/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.commitToBe.enums.TmcAppEnum;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.errorcode.ReceivErrorCode;
import kd.fi.cas.business.helper.ManualMatchHelper;
import kd.fi.cas.business.helper.RecDraftHelper;
import kd.fi.cas.business.paywarning.RecWarningHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.OperateTypeEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.RecTypeEnum;
import kd.fi.cas.formplugin.helper.InitCheckPluginHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CasPluginHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.log.RefundLogExecutor;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingBillList
extends AbstractListPlugin {
    private static final String KEY_CALLBACK_RECCHARGEBACK = "CALLBACK_RECCHARGEBACK";
    private static final String CONFIRM_DEL_CALLBACK = "CONFIRM_DEL_CALLBACK";
    private static final String CONFIRM_DELETE_CALLBACK = "CONFIRM_DELETE_CALLBACK";
    private static final String KEY_CLOSECALLBACK_CHARGEBACK = "CALLBACK_SELECTDRAFT";
    private FilterContainerInitArgs initArgs;
    private static final String BAR_BATCH_INPUT = "batchinput";
    private RefundLogExecutor refundLogExecutor;
    List<String> INTEGRATE_VALIDATE_KEYS = Arrays.asList("tblrecchg", "cancelrec", "baritemap2", "deletevoucher", "previewvoucher", "returnmoney", "refund", "cancelrefund", "cancelmark");

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object isFromDraftBill = listShowParameter.getCustomParams().getOrDefault("isFromDraftBill", null);
        if (null == this.getCachedOrgList()) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                List defaultValues;
                if (!"org.id".equals(filterColumn.getFieldName()) || null == (defaultValues = filterColumn.getDefaultValues()) || defaultValues.size() <= 0) continue;
                List<Long> selectedOrgIdList = defaultValues.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.toString())).map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
                this.cacheSelectedOrgIdList(selectedOrgIdList);
            }
        }
        if (CasPluginHelper.isTrack((FormShowParameter)this.getView().getFormShowParameter())) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if ("org.id".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValue("");
                    continue;
                }
                if ("billstatus".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValues(new Object[]{""});
                    continue;
                }
                if (!"bizdate".equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("");
            }
        }
        if (EmptyUtil.isNoEmpty(isFromDraftBill) && isFromDraftBill.toString().trim().equals("Y")) {
            CasPluginHelper.getCasQFilter((ListShowParameter)listShowParameter, (FilterContainerInitArgs)args);
        }
        this.fillToolBar();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List<Object> cachedOrgList;
        super.filterContainerSearchClick(args);
        List selectedOrgIdList = args.getSelectMainOrgIds();
        if (!(selectedOrgIdList.size() <= 0 || null != (cachedOrgList = this.getCachedOrgList()) && cachedOrgList.toString().equals(selectedOrgIdList.toString()))) {
            this.cacheSelectedOrgIdList(selectedOrgIdList);
            this.filterContainerInit(this.initArgs);
        }
    }

    private void cacheSelectedOrgIdList(List<Long> selectedOrgIdList) {
        if (selectedOrgIdList != null) {
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(selectedOrgIdList));
        } else {
            this.getPageCache().put("selectedOrgIdList", null);
        }
    }

    protected List<Object> getCachedOrgList() {
        if (this.getPageCache().get("selectedOrgIdList") != null) {
            return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
        }
        return null;
    }

    private void fillToolBar() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"recbook"});
        List<Object> tempList = this.getCachedOrgList();
        if (tempList == null || tempList.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"recbook"});
            return;
        }
        List cachedOrgList = this.getCachedOrgList().stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
        for (Long orgId : cachedOrgList) {
            boolean isdraft = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"isdraft");
            boolean ischeck = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ischeck");
            boolean ispromissorynote = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ispromissorynote");
            if (!isdraft && !ischeck && !ispromissorynote) continue;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"recbook"});
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "salesrec": {
                this.addNew(RecTypeEnum.SalesRec);
                break;
            }
            case "otherrec": {
                this.addNew(RecTypeEnum.OtherRec);
                break;
            }
            case "transcompany": {
                this.transCompany(evt);
                break;
            }
            case "tbloffset": {
                this.offset();
                break;
            }
            case "viewarsettle": {
                CasPluginHelper.viewSettleForRec((BillList)((BillList)this.getControl("billlistap")), (IFormView)this.getView());
                break;
            }
            case "cancelrec": {
                this.cancelrec();
                break;
            }
            case "viewdrafbill": {
                CasPluginHelper.viewDrafBill((BillList)((BillList)this.getControl("billlistap")), (IFormView)this.getView(), (String)"cas_recbill");
            }
        }
    }

    private void beforeSubmit() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > 0) {
            ArrayList rowIds = new ArrayList(selectedRows.size());
            selectedRows.forEach(row -> rowIds.add(row.getPrimaryKeyValue()));
            List resultList = RecWarningHelper.getResultByPkIds(rowIds);
            if (resultList != null && resultList.size() > 0) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("cas_recwarnmsg");
                parameter.setStatus(OperationStatus.VIEW);
                parameter.setCustomParam("sumAll", (Object)selectedRows.size());
                parameter.setCustomParam("sumWarn", (Object)resultList.size());
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "beforeSubmit"));
                this.getView().showForm(parameter);
            } else {
                this.getView().invokeOperation("submit");
            }
        }
    }

    private void suppleContractOrOrgsDivide(String opName) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)selectedRows) != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"ReceivingBillList_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow currentSelectedRowInfo = selectedRows.get(0);
        String billStatus = currentSelectedRowInfo.getBillStatus();
        if (!"D".equals(billStatus)) {
            if ("supplecontract".equals(opName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b26\u5408\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ReceivingBillList_26", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if ("orgsdivide".equals(opName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u6536\u6b3e\uff0c\u624d\u80fd\u64cd\u4f5c\u7ec4\u7ec7\u95f4\u6e05\u5206\u3002", (String)"ReceivingBillList_35", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject recbillDO = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"cas_recbill", (String)"receivingtype,settletype,actrecamt");
        DynamicObject receivingtype = recbillDO.getDynamicObject("receivingtype");
        boolean ispartreceivable = false;
        if (CasHelper.isNotEmpty((Object)receivingtype)) {
            ispartreceivable = receivingtype.getBoolean("ispartreceivable");
        }
        if (!ispartreceivable) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u6536\u6b3e\u7c7b\u578b\u672a\u53c2\u4e0e\u5e94\u6536\u7ed3\u7b97\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ReceivingBillList_27", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BigDecimal.ZERO.compareTo(recbillDO.getBigDecimal("actrecamt")) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u6536\u6b3e\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ReceivingBillList_32", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setCustomParam("supcontractOrOrgsdivide", (Object)opName);
        showParameter.setPkId(primaryKeyValue);
        showParameter.setFormId("cas_recbill_supdevide");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6536\u6b3e\u5355", (String)"ReceivingBillList_28", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object draftIdList;
        HashMap returnData;
        super.closedCallBack(e);
        if ("listoperation".equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
        } else if ("refund".equals(e.getActionId())) {
            ((ListView)this.getView()).refresh();
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"beforeSubmit")) {
            Object returnData2 = e.getReturnData();
            if (returnData2 != null) {
                if (((Boolean)returnData2).booleanValue()) {
                    this.getView().invokeOperation("submit");
                } else {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("isTrue", String.valueOf(returnData2));
                    this.getView().invokeOperation("warnsubmit", option);
                    this.getView().invokeOperation("refresh");
                }
            } else {
                this.getView().invokeOperation("warnsubmit");
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)KEY_CALLBACK_RECCHARGEBACK)) {
            Map data = (Map)e.getReturnData();
            if (null != data) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("billid", String.valueOf(data.get("billid")));
                option.setVariableValue("reason", String.valueOf(data.get("reason")));
                option.setVariableValue("entityname", "cas_recbill");
                OperationResult recchargebackwrite = this.getView().invokeOperation("recchargebackwrite", option);
                if (recchargebackwrite.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u5355\u6210\u529f\u3002", (String)"ReceivingBillList_29", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                }
            }
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)KEY_CLOSECALLBACK_CHARGEBACK) && null != (returnData = (HashMap)e.getReturnData()) && (draftIdList = returnData.get("draftBillIdList")) != null) {
            HashSet<Long> recBillSet = new HashSet<Long>(16);
            JSONArray recBillIdJsonArr = (JSONArray)returnData.get("recBillId");
            for (Object ob : recBillIdJsonArr) {
                recBillSet.add(Long.parseLong(ob.toString()));
            }
            this.displayDraftInfo(draftIdList, recBillSet);
            OperateOption option = OperateOption.create();
            option.setVariableValue("draftids", JSON.toJSONString(draftIdList));
            option.setVariableValue("selectdraft", "true");
            if (recBillSet.size() > 1) {
                option.setVariableValue("batchselect", JSONArray.toJSONString(recBillSet));
            }
            try {
                boolean success;
                OperationResult operationResult = this.getView().invokeOperation("receivingrec", option);
                if (null != operationResult && !(success = operationResult.isSuccess())) {
                    this.deleteDraftInfo(draftIdList, recBillSet);
                }
            }
            catch (Exception e1) {
                this.deleteDraftInfo(draftIdList, recBillSet);
                throw e1;
            }
        }
    }

    private void displayDraftInfo(Object draftIdList, Set<Long> recBillSet) {
        if (EmptyUtil.isEmpty((Object)draftIdList) && (EmptyUtil.isEmpty(recBillSet) || recBillSet.size() == 0)) {
            return;
        }
        Object[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,actrecamt,cas_draftinfo,cas_draftinfo.draftbillinfo,cas_draftinfo.recbillcurrency,cas_draftinfo.transamount,cas_draftinfo.draftbilllogid,cas_draftinfo.srcbilltype,cas_draftinfo.srcbillindex", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillSet)});
        if (!EmptyUtil.isEmpty((Object[])recBills)) {
            List draftIds = (List)draftIdList;
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((Object[])draftIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
            int recBillCount = recBillSet.size();
            if (recBillCount > 1) {
                for (Object recBill : recBills) {
                    DynamicObjectCollection draftInfoEntrys = recBill.getDynamicObjectCollection("cas_draftinfo");
                    DynamicObject newEntry = draftInfoEntrys.addNew();
                    newEntry.set("draftbillinfo", (Object)draftBills[0].getLong("id"));
                    newEntry.set("recbillcurrency", (Object)draftBills[0].getDynamicObject("currency").getLong("id"));
                    newEntry.set("transamount", (Object)recBill.getBigDecimal("actrecamt"));
                    newEntry.set("draftbilllogid", (Object)0);
                    newEntry.set("srcbilltype", (Object)"cas_recbill");
                    newEntry.set("srcbillindex", (Object)1);
                }
            } else {
                DynamicObjectCollection draftInfoEntrys = recBills[0].getDynamicObjectCollection("cas_draftinfo");
                DynamicObject newEntry = draftInfoEntrys.addNew();
                for (int i = 0; i < draftBills.length; ++i) {
                    newEntry.set("draftbillinfo", (Object)draftBills[i].getLong("id"));
                    newEntry.set("recbillcurrency", (Object)draftBills[i].getDynamicObject("currency").getLong("id"));
                    newEntry.set("transamount", (Object)draftBills[i].getBigDecimal("availableamount"));
                    newEntry.set("draftbilllogid", (Object)0);
                    newEntry.set("srcbilltype", (Object)"cas_recbill");
                    newEntry.set("srcbillindex", (Object)1);
                }
            }
            SaveServiceHelper.save((DynamicObject[])recBills);
        }
    }

    private void deleteDraftInfo(Object draftIdList, Set<Long> recBillSet) {
        if (EmptyUtil.isEmpty((Object)draftIdList) && (EmptyUtil.isEmpty(recBillSet) || recBillSet.size() == 0)) {
            return;
        }
        Object[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,actrecamt,cas_draftinfo,cas_draftinfo.draftbillinfo,cas_draftinfo.recbillcurrency,cas_draftinfo.transamount,cas_draftinfo.draftbilllogid,cas_draftinfo.srcbilltype,cas_draftinfo.srcbillindex", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillSet)});
        if (!EmptyUtil.isEmpty((Object[])recBills)) {
            List draftIds = (List)draftIdList;
            int recBillCount = recBillSet.size();
            if (recBillCount > 1) {
                for (Object recBill : recBills) {
                    DynamicObjectCollection draftInfoEntrys = recBill.getDynamicObjectCollection("cas_draftinfo");
                    draftInfoEntrys.removeIf(e -> null != e.getDynamicObject("draftbillinfo") && draftIds.contains(e.getDynamicObject("draftbillinfo").getPkValue()));
                }
            } else {
                DynamicObjectCollection draftInfoEntrys = recBills[0].getDynamicObjectCollection("cas_draftinfo");
                draftInfoEntrys.removeIf(e -> null != e.getDynamicObject("draftbillinfo") && draftIds.contains(e.getDynamicObject("draftbillinfo").getPkValue()));
            }
            SaveServiceHelper.save((DynamicObject[])recBills);
        }
    }

    private void offset() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows != null) {
            Object[] pks = selectedRows.getPrimaryKeyValues();
            if (pks.length <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"ReceivingBillList_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (pks.length > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ReceivingBillList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                this.getPageCache().put("operate", OperateTypeEnum.OFFSET.name());
                this.getView().invokeOperation("copy");
                this.getPageCache().remove("operate");
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"ReceivingBillList_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private void transCompany(ItemClickEvent evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)selectedRows) != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u6307\u5b9a\u5b9e\u9645\u6536\u6b3e\u516c\u53f8\u64cd\u4f5c\u3002", (String)"ReceivingBillList_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        List orgList = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_recbill", (String)"4715a0df000000ac");
        if (orgList == null || orgList.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ec4\u7ec7\u7684\u6307\u5b9a\u5b9e\u6536\u516c\u53f8\u6743\u9650\u3002", (String)"ReceivingBillList_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (selectedMainOrgIds != null && selectedMainOrgIds.size() > 0 && !orgList.contains(selectedMainOrgIds.get(0))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ec4\u7ec7\u7684\u6307\u5b9a\u5b9e\u6536\u516c\u53f8\u6743\u9650\u3002", (String)"ReceivingBillList_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow selectedRow = selectedRows.get(0);
        Long receivingId = (Long)selectedRow.getPrimaryKeyValue();
        if (this.check(receivingId, evt)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cas_rec_transcompany");
            showParameter.setCustomParam("receId", (Object)receivingId);
            showParameter.getOpenStyle().setShowType(ShowType.NonModal);
            this.getView().showForm(showParameter);
        }
    }

    private boolean check(Long receivingId, ItemClickEvent evt) {
        DynamicObject receivable = BusinessDataServiceHelper.loadSingle((Object)receivingId, (String)"cas_recbill", (String)"billno,billstatus,isagent");
        if ("D".equals(receivable.getString("billstatus"))) {
            this.getView().showErrorNotification(receivable.getString("billno") + new ReceivErrorCode().STATUS_TRANS_COMPANY().getMessage());
            return false;
        }
        if (!receivable.getBoolean("isagent")) {
            this.getView().showErrorNotification(receivable.getString("billno") + new ReceivErrorCode().STATUS_RECE_TYPE().getMessage());
            return false;
        }
        return true;
    }

    private void addNew(RecTypeEnum typeEnum) {
        this.getPageCache().put("recmentType", typeEnum.name());
        this.getView().invokeOperation("new");
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        FormShowParameter formShowParameter = new FormShowParameter();
        BillOperationStatus billStatus = parameter.getBillStatus();
        Long billId = (Long)parameter.getPkId();
        if (billId != null) {
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"cas_recbill", (String)"id, billstatus,biztype");
            if (parameter.getStatus() == OperationStatus.ADDNEW && billId != null) {
                String operateType = this.getPageCache().get("operate");
                BillShowParameter showParameter = e.getParameter();
                if (operateType != null) {
                    showParameter.getCustomParams().put("operate", operateType);
                } else {
                    showParameter.getCustomParams().put("operate", OperateTypeEnum.COPY);
                }
            }
            if (info.getString("biztype").equals(RecTypeEnum.OtherRec.toString())) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u5176\u4ed6\u6536\u6b3e\u5355", (String)"ReceivingBillList_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                formShowParameter.getCustomParams().put("recmentType", RecTypeEnum.OtherRec);
                parameter.setCaption(ResManager.loadKDString((String)"\u5176\u4ed6\u6536\u6b3e\u5355", (String)"ReceivingBillList_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                parameter.getCustomParams().put("recmentType", RecTypeEnum.OtherRec);
            } else {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u9500\u552e\u6536\u6b3e\u5355", (String)"ReceivingBillList_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                formShowParameter.getCustomParams().put("recmentType", RecTypeEnum.SalesRec);
                parameter.setCaption(ResManager.loadKDString((String)"\u9500\u552e\u6536\u6b3e\u5355", (String)"ReceivingBillList_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                parameter.getCustomParams().put("recmentType", RecTypeEnum.SalesRec);
            }
        } else if (BillOperationStatus.ADDNEW == billStatus) {
            parameter.getCustomParams().put("recmentType", this.getPageCache().get("recmentType"));
            this.getView().showForm((FormShowParameter)parameter);
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("EntityName", parameter.getFormId());
        if (OperationStatus.ADDNEW.equals((Object)e.getParameter().getStatus())) {
            this.getView().showForm((FormShowParameter)parameter);
            return;
        }
        customParam.put("PkId", parameter.getPkId());
        formShowParameter.setCustomParams(customParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if ("beforesubmit".equals(opKey)) {
            this.beforeSubmit();
        }
        if ("cancelrefund".equals(opKey)) {
            if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)selectedRows) > 1) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u7b14\u6536\u6b3e\u5355\u8fdb\u884c\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"ReceivingBillList_10_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            Long revId = (Long)selectedRows.get(0).getPrimaryKeyValue();
            operate.getOption().setVariableValue("revId", String.valueOf(revId));
            this.refundLogExecutor = new RefundLogExecutor(revId);
        }
        if ("refund".equals(opKey)) {
            if (selectedRows.size() == 0) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceivingBillList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)selectedRows) > 1) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ReceivingBillList_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (!RefundHelper.isPaid((Long)((Long)selectedRows.get(0).getPrimaryKeyValue()))) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u6536\u6b3e\u72b6\u6001\u7684\u5355\u636e\u624d\u53ef\u4ee5\u9000\u7968\u3002", (String)"ReceivingBillList_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (RefundHelper.isRefund((Long)((Long)selectedRows.get(0).getPrimaryKeyValue()))) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u9000\u7968\u7684\u6536\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u9000\u7968\u3002", (String)"ReceivingBillList_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            boolean isSettleCenterCollect = QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("id", "=", selectedRows.get(0).getPrimaryKeyValue()), new QFilter("receivingtype.biztype", "=", (Object)PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue())});
            if (!(isSettleCenterCollect && RefundHelper.isExistTransHandleBillsRefund((long)((Long)selectedRows.get(0).getPrimaryKeyValue())) || !isSettleCenterCollect && RefundHelper.isExistPayBills((Long)((Long)selectedRows.get(0).getPrimaryKeyValue())))) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6536\u6b3e\u5355\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9000\u6b3e\u6e90\u5355\uff0c\u786e\u8ba4\u9000\u7968\u5931\u8d25\u3002", (String)"ReceivingBillList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            Set srcBill = CasBotpHelper.getSrcBillByDestBill((Long)((Long)selectedRows.get(0).getPrimaryKeyValue()), (String)"cas_recbill", (String)"cas_paybill");
            if (!CasHelper.isEmpty((Object)srcBill)) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6536\u6b3e\u5355\u5df2\u5173\u8054\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u9000\u7968\u3002", (String)"ReceivingBillList_17", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (RefundHelper.isSettled((Long)((Long)selectedRows.get(0).getPrimaryKeyValue()))) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ed3\u7b97\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u9000\u7968\uff0c\u8bf7\u5148\u624b\u5de5\u53d6\u6d88\u7ed3\u7b97\u3002", (String)"ReceivingBillList_33", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if ("returnmoney".equals(opKey)) {
            boolean isSettleCenterCollect = QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("id", "=", selectedRows.get(0).getPrimaryKeyValue()), new QFilter("receivingtype.biztype", "=", (Object)PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue())});
            if (selectedRows.size() == 0) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceivingBillList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)selectedRows) > 1) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ReceivingBillList_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (!RefundHelper.isPaid((Long)((Long)selectedRows.get(0).getPrimaryKeyValue()))) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u6536\u6b3e\u72b6\u6001\u7684\u5355\u636e\u624d\u53ef\u4ee5\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c\u3002", (String)"ReceivingBillList_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (RefundHelper.isRefund((Long)((Long)selectedRows.get(0).getPrimaryKeyValue()))) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u9000\u6b3e\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u91cd\u590d\u9000\u6b3e\u3002", (String)"ReceivingBillList_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (!(isSettleCenterCollect && RefundHelper.isExistTransHandleBillsRefundMoney((long)((Long)selectedRows.get(0).getPrimaryKeyValue())) || !isSettleCenterCollect && RefundHelper.isExistPayBillsRefund((Long)((Long)selectedRows.get(0).getPrimaryKeyValue())))) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6536\u6b3e\u5355\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9000\u6b3e\u6e90\u5355\uff0c\u9000\u6b3e\u5931\u8d25\u3002", (String)"ReceivingBillList_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            Set srcBill = CasBotpHelper.getSrcBillByDestBill((Long)((Long)selectedRows.get(0).getPrimaryKeyValue()), (String)"cas_recbill", (String)"cas_paybill");
            if (!CasHelper.isEmpty((Object)srcBill)) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6536\u6b3e\u5355\u5df2\u5173\u8054\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u9000\u6b3e\u3002", (String)"ReceivingBillList_18_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (RefundHelper.isSettled((Long)((Long)selectedRows.get(0).getPrimaryKeyValue()))) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ed3\u7b97\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u9000\u6b3e\uff0c\u8bf7\u5148\u624b\u5de5\u53d6\u6d88\u7ed3\u7b97\u3002", (String)"ReceivingBillList_34", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if ("recbook".equals(opKey)) {
            Long id = (Long)selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_recbill");
            DynamicObjectCollection draftBillCol = (DynamicObjectCollection)dynamicObject.get("draftbill");
            if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)selectedRows) > 1) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ReceivingBillList_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (!this.checkStatus(id, "billstatus").booleanValue()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u6536\u7968\u767b\u8bb0\u3002", (String)"PaymentBillDraftEditPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!InitCheckPluginHelper.checkInitForPlugin(this.getView(), dynamicObject.getDynamicObject("org"), new String[0])) {
                args.setCancel(true);
                return;
            }
            if (!DraftHelper.isDraftBill((Long)id, (String)"cas_recbill")) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0\u4ec5\u9002\u7528\u4e8e\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u627f\u5151\u6c47\u7968\u3001\u652f\u7968\u6216\u672c\u7968\u7684\u6536\u6b3e\u5355\u3002\u5f53\u524d\u6240\u9009\u5355\u636e\u4e0d\u652f\u6301\u6536\u7968\u767b\u8bb0\u3002", (String)"ReceivingBillEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (!DraftHelper.isParameterDraftOn((Long)id, (String)"cas_recbill")) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u914d\u7f6e\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u3002", (String)"PaymentBillDraftEditPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftBillCol)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u9009\u62e9\u76f8\u5173\u5e94\u6536\u7968\u636e\uff0c\u4e0d\u80fd\u518d\u6b21\u6536\u7968\u767b\u8bb0\uff0c\u8bf7\u786e\u8ba4\u6536\u6b3e", (String)"ReceivingBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObject recBill;
                DynamicObject accountBank;
                Boolean isPush = CasBotpHelper.isFindTargetBill((String)"cas_recbill", (String)"cdm_receivablebill", (Long[])new Long[]{id});
                if (isPush.booleanValue()) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u8fdb\u884c\u6536\u7968\u767b\u8bb0\u3002", (String)"ReceivingBillEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                if (null != (accountBank = (recBill = BusinessDataServiceHelper.loadSingle((String)"cas_recbill", (String)"accountbank", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})).getDynamicObject("accountbank")) && AccountBankHelper.isClosed((long)accountBank.getLong("id"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), accountBank.getString("number")));
                }
            }
        } else if ("chargeback".equals(opKey)) {
            if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)selectedRows) > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9000\u5355\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"PaymentBillList_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.cancel = true;
            }
        } else if ("matchdetail".equals(opKey)) {
            ManualMatchHelper.verifySameOrg((ListSelectedRowCollection)selectedRows, (String)"cas_recbill", (IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
        } else if ("receivingrec".equals(opKey)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object[] selectedRowPks = list.getSelectedRows().getPrimaryKeyValues();
            RecDraftHelper.fillDraft((Object[])selectedRowPks, (boolean)true);
            if (selectedRowPks.length > 0) {
                DynamicObject[] dbDatas = BusinessDataServiceHelper.load((Object[])selectedRowPks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"));
                String draftIds = operate.getOption().getVariableValue("draftids", "");
                int recCount = selectedRowPks.length;
                if (StringUtils.isEmpty((CharSequence)draftIds)) {
                    if (recCount == 1) {
                        DynamicObject dbData = dbDatas[0];
                        String billstatus = dbData.getString("billstatus");
                        if (!"C".equals(billstatus)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6536\u6b3e\u5355\u624d\u80fd\u8fdb\u884c\u6536\u6b3e\u3002", (String)"PaymentBillList_7_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                        String sourceBillType = (String)dbData.get("sourcebilltype");
                        if ("cas_claimcenterbill".equals(sourceBillType)) {
                            return;
                        }
                        DynamicObject orgData = (DynamicObject)dbData.get("org");
                        Long pkValue = (Long)orgData.getPkValue();
                        boolean selectDraftFlag = SystemParameterHelper.getParameterBoolean((long)pkValue, (String)"cs123");
                        if (selectDraftFlag && PaymentBillPluginHelper.needSelectedDraft((DynamicObject)dbData)) {
                            HashSet<Long> recBillIdSet = new HashSet<Long>(1);
                            recBillIdSet.add(dbData.getLong("id"));
                            this.callSelectForm(recBillIdSet);
                            args.setCancel(true);
                        }
                    } else {
                        HashSet<Long> recSelectDraftProcessDySet = new HashSet<Long>(16);
                        boolean isNeedCancel = CasPluginHelper.batchDealRec(recSelectDraftProcessDySet, (DynamicObject[])dbDatas);
                        if (isNeedCancel) {
                            recSelectDraftProcessDySet.clear();
                        } else if (EmptyUtil.isNoEmpty(recSelectDraftProcessDySet) && recSelectDraftProcessDySet.size() > 0) {
                            this.callSelectForm(recSelectDraftProcessDySet);
                            args.setCancel(true);
                        }
                    }
                }
            }
        }
    }

    private void callSelectForm(Set<Long> recSelectDraftProcessDySet) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId("cas");
        showParameter.setFormId("cas_receiver_selectdraft");
        showParameter.setCustomParam("recBillId", recSelectDraftProcessDySet);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CLOSECALLBACK_CHARGEBACK));
        this.getView().showForm(showParameter);
    }

    private Boolean checkStatus(Long id, String field) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "=", (Object)id));
        qFilters.add(new QFilter(field, "=", (Object)BillStatusEnum.AUDIT.getValue()));
        return QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isSuccess;
        super.afterDoOperation(e);
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        boolean bl = isSuccess = e.getOperationResult() == null ? false : e.getOperationResult().isSuccess();
        if ("cancelrefund".equals(e.getOperateKey()) && this.refundLogExecutor != null) {
            this.refundLogExecutor.saveLog(e.getOperationResult());
        }
        if ("receivingrec".equals(e.getOperateKey()) && isSuccess) {
            this.showRecTip();
            this.getView().invokeOperation("refresh");
        } else if (("cancelrec".equals(e.getOperateKey()) || "cancelrefund".equals(e.getOperateKey())) && isSuccess) {
            this.getView().invokeOperation("refresh");
        } else if ("transcompany".equals(e.getOperateKey()) && isSuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u5b9e\u9645\u516c\u53f8\u6210\u529f\u3002", (String)"ReceivingBillList_19", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else if ("refund".equals(e.getOperateKey()) && isSuccess) {
            this.refund("refund");
        } else if ("returnmoney".equals(e.getOperateKey()) && isSuccess) {
            this.refund("returnmoney");
        } else if ("supplecontract".equals(e.getOperateKey()) && isSuccess) {
            this.suppleContractOrOrgsDivide("supplecontract");
        } else if ("orgsdivide".equals(e.getOperateKey()) && isSuccess) {
            this.suppleContractOrOrgsDivide("orgsdivide");
        } else if ("chargeback".equals(e.getOperateKey()) && isSuccess) {
            if (null != selectedRows && selectedRows.size() > 0) {
                CasPluginHelper.chargeBack((IFormPlugin)this, (IFormView)this.getView(), (Object)selectedRows.get(0).getPrimaryKeyValue(), (String)KEY_CALLBACK_RECCHARGEBACK);
            }
        } else if ("warnsubmit".equals(e.getOperateKey()) && isSuccess) {
            e.getOperationResult().setShowMessage(false);
        } else if ("matchdetail".equals(e.getOperateKey())) {
            ManualMatchHelper.bizBillMatchDetail((IFormView)this.getView(), (AfterDoOperationEventArgs)e, (ListSelectedRowCollection)selectedRows, (IFormPlugin)this, (String)list.getEntityId(), (String)"org,accountbank,currency");
        } else if (Arrays.asList("marknoneedmatch", "cancelmark", "cancelmatch").contains(e.getOperateKey()) && isSuccess) {
            this.getView().invokeOperation("refresh");
        } else if (BAR_BATCH_INPUT.equals(e.getOperateKey())) {
            CasPluginHelper.viewBatchInput((IFormView)this.getView(), (String)"cas_batchrecbill");
        }
    }

    private void showRecTip() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows.size() > 0) {
            LinkedList<Long> paymentBillPks = new LinkedList<Long>();
            for (ListSelectedRow selectedRow : selectedRows) {
                paymentBillPks.add((Long)selectedRow.getPrimaryKeyValue());
            }
            AppParam appParam = new AppParam();
            appParam.setAppId(TmcAppEnum.CAS.getId());
            QFilter payPidFilter = new QFilter("id", "in", paymentBillPks);
            DynamicObject[] recObjs = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,payer,billno,payertype,bizdate", (QFilter[])new QFilter[]{payPidFilter});
            List orgIds = Arrays.stream(recObjs).map(o -> o.getLong("payer")).collect(Collectors.toList());
            Set<Long> payerIsSupplierIds = this.getNeedQueryPayerId(recObjs, AsstActTypeEnum.SUPPLIER.getValue());
            Set<Long> payerIsCustomerIds = this.getNeedQueryPayerId(recObjs, AsstActTypeEnum.CUSTOMER.getValue());
            Map supplierMap = CasPluginHelper.getInternalCompanyMap((String)AsstActTypeEnum.SUPPLIER.getValue(), payerIsSupplierIds);
            Map customerMap = CasPluginHelper.getInternalCompanyMap((String)AsstActTypeEnum.CUSTOMER.getValue(), payerIsCustomerIds);
            HashSet<Object> orgIdSet = new HashSet<Object>(10);
            for (Map.Entry entry : supplierMap.entrySet()) {
                orgIdSet.add(entry.getValue());
            }
            for (Map.Entry entry : customerMap.entrySet()) {
                orgIdSet.add(entry.getValue());
            }
            orgIdSet.addAll(orgIds);
            Map stringMapMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, new ArrayList(orgIdSet));
            StringBuilder sb = new StringBuilder();
            for (DynamicObject recBill : recObjs) {
                boolean allow;
                boolean isCheck;
                Map sysParams;
                Long internalCompany;
                Long payer = recBill.getLong("payer");
                String payerType = recBill.getString("payertype");
                if (AsstActTypeEnum.SUPPLIER.getValue().equals(payerType)) {
                    internalCompany = (Long)supplierMap.get(payer);
                    if (CasHelper.isEmpty((Object)internalCompany)) continue;
                    payer = internalCompany;
                } else if (AsstActTypeEnum.CUSTOMER.getValue().equals(payerType)) {
                    internalCompany = (Long)customerMap.get(payer);
                    if (CasHelper.isEmpty((Object)internalCompany)) continue;
                    payer = internalCompany;
                } else if (!AsstActTypeEnum.COMPANY.getValue().equals(payerType)) continue;
                if (EmptyUtil.isNoEmpty((Long)payer)) {
                    Date bizDate = recBill.getDate("bizdate");
                    DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)payer);
                    if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((DynamicObject)currentPeriod) && !bizDate.before(currentPeriod.getDate("begindate"))) continue;
                }
                if (!EmptyUtil.isNoEmpty((Object)(sysParams = (Map)stringMapMap.get(String.valueOf(payer))))) continue;
                Object CS048 = sysParams.get("cs048");
                Object allowObj = sysParams.get("cs103");
                if (!EmptyUtil.isNoEmpty(CS048) || !(isCheck = ((Boolean)CS048).booleanValue()) || !EmptyUtil.isNoEmpty(allowObj) || (allow = ((Boolean)allowObj).booleanValue())) continue;
                String billNo = recBill.getString("billno");
                sb.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011\u786e\u8ba4\u6536\u6b3e\u6210\u529f\u3002\u56e0\u4ed8\u6b3e\u65b9\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u65b0\u589e\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u4ed8\u6b3e\u4e1a\u52a1\uff0c\u56e0\u6b64\u6536\u4ed8\u534f\u540c\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25\u3002\r\n", (String)"ReceivingBillList_36", (String)"fi-cas-formplugin", (Object[])new Object[0]), billNo));
            }
            if (EmptyUtil.isNotEmpty((CharSequence)sb)) {
                this.getView().showTipNotification(sb.toString());
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u6210\u529f\u3002", (String)"ReceivingBillEdit_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Set<Long> getNeedQueryPayerId(DynamicObject[] payobjs, String type) {
        HashSet<Long> payeeIds = new HashSet(2);
        payeeIds = Arrays.stream(payobjs).map(o -> {
            String payeeType = o.getString("payertype");
            if (type.equals(payeeType)) {
                return o.getLong("payer");
            }
            return 0L;
        }).collect(Collectors.toSet());
        return payeeIds;
    }

    private void refund(String operateKey) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ListSelectedRow selectedRow = selectedRows.get(0);
        DynamicObject revBill = BusinessDataServiceHelper.loadSingleFromCache((Object)selectedRow.getPrimaryKeyValue(), (String)"cas_recbill", (String)"receivingtype.biztype");
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("billId", selectedRow.getPrimaryKeyValue());
        if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(revBill.getString("receivingtype.biztype"))) {
            parameter.setFormId("cas_refund");
            parameter.setCustomParam("operateKey", (Object)("returnmoney".equals(operateKey) ? "returnmoney" : "refund"));
        } else {
            parameter.setFormId("cas_refund_renote");
            parameter.setCustomParam("operateKey", (Object)("returnmoney".equals(operateKey) ? "refund" : "renote"));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refund");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void cancelrec() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceivingBillList_21", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            LinkedList<Long> recBillPks = new LinkedList<Long>();
            for (ListSelectedRow selectedRow : selectedRows) {
                recBillPks.add((Long)selectedRow.getPrimaryKeyValue());
            }
            QFilter recPidFilter = new QFilter("id", "in", recBillPks);
            DynamicObjectCollection recobjs = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billno,isvoucher,org.id,receivingtype,receivingtype.enable", (QFilter[])new QFilter[]{recPidFilter});
            StringBuilder sb = new StringBuilder();
            int flag = 0;
            Map<Long, List<DynamicObject>> groupOrg = recobjs.stream().collect(Collectors.groupingBy(o -> o.getLong("org.id")));
            Set orgIds = recobjs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toSet());
            Map orgSysMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs116");
            for (Map.Entry<Long, List<DynamicObject>> entry : groupOrg.entrySet()) {
                int size;
                int CS114;
                Long orgId = entry.getKey();
                int n = CS114 = EmptyUtil.isEmpty(orgSysMap.get(String.valueOf(orgId))) ? 0 : Integer.parseInt((String)orgSysMap.get(String.valueOf(orgId)));
                if (3 != CS114) continue;
                List<DynamicObject> value = entry.getValue();
                Map<Long, String> idBillNoMap = value.stream().collect(Collectors.toMap(s -> s.getLong("id"), v -> v.getString("billno")));
                List existList = VoucherBookHelper.getVoucherExistIds(idBillNoMap.keySet(), (String)"cas_recbill");
                flag = size = existList.size();
                if (size <= 0) continue;
                for (Long id : existList) {
                    String billno = idBillNoMap.get(id);
                    sb.append(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\r\n", (String)"ReceivingBillList_22", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno));
                }
            }
            if (flag == 1) {
                this.getView().showConfirm(sb.substring(0, sb.length() - 1) + "\uff0c" + ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u6536\u6b3e\uff1f", (String)"ReceivingBillList_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELREC_CALLBACK", (IFormPlugin)this));
            } else if (flag > 0) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%d\u4e2a\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u6536\u6b3e\uff1f", (String)"ReceivingBillList_24", (String)"fi-cas-formplugin", (Object[])new Object[0]), flag), sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELREC_CALLBACK", (IFormPlugin)this));
            } else if (!CasPluginHelper.cancelCheckSettleForRec((IFormPlugin)this, (IFormView)this.getView(), recBillPks, (DynamicObjectCollection)recobjs).booleanValue()) {
                this.getView().invokeOperation("cancelrec");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CANCELREC_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() > 0) {
                LinkedList<Long> recBillPks = new LinkedList<Long>();
                for (ListSelectedRow selectedRow : selectedRows) {
                    recBillPks.add((Long)selectedRow.getPrimaryKeyValue());
                }
                QFilter recPidFilter = new QFilter("id", "in", recBillPks);
                DynamicObjectCollection recobjs = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billno,isvoucher", (QFilter[])new QFilter[]{recPidFilter});
                if (!CasPluginHelper.cancelCheckSettleForRec((IFormPlugin)this, (IFormView)this.getView(), recBillPks, (DynamicObjectCollection)recobjs).booleanValue()) {
                    this.getView().invokeOperation("cancelrec");
                }
            }
        } else if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CANCELPAY_SETTLE_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("cancelrec");
        } else if (id.equals(CONFIRM_DEL_CALLBACK)) {
            OperateOption option = OperateOption.create();
            if (MessageBoxResult.Yes.equals((Object)res)) {
                option.setVariableValue("delrecpay", "1");
                this.getView().invokeOperation("delete", option);
            }
        } else if (StringUtils.equals((CharSequence)id, (CharSequence)CONFIRM_DELETE_CALLBACK)) {
            if (MessageBoxResult.Yes.equals((Object)res)) {
                this.getView().invokeOperation("delete");
            }
        } else if ("CONFIRM_MANUALMATCH".equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            ManualMatchHelper.confirmBizBillMatchDetail((IFormView)this.getView(), (String)"org,accountbank,currency");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String opKey = evt.getOperationKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        String itemKey = evt.getItemKey();
        if (this.INTEGRATE_VALIDATE_KEYS.contains(opKey) || this.INTEGRATE_VALIDATE_KEYS.contains(itemKey)) {
            this.integrateValidate(evt, selectRows);
        }
        if ("delete".equals(opKey) && selectRows.size() > 0) {
            Object[] selectPks;
            DynamicObject[] recSelectObj;
            List<DynamicObject> virtRecList;
            HashSet selectRowsPks = new HashSet();
            selectRows.forEach(listSelectedRow -> selectRowsPks.add(listSelectedRow.getPrimaryKeyValue()));
            QFilter pkFilter = new QFilter("id", "in", selectRowsPks).and(new QFilter("hotaccount", "!=", (Object)"2"));
            QFilter sourceBillTypeFilter = new QFilter("sourcebilltype", "=", (Object)"cas_paybill");
            DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"billno", (QFilter[])new QFilter[]{pkFilter, sourceBillTypeFilter});
            if (payBills != null && payBills.length > 0) {
                evt.setCancel(true);
                StringBuilder billnos = new StringBuilder();
                Arrays.asList(payBills).forEach(payBill -> billnos.append(payBill.getString("billno")).append("\u3001"));
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u6536\u6b3e\u5355\u7531\u5185\u90e8\u6536\u4ed8\u534f\u540c\u4e1a\u52a1\u81ea\u52a8\u751f\u6210\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"ReceivingBillEdit_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), billnos.substring(0, billnos.length() - 1)), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_DEL_CALLBACK, (IFormPlugin)this));
            }
            if ((virtRecList = Arrays.stream(recSelectObj = BusinessDataServiceHelper.load((Object[])(selectPks = selectRows.getPrimaryKeyValues()), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_recbill"))).filter(o -> o.getBoolean("isvirtual") && !EmptyUtil.isEmpty((String)o.getString("sourcebilltype")) && "cas_recbill".equals(o.getString("sourcebilltype"))).collect(Collectors.toList())).size() > 0) {
                evt.setCancel(true);
                StringBuilder virtBillnos = new StringBuilder();
                virtRecList.forEach(rec -> virtBillnos.append(rec.getString("billno")).append("\u3001"));
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u865a\u62df\u6536\u6b3e\u5355\u7531\u7ec4\u7ec7\u95f4\u6e05\u5206\u4e1a\u52a1\u89e6\u53d1\u81ea\u52a8\u4e0b\u63a8\u7684\u5355\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ReceivingBillEdit_33", (String)"fi-cas-formplugin", (Object[])new Object[0]), virtBillnos.substring(0, virtBillnos.length() - 1)), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_DELETE_CALLBACK, (IFormPlugin)this));
            }
        }
    }

    private void integrateValidate(BeforeItemClickEvent evt, ListSelectedRowCollection selectRows) {
        if (EmptyUtil.isEmpty((Collection)selectRows)) {
            return;
        }
        Object[] primaryKeyValues = selectRows.getPrimaryKeyValues();
        QFilter historyFilter = new QFilter("id", "in", (Object)primaryKeyValues).and("ishistory", "=", (Object)"1");
        DynamicObjectCollection historyRecBills = QueryServiceHelper.query((String)"cas_recbill", (String)"billno", (QFilter[])historyFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)historyRecBills)) {
            String recBillNoStr = historyRecBills.stream().map(recBill -> recBill.getString("billno")).collect(Collectors.joining(","));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s \u4e3a\u5386\u53f2\u96c6\u6210\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c\u3002", (String)"ReceivingBillList_39", (String)"fi-cas-formplugin", (Object[])new Object[0]), recBillNoStr));
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("bizdate desc,org.id desc,id desc");
    }
}

