/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.UnreachParam;

public class UnreachBaseListDataRpt
extends AbstractReportListDataPlugin {
    protected String sourceEntity;

    public DataSet query(ReportQueryParam queryParam, Object po) throws Throwable {
        UnreachParam param = this.getUnreachParam(queryParam, po);
        if (param != null) {
            DataSet dataset = this.getRptListDataSet(param);
            return dataset;
        }
        return Algo.create((String)this.getAlgoKey("query")).createDataSet(new ArrayList(), this.getRowMeta());
    }

    protected UnreachParam getUnreachParam(ReportQueryParam queryParam, Object po) {
        FilterInfo filterInfo = queryParam.getFilter();
        UnreachParam param = new UnreachParam();
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("org");
        DynamicObjectCollection openOrgs = filterInfo.getDynamicObjectCollection("openorg");
        DynamicObjectCollection accbs = filterInfo.getDynamicObjectCollection("accountbank");
        DynamicObjectCollection currencys = filterInfo.getDynamicObjectCollection("currency");
        Date endDate = filterInfo.getDate("enddate");
        int aging = filterInfo.getInt("aging");
        String endDateType = filterInfo.getString("enddatetype");
        param.setEndDateType(endDateType);
        param.setOrgs(orgs);
        param.setOpenOrgs(openOrgs);
        param.setAccbs(accbs);
        param.setCurrencys(currencys);
        param.setEndDate(endDate);
        param.setAging(aging);
        String queryOrgType = filterInfo.getString("queryorgtype");
        param.setQueryOrgType(queryOrgType);
        return param;
    }

    protected DataSet getRptListDataSet(UnreachParam param) {
        QFilter[] qfilters = param.getQFilter();
        QFilter queryQFilter = this.getQueryQFilter(param);
        if (qfilters == null || qfilters.length == 0) {
            qfilters = new QFilter[]{queryQFilter};
        } else {
            qfilters[0].and(queryQFilter);
        }
        DataSet detailset = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getRptListDataSet"), (String)this.sourceEntity, (String)(this.getQueryFiled(param) + ",0 as rowtype"), (QFilter[])qfilters, null);
        detailset = detailset.orderBy(new String[]{"orgid", "bankaccountid", "currencyid"});
        GroupbyDataSet groupdataset = detailset.groupBy(new String[]{"orgid", "bankaccountid", "currencyid"}).sum("creditamount").sum("debitamount");
        DataSet sumset = groupdataset.finish();
        sumset = sumset.select(new String[]{"orgid", "bankaccountid", "currencyid", "debitamount", "creditamount"}).addNullField("orgname").addNullField("bankaccountname").addField("currencyid", "currencyname").addNullField("currencyname1").addField("'" + ResManager.loadKDString((String)"\u5408\u8ba1", (String)"UnreachBaseListDataRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]) + "'", "description").addNullField("bizdate").addNullField("settlementtype").addNullField("settlementnumber");
        sumset = this.addField(sumset).addField("1", "rowtype");
        DataSet totalSet = detailset.union(sumset).orderBy(new String[]{"orgid", "bankaccountid", "currencyid", "rowtype"});
        return totalSet;
    }

    protected RowMeta getRowMeta() {
        List<Field> field = this.getRowMetaField();
        return new RowMeta(field.toArray(new Field[0]));
    }

    protected List<Field> getRowMetaField() {
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("orgname", (DataType)DataType.StringType));
        field.add(new Field("bankaccountname", (DataType)DataType.StringType));
        field.add(new Field("currencyname", (DataType)DataType.LongType));
        field.add(new Field("description", (DataType)DataType.StringType));
        field.add(new Field("bizdate", (DataType)DataType.TimestampType));
        field.add(new Field("debitamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("creditamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("settlementtype", (DataType)DataType.StringType));
        field.add(new Field("settlementnumber", (DataType)DataType.StringType));
        return field;
    }

    protected String getQueryFiled(UnreachParam param) {
        String queryFields = "";
        queryFields = "cas_bankjournal".equals(this.sourceEntity) ? "org.id as orgid,openorg.id as openorgid,accountbank.id as bankaccountid,currency.id as currencyid,debitamount,creditamount,org.name as orgname,accountbank.bankaccountnumber as bankaccountname, currency.id as currencyname, currency.name as currencyname1, description,bizdate,settlementtype.name as settlementtype,settlementnumber" : "org.id as orgid,accountbank.id as bankaccountid,currency.id as currencyid,debitamount,creditamount,org.name as orgname,accountbank.bankaccountnumber as bankaccountname, currency.id as currencyname, currency.name as currencyname1, description,bizdate,settlementtype.name as settlementtype,settlementnumber";
        return queryFields;
    }

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    protected DataSet addField(DataSet sumset) {
        return sumset;
    }

    protected QFilter getQueryQFilter(UnreachParam param) {
        return null;
    }
}

