/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.agentpay;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.enums.FeePayerEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.AgentPayBillPluginHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.QuotationHelper;

public class AgentPayDiffCurrency
extends BillEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.fillDpCurrency();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFieldCaption();
        this.setRecExchangerateEditable();
        this.setExratetableVisibility();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "exratetable": 
            case "exratedate": {
                this.dpCurrencyF7Changed(newValue);
                this.setAgreedRate();
                break;
            }
            case "dpcurrency": {
                this.dpCurrencyF7Changed(newValue);
                this.setExratetableVisibility();
                this.setFeeCurrency();
                this.setAgreedRate();
                break;
            }
            case "basecurrency": {
                this.dpCurrencyF7Changed(newValue);
                this.setExratetableVisibility();
                break;
            }
            case "dpexchangerate": 
            case "dppayquotation": 
            case "agreedrate": 
            case "agreedquotation": {
                this.calculateDpAmt();
                break;
            }
            case "isdiffcur": {
                this.isDiffCurChanged(newValue);
                break;
            }
            case "feepayer": {
                this.feePayerChanged(newValue);
                break;
            }
            case "currency": {
                this.setAgreedRate();
                break;
            }
            case "dpamt": {
                this.dpAmtChanged(newValue);
            }
        }
    }

    private void isDiffCurChanged(Object newValue) {
        Boolean isDiffCur = (Boolean)newValue;
        if (!isDiffCur.booleanValue()) {
            if (!this.isBotpCreate()) {
                this.getModel().beginInit();
                this.getModel().setValue("exchangerate", this.getModel().getValue("dpexchangerate"));
                this.getModel().setValue("agreedrate", (Object)1);
                this.getModel().endInit();
                this.getView().updateView("exchangerate");
                this.getView().updateView("agreedrate");
                this.getModel().setValue("currency", this.getModel().getValue("dpcurrency"));
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("dpexchangerate", this.getModel().getValue("exchangerate"));
                this.getModel().setValue("agreedrate", (Object)1);
                this.getModel().endInit();
                this.getView().updateView("dpexchangerate");
                this.getView().updateView("agreedrate");
                this.getModel().setValue("dpcurrency", this.getModel().getValue("currency"));
            }
            this.setValue("contractno", null);
        } else {
            DynamicObject payerAcctBank = this.getDynamicObject("payeracctbank");
            if (payerAcctBank != null) {
                long defaultCurrencyId = payerAcctBank.getLong("defaultcurrency.id");
                this.setValue("dpcurrency", defaultCurrencyId);
            }
        }
        this.calculateDpAmt();
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"dpcurrency"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
        this.setCurrencyEditable(isDiffCur);
        this.initFieldCaption();
    }

    private void dpCurrencyF7Changed(Object newValue) {
        this.setRecExchangerateEditable();
    }

    private void calculateDpAmt() {
        DynamicObject dpcurrency = this.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        DynamicObject currency = this.getDynamicObject("currency");
        String dppayquotation = this.getString("dppayquotation");
        String agreedquotation = this.getString("agreedquotation");
        if (basecurrency == null) {
            return;
        }
        int round = basecurrency.getInt("amtprecision");
        int dppayround = 10;
        if (dpcurrency != null) {
            dppayround = dpcurrency.getInt("amtprecision");
        }
        BigDecimal payamount = this.getBigDecimal("payamount");
        if (currency != null) {
            payamount = payamount.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = this.getBigDecimal("localamt");
        BigDecimal agreedRate = this.getBigDecimal("agreedrate");
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        BigDecimal dpAmt = QuotationHelper.callToCurrency((BigDecimal)payamount, (BigDecimal)agreedRate, (String)agreedquotation, (int)dppayround);
        BigDecimal dpExchangeRate = this.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        this.getModel().beginInit();
        this.setValue("dpamt", dpAmt);
        this.setValue("dplocalamt", dpLocalAmt);
        this.setValue("lossamt", localAmt.subtract(dpLocalAmt));
        this.getModel().endInit();
        this.getView().updateView("dpamt");
        this.getView().updateView("dplocalamt");
        this.getView().updateView("lossamt");
        this.calculateEntryDpAmt();
    }

    private void dpAmtChanged(Object newValue) {
        BigDecimal dpAmt = (BigDecimal)newValue;
        BigDecimal dpExchangeRate = this.getBigDecimal("dpexchangerate");
        String dppayquotation = this.getString("dppayquotation");
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        if (basecurrency == null) {
            return;
        }
        int round = basecurrency.getInt("amtprecision");
        BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        BigDecimal localAmt = this.getBigDecimal("localamt");
        this.setValue("dplocalamt", dpLocalAmt);
        this.setValue("lossamt", localAmt.subtract(dpLocalAmt));
        BigDecimal payAmount = this.getBigDecimal("payamount");
        if (payAmount.compareTo(new BigDecimal(0)) == 0 || dpAmt.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        String agreedquotation = this.getString("agreedquotation");
        BigDecimal agreedRate = BigDecimal.ONE;
        agreedRate = "1".equals(agreedquotation) ? payAmount.divide(dpAmt, 10, RoundingMode.HALF_UP) : dpAmt.divide(payAmount, 10, RoundingMode.HALF_UP);
        this.getModel().beginInit();
        this.setValue("agreedrate", agreedRate);
        this.getModel().endInit();
        this.getView().updateView("agreedrate");
        this.calculateEntryDpAmt();
    }

    private void setRecExchangerateEditable() {
        DynamicObject srcCurrency = this.getDynamicObject("dpcurrency");
        DynamicObject destCurrency = this.getDynamicObject("basecurrency");
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"dpexchangerate"});
        }
    }

    private void setCurrencyEditable(Boolean isDiffCur) {
        Boolean isCurrencyEditable = Boolean.TRUE;
        DynamicObject settleType = this.getDynamicObject("settletype");
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        if (isCash) {
            DynamicObject accountCash = this.getDynamicObject("accountcash");
            if (accountCash != null) {
                isCurrencyEditable = !accountCash.getBoolean("isbycurrency");
            }
        } else {
            DynamicObject accountBank = this.getDynamicObject("payeracctbank");
            if (accountBank != null) {
                isCurrencyEditable = accountBank.getBoolean("ismulcurrency");
            }
        }
        if (isDiffCur.booleanValue()) {
            this.getView().setEnable(isCurrencyEditable, new String[]{"dpcurrency"});
        } else {
            this.getView().setEnable(isCurrencyEditable, new String[]{"currency"});
        }
        if (this.isBotpCreate()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        }
    }

    private void fillDpCurrency() {
        if (!this.isDelegAgent()) {
            BasedataEdit currencyF7 = (BasedataEdit)this.getControl("dpcurrency");
            currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)this.getDynamicObject("settletype"));
                Collection currencys = new ArrayList();
                if (isCash) {
                    Long accountId = this.getPk("accountcash");
                    if (accountId == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u73b0\u91d1\u8d26\u6237\u3002", (String)"AgentPayBillEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(true);
                        return;
                    }
                    currencys = AccountCashHelper.getCurrencys(Collections.singletonList(accountId));
                    if (!currencys.isEmpty()) {
                        filter = filter.and(new QFilter("id", "in", currencys));
                    }
                } else {
                    Long accountId = this.getPk("payeracctbank");
                    if (accountId == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"AgentPayBillEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(true);
                        return;
                    }
                    currencys = AccountBankHelper.getCurrencyPks((long)accountId);
                }
                if (!currencys.isEmpty()) {
                    filter = filter.and(new QFilter("id", "in", currencys));
                }
                showParameter.getListFilterParameter().setFilter(filter);
            });
        }
    }

    private void initFieldCaption() {
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (isDiffCur.booleanValue()) {
            ((FieldEdit)this.getControl("currency")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"PayBillDiffCurrency_1", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("exchangerate")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u6c47\u7387", (String)"PayBillDiffCurrency_2", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("payquotation")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u6c47\u7387\u6362\u7b97\u65b9\u5f0f", (String)"PayBillDiffCurrency_20", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("payamount")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"PayBillDiffCurrency_3", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("localamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u6298\u672c\u4f4d\u5e01", (String)"PayBillDiffCurrency_4", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dpcurrency")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd", (String)"PayBillDiffCurrency_5", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dpexchangerate")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6c47\u7387", (String)"PayBillDiffCurrency_6", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dppayquotation")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6c47\u7387\u6362\u7b97\u65b9\u5f0f", (String)"PayBillDiffCurrency_60", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dpamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"PayBillDiffCurrency_7", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dplocalamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u6298\u672c\u4f4d\u5e01", (String)"PayBillDiffCurrency_8", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        } else {
            ((FieldEdit)this.getControl("currency")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd", (String)"PayBillDiffCurrency_5", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("exchangerate")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6c47\u7387", (String)"PayBillDiffCurrency_6", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("payquotation")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6c47\u7387\u6362\u7b97\u65b9\u5f0f", (String)"PayBillDiffCurrency_60", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("payamount")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"PayBillDiffCurrency_7", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("localamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u6298\u672c\u4f4d\u5e01", (String)"PayBillDiffCurrency_8", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        }
    }

    private void setExratetableVisibility() {
        Long currencyId = this.getPk("currency");
        Long dpCurrencyId = this.getPk("dpcurrency");
        Long basecurrencyId = this.getPk("basecurrency");
        if (currencyId != null && !currencyId.equals(basecurrencyId) || dpCurrencyId != null && !dpCurrencyId.equals(basecurrencyId)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"exratetable"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"exratedate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exratetable"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exratedate"});
        }
    }

    private void feePayerChanged(Object newValue) {
        String feePayer = (String)newValue;
        this.getModel().beginInit();
        if (FeePayerEnum.REC.getValue().equals(feePayer)) {
            this.setValue("feeactbank", null);
            this.setValue("feecurrency", null);
        } else {
            this.setValue("feeactbank", this.getValue("payeracctbank"));
            this.setFeeCurrency();
        }
        this.getModel().endInit();
        this.getView().updateView("feeactbank");
        this.getView().updateView("feecurrency");
    }

    private void setFeeCurrency() {
        if (!FeePayerEnum.REC.getValue().equals(this.getString("feepayer"))) {
            Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
            if (isDiffCur.booleanValue()) {
                this.setValue("feecurrency", this.getValue("dpcurrency"));
            } else {
                this.setValue("feecurrency", this.getValue("currency"));
            }
        }
    }

    private boolean isBotpCreate() {
        String sourceBillType = this.getString("sourcebilltype");
        return !CasHelper.isEmpty((Object)sourceBillType);
    }

    private boolean isDelegAgent() {
        return this.getValue("delegorg") != null;
    }

    private void setAgreedRate() {
    }

    private void calculateEntryDpAmt() {
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (!isDiffCur.booleanValue()) {
            this.clearEntryField("e_dpamt", "e_dplocalamt");
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        for (DynamicObject row : entry) {
            int rowIdx = row.getInt("seq") - 1;
            BigDecimal amount = AgentPayBillPluginHelper.getEntryAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)row);
            if (amount != null && amount.compareTo(new BigDecimal(0)) > 0) {
                rowIndexs.add(rowIdx);
                continue;
            }
            this.setValue("e_dpamt", null, rowIdx);
            this.setValue("e_dplocalamt", null, rowIdx);
        }
        int size = rowIndexs.size();
        if (size <= 0) {
            return;
        }
        BigDecimal dpamt = this.getBigDecimal("dpamt");
        BigDecimal dplocalamt = this.getBigDecimal("dplocalamt");
        BigDecimal dpexchangerate = this.getBigDecimal("dpexchangerate");
        BigDecimal agreedrate = this.getBigDecimal("agreedrate");
        DynamicObject dpcurrency = this.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        String dppayquotation = this.getString("dppayquotation");
        String agreedquotation = this.getString("agreedquotation");
        if (basecurrency == null) {
            return;
        }
        int round = basecurrency.getInt("amtprecision");
        if (dpcurrency == null) {
            return;
        }
        int dppayround = dpcurrency.getInt("amtprecision");
        BigDecimal sumDpamt = BigDecimal.ZERO;
        BigDecimal sumDpLocalamt = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            int rowIdx = (Integer)rowIndexs.get(i);
            BigDecimal edpamt = BigDecimal.ZERO;
            BigDecimal edplocalamt = BigDecimal.ZERO;
            if (i == size - 1) {
                edpamt = dpamt.subtract(sumDpamt);
                edplocalamt = dplocalamt.subtract(sumDpLocalamt);
            } else {
                BigDecimal eamount = AgentPayBillPluginHelper.getEntryAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIdx);
                edpamt = QuotationHelper.callToCurrency((BigDecimal)eamount, (BigDecimal)agreedrate, (String)agreedquotation, (int)dppayround);
                sumDpamt = sumDpamt.add(edpamt);
                edplocalamt = QuotationHelper.callToCurrency((BigDecimal)edpamt, (BigDecimal)dpexchangerate, (String)dppayquotation, (int)round);
                sumDpLocalamt = sumDpLocalamt.add(edplocalamt);
            }
            this.setValue("e_dpamt", edpamt, rowIdx);
            this.setValue("e_dplocalamt", edplocalamt, rowIdx);
        }
    }

    private void clearEntryField(String ... keys) {
        DynamicObjectCollection coll = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < coll.size(); ++i) {
            for (String key : keys) {
                this.setValue(key, null, i);
            }
        }
    }
}

