/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.balance;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class BalanceAdjustPrintPlugin
extends AbstractPrintServicePlugin {
    private static final String ROWDATACACHEKEY = "SubLedgerRptPrint_RowDatas";
    private int entityIndex = 0;

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        List dyns = e.getDataEntities();
        DynamicObjectType customDT = new DynamicObjectType();
        if (e.isMainDs()) {
            for (DynamicObject dy : dyns) {
                Date bizdate = dy.getDate("bizdate");
                Lang lang = RequestContext.get().getLang();
                if (Lang.zh_CN != lang && Lang.zh_TW != lang) {
                    SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
                    String strDay = sd.format(bizdate);
                    dy.set("imageno", (Object)String.format(ResManager.loadKDString((String)"%s\u4f59\u989d\u8c03\u8282\u8868", (String)"BalanceAdjustPrintPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), strDay));
                    continue;
                }
                String str = String.format("yyyy%sMM%sdd%s", ResManager.loadKDString((String)"\u5e74", (String)"BalanceAdjustPrintPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6708", (String)"BalanceAdjustPrintPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65e5", (String)"BalanceAdjustPrintPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                SimpleDateFormat sd = new SimpleDateFormat(str);
                String strDay = sd.format(bizdate);
                dy.set("imageno", (Object)String.format(ResManager.loadKDString((String)"%s\u4f59\u989d\u8c03\u8282\u8868", (String)"BalanceAdjustPrintPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), strDay));
            }
            ThreadCache.put((Object)ROWDATACACHEKEY, dyns.stream().collect(Collectors.toList()));
        } else if ("balanceAdjust".equals(e.getDataSourceName())) {
            List list = (List)ThreadCache.get((Object)ROWDATACACHEKEY);
            DynamicObject balAdjust = (DynamicObject)list.get(this.entityIndex);
            ++this.entityIndex;
            int scale = balAdjust.getBigDecimal("bankgotamt").scale();
            balAdjust = BusinessDataServiceHelper.loadSingle((Object)balAdjust.get("id"), (String)"cas_balanceadjust");
            String entprpayedamt = CasHelper.formatDecimal((BigDecimal)balAdjust.getBigDecimal("entprpayedamt"), (int)scale);
            String bankpayedamt = CasHelper.formatDecimal((BigDecimal)balAdjust.getBigDecimal("bankpayedamt"), (int)scale);
            Map<String, List<DynamicObject>> detailData = this.getDetailData(balAdjust);
            customDT.registerProperty("orgdate", String.class, (Object)"", false);
            customDT.registerProperty("orgamount", String.class, (Object)"", false);
            customDT.registerProperty("orgreason", String.class, (Object)"", false);
            customDT.registerProperty("bankdate", String.class, (Object)"", false);
            customDT.registerProperty("bankvoucher", String.class, (Object)"", false);
            customDT.registerProperty("bankamount", String.class, (Object)"", false);
            customDT.registerProperty("bankreason", String.class, (Object)"", false);
            customDT.registerProperty("bankinfo", String.class, (Object)"", false);
            customDT.registerProperty("orginfo", String.class, (Object)"", false);
            List<DynamicObject> bankReceice = detailData.get("bankReceice");
            List<DynamicObject> orgReceice = detailData.get("orgReceice");
            DynamicObject printRow = null;
            int receiceSize = bankReceice.size() > orgReceice.size() ? bankReceice.size() : orgReceice.size();
            for (int i = 0; i < receiceSize; ++i) {
                printRow = new DynamicObject(customDT);
                if (bankReceice.size() > i) {
                    printRow.set("orgdate", (Object)bankReceice.get(i).getDate("enter_bizdate"));
                    printRow.set("orgamount", (Object)CasHelper.formatDecimal((BigDecimal)bankReceice.get(i).getBigDecimal("enter_creditamount"), (int)scale));
                    printRow.set("orgreason", (Object)bankReceice.get(i).getString("enter_reason"));
                }
                if (orgReceice.size() > i) {
                    printRow.set("bankdate", (Object)orgReceice.get(i).getDate("bank_bookdate"));
                    printRow.set("bankvoucher", (Object)orgReceice.get(i).getString("bank_vouchernumber"));
                    printRow.set("bankamount", (Object)CasHelper.formatDecimal((BigDecimal)orgReceice.get(i).getBigDecimal("bank_debitamount"), (int)scale));
                    printRow.set("bankreason", (Object)orgReceice.get(i).getString("bank_reason"));
                }
                dyns.add(printRow);
            }
            printRow = new DynamicObject(customDT);
            printRow.set("bankinfo", (Object)ResManager.loadKDString((String)"\u51cf\uff1a\u94f6\u884c\u5df2\u4ed8\uff0c\u4f01\u4e1a\u672a\u4ed8", (String)"BalanceAdjustPrintPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            printRow.set("orginfo", (Object)ResManager.loadKDString((String)"\u51cf\uff1a\u4f01\u4e1a\u5df2\u4ed8\uff0c\u94f6\u884c\u672a\u4ed8", (String)"BalanceAdjustPrintPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            printRow.set("orgamount", (Object)bankpayedamt);
            printRow.set("bankamount", (Object)entprpayedamt);
            dyns.add(printRow);
            List<DynamicObject> bankPay = detailData.get("bankPay");
            List<DynamicObject> orgPay = detailData.get("orgPay");
            int paySize = bankPay.size() > orgPay.size() ? bankPay.size() : orgPay.size();
            for (int i = 0; i < paySize; ++i) {
                printRow = new DynamicObject(customDT);
                if (bankPay.size() > i) {
                    printRow.set("orgdate", (Object)bankPay.get(i).getDate("enter_bizdate"));
                    printRow.set("orgamount", (Object)CasHelper.formatDecimal((BigDecimal)bankPay.get(i).getBigDecimal("enter_debitamount"), (int)scale));
                    printRow.set("orgreason", bankPay.get(i).get("enter_reason"));
                }
                if (orgPay.size() > i) {
                    printRow.set("bankdate", (Object)orgPay.get(i).getDate("bank_bookdate"));
                    printRow.set("bankvoucher", (Object)orgPay.get(i).getString("bank_vouchernumber"));
                    printRow.set("bankamount", (Object)CasHelper.formatDecimal((BigDecimal)orgPay.get(i).getBigDecimal("bank_creditamount"), (int)scale));
                    printRow.set("bankreason", orgPay.get(i).get("bank_reason"));
                }
                dyns.add(printRow);
            }
        }
        e.setDataEntities(dyns);
    }

    private Map<String, List<DynamicObject>> getDetailData(DynamicObject balAdjust) {
        DynamicObjectCollection bankEntryColl;
        HashMap<String, List<DynamicObject>> detailData = new HashMap<String, List<DynamicObject>>();
        List<Object> bankReceice = new ArrayList();
        List<Object> orgReceice = new ArrayList();
        List<Object> bankPay = new ArrayList();
        List<Object> orgPay = new ArrayList();
        DynamicObjectCollection enterEntryColl = balAdjust.getDynamicObjectCollection("enter_entry");
        if (!enterEntryColl.isEmpty()) {
            bankPay = enterEntryColl.stream().filter(e -> e.getBigDecimal("enter_debitamount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            bankReceice = enterEntryColl.stream().filter(e -> e.getBigDecimal("enter_creditamount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        }
        if (!(bankEntryColl = balAdjust.getDynamicObjectCollection("bank_entry")).isEmpty()) {
            orgPay = bankEntryColl.stream().filter(e -> e.getBigDecimal("bank_creditamount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            orgReceice = bankEntryColl.stream().filter(e -> e.getBigDecimal("bank_debitamount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        }
        detailData.put("bankReceice", bankReceice);
        detailData.put("orgReceice", orgReceice);
        detailData.put("bankPay", bankPay);
        detailData.put("orgPay", orgPay);
        return detailData;
    }
}

