/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.balance;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.inte.api.IInteService;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.DateTimeField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang.time.DateFormatUtils;

public class BalanceAdjustPrintPluginNew
extends AbstractPrintPlugin {
    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        String dataSourceName = dataSource.getDsName();
        if ("balanceAdjust".equals(dataSourceName)) {
            DataRowSet printRow;
            List customDataRows = evt.getCustomDataRows();
            Object pk = dataSource.getPkId();
            DynamicObject balAdjust = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"cas_balanceadjust");
            int scale = balAdjust.getDynamicObject("currency").getInt("amtprecision");
            String entprpayedamt = CasHelper.formatDecimal((BigDecimal)balAdjust.getBigDecimal("entprpayedamt"), (int)scale);
            String bankpayedamt = CasHelper.formatDecimal((BigDecimal)balAdjust.getBigDecimal("bankpayedamt"), (int)scale);
            Map<String, List<DynamicObject>> detailData = this.getDetailData(balAdjust);
            List<DynamicObject> bankReceice = detailData.get("bankReceice");
            List<DynamicObject> orgReceice = detailData.get("orgReceice");
            int receiceSize = bankReceice.size() > orgReceice.size() ? bankReceice.size() : orgReceice.size();
            for (int i = 0; i < receiceSize; ++i) {
                printRow = new DataRowSet();
                if (bankReceice.size() > i) {
                    printRow.put("orgdate", (Field)new DateTimeField(new Timestamp(bankReceice.get(i).getDate("enter_bizdate").getTime())));
                    printRow.put("orgamount", (Field)new TextField(CasHelper.formatDecimal((BigDecimal)bankReceice.get(i).getBigDecimal("enter_creditamount"), (int)scale)));
                    printRow.put("orgreason", (Field)new TextField(bankReceice.get(i).getString("enter_reason")));
                    String bankDesc = bankReceice.get(i).getString("enter_description");
                    if (EmptyUtil.isNoEmpty((String)bankDesc)) {
                        printRow.put("enter_description", (Field)new TextField(bankDesc));
                    }
                }
                if (orgReceice.size() > i) {
                    printRow.put("bankdate", (Field)new DateTimeField(new Timestamp(orgReceice.get(i).getDate("bank_bookdate").getTime())));
                    printRow.put("bankvoucher", (Field)new TextField(orgReceice.get(i).getString("bank_vouchernumber")));
                    printRow.put("bankamount", (Field)new TextField(CasHelper.formatDecimal((BigDecimal)orgReceice.get(i).getBigDecimal("bank_debitamount"), (int)scale)));
                    printRow.put("bankreason", (Field)new TextField(orgReceice.get(i).getString("bank_reason")));
                }
                customDataRows.add(printRow);
            }
            printRow = new DataRowSet();
            printRow.put("bankinfo", (Field)new TextField(ResManager.loadKDString((String)"\u51cf\uff1a\u94f6\u884c\u5df2\u4ed8\uff0c\u4f01\u4e1a\u672a\u4ed8", (String)"BalanceAdjustPrintPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            printRow.put("orginfo", (Field)new TextField(ResManager.loadKDString((String)"\u51cf\uff1a\u4f01\u4e1a\u5df2\u4ed8\uff0c\u94f6\u884c\u672a\u4ed8", (String)"BalanceAdjustPrintPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            printRow.put("orgamount", (Field)new TextField(bankpayedamt));
            printRow.put("bankamount", (Field)new TextField(entprpayedamt));
            customDataRows.add(printRow);
            List<DynamicObject> bankPay = detailData.get("bankPay");
            List<DynamicObject> orgPay = detailData.get("orgPay");
            int paySize = bankPay.size() > orgPay.size() ? bankPay.size() : orgPay.size();
            for (int i = 0; i < paySize; ++i) {
                printRow = new DataRowSet();
                if (bankPay.size() > i) {
                    printRow.put("orgdate", (Field)new DateTimeField(new Timestamp(bankPay.get(i).getDate("enter_bizdate").getTime())));
                    printRow.put("orgamount", (Field)new TextField(CasHelper.formatDecimal((BigDecimal)bankPay.get(i).getBigDecimal("enter_debitamount"), (int)scale)));
                    printRow.put("orgreason", (Field)new TextField(bankPay.get(i).getString("enter_reason")));
                    String bankDesc = bankPay.get(i).getString("enter_description");
                    if (EmptyUtil.isNoEmpty((String)bankDesc)) {
                        printRow.put("enter_description", (Field)new TextField(bankDesc));
                    }
                }
                if (orgPay.size() > i) {
                    printRow.put("bankdate", (Field)new DateTimeField(new Timestamp(orgPay.get(i).getDate("bank_bookdate").getTime())));
                    printRow.put("bankvoucher", (Field)new TextField(orgPay.get(i).getString("bank_vouchernumber")));
                    printRow.put("bankamount", (Field)new TextField(CasHelper.formatDecimal((BigDecimal)orgPay.get(i).getBigDecimal("bank_creditamount"), (int)scale)));
                    printRow.put("bankreason", (Field)new TextField(orgPay.get(i).getString("bank_reason")));
                }
                customDataRows.add(printRow);
            }
        }
    }

    public void afterLoadData(AfterLoadDataEvent evt) {
        super.afterLoadData(evt);
        if ("cas_balanceadjust".equals(evt.getDataSource().getDsName())) {
            List list = evt.getDataRowSets();
            for (DataRowSet dataRowSet : list) {
                Object value = dataRowSet.getField("bizdate").getValue();
                if (value == null) continue;
                Date bizDate = (Date)value;
                IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
                String dateFormat = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
                String dateStr = DateFormatUtils.format((Date)bizDate, (String)dateFormat);
                dataRowSet.put("imageno", (Field)new TextField(String.format(ResManager.loadKDString((String)"%s\u4f59\u989d\u8c03\u8282\u8868", (String)"BalanceAdjustPrintPluginNew_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), dateStr)));
            }
        }
    }

    private Map<String, List<DynamicObject>> getDetailData(DynamicObject balAdjust) {
        DynamicObjectCollection bankEntryColl;
        HashMap<String, List<DynamicObject>> detailData = new HashMap<String, List<DynamicObject>>();
        List<Object> bankReceice = new ArrayList();
        List<Object> orgReceice = new ArrayList();
        List<Object> bankPay = new ArrayList();
        List<Object> orgPay = new ArrayList();
        DynamicObjectCollection enterEntryColl = balAdjust.getDynamicObjectCollection("enter_entry");
        if (!enterEntryColl.isEmpty()) {
            bankPay = enterEntryColl.stream().filter(e -> e.getBigDecimal("enter_debitamount").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
            bankReceice = enterEntryColl.stream().filter(e -> e.getBigDecimal("enter_creditamount").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        }
        if (!(bankEntryColl = balAdjust.getDynamicObjectCollection("bank_entry")).isEmpty()) {
            orgPay = bankEntryColl.stream().filter(e -> e.getBigDecimal("bank_creditamount").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
            orgReceice = bankEntryColl.stream().filter(e -> e.getBigDecimal("bank_debitamount").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        }
        detailData.put("bankReceice", bankReceice);
        detailData.put("orgReceice", orgReceice);
        detailData.put("bankPay", bankPay);
        detailData.put("orgPay", orgPay);
        return detailData;
    }
}

