/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.cashcount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.facade.impl.CasServiceFacadeImpl;
import kd.fi.cas.enums.CashVerificationEnum;
import kd.fi.cas.enums.CashcheckresultEnum;
import kd.fi.cas.formplugin.helper.InitCheckPluginHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.StringUtils;

public class CashVerificationPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(CashVerificationPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initControlCurF7();
        this.initControlDenF7();
    }

    protected void initControlCurF7() {
        IDataModel model = this.getView().getModel();
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject cashAccount = (DynamicObject)model.getValue("cashaccount");
            if (cashAccount == null) {
                return;
            }
            DynamicObjectCollection currencyObjCol = (DynamicObjectCollection)cashAccount.get("currency");
            if (currencyObjCol == null) {
                return;
            }
            ArrayList<Object> currencyIdList = new ArrayList<Object>();
            for (DynamicObject currencyObj : currencyObjCol) {
                currencyIdList.add(currencyObj.get("fbasedataid_id"));
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", currencyIdList);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    protected void initControlDenF7() {
        IDataModel model = this.getView().getModel();
        BasedataEdit denSelectF7 = (BasedataEdit)this.getControl("denselect");
        denSelectF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject obj = (DynamicObject)model.getValue("currency");
            if (obj == null) {
                return;
            }
            Object currencyId = obj.get("id");
            DynamicObjectCollection entryCurrencyCol = this.getEntryCurrencyCol(currencyId);
            ArrayList<Long> denIdList = new ArrayList<Long>();
            for (DynamicObject entryCurrency : entryCurrencyCol) {
                denIdList.add(entryCurrency.getLong("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", denIdList);
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.getListFilterParameter().setOrderBy("conversionratio desc");
        });
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getView().getModel();
        Object org = this.getView().getFormShowParameter().getCustomParam("org");
        Object currency = this.getView().getFormShowParameter().getCustomParam("currency");
        Object cashAccount = this.getView().getFormShowParameter().getCustomParam("cashaccount");
        model.setValue("org", org);
        model.setValue("currency", currency);
        model.setValue("cashaccount", cashAccount);
        model.setValue("checkdate", (Object)new Date());
        this.creatCashEntityRow(currency, model);
        RequestContext requestContext = RequestContext.get();
        Long currentUserID = Long.valueOf(requestContext.getUserId());
        model.setValue("cashier", (Object)currentUserID);
        this.getView().updateView("cashentity");
        this.getView().updateView("accountentity");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        CashVerificationPlugin.getDenomination(this.getModel());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getView().getModel();
        String key = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        if (null == valSet[0].getNewValue()) {
            return;
        }
        switch (key) {
            case "denselect": {
                DynamicObject dynamicObject = (DynamicObject)model.getValue("currency");
                if (dynamicObject == null) {
                    logger.error("currency is null.");
                    return;
                }
                Object currencyId = dynamicObject.get("id");
                DynamicObjectCollection denSelectObjCol = this.creatCashEntityRow(currencyId, model);
                model.deleteEntryData("cashentity");
                for (int i = 0; i < denSelectObjCol.size(); ++i) {
                    DynamicObject obj = (DynamicObject)((DynamicObject)denSelectObjCol.get(i)).get("fbasedataid");
                    int rowIdx = model.createNewEntryRow("cashentity");
                    model.setEntryCurrentRowIndex("cashentity", rowIdx);
                    model.setValue("denomination", obj.get("denomination"), rowIdx);
                    model.setValue("conversionratio", obj.get("conversionratio"), rowIdx);
                    model.setValue("denominationid", (Object)String.valueOf(obj.getPkValue()), rowIdx);
                }
                this.countMoney(model);
                this.getView().updateView("cashentity");
                break;
            }
            case "cashaccount": {
                DynamicObject cashAccount = (DynamicObject)valSet[0].getNewValue();
                DynamicObject defaultAccountDyObj = (DynamicObject)cashAccount.get("defaultcurrency");
                Object currency = defaultAccountDyObj.get("id");
                Object orgId = cashAccount.get("org.id");
                DynamicObjectCollection currencyObjCol = (DynamicObjectCollection)cashAccount.get("currency");
                model.setValue("currency", currency);
                model.setValue("org", orgId);
                this.creatCashEntityRow(((DynamicObject)currencyObjCol.get(0)).get("fbasedataid_id"), model);
                this.countMoney(model);
                break;
            }
            case "denamount": {
                BigDecimal newValue = new BigDecimal(String.valueOf(valSet[0].getNewValue()));
                int selectIndex = model.getEntryCurrentRowIndex("cashentity");
                BigDecimal con = (BigDecimal)model.getValue("conversionratio", selectIndex);
                BigDecimal denmoney = newValue.multiply(con);
                model.setValue("denmoney", (Object)denmoney, selectIndex);
                this.countMoney(model);
                break;
            }
            case "currency": {
                DynamicObject currencyObj = (DynamicObject)valSet[0].getNewValue();
                this.creatCashEntityRow(currencyObj.getPkValue(), model);
                this.countMoney(model);
                break;
            }
            case "adjustment": {
                this.countMoney(model);
                break;
            }
            case "adjmoney": {
                this.countMoney(model);
                break;
            }
            case "checkdate": {
                this.countMoney(model);
                break;
            }
            case "itemremark": {
                this.getItemRemark(model, valSet);
            }
        }
    }

    public DynamicObjectCollection creatCashEntityRow(Object currency, IDataModel model) {
        model.deleteEntryData("cashentity");
        DynamicObjectCollection entryCurrencyCol = this.getEntryCurrencyCol(currency);
        for (int i = 0; i < entryCurrencyCol.size(); ++i) {
            int rowIdx = model.createNewEntryRow("cashentity");
            model.setEntryCurrentRowIndex("cashentity", rowIdx);
            model.setValue("denomination", ((DynamicObject)entryCurrencyCol.get(i)).get("denomination"), rowIdx);
            model.setValue("conversionratio", ((DynamicObject)entryCurrencyCol.get(i)).get("conversionratio"), rowIdx);
            model.setValue("denominationid", (Object)String.valueOf(((DynamicObject)entryCurrencyCol.get(i)).getPkValue()), rowIdx);
        }
        return CashVerificationPlugin.getDenominationByAcc(model, entryCurrencyCol);
    }

    public void getItemRemark(IDataModel model, ChangeData[] valSet) {
        Object newValue = valSet[0].getNewValue();
        int selectIndex = model.getEntryCurrentRowIndex("accountentity");
        switch (selectIndex) {
            case 0: {
                model.setValue("accountbalancermk", newValue);
                break;
            }
            case 1: {
                model.setValue("bookedunpaidrmk", newValue);
                break;
            }
            case 2: {
                model.setValue("unbookedreceivedrmk", newValue);
                break;
            }
            case 3: {
                model.setValue("bookedunreceivedrmk", newValue);
                break;
            }
            case 4: {
                model.setValue("unbookedpaidrmk", newValue);
                break;
            }
            case 5: {
                model.setValue("adjustbalancermk", newValue);
                break;
            }
            case 6: {
                model.setValue("realcashamountrmk", newValue);
                break;
            }
            case 7: {
                model.setValue("inventorysurplusrmk", newValue);
                break;
            }
            case 8: {
                model.setValue("inventorydeficitrmk", newValue);
            }
        }
    }

    public void countMoney(IDataModel model) {
        DynamicObjectCollection accObjCol = model.getEntryEntity("accdetailentity");
        BigDecimal addNoPaymentInAccSum = new BigDecimal("0");
        BigDecimal addYesPaymentNoAccSum = new BigDecimal("0");
        BigDecimal minusNoPaymentInAccSum = new BigDecimal("0");
        BigDecimal minusNoPaymentNoAccSum = new BigDecimal("0");
        for (DynamicObject accObj : accObjCol) {
            if (null == accObj.get("adjustment")) continue;
            Integer adjustment = Integer.parseInt(String.valueOf(accObj.get("adjustment")));
            BigDecimal adjmoney = accObj.getBigDecimal("adjmoney");
            switch (adjustment) {
                case 1: {
                    addNoPaymentInAccSum = addNoPaymentInAccSum.add(adjmoney);
                    break;
                }
                case 2: {
                    addYesPaymentNoAccSum = addYesPaymentNoAccSum.add(adjmoney);
                    break;
                }
                case 3: {
                    minusNoPaymentInAccSum = minusNoPaymentInAccSum.add(adjmoney);
                    break;
                }
                case 4: {
                    minusNoPaymentNoAccSum = minusNoPaymentNoAccSum.add(adjmoney);
                }
            }
        }
        model.setValue("itemmoney", (Object)addNoPaymentInAccSum, 1);
        model.setValue("bookedunpaid", (Object)addNoPaymentInAccSum);
        model.setValue("itemmoney", (Object)addYesPaymentNoAccSum, 2);
        model.setValue("unbookedreceived", (Object)addYesPaymentNoAccSum);
        model.setValue("itemmoney", (Object)minusNoPaymentInAccSum, 3);
        model.setValue("bookedunreceived", (Object)minusNoPaymentInAccSum);
        model.setValue("itemmoney", (Object)minusNoPaymentNoAccSum, 4);
        model.setValue("unbookedpaid", (Object)minusNoPaymentNoAccSum);
        BigDecimal balanceAmtOfAcct = "A".equals(model.getValue("billstatus").toString()) ? CashVerificationPlugin.getBalanceAmtOfAcct(model) : (BigDecimal)model.getValue("accountBalance");
        BigDecimal balanceAmtAfterAdj = BigDecimal.ZERO;
        balanceAmtAfterAdj = balanceAmtOfAcct.add(addNoPaymentInAccSum).add(addYesPaymentNoAccSum).subtract(minusNoPaymentInAccSum).subtract(minusNoPaymentNoAccSum);
        model.setValue("itemmoney", (Object)balanceAmtOfAcct, 0);
        model.setValue("accountBalance", (Object)balanceAmtOfAcct);
        int adjBalanceIdx = Integer.parseInt(CashVerificationEnum.CASH_ADJUST_BALANCE.getValue());
        model.setValue("itemmoney", (Object)balanceAmtAfterAdj, adjBalanceIdx);
        model.setValue("adjustbalance", (Object)balanceAmtAfterAdj);
        BigDecimal totalAmtOfCash = BigDecimal.ZERO;
        DynamicObjectCollection dc = model.getEntryEntity("cashentity");
        for (DynamicObject cash : dc) {
            BigDecimal amt = cash.getBigDecimal("denmoney");
            totalAmtOfCash = totalAmtOfCash.add(amt);
        }
        int cashIdx = Integer.parseInt(CashVerificationEnum.CASH_REAL_CASH.getValue());
        model.setValue("itemmoney", (Object)totalAmtOfCash, cashIdx);
        model.setValue("realcashamount", (Object)totalAmtOfCash);
        BigDecimal diffAmount = BigDecimal.ZERO;
        diffAmount = totalAmtOfCash.subtract(balanceAmtAfterAdj);
        int defictIdx = Integer.parseInt(CashVerificationEnum.CASH_DISH_DEFICIENT.getValue());
        int surplusIdx = Integer.parseInt(CashVerificationEnum.CASH_INVENTORY_SURPLUS.getValue());
        if (BigDecimal.ZERO.compareTo(diffAmount) < 0) {
            model.setValue("itemmoney", (Object)diffAmount, surplusIdx);
            model.setValue("inventorysurplus", (Object)diffAmount);
            model.setValue("itemmoney", (Object)BigDecimal.ZERO, defictIdx);
            model.setValue("inventorydeficit", (Object)BigDecimal.ZERO);
            model.setValue("checkresult", (Object)CashcheckresultEnum.INVENTORY_PROFIT.getValue());
        }
        if (BigDecimal.ZERO.compareTo(diffAmount) == 0) {
            model.setValue("itemmoney", (Object)BigDecimal.ZERO, surplusIdx);
            model.setValue("inventorysurplus", (Object)BigDecimal.ZERO);
            model.setValue("itemmoney", (Object)BigDecimal.ZERO, defictIdx);
            model.setValue("inventorydeficit", (Object)BigDecimal.ZERO);
            model.setValue("checkresult", (Object)CashcheckresultEnum.BALANCE_OF_ACCOUNT.getValue());
        }
        if (BigDecimal.ZERO.compareTo(diffAmount) > 0) {
            model.setValue("itemmoney", (Object)BigDecimal.ZERO, surplusIdx);
            model.setValue("inventorysurplus", (Object)BigDecimal.ZERO);
            model.setValue("itemmoney", (Object)diffAmount.abs(), defictIdx);
            model.setValue("inventorydeficit", (Object)diffAmount.abs());
            model.setValue("checkresult", (Object)CashcheckresultEnum.INVENTORY_LOSSES.getValue());
        }
    }

    public DynamicObjectCollection getEntryCurrencyCol(Object currency) {
        QFilter qFilter = new QFilter("currency", "=", currency);
        DynamicObject cashAccountObj = BusinessDataServiceHelper.loadSingle((String)"cas_currencyfacevalue", (String)"id,denomination,conversionratio,usestatus", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection entryCurrencyCol = new DynamicObjectCollection();
        if (null != cashAccountObj) {
            entryCurrencyCol = cashAccountObj.getDynamicObjectCollection("entryentity");
            entryCurrencyCol = entryCurrencyCol.stream().filter(dy -> (Boolean)dy.get("usestatus")).collect(Collectors.toCollection(DynamicObjectCollection::new));
        }
        return entryCurrencyCol;
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getView().getModel();
        this.initControlDenF7();
        RequestContext requestContext = RequestContext.get();
        Long currentUserID = Long.valueOf(requestContext.getUserId());
        model.setValue("cashier", (Object)currentUserID);
        model.setValue("checkdate", (Object)DateUtils.getCurrentDate());
    }

    public void afterBindData(EventObject e) {
        Object adjustBalance;
        super.beforeBindData(e);
        IDataModel model = this.getView().getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (!InitCheckPluginHelper.checkInitForPlugin(this.getView(), org, new String[]{"bar_save", "submit"})) {
            return;
        }
        DynamicObject cashObj = model.getDataEntity();
        Object accountBalance = "A".equals(cashObj.get("billstatus").toString()) ? CashVerificationPlugin.getBalanceAmtOfAcct(model) : cashObj.get("accountBalance");
        Object bookedUnpaid = cashObj.get("bookedunpaid");
        Object unBookedReceived = cashObj.get("unbookedreceived");
        Object bookedUnreceived = cashObj.get("bookedunreceived");
        Object unBookedPaid = cashObj.get("unbookedpaid");
        if ("A".equals(cashObj.get("billstatus").toString())) {
            BigDecimal accountBalanceBigDe = new BigDecimal(String.valueOf(accountBalance));
            BigDecimal bookedUnpaidBigDe = new BigDecimal(String.valueOf(bookedUnpaid));
            BigDecimal unBookedReceivedBigDe = new BigDecimal(String.valueOf(unBookedReceived));
            BigDecimal bookedUnreceivedBigDe = new BigDecimal(String.valueOf(bookedUnreceived));
            BigDecimal unBookedPaidBigDe = new BigDecimal(String.valueOf(unBookedPaid));
            adjustBalance = accountBalanceBigDe.add(bookedUnpaidBigDe).add(unBookedReceivedBigDe).subtract(bookedUnreceivedBigDe).subtract(unBookedPaidBigDe);
        } else {
            adjustBalance = cashObj.get("adjustbalance");
        }
        Object realCashAmount = cashObj.get("realcashamount");
        Object inventorySurplus = cashObj.get("inventorysurplus");
        Object inventoryDeficit = cashObj.get("inventorydeficit");
        Object accountBalanceRmk = cashObj.get("accountbalancermk");
        Object bookedUnpaidRmk = cashObj.get("bookedunpaidrmk");
        Object unBookedReceivedRmk = cashObj.get("unbookedreceivedrmk");
        Object bookedUnreceivedRmk = cashObj.get("bookedunreceivedrmk");
        Object unBookedPaidRmk = cashObj.get("unbookedpaidrmk");
        Object adjustBalanceRmk = cashObj.get("adjustbalancermk");
        Object realCashAmountRmk = cashObj.get("realcashamountrmk");
        Object inventorySurplusRmk = cashObj.get("inventorysurplusrmk");
        Object inventoryDeficitRmk = cashObj.get("inventorydeficitrmk");
        for (int i = 0; i < CashVerificationEnum.values().length; ++i) {
            int rowIdx = model.createNewEntryRow("accountentity");
            model.setEntryCurrentRowIndex("accountentity", rowIdx);
            model.setValue("item", (Object)CashVerificationEnum.getName((String)String.valueOf(i)), rowIdx);
        }
        CashVerificationPlugin.setMoneyAndRmk(accountBalanceRmk, accountBalance, model, 0);
        CashVerificationPlugin.setMoneyAndRmk(bookedUnpaidRmk, bookedUnpaid, model, 1);
        CashVerificationPlugin.setMoneyAndRmk(unBookedReceivedRmk, unBookedReceived, model, 2);
        CashVerificationPlugin.setMoneyAndRmk(bookedUnreceivedRmk, bookedUnreceived, model, 3);
        CashVerificationPlugin.setMoneyAndRmk(unBookedPaidRmk, unBookedPaid, model, 4);
        CashVerificationPlugin.setMoneyAndRmk(adjustBalanceRmk, adjustBalance, model, 5);
        CashVerificationPlugin.setMoneyAndRmk(realCashAmountRmk, realCashAmount, model, 6);
        CashVerificationPlugin.setMoneyAndRmk(inventorySurplusRmk, inventorySurplus, model, 7);
        CashVerificationPlugin.setMoneyAndRmk(inventoryDeficitRmk, inventoryDeficit, model, 8);
        this.countMoney(model);
        this.getView().updateView("accountentity");
        this.getView().getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (("audit".equals(operateKey) || "unaudit".equals(operateKey)) && opResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (StringUtils.equals((CharSequence)"accdetailentity", (CharSequence)e.getEntryProp().getName())) {
            this.countMoney(this.getModel());
        }
    }

    public static void getDenomination(IDataModel model) {
        model.beginInit();
        DynamicObject cashObj = model.getDataEntity();
        DynamicObjectCollection cashCollection = (DynamicObjectCollection)cashObj.get("cashentity");
        ArrayList<Long> cashDenId = new ArrayList<Long>(cashCollection.size());
        for (DynamicObject cash : cashCollection) {
            cashDenId.add(Long.valueOf(cash.getString("denominationid")));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", cashDenId)};
        DynamicObject[] currencyFaceObjs = BusinessDataServiceHelper.load((String)"cas_ccyfacevalueentry_f7", (String)"id,number", (QFilter[])qFilters);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_cash_verification");
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entityType.getProperty("denselect");
        DynamicObjectCollection collection = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)cashObj);
        for (DynamicObject currencyFaceObj : currencyFaceObjs) {
            DynamicObject newObj = new DynamicObject(currencyProp.getDynamicCollectionItemPropertyType());
            newObj.set("fbasedataid", (Object)currencyFaceObj);
            newObj.set("fbasedataid_id", currencyFaceObj.getPkValue());
            collection.add((Object)newObj);
        }
        model.setValue("denselect", (Object)collection);
        model.endInit();
    }

    public static DynamicObjectCollection getDenominationByAcc(IDataModel model, DynamicObjectCollection entryCurrencyCol) {
        DynamicObject cashObj = model.getDataEntity();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_cash_verification");
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entityType.getProperty("denselect");
        DynamicObjectCollection collection = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)cashObj);
        for (DynamicObject currencyFaceObj : entryCurrencyCol) {
            DynamicObject newObj = new DynamicObject(currencyProp.getDynamicCollectionItemPropertyType());
            newObj.set("fbasedataid", (Object)currencyFaceObj);
            newObj.set("fbasedataid_id", currencyFaceObj.getPkValue());
            collection.add((Object)newObj);
        }
        model.setValue("denselect", (Object)collection);
        return collection;
    }

    public static BigDecimal getBalanceAmtOfAcct(IDataModel model) {
        DynamicObject entity = model.getDataEntity();
        DynamicObject orgObj = entity.getDynamicObject("org");
        DynamicObject ccyObj = entity.getDynamicObject("currency");
        DynamicObject cashAccountObj = entity.getDynamicObject("cashaccount");
        if (ccyObj == null || cashAccountObj == null) {
            return BigDecimal.ZERO;
        }
        Long orgId = orgObj.getLong("id");
        Long ccyId = ccyObj.getLong("id");
        Long accountId = cashAccountObj.getLong("id");
        Date checkDate = entity.getDate("checkdate");
        BigDecimal balanceAmtOfAcct = BigDecimal.ZERO;
        if (orgId != null && ccyId != null && accountId != null && checkDate != null) {
            CasServiceFacadeImpl balanceService = new CasServiceFacadeImpl();
            boolean useBalanceModel = ExtendConfigHelper.useBalanceModel();
            balanceAmtOfAcct = useBalanceModel ? balanceService.getCashJournalBalanceByBalanceModel(orgId, accountId, ccyId, checkDate) : balanceService.getCashJournalDayBalanceByBookDate(orgId, accountId, ccyId, checkDate);
        }
        return balanceAmtOfAcct;
    }

    public static void setMoneyAndRmk(Object rmk, Object money, IDataModel model, int row) {
        model.setValue("itemmoney", money, row);
        model.setValue("itemremark", rmk, row);
    }
}

