/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.cashcount;

import java.math.BigDecimal;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class CurrencyDenominationF7ListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new GetListDataProvider());
    }

    static class GetListDataProvider
    extends ListDataProvider {
        GetListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty() || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"unit")) {
                return rows;
            }
            DynamicObject currency = QueryServiceHelper.queryOne((String)"cas_currencyfacevalue", (String)"id,entryentity.id,currency.amtprecision", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", ((DynamicObject)rows.get(0)).get("id"))});
            Integer scale = currency.getInt("currency.amtprecision");
            rows.stream().map(dy -> {
                String val = CasHelper.formatDecimal((BigDecimal)dy.getBigDecimal("conversionratio"), (int)scale);
                dy.set("unit", (Object)val);
                return dy;
            }).collect(Collectors.toCollection(DynamicObjectCollection::new));
            return rows;
        }
    }
}

