/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.cashcount;

import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CurrencyFaceValueEditPlugin
extends AbstractBillPlugIn {
    public static final String ENTRYENTITY = "entryentity";
    public static final String DENOMINATION_SINGLE = "denomination";
    public static final String DENOMINATION_ALLENABLED = "enableddenomination";
    public static final String IF_ENABLE = "usestatus";
    public static final String SAVE_OPERATE = "save";
    public static final String CURRENCY = "currency";
    public static final String UNIT = "unit";
    public static final String FACEVALUE = "facevalue";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] datas = e.getChangeSet();
        switch (fieldKey) {
            case "facevalue": 
            case "unit": {
                this.refreshDenomination(fieldKey, datas);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        QFilter[] qFilterArray;
        super.beforeDoOperation(args);
        Long pkId = (Long)this.getView().getModel().getDataEntity().getPkValue();
        if (null != pkId && pkId != 0L) {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = new QFilter("id", "!=", (Object)pkId);
        } else {
            qFilterArray = null;
        }
        QFilter[] qFilters = qFilterArray;
        DynamicObject[] dycol = BusinessDataServiceHelper.load((String)"cas_currencyfacevalue", (String)"id,currency", qFilters);
        DynamicObject currency = (DynamicObject)this.getModel().getValue(CURRENCY);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)SAVE_OPERATE) && dycol != null) {
            if (currency == null) {
                args.setCancel(true);
                return;
            }
            long currencyId = (Long)currency.getPkValue();
            DynamicObject tempCurrency = null;
            for (DynamicObject x : dycol) {
                tempCurrency = x.getDynamicObject(CURRENCY);
                if (currencyId != (Long)tempCurrency.getPkValue()) continue;
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u5df2\u5b58\u5728\u3002", (String)"CurrencyFaceValueEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void refreshDenomination(String fieldKey, ChangeData[] datas) {
        String facevalue = null;
        String unit = null;
        if (FACEVALUE.equals(fieldKey)) {
            facevalue = datas[0].getNewValue().toString();
            unit = this.getModel().getValue(UNIT).toString();
        } else if (UNIT.equals(fieldKey)) {
            unit = datas[0].getNewValue().toString();
            facevalue = this.getModel().getValue(FACEVALUE).toString();
        }
        if (StringUtils.isNotEmpty(unit) && StringUtils.isNotEmpty((CharSequence)facevalue)) {
            this.getModel().setValue(DENOMINATION_SINGLE, (Object)String.format("%s%s", facevalue, unit));
        }
    }
}

