/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.changebill;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.errorcode.AgentPayErrorCode;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.helper.PayInfoChgHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayInfoChgEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
        BasedataEdit aftersettletype = (BasedataEdit)this.getControl("aftersettletype");
        aftersettletype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sourceType = (String)this.getView().getFormShowParameter().getCustomParam("sourceType");
        Long sourceId = (Long)this.getView().getFormShowParameter().getCustomParam("sourceId");
        if (sourceType != null && sourceId != null) {
            DynamicObject bizBill = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceId, (String)sourceType);
            String changeCause = (String)this.getView().getFormShowParameter().getCustomParam("changeCause");
            BillModel model = (BillModel)this.getModel();
            model.setValue("remark", (Object)changeCause);
            model.setValue("billstatus", (Object)"A");
            model.setValue("sourcebillno", bizBill.get("billno"));
            model.setValue("chgtype", (Object)"paychg");
            model.setValue("sourcetype", (Object)sourceType);
            model.setValue("sourcebillid", (Object)sourceId);
            DynamicObject orgObj = bizBill.getDynamicObject("org");
            model.setValue("applyuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            model.setValue("alterationuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            Long org = null;
            if (!CasHelper.isEmpty((Object)orgObj)) {
                org = (Long)orgObj.getPkValue();
            }
            model.setValue("org", (Object)org);
            DynamicObject currencyObj = "cas_paybill".equals(sourceType) && bizBill.getBoolean("isdiffcur") ? bizBill.getDynamicObject("dpcurrency") : bizBill.getDynamicObject("currency");
            Long currencyId = null;
            if (!CasHelper.isEmpty((Object)currencyObj)) {
                currencyId = (Long)currencyObj.getPkValue();
            }
            model.setValue("sourcecurrency", (Object)currencyId);
            model.setValue("paychannel", (Object)bizBill.getString("paymentchannel"), 0);
            DynamicObject settletypeObj = bizBill.getDynamicObject("settletype");
            Long settletype = null;
            if (!CasHelper.isEmpty((Object)settletypeObj)) {
                settletype = (Long)settletypeObj.getPkValue();
            }
            model.setValue("settletype", (Object)settletype, 0);
            model.setValue("settletnumber", (Object)bizBill.getString("settletnumber"), 0);
            if (BaseDataHelper.isSettleTypeCash((DynamicObject)settletypeObj)) {
                DynamicObject payeracctcashObj = null;
                if ("cas_paybill".equals(sourceType)) {
                    payeracctcashObj = bizBill.getDynamicObject("payeracctcash");
                } else if ("cas_agentpaybill".equals(sourceType)) {
                    payeracctcashObj = bizBill.getDynamicObject("accountcash");
                }
                Long payeracctcash = null;
                if (null != payeracctcashObj) {
                    payeracctcash = payeracctcashObj.getLong("id");
                }
                model.setValue("payeracctcash", (Object)payeracctcash, 0);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"payeracctbank"});
            } else {
                DynamicObject payeracctbankObj = bizBill.getDynamicObject("payeracctbank");
                Long payeracctbank = null;
                if (!CasHelper.isEmpty((Object)payeracctbankObj)) {
                    payeracctbank = (Long)payeracctbankObj.getPkValue();
                }
                model.setValue("payeracctbank", (Object)payeracctbank, 0);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"payeracctcash"});
            }
            DynamicObject payerbankObj = bizBill.getDynamicObject("payerbank");
            Long payerbank = null;
            if (!CasHelper.isEmpty((Object)payerbankObj)) {
                payerbank = (Long)payerbankObj.getPkValue();
            }
            model.setValue("payerbank", (Object)payerbank, 0);
            if ("cas_paybill".equals(sourceType)) {
                model.setValue("usage", (Object)bizBill.getString("usage"), 0);
                model.setValue("actpayamt", bizBill.get("actpayamt"), 0);
            } else if ("cas_agentpaybill".equals(sourceType)) {
                model.setValue("actpayamt", bizBill.get("payamount"), 0);
                model.setValue("iscombinerecord", bizBill.get("isagencypersonpay"), 0);
                model.setValue("isaftercombinerecord", bizBill.get("isagencypersonpay"), 0);
            }
            model.setValue("bizdate", bizBill.get("bizdate"), 0);
            String businessType = bizBill.getString("businesstype");
            model.setValue("businesstype", (Object)businessType, 0);
            if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                model.setValue("institutioncode", bizBill.get("institutioncode"), 0);
                model.setValue("institutionname", bizBill.get("institutionname"), 0);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sourceType = (String)this.getView().getFormShowParameter().getCustomParam("sourceType");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String editSourceType = dataEntity.getString("sourcetype");
        if ("cas_agentpaybill".equals(sourceType) || "cas_agentpaybill".equals(editSourceType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"usage", "afterusage"});
        } else if ("cas_paybill".equals(sourceType) || "cas_paybill".equals(editSourceType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"iscombinerecord", "isaftercombinerecord"});
        }
        this.setAfterPayerAccountVisible();
    }

    private void initF7() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org == null ? 0L : Long.parseLong(org.getPkValue().toString());
        QFilter qFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)orgId);
        Object afterPayChannel = this.getModel().getValue("afterpaychannel");
        if ("bei".equals(afterPayChannel)) {
            qFilter.and(new QFilter("issetbankinterface", "=", (Object)"1"));
        }
        BasedataEdit payerAcctBank = (BasedataEdit)this.getControl("payeracctbank");
        payerAcctBank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object currency = this.getModel().getValue("sourcecurrency");
            if (currency != null) {
                qFilter.and(new QFilter("currency.fbasedataid.id", "=", ((DynamicObject)currency).getPkValue()));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit afterpayeracctbankCtrl = (BasedataEdit)this.getControl("afterpayeracctbank");
        afterpayeracctbankCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entrys", this.getModel().getEntryCurrentRowIndex("entrys"));
            DynamicObject aftersettletype = entryRowEntity.getDynamicObject("aftersettletype");
            QFilter virtualQf = BaseDataHelper.isSettleTypeVirtual((DynamicObject)aftersettletype) ? VisibleVirtualAcctHelper.virtualAcctQf() : VisibleVirtualAcctHelper.notVirtualAcctQf();
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object currency = this.getModel().getValue("sourcecurrency");
            if (currency != null) {
                qFilter.and(new QFilter("currency.fbasedataid.id", "=", ((DynamicObject)currency).getPkValue()));
            }
            String filterIsElec = "0";
            DynamicObject settletype = entryRowEntity.getDynamicObject("settletype");
            String businessType = entryRowEntity.getString("businesstype");
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settletype);
            if (isDcep && (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType))) {
                filterIsElec = "1";
            }
            qFilter.and(new QFilter("iselecpayment", "=", (Object)filterIsElec));
            showParameter.getListFilterParameter().getQFilters().add(qFilter.and(virtualQf));
        });
        BasedataEdit afterpayeracctcashCtrl = (BasedataEdit)this.getControl("afterpayeracctcash");
        afterpayeracctcashCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            LspWapper lspWapper = new LspWapper(beforeF7SelectEvent);
            QFilter[] orgFilter = AccountCashHelper.getUsableAccountFilter((Long)orgId);
            lspWapper.setFilters(orgFilter);
        });
        BasedataEdit afterpayerbankCtrl = (BasedataEdit)this.getControl("afterpayerbank");
        afterpayerbankCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entrys", this.getModel().getEntryCurrentRowIndex("entrys"));
            DynamicObject aftersettletype = entryRowEntity.getDynamicObject("aftersettletype");
            QFilter virtualQf = BaseDataHelper.isSettleTypeVirtual((DynamicObject)aftersettletype) ? VisibleVirtualAcctHelper.virtualBankQf() : VisibleVirtualAcctHelper.notVirtualBankQf();
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(virtualQf);
        });
        BasedataEdit afterSettleTypeCtrl = (BasedataEdit)this.getControl("aftersettletype");
        afterSettleTypeCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            boolean isFilterFlag;
            String chgType = (String)this.getModel().getValue("chgtype");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entrys", this.getModel().getEntryCurrentRowIndex("entrys"));
            DynamicObject settleType = entryRowEntity.getDynamicObject("settletype");
            boolean isDraftSettleType = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            boolean promDraft = BaseDataHelper.isSettleTypeProm((DynamicObject)settleType);
            boolean bl = isFilterFlag = EmptyUtil.equals((CharSequence)chgType, (CharSequence)"paychg") && (isDraftSettleType || checkDraft || promDraft);
            if (isFilterFlag) {
                QFilter settlementTypeQf = new QFilter("settlementtype", "=", (Object)settleType.getString("settlementtype"));
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(settlementTypeQf);
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            boolean ischange = PayInfoChgHelper.payInfoChanged((DynamicObject)this.getModel().getDataEntity(true));
            if (!ischange) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u4ed8\u4fe1\u606f\u65e0\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"RecInfoChgEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
            Object sourceType = this.getModel().getValue("sourceType");
            for (DynamicObject info : entrys) {
                DynamicObject org;
                String afterPayChannel = info.getString("afterpaychannel");
                DynamicObject acctbank = info.getDynamicObject("payeracctbank");
                DynamicObject afterPayerAcctBank = info.getDynamicObject("afterpayeracctbank");
                if (!EmptyUtil.isEmpty((DynamicObject)afterPayerAcctBank)) {
                    acctbank = afterPayerAcctBank;
                }
                if (!EmptyUtil.isEmpty((String)afterPayChannel) && !EmptyUtil.isEmpty((DynamicObject)acctbank) && PaymentChannelEnum.BEI.getValue().equals(afterPayChannel) && !acctbank.getBoolean("issetbankinterface")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u7684\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u76f8\u5e94\u7684\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u5fc5\u987b\u662f\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u3002", (String)"RecInfoChgEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!EmptyUtil.isEmpty((String)afterPayChannel) && !EmptyUtil.isEmpty((DynamicObject)acctbank) && PaymentChannelEnum.ONLINEBANK.getValue().equals(afterPayChannel) && !acctbank.getBoolean("isopenbank")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u5df2\u53d8\u66f4\u4e3a\u7f51\u4e0a\u94f6\u884c\uff0c\u4ed8\u6b3e\u94f6\u884c\u8d26\u53f7\u5fc5\u987b\u5f00\u901a\u7f51\u4e0a\u94f6\u884c\u3002", (String)"RecInfoChgEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject settletype = this.getDynamicObjectProp(info, "aftersettletype", "settletype");
                boolean settleTypeVirtual = BaseDataHelper.isSettleTypeVirtual((DynamicObject)settletype);
                if (settleTypeVirtual) {
                    String afterpaychannel = info.getString("afterpaychannel");
                    if (CasHelper.isEmpty((Object)afterpaychannel) || "".equals(afterpaychannel)) {
                        afterpaychannel = info.getString("paychannel");
                    }
                    if (CasHelper.isEmpty((Object)afterpaychannel) || !PaymentChannelEnum.COUNTER.getValue().equals(afterpaychannel)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u865a\u62df\u7ed3\u7b97\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u67dc\u53f0\u652f\u4ed8\u6e20\u9053", (String)"PayInfoChgEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                DynamicObject payerbank = this.getDynamicObjectProp(info, "afterpayerbank", "payerbank");
                DynamicObject[] payerbankIds = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{VisibleVirtualAcctHelper.virtualBankQf()});
                if (payerbank != null && payerbankIds.length > 0) {
                    long count = Arrays.stream(payerbankIds).map(o -> payerbank.getPkValue().equals(o.getPkValue())).filter(o -> o).count();
                    if (settleTypeVirtual) {
                        if (count == 0L) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u865a\u62df\u7ed3\u7b97\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u865a\u62df\u94f6\u884c", (String)"PayInfoChgEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                    } else if (count > 0L) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u865a\u62df\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u9009\u62e9\u865a\u62df\u94f6\u884c", (String)"PayInfoChgEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                DynamicObject accountbank = this.getDynamicObjectProp(info, "afterpayeracctbank", "payeracctbank");
                DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{VisibleVirtualAcctHelper.virtualAcctQf()});
                if (accountbank != null && ids.length > 0) {
                    long count = Arrays.stream(ids).map(o -> accountbank.getPkValue().equals(o.getPkValue())).filter(o -> o).count();
                    if (settleTypeVirtual) {
                        if (count == 0L) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u865a\u62df\u7ed3\u7b97\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u865a\u62df\u94f6\u884c\u8d26\u6237", (String)"PayInfoChgEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                    } else if (count > 0L) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u865a\u62df\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u9009\u62e9\u865a\u62df\u94f6\u884c\u8d26\u6237", (String)"PayInfoChgEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                long orgId = (org = (DynamicObject)this.getModel().getValue("org")) == null ? 0L : Long.parseLong(org.getPkValue().toString());
                DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)orgId);
                boolean cs103 = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs103");
                Date afterbizdate = (Date)info.get("afterbizdate");
                if (!"submit".equals(key) || cs103 || afterbizdate == null || currentPeriod == null || !afterbizdate.before(currentPeriod.getDate("beginDate"))) continue;
                if ("cas_paybill".equals(sourceType)) {
                    PaymentErrorCode paymentErrorCode = new PaymentErrorCode();
                    throw new KDBizException(paymentErrorCode.BIZDATE_BEFORE_CURRENTPERIOD(), new Object[0]);
                }
                if (!"cas_agentpaybill".equals(sourceType)) continue;
                AgentPayErrorCode agentPayErrorCode = new AgentPayErrorCode();
                throw new KDBizException(agentPayErrorCode.BIZDATE_BEFORE_CURRENTPERIOD(), new Object[0]);
            }
        }
    }

    private DynamicObject getDynamicObjectProp(DynamicObject entry, String afterProp, String beforeProp) {
        DynamicObject dynamicObject = entry.getDynamicObject(afterProp);
        if (CasHelper.isEmpty((Object)dynamicObject)) {
            return entry.getDynamicObject(beforeProp);
        }
        return dynamicObject;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyname;
        super.propertyChanged(e);
        switch (keyname = e.getProperty().getName()) {
            case "afterpayeracctbank": {
                DynamicObject newPayAcct = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowPayIndex = e.getChangeSet()[0].getRowIndex();
                this.getModel().setValue("afterpayerbank", null, rowPayIndex);
                if (CasHelper.isEmpty((Object)newPayAcct)) break;
                DynamicObject afterpayerbankObj = newPayAcct.getDynamicObject("bank");
                Long bankId = null;
                if (!CasHelper.isEmpty((Object)afterpayerbankObj)) {
                    bankId = (Long)afterpayerbankObj.getPkValue();
                }
                this.getModel().setValue("afterpayerbank", (Object)bankId, rowPayIndex);
                break;
            }
            case "aftersettletype": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (Objects.nonNull(newValue) && StringUtils.isNotEmpty((CharSequence)newValue.getString("paymentchannel")) && StringUtils.isNotEmpty((CharSequence)newValue.getString("defaultpaymentchannel"))) {
                    this.getModel().setValue("afterpaychannel", (Object)newValue.getString("defaultpaymentchannel"));
                }
                this.setAfterPayerAccountVisible();
                this.setVisible();
                this.setSettletnumberVisible();
            }
        }
    }

    private void setSettletnumberVisible() {
        boolean isHideFlag;
        String chgType = (String)this.getModel().getValue("chgtype");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entrys", this.getModel().getEntryCurrentRowIndex("entrys"));
        if (Objects.isNull(entryRowEntity)) {
            return;
        }
        DynamicObject afterSettleType = entryRowEntity.getDynamicObject("aftersettletype");
        boolean isDraftSettleType = BaseDataHelper.isSettleTypeDraft((DynamicObject)afterSettleType);
        boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)afterSettleType);
        boolean promDraft = BaseDataHelper.isSettleTypeProm((DynamicObject)afterSettleType);
        boolean bl = isHideFlag = EmptyUtil.equals((CharSequence)chgType, (CharSequence)"paychg") && (isDraftSettleType || checkDraft || promDraft);
        if (isHideFlag) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"aftersettletnumber"});
            this.getModel().setValue("aftersettletnumber", null);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"aftersettletnumber"});
        }
    }

    private void setAfterPayerAccountVisible() {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entrys", this.getModel().getEntryCurrentRowIndex("entrys"));
        if (Objects.isNull(entryRowEntity)) {
            return;
        }
        DynamicObject settleType = entryRowEntity.getDynamicObject("settletype");
        DynamicObject afterSettleType = entryRowEntity.getDynamicObject("aftersettletype");
        DynamicObject curSettleType = afterSettleType != null ? afterSettleType : settleType;
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)curSettleType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"afterpayeracctcash"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"afterpayeracctbank"});
            this.getModel().setValue("afterpayeracctbank", null);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"afterpayeracctcash"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"afterpayeracctbank"});
            this.getModel().setValue("afterpayeracctcash", null);
        }
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"payeracctcash"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"payeracctbank"});
            this.getModel().setValue("payeracctbank", null);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"payeracctbank"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"payeracctcash"});
            this.getModel().setValue("payeracctcash", null);
        }
    }

    private void setVisible() {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entrys", this.getModel().getEntryCurrentRowIndex("entrys"));
        if (Objects.isNull(entryRowEntity)) {
            return;
        }
        DynamicObject afterSettleType = entryRowEntity.getDynamicObject("aftersettletype");
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)afterSettleType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"afterpayerbank"});
            this.getModel().setValue("afterpayerbank", null);
            this.getModel().setValue("afterpayeracctbank", null);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"afterpayerbank"});
            this.getModel().setValue("afterpayeracctcash", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName = event.getProperty().getName();
        if ("aftersettletype".equals(propName)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entrys", this.getModel().getEntryCurrentRowIndex("entrys"));
            DynamicObject settleType = entryRowEntity.getDynamicObject("settletype");
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
            if (isDcep) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.DCEP.getValue()));
            } else {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("settlementtype", "!=", (Object)SettleMentTypeEnum.DCEP.getValue()));
            }
        }
    }
}

