/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.entryimport;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class EntryImport
extends AbstractFormPlugin
implements UploadListener {
    private static Log logger = LogFactory.getLog(EntryImport.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnresetfile", "download", "btn_upload"});
        Image fileLabel = (Image)this.getControl("btnupload");
        fileLabel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"filepanel"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control contol = (Control)evt.getSource();
        switch (key = contol.getKey()) {
            case "download": {
                FormShowParameter currShowParameter = this.getView().getFormShowParameter();
                String billFormId = (String)currShowParameter.getCustomParam("BillFormId");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_downloadtemplate");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("BillFormId", (Object)billFormId);
                showParameter.setCustomParam("TemplateType", (Object)"IMPT");
                this.getView().showForm(showParameter);
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"filepanel"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"uploadpanel"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
                break;
            }
            case "btn_upload": {
                this.uploadData();
            }
        }
    }

    private void uploadData() {
        String rowDataString = this.getPageCache().get("rowDatas");
        List rowDatas = (List)SerializationUtils.fromJsonString((String)rowDataString, List.class);
        Object importMethod = this.getModel().getValue("imptmethod");
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("imptmethod", importMethod);
        returnData.put("rowDatas", rowDatas);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        Object[] urls = evt.getUrls();
        String url = (String)urls[0];
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream inputStream = service.getInputStream(url);
        final ArrayList dataIndexes = new ArrayList();
        final ArrayList mustInputIndexes = new ArrayList();
        final StringBuffer errorInfo = new StringBuffer();
        final HashMap title = new HashMap();
        final ArrayList returnData = new ArrayList();
        final String billEntryId = (String)this.getView().getFormShowParameter().getCustomParam("BillEntryId");
        final String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        try {
            new ExcelReader().read(inputStream, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    if (row.getRowNum() == 0) {
                        if (row.isEmpty() || !row.get(Integer.valueOf(0)).equalsIgnoreCase(billEntryId) && !row.get(Integer.valueOf(0)).split(" # ")[1].equalsIgnoreCase(billEntryId) && !row.get(Integer.valueOf(0)).split(" # ")[1].equals(billFormId)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u3002", (String)"EntryImport_01", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        }
                    } else if (row.getRowNum() == 2) {
                        Map rowTitle = row.getData();
                        rowTitle.forEach((index, titleName) -> {
                            if (titleName.startsWith("*")) {
                                mustInputIndexes.add(index);
                            }
                            String titleStr = titleName;
                            if (titleName.contains(" # ")) {
                                titleStr = titleName.split(" # ")[1];
                            }
                            title.put(index, titleStr);
                        });
                    } else if (row.getRowNum() > 1 && !row.isEmpty() && row.getRowNum() != 3) {
                        dataIndexes.add(row.getRowNum());
                        for (Integer index2 : mustInputIndexes) {
                            if (row.get(index2) != null && !"".equals(row.get(index2))) continue;
                            String entryImport_02 = String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u7b2c%s\u884c\u5fc5\u586b\u9879\u3002", (String)"EntryImport_02", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.getRowNum() + 1);
                            errorInfo.append(entryImport_02);
                            break;
                        }
                        HashMap<String, String> dataRow = new HashMap<String, String>();
                        dataRow.put("excelrow", row.getRowNum() + 1 + "");
                        if (title.size() > 0) {
                            title.forEach((index, key) -> dataRow.put((String)key, row.get(index)));
                            returnData.add(dataRow);
                        }
                    }
                }
            });
            if (returnData.size() < 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", (String)"EntryImport_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
                return;
            }
            for (int i = dataIndexes.size() - 1; i > 0; --i) {
                if ((Integer)dataIndexes.get(i) - (Integer)dataIndexes.get(i - 1) > 1) continue;
                dataIndexes.remove(i);
            }
            if (dataIndexes.size() >= 2) {
                StringBuilder sb = new StringBuilder();
                Integer i = 1;
                Integer size = dataIndexes.size();
                Integer first = (Integer)dataIndexes.get(0);
                Integer last = (Integer)dataIndexes.get(i);
                while (i < size) {
                    first = first + 1;
                    sb.append(first + 1).append("\u3001");
                    if (first + 1 != last) continue;
                    if ((i = Integer.valueOf(i + 1)) >= size) break;
                    first = last;
                    last = (Integer)dataIndexes.get(i);
                }
                sb.setLength(sb.length() - 1);
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u4e3a\u7a7a\u7684\u6570\u636e\u884c\uff0c\u8bf7\u5220\u9664\u540e\u518d\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"EntryImport_03", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            HashSet payeeNums = new HashSet(returnData.size());
            HashSet payeebankNums = new HashSet(returnData.size());
            HashSet undflowItemNums = new HashSet(returnData.size());
            FormShowParameter currShowParameter = this.getView().getFormShowParameter();
            String payeetype = (String)currShowParameter.getCustomParam("payeetype");
            for (Map rowData2 : returnData) {
                payeeNums.add(rowData2.get("payee.number"));
                payeebankNums.add(rowData2.get("payeebank.number"));
                undflowItemNums.add(rowData2.get("e_fundflowitem.number"));
            }
            payeeNums.remove(null);
            payeeNums.remove("");
            payeebankNums.remove(null);
            payeebankNums.remove("");
            undflowItemNums.remove(null);
            undflowItemNums.remove("");
            HashSet payeeNames = new HashSet(returnData.size());
            HashSet payeebankNames = new HashSet(returnData.size());
            HashSet undflowItemNames = new HashSet(returnData.size());
            for (Map rowData3 : returnData) {
                payeeNames.add(rowData3.get("payee.name"));
                payeebankNames.add(rowData3.get("payeebank.name"));
                undflowItemNames.add(rowData3.get("e_fundflowitem.name"));
            }
            payeeNames.remove(null);
            payeeNames.remove("");
            payeebankNames.remove(null);
            payeebankNames.remove("");
            undflowItemNames.remove(null);
            undflowItemNames.remove("");
            if (!CasHelper.isEmpty((Object)payeetype) && !"other".equals(payeetype)) {
                DynamicObject[] payeeDyms = BusinessDataServiceHelper.load((String)payeetype, (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", payeeNums), new QFilter("enable", "=", (Object)true)});
                DynamicObject[] payeeNameDyms = BusinessDataServiceHelper.load((String)payeetype, (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("name", "in", payeeNames), new QFilter("enable", "=", (Object)true)});
                for (DynamicObject payeeDym : payeeDyms) {
                    payeeNums.remove(payeeDym.getString("number"));
                }
                for (DynamicObject payeeNameDym : payeeNameDyms) {
                    payeeNames.remove(payeeNameDym.getString("name"));
                }
            }
            DynamicObject[] payeebankDyms = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", payeebankNums), new QFilter("enable", "=", (Object)true)});
            DynamicObject[] payeebankNameDyms = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("name", "in", payeebankNames), new QFilter("enable", "=", (Object)true)});
            for (DynamicObject payeebankDym : payeebankDyms) {
                payeebankNums.remove(payeebankDym.getString("number"));
            }
            for (DynamicObject payeebankNameDym : payeebankNameDyms) {
                payeebankNames.remove(payeebankNameDym.getString("name"));
            }
            DynamicObject[] undflowItemDyms = BusinessDataServiceHelper.load((String)"cas_fundflowitem", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", undflowItemNums), new QFilter("enable", "=", (Object)true)});
            DynamicObject[] undflowItemNameDyms = BusinessDataServiceHelper.load((String)"cas_fundflowitem", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("name", "in", undflowItemNames), new QFilter("enable", "=", (Object)true)});
            for (DynamicObject undflowItemDym : undflowItemDyms) {
                undflowItemNums.remove(undflowItemDym.getString("number"));
            }
            for (DynamicObject undflowItemNameDym : undflowItemNameDyms) {
                undflowItemNames.remove(undflowItemNameDym.getString("name"));
            }
            returnData.forEach(rowData -> {
                String entryImport_12;
                String entryImport_10;
                String entryImport_08;
                DynamicObject e_fundflowitemDyms2;
                DynamicObject payeebankDyms2;
                DynamicObject payeeDyms2;
                DynamicObject[] e_fundflowitemNamesTemp;
                DynamicObject[] payeebankNamesTemp;
                DynamicObject[] payeeNamesTemp;
                if (!CasHelper.isEmpty(rowData.get("payee.name")) && CasHelper.isEmpty(rowData.get("payee.number")) && !CasHelper.isEmpty((DynamicObject[])(payeeNamesTemp = BusinessDataServiceHelper.load((String)payeetype, (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("name", "=", rowData.get("payee.name")), new QFilter("enable", "=", (Object)"1")}))) && payeeNamesTemp.length > 1) {
                    String entryImport_04 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6536\u6b3e\u4eba\u540d\u79f0\u4e0d\u552f\u4e00\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"EntryImport_04", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"));
                    errorInfo.append(entryImport_04);
                }
                if (!CasHelper.isEmpty(rowData.get("payeebank.name")) && CasHelper.isEmpty(rowData.get("payeebank.number")) && !CasHelper.isEmpty((DynamicObject[])(payeebankNamesTemp = BusinessDataServiceHelper.load((String)payeetype, (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("name", "=", rowData.get("payeebank.name")), new QFilter("enable", "=", (Object)"1")}))) && payeebankNamesTemp.length > 1) {
                    String entryImport_13 = String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u6536\u6b3e\u94f6\u884c\u540d\u79f0\u4e0d\u552f\u4e00\uff0c\u4e0d\u80fd\u7528\u8be5\u540d\u79f0\u5bfc\u5165\u3002\n", (String)"EntryImport_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"));
                    errorInfo.append(entryImport_13);
                }
                if (!CasHelper.isEmpty(rowData.get("e_fundflowitem.name")) && CasHelper.isEmpty(rowData.get("e_fundflowitem.number")) && !CasHelper.isEmpty((DynamicObject[])(e_fundflowitemNamesTemp = BusinessDataServiceHelper.load((String)payeetype, (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("name", "=", rowData.get("e_fundflowitem.name")), new QFilter("enable", "=", (Object)"1")}))) && e_fundflowitemNamesTemp.length > 1) {
                    String entryImport_14 = String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u8d44\u91d1\u7528\u9014\u540d\u79f0\u4e0d\u552f\u4e00\uff0c\u4e0d\u80fd\u7528\u8be5\u540d\u79f0\u5bfc\u5165\u3002\n", (String)"EntryImport_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"));
                    errorInfo.append(entryImport_14);
                }
                if (!CasHelper.isEmpty(rowData.get("payee.number")) && !CasHelper.isEmpty(rowData.get("payee.name")) && CasHelper.isEmpty((Object)(payeeDyms2 = BusinessDataServiceHelper.loadSingle((String)payeetype, (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", rowData.get("payee.number")), new QFilter("name", "=", rowData.get("payee.name")), new QFilter("enable", "=", (Object)"1")})))) {
                    String entryImport_05 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6536\u6b3e\u4eba\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u5339\u914d\u3002", (String)"EntryImport_05", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"));
                    errorInfo.append(entryImport_05);
                }
                if (!CasHelper.isEmpty(rowData.get("payeebank.number")) && !CasHelper.isEmpty(rowData.get("payeebank.name")) && CasHelper.isEmpty((Object)(payeebankDyms2 = BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", rowData.get("payeebank.number")), new QFilter("name", "=", rowData.get("payeebank.name")), new QFilter("enable", "=", (Object)"1")})))) {
                    String entryImport_06 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6536\u6b3e\u94f6\u884c\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u5339\u914d\u3002", (String)"EntryImport_06", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"));
                    errorInfo.append(entryImport_06);
                }
                if (!CasHelper.isEmpty(rowData.get("e_fundflowitem.number")) && !CasHelper.isEmpty(rowData.get("e_fundflowitem.name")) && CasHelper.isEmpty((Object)(e_fundflowitemDyms2 = BusinessDataServiceHelper.loadSingle((String)"cas_fundflowitem", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", rowData.get("e_fundflowitem.number")), new QFilter("name", "=", rowData.get("e_fundflowitem.name")), new QFilter("enable", "=", (Object)"1")})))) {
                    String entryImport_07 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8d44\u91d1\u7528\u9014\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u5339\u914d\u3002", (String)"EntryImport_07", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"));
                    errorInfo.append(entryImport_07);
                }
                if (payeeNums.contains(rowData.get("payee.number"))) {
                    entryImport_08 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u6536\u6b3e\u4eba\u201c%2$s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"EntryImport_08", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"), rowData.get("payee.number"));
                    errorInfo.append(entryImport_08);
                }
                if (payeeNames.contains(rowData.get("payee.name"))) {
                    entryImport_08 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u6536\u6b3e\u4eba\u201c%2$s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"EntryImport_08", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"), rowData.get("payee.name"));
                    errorInfo.append(entryImport_08);
                }
                if (payeebankNums.contains(rowData.get("payeebank.number"))) {
                    entryImport_10 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u6536\u6b3e\u94f6\u884c\u201c%2$s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"EntryImport_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"), rowData.get("payeebank.number"));
                    errorInfo.append(entryImport_10);
                }
                if (payeebankNames.contains(rowData.get("payeebank.name"))) {
                    entryImport_10 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u6536\u6b3e\u94f6\u884c\u201c%2$s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"EntryImport_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"), rowData.get("payeebank.name"));
                    errorInfo.append(entryImport_10);
                }
                if (undflowItemNums.contains(rowData.get("e_fundflowitem.number"))) {
                    entryImport_12 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u91d1\u7528\u9014\u201c%2$s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"EntryImport_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"), rowData.get("e_fundflowitem.number"));
                    errorInfo.append(entryImport_12);
                }
                if (undflowItemNames.contains(rowData.get("e_fundflowitem.name"))) {
                    entryImport_12 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u91d1\u7528\u9014\u201c%2$s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"EntryImport_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowData.get("excelrow"), rowData.get("e_fundflowitem.name"));
                    errorInfo.append(entryImport_12);
                }
            });
        }
        catch (KDBizException e) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImport_09", (String)"fi-cas-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            logger.info("EntryImport >>> " + e.getMessage());
            return;
        }
        catch (Exception e) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u5f02\u5e38\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EntryImport_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            logger.info("EntryImport >>> " + e.getMessage());
            return;
        }
        if (errorInfo.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImport_09", (String)"fi-cas-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"filepanel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadpanel"});
        this.getModel().setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
        this.getModel().setValue("filepath", (Object)url);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_upload"});
        String rowDatas = SerializationUtils.toJsonString(returnData);
        this.getPageCache().put("rowDatas", rowDatas);
        logger.info("EntryImport >> " + SerializationUtils.toJsonString((Object)rowDatas));
    }
}

