/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.er.writeback.plugin.agentpay;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.formplugin.er.writeback.plugin.agentpay.factory.WriteBackServiceFactory;
import kd.fi.cas.formplugin.er.writeback.plugin.agentpay.service.AbstractWriteBackService;

public class AgentpayBillWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(AgentpayBillWriteBackPlugin.class);

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        String entityName = e.getSrcMainType().getName();
        AbstractWriteBackService writeBackService = this.getWriteBackService(entityName);
        if (writeBackService == null) {
            logger.warn("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53cd\u5199\u670d\u52a1\uff1a\u539f\u5355\u7c7b\u578b:" + entityName);
            return;
        }
        writeBackService.addKeys(e.getFieldKeys());
    }

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("entry");
        keys.add("e_amount");
        keys.add("sourcebillid");
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        DynamicObject currObject = e.getSrcActiveRow();
        DynamicObject parentObject = (DynamicObject)currObject.getParent();
        String entityName = parentObject.getDataEntityType().getName();
        AbstractWriteBackService writeBackService = this.getWriteBackService(entityName);
        if (writeBackService == null) {
            logger.warn("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53cd\u5199\u670d\u52a1\uff1a\u539f\u5355\u7c7b\u578b:" + parentObject.getDataEntityType().getName());
            return;
        }
        DynamicObject tarObject = e.getTargetActiveRow();
        if (tarObject == null) {
            return;
        }
        DynamicObject tarParentObject = (DynamicObject)tarObject.getParent();
        if (tarParentObject == null) {
            return;
        }
        writeBackService.validator(currObject, tarObject, e);
    }

    private AbstractWriteBackService getWriteBackService(String entityName) {
        AbstractWriteBackService writeBackService = WriteBackServiceFactory.getInstance(entityName, this.getOpType());
        return writeBackService;
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        DynamicObject sourceBill = e.getSrcActiveRow();
        DynamicObject parentObject = (DynamicObject)sourceBill.getParent();
        String entityName = parentObject.getDataEntityType().getName();
        AbstractWriteBackService writeBackService = this.getWriteBackService(entityName);
        if (writeBackService == null) {
            logger.warn("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53cd\u5199\u670d\u52a1\uff1a\u539f\u5355\u7c7b\u578b:" + parentObject.getDataEntityType().getName());
            return;
        }
        DynamicObject targetBill = e.getTargetActiveRow();
        if (targetBill == null) {
            this.changeBillStatus(parentObject);
            return;
        }
        writeBackService.sumBuildAmount(sourceBill, targetBill);
    }

    private void changeBillStatus(DynamicObject parentObject) {
        String entityNumber = parentObject.getDataEntityType().getName();
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entityNumber, (Long[])new Long[]{Long.valueOf(parentObject.getPkValue().toString())});
        if (targetBills == null || targetBills.size() <= 1 || targetBills.get("cas_agentpaybill") == null || ((HashSet)targetBills.get("cas_agentpaybill")).size() <= 1) {
            parentObject.set("billstatus", (Object)"E");
        }
    }
}

