/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.er.writeback.plugin.agentpay.service;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public abstract class AbstractWriteBackService {
    protected static final String E_AMOUNT = "e_amount";
    protected static final String SOURCE_BILL_ID = "sourceentryid";
    protected String opType;
    private static final Log logger = LogFactory.getLog(AbstractWriteBackService.class);

    public void addKeys(List<String> keys) {
        keys.add("buildedamount");
        keys.add("orireceiveamount");
        keys.add("accexchangerate");
        keys.add("billstatusfield");
        keys.add("oriaccbalamount");
        keys.add("accbalamount");
        keys.add("oriaccpayedamount");
        keys.add("accpayedamount");
        keys.add("oriaccnotpayamount");
        keys.add("accnotpayamount");
        keys.add("billstatus");
    }

    public void sumBuildAmount(DynamicObject sourceBill, DynamicObject targetBill) {
        if (this.opType.equals("Save") || this.opType.equals("Draft")) {
            DynamicObject parentBill = (DynamicObject)sourceBill.getParent();
            parentBill.set("billstatus", (Object)"F");
        } else if (this.opType.equals("Delete")) {
            // empty if block
        }
    }

    public void writeBackEntryAmount(DynamicObject sourceBill, DynamicObject targetBill) {
        if (targetBill == null) {
            return;
        }
        if (this.opType.equals("Audit")) {
            String msg = targetBill.getParent() == null ? "" : ((DynamicObject)targetBill.getParent()).getString("billstatus");
            logger.info("targetbill status is :" + msg);
            logger.info("sourcebill id is\uff1a" + sourceBill.getPkValue() + "begin writeback ,writeback amount:" + targetBill.getBigDecimal(E_AMOUNT) + ",payamount is\uff1a" + sourceBill.getBigDecimal("oriaccpayedamount"));
            sourceBill.set("oriaccpayedamount", (Object)sourceBill.getBigDecimal("oriaccpayedamount").add(targetBill.getBigDecimal(E_AMOUNT)));
        } else if (this.opType.equals("UnAudit")) {
            DynamicObject parentTarObject = (DynamicObject)targetBill.getParent();
            if (parentTarObject.getString("billstatus").equals("C")) {
                logger.info("targetbill status is audited:" + parentTarObject.getString("billstatus"));
                return;
            }
            DynamicObject agentPayBill = BusinessDataServiceHelper.loadSingle((Object)parentTarObject.getPkValue(), (String)"cas_agentpaybill");
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"AgentPayBillHelper", (String)"decodeAmountForWriteBack", (Object[])new Object[]{agentPayBill});
            BigDecimal writeBackAmount = this.getWriteBackAmount(agentPayBill, sourceBill.getPkValue());
            logger.info("targetbill status is :" + parentTarObject.getString("billstatus"));
            logger.info("sourecbill id is\uff1a" + sourceBill.getPkValue() + "begin writeoff ,writeoff amount\uff1a" + writeBackAmount + ",payamount is\uff1a" + sourceBill.getBigDecimal("oriaccpayedamount"));
            sourceBill.set("oriaccpayedamount", (Object)sourceBill.getBigDecimal("oriaccpayedamount").subtract(writeBackAmount));
        }
        BigDecimal payedAmount = sourceBill.getBigDecimal("oriaccpayedamount").multiply(sourceBill.getBigDecimal("accexchangerate"));
        sourceBill.set("accpayedamount", (Object)payedAmount);
        sourceBill.set("oriaccbalamount", (Object)sourceBill.getBigDecimal("oriaccpayedamount"));
        sourceBill.set("accbalamount", (Object)sourceBill.getBigDecimal("accpayedamount"));
        sourceBill.set("oriaccnotpayamount", (Object)sourceBill.getBigDecimal("orireceiveamount").subtract(sourceBill.getBigDecimal("oriaccpayedamount")));
        BigDecimal notPayAmount = sourceBill.getBigDecimal("oriaccnotpayamount").multiply(sourceBill.getBigDecimal("accexchangerate"));
        sourceBill.set("accnotpayamount", (Object)notPayAmount);
        if (sourceBill.getBigDecimal("oriaccpayedamount").compareTo(sourceBill.getBigDecimal("orireceiveamount")) == 0) {
            sourceBill.set("billstatusfield", (Object)"G");
        } else {
            sourceBill.set("billstatusfield", (Object)"F");
        }
    }

    private BigDecimal getWriteBackAmount(DynamicObject agentPayBill, Object pkValue) {
        DynamicObjectCollection collection = agentPayBill.getDynamicObjectCollection("entry");
        BigDecimal writeBackAmount = BigDecimal.ZERO;
        for (DynamicObject entry : collection) {
            if (!entry.getString(SOURCE_BILL_ID).equals(pkValue.toString())) continue;
            writeBackAmount = entry.getBigDecimal(E_AMOUNT);
            break;
        }
        return writeBackAmount;
    }

    public void writeBackBillAmount(DynamicObject sourceBill) {
        int payedCount = 0;
        DynamicObject sourceParentBill = (DynamicObject)sourceBill.getParent();
        DynamicObjectCollection coll = ((DynamicObject)sourceBill.getParent()).getDynamicObjectCollection("accountentry");
        try {
            for (DynamicObject dyObject : coll) {
                if (!"G".equals(dyObject.get("billstatusfield"))) continue;
                ++payedCount;
            }
            if (payedCount == coll.size()) {
                sourceParentBill.set("billstatus", (Object)"G");
            } else {
                sourceParentBill.set("billstatus", (Object)"F");
            }
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
        }
    }

    public void validator(DynamicObject sourceBill, DynamicObject targetBill, AfterExcessCheckEventArgs e) {
        boolean reusltFlag;
        DynamicObject parentSourceBill = (DynamicObject)sourceBill.getParent();
        String entityNumber = parentSourceBill.getDataEntityType().getName();
        Map result = BFTrackerServiceHelper.findTargetBills((String)entityNumber, (Long[])new Long[]{Long.valueOf(parentSourceBill.getPkValue().toString())});
        DynamicObject targetParentBill = (DynamicObject)targetBill.getParent();
        String targetEntityNumber = targetParentBill.getDataEntityType().getName();
        Set ids = new HashSet();
        for (Map.Entry entry : result.entrySet()) {
            if (!((String)entry.getKey()).equals(targetEntityNumber)) continue;
            ids = (Set)entry.getValue();
            break;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cas_agentpaybill");
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)type);
        BigDecimal totalBuildAmount = BigDecimal.ZERO;
        for (int i = 0; i < bills.length; ++i) {
            if (bills[i].getPkValue().toString().equals(targetParentBill.getPkValue().toString())) continue;
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"AgentPayBillHelper", (String)"decodeAmountForWriteBack", (Object[])new Object[]{bills[i]});
            DynamicObjectCollection collection = bills[i].getDynamicObjectCollection("entry");
            for (DynamicObject entry : collection) {
                String targetBillStatus = bills[i].getString("billstatus");
                if (!entry.getString(SOURCE_BILL_ID).equals(sourceBill.getPkValue().toString()) || !"ABCDE".contains(targetBillStatus)) continue;
                totalBuildAmount = totalBuildAmount.add(entry.getBigDecimal(E_AMOUNT));
            }
        }
        totalBuildAmount = totalBuildAmount.add(targetBill.getBigDecimal(E_AMOUNT));
        if (("A".equals(targetParentBill.getString("billstatus")) || "B".equals(targetParentBill.getString("billstatus"))) && !(reusltFlag = this.validatorBuildAmount(totalBuildAmount, sourceBill))) {
            e.setExcess(true);
            String payerName = targetBill.getString("payeename");
            e.setMessage(String.format(ResManager.loadKDString((String)"\u4ee3\u53d1\u5206\u5f55%s\u7684\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u7d2f\u52a0\u540e\u8d85\u51fa\u6e90\u62a5\u9500\u5355\u5bf9\u5e94\u5206\u5f55\u7684\u6536\u6b3e\u91d1\u989d\uff0c\u63d0\u4ea4\u5931\u8d25", (String)"AbstractWriteBackService_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), payerName));
        }
    }

    public abstract boolean validatorBuildAmount(BigDecimal var1, DynamicObject var2);
}

