/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.er.writeback.plugin.agentpay.service;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.formplugin.er.writeback.plugin.agentpay.service.AbstractWriteBackService;

public class DailyLoanBillWriteBackService
extends AbstractWriteBackService {
    private static final Log logger = LogFactory.getLog(DailyLoanBillWriteBackService.class);

    public DailyLoanBillWriteBackService(String opType) {
        this.opType = opType;
    }

    @Override
    public void addKeys(List<String> keys) {
        super.addKeys(keys);
        keys.add("payAmount");
        keys.add("approveamount");
        keys.add("balanceamount");
        keys.add("notpayamount");
    }

    @Override
    public void sumBuildAmount(DynamicObject sourceBill, DynamicObject targetBill) {
        super.sumBuildAmount(sourceBill, targetBill);
    }

    @Override
    public void writeBackEntryAmount(DynamicObject sourceBill, DynamicObject targetBill) {
        super.writeBackEntryAmount(sourceBill, targetBill);
    }

    @Override
    public void writeBackBillAmount(DynamicObject sourceBill) {
        super.writeBackBillAmount(sourceBill);
        BigDecimal billPayedAmount = BigDecimal.ZERO;
        DynamicObjectCollection coll = ((DynamicObject)sourceBill.getParent()).getDynamicObjectCollection("accountentry");
        try {
            for (DynamicObject dyObject : coll) {
                if (sourceBill.getPkValue().toString().equals(dyObject.getPkValue().toString())) {
                    billPayedAmount = billPayedAmount.add(sourceBill.getBigDecimal("accpayedamount"));
                    continue;
                }
                billPayedAmount = billPayedAmount.add(dyObject.getBigDecimal("accpayedamount"));
            }
            DynamicObject sourceParentBill = (DynamicObject)sourceBill.getParent();
            sourceParentBill.set("payamount", (Object)billPayedAmount);
            sourceParentBill.set("balanceamount", (Object)billPayedAmount);
            sourceParentBill.set("notpayamount", (Object)sourceParentBill.getBigDecimal("approveamount").subtract(billPayedAmount));
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
        }
    }

    @Override
    public void validator(DynamicObject sourceBill, DynamicObject targetBill, AfterExcessCheckEventArgs e) {
        super.validator(sourceBill, targetBill, e);
    }

    @Override
    public boolean validatorBuildAmount(BigDecimal totalBuildAmount, DynamicObject sourceBill) {
        return totalBuildAmount.compareTo(sourceBill.getBigDecimal("orireceiveamount")) <= 0;
    }
}

