/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.exchangebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class ExchangeBillEdit
extends BillEditPlugin
implements ClickListener {
    private static final String CONFIRM_DELBOTP_CALLBACK = "CONFIRM_DELBOTP_CALLBACK";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.accountClickFilter();
        this.currencyFilter();
    }

    private void accountClickFilter() {
        for (String accountName : this.getAccountTypeList()) {
            BasedataEdit accountF7 = (BasedataEdit)this.getControl(accountName);
            accountF7.addBeforeF7SelectListener(beforeF7SelectEvent -> this.queryAccount(accountName, beforeF7SelectEvent));
        }
    }

    private void queryAccount(String accountName, BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String currencyField = "";
        switch (accountName.toLowerCase(Locale.ENGLISH)) {
            case "buyingaccount": {
                currencyField = "buyingcurrency";
                break;
            }
            case "sellingaccount": {
                currencyField = "sellingcurrency";
                break;
            }
            case "paycommissionaccount": {
                currencyField = "commissioncurrency";
            }
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue(currencyField);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (org != null) {
            QFilter[] usableAccountFilter = null;
            if ("bd_accountbanks".equals(this.getModel().getValue("accounttype"))) {
                filters.add(new QFilter("acctstatus", "<>", (Object)BankAcctStatusEnum.CLOSED.getValue()));
                filters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            } else if ("cas_accountcash".equals(this.getModel().getValue("accounttype"))) {
                usableAccountFilter = AccountCashHelper.getUsableAccountFilter((Long)org.getLong("id"));
            }
            if (!CasHelper.isEmpty(usableAccountFilter)) {
                filters.addAll(Arrays.asList(usableAccountFilter));
            }
            if (currency != null) {
                filters.add(new QFilter("currency.fbasedataid.id", "=", currency.get("id")));
            }
            showParameter.getListFilterParameter().setQFilters(filters);
            showParameter.setCustomParam("filterTransferViewOrg", (Object)"1");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) || "sumbit".equals(operateKey)) {
            Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
            Set newsrcBill = CasBotpHelper.getSrcBillByDestBill((Long)pkId, (String)"cas_exchangebill", (String)"bei_transdetail");
            if (CasHelper.isEmpty((Object)newsrcBill)) {
                Set handsrcBill = CasBotpHelper.getSrcBillByDestBill((Long)pkId, (String)"cas_exchangebill", (String)"bei_transdetail_cas");
                Set handRecsrcBill = CasBotpHelper.getSrcBillByDestBill((Long)pkId, (String)"cas_exchangebill", (String)"bei_intelrec");
                Set handPaysrcBill = CasBotpHelper.getSrcBillByDestBill((Long)pkId, (String)"cas_exchangebill", (String)"bei_intelpay");
                if (CasHelper.isNotEmpty((Object)(handsrcBill = HandLinkBillHelper.mergerSet((Set)handsrcBill, (Set)handPaysrcBill, (Set)handRecsrcBill))) && handsrcBill.size() > 0) {
                    DynamicObject[] detailDatas = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id,ishandlink,bankcheckflag,receredtype,isreced,smartmatch,recedbillnumber,autorecorpay,recedbilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)handsrcBill)});
                    QFilter idQf = new QFilter("id", "=", (Object)pkId);
                    Set propertys = EntityPropertyHelper.getPropertys((String)"cas_exchangebill");
                    String fileds = propertys.stream().reduce((a, b) -> a + ',' + b).orElse("id");
                    DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)"cas_exchangebill", (String)fileds, (QFilter[])new QFilter[]{idQf});
                    if (bizBills.length <= 0) {
                        return;
                    }
                    DynamicObject bizBill = bizBills[0];
                    String buybankcheckflag = bizBill.getString("buybankcheckflag");
                    String sellingbankcheckflag = bizBill.getString("sellingbankcheckflag");
                    String feebankcheckflag = bizBill.getString("feebankcheckflag");
                    DynamicObject oldcurrency = bizBill.getDynamicObject("buyingcurrency");
                    DynamicObject oldsellingcurrency = bizBill.getDynamicObject("sellingcurrency");
                    DynamicObject oldcommissioncurrency = bizBill.getDynamicObject("commissioncurrency");
                    DynamicObject newcurrency = (DynamicObject)this.getModel().getValue("buyingcurrency");
                    DynamicObject newsellingcurrency = (DynamicObject)this.getModel().getValue("sellingcurrency");
                    DynamicObject newcommissioncurrency = (DynamicObject)this.getModel().getValue("commissioncurrency");
                    Boolean changed = false;
                    BigDecimal newbuyamount = (BigDecimal)this.getModel().getValue("buyamount");
                    BigDecimal newsellamount = (BigDecimal)this.getModel().getValue("sellamount");
                    BigDecimal newcommissionamount = (BigDecimal)this.getModel().getValue("commissionamount");
                    BigDecimal oldbuyamount = bizBill.getBigDecimal("buyamount");
                    BigDecimal sellamount = bizBill.getBigDecimal("sellamount");
                    BigDecimal oldcommissionamount = bizBill.getBigDecimal("commissionamount");
                    for (DynamicObject detailData : detailDatas) {
                        Boolean amountFlag;
                        Boolean currencyFlag;
                        String bankcheckflag = detailData.getString("bankcheckflag");
                        if (CasHelper.isNotEmpty((Object)buybankcheckflag) && buybankcheckflag.contains(bankcheckflag)) {
                            currencyFlag = HandLinkBillHelper.recognitionBillChange((DynamicObject)oldcurrency, (DynamicObject)newcurrency);
                            amountFlag = HandLinkBillHelper.recognitionBillChange((BigDecimal)newbuyamount, (BigDecimal)oldbuyamount);
                            if (currencyFlag.booleanValue() || amountFlag.booleanValue()) {
                                changed = true;
                                break;
                            }
                        }
                        if (CasHelper.isNotEmpty((Object)sellingbankcheckflag) && sellingbankcheckflag.contains(bankcheckflag)) {
                            currencyFlag = HandLinkBillHelper.recognitionBillChange((DynamicObject)oldsellingcurrency, (DynamicObject)newsellingcurrency);
                            amountFlag = HandLinkBillHelper.recognitionBillChange((BigDecimal)newsellamount, (BigDecimal)sellamount);
                            if (currencyFlag.booleanValue() || amountFlag.booleanValue()) {
                                changed = true;
                                break;
                            }
                        }
                        if (!CasHelper.isNotEmpty((Object)feebankcheckflag) || !feebankcheckflag.contains(bankcheckflag)) continue;
                        currencyFlag = HandLinkBillHelper.recognitionBillChange((DynamicObject)oldcommissioncurrency, (DynamicObject)newcommissioncurrency);
                        amountFlag = HandLinkBillHelper.recognitionBillChange((BigDecimal)newcommissionamount, (BigDecimal)oldcommissionamount);
                        if (!currencyFlag.booleanValue() && !amountFlag.booleanValue()) continue;
                        changed = true;
                        break;
                    }
                    if (changed.booleanValue()) {
                        boolean handnotEmpty = CasHelper.isNotEmpty((Object)handsrcBill);
                        String billnoMesg = "";
                        if (handnotEmpty) {
                            this.getPageCache().put("handlink", JSON.toJSONString((Object)handsrcBill));
                        }
                        DynamicObject[] billnos = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)handsrcBill)});
                        billnoMesg = Arrays.stream(billnos).map(o -> o.getString("billno")).reduce((a, b) -> a + ',' + b).orElse("");
                        if (handnotEmpty) {
                            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u5df2\u5173\u8054\u4e86\u4ea4\u6613\u660e\u7ec6\uff08\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%s\uff09\uff0c\u5982\u9700\u4fee\u6539\u5e01\u79cd\u548c\u91d1\u989d\uff0c\u5c06\u81ea\u52a8\u53d6\u6d88\u4e0e\u4ea4\u6613\u660e\u7ec6\u7684\u5173\u8054\u5173\u7cfb\uff0c\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"HandSelectBillPlugin_3_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), billnoMesg), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_DELBOTP_CALLBACK, (IFormPlugin)this));
                            args.setCancel(true);
                        }
                    }
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6570\u636e\u7531\u4e0a\u6e38\u4ea4\u6613\u660e\u7ec6\u4e0b\u63a8\u751f\u6210\uff0c\u65e0\u6cd5\u4fee\u6539\u91d1\u989d\u4e0e\u5e01\u79cd\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasBillEdit_1_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private List<String> getAccountTypeList() {
        ArrayList<String> accountList = new ArrayList<String>();
        accountList.add("buyingaccount");
        accountList.add("sellingaccount");
        accountList.add("paycommissionaccount");
        return accountList;
    }

    private void currencyFilter() {
        this.currencyClickListener("sellingcurrency", "sellingaccount");
        this.currencyClickListener("commissioncurrency", "paycommissionaccount");
    }

    private void currencyClickListener(String currencyType, String accountType) {
        BasedataEdit buyingCurrencyF7 = (BasedataEdit)this.getControl(currencyType);
        buyingCurrencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject sellingAccount = (DynamicObject)this.getModel().getValue(accountType);
            if (sellingAccount != null) {
                QFilter qFilter;
                if ("bd_accountbanks".equals(this.getModel().getValue("accounttype"))) {
                    qFilter = new QFilter("id", "in", (Object)AccountBankHelper.getCurrencyPks((long)sellingAccount.getLong("id")));
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
                if ("cas_accountcash".equals(this.getModel().getValue("accounttype"))) {
                    qFilter = new QFilter("id", "in", (Object)AccountCashHelper.getCurrencyListByCashAcct((long)sellingAccount.getLong("id")));
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.orgChanged(this.getDynamicObject("org"));
        if (null == this.getDynamicObject("exratetable")) {
            Long orgId = this.getPk("org");
            this.setDefaultExratetable(orgId);
        }
        if (null == this.getValue("exratedate")) {
            this.setValue("exratedate", this.getValue("bizdate"));
        }
    }

    private void orgChanged(DynamicObject org) {
        if (org == null) {
            return;
        }
        if (SystemStatusCtrolHelper.isInitEnable((long)org.getLong("id"))) {
            DynamicObject initOrg = SystemStatusCtrolHelper.getSystemStatusCtrol((long)org.getLong("id"));
            DynamicObject standardCurrency = initOrg.getDynamicObject("standardcurrency");
            this.setValue("basecurrency", standardCurrency);
            this.setValue("buyingcurrency", standardCurrency);
            this.setValue("sellingcurrency", standardCurrency);
            this.setValue("commissioncurrency", standardCurrency);
            this.setValue("commissionexchangerate", BigDecimal.valueOf(1.0));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"commissionexchangerate"});
        }
        this.setOpenOrg();
        if (null == this.getDynamicObject("exratetable")) {
            Long orgId = this.getPk("org");
            this.setDefaultExratetable(orgId);
        }
        if (null == this.getValue("exratedate")) {
            this.setValue("exratedate", this.getValue("bizdate"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "org": {
                this.setOpenOrg();
                break;
            }
            case "buyingcurrency": {
                this.accountClickFilter();
                this.getModel().setValue("buyingaccount", null);
                break;
            }
            case "exchangedate": {
                this.exratedateChanged(newValue);
                break;
            }
            case "sellingcurrency": {
                this.accountClickFilter();
                this.getModel().setValue("sellingaccount", null);
                break;
            }
            case "commissioncurrency": {
                this.accountClickFilter();
                break;
            }
            case "billstatus": {
                this.setToolbarVisible();
            }
            case "sellamount": 
            case "sellingexchangerate": 
            case "salequotation": {
                this.setLocalAmount("sellamount", "buyamount", "sellingexchangerate", "salequotation", false);
                this.setLocalAmount("sellamount", "sellinglocalamount", "sellingexchangerate", "salequotation", true);
                break;
            }
            case "buyamount": 
            case "buyingexchangerate": 
            case "quotation": {
                this.setLocalAmount("buyamount", "buyinglocalamount", "buyingexchangerate", "quotation", true);
                break;
            }
            case "otherquotation": 
            case "commissionamount": 
            case "commissionexchangerate": {
                this.setLocalAmount("commissionamount", "commissionlocalamount", "commissionexchangerate", "otherquotation", true);
                break;
            }
            case "accounttype": {
                this.setMatchFlag(newValue);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        List workflowlist;
        super.afterBindData(e);
        this.setToolbarVisible();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean showConer = true;
        if (customParams.get("showConer") != null) {
            showConer = (Boolean)customParams.get("showConer");
        }
        if (CollectionUtils.isEmpty((Collection)(workflowlist = WorkflowServiceHelper.getAllApprovalRecord((String)this.getModel().getDataEntity().getPkValue().toString()))) || !showConer.booleanValue()) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.right, true);
            control.setCollapse("splitpanelap1", true);
        }
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        DynamicObject exrateTable = (DynamicObject)this.getModel().getValue("exratetable");
        if ("tm_businessbill".equals(sourceBillType) || "tm_rateswap".equals(sourceBillType)) {
            if (null == exrateTable) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"exratedate", "exchangedate"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"exratedate", "exchangedate"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String key = op.getOperateKey();
        if (this.isExchangeBtnVisible(key)) {
            this.setToolbarVisible();
        }
    }

    private boolean isExchangeBtnVisible(String key) {
        return "submit".equals(key) || "audit".equals(key) || "exchange".equals(key) || "cancelexchange".equals(key);
    }

    private void setToolbarVisible() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if ("C".equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_audit", "bar_exchange"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_audit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_unaudit"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_cancelexchange"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_exchange"});
        } else if ("F".equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_exchange"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_exchange"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_cancelexchange"});
        } else if ("B".equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_audit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_audit"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_cancelexchange".equals(itemKey)) {
            this.cancelExc();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (callBackId.equals("CONFIRM_CANCELPAY_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("cancelexchange");
        } else if (StringUtils.equals((CharSequence)callBackId, (CharSequence)CONFIRM_DELBOTP_CALLBACK) && MessageBoxResult.Yes.equals((Object)res)) {
            String handlink = this.getPageCache().get("handlink");
            HandLinkBillHelper.dealHandLinkExChange((String)handlink, (String)"cas_exchangebill", (Object)this.getModel().getDataEntity().getPkValue());
            this.getView().invokeOperation("save");
        }
    }

    private void setMatchFlag(Object newValue) {
        String accountType = (String)newValue;
        if ("cas_accountcash".equals(accountType)) {
            this.getModel().setValue("matchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
            this.getModel().setValue("buymatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
            this.getModel().setValue("sellmatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
        }
    }

    private void cancelExc() {
        String billno = (String)this.getModel().getValue("billno");
        DynamicObject payObj = BusinessDataServiceHelper.loadSingle((String)"cas_exchangebill", (String)"id,billno,isvoucher,billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        if (payObj != null) {
            String billstatus = payObj.getString("billstatus");
            if (!billstatus.equals("F")) {
                this.getView().invokeOperation("cancelexchange");
                return;
            }
            Boolean isv = payObj.getBoolean("isvoucher");
            if (isv.booleanValue()) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u5151\u6362\uff1f", (String)"ExchangeBillEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("cancelexchange");
            }
        }
    }

    private void setLocalAmount(String amountField, String localAmountField, String exchangeRateField, String quotationField, boolean isForce) {
        BigDecimal localamt = this.getBigDecimal(localAmountField);
        if (isForce || BigDecimal.ZERO.compareTo(localamt) == 0) {
            DynamicObject basecurrency = this.getDynamicObject("basecurrency");
            if (CasHelper.isEmpty((Object)basecurrency)) {
                return;
            }
            BigDecimal exchangeRate = this.getBigDecimal(exchangeRateField);
            String quotation = this.getString(quotationField);
            int round = basecurrency.getInt("amtprecision");
            BigDecimal amount = this.getBigDecimal(amountField);
            this.getModel().setValue(localAmountField, (Object)QuotationHelper.callToCurrency((BigDecimal)amount, (BigDecimal)exchangeRate, (String)quotation, (int)round));
        }
    }

    private void exratedateChanged(Object newValue) {
        if (newValue == null) {
            return;
        }
        this.getModel().setValue("exratedate", newValue);
    }

    private void setDefaultExratetable(Long orgId) {
        Long exchangeRateTableId = 0L;
        try {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getModel().setValue("exratetable", (Object)exchangeRateTableId);
    }
}

