/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.exchangebill;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.ManualMatchHelper;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.formplugin.common.AbstractCasBillListPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class ExchangeBillList
extends AbstractCasBillListPlugin {
    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if (this.isTrack()) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if (!"org.number".equals(filterColumn.getFieldName()) && !"billstatus".equals(filterColumn.getFieldName()) && !"bizdate".equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        BillList list = (BillList)this.getView().getControl("billlistap");
        if ("matchdetail".equals(key)) {
            ManualMatchHelper.verifySameOrg((ListSelectedRowCollection)list.getSelectedRows(), (String)"cas_exchangebill", (IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String key = op.getOperateKey();
        if (Arrays.asList("exchange", "cancelexchange", "marknoneedmatch", "cancelmark", "cancelmatch").contains(key)) {
            this.getView().invokeOperation("refresh");
        } else if ("receipt".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Set isAllSet = HandLinkBillHelper.showBotpRtansDetails((ListSelectedRowCollection)selectedRows, (String)"cas_exchangebill");
            List receiptNos = HandLinkBillHelper.getReceiptNoByDetails((ListSelectedRowCollection)selectedRows, (String)"cas_exchangebill");
            String bankcheckflag = HandLinkBillHelper.getBankCheckFlagNoDetail1((ListSelectedRowCollection)selectedRows, (String)"cas_exchangebill");
            if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess() || CasHelper.isNotEmpty((Object)isAllSet) && isAllSet.size() > 0) {
                FormShowParameter para = new FormShowParameter();
                para.setFormId("cas_multitag");
                String appId = "cas".equals(this.getView().getFormShowParameter().getAppId()) ? "cbei" : "bei";
                para.getCustomParams().put("checkRightAppId", appId);
                if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess()) {
                    para.setCustomParam("receiptID", (Object)bankcheckflag);
                    para.setCustomParam("receiptNo", (Object)JSON.toJSONString((Object)receiptNos));
                }
                if (isAllSet.size() > 0) {
                    para.setCustomParam("detailIds", (Object)JSON.toJSONString((Object)isAllSet));
                }
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(para);
            }
        } else if ("matchdetail".equals(key)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            ManualMatchHelper.bizBillMatchDetail((IFormView)this.getView(), (AfterDoOperationEventArgs)afterDoOperationEventArgs, (ListSelectedRowCollection)selectedRows, (IFormPlugin)this, (String)list.getEntityId(), (String)"org,buyingaccount,sellingaccount,buyingcurrency,sellingcurrency");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tblcancelexchange".equalsIgnoreCase(itemKey)) {
            this.cancelExc();
        }
    }

    private void cancelExc() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ExchangeBillList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            LinkedList<Long> paymentBillPks = new LinkedList<Long>();
            for (ListSelectedRow selectedRow : selectedRows) {
                paymentBillPks.add((Long)selectedRow.getPrimaryKeyValue());
            }
            QFilter payPidFilter = new QFilter("id", "in", paymentBillPks);
            DynamicObject[] payobjs = BusinessDataServiceHelper.load((String)"cas_exchangebill", (String)"id,billno,isvoucher,billstatus", (QFilter[])new QFilter[]{payPidFilter});
            StringBuilder sb = new StringBuilder();
            int flag = 0;
            for (DynamicObject obj : payobjs) {
                if (!obj.getBoolean("isvoucher")) continue;
                ++flag;
                String billno = obj.getString("billno");
                sb.append(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\r\n", (String)"ExchangeBillList_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno));
            }
            if (flag == 1) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s,\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u5151\u6362\uff1f", (String)"ExchangeBillList_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1)), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else if (flag > 0) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%d\u4e2a\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u5151\u6362\uff1f", (String)"ExchangeBillList_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), flag), sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("cancelexchange");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CANCELPAY_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("cancelexchange");
        }
        if ("CONFIRM_MANUALMATCH".equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            ManualMatchHelper.confirmBizBillMatchDetail((IFormView)this.getView(), (String)"org,buyingaccount,sellingaccount,buyingcurrency,sellingcurrency");
        }
    }

    public boolean isTrack() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isTrack = formShowParameter.getCustomParam("isTrack");
        return EmptyUtil.isEmpty((Object)isTrack) ? false : (Boolean)isTrack;
    }
}

