/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.enums.BeBillStatusEnum;
import org.apache.commons.lang.ArrayUtils;

public class AgentPluginHelper {
    public static final String AGENT_CHECK_PROS = "id,billno,billstatus,isrepulsed,entry.e_issuccess,entry.e_isrepaid,entry.e_isrefund,entry.id,entry.seq";
    private static final String STATUS_BIT_BACK = "T";

    public static String checkAgentRepayByBankAgentStatus(DynamicObjectCollection repayEntryList) {
        if (CollectionUtils.isEmpty((Collection)repayEntryList)) {
            return null;
        }
        DynamicObject agentPayBill = (DynamicObject)repayEntryList.get(0);
        QFilter filter = new QFilter("sourcebillid", "=", (Object)agentPayBill.getLong("id")).and("billstatus", "=", (Object)STATUS_BIT_BACK);
        Object[] bankAgentBills = BusinessDataServiceHelper.load((String)"bei_bankagentpay", (String)"id,billno,billstatus,createtime,entrys.id,entrys.status,entrys.sourceentryid", (QFilter[])filter.toArray(), (String)"createtime desc", (int)1);
        if (ArrayUtils.isNotEmpty((Object[])bankAgentBills)) {
            DynamicObjectCollection bankAgentEntryList = bankAgentBills[0].getDynamicObjectCollection("entrys");
            ArrayList<String> errMsgList = new ArrayList<String>(repayEntryList.size());
            for (DynamicObject casAgentEntry : repayEntryList) {
                if (casAgentEntry.getBoolean("entry.e_issuccess") || casAgentEntry.getBoolean("entry.e_isrepaid") || casAgentEntry.getBoolean("entry.e_isrefund")) continue;
                List bankEntryList = bankAgentEntryList.stream().filter(b -> b.getLong("sourceentryid") == casAgentEntry.getLong("entry.id")).collect(Collectors.toList());
                String bankBillno = bankAgentBills[0].getString("billno");
                if (bankEntryList.isEmpty()) {
                    errMsgList.add(AgentPluginHelper.buildAgentBankBillErrMsg(casAgentEntry.getInt("entry.seq"), bankBillno, 0));
                    continue;
                }
                for (DynamicObject bankEntry : bankEntryList) {
                    if (BeBillStatusEnum.TF.getValue().equals(bankEntry.getString("status"))) continue;
                    errMsgList.add(AgentPluginHelper.buildAgentBankBillErrMsg(casAgentEntry.getInt("entry.seq"), bankBillno, bankAgentEntryList.indexOf((Object)bankEntry)));
                }
            }
            if (!errMsgList.isEmpty()) {
                return String.join((CharSequence)"\r\n", errMsgList);
            }
        }
        return null;
    }

    private static String buildAgentBankBillErrMsg(int entrySeq, String bankBillno, int bankEntryIdx) {
        String msg = ResManager.loadKDString((String)"\u91cd\u4ed8\u5931\u8d25\u3002\u5206\u5f55\u7b2c%1$s\u884c\uff1a\u4e0d\u6ee1\u8db3\u5931\u8d25\u91cd\u4ed8\u6761\u4ef6\u3002\u5206\u5f55\u201c\u662f\u5426\u6210\u529f\u201d=\u5426\uff0c\u4e14\u5bf9\u5e94\u7684\u94f6\u884c\u4ee3\u53d1\u5355\uff08%2$s\uff09\u5206\u5f55\u884c\uff08\u7b2c%3$s\u884c\uff09\u72b6\u6001\u662f\u4ea4\u6613\u5931\u8d25\uff0c\u624d\u5141\u8bb8\u53d1\u8d77\u5931\u8d25\u91cd\u4ed8\u3002", (String)"CAS-E-430031", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        return String.format(msg, entrySeq, bankBillno, bankEntryIdx + 1);
    }
}

