/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.compare.concurrent.MultiThreadOperationExecutor;
import kd.fi.cas.util.EmptyUtil;

public class UnCheckExportHelper {
    private static final Log logger = LogFactory.getLog(UnCheckExportHelper.class);
    public static final Set<String> BANK_STATEMENT_SELECT_FIELDS = new HashSet<String>(){
        {
            this.add("org");
            this.add("accountbank");
            this.add("currency");
            this.add("bankvouvherno");
            this.add("source");
            this.add("description");
            this.add("bizdate");
            this.add("debitamount");
            this.add("creditamount");
            this.add("oppunit");
            this.add("oppaccountnumber");
            this.add("oppbank");
            this.add("bankcheckflag");
            this.add(String.join((CharSequence)UnCheckExportHelper.FIELD_SEPARATOR, "accountbank", "bank"));
        }
    };
    public static final Set<String> BANK_DAILY_SELECT_FIELDS = new HashSet<String>(){
        {
            this.add("org");
            this.add("accountbank");
            this.add("currency");
            this.add("source");
            this.add("description");
            this.add("bizdate");
            this.add("debitamount");
            this.add("creditamount");
            this.add("oppunit");
            this.add("oppbank");
            this.add("sourcebillnumber");
            this.add("oppacctnumber");
            this.add("bankcheckflag");
            this.add("bookdate");
            this.add(String.join((CharSequence)UnCheckExportHelper.FIELD_SEPARATOR, "accountbank", "bank"));
        }
    };
    private static final String[] EXPORT_FIELD_UNCHECK = new String[]{"org.number", "org.name", "accountbank.name", "accountbank.bankaccountnumber", "accountbank.bank.name", "currency.name", "datatype", "source", "sourcebillnumber", "description", "bizdate", "bookdate", "debitamount", "creditamount", "oppunit", "oppacctnumber", "oppbank", "bankcheckflag"};
    private static Map<String, Map<String, String>> FIELD_MAP = Collections.unmodifiableMap(new HashMap<String, Map<String, String>>(4){
        {
            this.put(UnCheckExportHelper.KEY_BANK_CHECK, new HashMap<String, String>(16){
                {
                    super(x0);
                    this.put("sourcebillnumber", "bankvouvherno");
                    this.put("oppacctnumber", "oppaccountnumber");
                    this.put("bookdate", UnCheckExportHelper.NO_FIELD);
                }
            });
        }
    });
    public static final String KEY_BANK_DAILY = "bankdaily";
    public static final String KEY_BANK_CHECK = "bankcheck";
    private static final String FIELD_SEPARATOR = ".";
    private static final String NO_FIELD = "nofield";
    private static final String DATA_TYPE = "datatype";
    private static final UnCheckExportHelper INSTANCE = new UnCheckExportHelper();
    private static final int BATCH_SIZE = 600;
    private static final int MAX_THREAD_COUNT = 8;

    private UnCheckExportHelper() {
    }

    public static UnCheckExportHelper getInstance() {
        return INSTANCE;
    }

    public void doExprotUnCheckBatch(List<Map<String, Object>> exportEntitySheet, String key, DynamicObject[] dynamicObjects) {
        if (EmptyUtil.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        int length = dynamicObjects.length;
        int threadCount = this.getThreadCount(length);
        if (threadCount == 1) {
            this.doExprotUnCheck(exportEntitySheet, key, dynamicObjects);
            return;
        }
        ExportFile exportFile = new ExportFile(key);
        MultiThreadOperationExecutor multiThreadOperationExecutor = new MultiThreadOperationExecutor();
        List list = multiThreadOperationExecutor.doBatchOperation(Arrays.asList(dynamicObjects), threadCount, (MultiThreadOperationExecutor.MultiThreadOperation)exportFile);
        exportEntitySheet.addAll(list);
    }

    private int getThreadCount(int length) {
        int count;
        int n = count = length / 600 >= 8 ? 8 : length / 600;
        if (count == 0) {
            if (length > 100) {
                return 4;
            }
            return 1;
        }
        if (count < 4) {
            return 4;
        }
        return count;
    }

    public void doExprotUnCheck(List<Map<String, Object>> exportEntitySheet, String key, DynamicObject[] dynamicObjects) {
        this.doExprotUnCheck(exportEntitySheet, key, Arrays.asList(dynamicObjects));
    }

    public void doExprotUnCheck(List<Map<String, Object>> exportEntitySheet, String key, List<DynamicObject> dynamicObjects) {
        if (EmptyUtil.isEmpty(dynamicObjects)) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (Objects.isNull(dynamicObject)) continue;
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(EXPORT_FIELD_UNCHECK.length);
            for (String field : EXPORT_FIELD_UNCHECK) {
                if (DATA_TYPE.equals(field)) {
                    details.put(field, this.getDataType(key));
                    continue;
                }
                String realField = this.getFieldIfMap(field, key);
                if (NO_FIELD.equals(realField)) {
                    details.put(field, "");
                    continue;
                }
                Object value = this.getValue(dynamicObject, realField);
                value = this.covertIfNeed(value, field);
                details.put(field, value);
            }
            DynamicObject currency = dynamicObject.getDynamicObject("currency");
            if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                details.put("amtprecision", currency.getInt("amtprecision"));
            }
            exportEntitySheet.add(details);
        }
    }

    private Object covertIfNeed(Object value, String field) {
        switch (field) {
            case "source": {
                String source = (String)value;
                return this.getSource(source);
            }
        }
        return value;
    }

    private String getSource(String source) {
        switch (source) {
            case "1": {
                return ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165", (String)"UnCheckExportHelper_01", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u5355\u636e\u751f\u6210", (String)"UnCheckExportHelper_02", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u6807\u51c6\u5bfc\u5165", (String)"UnCheckExportHelper_03", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u51ed\u8bc1\u767b\u8d26", (String)"UnCheckExportHelper_04", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private Object getDataType(String key) {
        switch (key) {
            case "bankcheck": {
                return ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355", (String)"UnCheckExportHelper_05", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            case "bankdaily": {
                return ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26", (String)"UnCheckExportHelper_06", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private Object getValue(DynamicObject dynamicObject, String field) {
        Object value = null;
        if (field.contains(FIELD_SEPARATOR)) {
            String[] split = field.split("\\.");
            value = this.getObject(dynamicObject, split[0]);
            String restName = this.getRestName(split);
            if (EmptyUtil.isNoEmpty((String)restName) && value instanceof DynamicObject) {
                DynamicObject dObj = (DynamicObject)value;
                value = this.getValue(dObj, restName);
            }
        } else {
            value = this.getObject(dynamicObject, field);
        }
        return value;
    }

    private Object getObject(DynamicObject dynamicObject, String field) {
        Object value = null;
        try {
            value = dynamicObject.get(field);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    private String getRestName(String[] split) {
        if (split.length == 1) {
            return "";
        }
        if (split.length == 2) {
            return split[split.length - 1];
        }
        CharSequence[] range = Arrays.copyOfRange(split, 1, split.length);
        return String.join((CharSequence)FIELD_SEPARATOR, range);
    }

    private String getFieldIfMap(String field, String key) {
        Map<String, String> stringMap = FIELD_MAP.get(key);
        if (Objects.isNull(stringMap)) {
            return field;
        }
        String name = stringMap.get(field);
        return EmptyUtil.isEmpty((String)name) ? field : name;
    }

    public static String[] getExportUnCheckHeadTitle() {
        return new String[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"UnCheckExportHelper_07", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"UnCheckExportHelper_08", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d26\u6237\u540d\u79f0", (String)"UnCheckExportHelper_09", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"UnCheckExportHelper_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"UnCheckExportHelper_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"UnCheckExportHelper_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"UnCheckExportHelper_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90", (String)"UnCheckExportHelper_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7/\u660e\u7ec6\u6d41\u6c34\u53f7", (String)"UnCheckExportHelper_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6458\u8981", (String)"UnCheckExportHelper_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f/\u4ea4\u6613\u65e5\u671f", (String)"UnCheckExportHelper_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f", (String)"UnCheckExportHelper_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d", (String)"UnCheckExportHelper_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d", (String)"UnCheckExportHelper_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u65b9\u6237\u540d", (String)"UnCheckExportHelper_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u65b9\u8d26\u53f7", (String)"UnCheckExportHelper_22", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u65b9\u5f00\u6237\u884c", (String)"UnCheckExportHelper_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u8d26\u6807\u8bc6\u7801", (String)"UnCheckExportHelper_24", (String)"fi-cas-formplugin", (Object[])new Object[0])};
    }

    static class ExportFile
    implements MultiThreadOperationExecutor.MultiThreadOperation<DynamicObject, Map<String, Object>> {
        private String key;

        public ExportFile(String key) {
            this.key = key;
        }

        public List<Map<String, Object>> doOperation(List<DynamicObject> dataList) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dataList.size());
            INSTANCE.doExprotUnCheck(result, this.key, dataList);
            return result;
        }
    }
}

