/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.formplugin.importplugin.importservice.BaseImportService;
import kd.fi.cas.formplugin.importplugin.importservice.ImportHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;

public class AgentPayBillImportPlugin
implements IImportPlugin {
    private static final String BILLTYPE_SALARY = "cas_agentpaybill_salary_BT_S";
    private static final String BILLTYPE_EXPENSE = "cas_agentpaybill_expense_BT_S";
    private Map<String, Object> importData;
    private ImportHelper importHelper = null;
    private BaseImportService importService;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        try {
            this.importData = data;
            this.importHelper = new ImportHelper("cas_agentpaybill", data);
            this.importService = new BaseImportService("cas_agentpaybill", data, option);
            this.importService.checkBillStatus();
            this.fillDefaultDataAndCheck();
        }
        catch (Exception exc) {
            if (exc instanceof KDBizException) {
                importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            } else {
                importlogs.add(new ImportLogger.ImportLog(ExceptionUtils.getExceptionStackTraceMessage((Exception)exc)));
            }
            return false;
        }
        return true;
    }

    public void fillDefaultDataAndCheck() {
        boolean canUseAccount;
        DynamicObject payerAcctBank;
        DynamicObject org = this.importHelper.loadBasedata("org");
        long orgId = org.getLong("id");
        if (!SystemStatusCtrolHelper.isInitEnable((long)orgId)) {
            this.addErrMessage(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
        }
        if ((payerAcctBank = this.importHelper.loadBasedata("payeracctbank")) != null && !(canUseAccount = AccountBankHelper.canUseAccount((long)orgId, (long)((Long)payerAcctBank.getPkValue())))) {
            this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff08%1$s\uff09\u6ca1\u6709\u94f6\u884c\u8d26\u6237\uff08%2$s\uff09\u7684\u4f7f\u7528\u6743\u6216\u8d26\u6237\u5df2\u7ecf\u9500\u6237\u3002", (String)"AgentPayBillImportPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), org.getString("name"), DynamicObjectHelper.getBasedataNumber((DynamicObject)payerAcctBank)));
        }
        DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
        DynamicObject currency = this.importHelper.loadBasedata("currency");
        DynamicObject exratetable = this.importHelper.loadBasedata("exratetable");
        BigDecimal exchangeRate = this.importHelper.getBigDecimal("exchangerate");
        if (exchangeRate == null || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
            if (currency == null || baseCurrency.getPkValue().equals(currency.getPkValue())) {
                exchangeRate = BigDecimal.ZERO;
            } else {
                Date exratedate = DateUtils.getCurrentDate();
                Object exratedateobj = this.importData.get("exratedate");
                Object bizDate = this.importData.get("bizdate");
                if (exratedateobj != null) {
                    exratedate = DateUtils.stringToDate((String)String.valueOf(exratedateobj), (String)"yyyy-MM-dd");
                } else if (bizDate != null) {
                    exratedate = DateUtils.stringToDate((String)String.valueOf(bizDate), (String)"yyyy-MM-dd");
                }
                exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)currency.getLong("id"), (Long)baseCurrency.getLong("id"), (Long)orgId, (Date)exratedate, (Long)(exratetable == null ? 0L : exratetable.getLong("id")));
            }
            this.importData.put("exchangerate", exchangeRate);
        } else if (currency != null && baseCurrency.getPkValue().equals(currency.getPkValue()) && BigDecimal.ONE.compareTo(exchangeRate) != 0) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5355\u636e\u5e01\u79cd\u4e0e\u7ec4\u7ec7\u672c\u4f4d\u5e01\u76f8\u540c\uff0c\u6c47\u7387\u5e94\u8be5\u4e3a1\u3002", (String)"AgentPayBillImportPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        DynamicObject billType = this.importHelper.loadBasedata("billtype");
        String billTypeNumber = billType.getString("number");
        if (!this.isStrInList(billTypeNumber, BILLTYPE_SALARY, BILLTYPE_EXPENSE)) {
            this.addErrMessage(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u5355\u636e\u7c7b\u578b\uff1a%s\uff0c\u5355\u636e\u7c7b\u578b\u5fc5\u987b\u4e3a\u201c\u62a5\u9500\u652f\u4ed8\u201d\u6216\u8005\u201c\u5de5\u8d44\u652f\u4ed8\u201d\u3002", (String)"AgentPayBillImportPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), billTypeNumber));
        }
        String payeeType = (String)this.importData.get("payeetypelist");
        String payeeTypeMultiBD = (String)this.importData.get("payeetype");
        if (this.importData.containsKey("payeetypelist")) {
            if (!this.isStrInList(payeeType, "other", "bos_user", "bos_org", "bd_supplier", "bd_customer")) {
                this.addErrMessage(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"AgentPayBillImportPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if (null == payeeTypeMultiBD) {
            if (!BILLTYPE_SALARY.equals(billTypeNumber)) {
                payeeType = "other";
            }
        } else {
            payeeType = payeeTypeMultiBD;
        }
        if (BILLTYPE_SALARY.equals(billTypeNumber)) {
            payeeType = "bos_user";
        }
        this.importData.put("payeetypelist", payeeType);
        if (!"other".equals(payeeType)) {
            this.importData.put("payeetype", payeeType);
        }
        JSONArray entry = (JSONArray)this.importData.get("entry");
        for (int i = 0; i < entry.size(); ++i) {
            JSONObject row = (JSONObject)entry.get(i);
            this.setPayeeBankInfo(row, i);
            this.checkPayee(row, i, payeeType);
        }
    }

    private void addErrMessage(String message) {
        throw new KDBizException(message);
    }

    private void checkPayee(JSONObject row, int index, String payeeType) {
        if ("other".equals(payeeType)) {
            if (StringUtils.isBlank((CharSequence)row.getString("payeename"))) {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u6536\u6b3e\u4eba\u5b9e\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPayBillImportPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), index + 1));
            }
        } else {
            JSONObject payeeJson = row.getJSONObject("payee");
            if (payeeJson == null && !this.isStrInList(payeeType, "bos_user", "other")) {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u6536\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPayBillImportPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), index + 1));
            }
        }
    }

    private void setPayeeBankInfo(JSONObject row, int index) {
        JSONObject payeeBankJson = row.getJSONObject("payeebank");
        String payeeBankName = row.getString("payeebankname");
        String acctBankNum = row.getString("payeeacctbank");
        DynamicObject payee = this.importHelper.loadBasedata("payee", index);
        DynamicObject beBank = null;
        if (payeeBankJson != null) {
            beBank = this.importHelper.loadBasedata("payeebank", index);
            if (beBank != null) {
                DynamicObject beBankNew = BusinessDataServiceHelper.loadSingleFromCache((Object)beBank.getPkValue(), (String)"bd_bebank", (String)"union_number,provincetxt,citytxt,country");
                if (StringUtils.isBlank((CharSequence)payeeBankName)) {
                    row.put("payeebankname", (Object)beBank.getString("name"));
                } else if (!payeeBankName.equals(beBank.getString("name"))) {
                    this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u6536\u6b3e\u94f6\u884c\u57fa\u7840\u8d44\u6599\uff08%2$s\uff09\u4e0e\u6536\u6b3e\u94f6\u884c\u540d\u79f0\uff08%3$s\uff09\u4e0d\u5339\u914d\u3002\uff08PS\uff1a\u8f93\u5165\u4e00\u4e2a\u6b63\u786e\u7684\u503c\u5373\u53ef\uff09", (String)"AgentPayBillImportPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), index + 1, beBank.getString("name"), payeeBankName));
                }
                if (StringUtils.isBlank((CharSequence)row.getString("payeebanknumber"))) {
                    row.put("payeebanknumber", (Object)beBankNew.getString("union_number"));
                } else if (!row.getString("payeebanknumber").equals(beBankNew.getString("union_number"))) {
                    this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u884c\u540d\u884c\u53f7\uff08%2$s\uff09\u4e0e\u6536\u6b3e\u94f6\u884c\uff08%3$s\uff09\u4e0d\u5339\u914d\u3002\uff08PS\uff1a\u8f93\u5165\u4e00\u4e2a\u6b63\u786e\u7684\u503c\u5373\u53ef\uff09", (String)"AgentPayBillImportPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), index + 1, row.getString("payeebanknumber"), beBank.getString("name")));
                }
                if (StringUtils.isBlank((CharSequence)row.getString("recprovince"))) {
                    row.put("recprovince", (Object)beBankNew.getString("provincetxt"));
                }
                if (StringUtils.isBlank((CharSequence)row.getString("reccity"))) {
                    row.put("reccity", (Object)beBankNew.getString("citytxt"));
                }
                if (CasHelper.isEmpty((Object)row.get((Object)"reccountry"))) {
                    row.put("reccountry", beBankNew.get("country"));
                }
            }
        } else if (!StringUtils.isBlank((CharSequence)payeeBankName)) {
            beBank = this.getPayeeBankByName(payeeBankName);
            row.put("payeebank", (Object)beBank);
            if (StringUtils.isBlank((CharSequence)row.getString("payeebanknumber")) && beBank != null) {
                row.put("payeebanknumber", (Object)beBank.getString("union_number"));
            }
        } else if (acctBankNum != null && payee != null) {
            String payeetype = (String)this.importData.get("payeetypelist");
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeetype) || AsstActTypeEnum.CUSTOMER.getValue().equals(payeetype)) {
                DynamicObject payeeDY = BusinessDataServiceHelper.loadSingle((Object)payee.getPkValue(), (String)payeetype);
                DynamicObject org = this.importHelper.loadBasedata("org");
                DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)org, (DynamicObject)payeeDY);
                if (internalOrg != null) {
                    this.setBeBankByAcct(row, internalOrg, acctBankNum);
                } else {
                    for (DynamicObject entry : payeeDY.getDynamicObjectCollection("entry_bank")) {
                        if (!acctBankNum.equals(entry.getString("bankaccount"))) continue;
                        row.put("payeebank", (Object)entry.getDynamicObject("bank"));
                        row.put("payeebankname", (Object)entry.getDynamicObject("bank").getString("name"));
                    }
                }
            } else if (AsstActTypeEnum.EMPLOYEE.getValue().equals(payeetype)) {
                QFilter filter = new QFilter("payer", "=", payee.getPkValue()).and("status", "=", (Object)"C").and("payeraccount", "=", (Object)acctBankNum);
                DynamicObject[] payeers = BusinessDataServiceHelper.load((String)"er_payeer", (String)"id,payerbank", (QFilter[])new QFilter[]{filter});
                if (payeers.length == 1) {
                    row.put("payeebank", (Object)payeers[0].getDynamicObject("payerbank"));
                    row.put("payeebankname", (Object)payeers[0].getDynamicObject("payerbank").getString("name"));
                }
            } else if (AsstActTypeEnum.COMPANY.getValue().equals(payeetype)) {
                this.setBeBankByAcct(row, payee, acctBankNum);
            }
        }
    }

    private void setBeBankByAcct(JSONObject row, DynamicObject payee, String acctBankNumber) {
        QFilter[] accountFilter = AccountBankHelper.getUsableAccountFilter((long)((Long)payee.getPkValue()));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(accountFilter));
        filters.add(new QFilter("bankaccountnumber", "=", (Object)acctBankNumber));
        DynamicObject[] accountbanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank.name", (QFilter[])filters.toArray(new QFilter[0]));
        if (accountbanks != null && accountbanks.length > 0) {
            row.put("payeebankname", (Object)accountbanks[0].getString("bank.name"));
            DynamicObject bebank = this.getPayeeBankByName(accountbanks[0].getString("bank.name"));
            if (bebank != null) {
                row.put("payeebank", (Object)bebank);
                if (StringUtils.isBlank((CharSequence)row.getString("recbanknumber"))) {
                    row.put("recbanknumber", (Object)bebank.getString("union_number"));
                }
                if (StringUtils.isBlank((CharSequence)row.getString("recprovince"))) {
                    row.put("recprovince", (Object)bebank.getString("provincetxt"));
                }
                if (StringUtils.isBlank((CharSequence)row.getString("reccity"))) {
                    row.put("reccity", (Object)bebank.getString("citytxt"));
                }
                if (CasHelper.isEmpty((Object)row.get((Object)"reccountry"))) {
                    row.put("reccountry", bebank.get("country"));
                }
            }
        }
    }

    private DynamicObject getPayeeBankByName(String payeeBankName) {
        QFilter[] qFilters = new QFilter[]{new QFilter("name", "=", (Object)payeeBankName), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)Character.valueOf('C'))};
        return BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id,name,number,union_number,country,provincetxt,citytxt", (QFilter[])qFilters);
    }

    private boolean isStrInList(String src, String ... strings) {
        for (String str : strings) {
            if (!str.equals(src)) continue;
            return true;
        }
        return false;
    }
}

