/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.formplugin.importplugin.importservice.ImportHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class BanksStatementImport
implements IImportPlugin {
    private static final Log logger = LogFactory.getLog(BanksStatementImport.class);
    private Map<String, Object> importData;
    private ImportHelper service;
    protected static final String NEW = "new";
    protected static final String OVERRIDE = "override";
    protected static final String OVERRIDE_NEW = "overridenew";
    private static final String accountBankFields = "id,name,number,ismulcurrency,defaultcurrency,org,bank,createorg,isvirtual";

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        this.importData = data;
        this.service = new ImportHelper("cas_bankstatement", this.importData);
        try {
            logger.info("\u94f6\u884c\u5bf9\u8d26\u5355\u5bfc\u5165data:" + ((JSONObject)data).toJSONString());
            this.checkImportType(data, option);
            this.verifyData(data);
            this.setDefaultValue();
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                importlogs.add(new ImportLogger.ImportLog(e.getMessage()));
            } else {
                importlogs.add(new ImportLogger.ImportLog(ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
            return false;
        }
        return true;
    }

    private void checkImportType(Map<String, Object> data, Map<String, Object> options) {
        Object importType = options.get("importtype");
        Object keyFields = options.get("KeyFields");
        if (OVERRIDE.equals(String.valueOf(importType)) || OVERRIDE_NEW.equals(String.valueOf(importType))) {
            List overrideField = CasHelper.getOverrideField((Object)keyFields);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(overrideField.size());
            for (String field : overrideField) {
                String property;
                QFilter filter;
                if ("accountbank".equals(field)) {
                    Map accountbankMap = (Map)data.get("accountbank");
                    String propertyAccountbank = (String)accountbankMap.get("importprop");
                    filter = null;
                    filter = "number".equals(propertyAccountbank) ? new QFilter("bankaccountnumber", "=", accountbankMap.get(propertyAccountbank)) : new QFilter(propertyAccountbank, "=", accountbankMap.get(propertyAccountbank));
                    Map accountBank = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{filter});
                    if (accountBank != null) {
                        filters.add(new QFilter("accountbank", "=", ((DynamicObject)accountBank.values().iterator().next()).getPkValue()));
                    }
                } else if ("currency".equals(field)) {
                    Map currencyMap = (Map)data.get("currency");
                    property = (String)currencyMap.get("importprop");
                    filter = new QFilter(property, "=", currencyMap.get(property));
                    Map currency = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter[]{filter});
                    if (currency != null) {
                        filters.add(new QFilter("currency", "=", ((DynamicObject)currency.values().iterator().next()).getPkValue()));
                    }
                } else if ("org".equals(field)) {
                    Map orgMap = (Map)data.get("org");
                    property = (String)orgMap.get("importprop");
                    filter = new QFilter(property, "=", orgMap.get(property));
                    Map org = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{filter});
                    if (org != null) {
                        filters.add(new QFilter("org", "=", ((DynamicObject)org.values().iterator().next()).getPkValue()));
                    }
                } else if (data.get(field) != null) {
                    filters.add(new QFilter(field, "=", data.get(field)));
                }
                if (filters.isEmpty()) continue;
                filters.add(new QFilter("ischeck", "=", (Object)"1").or(new QFilter("isarchive", "=", (Object)"1")));
                boolean exists = QueryServiceHelper.exists((String)"cas_bankstatement", (QFilter[])filters.toArray(new QFilter[0]));
                if (!exists) continue;
                this.throwException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5141\u8bb8\u88ab\u8986\u76d6\uff0c\u5bf9\u8d26\u5355\u5df2\u88ab\u52fe\u5bf9\u6216\u5df2\u5f52\u6863\u3002", (String)"BankStatementDefaultValueDealOp_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]);
            }
        }
    }

    private void setDefaultValue() throws ParseException {
        String strBizDate = (String)this.importData.get("bizdate");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date bizDate = format.parse(strBizDate);
        this.importData.put("createtime", bizDate);
        this.importData.put("modifytime", bizDate);
        String userId = RequestContext.get().getUserId();
        HashMap<String, String> mapUser = new HashMap<String, String>();
        mapUser.put("id", userId);
        this.importData.put("creator", mapUser);
        this.importData.put("modifier", mapUser);
        this.importData.put("auditdate", bizDate);
        this.importData.put("auditor", mapUser);
        this.importData.put("source", "3");
    }

    private void verifyData(Map<String, Object> data) throws ParseException {
        DynamicObject org = this.verifyOrg();
        DynamicObject accountBank = this.verifyAccountBank(org);
        this.verifyCurrency(accountBank);
        this.verifyAmount();
        this.verifyBizDate(org);
    }

    private void verifyAmount() {
        BigDecimal cred;
        BigDecimal debit;
        Object debitamount = this.importData.get("debitamount");
        Object creditamount = this.importData.get("creditamount");
        boolean isDebit = false;
        boolean isCredit = false;
        if (Objects.nonNull(debitamount)) {
            debit = BigDecimal.ZERO;
            try {
                debit = new BigDecimal(String.valueOf(debitamount));
            }
            catch (Exception e) {
                this.throwException(ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d\u4e0d\u4e3a\u6570\u503c\u3002", (String)"BanksStatementImport_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]);
            }
            if (BigDecimal.ZERO.compareTo(debit) != 0) {
                isDebit = true;
            }
        }
        if (Objects.nonNull(creditamount)) {
            cred = BigDecimal.ZERO;
            try {
                cred = new BigDecimal(String.valueOf(creditamount));
            }
            catch (Exception e) {
                this.throwException(ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d\u4e0d\u4e3a\u6570\u503c\u3002", (String)"BanksStatementImport_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]);
            }
            if (BigDecimal.ZERO.compareTo(cred) != 0) {
                isCredit = true;
            }
        }
        if (isDebit && isCredit) {
            this.throwException(ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d\u3001\u8d37\u65b9\u91d1\u989d\u53ea\u80fd\u4e00\u4e2a\u4e0d\u4e3a0\u3002", (String)"BanksStatementImport_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        if (isDebit) {
            debit = new BigDecimal(String.valueOf(this.importData.get("debitamount")));
            if (BigDecimal.ZERO.equals(debit)) {
                this.throwException(ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"BanksStatementImport_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]);
            }
            this.importData.put("direction", "1");
            return;
        }
        if (isCredit) {
            cred = new BigDecimal(String.valueOf(this.importData.get("creditamount")));
            if (BigDecimal.ZERO.equals(cred)) {
                this.throwException(ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"BanksStatementImport_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]);
            }
            this.importData.put("direction", "2");
            return;
        }
        this.throwException(ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d\u3001\u8d37\u65b9\u91d1\u989d\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u4e3a0\u3002", (String)"BanksStatementImport_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]);
    }

    private void verifyBizDate(DynamicObject org) throws ParseException {
        Date periodStartDate;
        String strBizDate;
        SimpleDateFormat format;
        Date imptBizDate;
        long orgID = org.getLong("id");
        DynamicObject startPeriod = SystemStatusCtrolHelper.getStartPeriod((long)orgID);
        if (Objects.isNull(startPeriod)) {
            this.throwException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6ca1\u6709\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BanksStatementImport_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), org.getString("name"));
        }
        if ((imptBizDate = (format = new SimpleDateFormat("yyyy-MM-dd")).parse(strBizDate = (String)this.importData.get("bizdate"))).before(periodStartDate = startPeriod.getDate("begindate"))) {
            this.throwException(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u542f\u7528\u671f\u95f4\u4ee5\u524d\u7684\u6570\u636e\u3002", (String)"BanksStatementImport_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    private DynamicObject verifyOrg() {
        logger.info("\u94f6\u884c\u5bf9\u8d26\u5355\uff1aorg:" + (JSONObject)this.importData.get("org"));
        DynamicObject mainOrg = this.service.loadBasedata("org", 0);
        if (Objects.isNull(mainOrg)) {
            this.throwException(ResManager.loadKDString((String)"\u7cfb\u7edf\u627e\u4e0d\u5230\u7ec4\u7ec7\u201c%s\u201d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BanksStatementImport_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), this.importData.get("org"));
        }
        if (!SystemStatusCtrolHelper.isInitEnable((long)((Long)mainOrg.getPkValue()))) {
            this.throwException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)mainOrg, (String)"name")), new Object[0]);
        }
        return mainOrg;
    }

    private void throwException(String format, Object ... args) {
        String exMsg = String.format(format, args);
        throw new KDBizException(exMsg);
    }

    private void verifyCurrency(DynamicObject accountBank) {
        long accountBankID;
        Set currencyIDSet;
        DynamicObject currency = this.service.loadBasedata("currency", 0);
        if (Objects.isNull(currency)) {
            this.throwException(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5e01\u79cd\u201c%s\u201d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BanksStatementImport_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), this.importData.get("currency"));
        }
        long imptCurrencyID = currency.getLong("id");
        String imptCurrencyName = currency.getString("name");
        String accountBankName = accountBank.getString("name");
        boolean isMulCurrency = accountBank.getBoolean("ismulcurrency");
        DynamicObject defaultCurrency = accountBank.getDynamicObject("defaultcurrency");
        if (!isMulCurrency && Objects.nonNull(defaultCurrency)) {
            long defCurrencyID = defaultCurrency.getLong("id");
            if (imptCurrencyID == defCurrencyID) {
                return;
            }
            this.throwException(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%1$s\u201d\u53ea\u652f\u6301\u5355\u5e01\u79cd\u201c%2$s\u201d\uff0c\u4e0d\u652f\u6301\u5e01\u79cd\u201c%3$s\u201d\u3002", (String)"BanksStatementImport_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), accountBankName, defaultCurrency.getString("name"), imptCurrencyName);
        }
        if ((currencyIDSet = AccountBankHelper.getCurrencyPks((long)(accountBankID = accountBank.getLong("id")))).contains(imptCurrencyID)) {
            return;
        }
        this.throwException(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%1$s\u201d\u4e0d\u652f\u6301\u5e01\u79cd\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BanksStatementImport_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), accountBankName, imptCurrencyName);
    }

    private DynamicObject verifyAccountBank(DynamicObject org) {
        boolean isVirtual;
        long imptOrgID;
        DynamicObject accountBank = this.service.loadBasedata("accountbank", 0, accountBankFields);
        if (Objects.isNull(accountBank)) {
            this.throwException(ResManager.loadKDString((String)"\u7cfb\u7edf\u627e\u4e0d\u5230\u94f6\u884c\u8d26\u6237\u201c%s\u201d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BanksStatementImport_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), this.importData.get("accountbank"));
        }
        long orgId = org.getLong("id");
        DynamicObject imptOrg = accountBank.getDynamicObject("createorg");
        if (imptOrg != null && orgId != (imptOrgID = imptOrg.getLong("id"))) {
            this.throwException(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%1$s\u201d\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0d\u662f\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BanksStatementImport_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), accountBank.getString("name"), org.getString("name"));
        }
        if (isVirtual = accountBank.getBoolean("isvirtual")) {
            this.throwException(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%s\u201d\u7684\u94f6\u884c\u7c7b\u522b\u662f\u865a\u62df\u94f6\u884c\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BanksStatementImport_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), accountBank.getString("name"));
        }
        return accountBank;
    }
}

