/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.journal;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BankJournalPrintPlugin
extends AbstractPrintServicePlugin {
    private static Log logger = LogFactory.getLog(BankJournalPrintPlugin.class);
    private static final String DATACACHEKEY = "SubLedgerRptPrint";
    private static final String ROWDATACACHEKEY = "SubLedgerRptPrint_RowDatas";

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>();
        ReportListModel listModel = null;
        listModel = this.getListModel(e.getPageId());
        if (listModel == null) {
            return;
        }
        int count = listModel.getRowCount();
        if (e.isMainDs()) {
            Optional<DynamicObject> opTitle;
            ReportQueryParam param = listModel.getReportQueryParam();
            StringBuilder title = new StringBuilder();
            String datetype = (String)param.getFilter().getFilterItem("datetype").getValue();
            if (StringUtils.equals((CharSequence)"1", (CharSequence)datetype)) {
                DynamicObject endperiodDy;
                String endperiodStr;
                DynamicObject beginperiodDy = (DynamicObject)param.getFilter().getFilterItem("beginperiod").getValue();
                String beginperiodStr = beginperiodDy.getString("name");
                if (StringUtils.equals((CharSequence)beginperiodStr, (CharSequence)(endperiodStr = (endperiodDy = (DynamicObject)param.getFilter().getFilterItem("endperiod").getValue()).getString("name")))) {
                    title.append(beginperiodStr);
                } else {
                    title.append(beginperiodStr).append("-").append(endperiodStr);
                }
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)datetype)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
                Date beginDate = (Date)param.getFilter().getFilterItem("begindate").getValue();
                String beginString = sdf.format(beginDate);
                Date endDate = (Date)param.getFilter().getFilterItem("enddate").getValue();
                String endString = sdf.format(endDate);
                if (beginDate.compareTo(endDate) == 0) {
                    title.append(beginString);
                } else {
                    title.append(beginString).append("-").append(endString);
                }
            }
            title.append(ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26", (String)"BankJournalPrintPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            DynamicObjectCollection ds = listModel.getRowData(0, count);
            Object[] objs = ds.stream().filter(o -> StringUtils.equals((CharSequence)"3", (CharSequence)o.getString("datatype"))).toArray();
            String orgname = "";
            String accountbank = "";
            String currency = "";
            if (objs.length != 0 && (opTitle = ds.stream().filter(o -> !EmptyUtil.isEmpty((String)o.getString("orgname")) && !EmptyUtil.isEmpty((String)o.getDynamicObject("bankno").getString("number")) && !EmptyUtil.isEmpty((String)o.getDynamicObject("currencyfield").getString("name"))).limit(1L).findFirst()).isPresent()) {
                DynamicObject dyTitle = opTitle.get();
                orgname = dyTitle.getString("orgname");
                accountbank = dyTitle.getDynamicObject("bankno").getString("number");
                currency = dyTitle.getDynamicObject("currencyfield").getString("name");
            }
            DynamicObjectType customDT = new DynamicObjectType();
            customDT.registerProperty("datetype", String.class, (Object)"", false);
            customDT.registerProperty("orgname", String.class, (Object)"", false);
            customDT.registerProperty("accountbank", String.class, (Object)"", false);
            customDT.registerProperty("currency", String.class, (Object)"", false);
            DynamicObject d = new DynamicObject(customDT);
            d.set("datetype", (Object)title.toString());
            d.set("orgname", (Object)orgname);
            d.set("accountbank", (Object)accountbank);
            d.set("currency", (Object)currency);
            dyns.add(d);
            HashMap rowDatas = new HashMap();
            for (DynamicObject dyo : ds) {
                int rowNo = dyo.getInt("fseq");
                ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
                datas.add(dyo);
                rowDatas.put(rowNo, datas);
            }
            ThreadCache.put((Object)ROWDATACACHEKEY, rowDatas);
            e.setDataEntities(dyns);
        } else {
            Map rowDatas = (Map)ThreadCache.get((Object)ROWDATACACHEKEY);
            dyns.clear();
            for (Map.Entry row : rowDatas.entrySet()) {
                List datas = (List)row.getValue();
                DynamicObjectType customDT = new DynamicObjectType();
                customDT.registerProperty("fseq", String.class, (Object)"", false);
                customDT.registerProperty("bizdate", String.class, (Object)"", false);
                customDT.registerProperty("bankno", String.class, (Object)"", false);
                customDT.registerProperty("bookdate", String.class, (Object)"", false);
                customDT.registerProperty("description", String.class, (Object)"", false);
                customDT.registerProperty("debitamount", String.class, (Object)"", false);
                customDT.registerProperty("creditamount", String.class, (Object)"", false);
                customDT.registerProperty("currencyfield", String.class, (Object)"", false);
                customDT.registerProperty("direction", String.class, (Object)"", false);
                customDT.registerProperty("actualbalance", String.class, (Object)"", false);
                customDT.registerProperty("oppunit", String.class, (Object)"", false);
                int temp = 1;
                for (DynamicObject d : datas) {
                    DynamicObject printRow = new DynamicObject(customDT);
                    printRow.set("fseq", (Object)temp);
                    this.handelRow(d, printRow);
                    dyns.add(printRow);
                    ++temp;
                }
            }
            e.setDataEntities(dyns);
        }
    }

    private void handelRow(DynamicObject d, DynamicObject printRow) {
        if (d == null) {
            return;
        }
        try {
            String direction = "";
            Date date = d.getDate("bizdate");
            Date bookdate = d.getDate("bookdate");
            printRow.set("bizdate", (Object)(CasHelper.isEmpty((Object)date) ? "" : DateUtils.formatString((Date)date, (String)"yyyy-MM-dd")));
            printRow.set("bookdate", (Object)(CasHelper.isEmpty((Object)bookdate) ? "" : DateUtils.formatString((Date)bookdate, (String)"yyyy-MM-dd")));
            printRow.set("description", (Object)d.getString("description"));
            DynamicObject bankno = d.getDynamicObject("bankno");
            if (bankno != null) {
                printRow.set("bankno", (Object)bankno.getString("number"));
            }
            BigDecimal debitamount = new BigDecimal(d.getString("debitamount"));
            printRow.set("debitamount", (Object)debitamount.setScale(2, 4));
            BigDecimal creditamount = new BigDecimal(d.getString("creditamount"));
            printRow.set("creditamount", (Object)creditamount.setScale(2, 4));
            direction = d.getString("direction");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)direction)) {
                direction = ResManager.loadKDString((String)"\u501f", (String)"BankJournalPrintPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)direction)) {
                direction = ResManager.loadKDString((String)"\u8d37", (String)"BankJournalPrintPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)"3", (CharSequence)direction)) {
                direction = ResManager.loadKDString((String)"\u5e73", (String)"BankJournalPrintPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            printRow.set("direction", (Object)direction);
            BigDecimal actualbalance = new BigDecimal(d.getString("actualbalance"));
            printRow.set("actualbalance", (Object)actualbalance.setScale(2, 4));
            DynamicObject curr = d.getDynamicObject("currencyfield");
            if (curr != null) {
                printRow.set("currencyfield", (Object)curr.getString("name"));
            }
            printRow.set("oppunit", (Object)d.getString("oppunit"));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private ReportListModel getListModel(String pageId) {
        ReportListModel listModel = null;
        listModel = (ReportListModel)ThreadCache.get((Object)DATACACHEKEY);
        if (listModel == null) {
            ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
            if (view == null) {
                return listModel;
            }
            ReportList list = view.getReportList();
            listModel = (ReportListModel)list.getReportModel();
        }
        return listModel;
    }
}

