/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.journal;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.ObjectField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.report.ReportList;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class CashJournalPrintPluginNew
extends AbstractPrintPlugin {
    private static final String pageHeadCacheKey = "SubLedgerRptPrint_PageHead";
    private static Log logger = LogFactory.getLog(CashJournalPrintPluginNew.class);
    private static final String DATACACHEKEY = "SubLedgerRptPrint";
    private static final String ROWDATACACHEKEY = "SubLedgerRptPrint_RowDatas";

    public void afterLoadData(AfterLoadDataEvent e) {
        super.afterLoadData(e);
        PrtDataSource dataSource = e.getDataSource();
        if (dataSource instanceof MainDataSource) {
            ReportListModel listModel = this.getListModel(((MainDataSource)dataSource).getPageId());
            if (listModel == null) {
                return;
            }
            DynamicObjectCollection ds = listModel.getRowData(0, listModel.getRowCount());
            HashMap<Integer, List<DynamicObject>> rowDatas = new HashMap<Integer, List<DynamicObject>>(1);
            HashMap<Integer, String> pageHeadAccount = new HashMap<Integer, String>(1);
            int key = 1;
            Map<String, List<DynamicObject>> pages = ds.stream().collect(Collectors.groupingBy(o -> this.getPageKey((DynamicObject)o)));
            ArrayList<DataRowSet> dataRows = new ArrayList<DataRowSet>(1);
            for (Map.Entry<String, List<DynamicObject>> page : pages.entrySet()) {
                DataRowSet printRow = new DataRowSet();
                printRow.add("id", (Field)new TextField(key + ""));
                dataRows.add(printRow);
                pageHeadAccount.put(key, page.getKey());
                List<DynamicObject> rows = page.getValue();
                rowDatas.put(key, rows);
                ++key;
            }
            e.setDataRowSets(dataRows);
            ThreadCache.put((Object)ROWDATACACHEKEY, rowDatas);
            ThreadCache.put((Object)pageHeadCacheKey, pageHeadAccount);
        }
    }

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String dataSourceName = dataSource.getDsName();
        List dyns = evt.getCustomDataRows();
        ReportListModel listModel = this.getListModel(dataSource.getPageId());
        if (listModel == null) {
            return;
        }
        int count = listModel.getRowCount();
        if ("reporttitle".equals(dataSourceName)) {
            ReportQueryParam param = listModel.getReportQueryParam();
            StringBuilder title = new StringBuilder();
            String datetype = (String)param.getFilter().getFilterItem("datetype").getValue();
            if (StringUtils.equals((CharSequence)"1", (CharSequence)datetype)) {
                DynamicObject endperiodDy;
                String endperiodStr;
                DynamicObject beginperiodDy = (DynamicObject)param.getFilter().getFilterItem("beginperiod").getValue();
                String beginperiodStr = beginperiodDy.getString("name");
                if (StringUtils.equals((CharSequence)beginperiodStr, (CharSequence)(endperiodStr = (endperiodDy = (DynamicObject)param.getFilter().getFilterItem("endperiod").getValue()).getString("name")))) {
                    title.append(beginperiodStr);
                } else {
                    title.append(beginperiodStr).append("-").append(endperiodStr);
                }
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)datetype)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
                Date beginDate = (Date)param.getFilter().getFilterItem("begindate").getValue();
                String beginString = sdf.format(beginDate);
                Date endDate = (Date)param.getFilter().getFilterItem("enddate").getValue();
                String endString = sdf.format(endDate);
                if (beginDate.compareTo(endDate) == 0) {
                    title.append(beginString);
                } else {
                    title.append(beginString).append("-").append(endString);
                }
            }
            title.append(ResManager.loadKDString((String)"\u73b0\u91d1\u65e5\u8bb0\u8d26", (String)"JournalBaseFormRpt_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            Map pageHeadAccounts = (Map)ThreadCache.get((Object)pageHeadCacheKey);
            String pageKey = (String)pageHeadAccounts.get(Integer.parseInt(dataSource.getPkId().toString()));
            DataRowSet d = this.getHeadFielsValues(listModel, pageKey);
            d.put("datetype", (Field)new TextField(title.toString()));
            dyns.add(d);
        } else if ("reportlist".equals(dataSourceName)) {
            Map rowDatas = (Map)ThreadCache.get((Object)ROWDATACACHEKEY);
            dyns.clear();
            int index = Integer.parseInt(dataSource.getPkId().toString());
            List datas = (List)rowDatas.get(index);
            List fieldList = dataSource.getQueryField();
            int temp = 1;
            for (DynamicObject d : datas) {
                DataRowSet printRow = new DataRowSet();
                printRow.put("fseq", (Field)new IntegerField(Integer.valueOf(temp)));
                this.handelRow(d, printRow);
                this.defaultRow(fieldList, printRow, d);
                dyns.add(printRow);
                ++temp;
            }
        }
    }

    private void defaultRow(List<String> fieldList, DataRowSet printRow, DynamicObject d) {
        for (String field : fieldList) {
            if (printRow.containerKey(field)) continue;
            printRow.put(field, (Field)new ObjectField(d.get(field)));
        }
    }

    private void handelRow(DynamicObject d, DataRowSet printRow) {
        if (d == null) {
            return;
        }
        try {
            String direction = "";
            Date date = d.getDate("bizdate");
            Date bookdate = d.getDate("bookdate");
            printRow.put("bizdate", (Field)new TextField(CasHelper.isEmpty((Object)date) ? "" : DateUtils.formatString((Date)date, (String)"yyyy-MM-dd")));
            printRow.put("bookdate", (Field)new TextField(CasHelper.isEmpty((Object)bookdate) ? "" : DateUtils.formatString((Date)bookdate, (String)"yyyy-MM-dd")));
            printRow.put("description", (Field)new TextField(d.getString("description")));
            printRow.put("acctname", (Field)new TextField(d.getString("acctname")));
            BigDecimal debitamount = new BigDecimal(d.getString("debitamount"));
            printRow.put("debitamount", (Field)new DecimalField(debitamount.setScale(2, 4)));
            BigDecimal creditamount = new BigDecimal(d.getString("creditamount"));
            printRow.put("creditamount", (Field)new DecimalField(creditamount.setScale(2, 4)));
            direction = d.getString("direction");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)direction)) {
                direction = ResManager.loadKDString((String)"\u501f", (String)"BankJournalPrintPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)direction)) {
                direction = ResManager.loadKDString((String)"\u8d37", (String)"BankJournalPrintPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)"3", (CharSequence)direction)) {
                direction = ResManager.loadKDString((String)"\u5e73", (String)"BankJournalPrintPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            printRow.put("direction", (Field)new TextField(direction));
            BigDecimal actualbalance = new BigDecimal(d.getString("actualbalance"));
            printRow.put("actualbalance", (Field)new DecimalField(actualbalance.setScale(2, 4)));
            DynamicObject curr = d.getDynamicObject("currencyfield");
            if (curr != null) {
                printRow.put("currencyfield", (Field)new TextField(curr.getString("name")));
            }
            printRow.put("oppunit", (Field)new TextField(d.getString("oppunit")));
        }
        catch (Exception e) {
            logger.error("\u6253\u5370\u62a5\u9519", (Throwable)e);
        }
    }

    private ReportListModel getListModel(String pageId) {
        Object param;
        ReportListModel listModel = (ReportListModel)ThreadCache.get((Object)DATACACHEKEY);
        if (listModel == null) {
            ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
            if (view == null) {
                return listModel;
            }
            ReportList list = view.getReportList();
            listModel = (ReportListModel)list.getReportModel();
        }
        if ((param = this.getExtParam().get("pageIDForPrint")) != null) {
            String pageIDForPrint = param.toString();
            listModel.setReportTaskResult(listModel.getReportCache().getReportTaskResult(pageIDForPrint, "reportlistap"));
            listModel.setPageId(pageIDForPrint);
        }
        return listModel;
    }

    private String getOrgName(ReportListModel listModel) {
        ReportQueryParam param = listModel.getReportQueryParam();
        String selNode = listModel.getView().getPageCache().get("printselnode");
        if (selNode == null) {
            selNode = "";
        }
        Long orgId = 0L;
        String[] sel_node = selNode.split("-");
        if (sel_node.length >= 2) {
            orgId = Long.valueOf(sel_node[2]);
        }
        DynamicObject orgObj = null;
        Object orgObjTemp = param.getFilter().getFilterItem("org").getValue();
        if (orgObjTemp instanceof DynamicObject) {
            orgObj = (DynamicObject)orgObjTemp;
        }
        if (orgObjTemp instanceof DynamicObjectCollection) {
            DynamicObjectCollection orgCols = (DynamicObjectCollection)orgObjTemp;
            for (DynamicObject orgCol : orgCols) {
                if (0L == orgId) {
                    orgObj = orgCol;
                    break;
                }
                if (orgId.compareTo(orgCol.getLong("id")) != 0) continue;
                orgObj = orgCol;
                break;
            }
        }
        return orgObj == null ? "" : orgObj.getString("name");
    }

    private DataRowSet getHeadFielsValues(ReportListModel listModel, String pageKey) {
        ReportQueryParam param = listModel.getReportQueryParam();
        int count = listModel.getRowCount();
        DynamicObjectCollection ds = listModel.getRowData(0, count);
        String orgname = "";
        String accountbank = "";
        String currency = "";
        Boolean isPrintNull = (Boolean)param.getFilter().getFilterItem("isprintnull").getValue();
        Boolean isPrintAll = (Boolean)this.getExtParam().get("printAll");
        if (isPrintNull == null) {
            isPrintNull = false;
        }
        if (isPrintAll == null) {
            isPrintAll = false;
        }
        if (isPrintNull.booleanValue() || isPrintAll.booleanValue()) {
            String[] page = pageKey.split("!");
            if (page.length > 1) {
                DynamicObject dyTitle;
                String bank_id = page[0];
                String currency_id = page[1];
                if (ds.size() != 0 && (dyTitle = this.getFirstDy(ds, bank_id, currency_id)) != null) {
                    orgname = this.getOrgName(listModel);
                    accountbank = dyTitle.getString("acctname");
                    currency = dyTitle.getDynamicObject("currencyfield").getString("name");
                }
            }
        } else {
            Optional<DynamicObject> opTitle;
            Object[] objs = ds.stream().filter(o -> StringUtils.equals((CharSequence)"3", (CharSequence)o.getString("datatype"))).toArray();
            if (objs.length != 0 && (opTitle = ds.stream().filter(o -> !EmptyUtil.isEmpty((String)o.getString("orgname")) && !EmptyUtil.isEmpty((String)o.getString("acctname")) && !EmptyUtil.isEmpty((String)o.getDynamicObject("currencyfield").getString("name"))).limit(1L).findFirst()).isPresent()) {
                DynamicObject dyTitle = opTitle.get();
                orgname = dyTitle.getString("orgname");
                accountbank = dyTitle.getString("acctname");
                currency = dyTitle.getDynamicObject("currencyfield").getString("name");
            }
        }
        DataRowSet d = new DataRowSet();
        d.put("orgname", (Field)new TextField(orgname));
        d.put("acctname", (Field)new TextField(accountbank));
        d.put("currency", (Field)new TextField(currency));
        return d;
    }

    private String getPageKey(DynamicObject dyo) {
        return dyo.getString("acctname") + "!" + dyo.getLong("currencyfield_id");
    }

    private DynamicObject getFirstDy(DynamicObjectCollection ds, String acctname, String currency_id) {
        if (ds == null) {
            return null;
        }
        for (DynamicObject d : ds) {
            String _currencyid;
            String _acctname = d.getString("acctname") == null ? "" : d.getString("acctname");
            String string = _currencyid = d.getDynamicObject("currencyfield") == null ? "" : d.getDynamicObject("currencyfield").getString("id");
            if (!_acctname.equalsIgnoreCase(acctname) || !_currencyid.equalsIgnoreCase(currency_id)) continue;
            return d;
        }
        return null;
    }
}

