/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.journal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SimpleBeanFactory;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.util.DateUtils;

public class VoucherNotBookListPlugin
extends AbstractListPlugin {
    private VoucherBookHelper voucherBookHelper = (VoucherBookHelper)SimpleBeanFactory.getBean(VoucherBookHelper.class);
    private static final Log logger = LogFactory.getLog(VoucherNotBookListPlugin.class);

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("billno".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObject voucher = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"cas_glvouchernotbook", (String)"id,voucherid");
            String id = voucher.getString("voucherid");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setFormId("gl_voucher");
            showParameter.setPkId((Object)id);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        this.getPageCache().remove("firstDate");
        this.getPageCache().remove("lastDate");
        this.getPageCache().remove("org");
        while (iterator.hasNext()) {
            QFilter filter = (QFilter)iterator.next();
            if ("bookeddate".equals(filter.getProperty())) {
                Object firstFilter = filter.getValue();
                this.getPageCache().put("firstDate", DateUtils.formatString((Date)((Date)firstFilter), (String)"yyyyMMddhhmmss"));
                List nests = filter.getNests(true);
                if (nests.size() == 0) continue;
                Object lastFilter = ((QFilter.QFilterNest)nests.get(0)).getFilter().getValue();
                this.getPageCache().put("lastDate", DateUtils.formatString((Date)((Date)lastFilter), (String)"yyyyMMddhhmmss"));
            }
            if (!filter.getProperty().startsWith("org")) continue;
            Object org = filter.getValue();
            this.getPageCache().put("org", String.valueOf(org));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("check".equals(itemKey)) {
            try {
                this.check();
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u5b8c\u6210", (String)"VoucherNotBookListPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw e;
            }
        }
    }

    public void check() {
        String firstDate = this.getPageCache().get("firstDate");
        String lastDate = this.getPageCache().get("lastDate");
        QFilter filter = new QFilter("ischeck", "in", (Object)new String[]{"b", "c"});
        if (CasHelper.isNotEmpty((Object)firstDate)) {
            filter.and(new QFilter("bookeddate", ">=", (Object)DateUtils.stringToDate((String)firstDate, (String)"yyyyMMddhhmmss")));
        }
        if (CasHelper.isNotEmpty((Object)lastDate)) {
            filter.and(new QFilter("bookeddate", "<", (Object)DateUtils.stringToDate((String)lastDate, (String)"yyyyMMddhhmmss")));
        }
        ListShowParameter showParam = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = showParam.getBillFormId();
        DeleteServiceHelper.delete((String)billFormId, (QFilter[])new QFilter[]{QFilter.isNotNull((String)"org")});
        String orgId = this.getPageCache().get("org");
        if (CasHelper.isNotEmpty((Object)orgId)) {
            this.dealVoucer(Long.parseLong(orgId), billFormId);
            return;
        }
        DataSet voucherDataSet = QueryServiceHelper.queryDataSet((String)"voucherNotBook", (String)"gl_voucher", (String)"org", (QFilter[])new QFilter[]{filter}, null).groupBy(new String[]{"org"}).finish();
        Iterator iterators = voucherDataSet.iterator();
        HashSet<Long> orgs = new HashSet<Long>(10);
        while (iterators.hasNext()) {
            Row row = (Row)iterators.next();
            orgs.add(row.getLong("org"));
        }
        for (Long org : orgs) {
            this.dealVoucer(org, billFormId);
        }
    }

    public void dealVoucer(Long orgId, String billFormId) {
        DynamicObject[] vouchers;
        ArrayList<DynamicObject> voucherNotBookList = new ArrayList<DynamicObject>(16);
        String firstDate = this.getPageCache().get("firstDate");
        String lastDate = this.getPageCache().get("lastDate");
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("ischeck", "in", (Object)new String[]{"b", "c"}));
        if (CasHelper.isNotEmpty((Object)firstDate)) {
            filter.and(new QFilter("bookeddate", ">=", (Object)DateUtils.stringToDate((String)firstDate, (String)"yyyyMMddhhmmss")));
        }
        if (CasHelper.isNotEmpty((Object)lastDate)) {
            filter.and(new QFilter("bookeddate", "<", (Object)DateUtils.stringToDate((String)lastDate, (String)"yyyyMMddhhmmss")));
        }
        for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,org,ischeck,bookeddate,vouchertype,billno,sourcetype,booktype,createtime,entries.account,entries.assgrp", (QFilter[])new QFilter[]{filter})) {
            DynamicObject bookType = voucher.getDynamicObject("booktype");
            if (!this.voucherBookHelper.isMainBookType(bookType)) continue;
            DynamicObjectCollection entry = voucher.getDynamicObjectCollection("entries");
            int books = 0;
            for (DynamicObject row : entry) {
                String accountType;
                DynamicObject account = this.voucherBookHelper.getCasAccount(row);
                if (account == null || !"bd_accountbanks".equals(accountType = account.getDataEntityType().getName()) && !"cas_accountcash".equals(accountType)) continue;
                ++books;
            }
            if (books > 0) {
                DynamicObject[] bankjournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,source,sourcebillid", (QFilter[])new QFilter[]{new QFilter("source", "=", (Object)"4"), new QFilter("sourcebillid", "=", voucher.getPkValue())});
                DynamicObject notBook = BusinessDataServiceHelper.newDynamicObject((String)billFormId);
                if (CasHelper.isEmpty((DynamicObject[])bankjournals)) {
                    notBook.set("isall", (Object)"0");
                } else {
                    if (bankjournals.length >= books) continue;
                    notBook.set("isall", (Object)"1");
                }
                notBook.set("voucherid", voucher.get("id"));
                notBook.set("billno", voucher.get("billno"));
                notBook.set("ischeck", voucher.get("ischeck"));
                notBook.set("bookeddate", voucher.get("bookeddate"));
                DynamicObject org = voucher.getDynamicObject("org");
                if (org != null) {
                    notBook.set("org", org.getPkValue());
                }
                notBook.set("sourcetype", voucher.get("sourcetype"));
                DynamicObject voucherType = voucher.getDynamicObject("vouchertype");
                notBook.set("vouchertype", voucherType.getPkValue());
                voucherNotBookList.add(notBook);
            }
            if (voucherNotBookList.size() != 1000) continue;
            SaveServiceHelper.save((DynamicObject[])voucherNotBookList.toArray(new DynamicObject[0]));
            voucherNotBookList.clear();
        }
        if (voucherNotBookList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])voucherNotBookList.toArray(new DynamicObject[0]));
        }
    }
}

