/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.util.EmptyUtil;

public abstract class AbstractCustomPlugin
extends AbstractFormPlugin {
    private String[] recInfoFileds = new String[]{"recemail", "reccountry", "recprovince", "reccity", "recbankaddress", "recswiftcode", "recroutingnum", "recothercode", "recaddress", "feeactbank", "feecurrency"};

    public abstract String getEntryName();

    public abstract String getEntityName();

    public abstract String getControlFeild();

    public abstract void changedAction();

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.getControlFeild().equals(key)) {
            this.setFieldStyle();
            this.changedAction();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFieldStyle();
    }

    public void setFieldStyle() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject crossTranType = model.getDataEntity().getDynamicObject(this.getControlFeild());
        if (null == crossTranType) {
            return;
        }
        Map<String, String> allProps = this.getAllProps();
        crossTranType = BusinessDataServiceHelper.loadSingle((Object)crossTranType.getPkValue(), (String)"bei_crosstrantype");
        DynamicObjectCollection entrys = crossTranType.getDynamicObjectCollection("entry");
        List<String> proxyBeBankFields = Arrays.asList(PaymentBillPluginHelper.proxyBeBankFields);
        HashMap<String, Boolean> proxyBeBankFieldVis = new HashMap<String, Boolean>();
        for (DynamicObject crossField : entrys) {
            String fieldName = crossField.getString("fieldkey");
            String fieldArea = allProps.get(fieldName);
            if (StringUtil.isEmptyString((String)fieldArea)) continue;
            boolean isEntryFeild = fieldArea.equals("entry");
            boolean isVisible = crossField.getBoolean("issee");
            view.setVisible(Boolean.valueOf(isVisible), new String[]{fieldName});
            if (proxyBeBankFields.contains(fieldName)) {
                proxyBeBankFieldVis.put(fieldName, isVisible);
            }
            if (isVisible) {
                Control fieldControl = this.getControl(fieldName);
                String defaultValue = crossField.getString("defaultvalue");
                if (fieldControl instanceof ComboEdit) {
                    ComboEdit fieldCombox = (ComboEdit)fieldControl;
                    String limitValue = crossField.getString("comboxvalue");
                    String virtValue = null;
                    if (crossField.getBoolean("islimitvalue")) {
                        virtValue = crossField.getString("virtualvalue");
                    }
                    List<ComboItem> conboxItems = this.buildCombox(fieldName, limitValue, virtValue);
                    fieldCombox.setComboItems(conboxItems);
                } else if (fieldControl instanceof BasedataEdit) {
                    defaultValue = crossField.getString("defaultvalueid");
                }
                this.setDefaultValue(defaultValue, isEntryFeild, fieldName, crossField);
                continue;
            }
            List<String> recInfoFiledls = Arrays.asList(this.recInfoFileds);
            if (recInfoFiledls.contains(fieldName)) continue;
            this.setValue(null, isEntryFeild, fieldName);
        }
        this.getPageCache().put("proxyBeBankFieldVisible", SerializationUtils.toJsonString(proxyBeBankFieldVis));
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        Map<String, String> allProps = this.getAllProps();
        DynamicObject crossTranType = this.getModel().getDataEntity().getDynamicObject(this.getControlFeild());
        if (null == crossTranType) {
            return;
        }
        crossTranType = BusinessDataServiceHelper.loadSingle((Object)crossTranType.getPkValue(), (String)"bei_crosstrantype");
        DynamicObjectCollection entrys = crossTranType.getDynamicObjectCollection("entry");
        HashMap<String, DynamicObject> crossFieldMap = new HashMap<String, DynamicObject>();
        for (DynamicObject field : entrys) {
            crossFieldMap.put(field.getString("fieldkey"), field);
        }
        for (Map.Entry<String, String> prop : allProps.entrySet()) {
            String fieldName;
            DynamicObject crossField;
            if (!prop.getValue().equals("entry") || (crossField = (DynamicObject)crossFieldMap.get(fieldName = prop.getKey())) == null || !crossField.getBoolean("issee")) continue;
            Control fieldControl = this.getControl(fieldName);
            String defaultValue = crossField.getString("defaultvalue");
            if (fieldControl instanceof BasedataEdit) {
                defaultValue = crossField.getString("defaultvalueid");
            }
            this.setDefaultValue(defaultValue, true, fieldName, crossField);
        }
    }

    private void setDefaultValue(Object defaultValue, boolean isEntryFeild, String fieldName, DynamicObject entry) {
        IDataModel model = this.getModel();
        if (isEntryFeild) {
            DynamicObjectCollection entryEntity = model.getEntryEntity(this.getEntryName());
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
                int len = entryEntity.size();
                for (int i = 0; i < len; ++i) {
                    Object fieldValue = ((DynamicObject)entryEntity.get(i)).get(fieldName);
                    boolean isBolllean = this.isBooleanProp(fieldName);
                    if (!this.isEmpty(fieldValue) && this.isLegalValue(fieldValue, fieldName, entry) && (!isBolllean || !EmptyUtil.isNoEmpty((Object)defaultValue))) continue;
                    model.setValue(fieldName, defaultValue, i);
                }
            }
        } else {
            Object fieldValue = model.getValue(fieldName);
            boolean isBolllean = this.isBooleanProp(fieldName);
            if (this.isEmpty(fieldValue) || !this.isLegalValue(fieldValue, fieldName, entry) || isBolllean && EmptyUtil.isNoEmpty((Object)defaultValue)) {
                model.setValue(fieldName, defaultValue);
            } else if (this.isDecimalProp(fieldName) && EmptyUtil.isNoEmpty((Object)defaultValue)) {
                model.setValue(fieldName, (Object)new BigDecimal(defaultValue.toString()));
            }
        }
    }

    protected boolean isBooleanProp(String fieldName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        Map allFields = dataEntityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldName);
        return property instanceof BooleanProp;
    }

    protected boolean isDecimalProp(String fieldName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        Map allFields = dataEntityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldName);
        return property instanceof DecimalProp;
    }

    private void setValue(Object value, boolean isEntryFeild, String fieldName) {
        IDataModel model = this.getModel();
        if (isEntryFeild) {
            DynamicObjectCollection entryEntity = model.getEntryEntity(this.getEntryName());
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
                int len = entryEntity.size();
                for (int i = 0; i < len; ++i) {
                    model.setValue(fieldName, value, i);
                }
            }
        } else {
            model.setValue(fieldName, value);
        }
    }

    private boolean isLegalValue(Object value, String fieldName, DynamicObject entry) {
        String virtValue;
        List virtValues;
        Control feildControl = this.getControl(fieldName);
        boolean isLimit = entry.getBoolean("islimitvalue");
        return !(feildControl instanceof ComboEdit) || !isLimit || (virtValues = CollectionUtils.arrayToList((Object)(virtValue = entry.getString("virtualvalue")).split(","))).contains(value);
    }

    private List<ComboItem> buildCombox(String fieldName, String limitValue, String virtValue) {
        ArrayList<String> valueStr = new ArrayList<String>();
        String[] limitValues = limitValue.split(",");
        if (!StringUtil.isEmptyString((String)virtValue)) {
            String[] virtValues = virtValue.split(",");
            block0: for (String kv : virtValues) {
                for (String ltKv : limitValues) {
                    if (!ltKv.startsWith((String)kv + ":")) continue;
                    valueStr.add(ltKv);
                    continue block0;
                }
            }
        } else {
            Stream.of(limitValues).forEach(v -> valueStr.add((String)v));
        }
        ArrayList<ComboItem> comboxItems = new ArrayList<ComboItem>(valueStr.size());
        for (String value : valueStr) {
            String[] keyValues = value.split(":");
            if (keyValues.length < 2) continue;
            String resourceId = "AbstractCustomPlugin_" + fieldName + "_" + keyValues[0];
            LocaleString localeString = new LocaleString(ResManager.loadKDString((String)keyValues[1], (String)resourceId, (String)"fi-cas-formplugin", (Object[])new Object[0]));
            ComboItem item = new ComboItem(localeString, keyValues[0]);
            comboxItems.add(item);
        }
        return comboxItems;
    }

    private Map<String, String> getAllProps() {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        DataEntityPropertyCollection properties = entity.getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                EntryProp p = (EntryProp)property;
                DataEntityPropertyCollection entryProps = p.getDynamicCollectionItemPropertyType().getProperties();
                entryProps.forEach(prop -> fieldMap.put(prop.getName(), "entry"));
                continue;
            }
            fieldMap.put(property.getName(), "head");
        }
        return fieldMap;
    }

    private boolean isEmpty(Object value) {
        return value == null || value instanceof String && value.toString().length() == 0;
    }
}

