/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.errorcode.PayErrorCode;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class InterPayPlanPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.orgInitF7();
        this.payerAcctBankInitF7();
        this.settleTypeF7();
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("interplan");
        filterGrid.setEntityNumber("cas_paybill");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        super.beforeItemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_save": {
                this.getFilter();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFilterCon();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "org": {
                this.getModel().setValue("payeracctbank", null);
                this.getModel().setValue("settletype", null);
                this.getModel().setValue("paymentchannel", null);
                this.getModel().setValue("usage", null);
                break;
            }
            case "payeracctbank": {
                this.getModel().setValue("settletype", null);
                this.getModel().setValue("paymentchannel", null);
                this.getModel().setValue("usage", null);
                this.settleTypeF7();
                this.setPaymentChannelValue((DynamicObject)newValue);
                break;
            }
            case "settletype": {
                DynamicObject acctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
                this.setPaymentChannelValue(acctBank);
            }
        }
    }

    private void setPaymentChannelValue(DynamicObject payerAcctBank) {
        ComboItem item;
        DynamicObject dynamicObject = payerAcctBank;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboEdit paymentChannel = (ComboEdit)this.getControl("paymentchannel");
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(PaymentChannelEnum.COUNTER.getValue());
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.COUNTER.getName(), (String)"PaymentBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        ComboItem selectedItem = comboItem;
        comboItems.add(comboItem);
        DynamicObject settletype = (DynamicObject)this.getModel().getValue("settletype");
        if (null == dynamicObject || settletype != null && "14".equals(settletype.getString("settlementtype"))) {
            paymentChannel.setComboItems(comboItems);
            paymentChannel.selectedStore(comboItem);
            return;
        }
        if (dynamicObject.getBoolean("isopenbank")) {
            item = new ComboItem();
            item.setValue(PaymentChannelEnum.ONLINEBANK.getValue());
            item.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.ONLINEBANK.getName(), (String)"PaymentBillEdit_17", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            selectedItem = item;
            comboItems.add(item);
        }
        if (dynamicObject.getBoolean("issetbankinterface")) {
            item = new ComboItem();
            item.setValue(PaymentChannelEnum.BEI.getValue());
            item.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.BEI.getName(), (String)"PaymentBillEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            selectedItem = item;
            comboItems.add(item);
        }
        paymentChannel.setComboItems(comboItems);
        paymentChannel.selectedStore(selectedItem);
    }

    private void orgInitF7() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_interpayplan", (String)"47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)orgList);
            showParameter.setCustomParam("orgFuncId", (Object)"08");
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    private void payerAcctBankInitF7() {
        Object org = this.getModel().getValue("org");
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("payeracctbank");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (org == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(new PayErrorCode().INTER_PAY_ORGNULL().getMessage());
                return;
            }
            DynamicObject orgDyn = (DynamicObject)org;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            long orgID = orgDyn.getPkValue() == null ? 0L : Long.parseLong(orgDyn.getPkValue().toString());
            QFilter qFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)orgID);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    private void settleTypeF7() {
        Object acctBank = this.getModel().getValue("payeracctbank");
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("settletype");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (acctBank == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(new PayErrorCode().INTER_PAY_SETTLETYPENULL().getMessage());
                return;
            }
            DynamicObject acctBankDyn = (DynamicObject)acctBank;
            DynamicObjectCollection settlementtypes = acctBankDyn.getDynamicObjectCollection("settlementtype");
            ArrayList<Long> setlIds = new ArrayList<Long>();
            for (DynamicObject settlementtype : settlementtypes) {
                setlIds.add(((DynamicObject)settlementtype.get("fbasedataid")).getLong("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (setlIds.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", setlIds);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        });
    }

    private void initFilterCon() {
        FilterCondition filterCondition;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("interplan");
        Object filterCon = this.getModel().getValue("filtercon");
        if (!CasHelper.isEmpty((Object)filterCon) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)String.valueOf(filterCon), FilterCondition.class)) != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    private void getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("interplan");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        if (condition != null) {
            String filter = SerializationUtils.toJsonString((Object)condition);
            this.getModel().setValue("filtercon", (Object)filter);
        }
    }
}

