/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class PayBillDcepBaseEdit
extends BillEditPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_payer_oncode", "flex_payee_oncode", "flex_payer_onname", "flex_payee_onname"});
        this.setInstitUtionCodeVisible();
        DcepConverHelper.initImage((IFormView)this.getView());
        this.setInstitUtionCodeLab();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "settletype": {
                this.changeSettleType();
                break;
            }
            case "payeracctbank": {
                this.synAcctBankInfo();
                break;
            }
            case "institutioncode": 
            case "institutionname": {
                this.setInstitUtionCodeLab();
                break;
            }
            case "businesstype": {
                this.setValue("institutioncode", null);
                this.setValue("institutionname", null);
                this.setInstitUtionCodeVisible();
                DcepConverHelper.initImage((IFormView)this.getView());
                break;
            }
        }
    }

    private void changeSettleType() {
        DynamicObject settleType = this.getDynamicObject("settletype");
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (billtype != null && !BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue()) && !BillTypeConstants.PAYBILL_DCEP.equals(billtype.getPkValue())) {
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
            if (isDcep) {
                PaymentBillPluginHelper.initBusinessType((IFormView)this.getView(), (String[])new String[]{PayBusinessTypeEnum.WALLETUP.getValue(), PayBusinessTypeEnum.WALLETESSAY.getValue(), PayBusinessTypeEnum.WALLETTRANSFER.getValue()});
                this.setValue("businesstype", PayBusinessTypeEnum.WALLETTRANSFER.getValue());
            } else {
                this.setValue("businesstype", null);
            }
        }
    }

    private void synAcctBankInfo() {
        DynamicObject payAccBank;
        String businessType = (String)this.getValue("businesstype");
        DynamicObject settleType = (DynamicObject)this.getValue("settletype");
        boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
        if (isDcep && PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType) && (EmptyUtil.isNoEmpty((DynamicObject)(payAccBank = (DynamicObject)this.getValue("payeracctbank"))) && !payAccBank.getBoolean("iselecpayment") || EmptyUtil.isEmpty((DynamicObject)payAccBank))) {
            this.clearPayAccValue();
        }
    }

    private void clearPayAccValue() {
        this.setValue("payeracctbank", null);
        this.setValue("payerbank", null);
        this.setPayerInfo4Lb();
    }

    private void setPayerInfo4Lb() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        this.getModel().setValue("orgv", (Object)CasHelper.getLocalValue((DynamicObject)org, (String)"name"));
        DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
        String v_payerbanknum = EmptyUtil.isEmpty((DynamicObject)payerAcctBank) ? "" : StringUtils.splitString((String)payerAcctBank.getString("bankaccountnumber"), (int)4, (String)" ");
        ((Label)this.getControl("payerbanknumv")).setText(v_payerbanknum);
        DynamicObject payerBank = (DynamicObject)this.getModel().getValue("payerbank");
        String v_payerbankname = "";
        if (payerBank != null) {
            v_payerbankname = CasHelper.getLocalValue((DynamicObject)payerBank, (String)"name");
        }
        ((Label)this.getControl("payerbanknamev")).setText(v_payerbankname);
    }

    private void setInstitUtionCodeVisible() {
        String businessType = (String)this.getValue("businesstype");
        DynamicObject settleType = this.getDynamicObject("settletype");
        boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
        if (isDcep && PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_payer_oncode", "flex_payer_onname"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_payee_oncode", "flex_payee_onname"});
        } else if (isDcep && (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_payer_oncode", "flex_payer_onname"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_payee_oncode", "flex_payee_onname"});
        }
    }

    private void setInstitUtionCodeLab() {
        String businessType = (String)this.getValue("businesstype");
        DynamicObject settleType = this.getDynamicObject("settletype");
        boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
        if (isDcep && PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
            ((Label)this.getControl("payeroncode")).setText(this.getString("institutioncode"));
            ((Label)this.getControl("payeeoncode")).setText("");
            ((Label)this.getControl("payeronname")).setText(this.getString("institutionname"));
            ((Label)this.getControl("payeeonname")).setText("");
        } else if (isDcep && (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType))) {
            ((Label)this.getControl("payeroncode")).setText("");
            ((Label)this.getControl("payeeoncode")).setText(this.getString("institutioncode"));
            ((Label)this.getControl("payeronname")).setText("");
            ((Label)this.getControl("payeeonname")).setText(this.getString("institutionname"));
        }
    }
}

