/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.QuotationHelper;

public class PayBillExchangeRateEdit
extends BillEditPlugin {
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.reExchangeRate();
        this.reDpExchangeRate();
        this.calculateAmt();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "basecurrency": {
                this.reExchangeRate();
                this.reDpExchangeRate();
            }
        }
    }

    private void reExchangeRate() {
        this.setExchangerateEditable();
    }

    private void reDpExchangeRate() {
        this.setRecExchangerateEditable();
    }

    private void calculateAmt() {
        DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
        String quotation = this.getString("payquotation");
        if (basecurrency == null) {
            return;
        }
        int round = basecurrency.getInt("amtprecision");
        int count = this.getModel().getEntryRowCount("entry");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            BigDecimal discountAmt;
            DynamicObject rowInfo = this.getModel().getEntryRowEntity("entry", i);
            BigDecimal payAmount = rowInfo.getBigDecimal("e_payableamt");
            if (payAmount != null) {
                this.setValue("e_payablelocamt", QuotationHelper.callToCurrency((BigDecimal)payAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            if ((discountAmt = rowInfo.getBigDecimal("e_discountamt")) != null) {
                this.setValue("e_discountlocamt", QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            if (payAmount != null && discountAmt != null) {
                BigDecimal actAmt = payAmount.subtract(discountAmt);
                sumAmt = sumAmt.add(actAmt);
                BigDecimal actLocalAmt = BigDecimal.ZERO;
                actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                sumLocalAmt = sumLocalAmt.add(actLocalAmt);
                this.setValue("e_actamt", actAmt, i);
                this.setValue("e_localamt", actLocalAmt, i);
            }
            this.setValue("e_unsettledamt", payAmount, i);
            this.setValue("e_unlockamt", payAmount, i);
        }
        this.setValue("actpayamt", sumAmt);
        this.setValue("localamt", sumLocalAmt);
        this.calculateDpAmt();
    }

    private void calculateDpAmt() {
        DynamicObject dpcurrency = this.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        DynamicObject currency = this.getDynamicObject("currency");
        String dppayquotation = this.getString("dppayquotation");
        if (dpcurrency == null) {
            return;
        }
        int dppayround = dpcurrency.getInt("amtprecision");
        if (basecurrency == null) {
            return;
        }
        int round = basecurrency.getInt("amtprecision");
        String agreedquotation = this.getString("agreedquotation");
        BigDecimal actPayAmt = this.getBigDecimal("actpayamt");
        if (currency != null) {
            actPayAmt = actPayAmt.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = this.getBigDecimal("localamt");
        BigDecimal agreedRate = this.getBigDecimal("agreedrate");
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        BigDecimal dpAmt = BigDecimal.ZERO;
        dpAmt = QuotationHelper.callToCurrency((BigDecimal)actPayAmt, (BigDecimal)agreedRate, (String)agreedquotation, (int)dppayround);
        BigDecimal dpExchangeRate = this.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = BigDecimal.ZERO;
        dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        this.setValue("dpamt", dpAmt);
        this.setValue("dplocalamt", dpLocalAmt);
        this.setValue("lossamt", localAmt.subtract(dpLocalAmt));
    }

    protected void setExchangerateEditable() {
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"exchangerate"});
        }
    }

    protected void setRecExchangerateEditable() {
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("dpcurrency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"dpexchangerate"});
        }
    }

    protected boolean isBotpCreate() {
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        return !CasHelper.isEmpty((Object)sourceBillType);
    }
}

