/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.fi.cas.enums.SysParamCs1046Enum;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.DateUtils;

public class PayBillPayRatePlugin
extends DynamicFormPlugin {
    private static List<String> notInitPropArr = Collections.singletonList("paydate");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (customParams.containsKey(propName) && !notInitPropArr.contains(propName)) {
                this.setValue(propName, customParams.get(propName));
            }
            if (!"dpexchangerate".equals(propName)) continue;
            this.setValue(propName, null);
        }
        this.setFieldEnable();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnok": {
                Date paydate = (Date)this.getModel().getValue("paydate");
                if (paydate != null && DateUtils.getDiffDays((Date)DateUtils.getCurrentDate(), (Date)paydate) > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PayBillDiffPayPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    String propName = property.getName();
                    Object value = this.getValue(propName);
                    if (value instanceof DynamicObject) {
                        dataMap.put(propName, ((DynamicObject)value).getPkValue());
                        continue;
                    }
                    if (value instanceof Date) {
                        dataMap.put(propName, DateUtils.formatString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    dataMap.put(propName, value);
                }
                dataMap.put("cs1046", StringUtils.join((Object[])this.getSysPrarmCs1046().toArray(new String[0]), (String)","));
                this.getView().returnDataToParent(dataMap);
                this.getView().close();
            }
        }
    }

    private void setFieldEnable() {
        Set<String> cs1046 = this.getSysPrarmCs1046();
        if (!cs1046.contains(SysParamCs1046Enum.PAYDATE.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"paydate"});
        }
    }

    private Set<String> getSysPrarmCs1046() {
        DynamicObject org = this.getDynamicObject("org");
        Set cs1046 = SystemParameterHelper.getParameterComboxs((long)org.getLong("id"), (String)"cs1046");
        if (cs1046.contains(SysParamCs1046Enum.DIFF.getValue())) {
            cs1046.remove(SysParamCs1046Enum.DIFF.getValue());
        }
        if (cs1046.contains(SysParamCs1046Enum.FEE.getValue())) {
            cs1046.remove(SysParamCs1046Enum.FEE.getValue());
        }
        return cs1046;
    }
}

