/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayBillReceiptEditPlugin
extends AbstractBillPlugIn {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("receipt".equals(operateKey)) {
            this.findReceipt(args, operationResult);
        }
    }

    private void findReceipt(AfterDoOperationEventArgs args, OperationResult operationResult) {
        Set isAllSet = HandLinkBillHelper.showBotpRtansDetails((DynamicObject)this.getModel().getDataEntity(), (String)"cas_paybill");
        List<String> receiptNos = HandLinkBillHelper.getReceiptNoByDetails((DynamicObject)this.getModel().getDataEntity(), (String)"cas_paybill");
        String bankcheckflag = HandLinkBillHelper.getBankCheckFlagNoDetail((DynamicObject)this.getModel().getDataEntity(), (String)"cas_paybill");
        if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess() && CasHelper.isNotEmpty((Object)isAllSet) && isAllSet.size() > 0) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("cas_multitag");
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = appId != null && "cas".equals(appId) ? "cbei" : "bei";
            para.getCustomParams().put("checkRightAppId", appId);
            if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess()) {
                receiptNos = this.getBankReceipts(receiptNos);
                String receiptID = args.getOperationResult().getMessage();
                para.setCustomParam("receiptID", (Object)bankcheckflag);
                para.setCustomParam("receiptNo", (Object)JSON.toJSONString(receiptNos));
            }
            if (isAllSet.size() > 0) {
                para.setCustomParam("detailIds", (Object)JSON.toJSONString((Object)isAllSet));
            }
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(para);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355\u3002", (String)"PayBillViewReceiptOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private List<String> getBankReceipts(List<String> receiptNos) {
        DynamicObject accountBankDy = (DynamicObject)this.getModel().getValue("payeracctbank");
        if (accountBankDy != null && (accountBankDy = QueryServiceHelper.queryOne((String)"am_accountbank", (String)"id, finorgtype, authquerpt", (QFilter[])new QFilter[]{new QFilter("id", "=", accountBankDy.getPkValue())})) != null) {
            String finorgType = accountBankDy.getString("finorgtype");
            Boolean authQuerpt = accountBankDy.getBoolean("authquerpt");
            if ("1".equalsIgnoreCase(finorgType) && authQuerpt.booleanValue()) {
                HashSet<Long> ids = new HashSet<Long>();
                long id = (Long)this.getModel().getValue("id");
                ids.add(id);
                Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"queryBankReceiptService", (String)"getBankReceipts", (Object[])new Object[]{ids, Boolean.TRUE});
                if (result != null) {
                    Set bankReceipts = (Set)result;
                    receiptNos.addAll(bankReceipts);
                }
            }
        }
        return receiptNos;
    }
}

