/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.PaymentBillEdit;

public class PayBillSelectCreditEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initCreditBillF7();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("confirm".equals(operateKey) && e.getOperationResult().isSuccess()) {
            DynamicObject creditBill = (DynamicObject)this.getModel().getValue("lettercredit");
            if (creditBill != null) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Object payBillId = formShowParameter.getCustomParam("payBillId");
                String lcBillNo = creditBill.getString("billno");
                HashMap<String, Object> returnData = new HashMap<String, Object>(8);
                returnData.put("paybillid", payBillId);
                returnData.put("lcBillNo", lcBillNo);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4fe1\u7528\u8bc1\u540e\u786e\u5b9a\u3002", (String)"PayBillSelectCreditEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void initCreditBillF7() {
        BasedataEdit creditBillEdit = (BasedataEdit)this.getControl("lettercredit");
        creditBillEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object payBillId = formShowParameter.getCustomParam("payBillId");
            DynamicObject payInfo = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"id,org,payerbank,dpcurrency,actpayamt,payeetype,payeename", (QFilter[])new QFilter[]{new QFilter("id", "=", payBillId)});
            if (payInfo != null) {
                Long orgId = payInfo.getLong("org");
                Long bankId = payInfo.getLong("payerbank");
                Long dpcurrencyId = payInfo.getLong("dpcurrency");
                BigDecimal actPayAmt = payInfo.getBigDecimal("actpayamt");
                String payeeType = payInfo.getString("payeetype");
                String payeeName = payInfo.getString("payeename");
                QFilter qFilter = PaymentBillEdit.lcBizF7Filter(orgId, bankId, dpcurrencyId, actPayAmt, payeeType, payeeName);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setMultiSelect(false);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object payBillId = formShowParameter.getCustomParam("payBillId");
        DynamicObject payBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"id,actpayamt,dpcurrency", (QFilter[])new QFilter[]{new QFilter("id", "=", payBillId)});
        if (payBill != null) {
            BigDecimal payAmt = payBill.getBigDecimal("actpayamt");
            Long currency = payBill.getLong("dpcurrency");
            this.getModel().setValue("payamt", (Object)payAmt);
            this.getModel().setValue("currency", (Object)currency);
        }
        this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5408\u8ba1\u91d1\u989d\uff1a", (String)"PayBillSelectCreditEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield1", (Object)ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5408\u8ba1\u91d1\u989d\uff1a", (String)"PayBillSelectCreditEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "lettercredit": {
                Object creditObj = this.getModel().getValue("lettercredit");
                if (null != creditObj) {
                    DynamicObject creditBill = (DynamicObject)creditObj;
                    this.getModel().setValue("creditamt", (Object)creditBill.getBigDecimal("amount"));
                    break;
                }
                this.getModel().setValue("creditamt", (Object)BigDecimal.ZERO);
                break;
            }
        }
    }
}

