/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayBillSelectDraftEdit
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(PayBillSelectDraftEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initDraftBillF7();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirmop".equals(operateKey) && !this.draftValidate()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("confirmop".equals(operateKey) && e.getOperationResult().isSuccess()) {
            DynamicObjectCollection draftBillColl = (DynamicObjectCollection)this.getModel().getValue("draftbill");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object payBillId = formShowParameter.getCustomParam("payBillId");
            List draftBillIdList = draftBillColl.stream().map(i -> i.get("fbasedataid.id")).collect(Collectors.toList());
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            returnData.put("paybillid", payBillId);
            returnData.put("draftBillIdList", draftBillIdList);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private boolean draftValidate() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashSet<Long> payBillIdSet = new HashSet<Long>(16);
        Object payBillId = formShowParameter.getCustomParam("payBillId");
        if (payBillId instanceof JSONArray) {
            JSONArray payBillIdJsonArr = (JSONArray)payBillId;
            if (null != payBillIdJsonArr) {
                for (Object ob : payBillIdJsonArr) {
                    payBillIdSet.add(Long.parseLong(ob.toString()));
                }
            }
        } else {
            payBillIdSet.add(Long.parseLong(payBillId.toString()));
        }
        BigDecimal payAmount = (BigDecimal)this.getModel().getValue("caspayamounttotal");
        DynamicObjectCollection draftBillColl = (DynamicObjectCollection)this.getModel().getValue("draftbill");
        List draftBillIdList = draftBillColl.stream().map(i -> i.get("fbasedataid.id")).collect(Collectors.toList());
        DynamicObject[] draftDataArr = BusinessDataServiceHelper.load((Object[])draftBillIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payandrecdraft_f7"));
        String needPreRecButNotRecMsg = DraftHelper.getNeedPreRecButNotRec((DynamicObject[])draftDataArr);
        if (EmptyUtil.isNoEmpty((String)needPreRecButNotRecMsg)) {
            this.getView().showTipNotification(needPreRecButNotRecMsg);
            return false;
        }
        BigDecimal billAmount = Arrays.stream(draftDataArr).map(i -> i.getBigDecimal("availableamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (payAmount.compareTo(billAmount) != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7968\u636e\u201c\u7968\u9762\u5408\u8ba1\u91d1\u989d\u201d\u5fc5\u987b\u4e0e\u4ed8\u6b3e\u5904\u7406\u5408\u8ba1\u91d1\u989d\u76f8\u7b49\u3002", (String)"PayBillSelectDraftEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set<Long> receivebillIdSet = Arrays.stream(draftDataArr).filter(e -> "receivebill".equals(e.getString("rptype"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set<String> hasRelatedSet = this.draftIsQuoteCas(receivebillIdSet, payBillIdSet);
        if (null != hasRelatedSet && hasRelatedSet.size() > 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u201c%s\u201d\u5df2\u5173\u8054\u4e86\u4ed8\u6b3e\u5355\u3002", (String)"PayBillSelectDraftEdit_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), hasRelatedSet.toString()));
            return false;
        }
        int payBillCount = payBillIdSet.size();
        if (payBillCount > 1 && draftBillIdList.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u6279\u91cf\u4ed8\u6b3e\u9009\u7968\u4e0d\u652f\u6301\u591a\u9009\u7968\u636e\u3002", (String)"PayBillSelectDraftEdit_0_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Set<String> draftIsQuoteCas(Set<Long> draftIds, Set<Long> payBillIdSet) {
        HashSet<String> draftbillnoSet = new HashSet<String>();
        try {
            if (null == draftIds || draftIds.size() == 0) {
                return draftbillnoSet;
            }
            logger.info("start draftIsQuoteCas");
            QFilter billIdFilter = new QFilter("draftbill.fbasedataid", "in", draftIds);
            QFilter payIdFilter = new QFilter("id", "not in", payBillIdSet);
            DynamicObject[] payObjs = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,draftbill.fbasedataid", (QFilter[])new QFilter[]{payIdFilter, billIdFilter});
            if (null != payObjs && payObjs.length > 0) {
                for (DynamicObject payObj : payObjs) {
                    DynamicObjectCollection draftbillColl = payObj.getDynamicObjectCollection("draftbill");
                    for (DynamicObject draftbill : draftbillColl) {
                        DynamicObject fbasedataid = draftbill.getDynamicObject("fbasedataid");
                        if (fbasedataid == null || !draftIds.contains(fbasedataid.getLong("id"))) continue;
                        String draftbillno = fbasedataid.getString("draftbillno");
                        draftbillnoSet.add(draftbillno);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("draftIsQuoteCas has error:", (Throwable)e);
        }
        return draftbillnoSet;
    }

    private void initDraftBillF7() {
        BigDecimal payAmount = (BigDecimal)this.getModel().getValue("caspayamounttotal");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashSet<Long> payBillIdSet = new HashSet<Long>(16);
        Object payBillId = formShowParameter.getCustomParam("payBillId");
        if (payBillId instanceof JSONArray) {
            JSONArray payBillIdJsonArr = (JSONArray)payBillId;
            if (null != payBillIdJsonArr) {
                for (Object ob : payBillIdJsonArr) {
                    payBillIdSet.add(Long.parseLong(ob.toString()));
                }
            }
        } else {
            payBillIdSet.add(Long.parseLong(payBillId.toString()));
        }
        DynamicObject[] payBillDatas = BusinessDataServiceHelper.load((Object[])payBillIdSet.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
        DynamicObject payBillData = payBillDatas[0];
        DynamicObject org = (DynamicObject)payBillData.get("org");
        Object payeeType = payBillData.get("payeetype");
        Object payeeName = payBillData.get("payeename");
        BasedataEdit draftBillEdit = (BasedataEdit)this.getControl("draftbill");
        draftBillEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Set hasNoReleatedCasPayIdSet;
            DynamicObject currency = (DynamicObject)payBillData.get("currency");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter billHandleFilter = new QFilter(String.join((CharSequence)".", "company", "id"), "=", (Object)org.getLong("id"));
            billHandleFilter.and(new QFilter("payeetypetext", "=", payeeType));
            billHandleFilter.and(new QFilter("beendorsortext", "=", payeeName));
            billHandleFilter.and(new QFilter("tradetype", "=", (Object)"endorse"));
            billHandleFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            DynamicObject[] billHandleDataArr = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"billno,id,entrys,entrys.draftbill", (QFilter[])new QFilter[]{billHandleFilter});
            Set realNeedQueryDraftIdSet = DraftHelper.getCorrectEndorseTRadeDraftId((DynamicObject[])billHandleDataArr);
            QFilter qFilter = new QFilter(String.join((CharSequence)".", "company", "id"), "=", (Object)org.getLong("id"));
            qFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
            if (EmptyUtil.isNoEmpty((BigDecimal)payAmount) && BigDecimal.ZERO.compareTo(payAmount) < 0) {
                qFilter.and(new QFilter("availableamount", "<=", (Object)payAmount));
            }
            qFilter.and(new QFilter("currency", "=", currency.getPkValue()));
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilter.and(new QFilter("draftbillstatus", "=", (Object)"endorsed"));
            qFilter.and(new QFilter("istransfer", "=", (Object)"1"));
            Set hasCasRecIdSet = DraftHelper.getReleatedCasPayBill((QFilter)qFilter, (String)"cdm_receivablebill");
            if (EmptyUtil.isNoEmpty((Object)hasCasRecIdSet)) {
                realNeedQueryDraftIdSet.removeAll(hasCasRecIdSet);
            }
            qFilter.and(new QFilter("id", "in", (Object)realNeedQueryDraftIdSet));
            Object settleType = payBillData.get("settletype");
            if (settleType != null) {
                DynamicObject settleTypeObj = (DynamicObject)settleType;
                List billTypeIdList = DraftHelper.getBillTypeIdList((Object)settleTypeObj.getPkValue(), (String)settleTypeObj.getString("settlementtype"));
                qFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            QFilter nullFilter = QFilter.isNull((String)"billpool");
            qFilter.and(new QFilter("billpool", "=", (Object)0).or(nullFilter));
            Object draftBillColl = this.getModel().getValue("draftbill");
            if (null != draftBillColl) {
                DynamicObjectCollection colls = (DynamicObjectCollection)draftBillColl;
                for (DynamicObject coll : colls) {
                    ids.add(((DynamicObject)coll.get("fbasedataid")).getLong("id"));
                }
            }
            if (ids.size() > 0) {
                qFilter.or(new QFilter("id", "in", ids));
            }
            QFilter payFilter = new QFilter(String.join((CharSequence)".", "company", "id"), "=", (Object)org.getLong("id"));
            payFilter.and(new QFilter("source", "not in", (Object)new String[]{"cas", "ifm"}));
            payFilter.and(new QFilter("rptype", "=", (Object)"paybill"));
            payFilter.and(new QFilter("availableamount", ">", (Object)0));
            if (EmptyUtil.isNoEmpty((BigDecimal)payAmount) && BigDecimal.ZERO.compareTo(payAmount) < 0) {
                payFilter.and(new QFilter("availableamount", "<=", (Object)payAmount));
            }
            payFilter.and(new QFilter("currency", "=", currency.get("id")));
            payFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            payFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
            payFilter.and(new QFilter("payeetype", "=", payeeType));
            payFilter.and(new QFilter("payeetype", "=", (Object)"other").and(new QFilter("receivername", "=", payeeName)).or(new QFilter("payeetype", "!=", (Object)"other").and(new QFilter("receiver", "=", payBillData.get("payee")))));
            if (settleType != null) {
                DynamicObject settleTypeObj = (DynamicObject)settleType;
                List billTypeIdList = DraftHelper.getBillTypeIdList((Object)settleTypeObj.getPkValue(), (String)settleTypeObj.getString("settlementtype"));
                payFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
            }
            if (EmptyUtil.isNoEmpty((Object)(hasNoReleatedCasPayIdSet = DraftHelper.getReleatedCasPayBill((QFilter)payFilter, (String)"cdm_payablebill")))) {
                payFilter.and(new QFilter("id", "not in", (Object)hasNoReleatedCasPayIdSet));
            }
            qFilter.or(payFilter);
            boolean isSinglePay = payBillIdSet.size() == 1;
            showParameter.setMultiSelect(isSinglePay);
            showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashSet<Long> payBillIdSet = new HashSet<Long>(16);
        Object payBillId = formShowParameter.getCustomParam("payBillId");
        if (payBillId instanceof JSONArray) {
            JSONArray payBillIdJsonArr = (JSONArray)payBillId;
            if (null != payBillIdJsonArr) {
                for (Object ob : payBillIdJsonArr) {
                    payBillIdSet.add(Long.parseLong(ob.toString()));
                }
            }
        } else {
            payBillIdSet.add(Long.parseLong(payBillId.toString()));
        }
        DynamicObjectCollection casRecBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,actpayamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIdSet)});
        BigDecimal casTotalAmount = casRecBills.stream().map(e1 -> e1.getBigDecimal("actpayamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        this.getModel().setValue("caspayamounttotal", (Object)casTotalAmount);
        this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5408\u8ba1\u91d1\u989d\uff1a", (String)"PayBillSelectDraftEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield1", (Object)ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u5408\u8ba1\u91d1\u989d\uff1a", (String)"PayBillSelectDraftEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield11", (Object)ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u5408\u8ba1\u91d1\u989d\uff1a", (String)"PayBillSelectDraftEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield111", (Object)ResManager.loadKDString((String)"\u7968\u9762\u5408\u8ba1\u91d1\u989d\uff1a", (String)"PayBillSelectDraftEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "draftbill": {
                Object draftBillColl = this.getModel().getValue("draftbill");
                if (null != draftBillColl) {
                    DynamicObjectCollection colls = (DynamicObjectCollection)draftBillColl;
                    Set draftBillIdSet = colls.stream().filter(e1 -> null != e1.getDynamicObject("fbasedataid")).map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    DynamicObjectCollection draftColl = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,availableamount,rptype", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIdSet)});
                    BigDecimal recDraftAmountTotal = draftColl.stream().filter(e2 -> "receivebill".equals(e2.getString("rptype"))).map(o -> o.getBigDecimal("availableamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal payDraftAmountTotal = draftColl.stream().filter(e2 -> "paybill".equals(e2.getString("rptype"))).map(o -> o.getBigDecimal("availableamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    this.getModel().setValue("totalrecdraftamount", (Object)recDraftAmountTotal);
                    this.getModel().setValue("totalpaydraftamount", (Object)payDraftAmountTotal);
                    this.getModel().setValue("totaldraftamount", (Object)payDraftAmountTotal.add(recDraftAmountTotal));
                    break;
                }
                this.getModel().setValue("totalrecdraftamount", (Object)BigDecimal.ZERO);
                this.getModel().setValue("totalpaydraftamount", (Object)BigDecimal.ZERO);
                this.getModel().setValue("totaldraftamount", (Object)BigDecimal.ZERO);
                break;
            }
        }
    }
}

