/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.StringUtils;

public class PayBillSynPlugin
extends BillEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    public void afterCreateNewData(EventObject e) {
        this.synPayRec();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryVisible();
        this.setEntryVisibleFromTransferApply();
    }

    private void setEntryVisibleFromTransferApply() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        Object sourceBillType = this.getModel().getValue("sourcebilltype");
        if (Objects.equals(sourceBillType, "cas_transferapply") && billType != null && BillTypeConstants.PAYBILL_SYN.equals(billType.getPkValue())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flex_payinfo", "flex_recinfo", "actpayamt", "currency", "dpcurrency", "dpamt"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayer", "changepayee"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "org": {
                this.synPayRec();
                break;
            }
            case "currency": {
                this.clearPayeeAcctBankForSynPay((DynamicObject)newValue);
                break;
            }
            case "settletype": {
                this.setEntryVisible();
            }
        }
    }

    private void synPayRec() {
        DynamicObject org = this.getDynamicObject("org");
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (org != null && billtype != null && BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue())) {
            this.setValue("payee", org.getPkValue());
            this.setValue("payeename", org.getLocaleString("name").getLocaleValue());
            this.setValue("payeeformid", this.getString("payeetype"));
            this.setPayeeInfo4Lb();
            this.clearPayeeAccValue();
        }
    }

    private void clearPayeeAcctBankForSynPay(DynamicObject currency) {
        QFilter currFilter;
        QFilter pkFilter;
        boolean isExists;
        Object payeeacctbank;
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (currency != null && billtype != null && BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue()) && (payeeacctbank = this.getValue("payeeacctbank")) != null && Long.parseLong(payeeacctbank.toString()) != 0L && !(isExists = QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{pkFilter = new QFilter("id", "=", payeeacctbank), currFilter = new QFilter("currency.fbasedataid.id", "=", (Object)currency.getLong("id"))}))) {
            Object value = null;
            this.setValue("payeeaccformid", value);
            this.setValue("payeeacctbank", value);
            this.setValue("payeebanknum", value);
            this.setValue("payeebank", value);
            this.setValue("payeebankname", value);
            this.setValue("recaccbankname", value);
            this.setValue("recbanknumber", value);
            this.setPayeeAcctInfo4Lb();
        }
    }

    private void setPayeeInfo4Lb() {
        this.setValue("payeenamev", this.getValue("payeename"));
        Image payeePic = (Image)this.getControl("payeepic");
        String payeeformid = this.getString("payeeformid");
        long payeeId = (Long)this.getValue("payee");
        String defaultUrl = BaseDataHelper.getPictureUrl((Long)payeeId, (String)payeeformid);
        defaultUrl = defaultUrl == null ? "/kingdee/tmc/images/pc/icon/entrance/sky_skf_80_80.png" : defaultUrl;
        payeePic.setUrl(defaultUrl);
    }

    private void setPayeeAcctInfo4Lb() {
        ((Label)this.getControl("payeebanknumv")).setText(StringUtils.splitString((String)this.getString("payeebanknum"), (int)4, (String)" "));
        ((Label)this.getControl("payeebanknamev")).setText(this.getString("payeebankname"));
        ((Label)this.getControl("recaccbanknamev")).setText(this.getString("recaccbankname"));
        ((Label)this.getControl("recbanknumberv")).setText(this.getString("recbanknumber"));
    }

    private void setEntryVisible() {
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (billtype != null && BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdiffcur"});
        }
    }

    private void clearPayeeAccValue() {
        Object value = null;
        this.setValue("payeeaccformid", value);
        this.setValue("payeeacctbank", value);
        this.setValue("payeebanknum", value);
        this.setValue("payeebank", value);
        this.setValue("payeebankname", value);
        this.setValue("recaccbankname", value);
        this.setValue("recbanknumber", value);
        this.setValue("payeenumber", null);
        this.setPayeeAcctInfo4Lb();
    }

    private void initF7() {
        DynamicObject billtype;
        DynamicObject dynamicObject = billtype = this.getValue("billtype") == null ? null : this.getDynamicObject("billtype");
        if (billtype != null && BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue())) {
            this.fillSettleType();
        }
    }

    private void fillSettleType() {
        BasedataEdit paymenttypeF7 = (BasedataEdit)this.getControl("settletype");
        paymenttypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("settlementtype", "not in", (Object)new String[]{SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue(), SettleMentTypeEnum.PROMISSORY.getValue(), SettleMentTypeEnum.CHECK.getValue(), SettleMentTypeEnum.MONEY.getValue()});
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }
}

