/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.LoggerPrintHelper;
import kd.fi.cas.helper.PaymentQueryHelper;
import kd.fi.cas.helper.SystemParameterFcsHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.helper.ViewInputHelper;
import kd.fi.cas.model.DoScheInfoModel;
import kd.fi.cas.pojo.BizBalanceModelBean;
import kd.fi.cas.util.EmptyUtil;

public class DoScheInfoEdit
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(DoScheInfoEdit.class);
    private static final String DEFAULT_CURRENCY_SIGN = "\uffe5";
    private boolean isSkipPropChange = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initPaymentAcctF7();
        this.initSettlementTypeF7();
        this.setPayerCurrencyListener();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List successPkIds = (List)e.getFormShowParameter().getCustomParam("successPkIds");
        if (null == successPkIds || 0 == successPkIds.size()) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u6253\u5f00\u6392\u6b3e\u4fe1\u606f\u9875\u9762\u5931\u8d25\uff1a\u6682\u65f6\u6ca1\u6709\u5bf9\u5e94\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u6392\u6b3e\u4fe1\u606f\u7684\u6279\u91cf\u586b\u5145\u3002", (String)"DoScheInfoEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List successPkIds = (List)fsp.getCustomParam("successPkIds");
        this.getView().getPageCache().put("successPkIds", JSON.toJSONString((Object)successPkIds));
        Object payOrgId = fsp.getCustomParam("payOrgId");
        Object payCurrencyId = fsp.getCustomParam("payCurrencyId");
        Object payeeCurrencyId = fsp.getCustomParam("payeeCurrencyId");
        logger.info(String.format("\u6392\u6b3e\u4fe1\u606f\u754c\u9762\u63a5\u6536\u7684\u53c2\u6570: {%s}", LoggerPrintHelper.printCollectionLogger((Collection)successPkIds)));
        DynamicObject[] payApplyDyArr = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_payapplybill"));
        if (0 < payApplyDyArr.length) {
            this.initLabelAndBasenfo(payApplyDyArr, payOrgId, payCurrencyId, payeeCurrencyId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"payeracctbank"});
        this.isMustInputPayerAcctBank((DynamicObject)this.getModel().getValue("settlementtype"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        if (this.isSkipPropChange) {
            this.isSkipPropChange = false;
            return;
        }
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "payeracctbank": {
                logger.info(String.format("\u6539\u53d8\u7684\u94f6\u884c\u8d26\u6237: %s\uff0c\u539f\u6765\u7684\u8d26\u6237: %s", newValue, oldValue));
                if (!(newValue instanceof DynamicObject)) break;
                this.initPayChannel((DynamicObject)newValue);
                DynamicObject defaultCurrency = ((DynamicObject)newValue).getDynamicObject("defaultcurrency");
                this.isSkipPropChange = true;
                if (!this.isEnableCurrency(defaultCurrency)) {
                    defaultCurrency = null;
                }
                this.getModel().setValue("payeecurrency", (Object)defaultCurrency);
                this.setAgreedRate(defaultCurrency);
                this.showBalance((DynamicObject)newValue, defaultCurrency);
                break;
            }
            case "payeecurrency": {
                this.setAgreedRate((DynamicObject)newValue);
                this.showBalance(this.getModel().getDataEntity().getDynamicObject("payeracctbank"), (DynamicObject)newValue);
                break;
            }
            case "settlementtype": {
                this.isMustInputPayerAcctBank((DynamicObject)newValue);
                DynamicObject bankAccount = (DynamicObject)this.getModel().getValue("payeracctbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) break;
                this.initPayChannel(bankAccount);
                break;
            }
        }
    }

    private void isMustInputPayerAcctBank(DynamicObject settlemenTtype) {
        DynamicObject payOrg = (DynamicObject)this.getModel().getValue("payorg");
        boolean isCheckOurAcc = PaymentQueryHelper.isCheckOurAccBySysParam((DynamicObject)payOrg, (DynamicObject)settlemenTtype);
        ViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isCheckOurAcc, (String[])new String[]{"payeracctbank"});
        if (!isCheckOurAcc) {
            this.initPayChannel(null);
        }
    }

    private boolean isEnableCurrency(DynamicObject defaultCurrency) {
        if (defaultCurrency == null) {
            return false;
        }
        QFilter tQFilter = new QFilter("enable", "=", (Object)"1");
        tQFilter.and("id", "=", defaultCurrency.getPkValue());
        return QueryServiceHelper.exists((String)"bd_currency", (QFilter[])new QFilter[]{tQFilter});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("comfirmsche".equals(operateKey) || "comfirmscheandpushpay".equals(operateKey)) {
            List paychannelList;
            IClientViewProxy viewProxy;
            Map paychannelMap;
            Map allFields = this.getModel().getDataEntityType().getAllFields();
            BasedataProp settlementtype = (BasedataProp)allFields.get("settlementtype");
            BasedataProp payeracctbank = (BasedataProp)allFields.get("payeracctbank");
            BasedataProp payeecurrency = (BasedataProp)allFields.get("payeecurrency");
            ComboProp paychannel = (ComboProp)allFields.get("paychannel");
            if (settlementtype.isMustInput() && EmptyUtil.isEmpty((Object)this.getModel().getValue(settlementtype.getName()))) {
                args.setCancel(true);
                args.setCancelMessage(this.getErrMsg((IDataEntityProperty)settlementtype));
            }
            if (!args.isCancel() && payeracctbank.isMustInput() && EmptyUtil.isEmpty((Object)this.getModel().getValue(payeracctbank.getName()))) {
                args.setCancel(true);
                args.setCancelMessage(this.getErrMsg((IDataEntityProperty)payeracctbank));
            }
            if (!args.isCancel() && payeecurrency.isMustInput() && EmptyUtil.isEmpty((Object)this.getModel().getValue(payeecurrency.getName()))) {
                args.setCancel(true);
                args.setCancelMessage(this.getErrMsg((IDataEntityProperty)payeecurrency));
            }
            if (!args.isCancel() && paychannel.isMustInput() && (paychannelMap = (viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getControlMetaState(paychannel.getName())) != null && paychannelMap.get("st") instanceof ArrayList && ((paychannelList = (List)paychannelMap.get("st")) == null || paychannelList.size() < 1 || !paychannelList.stream().anyMatch(o -> o.contains(this.getModel().getValue(paychannel.getName()))))) {
                args.setCancel(true);
                args.setCancelMessage(this.getErrMsg((IDataEntityProperty)paychannel));
            }
            if (args.isCancel()) {
                this.getView().showErrorNotification(args.getCancelMessage());
            }
        }
    }

    private String getErrMsg(IDataEntityProperty dataProp) {
        return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"DoScheInfoEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), dataProp.getDisplayName().getLocaleValue());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("comfirmsche".equals(operateKey) && opResult.isSuccess()) {
            String doScheInfoJSONStr = this.convertToJSONStr();
            HashMap<String, String> params = new HashMap<String, String>(4);
            params.put("op", operateKey);
            params.put("doScheInfo", doScheInfoJSONStr);
            params.put("successPkIds", this.getView().getPageCache().get("successPkIds"));
            this.getView().returnDataToParent(params);
            this.getView().invokeOperation("close");
        } else if ("comfirmscheandpushpay".equals(operateKey) && opResult.isSuccess()) {
            String doScheInfoJSONStr = this.convertToJSONStr();
            HashMap<String, String> params = new HashMap<String, String>(4);
            params.put("op", operateKey);
            params.put("doScheInfo", doScheInfoJSONStr);
            params.put("successPkIds", this.getView().getPageCache().get("successPkIds"));
            this.getView().returnDataToParent(params);
            this.getView().invokeOperation("close");
        }
    }

    private void setAgreedRate(DynamicObject payCurrency) {
        DynamicObject payOrg = (DynamicObject)this.getModel().getValue("payorg");
        DynamicObject recCurrency = (DynamicObject)this.getModel().getValue("paycurrency");
        boolean isDiffPay = recCurrency != null && payCurrency != null && !recCurrency.getPkValue().equals(payCurrency.getPkValue());
        this.getModel().setValue("isdiffcur", (Object)isDiffPay);
        if (isDiffPay) {
            Date exrateDate = (Date)this.getModel().getValue("exratedate");
            DynamicObject exrateTable = (DynamicObject)this.getModel().getValue("exratetable");
            if (exrateDate == null) {
                exrateDate = new Date();
                this.getModel().setValue("exratedate", (Object)exrateDate);
            }
            if (exrateTable == null) {
                exrateTable = SystemStatusCtrolHelper.getExrateTable((long)((Long)payOrg.getPkValue()));
                this.getModel().setValue("exratetable", (Object)exrateTable);
            }
            if (exrateTable != null) {
                BigDecimal exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)recCurrency.getLong("id"), (Long)payCurrency.getLong("id"), (Long)payOrg.getLong("id"), (Date)exrateDate, (Long)exrateTable.getLong("id"));
                if (exchangeRate == null) {
                    exchangeRate = BigDecimal.ONE;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd\u5bf9\u5e94\u7684\u6c47\u7387\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u6c47\u7387\u8868\u4e2d\u6c47\u7387\u503c\u3002", (String)"DoScheInfoEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                this.getModel().setValue("exchangerate", (Object)exchangeRate);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4ed8\u6b3e\u7ec4\u7ec7\u5bf9\u5e94\u7684\u6c47\u7387\u8868\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u540e\u518d\u8fdb\u884c\u6392\u6b3e\u3002", (String)"DoScheInfoEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void initPayChannel(DynamicObject payerAcctBank) {
        List<ComboItem> items;
        ComboEdit fields = (ComboEdit)this.getControl("paychannel");
        fields.setComboItems(new ArrayList(0));
        String defaultStr = null;
        DynamicObject defaultSettlement = this.getModel().getDataEntity().getDynamicObject("settlementtype");
        boolean isVirtual = BaseDataHelper.isSettleTypeVirtual((DynamicObject)defaultSettlement);
        if (isVirtual) {
            defaultStr = PaymentChannelEnum.COUNTER.getValue();
            items = this.getComboItems((List<String>)new ArrayList<String>(2){
                private static final long serialVersionUID = 1L;
                {
                    this.add(PaymentChannelEnum.ONLINEBANK.getValue());
                    this.add(PaymentChannelEnum.BEI.getValue());
                }
            });
        } else if (null != payerAcctBank) {
            boolean issetbankinterface = payerAcctBank.getBoolean("issetbankinterface");
            boolean isopenbank = payerAcctBank.getBoolean("isopenbank");
            logger.info(String.format("\u521d\u59cb\u5316\u652f\u4ed8\u6e20\u9053: \u5f00\u901a\u94f6\u4f01\u63a5\u53e3={%s}, \u5f00\u901a\u7f51\u4e0a\u94f6\u884c={%s}", issetbankinterface, isopenbank));
            if (issetbankinterface) {
                if (isopenbank) {
                    defaultStr = PaymentChannelEnum.BEI.getValue();
                    items = this.getComboItems(new ArrayList<String>(0));
                } else {
                    defaultStr = PaymentChannelEnum.BEI.getValue();
                    items = this.getComboItems((List<String>)new ArrayList<String>(1){
                        private static final long serialVersionUID = 1L;
                        {
                            this.add(PaymentChannelEnum.ONLINEBANK.getValue());
                        }
                    });
                }
            } else if (isopenbank) {
                defaultStr = PaymentChannelEnum.ONLINEBANK.getValue();
                items = this.getComboItems((List<String>)new ArrayList<String>(1){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(PaymentChannelEnum.BEI.getValue());
                    }
                });
            } else {
                defaultStr = PaymentChannelEnum.COUNTER.getValue();
                items = this.getComboItems((List<String>)new ArrayList<String>(2){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(PaymentChannelEnum.BEI.getValue());
                        this.add(PaymentChannelEnum.ONLINEBANK.getValue());
                    }
                });
            }
            if (Objects.nonNull(defaultSettlement)) {
                String paymentChannel = defaultSettlement.getString("paymentchannel");
                String defaultPaymentChannel = defaultSettlement.getString("defaultpaymentchannel");
                if (StringUtils.isNotEmpty((CharSequence)paymentChannel)) {
                    List paymentChannels = Arrays.stream(paymentChannel.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                    items.removeIf(i -> !paymentChannels.contains(i.getValue()));
                }
                if (StringUtils.isNotEmpty((CharSequence)defaultPaymentChannel)) {
                    defaultStr = defaultPaymentChannel;
                }
            }
        } else {
            items = this.getComboItems(new ArrayList<String>(0));
        }
        fields.setComboItems(items);
        String defaultItem = defaultStr;
        if (null != defaultItem && items.stream().anyMatch(b -> b.getValue().equals(defaultItem))) {
            this.getModel().setValue("paychannel", (Object)defaultItem);
        } else {
            this.getModel().setValue("paychannel", null);
        }
        this.getView().updateView("paychannel");
    }

    public List<ComboItem> getComboItems(List<String> filters) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(3);
        HashMap<String, String> resourceMaps = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResManager.loadKDString((String)"\u7f51\u4e0a\u94f6\u884c", (String)"DoScheInfoEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), "DoScheInfoEdit_0");
                this.put(ResManager.loadKDString((String)"\u94f6\u4f01\u4e92\u8054", (String)"DoScheInfoEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), "DoScheInfoEdit_1");
                this.put(ResManager.loadKDString((String)"\u67dc\u53f0", (String)"DoScheInfoEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), "DoScheInfoEdit_2");
            }
        };
        Arrays.stream(PaymentChannelEnum.values()).filter(o -> !filters.contains(o.getValue())).forEach(elem -> {
            String fullFieldName = elem.getValue();
            LocaleString localeName = ResManager.getLocaleString((String)elem.getName(), (String)((String)resourceMaps.get(elem.getName())), (String)"fi-cas-formplugin");
            ComboItem combo = new ComboItem(localeName, fullFieldName);
            combos.add(combo);
        });
        return combos;
    }

    private void initLabelAndBasenfo(DynamicObject[] payApplyDyArr, Object payOrgId, Object payCurrencyId, Object payeeCurrencyId) {
        if (payApplyDyArr.length == 0) {
            return;
        }
        DynamicObject template = payApplyDyArr[0];
        String orgName = Optional.ofNullable(template.getDynamicObject("applyorg")).map(org -> org.getString("name")).orElseGet(() -> "");
        ((Label)this.getControl("companylb")).setText(orgName);
        ((Label)this.getControl("applybillcountlb")).setText(String.format("%d", payApplyDyArr.length));
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (DynamicObject detail : payApplyDyArr) {
            DynamicObjectCollection detailEntrys = detail.getDynamicObjectCollection("cas_payinfo");
            for (DynamicObject entry : detailEntrys) {
                String payStatus = entry.getString("entry_paystatus");
                if (!PayStatusEnum.NOTPAYING.getValue().equals(payStatus)) continue;
                ++count;
                totalAmt = totalAmt.add(entry.getBigDecimal("entry_payeeamount"));
            }
        }
        ((Label)this.getControl("amountlb")).setText(String.format("%d", count));
        DynamicObject payeeCurrency = Optional.ofNullable(template).map(o -> o.getDynamicObject("payeecurrency")).orElseGet(() -> null);
        String payeeSign = DEFAULT_CURRENCY_SIGN;
        int payeeAmtprecision = 2;
        if (null != payeeCurrency) {
            payeeSign = payeeCurrency.getString("sign");
            payeeAmtprecision = payeeCurrency.getInt("amtprecision");
        }
        String totalApplyAmt = this.initFormat(payeeSign, payeeAmtprecision).format(totalAmt);
        ((Label)this.getControl("totalamountlb")).setText(totalApplyAmt);
        if (null == payOrgId) {
            payOrgId = Optional.ofNullable(template.getDynamicObject("payorg")).map(o -> o.getPkValue()).orElseGet(() -> null);
        }
        this.getModel().setValue("payorg", payOrgId);
        if (null == payeeCurrencyId) {
            payeeCurrencyId = Optional.ofNullable(template.getDynamicObject("payeecurrency")).map(o -> o.getPkValue()).orElseGet(() -> null);
        }
        this.getModel().setValue("paycurrency", payeeCurrencyId);
        Object defaultSettlementId = null;
        List tSettlementtypeIds = Arrays.stream(payApplyDyArr).map(item -> item.getDynamicObjectCollection("cas_payapplyentry")).flatMap(item -> item.stream().map(entry -> entry.getDynamicObject("e_settlementtype") == null ? null : Long.valueOf(entry.getDynamicObject("e_settlementtype").getLong("id")))).distinct().collect(Collectors.toList());
        if (tSettlementtypeIds.size() != 0) {
            if (tSettlementtypeIds.size() == 1 && tSettlementtypeIds.get(0) != null) {
                defaultSettlementId = tSettlementtypeIds.get(0);
            } else if (tSettlementtypeIds.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7533\u8bf7\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u4e00\u81f4\u3002", (String)"DoScheInfoEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
        if (null != defaultSettlementId) {
            this.getModel().setValue("settlementtype", defaultSettlementId);
            DynamicObject defaultAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)String.join((CharSequence)",", "id", "defaultcurrency", "issetbankinterface", "isopenbank"), (QFilter[])new QFilter[]{new QFilter("isdefaultpay", "=", (Object)"1"), this.getPaymentAcctF7()});
            if (defaultAccount != null) {
                this.getModel().setValue("payeracctbank", defaultAccount.get("id"));
                this.initPayChannel(defaultAccount);
                DynamicObject payCurrency = defaultAccount.getDynamicObject("defaultcurrency");
                if (!this.isEnableCurrency(payCurrency)) {
                    payCurrency = null;
                }
                this.getModel().setValue("payeecurrency", (Object)payCurrency);
                String paySign = DEFAULT_CURRENCY_SIGN;
                int payAmtprecision = 2;
                if (null != payCurrency) {
                    paySign = payCurrency.getString("sign");
                    payAmtprecision = payCurrency.getInt("amtprecision");
                }
                ((Label)this.getControl("balancelb")).setText(this.initFormat(paySign, payAmtprecision).format(BigDecimal.ZERO));
                this.setAgreedRate(payCurrency);
                this.showBalance(defaultAccount, payCurrency);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"balancelb"});
            }
        }
    }

    private BigDecimal showBalance(DynamicObject acctBank, DynamicObject currency) {
        BigDecimal balance = BigDecimal.ZERO;
        DynamicObject org = (DynamicObject)this.getModel().getValue("payorg");
        if (!EmptyUtil.isEmpty((DynamicObject)org) && currency != null && !EmptyUtil.isEmpty((DynamicObject)acctBank)) {
            Long acctBankId = Optional.ofNullable(acctBank.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> acctBank.getLong("id"));
            Long orgId = Optional.ofNullable(org.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> org.getLong("id"));
            Long currencyId = Optional.ofNullable(currency.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> currency.getLong("id"));
            logger.info(String.format("\u53c2\u6570: acctBankId={%s}; orgId={%s}; cuurencyId={%s}", acctBankId, orgId, currencyId));
            String balanceType = SystemParameterFcsHelper.getParameterString((long)org.getLong("id"), (String)"balancevalue");
            Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalance", (Object[])new Object[]{balanceType, acctBankId, currencyId});
            BizBalanceModelBean bizBalanceModelBean = (BizBalanceModelBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), BizBalanceModelBean.class);
            balance = bizBalanceModelBean.getAmount();
            if (balance == null) {
                balance = BigDecimal.ZERO;
            }
            ((Label)this.getControl("balancelb")).setText(this.initFormat(currency.getString("sign"), currency.getInt("amtprecision")).format(balance));
            logger.info(String.format("\u5373\u65f6\u4f59\u989d\u4e3a %s", balance));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"balancelb"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"balancelb"});
        }
        return balance;
    }

    private Format initFormat(String currencySign, int amtprecision) {
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        fobj.getCurrencyFormat().setCurrencySymbols(currencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
        return FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
    }

    private void initPaymentAcctF7() {
        BasedataEdit payerAcctBank = (BasedataEdit)this.getControl("payeracctbank");
        payerAcctBank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(this.getPaymentAcctF7());
        });
    }

    private QFilter getPaymentAcctF7() {
        QFilter filter = new QFilter("acctstatus", "in", (Object)new String[]{"normal", "closing"});
        DynamicObject settlementType = (DynamicObject)this.getModel().getValue("settlementtype");
        String type = settlementType.getString("settlementtype");
        DynamicObject payOrg = (DynamicObject)this.getModel().getValue("payorg");
        if (payOrg != null) {
            filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)Long.valueOf(payOrg.getPkValue().toString())));
        }
        if (SettleMentTypeEnum.MONEY.getValue().equals(type)) {
            filter.and(new QFilter("settlementtype.fbasedataid.settlementtype", "=", (Object)SettleMentTypeEnum.MONEY.getValue()));
        }
        if (SettleMentTypeEnum.VIRTUAL.getValue().equals(type)) {
            filter.and(new QFilter("isvirtual", "=", (Object)"1"));
        }
        return filter;
    }

    private void setPayerCurrencyListener() {
        BasedataEdit payCurrencyEdit = (BasedataEdit)this.getControl("payeecurrency");
        IDataModel model = this.getModel();
        payCurrencyEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject payAcct = (DynamicObject)model.getValue("payeracctbank");
            DynamicObject settlementType = (DynamicObject)this.getModel().getValue("settlementtype");
            boolean isVirtual = BaseDataHelper.isSettleTypeVirtual((DynamicObject)settlementType);
            if (!isVirtual && EmptyUtil.isEmpty((DynamicObject)payAcct)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u8d26\u53f7", (String)"PayApplyEntryEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)payAcct)) {
                DynamicObjectCollection currencyList = payAcct.getDynamicObjectCollection("currency");
                Object[] currencyIdArr = currencyList.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).toArray();
                QFilter qFilter = new QFilter("id", "in", (Object)currencyIdArr);
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                parameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void initSettlementTypeF7() {
        BasedataEdit payerAcctBank = (BasedataEdit)this.getControl("settlementtype");
        payerAcctBank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("settlementtype", "<>", (Object)SettleMentTypeEnum.MONEY.getValue());
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    public String convertToJSONStr() {
        Boolean isDiffPay = (Boolean)this.getModel().getValue("isdiffcur");
        DynamicObject exchangeRateTable = (DynamicObject)this.getModel().getValue("exratetable");
        BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
        if (isDiffPay.booleanValue()) {
            if (exchangeRateTable == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4ed8\u6b3e\u7ec4\u7ec7\u5bf9\u5e94\u7684\u6c47\u7387\u8868\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u540e\u518d\u8fdb\u884c\u6392\u6b3e\u3002", (String)"DoScheInfoEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (exchangeRate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd\u5bf9\u5e94\u7684\u6c47\u7387\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u6c47\u7387\u8868\u4e2d\u6c47\u7387\u503c\u3002", (String)"DoScheInfoEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
        DoScheInfoModel model = new DoScheInfoModel();
        Long settlementType = Optional.ofNullable((DynamicObject)this.getModel().getValue("settlementtype")).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> null);
        model.setSettlementTypeId(settlementType);
        Long payerAcctBankId = Optional.ofNullable((DynamicObject)this.getModel().getValue("payeracctbank")).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> null);
        model.setPayerAcctBankId(payerAcctBankId);
        DynamicObject bankObj = Optional.ofNullable((DynamicObject)this.getModel().getValue("payeracctbank")).map(o -> o.getDynamicObject("bank")).orElseGet(() -> null);
        Long bankId = Optional.ofNullable(bankObj).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> null);
        model.setBankId(bankId);
        String payChannel = Optional.ofNullable((String)this.getModel().getValue("paychannel")).orElse(null);
        model.setPayChannel(payChannel);
        Date avd = Optional.ofNullable((Date)this.getModel().getValue("avd")).orElse(null);
        model.setAvd(avd);
        String transferpost = Optional.ofNullable((String)this.getModel().getValue("transferpost")).orElse(null);
        model.setTransferPost(transferpost);
        model.setLastUpdateDate(this.getAccountBankLastModifyTime());
        DynamicObject payCurrency = (DynamicObject)this.getModel().getValue("payeecurrency");
        if (payCurrency != null) {
            model.setPayCurrecnyId(Long.valueOf(payCurrency.getLong("id")));
        }
        BigDecimal balance = Optional.ofNullable(this.showBalance(this.getModel().getDataEntity().getDynamicObject("payeracctbank"), payCurrency)).orElse(BigDecimal.ZERO);
        model.setBalance(balance);
        model.setDiffPay(isDiffPay.booleanValue());
        if (isDiffPay.booleanValue()) {
            model.setExchangeRateTableId(Long.valueOf(exchangeRateTable.getLong("id")));
            model.setExchangeRateDate((Date)this.getModel().getValue("exratedate"));
            model.setExchangeRate(exchangeRate);
        }
        logger.info(String.format("\u6392\u6b3e\u4fe1\u606f\u52a8\u6001\u5bf9\u8c61\u8f6c DoScheInfoModel \u5bf9\u8c61 JSON \u6570\u636e: {%s}", LoggerPrintHelper.printObjectLoggerByJSON((Object[])new DoScheInfoModel[]{model})));
        return JSON.toJSONString((Object)model, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.WriteClassName, SerializerFeature.NotWriteRootClassName, SerializerFeature.WriteMapNullValue});
    }

    private Date getAccountBankLastModifyTime() {
        DynamicObject acctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
        if (EmptyUtil.isNoEmpty((DynamicObject)acctBank)) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
            Long acctBankId = Optional.ofNullable(acctBank.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> acctBank.getLong("id"));
            Long cuurencyId = Optional.ofNullable(currency.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> currency.getLong("id"));
            DynamicObject realTimeAcctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)acctBankId, (String)"bd_accountbanks");
            if (realTimeAcctBank != null && realTimeAcctBank.getBoolean("issetbankinterface")) {
                QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", (Object)acctBankId), new QFilter("currency", "=", (Object)cuurencyId)};
                DynamicObjectCollection balanceInquires = QueryServiceHelper.query((String)"getLastestBalanceInquire", (String)"bei_bankbalance", (String)"amount,bizdate,modifytime", (QFilter[])filters, (String)"modifytime desc", (int)1);
                if (balanceInquires.isEmpty()) {
                    return null;
                }
                return ((DynamicObject)balanceInquires.get(0)).getDate("modifytime");
            }
            return new Date();
        }
        return new Date();
    }
}

