/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.business.opservice.helper.PaymentPayeeInfo;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.formplugin.payapply.PaymentChannelHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.DynamicListHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.info.SCAccountInfo;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyBatchInputPlugin
extends BillEditPlugin {
    private static Log logger = LogFactory.getLog(PayApplyBatchInputPlugin.class);
    private static String[] DIFF_PAY_PROPS = new String[]{"entry_isdiffcur", "entry_paycurrency", "entry_exratetable", "entry_exratedate", "entry_exchangerate", "entry_payamount", "entry_quotation"};
    private static final List<String> SYNC_FIELDS = Arrays.asList("e_settlementtype", "e_payeeamount", "e_payeetype", "e_accountname", "e_payeebank", "e_payeeaccbanknum", "e_payeename", "e_payeeid", "e_remark", "e_priority");

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "paymenttypetext", "e_payeetypetext"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payeeName = (TextEdit)this.getView().getControl("e_payeename");
        payeeName.addButtonClickListener((ClickListener)this);
        TextEdit payeeBankNum = (TextEdit)this.getView().getControl("e_payeeaccbanknum");
        payeeBankNum.addButtonClickListener((ClickListener)this);
        TextEdit settletNumber = (TextEdit)this.getView().getControl("entry_settletnumber");
        settletNumber.addButtonClickListener((ClickListener)this);
        this.ePayeeAccBank();
        this.eUserAccBank();
        this.payOrg();
        this.payee();
        this.setPayerAccBankListener();
        this.setPayerCurrencyListener();
        PayApplyBatchInputPlugin.initDraftAmtTotal(this.getView());
        PayApplyBatchInputPlugin.initArrivalUnlockAmt(this.getView());
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if ("e_payeename".equals(key) || "e_payeeaccbanknum".equals(key)) {
            String ePayeeType = (String)this.getValue("e_payeetype", rowIndex);
            Object paymentType = this.getModel().getValue("paymenttype", rowIndex);
            String errMsg = "";
            if (Objects.isNull(paymentType)) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u7c7b\u578b\u3002", (String)"PayApplyEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isEmpty((CharSequence)ePayeeType)) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"PayApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (!StringUtils.isEmpty((CharSequence)errMsg)) {
                this.getView().showTipNotification(errMsg, Integer.valueOf(3000));
                evt.setCancel(true);
            }
        }
        if ("entry_settletnumber".equals(key)) {
            DynamicObject settleType = (DynamicObject)this.getValue("entry_settlementtype", rowIndex);
            if (null == settleType) {
                return;
            }
            if (PayApplyBatchInputPlugin.isDraftbillSettlement(settleType)) {
                evt.setCancel(false);
            } else if (PayApplyBatchInputPlugin.isArrivalSettlement(settleType)) {
                evt.setCancel(false);
            } else {
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (key) {
            case "e_payeename": {
                this.payeeName();
                break;
            }
            case "e_payeeaccbanknum": {
                if (this.isUser()) {
                    BasedataEdit erPayee = (BasedataEdit)this.getControl("e_useraccbank");
                    erPayee.click();
                    break;
                }
                if (this.isSupplier() || this.isCustomer()) {
                    this.showAccountBankInfoF7();
                    break;
                }
                if (!this.isCompany()) break;
                BasedataEdit payeeAcctBank = (BasedataEdit)this.getControl("e_payeeaccbank");
                payeeAcctBank.click();
                break;
            }
            case "entry_settletnumber": {
                DynamicObject settleType = this.getDynamicObject("entry_settlementtype", rowIndex);
                if (PayApplyBatchInputPlugin.isDraftbillSettlement(settleType)) {
                    this.draftbillSettlementClick();
                    break;
                }
                if (!PayApplyBatchInputPlugin.isArrivalSettlement(settleType)) break;
                this.arrivalSettlementClick();
                break;
            }
            case "paymenttypetext": 
            case "e_payeetypetext": {
                this.fillPayRecType();
                break;
            }
            case "btnok": {
                this.checkAndSave();
            }
        }
    }

    private void fillPayRecType() {
        HashMap<String, String> batchInfo = new HashMap<String, String>();
        batchInfo.put("batchbillname", "cas_batchpayapply");
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_batchpayrectype");
        parameter.getCustomParams().putAll(batchInfo);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchpayrectype"));
        this.getView().showForm(parameter);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("entryentity".equals(entryName)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            this.initRowData(entryEntity.size() - 1);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initRowData(0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        if (fieldKey.equals("payorg") && CasHelper.isEmpty((Object)newValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u53ef\u6e05\u7a7a\u3002", (String)"PayApplyBatch02", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("payorg", oldValue, rowIndex);
            this.getModel().setDataChanged(false);
            return;
        }
        if (SYNC_FIELDS.contains(fieldKey)) {
            this.changedEntryPayInfo(fieldKey, rowIndex);
        }
        if (fieldKey.equals("e_payeeaccbanknum") && newValue != null) {
            DynamicObject payeeAccBank = (DynamicObject)this.getValue("e_payeeaccbank", rowIndex);
            if (payeeAccBank != null && !Objects.equals((payeeAccBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeAccBank.getPkValue(), (String)"bd_accountbanks")).get("number"), newValue)) {
                this.setValue("e_payeeaccbank", null, rowIndex);
                this.setValue("e_payeebank", null, rowIndex);
            }
            this.fillAccountName(rowIndex, null);
            if (StringUtils.isEmpty((CharSequence)((String)newValue))) {
                this.setValue("e_accountname", null, rowIndex);
                this.setValue("e_payeebank", null, rowIndex);
            }
        }
        if (fieldKey.equals("e_payeetype") && newValue != null) {
            this.setValue("e_payee", null, rowIndex);
            this.setValue("e_payeeid", null, rowIndex);
            this.setValue("e_payeename", null, rowIndex);
            this.setValue("e_payeeaccbank", null, rowIndex);
            this.setValue("e_payeeaccbankid", null, rowIndex);
            this.setValue("e_payeeaccbanknum", null, rowIndex);
            this.setValue("e_useraccbank", null, rowIndex);
            this.setValue("e_payeebank", null, rowIndex);
            this.setValue("e_accountname", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_accountname"});
        }
        if (fieldKey.equals("e_payee")) {
            this.setValue("e_payeeaccbank", null, rowIndex);
            this.setValue("e_payeeaccbankid", null, rowIndex);
            this.setValue("e_payeeaccbanknum", null, rowIndex);
            this.setValue("e_useraccbank", null, rowIndex);
            this.setValue("e_payeebank", null, rowIndex);
            this.setValue("e_accountname", null, rowIndex);
            if (newValue == null) {
                return;
            }
            this.setValue("e_payeeid", ((DynamicObject)newValue).get("id"), rowIndex);
            this.setValue("entry_payeeid", ((DynamicObject)newValue).get("id"), rowIndex);
            this.setValue("e_payeename", ((DynamicObject)newValue).get("name"), rowIndex);
            this.setValue("entry_payeename", ((DynamicObject)newValue).get("name"), rowIndex);
            if (this.isSupplier(rowIndex) || this.isCustomer(rowIndex)) {
                this.supplierOrCustomerChanged((DynamicObject)newValue, rowIndex);
            } else if (this.isUser(rowIndex)) {
                this.userF7Changed((DynamicObject)newValue, rowIndex);
            } else if (this.isCompany(rowIndex)) {
                this.orgF7Changed((DynamicObject)newValue, rowIndex);
            }
        }
        if (fieldKey.equals("e_payeename") && newValue != null && !this.isOther()) {
            DynamicObject payee = this.getDynamicObject("e_payee", rowIndex);
            if (payee == null) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                this.getModel().setValue("e_payeename", newValue, rowIndex);
                this.getModel().setValue("entry_payeename", newValue, rowIndex);
            } else {
                String payeeName = payee.getString("name");
                if (!payeeName.equals(newValue)) {
                    this.getModel().setValue("e_payeename", (Object)payeeName, rowIndex);
                    this.getModel().setValue("entry_payeename", newValue, rowIndex);
                }
            }
        }
        if (fieldKey.equals("e_payeeaccbank") && newValue != null) {
            this.setValue("e_payeeaccbankid", null, rowIndex);
            this.setValue("e_payeeaccbanknum", null, rowIndex);
            this.setValue("e_payeebank", null, rowIndex);
            DynamicObject actBank = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)newValue).getPkValue(), (String)"bd_accountbanks");
            PaymentPayeeInfo paymentPayeeInfo = PaymentPayeeInfo.createByAccountBank((DynamicObject)actBank);
            this.setValue("e_payeeaccbanknum", paymentPayeeInfo.getAccountNumber(), rowIndex);
            this.setValue("e_payeeaccbankid", actBank.getPkValue(), rowIndex);
            this.setValue("e_payeebank", paymentPayeeInfo.getBebankId(), rowIndex);
            this.setValue("e_payeename", actBank.get("company.name"), rowIndex);
        }
        if (fieldKey.equals("e_useraccbank") && newValue != null) {
            this.setValue("e_payeeaccbank", null, rowIndex);
            this.setValue("e_payeeaccbankid", null, rowIndex);
            this.setValue("e_payeeaccbanknum", null, rowIndex);
            this.setValue("e_payeebank", null, rowIndex);
            DynamicObject erPayee = (DynamicObject)newValue;
            this.setValue("e_payeeaccbanknum", erPayee.getString("payeraccount"), rowIndex);
            this.setValue("e_payeeaccbankid", erPayee.getPkValue(), rowIndex);
            this.setValue("e_payeebank", erPayee.getDynamicObject("payerbank"), rowIndex);
            this.fillAccountName(rowIndex, null);
        }
        if (fieldKey.equals("payeecurrency") && newValue != null) {
            this.clearRecInfo((DynamicObject)newValue, rowIndex);
            this.getModel().setValue("entry_draftbill", null, rowIndex);
            this.setDiffPay(rowIndex);
        }
        if ("planpaydate".equals(fieldKey)) {
            this.getModel().setValue("entry_expectdate", newValue, rowIndex);
        }
        if ("entry_payeebank".equals(fieldKey)) {
            DynamicObject payeeBank = (DynamicObject)this.getModel().getValue("entry_payeebank", rowIndex);
            if (EmptyUtil.isEmpty((DynamicObject)payeeBank)) {
                this.getModel().setValue("entry_recbanknumber", null, rowIndex);
                this.getModel().setValue("entry_recswiftcode", null, rowIndex);
                this.getModel().setValue("entry_recroutingnum", null, rowIndex);
                this.getModel().setValue("entry_recothercode", null, rowIndex);
            } else {
                this.getModel().setValue("entry_recbanknumber", payeeBank.get("union_number"), rowIndex);
                this.getModel().setValue("entry_recswiftcode", payeeBank.get("swift_code"), rowIndex);
                this.getModel().setValue("entry_recroutingnum", payeeBank.get("routingnum"), rowIndex);
                this.getModel().setValue("entry_recothercode", payeeBank.get("other_code"), rowIndex);
            }
        }
        if ("entry_settlementtype".equals(fieldKey)) {
            String newType;
            PaymentChannelHelper.initPaymentChannel(rowIndex, (DynamicObject)newValue, (DynamicObject)this.getModel().getValue("entry_payeraccbank", rowIndex), this.getView());
            if (EmptyUtil.isEmpty((Object)newValue) || EmptyUtil.isEmpty((Object)oldValue)) {
                return;
            }
            String oldType = ((DynamicObject)oldValue).getString("settlementtype");
            if (!oldType.equals(newType = ((DynamicObject)newValue).getString("settlementtype")) && (SettleMentTypeEnum.VIRTUAL.getValue().equals(oldType) || SettleMentTypeEnum.VIRTUAL.getValue().equals(newType))) {
                this.getModel().setValue("entry_payeraccbank", null, rowIndex);
                this.getModel().setValue("entry_payerbank", null, rowIndex);
                this.getModel().setValue("entry_paymentchannel", null, rowIndex);
            }
            if (PayApplyBatchInputPlugin.isDraftbillSettlement((DynamicObject)oldValue) != PayApplyBatchInputPlugin.isDraftbillSettlement((DynamicObject)newValue)) {
                this.getModel().setValue("entry_draftbill", null, rowIndex);
            }
            if (PayApplyBatchInputPlugin.isArrivalSettlement((DynamicObject)oldValue) != PayApplyBatchInputPlugin.isArrivalSettlement((DynamicObject)newValue)) {
                this.getModel().setValue("entry_arrivalno", null, rowIndex);
            }
            PayApplyBatchInputPlugin.initDraftAmtTotal(this.getView());
            PayApplyBatchInputPlugin.initArrivalUnlockAmt(this.getView());
        }
        if ("entry_paymentchannel".equals(fieldKey)) {
            DynamicObject payerAccBank = (DynamicObject)this.getModel().getValue("entry_payeraccbank", rowIndex);
            if (payerAccBank == null) {
                return;
            }
            String result = PayApplyBatchInputPlugin.checkPaymentChannel(payerAccBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerAccBank.getPkValue(), (String)"bd_accountbanks"), (String)newValue);
            if (result != null) {
                this.setValue("entry_paymentchannel", oldValue, rowIndex);
                this.getView().showErrorNotification(result);
                return;
            }
        }
        if ("entry_draftbill".equals(fieldKey)) {
            DynamicObjectCollection list = (DynamicObjectCollection)newValue;
            CharSequence[] draftbillnos = (String[])list.parallelStream().map(coll -> coll.getDynamicObject("fbasedataid").getString("draftbillno")).toArray(String[]::new);
            this.getModel().setValue("entry_settletnumber", (Object)String.join((CharSequence)"\uff1b", draftbillnos), rowIndex);
            BigDecimal draftamttotal = list.parallelStream().map(coll -> coll.getDynamicObject("fbasedataid").getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().setValue("entry_draftamttotal", (Object)draftamttotal, rowIndex);
            Object payeeamount = this.getModel().getValue("entry_payeeamount", rowIndex);
            if (payeeamount == null || BigDecimal.ZERO.compareTo(new BigDecimal(payeeamount.toString())) == 0) {
                this.getModel().setValue("entry_payeeamount", (Object)draftamttotal, rowIndex);
                this.getModel().setValue("e_payeeamount", (Object)draftamttotal, rowIndex);
            }
        }
        if ("entry_arrivalno".equals(fieldKey)) {
            BigDecimal arrivalunlockamt = null;
            String settletnumber = null;
            if (newValue != null) {
                DynamicObject arrivalBill = BusinessDataServiceHelper.loadSingle((Object)newValue, (String)"lc_arrival");
                arrivalunlockamt = arrivalBill.getBigDecimal("todoamount").subtract(arrivalBill.getBigDecimal("lockamount"));
                settletnumber = arrivalBill.getString("arrivalno");
            }
            this.getModel().setValue("entry_settletnumber", settletnumber, rowIndex);
            this.getModel().setValue("entry_arrivalunlockamt", (Object)arrivalunlockamt, rowIndex);
        }
        if ("entry_settletnumber".equals(fieldKey)) {
            String value = (String)newValue;
            DynamicObject settleType = (DynamicObject)this.getModel().getValue("entry_settlementtype", rowIndex);
            if (PayApplyBatchInputPlugin.isDraftbillSettlement(settleType)) {
                DynamicObjectCollection draftBill = (DynamicObjectCollection)this.getModel().getValue("entry_draftbill", rowIndex);
                if (draftBill != null && draftBill.size() > 0) {
                    if (value == null || value.length() < 1) {
                        this.getModel().setValue("entry_draftbill", null, rowIndex);
                    } else {
                        CharSequence[] draftbillnos = (String[])draftBill.stream().map(coll -> coll.getDynamicObject("fbasedataid").getString("draftbillno")).toArray(String[]::new);
                        if (!String.join((CharSequence)"\uff1b", draftbillnos).equals(value)) {
                            this.getModel().setValue("entry_settletnumber", (Object)String.join((CharSequence)"\uff1b", draftbillnos), rowIndex);
                        }
                    }
                } else {
                    this.getModel().setValue("entry_settletnumber", null, rowIndex);
                }
            } else if (PayApplyBatchInputPlugin.isArrivalSettlement(settleType)) {
                if (value == null || value.length() < 1) {
                    this.getModel().setValue("entry_arrivalno", null, rowIndex);
                } else {
                    this.getModel().setValue("entry_arrivalno", this.getModel().getValue("entry_arrivalno", rowIndex), rowIndex);
                }
            }
        }
        if ("entry_payeetype".equals(fieldKey) || "entry_payeename".equals(fieldKey)) {
            this.getModel().setValue("entry_draftbill", null, rowIndex);
            this.getModel().setValue("entry_arrivalno", null, rowIndex);
        }
        if ("entry_payeraccbank".equals(fieldKey)) {
            DynamicObject settleMentType = (DynamicObject)this.getModel().getValue("entry_settlementtype", rowIndex);
            this.getModel().setValue("entry_paycurrency", null, rowIndex);
            PaymentChannelHelper.initPaymentChannel(rowIndex, null, (DynamicObject)newValue, this.getView());
            if (EmptyUtil.isEmpty((DynamicObject)settleMentType) || EmptyUtil.isEmpty((Object)newValue)) {
                this.getModel().setValue("entry_payeraccbank", null, rowIndex);
                this.getModel().setValue("entry_payerbank", null, rowIndex);
                this.getModel().setValue("entry_paymentchannel", null, rowIndex);
                return;
            }
            Object pkValue = ((DynamicObject)newValue).getPkValue();
            DynamicObject payerBank = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"bd_accountbanks");
            DynamicObject bank = payerBank.getDynamicObject("bank");
            String defChannel = PayApplyBatchInputPlugin.getPaymentChannelValue((ComboEdit)this.getControl("entry_paymentchannel"), (DynamicObject)newValue, this.getModel(), rowIndex);
            this.getModel().setValue("entry_paymentchannel", (Object)defChannel, rowIndex);
            this.getModel().setValue("entry_payerbank", (Object)bank, rowIndex);
            DynamicObject defaultCurrency = payerBank.getDynamicObject("defaultcurrency");
            this.setValue("entry_paycurrency", defaultCurrency, rowIndex);
        }
        if ("entry_paycurrency".equals(fieldKey)) {
            this.setDiffPay(rowIndex);
        }
        if ("entry_payeeamount".equals(fieldKey) || "entry_exchangerate".equals(fieldKey) || "entry_quotation".equals(fieldKey)) {
            BigDecimal payeeAmount = (BigDecimal)this.getValue("entry_payeeamount", rowIndex);
            BigDecimal exchangeRate = (BigDecimal)this.getValue("entry_exchangerate", rowIndex);
            DynamicObject payCurrency = this.getDynamicObject("entry_paycurrency", rowIndex);
            String quotation = "0";
            if (this.getValue("entry_quotation", rowIndex) != null) {
                quotation = (String)this.getValue("entry_quotation", rowIndex);
            }
            if (payCurrency != null) {
                this.setValue("entry_payamount", QuotationHelper.callToCurrency((BigDecimal)payeeAmount, (BigDecimal)exchangeRate, (String)quotation, (int)payCurrency.getInt("amtprecision")), rowIndex);
            } else {
                this.setValue("entry_payamount", null, rowIndex);
            }
        }
    }

    public static String checkPaymentChannel(DynamicObject payerAccBank, String newValue) {
        if (payerAccBank != null) {
            if (PaymentChannelEnum.ONLINEBANK.getValue().equals(newValue) && !payerAccBank.getBoolean("isopenbank")) {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u7f51\u4e0a\u94f6\u884c\u3002", (String)"PayApplyEntryEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (PaymentChannelEnum.BEI.getValue().equals(newValue) && !payerAccBank.getBoolean("issetbankinterface")) {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u3002", (String)"PayApplyEntryEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map resultMap;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("payeeaccountbank".equals(actionId)) {
            Object returnData = event.getReturnData();
            if (returnData != null) {
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
                String asstActType = this.getString("e_payeetype");
                SCAccountInfo scAccountInfo = BaseDataHelper.loadBankInfo((String)asstActType, (Long)((Long)entryKey));
                this.bindAccountBankInfo(scAccountInfo);
                this.fillAccountName(this.getModel().getEntryCurrentRowIndex("entryentity"), returnData);
            }
        } else if ("e_payeeaccbank".equals(actionId)) {
            Object returnData = event.getReturnData();
            if (returnData != null) {
                this.fillAccountName(this.getModel().getEntryCurrentRowIndex("entryentity"), returnData);
            }
        } else if ("e_useraccbank".equals(actionId)) {
            Object returnData = event.getReturnData();
            if (returnData != null) {
                this.fillAccountName(this.getModel().getEntryCurrentRowIndex("entryentity"), returnData);
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                Object entryKey = rowInfo.getPrimaryKeyValues()[0];
                this.setValue("e_useraccbank", entryKey);
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"settletnumber")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)rows)) {
                Object keyValue = rows.get(0).getPrimaryKeyValue();
                String asIndex = this.getPageCache().get("arrival_settlement_index");
                this.getModel().setValue("entry_arrivalno", keyValue, Integer.parseInt(asIndex));
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"batchpayrectype") && (resultMap = (Map)event.getReturnData()) != null) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject paymenttype = (DynamicObject)resultMap.get("paymenttype");
            String ePayeetype = (String)resultMap.get("e_payeetype");
            if (EmptyUtil.isNoEmpty((DynamicObject)paymenttype) && EmptyUtil.isNotEmpty((String)ePayeetype)) {
                this.setValue("paymenttype", paymenttype, rowIndex);
                this.setValue("paymenttypetext", paymenttype.getString("name"), rowIndex);
                this.setValue("e_payeetype", ePayeetype, rowIndex);
                this.setValue("e_payeetypetext", AsstActTypeEnum.getName((String)ePayeetype), rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
    }

    private void bindAccountBankInfo(SCAccountInfo scAccountInfo) {
        if (scAccountInfo == null) {
            this.setValue("e_payeeaccbank", null);
            this.setValue("e_payeeaccbankid", null);
            this.setValue("e_payeeaccbanknum", null);
            this.setValue("e_payeebank", null);
            return;
        }
        this.setValue("e_payeeaccbanknum", scAccountInfo.getAccount());
        this.setValue("e_payeebank", scAccountInfo.getBeBank());
    }

    private DynamicObject getStandardCurrencyAndCheckInit(DynamicObject payOrg, int rowIndex) {
        boolean finishInit;
        boolean isFinishInitSetting = true;
        DynamicObject standardCurrency = null;
        try {
            if (payOrg != null) {
                standardCurrency = SystemStatusCtrolHelper.getStandardCurrency((long)((Long)payOrg.getPkValue()));
            }
        }
        catch (KDBizException e) {
            logger.error((Throwable)e);
            this.getView().showTipNotification(e.getMessage());
            isFinishInitSetting = false;
        }
        if (payOrg == null) {
            long orgId = RequestContext.get().getOrgId();
            if (orgId != 0L && this.isFisbankroll(orgId)) {
                this.setValue("payorg", orgId, rowIndex);
            }
        } else if (!this.isFisbankroll((Long)payOrg.getPkValue())) {
            this.setValue("payorg", null, rowIndex);
        } else if (isFinishInitSetting && !(finishInit = SystemStatusCtrolHelper.isFinishInit((long)((Long)payOrg.getPkValue())))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"PayApplyEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        return standardCurrency;
    }

    private boolean isFisbankroll(Long orgId) {
        DynamicObject payOrgDynamicObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"fisbankroll");
        return payOrgDynamicObject.getBoolean("fisbankroll");
    }

    private void fillByPayeeType(List<String> errorRows, int rowIndex) {
        DynamicObject internalOrg;
        if (this.isSupplier(rowIndex) || this.isCustomer(rowIndex)) {
            DynamicObject internalOrg2;
            DynamicObject ePayee = this.getDynamicObject("e_payee", rowIndex);
            if (ePayee != null && (internalOrg2 = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg", rowIndex), (DynamicObject)ePayee)) != null) {
                this.checkPayeeAccBank(errorRows, rowIndex, internalOrg2);
            }
        } else if (this.isCompany(rowIndex) && (internalOrg = (DynamicObject)this.getModel().getValue("e_payee", rowIndex)) != null) {
            this.checkPayeeAccBank(errorRows, rowIndex, internalOrg);
        }
    }

    private void checkPayeeAccBank(List<String> errorRows, int rowIndex, DynamicObject internalOrg) {
        QFilter bankNumberFilter;
        QFilter useOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)((Long)internalOrg.getPkValue()));
        DynamicObject[] bankAccounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id, bank.bebank", (QFilter[])new QFilter[]{useOrgFilter, bankNumberFilter = new QFilter("bankaccountnumber", "=", this.getModel().getValue("e_payeeaccbanknum", rowIndex))});
        if (bankAccounts == null || bankAccounts.length == 0) {
            if (BaseDataHelper.isInternalOrg((DynamicObject)this.getDynamicObject("payorg", rowIndex))) {
                errorRows.add(String.valueOf(rowIndex + 1));
            } else if (QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{useOrgFilter})) {
                errorRows.add(String.valueOf(rowIndex + 1));
            }
        } else {
            this.getModel().setValue("e_payeeaccbank", bankAccounts[0].getPkValue(), rowIndex);
            String accountName = (String)this.getModel().getValue("e_accountname", rowIndex);
            if (StringUtils.isEmpty((CharSequence)accountName)) {
                this.fillAccountName(rowIndex, null);
            }
            DynamicObject beBank = (DynamicObject)bankAccounts[0].get("bank.bebank");
            this.getModel().setValue("e_payeebank", (Object)beBank, rowIndex);
        }
    }

    private void payeeName() {
        String ePayeeType = this.getValue("e_payeetype").toString();
        if (StringUtils.isEmpty((CharSequence)ePayeeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"PayApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        if (AsstActTypeEnum.EMPLOYEE.getValue().equals(ePayeeType) || AsstActTypeEnum.SUPPLIER.getValue().equals(ePayeeType) || AsstActTypeEnum.CUSTOMER.getValue().equals(ePayeeType) || AsstActTypeEnum.COMPANY.getValue().equals(ePayeeType)) {
            ItemClassEdit payeeAcctBank = (ItemClassEdit)this.getControl("e_payee");
            payeeAcctBank.addBeforeF7SelectListener(e -> {
                DynamicObject paymentType = (DynamicObject)this.getModel().getValue("paymenttype");
                if (PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(paymentType.get("biztype")) || PayAndRecBizTypeEnum.FUNDS_ALLOCATE.getValue().equals(paymentType.get("biztype"))) {
                    ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                    QFilter qFilter = new QFilter("fisbankroll", "=", (Object)"1").and(new QFilter("enable", "=", (Object)"1"));
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
                if (AsstActTypeEnum.SUPPLIER.getValue().equals(ePayeeType)) {
                    QFilter qFilter = new QFilter("payhold", "=", (Object)"0");
                    ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            });
            payeeAcctBank.click();
        }
    }

    private void showAccountBankInfoF7() {
        DynamicObject ePayee = this.getDynamicObject("e_payee");
        if (ePayee == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"PayApplyEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg"), (DynamicObject)ePayee);
        if (internalOrg != null) {
            BasedataEdit ePayeeAccBank = (BasedataEdit)this.getControl("e_payeeaccbank");
            ePayeeAccBank.click();
        } else {
            SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)ePayee);
            if (defaultBankInfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"PayApplyEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = null;
            lsp = this.isSupplier() ? DynamicListHelper.getSupplierBankInfoShowParameter((Object)ePayee.getPkValue()) : DynamicListHelper.getCustomerBankInfoShowParameter((Object)ePayee.getPkValue());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeeaccountbank");
            lsp.setCloseCallBack(closeCallBack);
            lsp.getListFilterParameter().setFilter(this.getCurrencyFilter());
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private QFilter getCurrencyFilter() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6536\u6b3e\u5e01\u79cd\u3002", (String)"PayApplyEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        return new QFilter("entry_bank.currency.id", "in", currency.getPkValue());
    }

    private void payee() {
        BasedataEdit payee = (BasedataEdit)this.getControl("e_payee");
        payee.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (this.isCompany()) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("fisbankroll", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void payOrg() {
        BasedataEdit payOrgF7 = (BasedataEdit)this.getControl("payorg");
        payOrgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            List authOrgList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_payapplybill", (String)"47156aff000000ac");
            QFilter filter = ExtendConfigHelper.isInitOnlySet() ? new QFilter("standardcurrency", "is not null", null) : new QFilter("isfinishinit", "=", (Object)"1");
            DynamicObject[] finishInitArrays = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id, org", (QFilter[])filter.toArray());
            List finishInitOrgIds = Arrays.stream(finishInitArrays).filter(f -> f.getDynamicObject("org") != null).map(f -> f.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
            List list = finishInitOrgIds.stream().filter(authOrgList::contains).collect(Collectors.toList());
            showPara.getListFilterParameter().setFilter(new QFilter("id", "in", list));
        });
    }

    private void eUserAccBank() {
        BasedataEdit accBankF7 = (BasedataEdit)this.getControl("e_useraccbank");
        accBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject ePayee = this.getDynamicObject("e_payee");
            if (ePayee != null) {
                QFilter qFilter = new QFilter("payer", "=", ePayee.getPkValue());
                ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
                if (currency != null) {
                    qFilter.and(new QFilter("currency.id", "is null", null).or(new QFilter("currency.id", "=", (Object)0).or(new QFilter("currency.id", "=", currency.getPkValue()))));
                }
                showPara.getListFilterParameter().setFilter(qFilter);
                List qFilters = showPara.getListFilterParameter().getQFilters();
                qFilters.removeIf(q -> q.toString().contains("t_er_Payee_U"));
                showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_useraccbank"));
            }
        });
    }

    private void ePayeeAccBank() {
        BasedataEdit acctBankF7 = (BasedataEdit)this.getControl("e_payeeaccbank");
        acctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject useOrg;
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("acctstatus", "in", (Object)new String[]{"normal", "freeze", "closing"});
            DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
            if (currency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6536\u6b3e\u5e01\u79cd\u3002", (String)"PayApplyEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            showPara.getListFilterParameter().setFilter(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            DynamicObject payee = (DynamicObject)this.getValue("e_payee");
            DynamicObject dynamicObject = useOrg = this.isCompany() ? payee : BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg"), (DynamicObject)payee);
            if (useOrg != null) {
                QFilter useOrgFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)((Long)useOrg.getPkValue()));
                qFilter.and(useOrgFilter);
            }
            logger.info("\u6536\u6b3e\u8d26\u53f7\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a{}", (Object)qFilter);
            showPara.setCustomParam("isclearcorefilter", (Object)"true");
            showPara.getListFilterParameter().setFilter(qFilter);
            showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_payeeaccbank"));
        });
    }

    private void clearRecInfo(DynamicObject newValue, int rowIndex) {
        DynamicObject payeeAccBank;
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        if (this.isSupplier(rowIndex) || this.isCustomer(rowIndex)) {
            DynamicObject currency = this.getEntryBankCurrency(row);
            if (currency != null && !Objects.equals(currency.getPkValue(), newValue.getPkValue())) {
                this.getModel().setValue("e_payeeaccbanknum", null, rowIndex);
                this.getModel().setValue("e_accountname", null, rowIndex);
                this.getModel().setValue("e_payeebank", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_accountname"});
            }
        } else if (this.isUser(rowIndex)) {
            DynamicObject currency;
            DynamicObject userAccBank = (DynamicObject)this.getModel().getValue("e_useraccbank", rowIndex);
            if (Objects.nonNull(userAccBank) && Objects.nonNull(currency = userAccBank.getDynamicObject("currency")) && !Objects.equals(newValue.getPkValue(), currency.getPkValue())) {
                this.getModel().setValue("e_payeeaccbanknum", null, rowIndex);
                this.getModel().setValue("e_accountname", null, rowIndex);
                this.getModel().setValue("e_payeebank", null, rowIndex);
                this.getModel().setValue("e_useraccbank", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_accountname"});
            }
        } else if (this.isCompany(rowIndex) && Objects.nonNull(payeeAccBank = (DynamicObject)this.getModel().getValue("e_payeeaccbank")) && !Objects.equals(payeeAccBank.getDynamicObject("defaultcurrency").getPkValue(), newValue.getPkValue())) {
            this.getModel().setValue("e_payeeaccbanknum", null, rowIndex);
            this.getModel().setValue("e_accountname", null, rowIndex);
            this.getModel().setValue("e_payeebank", null, rowIndex);
            this.getModel().setValue("e_payeeaccbank", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_accountname"});
        }
    }

    private void fillAccountName(int rowIndex, Object returnData) {
        DynamicObject baseData = (DynamicObject)this.getModel().getValue("e_payee");
        if (this.isSupplier(rowIndex) || this.isCustomer(rowIndex)) {
            DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg", rowIndex), (DynamicObject)baseData);
            if (internalOrg == null) {
                if (returnData != null) {
                    ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                    Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
                    SCAccountInfo bankInfo = BaseDataHelper.loadBankInfo((String)baseData.getDataEntityType().getName(), (Long)((Long)entryKey));
                    this.setValue("e_accountname", bankInfo.getAccountName(), rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_accountname"});
                } else {
                    this.setValue("e_accountname", this.getValue("e_payeename"), rowIndex);
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_accountname"});
                }
            } else {
                this.fillAccountNameByReturnData(rowIndex, returnData);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_accountname"});
            }
        } else if (this.isCompany(rowIndex)) {
            this.fillAccountNameByReturnData(rowIndex, returnData);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_accountname"});
        } else if (this.isUser(rowIndex)) {
            if (returnData != null) {
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                Object entryKey = rowInfo.getPrimaryKeyValues()[0];
                DynamicObject payeer = BusinessDataServiceHelper.loadSingle((Object)entryKey, (String)"er_payeer");
                this.getModel().setValue("e_accountname", payeer.get("payeraccountname"), rowIndex);
                this.getModel().setValue("e_payeeaccbanknum", payeer.get("payeraccount"), rowIndex);
                this.getModel().setValue("e_payeebank", payeer.get("payerbank"), rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_accountname"});
            } else {
                DynamicObject userAccBank = (DynamicObject)this.getValue("e_useraccbank", rowIndex);
                if (userAccBank != null) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)userAccBank.getPkValue(), (String)"er_payeer");
                    this.getModel().setValue("e_accountname", dynamicObject.get("payeraccountname"), rowIndex);
                } else {
                    this.getModel().setValue("e_accountname", this.getValue("e_payeename"), rowIndex);
                }
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_accountname"});
            }
        }
    }

    private void fillAccountNameByReturnData(int rowIndex, Object returnData) {
        if (returnData != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getPrimaryKeyValues()[0];
            this.fillAccountNameByBankAccount(entryKey, rowIndex);
            this.getModel().setValue("e_payeeaccbank", entryKey, rowIndex);
        } else {
            DynamicObject payeeAccBank = (DynamicObject)this.getValue("e_payeeaccbank", rowIndex);
            if (payeeAccBank != null) {
                this.fillAccountNameByBankAccount(payeeAccBank.getPkValue(), rowIndex);
            }
        }
    }

    private void fillAccountNameByBankAccount(Object entryKey, int rowIndex) {
        DynamicObject accountBank = BusinessDataServiceHelper.loadSingle((Object)entryKey, (String)"bd_accountbanks");
        this.getModel().setValue("e_accountname", accountBank.get("acctname"), rowIndex);
        if (!accountBank.getBoolean("issetbankinterface")) {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_accountname"});
        }
    }

    private void supplierOrCustomerChanged(DynamicObject basedata, int rowIndex) {
        DynamicObject payeeCurrency = (DynamicObject)this.getModel().getValue("payeecurrency", rowIndex);
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg", rowIndex), (DynamicObject)basedata);
        if (internalOrg != null) {
            DynamicObject defaultPayAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)internalOrg.getPkValue()));
            if (payeeCurrency == null || Objects.nonNull(defaultPayAccount) && Objects.equals(((DynamicObject)defaultPayAccount.get("defaultcurrency")).getPkValue(), payeeCurrency.getPkValue())) {
                this.getModel().setValue("e_payeeaccbank", (Object)defaultPayAccount, rowIndex);
            }
        } else {
            SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)basedata);
            if (defaultBankInfo != null && (payeeCurrency == null || Objects.equals(defaultBankInfo.getCurrency().getPkValue(), payeeCurrency.getPkValue()))) {
                this.getModel().setValue("e_payeeaccbanknum", (Object)defaultBankInfo.getAccount(), rowIndex);
                this.getModel().setValue("e_payeebank", (Object)defaultBankInfo.getBeBank(), rowIndex);
                this.getModel().setValue("e_accountname", (Object)defaultBankInfo.getAccountName(), rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_accountname"});
            }
        }
    }

    private void userF7Changed(DynamicObject user, int rowIndex) {
        DynamicObject erPayeeInfo = this.getErPayeeInfo(user.getLong("id"), user.getLocaleString("name").getLocaleValue());
        DynamicObject payeeCurrency = (DynamicObject)this.getModel().getValue("payeecurrency", rowIndex);
        if (Objects.nonNull(erPayeeInfo) && Objects.isNull(erPayeeInfo.get("currency")) || Objects.isNull(payeeCurrency) || Objects.nonNull(erPayeeInfo) && Objects.nonNull(erPayeeInfo.get("currency")) && Objects.equals(erPayeeInfo.getDynamicObject("currency").getPkValue(), payeeCurrency.getPkValue())) {
            this.getModel().setValue("e_useraccbank", (Object)erPayeeInfo, rowIndex);
        }
    }

    private void orgF7Changed(DynamicObject org, int rowIndex) {
        if (org != null) {
            DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)org.getPkValue()));
            DynamicObject payeeCurrency = (DynamicObject)this.getModel().getValue("payeecurrency", rowIndex);
            if (payeeCurrency == null || defaultRecAccount != null && Objects.equals(defaultRecAccount.getDynamicObject("defaultcurrency").getPkValue(), payeeCurrency.getPkValue())) {
                this.getModel().setValue("e_payeeaccbank", (Object)defaultRecAccount, rowIndex);
            }
        }
    }

    private DynamicObject getErPayeeInfo(long userId, String name) {
        String orderBys;
        QFilter eFilter;
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("payer", "=", (Object)userId);
        String selectFields = "id,name,payer,payeraccount,payeraccountname,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number,currency";
        QFilter[] qFilters = new QFilter[]{uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C'))), eFilter = new QFilter("enable", "=", (Object)"1")};
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)(orderBys = "isdefault desc"), (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    private DynamicObject getEntryBankCurrency(DynamicObject row) {
        DynamicObject payee = row.getDynamicObject("e_payee");
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg"), (DynamicObject)payee);
        if (Objects.nonNull(internalOrg)) {
            DynamicObject defaultPayAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)internalOrg.getPkValue()));
            return defaultPayAccount == null ? null : defaultPayAccount.getDynamicObject("defaultcurrency");
        }
        String payeeAccBankNum = row.getString("e_payeeaccbanknum");
        if (Objects.nonNull(payee)) {
            DynamicObject payeeFromDB = BusinessDataServiceHelper.loadSingle((Object)payee.getPkValue(), (String)payee.getDynamicObjectType().getName(), (String)"entry_bank, entry_bank.bankaccount, entry_bank.currency");
            DynamicObjectCollection entryBank = payeeFromDB.getDynamicObjectCollection("entry_bank");
            for (DynamicObject entryBankRow : entryBank) {
                String bankAccount = entryBankRow.getString("bankaccount");
                if (!Objects.equals(payeeAccBankNum, bankAccount)) continue;
                return entryBankRow.getDynamicObject("currency");
            }
        }
        return null;
    }

    private void checkAndSave() {
        DynamicObjectCollection dataRows = this.getModel().getEntryEntity("entryentity");
        if (CasHelper.isEmpty((Object)dataRows)) {
            return;
        }
        ArrayList<String> bankErrorRows = new ArrayList<String>(dataRows.size());
        for (int rowIndex = 0; rowIndex < dataRows.size(); ++rowIndex) {
            this.fillByPayeeType(bankErrorRows, rowIndex);
        }
        if (!bankErrorRows.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u7b2c%s\u884c\u5f55\u5165\u6536\u6b3e\u8d26\u53f7\u6709\u8bef\uff0c\u5efa\u8bae\u901a\u8fc7\u9009\u62e9\u65b9\u5f0f\u586b\u5199\u3002", (String)"PayApplyEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", bankErrorRows)));
            return;
        }
        DynamicObject[] targetBills = new DynamicObject[dataRows.size()];
        for (int i = 0; i < dataRows.size(); ++i) {
            targetBills[i] = this.convertTargetBill((DynamicObject)dataRows.get(i));
        }
        OperationResult operationResult = OperateServiceHelper.execOperate((String)"save", (String)"cas_payapplybill", (DynamicObject[])targetBills, (OperateOption)OperateOption.create(), (boolean)true);
        if (!operationResult.isSuccess()) {
            logger.error((Throwable)((Object)operationResult.getAllErrorOrValidateInfo()));
        } else {
            int okCount = operationResult.getSuccessPkIds().size();
            String msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5f55\u5165\u6210\u529f\uff0c\u5171%s\u6761\u3002", (String)"PayApplyBatch01", (String)"fi-cas-formplugin", (Object[])new Object[0]), okCount);
            this.getView().showSuccessNotification(msg, Integer.valueOf(3000));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok", "newentry", "copyentry", "deleteentry"});
        }
    }

    private DynamicObject convertTargetBill(DynamicObject row) {
        DynamicObject bill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_payapplybill"));
        bill.set("billstatus", row.get("billstatus"));
        bill.set("paidstatus", row.get("paidstatus"));
        bill.set("creator", row.get("creator"));
        bill.set("applydate", row.get("applydate"));
        bill.set("payorg", row.get("payorg"));
        bill.set("applyorg", row.get("applyorg"));
        bill.set("paymenttype", row.get("paymenttype"));
        bill.set("paymentidentify", row.get("paymentidentify"));
        bill.set("applycause", row.get("applycause"));
        bill.set("payeecurrency", row.get("payeecurrency"));
        bill.set("planpaydate", row.get("planpaydate"));
        bill.set("payeeamount", row.get("payeeamount"));
        DynamicObjectCollection applyEntry = bill.getDynamicObjectCollection("cas_payapplyentry");
        DynamicObject entryInfo = applyEntry.addNew();
        entryInfo.set("e_settlementtype", row.get("e_settlementtype"));
        entryInfo.set("e_payeeamount", row.get("e_payeeamount"));
        entryInfo.set("e_priority", row.get("e_priority"));
        entryInfo.set("e_payeetype", row.get("e_payeetype"));
        entryInfo.set("e_payee", row.get("e_payee"));
        entryInfo.set("e_payeeid", row.get("e_payeeid"));
        entryInfo.set("e_payeename", row.get("e_payeename"));
        entryInfo.set("e_payeeaccbankid", row.get("e_payeeaccbankid"));
        entryInfo.set("e_payeeaccbanknum", row.get("e_payeeaccbanknum"));
        entryInfo.set("e_payeeaccbank", row.get("e_payeeaccbank"));
        entryInfo.set("e_accountname", row.get("e_accountname"));
        entryInfo.set("e_payeebank", row.get("e_payeebank"));
        entryInfo.set("e_remark", row.get("e_remark"));
        entryInfo.set("e_useraccbank", row.get("e_useraccbank"));
        entryInfo.set("e_chgstatus", row.get("e_chgstatus"));
        bill.set("cas_payapplyentry", (Object)applyEntry);
        DynamicObjectCollection payEntry = bill.getDynamicObjectCollection("cas_payinfo");
        DynamicObject payInfo = payEntry.addNew();
        payInfo.set("entry_settlementtype", row.get("entry_settlementtype"));
        payInfo.set("entry_settletnumber", row.get("entry_settletnumber"));
        payInfo.set("entry_draftbill", row.get("entry_draftbill"));
        payInfo.set("entry_draftamttotal", row.get("entry_draftamttotal"));
        payInfo.set("entry_arrivalunlockamt", row.get("entry_arrivalunlockamt"));
        payInfo.set("entry_payeraccbank", row.get("entry_payeraccbank"));
        payInfo.set("entry_payerbank", row.get("entry_payerbank"));
        payInfo.set("entry_paycurrency", row.get("entry_paycurrency"));
        payInfo.set("entry_isdiffcur", row.get("entry_isdiffcur"));
        payInfo.set("entry_exratetable", row.get("entry_exratetable"));
        payInfo.set("entry_exratedate", row.get("entry_exratedate"));
        payInfo.set("entry_exchangerate", row.get("entry_exchangerate"));
        payInfo.set("entry_quotation", row.get("entry_quotation"));
        payInfo.set("entry_payamount", row.get("entry_payamount"));
        payInfo.set("entry_paymentchannel", row.get("entry_paymentchannel"));
        payInfo.set("entry_expectdate", row.get("entry_expectdate"));
        payInfo.set("entry_usage", row.get("entry_usage"));
        payInfo.set("entry_remark", row.get("entry_remark"));
        payInfo.set("entry_payeeamount", row.get("entry_payeeamount"));
        payInfo.set("entry_priority", row.get("entry_priority"));
        payInfo.set("entry_paystatus", row.get("entry_paystatus"));
        payInfo.set("entry_payeetype", row.get("entry_payeetype"));
        payInfo.set("entry_payee", row.get("entry_payee"));
        payInfo.set("entry_payeeid", row.get("entry_payeeid"));
        payInfo.set("entry_payeename", row.get("entry_payeename"));
        payInfo.set("entry_accountname", row.get("entry_accountname"));
        payInfo.set("entry_payeeaccbanknum", row.get("entry_payeeaccbanknum"));
        payInfo.set("entry_recaccbankname", row.get("entry_recaccbankname"));
        payInfo.set("entry_payeebank", row.get("entry_payeebank"));
        payInfo.set("entry_recbanknumber", row.get("entry_recbanknumber"));
        payInfo.set("entry_recswiftcode", row.get("entry_recbanknumber"));
        payInfo.set("entry_recroutingnum", row.get("entry_recroutingnum"));
        payInfo.set("entry_recothercode", row.get("entry_recothercode"));
        payInfo.set("entry_recbanknumber", row.get("entry_recbanknumber"));
        payInfo.set("entry_arrivalno", row.get("entry_arrivalno"));
        payInfo.set("entry_invalid", row.get("entry_invalid"));
        bill.set("cas_payinfo", (Object)payEntry);
        DynamicObjectCollection bizEntry = bill.getDynamicObjectCollection("cas_businessentry");
        DynamicObject bizInfo = bizEntry.addNew();
        bizInfo.set("e_contractnumber", row.get("e_contractnumber"));
        bizInfo.set("materielfield", row.get("materielfield"));
        bizInfo.set("e_expenseitem", row.get("e_expenseitem"));
        bizInfo.set("e_project", row.get("e_project"));
        bizInfo.set("e_buspayeeamount", row.get("e_buspayeeamount"));
        bizInfo.set("e_busremark", row.get("e_busremark"));
        bill.set("cas_businessentry", (Object)bizEntry);
        return bill;
    }

    private boolean isUser() {
        return this.isAimType(AsstActTypeEnum.EMPLOYEE);
    }

    private boolean isUser(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.EMPLOYEE, rowIndex);
    }

    private boolean isSupplier() {
        return this.isAimType(AsstActTypeEnum.SUPPLIER);
    }

    private boolean isSupplier(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.SUPPLIER, rowIndex);
    }

    private boolean isCustomer() {
        return this.isAimType(AsstActTypeEnum.CUSTOMER);
    }

    private boolean isCustomer(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.CUSTOMER, rowIndex);
    }

    private boolean isCompany() {
        return this.isAimType(AsstActTypeEnum.COMPANY);
    }

    private boolean isCompany(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.COMPANY, rowIndex);
    }

    private boolean isOther() {
        return this.isAimType(AsstActTypeEnum.OTHER);
    }

    private boolean isOther(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.OTHER, rowIndex);
    }

    private boolean isAimType(AsstActTypeEnum asstActType) {
        Object payeeType = this.getValue("e_payeetype");
        return asstActType.getValue().equals(payeeType);
    }

    private boolean isAimType(AsstActTypeEnum asstActType, int rowIndex) {
        Object payeeType = this.getValue("e_payeetype", rowIndex);
        return asstActType.getValue().equals(payeeType);
    }

    public static void initDraftAmtTotal(IFormView view) {
        int rowIndex = view.getModel().getEntryCurrentRowIndex("entryentity");
        view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"entry_draftamttotal"});
    }

    public static boolean isDraftbillSettlement(DynamicObject settleType) {
        return settleType != null && (SettleMentTypeEnum.CHECK.getValue().equals(settleType.getString("settlementtype")) || SettleMentTypeEnum.BUSINESS.getValue().equals(settleType.getString("settlementtype")) || SettleMentTypeEnum.BANK.getValue().equals(settleType.getString("settlementtype")));
    }

    public static boolean isArrivalSettlement(DynamicObject settleType) {
        return settleType != null && SettleMentTypeEnum.CREDIT.getValue().equals(settleType.getString("settlementtype"));
    }

    public static void initArrivalUnlockAmt(IFormView view) {
        int rowIndex = view.getModel().getEntryCurrentRowIndex("entryentity");
        view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"entry_arrivalunlockamt"});
    }

    private void draftbillSettlementClick() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        Object payeetype = this.getValue("entry_payeetype", rowIndex);
        if (CasHelper.isEmpty((Object)payeetype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"PayApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object org = this.getValue("payorg", rowIndex);
        if (EmptyUtil.isEmpty((Object)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f", (String)"PayApplyEntryEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        MulBasedataEdit draftbill = (MulBasedataEdit)this.getControl("entry_draftbill");
        draftbill.addBeforeF7SelectListener(e -> {
            Object currency = this.getModel().getValue("payeecurrency", rowIndex);
            if (CasHelper.isEmpty((Object)currency)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e01\u79cd\u3002", (String)"PaymentBillDraftEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object payeename = this.getModel().getValue("entry_payeename", rowIndex);
            if (CasHelper.isEmpty((Object)payeename)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentBillDraftEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            QFilter qFilter = this.getDraftF7Filter((DynamicObject)currency, payeetype.toString(), payeename.toString());
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
        draftbill.click();
    }

    private QFilter getDraftF7Filter(DynamicObject currency, String payeetype, String payeename) {
        ArrayList ids = new ArrayList(0);
        ArrayList<Long> lockIds = new ArrayList<Long>(0);
        try {
            DynamicObject payApplyBillFromDB = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity(true).getPkValue(), (String)"cas_payapplybill");
            lockIds.addAll(PayApplyBatchInputPlugin.getDraftBillList(payApplyBillFromDB.getDynamicObjectCollection("entryentity"), true));
        }
        catch (Exception e1) {
            logger.error((Throwable)e1);
        }
        List<Long> otherIds = PayApplyBatchInputPlugin.getDraftBillList(this.getModel().getEntryEntity("entryentity"), true);
        lockIds.removeAll(otherIds);
        DynamicObjectCollection draftbillColls = (DynamicObjectCollection)this.getModel().getValue("entry_draftbill");
        if (draftbillColls != null && draftbillColls.size() > 0) {
            ids.addAll(draftbillColls.stream().map(coll -> coll.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
            lockIds.addAll(ids);
        }
        Object settleType = this.getValue("entry_settlementtype");
        Object payeeId = this.getValue("entry_payeeid");
        DynamicObject org = (DynamicObject)this.getModel().getValue("payorg");
        QFilter qFilter = PayApplyBatchInputPlugin.getDraftBillQFilter(org, (DynamicObject)settleType, currency, payeetype, (Long)payeeId, payeename, this.getModel().getDataEntity().getPkValue(), lockIds);
        otherIds.removeAll(ids);
        if (otherIds.size() > 0) {
            qFilter.and(new QFilter("id", "not in", otherIds));
        }
        return qFilter;
    }

    private void arrivalSettlementClick() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        Object currency = this.getModel().getValue("payeecurrency", rowIndex);
        if (CasHelper.isEmpty((Object)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e01\u79cd\u3002", (String)"PaymentBillDraftEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object payeetype = this.getValue("entry_payeetype", rowIndex);
        Object payeename = this.getValue("entry_payeename", rowIndex);
        if (CasHelper.isEmpty((Object)payeetype) || CasHelper.isEmpty((Object)payeename)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentBillDraftEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object org = this.getValue("payorg", rowIndex);
        if (EmptyUtil.isEmpty((Object)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f", (String)"PayApplyEntryEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"lc_arrival", (boolean)false);
        Object payeeId = this.getValue("entry_payeeid", rowIndex);
        Object payeeAmount = this.getValue("entry_payeeamount", rowIndex);
        QFilter qFilter = PayApplyBatchInputPlugin.getArrivalNoQFilter((DynamicObject)org, (DynamicObject)currency, payeetype.toString(), (Long)payeeId, payeename.toString(), (BigDecimal)payeeAmount);
        showParameter.getListFilterParameter().setFilter(qFilter);
        this.getPageCache().put("arrival_settlement_index", String.valueOf(rowIndex));
        showParameter.setIsolationOrg(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "settletnumber"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public static QFilter getArrivalNoQFilter(DynamicObject org, DynamicObject currency, String payeetype, long payeeid, String payeename, BigDecimal payeeamount) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("arrivalstatus", "=", (Object)"arrival_confirm");
        qFilter.and("arrivalway", "!=", (Object)"protest");
        qFilter.and("org", "=", org.getPkValue());
        if ("other".equals(payeetype)) {
            qFilter.and("benefitertype", "=", (Object)"fbd_other");
            qFilter.and("benefiterother", "=", (Object)payeename);
        } else {
            qFilter.and("benefitertype", "=", (Object)payeetype);
            qFilter.and("benefiter", "=", (Object)payeeid);
        }
        qFilter.and("arrivalcurrency", "=", currency.getPkValue());
        DynamicObject[] arrivals = BusinessDataServiceHelper.load((String)"lc_arrival", (String)"id,todoamount,lockamount", (QFilter[])new QFilter[]{qFilter});
        List arrivalIds = Arrays.asList(arrivals).stream().filter(item -> {
            if (item.getBigDecimal("todoamount").compareTo(item.getBigDecimal("lockamount")) > 0) {
                if (payeeamount != null) {
                    return item.getBigDecimal("todoamount").compareTo(item.getBigDecimal("lockamount").add(payeeamount)) >= 0;
                }
                return true;
            }
            return false;
        }).map(item -> item.getLong("id")).collect(Collectors.toList());
        qFilter = new QFilter("id", "in", arrivalIds);
        return qFilter;
    }

    public static QFilter getDraftBillQFilter(DynamicObject org, DynamicObject settleTypeObj, DynamicObject currency, String payeetype, long payeeid, String payeename, Object pkValue, List<Long> ids) {
        List<Long> billIds;
        QFilter receFilter = new QFilter("company.id", "=", (Object)org.getLong("id"));
        receFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
        receFilter.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("isendorsepay", "=", (Object)"1").and(new QFilter("locksourcebilltype", "=", (Object)"cas_payapplybill")).and(new QFilter("locksourcebillid", "=", (Object)String.valueOf(pkValue)))));
        receFilter.and(new QFilter("currency", "=", currency.get("id")));
        receFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        receFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        receFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        QFilter nullFilter = QFilter.isNull((String)"billpool");
        receFilter.and(new QFilter("billpool", "=", (Object)0).or(nullFilter));
        List<Long> poolIds = PayApplyBatchInputPlugin.getBillPoolByCompany(org.getLong("id"));
        QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"isShowUnLockBill");
        if (isShowUnLockBill) {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)org.getLong("id")))));
        } else {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)org.getLong("id"))));
        }
        qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterBillPool.and(new QFilter("currency", "=", currency.get("id")));
        qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilterBillPool.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        boolean isExcludedBills = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"isexcludedbills");
        if (isExcludedBills && EmptyUtil.isNoEmpty(billIds = PayApplyBatchInputPlugin.getIsExcludedBills(org, currency)) && billIds.size() > 0) {
            qFilterBillPool.and("id", "not in", (Object)billIds.toArray());
        }
        QFilter payFilter = new QFilter("company.id", "=", (Object)org.getLong("id"));
        payFilter.and(new QFilter("source", "in", (Object)new String[]{"handregister", "apply", "cdm"}));
        payFilter.and(new QFilter("rptype", "=", (Object)"paybill"));
        payFilter.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("isendorsepay", "=", (Object)"1").and(new QFilter("locksourcebilltype", "=", (Object)"cas_payapplybill")).and(new QFilter("locksourcebillid", "=", (Object)String.valueOf(pkValue)))));
        payFilter.and(new QFilter("currency", "=", currency.get("id")));
        payFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        payFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        payFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        payFilter.and(new QFilter("payeetype", "=", (Object)payeetype));
        payFilter.and(new QFilter("payeetype", "=", (Object)"other").and(new QFilter("receivername", "=", (Object)payeename)).or(new QFilter("payeetype", "!=", (Object)"other").and(new QFilter("receiver", "=", (Object)payeeid))));
        if (settleTypeObj != null) {
            List billTypeIdList = DraftHelper.getBillTypeIdList((Object)settleTypeObj.getPkValue(), (String)settleTypeObj.getString("settlementtype"));
            receFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
            qFilterBillPool.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
            payFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
        }
        QFilter qFilter = receFilter.or(qFilterBillPool).or(payFilter);
        if (ids != null && ids.size() > 0) {
            qFilter.or(new QFilter("id", "in", ids));
        }
        return qFilter;
    }

    public static List<Long> getDraftBillList(DynamicObjectCollection payinfoCollection, boolean isClancel) {
        return PayApplyBillHelper.getDraftBillList((DynamicObjectCollection)payinfoCollection, (boolean)isClancel);
    }

    private static List<Long> getBillPoolByCompany(long orgId) {
        DynamicObject[] billPools = BusinessDataServiceHelper.load((String)"cdm_billpool", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.e_company", "=", (Object)orgId).or(new QFilter("company", "=", (Object)orgId)), new QFilter("enable", "=", (Object)"1")});
        ArrayList<Long> poolIds = new ArrayList<Long>(billPools.length);
        for (DynamicObject dy0 : billPools) {
            poolIds.add(dy0.getLong("id"));
        }
        return poolIds;
    }

    private static List<Long> getIsExcludedBills(DynamicObject org, DynamicObject currency) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return ids;
        }
        String orgName = org.getString("name");
        if (EmptyUtil.isEmpty((String)orgName)) {
            return ids;
        }
        List<Long> poolIds = PayApplyBatchInputPlugin.getBillPoolByCompany(org.getLong("id"));
        QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"isShowUnLockBill");
        if (isShowUnLockBill) {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)org.getLong("id")))));
        } else {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)org.getLong("id"))));
        }
        qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterBillPool.and(new QFilter("currency", "=", currency.get("id")));
        qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilterBillPool.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        qFilterBillPool.and(new QFilter("company.id", "!=", (Object)org.getLong("id")));
        Object[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,delivername,drawername,receivername,endorseentry.id,endorseentry.initiatorname,endorseentry.opponentname", (QFilter[])qFilterBillPool.toArray());
        if (EmptyUtil.isNoEmpty((Object[])receivablebills)) {
            block0: for (Object receivablebill : receivablebills) {
                String delivername = receivablebill.getString("delivername");
                String drawername = receivablebill.getString("drawername");
                String receivername = receivablebill.getString("receivername");
                if (orgName.equals(delivername) || orgName.equals(drawername) || orgName.equals(receivername)) {
                    ids.add(receivablebill.getLong("id"));
                    continue;
                }
                DynamicObjectCollection endorseentrys = receivablebill.getDynamicObjectCollection("endorseentry");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)endorseentrys)) continue;
                for (DynamicObject endorseentry : endorseentrys) {
                    String initiatorname = endorseentry.getString("initiatorname");
                    String opponentname = endorseentry.getString("opponentname");
                    if (!orgName.equals(initiatorname) && !orgName.equals(opponentname)) continue;
                    ids.add(receivablebill.getLong("id"));
                    continue block0;
                }
            }
        }
        return ids;
    }

    public static String getPaymentChannelValue(ComboEdit paymentChannel, DynamicObject payerAcctBank, IDataModel model, int rowIndex) {
        boolean isSetBankInterface;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(PaymentChannelEnum.COUNTER.getValue());
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.COUNTER.getName(), (String)"PaymentBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        ComboItem selectedItem = comboItem;
        comboItems.add(comboItem);
        ComboItem item = new ComboItem();
        item.setValue(PaymentChannelEnum.ONLINEBANK.getValue());
        item.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.ONLINEBANK.getName(), (String)"PaymentBillEdit_17", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        comboItems.add(item);
        ComboItem itemBei = new ComboItem();
        itemBei.setValue(PaymentChannelEnum.BEI.getValue());
        itemBei.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.BEI.getName(), (String)"PaymentBillEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        comboItems.add(itemBei);
        boolean isOpenBank = payerAcctBank.getBoolean("isopenbank");
        if (isOpenBank) {
            selectedItem = item;
        }
        if (isSetBankInterface = payerAcctBank.getBoolean("issetbankinterface")) {
            selectedItem = itemBei;
        }
        paymentChannel.setComboItems(comboItems);
        String defaultPaymentChannel = "";
        DynamicObject settletype = (DynamicObject)model.getValue("entry_settlementtype", rowIndex);
        if (Objects.nonNull(settletype) && StringUtils.isNotEmpty((CharSequence)(defaultPaymentChannel = settletype.getString("defaultpaymentchannel")))) {
            if (!isOpenBank && Objects.equals(defaultPaymentChannel, PaymentChannelEnum.ONLINEBANK.getValue()) || !isSetBankInterface && Objects.equals(defaultPaymentChannel, PaymentChannelEnum.BEI.getValue())) {
                return null;
            }
            return defaultPaymentChannel;
        }
        return selectedItem.getValue();
    }

    private void setDiffPay(int rowIndex) {
        DynamicObject payCurrency = this.getDynamicObject("entry_paycurrency", rowIndex);
        DynamicObject payeeCurrency = this.getDynamicObject("payeecurrency", rowIndex);
        Boolean currIsDiffPay = payCurrency != null && payeeCurrency != null && !payCurrency.getPkValue().equals(payeeCurrency.getPkValue());
        Boolean prevIsDiffPay = (Boolean)this.getValue("entry_isdiffcur", rowIndex);
        this.setValue("entry_isdiffcur", currIsDiffPay, rowIndex);
        if (currIsDiffPay.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"entry_exratetable", "entry_exratedate"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"entry_exratetable", "entry_exratedate"});
        }
        if (currIsDiffPay.booleanValue() && !prevIsDiffPay.booleanValue()) {
            DynamicObject payOrg = this.getDynamicObject("payorg", rowIndex);
            DynamicObject exrateTable = SystemStatusCtrolHelper.getExrateTable((long)((Long)payOrg.getPkValue()));
            if (this.getValue("entry_exratetable", rowIndex) == null) {
                this.setValue("entry_exratetable", exrateTable, rowIndex);
            }
            if (this.getValue("entry_exratedate", rowIndex) == null) {
                this.setValue("entry_exratedate", new Date(), rowIndex);
            }
        } else {
            this.setValue("entry_exratetable", null, rowIndex);
            this.setValue("entry_exratedate", null, rowIndex);
        }
    }

    private void setPayerAccBankListener() {
        BasedataEdit payerActBank = (BasedataEdit)this.getControl("entry_payeraccbank");
        payerActBank.addBeforeF7SelectListener(evt -> {
            int row = evt.getRow();
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject payOrg = this.getDynamicObject("payorg", index);
            DynamicObject settleMentType = this.getDynamicObject("entry_settlementtype", index);
            if (EmptyUtil.isEmpty((DynamicObject)payOrg) || EmptyUtil.isEmpty((DynamicObject)settleMentType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f", (String)"PayApplyEntryEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String settleType = settleMentType.getString("settlementtype");
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("acctstatus", "in", (Object)new String[]{"normal", "freeze", "closing"});
            if (SettleMentTypeEnum.MONEY.getValue().equals(settleType)) {
                qFilter.and(new QFilter("settlementtype.fbasedataid.settlementtype", "=", (Object)SettleMentTypeEnum.MONEY.getValue()));
            }
            if (SettleMentTypeEnum.VIRTUAL.getValue().equals(settleType)) {
                qFilter.and(new QFilter("isvirtual", "=", (Object)"1"));
            } else {
                qFilter.and(new QFilter("isvirtual", "=", (Object)"0"));
            }
            parameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void setPayerCurrencyListener() {
        BasedataEdit payCurrencyEdit = (BasedataEdit)this.getControl("entry_paycurrency");
        payCurrencyEdit.addBeforeF7SelectListener(evt -> {
            int row = evt.getRow();
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject payAcct = this.getDynamicObject("entry_payeraccbank", index);
            if (EmptyUtil.isEmpty((DynamicObject)payAcct)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u8d26\u53f7", (String)"PayApplyEntryEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            payAcct = BusinessDataServiceHelper.loadSingleFromCache((Object)payAcct.getPkValue(), (String)"bd_accountbanks");
            DynamicObjectCollection currencyList = payAcct.getDynamicObjectCollection("currency");
            Object[] currencyIdArr = currencyList.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).toArray();
            QFilter qFilter = new QFilter("id", "in", (Object)currencyIdArr);
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            parameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void initRowData(int rowIndex) {
        DynamicObject applyOrg = this.getDynamicObject("applyorg", rowIndex);
        DynamicObject payOrg = this.getDynamicObject("payorg", rowIndex);
        if (applyOrg == null) {
            this.setValue("applyorg", RequestContext.get().getOrgId(), rowIndex);
        }
        long applyOrgId = (applyOrg = this.getDynamicObject("applyorg", rowIndex)) == null ? 0L : applyOrg.getLong("id");
        DynamicObject standardCurrency = this.getStandardCurrencyAndCheckInit(payOrg, rowIndex);
        DynamicObject payeeCurrency = this.getDynamicObject("payeecurrency", rowIndex);
        if (payeeCurrency == null && standardCurrency != null) {
            this.setValue("payeecurrency", standardCurrency, rowIndex);
        }
        DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
        this.getModel().setValue("e_settlementtype", (Object)defaultSettleType, rowIndex);
        this.getModel().setValue("entry_settlementtype", (Object)defaultSettleType, rowIndex);
        PaymentChannelHelper.initPaymentChannel(rowIndex, defaultSettleType, (DynamicObject)this.getModel().getValue("entry_payeraccbank", rowIndex), this.getView());
        DynamicObject paymentType = this.getDynamicObject("paymenttype", rowIndex);
        if (Objects.nonNull(paymentType)) {
            String typeNumber = paymentType.getString("biztype");
            if (PayAndRecBizTypeEnum.TRANSFER_SAME.getValue().equals(typeNumber)) {
                this.getModel().setValue("e_payeetype", (Object)"bos_org", rowIndex);
                this.getModel().setValue("e_payee", this.getModel().getValue("payorg", rowIndex), rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_payeename", "e_payeetype"});
            } else if (PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(typeNumber) || PayAndRecBizTypeEnum.FUNDS_ALLOCATE.getValue().equals(typeNumber)) {
                this.getModel().setValue("e_payeetype", (Object)"bos_org", rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_payeetype"});
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_payeename"});
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void changedEntryPayInfo(String templeKey, int rowIndex) {
        String key = templeKey.substring(2);
        this.getModel().setValue("entry_" + key, this.getValue(templeKey), rowIndex);
    }
}

