/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.opservice.helper.PaymentPayeeInfo;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.formplugin.payapply.PaymentChannelHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicListHelper;
import kd.fi.cas.helper.PayApplyHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.info.SCAccountInfo;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyEdit
extends BillEditPlugin {
    private static final Log logger = LogFactory.getLog(PayApplyEdit.class);
    private static final String SUBMIT_CONFIRMCALLBACK = "submit_confirmcallback";
    private static final String COMFIRMSCHE_CONFIRMCALLBACK = "comfirmsche_confirmcallback";
    private static final String CHECKDRAFTBILL = "CheckDraftBill";
    private static final String ISELECPAYMENT = "iselecpayment";
    private String labCurrencySign;
    private int currencyAmtprecision;
    private Format currencyFormat;
    private static final List<String> BTN_ENTRY = Arrays.asList("paydeleteentry", "applyentryentryup", "applyentryentrydown", "paymoveentryup", "paymoveentrydown");

    private void initFormat() {
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        fobj.getCurrencyFormat().setCurrencySymbols(this.labCurrencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(this.currencyAmtprecision);
        this.currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payeeName = (TextEdit)this.getView().getControl("e_payeename");
        payeeName.addButtonClickListener((ClickListener)this);
        TextEdit payeeBankNum = (TextEdit)this.getView().getControl("e_payeeaccbanknum");
        payeeBankNum.addButtonClickListener((ClickListener)this);
        this.payerAcctBank();
        this.ePayeeAccBank();
        this.eUserAccBank();
        this.entryPayerAcctBank();
        this.payOrg();
        this.payee();
        this.entrySettlementType();
        this.applySettlementType();
        this.entryPayCurrency();
    }

    private void payee() {
        BasedataEdit payee = (BasedataEdit)this.getControl("e_payee");
        payee.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (this.isCompany()) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("fisbankroll", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void payOrg() {
        BasedataEdit payOrgF7 = (BasedataEdit)this.getControl("payorg");
        payOrgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject[] finishInitArrays = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id, org", (QFilter[])new QFilter("isfinishinit", "=", (Object)"1").toArray());
            List finishInitOrgIds = Arrays.stream(finishInitArrays).filter(f -> f.getDynamicObject("org") != null).map(f -> f.getDynamicObject("org").getPkValue()).collect(Collectors.toList());
            showPara.getListFilterParameter().setFilter(new QFilter("id", "in", finishInitOrgIds));
        });
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("e_payeename".equals(key) || "e_payeeaccbanknum".equals(key)) {
            Object payee;
            String ePayeeType = (String)this.getValue("e_payeetype");
            Object paymentType = this.getModel().getValue("paymenttype");
            String errMsg = "";
            if (Objects.isNull(paymentType)) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u7c7b\u578b\u3002", (String)"PayApplyEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isEmpty((CharSequence)ePayeeType)) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"PayApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("cas_payapplyentry");
            if ("e_payeeaccbanknum".equals(key) && this.isUser(rowIndex) && EmptyUtil.isEmpty((Object)(payee = this.getModel().getValue("e_payee", rowIndex)))) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"PayApplyEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (!StringUtils.isEmpty((CharSequence)errMsg)) {
                this.getView().showTipNotification(errMsg, Integer.valueOf(3000));
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey().toLowerCase()) {
            case "e_payeename": {
                this.payeeName();
                break;
            }
            case "e_payeeaccbanknum": {
                if (this.isUser()) {
                    BasedataEdit erPayee = (BasedataEdit)this.getControl("e_useraccbank");
                    erPayee.click();
                    break;
                }
                if (this.isSupplier() || this.isCustomer()) {
                    this.showAccountBankInfoF7();
                    break;
                }
                if (!this.isCompany()) break;
                BasedataEdit payeeAcctBank = (BasedataEdit)this.getControl("e_payeeaccbank");
                payeeAcctBank.click();
            }
        }
    }

    private void payeeName() {
        String ePayeeType = this.getValue("e_payeetype").toString();
        if (StringUtils.isEmpty((CharSequence)ePayeeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"PayApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        if (AsstActTypeEnum.EMPLOYEE.getValue().equals(ePayeeType) || AsstActTypeEnum.SUPPLIER.getValue().equals(ePayeeType) || AsstActTypeEnum.CUSTOMER.getValue().equals(ePayeeType) || AsstActTypeEnum.COMPANY.getValue().equals(ePayeeType)) {
            ItemClassEdit payeeAcctBank = (ItemClassEdit)this.getControl("e_payee");
            payeeAcctBank.addBeforeF7SelectListener(e -> {
                DynamicObject paymentType = (DynamicObject)this.getModel().getValue("paymenttype");
                if (PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(paymentType.get("biztype")) || PayAndRecBizTypeEnum.FUNDS_ALLOCATE.getValue().equals(paymentType.get("biztype"))) {
                    ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                    QFilter qFilter = new QFilter("fisbankroll", "=", (Object)"1").and(new QFilter("enable", "=", (Object)"1"));
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
                if (AsstActTypeEnum.SUPPLIER.getValue().equals(ePayeeType)) {
                    QFilter qFilter = new QFilter("payhold", "=", (Object)"0");
                    ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            });
            payeeAcctBank.click();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if (Objects.equals(entryName, "cas_payapplyentry")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_payapplyentry");
            int length = entryEntity.size();
            DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
            this.getModel().setValue("e_settlementtype", (Object)defaultSettleType, length - 1);
            DynamicObject paymentType = (DynamicObject)this.getModel().getValue("paymenttype");
            if (Objects.nonNull(paymentType)) {
                if (PayAndRecBizTypeEnum.TRANSFER_SAME.getValue().equals(paymentType.get("biztype"))) {
                    this.getModel().setValue("e_payeetype", (Object)"bos_org", length - 1);
                    this.getModel().setValue("e_payee", this.getModel().getValue("payorg"), length - 1);
                    this.getView().setEnable(Boolean.FALSE, length - 1, new String[]{"e_payeename", "e_payeetype"});
                } else if (PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(paymentType.get("biztype")) || PayAndRecBizTypeEnum.FUNDS_ALLOCATE.getValue().equals(paymentType.get("biztype"))) {
                    this.getModel().setValue("e_payeetype", (Object)"bos_org", length - 1);
                    this.getView().setEnable(Boolean.FALSE, length - 1, new String[]{"e_payeetype"});
                    this.getView().setEnable(Boolean.TRUE, length - 1, new String[]{"e_payeename"});
                }
            }
            this.updateDraftInfo();
            this.payApplyAmountSum();
        } else if (Objects.equals(entryName, "cas_payinfo")) {
            this.payAmountSum();
        }
    }

    private boolean isUser() {
        return this.isAimType(AsstActTypeEnum.EMPLOYEE);
    }

    private boolean isUser(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.EMPLOYEE, rowIndex);
    }

    private boolean isSupplier() {
        return this.isAimType(AsstActTypeEnum.SUPPLIER);
    }

    private boolean isSupplier(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.SUPPLIER, rowIndex);
    }

    private boolean isCustomer() {
        return this.isAimType(AsstActTypeEnum.CUSTOMER);
    }

    private boolean isCustomer(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.CUSTOMER, rowIndex);
    }

    private boolean isCompany() {
        return this.isAimType(AsstActTypeEnum.COMPANY);
    }

    private boolean isCompany(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.COMPANY, rowIndex);
    }

    private boolean isOther() {
        return this.isAimType(AsstActTypeEnum.OTHER);
    }

    private boolean isOther(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.OTHER, rowIndex);
    }

    private boolean isAimType(AsstActTypeEnum asstActType) {
        Object payeeType = this.getValue("e_payeetype");
        return asstActType.getValue().equals(payeeType);
    }

    private boolean isAimType(AsstActTypeEnum asstActType, int rowIndex) {
        Object payeeType = this.getValue("e_payeetype", rowIndex);
        return asstActType.getValue().equals(payeeType);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject applyOrg = this.getDynamicObject("applyorg");
        DynamicObject payOrg = this.getDynamicObject("payorg");
        if (applyOrg == null) {
            this.setValue("applyorg", RequestContext.get().getOrgId());
        }
        boolean isPartPayment = payOrg == null ? false : SystemParameterHelper.getParameterBoolean((long)payOrg.getLong("id"), (String)"ispartpayment");
        this.setValue("ispartpayment", isPartPayment);
        DynamicObject standardCurrency = this.getStandardCurrencyAndCheckInit(payOrg);
        applyOrg = this.getDynamicObject("applyorg");
        long applyOrgId = applyOrg == null ? 0L : applyOrg.getLong("id");
        DynamicObject defaultPayAccount = AccountBankHelper.getDefaultPayAccount((Long)applyOrgId);
        DynamicObject payeeCurrency = this.getDynamicObject("payeecurrency");
        DynamicObject payerAcctBank = this.getDynamicObject("payeracctbank");
        if (payeeCurrency == null && standardCurrency != null) {
            this.setValue("payeecurrency", standardCurrency);
        }
        if (payerAcctBank == null) {
            this.setValue("payeracctbank", defaultPayAccount);
        }
        this.fillDefaultSettleType();
    }

    private void fillDefaultSettleType() {
        DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
        int entryRowCount = this.getModel().getEntryRowCount("cas_payapplyentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue("e_settlementtype", (Object)defaultSettleType, i);
        }
        int entryRowCountInfo = this.getModel().getEntryRowCount("cas_payinfo");
        for (int i = 0; i < entryRowCountInfo; ++i) {
            this.getModel().setValue("entry_settlementtype", (Object)defaultSettleType, i);
            PaymentChannelHelper.initPaymentChannel(i, defaultSettleType, (DynamicObject)this.getModel().getValue("entry_payeraccbank", i), this.getView());
        }
    }

    private DynamicObject getStandardCurrencyAndCheckInit(DynamicObject payOrg) {
        boolean finishInit;
        boolean isFinishInitSetting = true;
        DynamicObject standardCurrency = null;
        try {
            if (payOrg != null) {
                standardCurrency = SystemStatusCtrolHelper.getStandardCurrency((long)((Long)payOrg.getPkValue()));
            }
        }
        catch (KDBizException e1) {
            logger.error((Throwable)e1);
            this.getView().showTipNotification(e1.getMessage());
            isFinishInitSetting = false;
        }
        if (payOrg == null) {
            long orgId = RequestContext.get().getOrgId();
            if (orgId != 0L && this.isFisbankroll(orgId)) {
                this.setValue("payorg", orgId);
            }
        } else if (!this.isFisbankroll((Long)payOrg.getPkValue())) {
            this.setValue("payorg", null);
        } else if (isFinishInitSetting && !(finishInit = SystemStatusCtrolHelper.isFinishInit((long)((Long)payOrg.getPkValue())))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"PayApplyEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        return standardCurrency;
    }

    private boolean isFisbankroll(Long orgId) {
        DynamicObject payOrgDynamicObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"fisbankroll");
        return payOrgDynamicObject.getBoolean("fisbankroll");
    }

    public void afterBindData(EventObject e) {
        Object value;
        List workflowlist;
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean showConer = true;
        if (customParams.get("showConer") != null) {
            showConer = (Boolean)customParams.get("showConer");
        }
        if (CollectionUtils.isEmpty((Collection)(workflowlist = WorkflowServiceHelper.getAllApprovalRecord((String)this.getModel().getDataEntity().getPkValue().toString()))) || !showConer.booleanValue()) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.right, true);
            control.setCollapse("splitpanelap1", true);
        }
        if ((value = this.getModel().getValue("paymenttype")) != null) {
            DynamicObject paymentType = (DynamicObject)value;
            this.bindByPaymentType(paymentType);
            this.updatePayeeType(paymentType);
        }
        this.visibleRefresh();
        this.getModel().setDataChanged(false);
        this.payApplyAmountSum();
        this.payAmountSum();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.payApplyAmountSum();
        this.payAmountSum();
    }

    private void visibleRefresh() {
        Object billNo = this.getModel().getValue("billno");
        QFilter filter = new QFilter("billno", "=", billNo);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] payApplyBill = BusinessDataServiceHelper.load((String)"cas_payapplybill", (String)"id", (QFilter[])filters);
        if (payApplyBill.length == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_refresh"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_refresh"});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_pushtopaybill".equals(key)) {
            DynamicObject info = this.getModel().getDataEntity();
            if (info.getBoolean("invalidflag")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PayApplyEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String billStatus = (String)info.get("billstatus");
            if (!billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u901a\u8fc7\u7684\u7533\u8bf7\u5355\u5141\u8bb8\u4e0b\u63a8\u4ed8\u6b3e\u5904\u7406", (String)"PayApplyEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection applyEntryCol = this.getModel().getEntryEntity("cas_payapplyentry");
            applyEntryCol.stream().filter(Objects::nonNull).forEach(entry -> {
                String chgstatus = entry.getString("e_chgstatus");
                if (chgstatus.equals(PayApplyRecChgStatusEnum.CHGING.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u7533\u8bf7\u5206\u5f55\u6570\u636e\u5904\u4e8e\u201c\u53d8\u66f4\u4e2d\u201d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PayApplyComfirmScheValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            });
        }
    }

    private void updatePayeeType(DynamicObject paymentType) {
        boolean isSelectallpayertype = false;
        DynamicObject payorg = (DynamicObject)this.getModel().getValue("payorg");
        if (EmptyUtil.isNoEmpty((DynamicObject)payorg)) {
            isSelectallpayertype = SystemParameterHelper.getParameterBoolean((long)payorg.getLong("id"), (String)"selectallpayeetype");
        }
        ItemClassTypeEdit ePayeeType = (ItemClassTypeEdit)this.getControl("e_payeetype");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem customerCI = new ComboItem();
        customerCI.setCaption(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()));
        customerCI.setValue(AsstActTypeEnum.CUSTOMER.getValue());
        ComboItem supplierCI = new ComboItem();
        supplierCI.setCaption(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()));
        supplierCI.setValue(AsstActTypeEnum.SUPPLIER.getValue());
        ComboItem employeeCI = new ComboItem();
        employeeCI.setCaption(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()));
        employeeCI.setValue(AsstActTypeEnum.EMPLOYEE.getValue());
        ComboItem companyCI = new ComboItem();
        companyCI.setCaption(new LocaleString(AsstActTypeEnum.COMPANY.getName()));
        companyCI.setValue(AsstActTypeEnum.COMPANY.getValue());
        ComboItem otherCI = new ComboItem();
        otherCI.setCaption(new LocaleString(AsstActTypeEnum.OTHER.getName()));
        otherCI.setValue(AsstActTypeEnum.OTHER.getValue());
        String bizType = paymentType.getString("biztype");
        boolean isPartPayment = paymentType.getBoolean("ispartpayment");
        if (bizType.equals(PayAndRecBizTypeEnum.TRANSFER_SAME.getValue()) || bizType.equals(PayAndRecBizTypeEnum.CASH_ACCESS.getValue())) {
            comboItems.add(companyCI);
            ePayeeType.setComboItems(comboItems);
            ePayeeType.selectedStore(companyCI);
        }
        if (isPartPayment) {
            comboItems.add(supplierCI);
            comboItems.add(customerCI);
            comboItems.add(employeeCI);
            ePayeeType.setComboItems(comboItems);
        } else {
            comboItems.add(supplierCI);
            comboItems.add(customerCI);
            if (!comboItems.contains(companyCI)) {
                comboItems.add(companyCI);
            }
            comboItems.add(employeeCI);
            comboItems.add(otherCI);
            ePayeeType.setComboItems(comboItems);
        }
        if (isSelectallpayertype) {
            if (!comboItems.contains(companyCI)) {
                comboItems.add(companyCI);
            }
            if (!comboItems.contains(otherCI)) {
                comboItems.add(otherCI);
            }
            ePayeeType.setComboItems(comboItems);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Set settlementType;
        DynamicObject payeecurrency;
        DynamicObjectCollection payApplyEntry;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (Objects.equals(operateKey, "save") || Objects.equals(operateKey, "submit")) {
            payApplyEntry = this.getModel().getEntryEntity("cas_payapplyentry");
            ArrayList<String> checkBankNumErrorRows = new ArrayList<String>(payApplyEntry.size());
            for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
                this.fillByPayeeType(checkBankNumErrorRows, rowIndex);
            }
        }
        if (Objects.equals(operateKey, "submit") || Objects.equals(operateKey, "comfirmsche")) {
            List<String> errorRows = this.checkDraftBill(this.getCheckDraftBill());
            this.setCheckDraftBill(Boolean.FALSE);
            if (!errorRows.isEmpty()) {
                String result = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5df2\u9009\u7968\u636e\u7968\u9762\u91d1\u989d\u5408\u8ba1\u4e0e\u6536\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayApplyEdit_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errorRows));
                if (Objects.equals(operateKey, "submit")) {
                    this.getView().showConfirm(result, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(SUBMIT_CONFIRMCALLBACK, (IFormPlugin)this));
                } else {
                    this.getView().showConfirm(result, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(COMFIRMSCHE_CONFIRMCALLBACK, (IFormPlugin)this));
                }
                args.setCancel(true);
            }
        }
        if (Objects.equals(operateKey, "push")) {
            payApplyEntry = this.getModel().getEntryEntity("cas_payapplyentry");
            BigDecimal payApplyAmt = BigDecimal.ZERO;
            for (DynamicObject entry2 : payApplyEntry) {
                payApplyAmt = payApplyAmt.add(entry2.getBigDecimal("e_payeeamount"));
            }
            DynamicObjectCollection payInfoEntry = this.getModel().getEntryEntity("cas_payinfo");
            BigDecimal payInfoAmt = BigDecimal.ZERO;
            for (DynamicObject entry3 : payInfoEntry) {
                String payStatus = entry3.getString("entry_paystatus");
                if (payStatus.equals(PayStatusEnum.CLANCEL.getValue())) continue;
                payInfoAmt = payInfoAmt.add(entry3.getBigDecimal("entry_payeeamount"));
            }
            if ((payInfoAmt = this.calAmountSumWithRefundAndReNote(payInfoAmt)).compareTo(payApplyAmt) != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u5206\u5f55\u548c\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7684\u6536\u6b3e\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4e0b\u63a8\u4ed8\u6b3e\u3002", (String)"PayApplyEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (PayApplyHelper.checkPayeeTypeFreeze(Collections.singletonList(this.getModel().getDataEntity()))) {
                this.getView().showErrorNotification(new PaymentErrorCode().CANOTDOTHISOP_WHENSUPPLIERFREEZE().getMessage());
                args.setCancel(true);
            }
        }
        if (Objects.equals(operateKey, "paysplit") && EmptyUtil.isEmpty((DynamicObject)(payeecurrency = (DynamicObject)this.getModel().getValue("payeecurrency")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u3002", (String)"PayApplyEdit_19", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if ("batchsche".equals(operateKey) && (settlementType = (payApplyEntry = this.getModel().getEntryEntity("cas_payapplyentry")).stream().filter(Objects::nonNull).filter(entry -> EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("e_settlementtype"))).map(entry -> entry.getDynamicObject("e_settlementtype").getString("settlementtype")).collect(Collectors.toSet())).contains(SettleMentTypeEnum.DCEP.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u4e3a\u6570\u5e01\u94b1\u5305\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u6392\u6b3e\u3002", (String)"PayApplyEdit_23", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        OperationResult result = null;
        if (SUBMIT_CONFIRMCALLBACK.equals(id) && MessageBoxResult.Yes == res) {
            this.setCheckDraftBill(Boolean.TRUE);
            result = this.getView().invokeOperation("submit");
        } else if (COMFIRMSCHE_CONFIRMCALLBACK.equals(id) && MessageBoxResult.Yes == res) {
            this.setCheckDraftBill(Boolean.TRUE);
            result = this.getView().invokeOperation("comfirmsche");
        }
        if (result == null || !result.isSuccess()) {
            // empty if block
        }
    }

    private boolean getCheckDraftBill() {
        return Boolean.parseBoolean(this.getPageCache().get(CHECKDRAFTBILL));
    }

    private void setCheckDraftBill(Boolean isCheckDraftBill) {
        this.getPageCache().put(CHECKDRAFTBILL, isCheckDraftBill.toString().toLowerCase());
    }

    private List<String> checkDraftBill(boolean result) {
        ArrayList<String> errorRows = new ArrayList<String>(0);
        if (result) {
            return errorRows;
        }
        DynamicObjectCollection payApplyEntry = this.getModel().getEntryEntity("cas_payapplyentry");
        for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
            DynamicObject payEntry = this.getModel().getEntryRowEntity("cas_payinfo", rowIndex);
            DynamicObjectCollection draftbill = payEntry.getDynamicObjectCollection("entry_draftbill");
            if (draftbill == null || draftbill.size() <= 0 || payEntry.getBigDecimal("entry_draftamttotal").compareTo(payEntry.getBigDecimal("entry_payeeamount")) == 0) continue;
            errorRows.add(String.valueOf(rowIndex + 1));
        }
        return errorRows;
    }

    private void fillByPayeeType(List<String> errorRows, int rowIndex) {
        DynamicObject internalOrg;
        if (this.isSupplier(rowIndex) || this.isCustomer(rowIndex)) {
            DynamicObject internalOrg2;
            DynamicObject ePayee = this.getDynamicObject("e_payee", rowIndex);
            if (ePayee != null && (internalOrg2 = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg"), (DynamicObject)ePayee)) != null) {
                this.checkPayeeAccBank(errorRows, rowIndex, internalOrg2);
            }
        } else if (this.isCompany(rowIndex) && (internalOrg = (DynamicObject)this.getModel().getValue("e_payee", rowIndex)) != null) {
            this.checkPayeeAccBank(errorRows, rowIndex, internalOrg);
        }
    }

    private void checkPayeeAccBank(List<String> errorRows, int rowIndex, DynamicObject internalOrg) {
        QFilter bankNumberFilter;
        QFilter useOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)((Long)internalOrg.getPkValue()));
        DynamicObject[] bankAccounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id, bank.bebank", (QFilter[])new QFilter[]{useOrgFilter, bankNumberFilter = new QFilter("bankaccountnumber", "=", this.getModel().getValue("e_payeeaccbanknum", rowIndex))});
        if (bankAccounts == null || bankAccounts.length == 0) {
            if (BaseDataHelper.isInternalOrg((DynamicObject)this.getDynamicObject("payorg"))) {
                errorRows.add(String.valueOf(rowIndex + 1));
            } else if (QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{useOrgFilter})) {
                errorRows.add(String.valueOf(rowIndex + 1));
            }
        } else {
            this.getModel().setValue("e_payeeaccbank", bankAccounts[0].getPkValue(), rowIndex);
            String accountName = (String)this.getModel().getValue("e_accountname", rowIndex);
            if (StringUtils.isEmpty((CharSequence)accountName)) {
                this.fillAccountName(rowIndex, null);
            }
            DynamicObject beBank = (DynamicObject)bankAccounts[0].get("bank.bebank");
            this.getModel().setValue("e_payeebank", (Object)beBank, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (BTN_ENTRY.contains(opKey)) {
            this.getView().updateView("cas_payinfo");
            this.updateDraftInfo();
        }
        if (operationResult == null) {
            return;
        }
        if ("save".equals(opKey) || "submit".equals(opKey)) {
            this.visibleRefresh();
            if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void updateDraftInfo() {
        HashMap<Long, Integer> draftIdInfo = new HashMap<Long, Integer>();
        DynamicObjectCollection draftInfos = this.getModel().getEntryEntity("cas_draftinfo");
        DynamicObjectCollection payInfos = this.getModel().getEntryEntity("cas_payinfo");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfos)) {
            Integer seq;
            for (DynamicObject info : payInfos) {
                DynamicObjectCollection draftBills = info.getDynamicObjectCollection("entry_draftbill");
                seq = info.getInt("Seq");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)draftBills)) continue;
                for (DynamicObject draftBill : draftBills) {
                    Long draftid = draftBill.getDynamicObject("fbasedataid").getLong("id");
                    draftIdInfo.put(draftid, seq);
                }
            }
            for (DynamicObject draftInfo : draftInfos) {
                Long draftId = draftInfo.getDynamicObject("draftbillinfo").getLong("id");
                seq = (Integer)draftIdInfo.get(draftId);
                Integer draftSeq = draftInfo.getInt("srcbillindex");
                if (draftSeq.equals(seq)) continue;
                draftInfo.set("srcbillindex", (Object)seq);
            }
            this.getView().updateView("cas_draftinfo");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String payeeName;
        DynamicObject payee;
        Set ids;
        QFilter qFilter;
        DynamicObject acc;
        String ePayeeName;
        Object oldValue;
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        if (fieldKey.equals("paymenttype") && newValue != null) {
            this.clearEntryPayeeInfo();
            DynamicObject paymentType = (DynamicObject)newValue;
            this.bindByPaymentType(paymentType);
            this.updatePayeeType(paymentType);
        }
        if (fieldKey.equals("e_payeeaccbanknum") && newValue != null) {
            DynamicObject payeeAccBank;
            String payeeName2 = (String)this.getValue("e_payeename", rowIndex);
            if (EmptyUtil.isBlank((CharSequence)payeeName2) && !this.isCompany(rowIndex)) {
                this.getModel().beginInit();
                this.setValue("e_payeeaccbanknum", oldValue);
                this.getModel().endInit();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"PayApplyEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            ePayeeName = (String)this.getModel().getValue("e_payeename");
            if (this.isCompany(rowIndex) && EmptyUtil.isBlank((CharSequence)ePayeeName) && (acc = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,company,acctname,bank.bebank", (QFilter[])new QFilter[]{qFilter = new QFilter("bankaccountnumber", "=", (Object)((String)newValue))})) != null) {
                ids = AccountBankHelper.getUserAuthorityOrgs((Long)acc.getLong("id"));
                if (ids.size() == 1) {
                    this.setValue("e_payeename", acc.get("company.name"), rowIndex);
                    this.setValue("e_payeeaccbankid", acc.getPkValue(), rowIndex);
                    this.setValue("e_payeebank", acc.get("bank.bebank"), rowIndex);
                    this.setValue("e_accountname", acc.get("acctname"), rowIndex);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d26\u6237\u5206\u914d\u7ed9\u591a\u5bb6\u7ec4\u7ec7\u4f7f\u7528\uff0c\u65e0\u6cd5\u627e\u5230\u552f\u4e00\u8d44\u91d1\u7ec4\u7ec7\u8d4b\u503c\u5230\u6536\u6b3e\u4eba\u3002\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u540e\u518d\u586b\u5199\u6536\u6b3e\u8d26\u53f7\u3002", (String)"PayApplyEdit_20", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
            }
            if ((payeeAccBank = (DynamicObject)this.getValue("e_payeeaccbank", rowIndex)) != null && !Objects.equals(payeeAccBank.get("number"), newValue)) {
                this.setValue("e_payeeaccbank", null, rowIndex);
                this.setValue("e_payeebank", null, rowIndex);
            }
            this.fillAccountName(rowIndex, null);
            if (StringUtils.isEmpty((CharSequence)((String)newValue))) {
                this.setValue("e_accountname", null, rowIndex);
                this.setValue("e_institutioncode", null, rowIndex);
                this.setValue("e_institutionname", null, rowIndex);
                this.setValue("e_payeebank", null, rowIndex);
            }
        }
        if (fieldKey.equals("e_payeeamount") && newValue != null) {
            this.calPayeeAmountTotal();
        }
        if (fieldKey.equals("e_payeetype") && newValue != null) {
            this.setValue("e_payee", null, rowIndex);
            this.setValue("e_payeeid", null, rowIndex);
            this.setValue("e_payeename", null, rowIndex);
            this.setValue("e_payeeaccbank", null, rowIndex);
            this.setValue("e_payeeaccbankid", null, rowIndex);
            this.setValue("e_payeeaccbanknum", null, rowIndex);
            this.setValue("e_useraccbank", null, rowIndex);
            this.setValue("e_payeebank", null, rowIndex);
            this.setValue("e_accountname", null, rowIndex);
            this.setValue("e_institutioncode", null, rowIndex);
            this.setValue("e_institutionname", null, rowIndex);
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"e_accountname"});
        }
        if (fieldKey.equals("e_payee")) {
            this.setValue("e_payeeaccbank", null, rowIndex);
            this.setValue("e_payeeaccbankid", null, rowIndex);
            this.setValue("e_payeeaccbanknum", null, rowIndex);
            this.setValue("e_useraccbank", null, rowIndex);
            this.setValue("e_payeebank", null, rowIndex);
            this.setValue("e_accountname", null, rowIndex);
            if (newValue == null) {
                return;
            }
            this.setValue("e_payeename", ((DynamicObject)newValue).get("name"), rowIndex);
            this.setValue("e_payeeid", ((DynamicObject)newValue).get("id"), rowIndex);
            String businessType = (String)this.getModel().getValue("e_businesstype", rowIndex);
            if (EmptyUtil.isEmpty((String)businessType)) {
                if (this.isSupplier(rowIndex) || this.isCustomer(rowIndex)) {
                    this.supplierOrCustomerChanged((DynamicObject)newValue, rowIndex);
                } else if (this.isUser(rowIndex)) {
                    this.userF7Changed((DynamicObject)newValue, rowIndex);
                } else if (this.isCompany(rowIndex)) {
                    this.orgF7Changed((DynamicObject)newValue, rowIndex);
                }
            }
        }
        if (fieldKey.equals("e_payeename") && newValue != null && !this.isOther() && (payee = this.getDynamicObject("e_payee", rowIndex)) != null && !(payeeName = payee.getString("name")).equals(newValue)) {
            this.getModel().setValue("e_payeename", (Object)payeeName, rowIndex);
        }
        if (fieldKey.equals("e_payeeaccbank") && newValue != null) {
            this.setValue("e_payeeaccbankid", null, rowIndex);
            this.setValue("e_payeeaccbanknum", null, rowIndex);
            this.setValue("e_payeebank", null, rowIndex);
            PaymentPayeeInfo paymentPayeeInfo = PaymentPayeeInfo.createByAccountBank((DynamicObject)((DynamicObject)newValue));
            this.setValue("e_payeeaccbanknum", paymentPayeeInfo.getAccountNumber(), rowIndex);
            ePayeeName = (String)this.getModel().getValue("e_payeename");
            if (this.isCompany(rowIndex) && EmptyUtil.isBlank((CharSequence)ePayeeName) && (acc = BusinessDataServiceHelper.loadSingle((String)"am_accountbank", (String)"id,company", (QFilter[])new QFilter[]{qFilter = new QFilter("bankaccountnumber", "=", (Object)paymentPayeeInfo.getAccountNumber())})) != null && (ids = AccountBankHelper.getUserAuthorityOrgs((Long)acc.getLong("id"))).size() != 1) {
                this.setValue("e_accountname", null, rowIndex);
                return;
            }
            this.setValue("e_payeeaccbankid", ((DynamicObject)newValue).getPkValue(), rowIndex);
            this.setValue("e_payeebank", paymentPayeeInfo.getBebankId(), rowIndex);
            DynamicObject accBank = (DynamicObject)newValue;
            this.setValue("e_payeename", accBank.get("company.name"), rowIndex);
        }
        if (fieldKey.equals("e_useraccbank") && newValue != null) {
            this.setValue("e_payeeaccbank", null, rowIndex);
            this.setValue("e_payeeaccbankid", null, rowIndex);
            this.setValue("e_payeeaccbanknum", null, rowIndex);
            this.setValue("e_payeebank", null, rowIndex);
            DynamicObject erPayee = (DynamicObject)newValue;
            this.setValue("e_payeeaccbanknum", erPayee.getString("payeraccount"), rowIndex);
            this.setValue("e_payeeaccbankid", erPayee.getPkValue(), rowIndex);
            this.setValue("e_payeebank", erPayee.getDynamicObject("payerbank"), rowIndex);
            this.fillAccountName(rowIndex, null);
        }
        if (fieldKey.equals("payeecurrency") && newValue != null) {
            this.clearRecInfo((DynamicObject)newValue);
        }
        if (fieldKey.equals("payorg") || fieldKey.equals("payeecurrency")) {
            this.payApplyAmountSum();
            this.payAmountSum();
        }
        if (fieldKey.equals("e_payeeamount") || fieldKey.equals("e_paidamount")) {
            this.payApplyAmountSum();
        } else if (fieldKey.equals("entry_payeeamount")) {
            this.payAmountSum();
        }
        if ("e_businesstype".equals(fieldKey)) {
            this.setValue("entry_businesstype", newValue, rowIndex);
        }
        switch (fieldKey) {
            case "refundandrepay": {
                this.payAmountSum();
                break;
            }
        }
    }

    private void bindByPaymentType(DynamicObject paymentType) {
        if (PayAndRecBizTypeEnum.TRANSFER_SAME.getValue().equals(paymentType.get("biztype"))) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_payapplyentry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getModel().setValue("e_payeetype", (Object)"bos_org", i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_payeename", "e_payeetype"});
                this.getModel().setValue("e_payee", this.getModel().getValue("payorg"), i);
            }
        } else if (PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(paymentType.get("biztype")) || PayAndRecBizTypeEnum.FUNDS_ALLOCATE.getValue().equals(paymentType.get("biztype"))) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_payapplyentry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getModel().setValue("e_payeetype", (Object)"bos_org", i);
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_payeename"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_payeetype"});
            }
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_payapplyentry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_payeename", "e_payeetype"});
            }
        }
    }

    private void clearRecInfo(DynamicObject payeeCurrency) {
        DynamicObjectCollection applyEntry = this.getModel().getEntryEntity("cas_payapplyentry");
        for (int i = 0; i < applyEntry.size(); ++i) {
            DynamicObject payeeAccBank;
            DynamicObject row = (DynamicObject)applyEntry.get(i);
            if (this.isSupplier(i) || this.isCustomer(i)) {
                DynamicObject currency = this.getEntryBankCurrency(row);
                if (currency == null || Objects.equals(currency.getPkValue(), payeeCurrency.getPkValue())) continue;
                this.getModel().setValue("e_payeeaccbanknum", null, i);
                this.getModel().setValue("e_accountname", null, i);
                this.getModel().setValue("e_payeebank", null, i);
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_accountname"});
                continue;
            }
            if (this.isUser(i)) {
                DynamicObject currency;
                DynamicObject userAccBank = (DynamicObject)this.getModel().getValue("e_useraccbank", i);
                if (!Objects.nonNull(userAccBank) || !Objects.nonNull(currency = userAccBank.getDynamicObject("currency")) || Objects.equals(payeeCurrency.getPkValue(), currency.getPkValue())) continue;
                this.getModel().setValue("e_payeeaccbanknum", null, i);
                this.getModel().setValue("e_accountname", null, i);
                this.getModel().setValue("e_payeebank", null, i);
                this.getModel().setValue("e_useraccbank", null, i);
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_accountname"});
                continue;
            }
            if (!this.isCompany(i) || !Objects.nonNull(payeeAccBank = (DynamicObject)this.getModel().getValue("e_payeeaccbank")) || Objects.equals(payeeAccBank.getDynamicObject("defaultcurrency").getPkValue(), payeeCurrency.getPkValue())) continue;
            this.getModel().setValue("e_payeeaccbanknum", null, i);
            this.getModel().setValue("e_accountname", null, i);
            this.getModel().setValue("e_payeebank", null, i);
            this.getModel().setValue("e_payeeaccbank", null, i);
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_accountname"});
        }
    }

    private DynamicObject getEntryBankCurrency(DynamicObject row) {
        DynamicObject payee = row.getDynamicObject("e_payee");
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg"), (DynamicObject)payee);
        if (Objects.nonNull(internalOrg)) {
            DynamicObject defaultPayAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)internalOrg.getPkValue()));
            return defaultPayAccount == null ? null : defaultPayAccount.getDynamicObject("defaultcurrency");
        }
        String payeeAccBankNum = row.getString("e_payeeaccbanknum");
        if (Objects.nonNull(payee)) {
            DynamicObject payeeFromDB = BusinessDataServiceHelper.loadSingle((Object)payee.getPkValue(), (String)payee.getDynamicObjectType().getName(), (String)"entry_bank, entry_bank.bankaccount, entry_bank.currency");
            DynamicObjectCollection entryBank = payeeFromDB.getDynamicObjectCollection("entry_bank");
            for (DynamicObject entryBankRow : entryBank) {
                String bankAccount = entryBankRow.getString("bankaccount");
                if (!Objects.equals(payeeAccBankNum, bankAccount)) continue;
                return entryBankRow.getDynamicObject("currency");
            }
        }
        return null;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String propName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)"cas_payapplyentry", (CharSequence)propName)) {
            this.calPayeeAmountTotal();
            this.updateDraftInfo();
            this.payApplyAmountSum();
        } else if (Objects.equals(propName, "cas_payinfo")) {
            this.payAmountSum();
        }
    }

    private void calPayeeAmountTotal() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("cas_payapplyentry");
        BigDecimal sum = dynamicObjects.stream().map(item -> item.get("e_payeeamount") == null ? BigDecimal.ZERO : new BigDecimal(item.get("e_payeeamount").toString())).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.setValue("payeeamount", sum);
    }

    private void payerAcctBank() {
        BasedataEdit payeeAcctBankF7 = (BasedataEdit)this.getControl("payeracctbank");
        payeeAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter qFilter = new QFilter("acctstatus", "!=", (Object)"closed");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("entry_paycurrency", beforeF7SelectEvent.getRow());
            if (currency != null) {
                qFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            }
            int rowIdx = this.getModel().getEntryCurrentRowIndex("cas_payinfo");
            String businessType = (String)this.getModel().getValue("entry_businesstype", rowIdx);
            if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                qFilter.and(ISELECPAYMENT, "!=", (Object)true);
            } else if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
                qFilter.and(ISELECPAYMENT, "=", (Object)true);
            } else if (PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                DynamicObject payee;
                DynamicObject internalOrg;
                String payeeType = (String)this.getModel().getValue("e_payeetype");
                if ("bos_org".equals(payeeType)) {
                    qFilter.and(ISELECPAYMENT, "=", (Object)true);
                } else if (("bd_supplier".equals(payeeType) || "bd_customer".equals(payeeType)) && (internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)(payee = (DynamicObject)this.getModel().getValue("e_payee")))) != null) {
                    qFilter.and(ISELECPAYMENT, "=", (Object)true);
                }
            } else {
                qFilter.and(ISELECPAYMENT, "!=", (Object)true);
            }
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showPara.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void entryPayerAcctBank() {
        BasedataEdit payeeAcctBankF7 = (BasedataEdit)this.getControl("entry_payeraccbank");
        payeeAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter qFilter = new QFilter("acctstatus", "!=", (Object)"closed");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("entry_paycurrency", beforeF7SelectEvent.getRow());
            if (currency != null) {
                qFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            }
            int rowIdx = this.getModel().getEntryCurrentRowIndex("cas_payinfo");
            String businessType = (String)this.getModel().getValue("entry_businesstype", rowIdx);
            if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                qFilter.and(ISELECPAYMENT, "!=", (Object)true);
            } else if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                qFilter.and(ISELECPAYMENT, "=", (Object)true);
            } else {
                qFilter.and(ISELECPAYMENT, "!=", (Object)true);
            }
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showPara.setCustomParam("filterTransferViewOrg", (Object)"1");
            showPara.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void entrySettlementType() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("cas_payinfo");
        DynamicObject applySettlementType = (DynamicObject)this.getModel().getValue("e_settlementtype", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)applySettlementType)) {
            return;
        }
        String settlementType = applySettlementType.getString("settlementtype");
        BasedataEdit entrySettlementTypeF7 = (BasedataEdit)this.getControl("entry_settlementtype");
        entrySettlementTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter qFilter = SettleMentTypeEnum.DCEP.getValue().equals(settlementType) ? new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.DCEP.getValue()) : new QFilter("settlementtype", "!=", (Object)SettleMentTypeEnum.DCEP.getValue());
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showPara.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void entryPayCurrency() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("cas_payinfo");
        DynamicObject applySettlementType = (DynamicObject)this.getModel().getValue("e_settlementtype", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)applySettlementType)) {
            return;
        }
        String settlementType = applySettlementType.getString("settlementtype");
        BasedataEdit entryPayCurrencyF7 = (BasedataEdit)this.getControl("entry_paycurrency");
        entryPayCurrencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (SettleMentTypeEnum.DCEP.getValue().equals(settlementType)) {
                QFilter qFilter = new QFilter("number", "=", (Object)"CNY");
                ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showPara.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void applySettlementType() {
        DynamicObject payeeCurrency = (DynamicObject)this.getModel().getValue("payeecurrency");
        BasedataEdit applySettlementTypeF7 = (BasedataEdit)this.getControl("e_settlementtype");
        applySettlementTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (EmptyUtil.isNoEmpty((DynamicObject)payeeCurrency)) {
                String currencyCode = payeeCurrency.getString("number");
                if (!"CNY".equals(currencyCode)) {
                    QFilter qFilter = new QFilter("settlementtype", "!=", (Object)SettleMentTypeEnum.DCEP.getValue());
                    ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    showPara.getListFilterParameter().setFilter(qFilter);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6536\u6b3e\u5e01\u79cd\u3002", (String)"PayApplyEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        });
    }

    private void ePayeeAccBank() {
        BasedataEdit payeeAcctBankF7 = (BasedataEdit)this.getControl("e_payeeaccbank");
        payeeAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject useOrg;
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("acctstatus", "in", (Object)new String[]{"normal", "freeze", "closing", "changing"});
            DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
            if (currency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6536\u6b3e\u5e01\u79cd\u3002", (String)"PayApplyEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            showPara.getListFilterParameter().setFilter(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            int rowIdx = this.getModel().getEntryCurrentRowIndex("cas_payapplyentry");
            String businessType = (String)this.getModel().getValue("e_businesstype", rowIdx);
            if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                qFilter.and(ISELECPAYMENT, "=", (Object)true);
            } else if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
                qFilter.and(ISELECPAYMENT, "!=", (Object)true);
            } else if (PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                DynamicObject payee;
                DynamicObject internalOrg;
                String payeeType = (String)this.getModel().getValue("e_payeetype");
                if ("bos_org".equals(payeeType)) {
                    qFilter.and(ISELECPAYMENT, "=", (Object)true);
                } else if (("bd_supplier".equals(payeeType) || "bd_customer".equals(payeeType)) && (internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)(payee = (DynamicObject)this.getModel().getValue("e_payee")))) != null) {
                    qFilter.and(ISELECPAYMENT, "=", (Object)true);
                }
            } else {
                qFilter.and(ISELECPAYMENT, "!=", (Object)true);
            }
            DynamicObject payee = (DynamicObject)this.getValue("e_payee");
            DynamicObject dynamicObject = useOrg = this.isCompany() ? payee : BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg"), (DynamicObject)payee);
            if (useOrg != null) {
                QFilter useOrgFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)((Long)useOrg.getPkValue()));
                qFilter.and(useOrgFilter);
            }
            logger.info("\u6536\u6b3e\u8d26\u53f7\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a{}", (Object)qFilter);
            showPara.setCustomParam("isclearcorefilter", (Object)"true");
            showPara.getListFilterParameter().setFilter(qFilter);
            showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_payeeaccbank"));
        });
    }

    private void eUserAccBank() {
        BasedataEdit eUserAccBankF7 = (BasedataEdit)this.getControl("e_useraccbank");
        eUserAccBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject ePayee = this.getDynamicObject("e_payee");
            if (ePayee != null) {
                QFilter qFilter = new QFilter("payer", "=", ePayee.getPkValue());
                ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
                if (currency != null) {
                    qFilter.and(new QFilter("currency.id", "is null", null).or(new QFilter("currency.id", "=", (Object)0).or(new QFilter("currency.id", "=", currency.getPkValue()))));
                }
                showPara.getListFilterParameter().setFilter(qFilter);
                List qFilters = showPara.getListFilterParameter().getQFilters();
                qFilters.removeIf(q -> q.toString().contains("t_er_Payee_U"));
                showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_useraccbank"));
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("payeeaccountbank".equals(actionId)) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 != null) {
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData2;
                Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
                String asstActType = this.getString("e_payeetype");
                SCAccountInfo scAccountInfo = BaseDataHelper.loadBankInfo((String)asstActType, (Long)((Long)entryKey));
                this.bindAccountBankInfo(scAccountInfo);
                this.fillAccountName(this.getModel().getEntryCurrentRowIndex("cas_payapplyentry"), returnData2);
            }
        } else if ("e_payeeaccbank".equals(actionId)) {
            Object returnData3 = closedCallBackEvent.getReturnData();
            if (returnData3 != null) {
                this.fillAccountName(this.getModel().getEntryCurrentRowIndex("cas_payapplyentry"), returnData3);
            }
        } else if ("e_useraccbank".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.fillAccountName(this.getModel().getEntryCurrentRowIndex("cas_payapplyentry"), returnData);
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getPrimaryKeyValues()[0];
            this.setValue("e_useraccbank", entryKey);
        }
    }

    private void fillAccountName(int rowIndex, Object returnData) {
        DynamicObject baseData = (DynamicObject)this.getModel().getValue("e_payee");
        if (this.isSupplier(rowIndex) || this.isCustomer(rowIndex)) {
            DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg"), (DynamicObject)baseData);
            if (internalOrg == null) {
                if (returnData != null) {
                    ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                    Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
                    SCAccountInfo bankInfo = BaseDataHelper.loadBankInfo((String)baseData.getDataEntityType().getName(), (Long)((Long)entryKey));
                    this.setValue("e_accountname", bankInfo.getAccountName(), rowIndex);
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"e_accountname"});
                } else {
                    this.setValue("e_accountname", this.getValue("e_payeename"), rowIndex);
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"e_accountname"});
                }
            } else {
                this.fillAccountNameByReturnData(rowIndex, returnData);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"e_accountname"});
            }
        } else if (this.isCompany(rowIndex)) {
            this.fillAccountNameByReturnData(rowIndex, returnData);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"e_accountname"});
        } else if (this.isUser(rowIndex)) {
            if (returnData != null) {
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                Object entryKey = rowInfo.getPrimaryKeyValues()[0];
                DynamicObject payeer = BusinessDataServiceHelper.loadSingle((Object)entryKey, (String)"er_payeer");
                this.setValue("e_accountname", payeer.get("payeraccountname"), rowIndex);
                this.setValue("e_payeeaccbanknum", payeer.get("payeraccount"), rowIndex);
                this.setValue("e_payeebank", payeer.get("payerbank"), rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"e_accountname"});
            } else {
                DynamicObject userAccBank = (DynamicObject)this.getValue("e_useraccbank", rowIndex);
                if (userAccBank != null) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)userAccBank.getPkValue(), (String)"er_payeer");
                    this.setValue("e_accountname", dynamicObject.get("payeraccountname"), rowIndex);
                } else {
                    this.setValue("e_accountname", this.getValue("e_payeename"), rowIndex);
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"e_accountname"});
            }
        }
    }

    private void fillAccountNameByReturnData(int rowIndex, Object returnData) {
        if (returnData != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getPrimaryKeyValues()[0];
            this.fillAccountNameByBankAccount(entryKey, rowIndex);
            this.setValue("e_payeeaccbank", entryKey, rowIndex);
        } else {
            DynamicObject payeeAccBank = (DynamicObject)this.getValue("e_payeeaccbank", rowIndex);
            if (payeeAccBank != null) {
                this.fillAccountNameByBankAccount(payeeAccBank.getPkValue(), rowIndex);
            }
        }
    }

    private void fillAccountNameByBankAccount(Object entryKey, int rowIndex) {
        DynamicObject accountBank = BusinessDataServiceHelper.loadSingle((Object)entryKey, (String)"bd_accountbanks");
        this.setValue("e_accountname", accountBank.get("acctname"), rowIndex);
        if (!accountBank.getBoolean("issetbankinterface")) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"e_accountname"});
        }
    }

    private void showAccountBankInfoF7() {
        DynamicObject ePayee = this.getDynamicObject("e_payee");
        if (ePayee == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"PayApplyEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg"), (DynamicObject)ePayee);
        if (internalOrg != null) {
            BasedataEdit ePayeeAccBank = (BasedataEdit)this.getControl("e_payeeaccbank");
            ePayeeAccBank.click();
        } else {
            SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)ePayee);
            if (defaultBankInfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"PayApplyEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = null;
            lsp = this.isSupplier() ? DynamicListHelper.getSupplierBankInfoShowParameter((Object)ePayee.getPkValue()) : DynamicListHelper.getCustomerBankInfoShowParameter((Object)ePayee.getPkValue());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeeaccountbank");
            lsp.setCloseCallBack(closeCallBack);
            lsp.getListFilterParameter().setFilter(this.getCurrencyFilter());
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private QFilter getCurrencyFilter() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6536\u6b3e\u5e01\u79cd\u3002", (String)"PayApplyEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        return new QFilter("entry_bank.currency.id", "in", currency.getPkValue());
    }

    private void bindAccountBankInfo(SCAccountInfo scAccountInfo) {
        if (scAccountInfo == null) {
            this.setValue("e_payeeaccbank", null);
            this.setValue("e_payeeaccbankid", null);
            this.setValue("e_payeeaccbanknum", null);
            this.setValue("e_payeebank", null);
            return;
        }
        this.setValue("e_payeeaccbanknum", scAccountInfo.getAccount());
        this.setValue("e_payeebank", scAccountInfo.getBeBank());
    }

    private void clearEntryPayeeInfo() {
        this.getModel().beginInit();
        DynamicObjectCollection payApplyEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("cas_payapplyentry");
        for (int i = 0; i < payApplyEntry.size(); ++i) {
            this.getModel().setValue("e_payeetype", null, i);
            this.getModel().setValue("e_payee", null, i);
            this.getModel().setValue("e_payeeid", null, i);
            this.getModel().setValue("e_payeename", null, i);
            this.getModel().setValue("e_payeeaccbank", null, i);
            this.getModel().setValue("e_payeeaccbankid", null, i);
            this.getModel().setValue("e_payeeaccbanknum", null, i);
            this.getModel().setValue("e_useraccbank", null, i);
            this.getModel().setValue("e_payeebank", null, i);
            this.getModel().setValue("e_accountname", null, i);
            this.getModel().setValue("e_institutioncode", null, i);
            this.getModel().setValue("e_institutionname", null, i);
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_accountname"});
        }
        DynamicObjectCollection payInfoEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("cas_payinfo");
        for (int i = 0; i < payInfoEntry.size(); ++i) {
            this.getModel().setValue("entry_payeetype", null, i);
            this.getModel().setValue("entry_payee", null, i);
            this.getModel().setValue("entry_payeeid", null, i);
            this.getModel().setValue("entry_payeename", null, i);
            this.getModel().setValue("entry_recaccbankname", null, i);
            this.getModel().setValue("entry_payeeaccbanknum", null, i);
            this.getModel().setValue("entry_payeebank", null, i);
            this.getModel().setValue("entry_recbanknumber", null, i);
            this.getModel().setValue("entry_draftbill", null, i);
            this.getModel().setValue("entry_accountname", null, i);
            this.getModel().setValue("entry_payinstitutioncode", null, i);
            this.getModel().setValue("entry_recinstitutioncode", null, i);
            this.getModel().setValue("entry_payinstitutionname", null, i);
            this.getModel().setValue("entry_recinstitutionname", null, i);
        }
        this.getModel().endInit();
        this.getView().updateView("cas_payapplyentry");
        this.getView().updateView("cas_payinfo");
    }

    private void supplierOrCustomerChanged(DynamicObject basedata, int rowIndex) {
        DynamicObject payeeCurrency = (DynamicObject)this.getModel().getValue("payeecurrency");
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("payorg"), (DynamicObject)basedata);
        if (internalOrg != null) {
            DynamicObject defaultPayAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)internalOrg.getPkValue()));
            if (payeeCurrency == null || Objects.nonNull(defaultPayAccount) && Objects.equals(((DynamicObject)defaultPayAccount.get("defaultcurrency")).getPkValue(), payeeCurrency.getPkValue())) {
                this.setValue("e_payeeaccbank", defaultPayAccount, rowIndex);
            }
        } else {
            SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)basedata);
            if (defaultBankInfo != null && (payeeCurrency == null || Objects.equals(defaultBankInfo.getCurrency().getPkValue(), payeeCurrency.getPkValue()))) {
                this.setValue("e_payeeaccbanknum", defaultBankInfo.getAccount(), rowIndex);
                this.setValue("e_payeebank", defaultBankInfo.getBeBank(), rowIndex);
                this.setValue("e_accountname", defaultBankInfo.getAccountName(), rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"e_accountname"});
            }
        }
    }

    private void userF7Changed(DynamicObject user, int rowIndex) {
        DynamicObject erPayeeInfo = this.getErPayeeInfo(user.getLong("id"), user.getLocaleString("name").getLocaleValue());
        DynamicObject payeeCurrency = (DynamicObject)this.getModel().getValue("payeecurrency");
        if (Objects.nonNull(erPayeeInfo) && Objects.isNull(erPayeeInfo.get("currency")) || Objects.isNull(payeeCurrency) || Objects.nonNull(erPayeeInfo) && Objects.nonNull(erPayeeInfo.get("currency")) && Objects.equals(erPayeeInfo.getDynamicObject("currency").getPkValue(), payeeCurrency.getPkValue())) {
            this.setValue("e_useraccbank", erPayeeInfo, rowIndex);
        }
    }

    private DynamicObject getErPayeeInfo(long userId, String name) {
        String orderBys;
        QFilter eFilter;
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("payer", "=", (Object)userId);
        String selectFields = "id,name,payer,payeraccount,payeraccountname,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number,currency";
        QFilter[] qFilters = new QFilter[]{uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C'))), eFilter = new QFilter("enable", "=", (Object)"1")};
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)(orderBys = "isdefault desc"), (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    private void orgF7Changed(DynamicObject org, int rowIndex) {
        if (org != null) {
            DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)org.getPkValue()));
            DynamicObject payeeCurrency = (DynamicObject)this.getModel().getValue("payeecurrency");
            if (payeeCurrency == null || defaultRecAccount != null && Objects.equals(defaultRecAccount.getDynamicObject("defaultcurrency").getPkValue(), payeeCurrency.getPkValue())) {
                this.setValue("e_payeeaccbank", defaultRecAccount, rowIndex);
            }
        }
    }

    private void payApplyAmountSum() {
        if (this.getModel().getValue("payorg") == null) {
            return;
        }
        Long orgID = this.getPk("payorg");
        Long currencyId = this.getPk("payeecurrency");
        if (orgID == null || currencyId == null) {
            this.clearPayApplyAmountSum();
            return;
        }
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        try {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("cas_payapplyentry");
            BigDecimal payeeAmountSum = dynamicObjects.stream().map(item -> item.get("e_payeeamount") == null ? BigDecimal.ZERO : new BigDecimal(item.get("e_payeeamount").toString())).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal paidAmountSum = dynamicObjects.stream().map(item -> item.get("e_paidamount") == null ? BigDecimal.ZERO : new BigDecimal(item.get("e_paidamount").toString())).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = currency.getInt("amtprecision");
            this.initFormat();
            ((Label)this.getControl("epeamountsumb")).setText(this.currencyFormat.format(payeeAmountSum == null ? Integer.valueOf(0) : payeeAmountSum));
            ((Label)this.getControl("epaidamountsumb")).setText(this.currencyFormat.format(paidAmountSum == null ? Integer.valueOf(0) : paidAmountSum));
        }
        catch (Exception err) {
            this.clearPayApplyAmountSum();
            logger.error("\u7533\u8bf7\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u3001\u5df2\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u5237\u65b0\u9519\u8bef", (Throwable)err);
        }
    }

    private void clearPayApplyAmountSum() {
        DynamicObject currency = this.getDynamicObject("payeecurrency");
        if (!CasHelper.isEmpty((Object)currency)) {
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = currency.getInt("amtprecision");
            this.initFormat();
            ((Label)this.getControl("epeamountsumb")).setText(this.currencyFormat.format(BigDecimal.ZERO));
            ((Label)this.getControl("epaidamountsumb")).setText(this.currencyFormat.format(BigDecimal.ZERO));
        } else {
            ((Label)this.getControl("epeamountsumb")).setText("\uffe50.00");
            ((Label)this.getControl("epaidamountsumb")).setText("\uffe50.00");
        }
    }

    private void payAmountSum() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (this.getModel().getValue("payorg") == null) {
            return;
        }
        Long orgID = this.getPk("payorg");
        Long currencyId = this.getPk("payeecurrency");
        if (orgID == null || currencyId == null) {
            this.clearPayAmountSum();
            return;
        }
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        try {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("cas_payinfo");
            BigDecimal payeeAmountSum = dynamicObjects.stream().filter(o -> !"E".equals(o.getString("entry_paystatus"))).map(item -> item.get("entry_payeeamount") == null ? BigDecimal.ZERO : new BigDecimal(item.get("entry_payeeamount").toString())).reduce(BigDecimal.ZERO, BigDecimal::add);
            payeeAmountSum = this.calAmountSumWithRefundAndReNote(payeeAmountSum);
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = currency.getInt("amtprecision");
            this.initFormat();
            ((Label)this.getControl("enpeamountsumb")).setText(this.currencyFormat.format(payeeAmountSum == null ? Integer.valueOf(0) : payeeAmountSum));
        }
        catch (Exception err) {
            this.clearPayAmountSum();
            logger.error("\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5237\u65b0\u9519\u8bef", (Throwable)err);
        }
    }

    private BigDecimal calAmountSumWithRefundAndReNote(BigDecimal payeeAmountSum) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("cas_payinfo");
        if (dataEntity.getBoolean("refundandrepay")) {
            BigDecimal refundAmount = dynamicObjects.stream().filter(e -> !PayStatusEnum.CLANCEL.getValue().equals(e.getString("entry_paystatus"))).filter(e -> EmptyUtil.isNoEmpty((BigDecimal)e.getBigDecimal("entry_refundamount"))).map(e -> e.getBigDecimal("entry_refundamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            payeeAmountSum = payeeAmountSum.subtract(refundAmount);
        }
        return payeeAmountSum;
    }

    private void clearPayAmountSum() {
        DynamicObject currency = this.getDynamicObject("payeecurrency");
        if (!CasHelper.isEmpty((Object)currency)) {
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = currency.getInt("amtprecision");
            this.initFormat();
            ((Label)this.getControl("enpeamountsumb")).setText(this.currencyFormat.format(BigDecimal.ZERO));
        } else {
            ((Label)this.getControl("enpeamountsumb")).setText("\uffe50.00");
        }
    }
}

