/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.PaymentBillEdit;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.formplugin.payapply.PaymentChannelHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.SystemParameterFcsHelper;
import kd.fi.cas.pojo.BizBalanceModelBean;
import kd.fi.cas.pojo.ModelRequestBean;
import kd.fi.cas.result.PayApplyStatusResult;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;

public class PayApplyEntryEdit
extends BillEditPlugin
implements ClickListener,
HyperLinkClickListener {
    private static Log log = LogFactory.getLog(PayApplyEntryEdit.class);
    private static final String[] FIELD_TEMPLE = new String[]{"e_settlementtype", "e_payeeamount", "e_payeetype", "e_accountname", "e_payeebank", "e_payeeaccbanknum", "e_payeename", "e_payeeid", "e_remark", "e_priority", "e_payee"};
    private static final String BILL = "bill";
    private static final String PKVALUE = "pkValue";
    private static final String CFMARRIVAL = "cfmArrival";
    private static final List<String> CFMARRIVALOP = Arrays.asList("save", "submit", "comfirmsche");
    private static final String PAY_INVALID_CONFIRM_ACCOUNT = "payinvalid_confirmaccount";
    private static final String PAY_INVALID_AMOUNT_CALLBACK = "cas_payinvalid_amount_callback";
    private static final String CONTINUE_ACC_NOT_EXIST = "continue_acc_not_exist";
    private static String[] DIFF_PAY_PROPS = new String[]{"entry_isdiffcur", "entry_paycurrency", "entry_exratetable", "entry_exratedate", "entry_exchangerate", "entry_payamount", "entry_quotation"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control entryentity = this.getView().getControl("cas_payinfo");
        EntryGrid entry = (EntryGrid)entryentity;
        entry.addHyperClickListener((HyperLinkClickListener)this);
        TextEdit settletNumber = (TextEdit)this.getView().getControl("entry_settletnumber");
        settletNumber.addButtonClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("entry_settletnumber".equals(key)) {
            DynamicObject settleType = (DynamicObject)this.getValue("entry_settlementtype");
            if (PayApplyEntryEdit.isDraftbillSettlement(settleType)) {
                evt.setCancel(false);
            } else if (PayApplyEntryEdit.isArrivalSettlement(settleType)) {
                evt.setCancel(false);
            } else if (PayBillHepler.isLCSettlement((DynamicObject)settleType, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN)) {
                evt.setCancel(false);
            } else {
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey().toLowerCase()) {
            case "entry_settletnumber": {
                DynamicObject settleType = (DynamicObject)this.getValue("entry_settlementtype");
                if (PayApplyEntryEdit.isDraftbillSettlement(settleType)) {
                    this.draftbillSettlementClick();
                    break;
                }
                if (PayApplyEntryEdit.isArrivalSettlement(settleType)) {
                    this.arrivalSettlementClick();
                    break;
                }
                if (!PayBillHepler.isLCSettlement((DynamicObject)settleType, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN)) break;
                this.lcOpenSettlementClick();
            }
        }
    }

    private void arrivalSettlementClick() {
        Object currency = this.getModel().getValue("payeecurrency");
        if (CasHelper.isEmpty((Object)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e01\u79cd\u3002", (String)"PaymentBillDraftEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object payeetype = this.getValue("entry_payeetype");
        Object payeename = this.getValue("entry_payeename");
        if (CasHelper.isEmpty((Object)payeetype) || CasHelper.isEmpty((Object)payeename)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentBillDraftEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object org = this.getValue("payorg");
        if (EmptyUtil.isEmpty((Object)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f", (String)"PayApplyEntryEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"lc_arrival", (boolean)false);
        Object payeeId = this.getValue("entry_payeeid");
        Object payeeAmount = this.getValue("entry_payeeamount");
        DynamicObject settleType = this.getDynamicObject("entry_settlementtype");
        String settlementType = settleType.getString("settlementtype");
        QFilter qFilter = PayApplyEntryEdit.getArrivalNoQFilter((DynamicObject)org, (DynamicObject)currency, payeetype.toString(), (Long)payeeId, payeename.toString(), (BigDecimal)payeeAmount, settlementType);
        showParameter.getListFilterParameter().setFilter(qFilter);
        EntryGrid entryentity1 = (EntryGrid)this.getView().getControl("cas_payinfo");
        int[] selectRows = entryentity1.getSelectRows();
        if (selectRows.length >= 1) {
            int index = selectRows[0];
            DynamicObject cas_payinfo_sel = this.getModel().getEntryRowEntity("cas_payinfo", index);
            this.getPageCache().put(PKVALUE, cas_payinfo_sel.getPkValue().toString());
        }
        showParameter.setIsolationOrg(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "settletnumber"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void lcOpenSettlementClick() {
        String payeeType;
        Long orgId = this.getPk("payorg");
        Long bankId = this.getPk("entry_payerbank");
        Long currencyId = this.getPk("entry_paycurrency");
        BigDecimal actPayAmt = this.getBigDecimal("entry_payamount");
        String payeeName = this.getString("entry_payeename");
        ArrayList<String> tipList = new ArrayList<String>(5);
        if (EmptyUtil.isEmpty((Long)orgId)) {
            tipList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3002", (String)"PayApplyEntryEdit_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if (CasHelper.isEmpty((Object)(payeeType = this.getString("entry_payeetype"))) || CasHelper.isEmpty((Object)payeeName)) {
            tipList.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentBillDraftEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Long)bankId)) {
            tipList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u8d26\u53f7\u3002", (String)"PayApplyEntryEdit_26", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Long)currencyId)) {
            tipList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u5e01\u79cd\u3002", (String)"PayApplyEntryEdit_27", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if (actPayAmt.compareTo(BigDecimal.ZERO) == 0) {
            tipList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"PayApplyEntryEdit_28", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if (!tipList.isEmpty()) {
            String tips = String.join((CharSequence)"\r\n", tipList);
            String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u4e3a\u4fe1\u7528\u8bc1\u5f00\u7acb\u65f6:\r\n%s", (String)"PayApplyEntryEdit_29", (String)"fi-cas-formplugin", (Object[])new Object[0]), tips);
            this.getView().showTipNotification(msg);
            return;
        }
        QFilter qFilter = PaymentBillEdit.lcBizF7Filter(orgId, bankId, currencyId, actPayAmt, payeeType, payeeName);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"lc_lettercredit", (boolean)false);
        showParameter.getListFilterParameter().setFilter(qFilter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "creditopen_settletnumber");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void draftbillSettlementClick() {
        Object payeetype = this.getValue("entry_payeetype");
        if (CasHelper.isEmpty((Object)payeetype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"PayApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object org = this.getValue("payorg");
        if (EmptyUtil.isEmpty((Object)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f", (String)"PayApplyEntryEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        MulBasedataEdit draftbill = (MulBasedataEdit)this.getControl("entry_draftbill");
        draftbill.addBeforeF7SelectListener(e -> {
            Object currency = this.getModel().getValue("payeecurrency");
            if (CasHelper.isEmpty((Object)currency)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e01\u79cd\u3002", (String)"PaymentBillDraftEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object payeename = this.getModel().getValue("entry_payeename");
            if (CasHelper.isEmpty((Object)payeename)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentBillDraftEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            QFilter qFilter = this.getDraftF7Filter((DynamicObject)currency, payeetype.toString(), payeename.toString());
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
        draftbill.click();
    }

    private QFilter getDraftF7Filter(DynamicObject currency, String payeetype, String payeename) {
        ArrayList ids = new ArrayList(0);
        ArrayList<Long> lockIds = new ArrayList<Long>(0);
        try {
            DynamicObject payApplyBillFromDB = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity(true).getPkValue(), (String)"cas_payapplybill");
            lockIds.addAll(PayApplyEntryEdit.getDraftBillList(payApplyBillFromDB.getDynamicObjectCollection("cas_payinfo"), true));
        }
        catch (Exception e1) {
            log.error((Throwable)e1);
        }
        List<Long> otherIds = PayApplyEntryEdit.getDraftBillList(this.getModel().getEntryEntity("cas_payinfo"), true);
        lockIds.removeAll(otherIds);
        DynamicObjectCollection draftbillColls = (DynamicObjectCollection)this.getModel().getValue("entry_draftbill");
        if (draftbillColls != null && draftbillColls.size() > 0) {
            ids.addAll(draftbillColls.stream().filter(e -> null != e.getDynamicObject("fbasedataid")).map(coll -> coll.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
            lockIds.addAll(ids);
        }
        Object settleType = this.getValue("entry_settlementtype");
        Object payeeId = this.getValue("entry_payeeid");
        DynamicObject org = (DynamicObject)this.getModel().getValue("payorg");
        QFilter qFilter = PayApplyEntryEdit.getDraftBillQFilter(org, (DynamicObject)settleType, currency, payeetype, (Long)payeeId, payeename, this.getModel().getDataEntity().getPkValue(), lockIds);
        otherIds.removeAll(ids);
        if (otherIds.size() > 0) {
            qFilter.and(new QFilter("id", "not in", otherIds));
        }
        return qFilter;
    }

    public static List<Long> getDraftBillList(DynamicObjectCollection payinfoCollection, boolean isClancel) {
        return PayApplyBillHelper.getDraftBillList((DynamicObjectCollection)payinfoCollection, (boolean)isClancel);
    }

    public static List<Long> getArrivalNoList(DynamicObjectCollection payinfoCollection) {
        return payinfoCollection.stream().filter(item -> item.getDynamicObject("entry_arrivalno") != null).map(item -> item.getDynamicObject("entry_arrivalno").getLong("id")).collect(Collectors.toList());
    }

    public static QFilter getDraftBillQFilter(DynamicObject org, DynamicObject settleTypeObj, DynamicObject currency, String payeetype, long payeeid, String payeename, Object pkValue, List<Long> ids) {
        Set hasCasRecIdSet;
        Set hasNoReleatedCasPayIdSet;
        List<Long> billIds;
        QFilter receFilter = new QFilter("company.id", "=", (Object)org.getLong("id"));
        receFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
        receFilter.and(new QFilter("availableamount", ">", (Object)0));
        receFilter.and(new QFilter("currency", "=", currency.get("id")));
        receFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        receFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        receFilter.and(new QFilter("istransfer", "=", (Object)"1"));
        QFilter nullFilter = QFilter.isNull((String)"billpool");
        receFilter.and(new QFilter("billpool", "=", (Object)0).or(nullFilter));
        List<Long> poolIds = PayApplyEntryEdit.getBillPoolByCompany(org.getLong("id"));
        QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"isShowUnLockBill");
        if (isShowUnLockBill) {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)org.getLong("id")))));
        } else {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)org.getLong("id"))));
        }
        qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterBillPool.and(new QFilter("currency", "=", currency.get("id")));
        qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilterBillPool.and(new QFilter("availableamount", ">", (Object)0));
        boolean isExcludedBills = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"isexcludedbills");
        if (isExcludedBills && EmptyUtil.isNoEmpty(billIds = PayApplyEntryEdit.getIsExcludedBills(org, currency)) && billIds.size() > 0) {
            qFilterBillPool.and("id", "not in", (Object)billIds.toArray());
        }
        QFilter payFilter = new QFilter("company.id", "=", (Object)org.getLong("id"));
        payFilter.and(new QFilter("source", "not in", (Object)new String[]{"cas", "ifm"}));
        payFilter.and(new QFilter("rptype", "=", (Object)"paybill"));
        payFilter.and(new QFilter("availableamount", ">", (Object)0));
        payFilter.and(new QFilter("currency", "=", currency.get("id")));
        payFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        payFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        payFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        payFilter.and(new QFilter("payeetype", "=", (Object)payeetype));
        payFilter.and(new QFilter("payeetype", "=", (Object)"other").and(new QFilter("receivername", "=", (Object)payeename)).or(new QFilter("payeetype", "!=", (Object)"other").and(new QFilter("receiver", "=", (Object)payeeid))));
        if (settleTypeObj != null) {
            List billTypeIdList = DraftHelper.getBillTypeIdList((Object)settleTypeObj.getPkValue(), (String)settleTypeObj.getString("settlementtype"));
            receFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
            qFilterBillPool.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
            payFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
        }
        if (EmptyUtil.isNoEmpty((Object)(hasNoReleatedCasPayIdSet = DraftHelper.getReleatedCasPayBill((QFilter)payFilter, (String)"cdm_payablebill")))) {
            payFilter.and(new QFilter("id", "not in", (Object)hasNoReleatedCasPayIdSet));
        }
        if (EmptyUtil.isNoEmpty((Object)(hasCasRecIdSet = DraftHelper.getReleatedCasPayBill((QFilter)receFilter, (String)"cdm_receivablebill")))) {
            receFilter.and(new QFilter("id", "not in", (Object)hasNoReleatedCasPayIdSet));
        }
        QFilter qFilter = receFilter.or(qFilterBillPool).or(payFilter);
        if (ids != null && ids.size() > 0) {
            qFilter.or(new QFilter("id", "in", ids));
        }
        return qFilter;
    }

    private static List<Long> getIsExcludedBills(DynamicObject org, DynamicObject currency) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return ids;
        }
        String orgName = org.getString("name");
        if (EmptyUtil.isEmpty((String)orgName)) {
            return ids;
        }
        List<Long> poolIds = PayApplyEntryEdit.getBillPoolByCompany(org.getLong("id"));
        QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"isShowUnLockBill");
        if (isShowUnLockBill) {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)org.getLong("id")))));
        } else {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)org.getLong("id"))));
        }
        qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterBillPool.and(new QFilter("currency", "=", currency.get("id")));
        qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilterBillPool.and(new QFilter("company.id", "!=", (Object)org.getLong("id")));
        Object[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,delivername,drawername,receivername,endorseentry.id,endorseentry.initiatorname,endorseentry.opponentname", (QFilter[])qFilterBillPool.toArray());
        if (EmptyUtil.isNoEmpty((Object[])receivablebills)) {
            block0: for (Object receivablebill : receivablebills) {
                String delivername = receivablebill.getString("delivername");
                String drawername = receivablebill.getString("drawername");
                String receivername = receivablebill.getString("receivername");
                if (orgName.equals(delivername) || orgName.equals(drawername) || orgName.equals(receivername)) {
                    ids.add(receivablebill.getLong("id"));
                    continue;
                }
                DynamicObjectCollection endorseentrys = receivablebill.getDynamicObjectCollection("endorseentry");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)endorseentrys)) continue;
                for (DynamicObject endorseentry : endorseentrys) {
                    String initiatorname = endorseentry.getString("initiatorname");
                    String opponentname = endorseentry.getString("opponentname");
                    if (!orgName.equals(initiatorname) && !orgName.equals(opponentname)) continue;
                    ids.add(receivablebill.getLong("id"));
                    continue block0;
                }
            }
        }
        return ids;
    }

    public static QFilter getArrivalNoQFilter(DynamicObject org, DynamicObject currency, String payeetype, long payeeid, String payeename, BigDecimal payeeamount, String settlementType) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("arrivalstatus", "=", (Object)"arrival_confirm");
        qFilter.and("arrivalway", "!=", (Object)"protest");
        qFilter.and("org", "=", org.getPkValue());
        if ("other".equals(payeetype)) {
            qFilter.and("benefitertype", "=", (Object)"fbd_other");
            qFilter.and("benefiterother", "=", (Object)payeename);
        } else {
            qFilter.and("benefitertype", "=", (Object)payeetype);
            qFilter.and("benefiter", "=", (Object)payeeid);
        }
        if (SettleMentTypeEnum.CREDIT.getValue().equals(settlementType)) {
            qFilter.and("isinit", "=", (Object)Character.valueOf('0'));
            qFilter.and("eassrcid", "=", (Object)"");
        }
        qFilter.and("arrivalcurrency", "=", currency.getPkValue());
        DynamicObject[] arrivals = BusinessDataServiceHelper.load((String)"lc_arrival", (String)"id,todoamount,lockamount", (QFilter[])new QFilter[]{qFilter});
        List arrivalIds = Arrays.asList(arrivals).stream().filter(item -> {
            if (item.getBigDecimal("todoamount").compareTo(item.getBigDecimal("lockamount")) > 0) {
                if (payeeamount != null) {
                    return item.getBigDecimal("todoamount").compareTo(item.getBigDecimal("lockamount").add(payeeamount)) >= 0;
                }
                return true;
            }
            return false;
        }).map(item -> item.getLong("id")).collect(Collectors.toList());
        qFilter = new QFilter("id", "in", arrivalIds);
        return qFilter;
    }

    private static List<Long> getBillPoolByCompany(long orgId) {
        DynamicObject[] billPools = BusinessDataServiceHelper.load((String)"cdm_billpool", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.e_company", "=", (Object)orgId).or(new QFilter("company", "=", (Object)orgId)), new QFilter("enable", "=", (Object)"1")});
        ArrayList<Long> poolIds = new ArrayList<Long>(billPools.length);
        for (DynamicObject dy0 : billPools) {
            poolIds.add(dy0.getLong("id"));
        }
        return poolIds;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String opKey = source.getOperateKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection payApplyEntry = model.getEntryEntity("cas_payapplyentry");
        DynamicObjectCollection payInfoEntry = model.getEntryEntity("cas_payinfo");
        if ("submit".equals(opKey)) {
            BigDecimal payeeamount = model.getDataEntity().getBigDecimal("payeeamount");
            BigDecimal e_payeeamount = BigDecimal.ZERO;
            for (Object payApply : payApplyEntry) {
                e_payeeamount = e_payeeamount.add(payApply.getBigDecimal("e_payeeamount"));
            }
            if (payeeamount.compareTo(e_payeeamount) != 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7533\u8bf7\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5e94\u7b49\u4e8e\u6536\u6b3e\u603b\u989d\u3002", (String)"PayApplyEntryEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), ""));
                args.setCancel(true);
                return;
            }
            BigDecimal entry_payeeamount = BigDecimal.ZERO;
            for (DynamicObject payInfo : payInfoEntry.stream().filter(item -> !PayStatusEnum.CLANCEL.getValue().equals(item.getString("entry_paystatus"))).collect(Collectors.toList())) {
                entry_payeeamount = entry_payeeamount.add(payInfo.getBigDecimal("entry_payeeamount"));
            }
            if (payeeamount.compareTo(entry_payeeamount) != 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u6536\u6b3e\u603b\u989d", (String)"PayApplyEntryEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ""));
                args.setCancel(true);
                return;
            }
            this.checkPayeeAndAcc(args, payApplyEntry, source);
        } else if (CFMARRIVALOP.contains(opKey)) {
            ArrayList<String> cfmArrivalMsgList = new ArrayList<String>(0);
            cfmArrivalMsgList.addAll(PayApplyEntryEdit.checkArrivalUnlockAmt(payInfoEntry));
            if (cfmArrivalMsgList.size() > 0) {
                this.getPageCache().put("checkOp", opKey);
                if (!Boolean.parseBoolean(this.getPageCache().get("checkOpResult"))) {
                    this.getView().showConfirm(String.join((CharSequence)"\n", cfmArrivalMsgList), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CFMARRIVAL, (IFormPlugin)this));
                    args.setCancel(true);
                    return;
                }
                this.getPageCache().put("checkOpResult", Boolean.FALSE.toString());
            }
            if ("save".equals(opKey)) {
                this.checkPayeeAndAcc(args, payApplyEntry, source);
            }
        } else if ("payinvalid".equals(opKey)) {
            EntryGrid payInfoGrid = (EntryGrid)this.getView().getControl("cas_payinfo");
            if (payInfoGrid.getSelectRows().length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u62d2\u4ed8\u7684\u6570\u636e\u3002", (String)"PayApplyEntryEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (!args.isCancel()) {
                this.confirmInvalidPay(args, opKey);
                this.dealInvalid(source);
            }
        } else if ("refreshbalance".equals(opKey)) {
            EntryGrid entryEntity = (EntryGrid)this.getView().getControl("cas_payinfo");
            int[] selectRows = entryEntity.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PayApplyEntryEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashSet<String> keySet = new HashSet<String>(selectRows.length);
            int noUpdateRowCount = 0;
            for (int i : selectRows) {
                DynamicObject payerAccBank = (DynamicObject)this.getModel().getValue("entry_payeraccbank", i);
                DynamicObject currency = (DynamicObject)this.getModel().getValue("entry_paycurrency", i);
                String payStatus = (String)this.getModel().getValue("entry_paystatus", i);
                if (payerAccBank == null || currency == null || !PayStatusEnum.NOTPAYING.getValue().equals(payStatus)) {
                    ++noUpdateRowCount;
                    continue;
                }
                String payerAccBankId = String.valueOf(payerAccBank.getLong("id"));
                String currencyId = String.valueOf(currency.getLong("id"));
                keySet.add(payerAccBankId.concat(";").concat(currencyId));
            }
            if (keySet.size() > 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d26\u6237\u8fc7\u591a\u4f1a\u5bfc\u81f4\u66f4\u65b0\u65f6\u95f4\u8f83\u957f\uff0c\u56e0\u6b64\u7cfb\u7edf\u63a7\u5236\u6bcf\u6b21\u66f4\u65b0\u8d26\u6237\u6570\u91cf\uff08\u91cd\u590d\u8d26\u6237\u7b971\u4e2a\uff0c\u540c\u4e00\u8d26\u6237\u4e0d\u540c\u5e01\u79cd\u7b97\u591a\u4e2a\uff09\u4e0d\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u9009\u62e9\u4e0d\u8d85\u8fc7100\u4e2a\u8d26\u6237\u8fdb\u884c\u624b\u52a8\u5237\u65b0\u3002", (String)"PayApplyEntryEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (keySet.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u7684\u201c\u4ed8\u6b3e\u8d26\u53f7\u201d\u6216\u201c\u4ed8\u6b3e\u5e01\u79cd\u201d\u4e3a\u7a7a\uff0c\u6216\u4ed8\u6b3e\u72b6\u6001\u975e\u672a\u4ed8\u6b3e\uff0c\u672a\u5237\u65b0\u5373\u65f6\u4f59\u989d\u3002", (String)"PayApplyEntryEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (noUpdateRowCount == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5373\u65f6\u4f59\u989d\u5237\u65b0\u6210\u529f\u3002", (String)"PayApplyEntryEdit_32", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u529f\u5237\u65b0%1$s\u6761\u4ed8\u6b3e\u660e\u7ec6\uff0c\u5269\u4f59%2$s\u6761\u4ed8\u6b3e\u660e\u7ec6\u672a\u5237\u65b0\u5373\u65f6\u4f59\u989d\uff08\u201c\u4ed8\u6b3e\u8d26\u53f7\u201d\u6216\u201c\u5e01\u522b\u201d\u4e3a\u7a7a\u3001\u6216\u4ed8\u6b3e\u72b6\u6001\u4e0d\u662f\u672a\u4ed8\u6b3e\uff09\u3002", (String)"CAS-E-160717", (String)"fi-cas-formplugin", (Object[])new Object[]{selectRows.length - noUpdateRowCount, noUpdateRowCount}));
            }
        }
    }

    private void checkPayeeAndAcc(BeforeDoOperationEventArgs args, DynamicObjectCollection payApplyEntry, FormOperate operate) {
        if (operate.getOption().containsVariable(CONTINUE_ACC_NOT_EXIST)) {
            return;
        }
        ArrayList<String> accNotExistList = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
            DynamicObject account;
            DynamicObject payApplyInfo = (DynamicObject)payApplyEntry.get(rowIndex);
            String accNumber = payApplyInfo.getString("e_payeeaccbanknum");
            boolean isCompany = AsstActTypeEnum.COMPANY.getValue().equals(payApplyInfo.get("e_payeetype"));
            if (!isCompany || StringUtils.isBlank((CharSequence)accNumber) || StringUtils.isBlank((CharSequence)payApplyInfo.getString("e_payeename")) || (account = AccountBankHelper.getAccountByNumber((String)accNumber)) != null) continue;
            accNotExistList.add(String.valueOf(rowIndex + 1));
        }
        if (!accNotExistList.isEmpty()) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)this);
            String errRows = String.join((CharSequence)",", accNotExistList);
            String msgFmt = ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6536\u6b3e\u4eba\u7c7b\u578b\u662f\u516c\u53f8\uff0c\u4f46\u662f\u672c\u5355\u6240\u5f55\u5165\u7684\u6536\u6b3e\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u5339\u914d\u5230\u8d26\u6237\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed", (String)"PayApplyEntryEdit_23", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(String.format(msgFmt, errRows), MessageBoxOptions.OKCancel, callBackListener);
            args.setCancel(true);
        }
    }

    private void confirmInvalidPay(BeforeDoOperationEventArgs args, String opKey) {
        if (Boolean.parseBoolean(this.getPageCache().get(PAY_INVALID_CONFIRM_ACCOUNT))) {
            return;
        }
        boolean isPartPayment = (Boolean)this.getModel().getValue("ispartpayment");
        IDataModel model = this.getModel();
        if (!Boolean.parseBoolean(this.getPageCache().get(opKey))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u62d2\u4ed8\u540e\uff0c\u9009\u4e2d\u7684\u8bb0\u5f55\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u786e\u5b9a\u8981\u62d2\u4ed8\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"PayApplyEntryEdit_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(opKey, (IFormPlugin)this));
            args.setCancel(true);
        } else if (isPartPayment) {
            BigDecimal lockedAmount;
            this.getPageCache().put(opKey, Boolean.FALSE.toString());
            this.getPageCache().put(PAY_INVALID_CONFIRM_ACCOUNT, Boolean.FALSE.toString());
            DynamicObject cas_payinfo_sel = null;
            try {
                int index = model.getEntryCurrentRowIndex("cas_payinfo");
                cas_payinfo_sel = model.getEntryRowEntity("cas_payinfo", index);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            if (cas_payinfo_sel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u62d2\u4ed8\u7684\u6570\u636e\u3002", (String)"PayApplyEntryEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal recAmount = cas_payinfo_sel.getBigDecimal("entry_payeeamount");
            BigDecimal balance = recAmount.subtract(lockedAmount = cas_payinfo_sel.getBigDecimal("entry_lockedamount"));
            if (BigDecimal.ZERO.compareTo(balance) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u91d1\u989d\u53ef\u62d2\u4ed8\u3002", (String)"PayApplyEntryEdit_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cas_payinvalid_amount");
            showParameter.setCustomParam("recAmount", (Object)recAmount);
            showParameter.setCustomParam("lockedAmount", (Object)lockedAmount);
            if (cas_payinfo_sel.getDynamicObject("entry_paycurrency") != null) {
                showParameter.setCustomParam("payCurrency", (Object)cas_payinfo_sel.getDynamicObject("entry_paycurrency").getLong("id"));
            }
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PAY_INVALID_AMOUNT_CALLBACK));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
            args.setCancel(true);
        } else {
            this.getPageCache().put(opKey, Boolean.FALSE.toString());
            this.getPageCache().put(PAY_INVALID_CONFIRM_ACCOUNT, Boolean.TRUE.toString());
        }
    }

    private void dealInvalid(FormOperate source) {
        if (!Boolean.parseBoolean(this.getPageCache().get(PAY_INVALID_CONFIRM_ACCOUNT))) {
            return;
        }
        IDataModel model = this.getModel();
        this.getPageCache().put(PAY_INVALID_CONFIRM_ACCOUNT, Boolean.FALSE.toString());
        DynamicObject cas_payinfo_sel = null;
        try {
            int index = model.getEntryCurrentRowIndex("cas_payinfo");
            cas_payinfo_sel = model.getEntryRowEntity("cas_payinfo", index);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (cas_payinfo_sel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u62d2\u4ed8\u7684\u6570\u636e\u3002", (String)"PayApplyEntryEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isPartPayment = (Boolean)this.getModel().getValue("ispartpayment");
        HashMap<Long, List<Long>> pkValueMap = new HashMap<Long, List<Long>>(1);
        pkValueMap.put(model.getDataEntity().getLong("id"), Collections.singletonList(cas_payinfo_sel.getLong("id")));
        source.getOption().setVariableValue("pkValueMap", JSON.toJSONString(pkValueMap));
        if (isPartPayment) {
            String invalidAmount = source.getOption().getVariableValue("invalidamount");
            source.getOption().setVariableValue("invalidamount", invalidAmount);
            source.getOption().setVariableValue("payApplyInvalid", "true");
        }
    }

    public static List<String> checkArrivalUnlockAmt(DynamicObjectCollection payApplyEntry) {
        ArrayList<String> cfmArrivalMsgList = new ArrayList<String>(0);
        ArrayList<String> errMsgList = new ArrayList<String>(0);
        for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
            DynamicObject payEntry = (DynamicObject)payApplyEntry.get(rowIndex);
            DynamicObject settleType = payEntry.getDynamicObject("entry_settlementtype");
            Long arrivalno = payEntry.getLong("entry_arrivalno");
            BigDecimal arrivalunlockamt = payEntry.getBigDecimal("entry_arrivalunlockamt");
            BigDecimal payeeamount = payEntry.getBigDecimal("entry_payeeamount");
            if (!PayApplyEntryEdit.isArrivalSettlement(settleType) || arrivalno == 0L) continue;
            if (payeeamount.compareTo(arrivalunlockamt) > 0) {
                errMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6536\u6b3e\u91d1\u989d\u5927\u4e8e\u5230\u5355\u672a\u9501\u5b9a\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayApplyEntryEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowIndex + 1));
                continue;
            }
            if (arrivalunlockamt.compareTo(payeeamount) == 0) continue;
            cfmArrivalMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5df2\u9009\u5230\u5355\u672a\u9501\u5b9a\u91d1\u989d\u4e0e\u6536\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayApplyEntryEdit_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        if (errMsgList.size() > 0) {
            throw new KDBizException(String.join((CharSequence)"\n", errMsgList.toArray(new String[errMsgList.size()])));
        }
        return cfmArrivalMsgList;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        IDataModel model = this.getModel();
        if ("refreshbalance".equals(opKey)) {
            EntryGrid entryEntity = (EntryGrid)this.getView().getControl("cas_payinfo");
            int[] selectRows = entryEntity.getSelectRows();
            this.updateBalance(selectRows);
        } else if ("paysplit".equals(opKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.doPaySplit(model);
        } else if ("payinvalid".equals(opKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (Arrays.asList("save", "submit", "audit", "payinvalid").contains(opKey)) {
            this.updateArrivalNoRation();
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("cas_payapplyentry".equals(entryName)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection payApplyEntry = model.getEntryEntity("cas_payapplyentry");
            DynamicObjectCollection payInfoEntry = model.getEntryEntity("cas_payinfo");
            for (int index : e.getRowIndexs()) {
                DynamicObject payApply = (DynamicObject)payApplyEntry.get(index);
                Long payApplyEntryId = payApply.getLong("e_splitid");
                ArrayList<Integer> deleteEntryRowsList = new ArrayList<Integer>(10);
                for (int i = 0; i < payInfoEntry.size(); ++i) {
                    Long applyId = (Long)model.getValue("entry_applyid", i);
                    if (payApplyEntryId.compareTo(applyId) != 0) continue;
                    deleteEntryRowsList.add(i);
                    DynamicObjectCollection draftInfos = ((DynamicObject)payInfoEntry.get(i)).getDynamicObjectCollection("entry_draftbill");
                    if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfos) || draftInfos.size() <= 0) continue;
                    this.getModel().setValue("entry_draftbill", null, i);
                }
                int[] deleteEntryRowsArr = deleteEntryRowsList.stream().mapToInt(Integer::valueOf).toArray();
                model.deleteEntryRows("cas_payinfo", deleteEntryRowsArr);
                payInfoEntry = model.getEntryEntity("cas_payinfo");
                this.updateHeadStatus(payInfoEntry);
                this.updatePayBillSrcindex(payInfoEntry);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("cas_payapplyentry".equals(entryName)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection payApplyEntry = model.getEntryEntity("cas_payapplyentry");
            DynamicObjectCollection payInfoEntry = model.getEntryEntity("cas_payinfo");
            DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
            long payApplyBillEntryId = DB.genLongId((String)"cas_payapplybill");
            model.setValue("cas_payapplyentry.id", (Object)payApplyBillEntryId, payApplyEntry.size() - 1);
            model.setValue("e_splitid", (Object)payApplyBillEntryId, payApplyEntry.size() - 1);
            int[] appendEntryRow = model.appendEntryRow("cas_payinfo", payInfoEntry.size(), 1);
            model.setValue("entry_applyid", (Object)payApplyBillEntryId, appendEntryRow[0]);
            Object planPayDateObj = this.getModel().getValue("planpaydate");
            if (planPayDateObj != null) {
                model.setValue("entry_expectdate", planPayDateObj, appendEntryRow[0]);
            }
            model.setValue("entry_settlementtype", (Object)defaultSettleType, appendEntryRow[0]);
            DynamicObject paymentType = (DynamicObject)this.getModel().getValue("paymenttype");
            if (Objects.nonNull(paymentType)) {
                if (PayAndRecBizTypeEnum.TRANSFER_SAME.getValue().equals(paymentType.get("biztype"))) {
                    this.getModel().setValue("entry_payeetype", (Object)"bos_org", appendEntryRow[0]);
                    this.getModel().setValue("entry_payee", this.getModel().getValue("payorg"), appendEntryRow[0]);
                    this.getModel().setValue("entry_recinstitutioncode", this.getModel().getValue("e_institutioncode", payApplyEntry.size() - 1), appendEntryRow[0]);
                    this.getModel().setValue("entry_recinstitutionname", this.getModel().getValue("e_institutionname", payApplyEntry.size() - 1), appendEntryRow[0]);
                    List<String> templeKey = Arrays.asList(FIELD_TEMPLE);
                    for (String key : templeKey) {
                        String key2 = key.substring(2);
                        model.setValue("entry_" + key2, ((DynamicObject)payApplyEntry.get(payApplyEntry.size() - 1)).get(key), payApplyEntry.size() - 1);
                    }
                } else if (PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(paymentType.get("biztype")) || PayAndRecBizTypeEnum.FUNDS_ALLOCATE.getValue().equals(paymentType.get("biztype"))) {
                    this.getModel().setValue("entry_payeetype", (Object)"bos_org", appendEntryRow[0]);
                }
            }
            this.updateHeadStatus(payInfoEntry);
        }
    }

    private void updateArrivalNoRation() {
        CasBotpHelper.deleteRation((DBRoute)DBRouteConst.TMC, (String)"lc_arrival", (Long[])new Long[0], (Long)this.getModel().getDataEntity().getLong("id"), (boolean)true);
        List<Long> arrivalNoIds = this.getArrivalNoList(this.getModel().getEntryEntity("cas_payinfo"), true);
        if (arrivalNoIds.size() > 0) {
            CasBotpHelper.saveRelation((String)"lc_arrival", arrivalNoIds, (String)this.getModel().getDataEntityType().getName(), (Long)this.getModel().getDataEntity().getLong("id"));
        }
    }

    private List<Long> getArrivalNoList(DynamicObjectCollection payinfoCollection, boolean isClancel) {
        return payinfoCollection.stream().filter(item -> {
            Long arrivalno = item.getLong("entry_arrivalno");
            if (arrivalno == null || arrivalno == Long.parseLong("0")) {
                return false;
            }
            if (PayStatusEnum.CLANCEL.getValue().equals(item.getString("entry_paystatus"))) {
                return isClancel;
            }
            if (item.getBoolean("entry_invalid")) {
                return isClancel;
            }
            return true;
        }).map(item -> item.getLong("entry_arrivalno")).distinct().collect(Collectors.toList());
    }

    private void updateHeadStatus(DynamicObjectCollection payInfoEntry) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)payInfoEntry)) {
            this.getModel().setValue("paidstatus", (Object)PayApplyPayStatusEnum.NOTPAYING.getValue());
            return;
        }
        PayApplyStatusResult result = PayApplyBillHelper.getHeadStatus((DynamicObjectCollection)payInfoEntry);
        this.getModel().setValue("paidstatus", (Object)result.getPayStatus().getValue());
        this.getModel().setValue("backbillflag", (Object)result.getBackBillFlag());
        this.getModel().setValue("partpaysche", (Object)result.getPartPaySchFlag());
        this.getModel().setValue("partpay", (Object)result.getPartPayFlag());
    }

    private void updatePayBillSrcindex(DynamicObjectCollection payInfoEntrys) {
        HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
        if (EmptyUtil.isEmpty((DynamicObjectCollection)payInfoEntrys)) {
            return;
        }
        for (DynamicObject payInfoEntry : payInfoEntrys) {
            DynamicObjectCollection draftInfos = payInfoEntry.getDynamicObjectCollection("entry_draftbill");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfos) || draftInfos.size() <= 0) continue;
            for (DynamicObject draftInfo : draftInfos) {
                Long id = draftInfo.getDynamicObject("fbasedataid").getLong("id");
                Integer seq = payInfoEntry.getInt("Seq");
                indexMap.put(id, seq);
            }
        }
        DynamicObjectCollection draftInfos = this.getModel().getEntryEntity("cas_draftinfo");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfos) && draftInfos.size() > 0) {
            for (DynamicObject draftInfo : draftInfos) {
                Long id = draftInfo.getDynamicObject("draftbillinfo").getLong("id");
                draftInfo.set("srcbillindex", indexMap.get(id));
            }
        }
    }

    private void doPaySplit(IDataModel model) {
        EntryGrid entryentity1 = (EntryGrid)this.getView().getControl("cas_payinfo");
        int[] selectRows = entryentity1.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u62c6\u5206\u64cd\u4f5c", (String)"PayApplyEntryEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            int index = selectRows[0];
            DynamicObject cas_payinfo_sel = model.getEntryRowEntity("cas_payinfo", index);
            DynamicObject paySettlement = cas_payinfo_sel.getDynamicObject("entry_settlementtype");
            if (!PayStatusEnum.NOTPAYING.getValue().equals(cas_payinfo_sel.getString("entry_paystatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u201c\u4ed8\u6b3e\u660e\u7ec6\u201d\u5df2\u5b8c\u6210\u201c\u6392\u6b3e\u201d\u6216\u8005\u201c\u4e0b\u63a8\u4ed8\u6b3e\u201d\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u3002", (String)"PayApplyEntryEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (cas_payinfo_sel.getBoolean("entry_invalid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u5df2\u62d2\u4ed8\uff0c\u65e0\u6cd5\u62c6\u5206\u3002", (String)"PayApplyEntryEdit_21", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (EmptyUtil.isNoEmpty((DynamicObject)paySettlement) && SettleMentTypeEnum.DCEP.getValue().equals(paySettlement.getString("settlementtype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u4e3a\u6570\u5e01\u94b1\u5305\u65f6\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u4ed8\u6b3e\u660e\u7ec6\u3002", (String)"PayApplyEntryEdit_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                String entry_applyid = cas_payinfo_sel.getString("entry_applyid");
                DynamicObject payApply = BusinessDataServiceHelper.loadSingle((String)"cas_payapplybill", (String)"cas_payapplyentry.e_chgstatus,cas_payapplyentry.e_splitid", (QFilter[])new QFilter[]{new QFilter("id", "=", model.getValue("id"))});
                String errMsg = null;
                if (payApply != null) {
                    DynamicObjectCollection cas_payapplyentrys = payApply.getDynamicObjectCollection("cas_payapplyentry");
                    for (DynamicObject cas_payapplyentry : cas_payapplyentrys) {
                        if (!entry_applyid.equals(cas_payapplyentry.getString("e_splitid")) || !PayApplyRecChgStatusEnum.CHGING.getValue().equals(cas_payapplyentry.getString("e_chgstatus"))) continue;
                        errMsg = ResManager.loadKDString((String)"\u6240\u9009\u201c\u4ed8\u6b3e\u660e\u7ec6\u201d\u5bf9\u5e94\u7684\u201c\u7533\u8bf7\u660e\u7ec6\u201d\u6b63\u5728\u8fdb\u884c\u201c\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u201d\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u3002", (String)"PayApplyEntryEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                        break;
                    }
                }
                if (errMsg != null) {
                    this.getView().showErrorNotification(errMsg);
                } else {
                    Long pkValue = (Long)cas_payinfo_sel.getPkValue();
                    if (EmptyUtil.isEmpty((Long)pkValue)) {
                        long cas_payinfoentryid = DB.genLongId((String)"cas_payinfo");
                        model.setValue("cas_payinfo.id", (Object)cas_payinfoentryid, index);
                        pkValue = cas_payinfoentryid;
                    }
                    DynamicObject bill = model.getDataEntity();
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("cas_payapplybill_paysplit");
                    showParameter.setAppId("cas");
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setCustomParam(PKVALUE, (Object)pkValue);
                    showParameter.setCustomParam(BILL, (Object)SerializeHelper.serializeDynamicObj((Object)bill));
                    showParameter.setCustomParam("entry_applyid", (Object)entry_applyid);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "paysplit_callback"));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(showParameter);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("paysplit_callback".equals(actionId)) {
            Map params = (Map)closedCallBackEvent.getReturnData();
            if (params != null && params.size() > 0) {
                IDataModel model = this.getModel();
                this.doPaysplitCallback(model, params);
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"settletnumber")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)rows)) {
                PayApplyEntryEdit.setEntryArrivalNo(this.getModel(), "cas_payinfo", this.getPageCache().get(PKVALUE), rows.get(0).getPrimaryKeyValue());
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"creditopen_settletnumber")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)rows)) {
                Object pKValue = rows.get(0).getPrimaryKeyValue();
                DynamicObject lcInfo = QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"id,billno,creditno", (QFilter[])new QFilter[]{new QFilter("id", "=", pKValue)});
                EntryGrid entryentity1 = (EntryGrid)this.getView().getControl("cas_payinfo");
                int[] selectRows = entryentity1.getSelectRows();
                int index = selectRows[0];
                this.getModel().setValue("entry_settletnumber", (Object)lcInfo.getString("billno"), index);
            }
        } else if (PAY_INVALID_AMOUNT_CALLBACK.equals(actionId)) {
            Map data = (Map)closedCallBackEvent.getReturnData();
            if (data != null) {
                this.getPageCache().put(PAY_INVALID_CONFIRM_ACCOUNT, Boolean.TRUE.toString());
                BigDecimal invalidAmount = (BigDecimal)data.get("invalidAmount");
                OperateOption option = OperateOption.create();
                option.setVariableValue("invalidAmount", String.valueOf(invalidAmount));
                this.getView().invokeOperation("payinvalid", option);
            } else {
                this.getPageCache().put(PAY_INVALID_CONFIRM_ACCOUNT, Boolean.FALSE.toString());
                this.getPageCache().put("payinvalid", Boolean.FALSE.toString());
            }
        }
    }

    public static void setEntryArrivalNo(IDataModel model, String entryEntityName, String pkValue, Object setValue) {
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryEntityName);
        if (entryEntity != null && entryEntity.size() > 0) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject item = (DynamicObject)entryEntity.get(i);
                if (item == null || item.getPkValue() == null || !item.getPkValue().toString().equals(pkValue)) continue;
                model.setValue("entry_arrivalno", setValue, i);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (CFMARRIVAL.equals(id) && MessageBoxResult.Yes == res) {
            if (CFMARRIVALOP.contains(this.getPageCache().get("checkOp"))) {
                this.getPageCache().put("checkOpResult", Boolean.TRUE.toString());
                this.getView().invokeOperation(this.getPageCache().get("checkOp"));
            }
        } else if ("payinvalid".equals(id) && MessageBoxResult.Yes == res) {
            this.getPageCache().put(id, Boolean.TRUE.toString());
            this.getView().invokeOperation(id);
        } else if (("save".equals(id) || "submit".equals(id)) && MessageBoxResult.Yes == res) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(CONTINUE_ACC_NOT_EXIST, "1");
            this.getView().invokeOperation(id, operateOption);
        }
    }

    private void doPaysplitCallback(IDataModel model, Map<String, Object> params) {
        String splitbill_str = (String)params.get("splitbill");
        DynamicObject splitbill = SerializeHelper.deserializeDynamicObj((String)"cas_payapplybill_paysplit", (String)splitbill_str);
        DynamicObjectCollection entryentity1 = (DynamicObjectCollection)splitbill.get("cas_payinfo");
        DynamicObjectCollection cas_payinfos_dosplit = new DynamicObjectCollection();
        ArrayList casPayinfoAddPks = new ArrayList();
        entryentity1.forEach(entity -> {
            if (PayStatusEnum.NOTPAYING.getValue().equals(entity.getString("entry_paystatus"))) {
                cas_payinfos_dosplit.add(entity);
                casPayinfoAddPks.add(entity.getPkValue());
            }
        });
        if (cas_payinfos_dosplit.size() > 0) {
            DynamicObject cas_payinfo;
            String entryapplyid = (String)params.get("entry_applyid");
            DynamicObjectCollection cas_payinfos = model.getEntryEntity("cas_payinfo");
            ArrayList casPayinfoUpdataPks = new ArrayList();
            cas_payinfos.forEach(casPayinfo -> casPayinfoUpdataPks.add(casPayinfo.getPkValue()));
            ArrayList casPayinfoDelPks = new ArrayList(casPayinfoUpdataPks);
            casPayinfoUpdataPks.retainAll(casPayinfoAddPks);
            casPayinfoAddPks.removeAll(casPayinfoDelPks);
            casPayinfoDelPks.removeAll(casPayinfoUpdataPks);
            for (DynamicObject cas_payinfo_dosplit : cas_payinfos_dosplit) {
                if (casPayinfoAddPks.contains(cas_payinfo_dosplit.getPkValue())) {
                    int index = model.createNewEntryRow("cas_payinfo");
                    this.setCasPayInfo(model, cas_payinfo_dosplit, entryapplyid, index);
                } else {
                    for (int i = 0; i < cas_payinfos.size(); ++i) {
                        cas_payinfo = (DynamicObject)cas_payinfos.get(i);
                        if (!cas_payinfo.getPkValue().equals(cas_payinfo_dosplit.getPkValue())) continue;
                        this.setCasPayInfo(model, cas_payinfo_dosplit, entryapplyid, i);
                        break;
                    }
                }
                this.getView().updateView("cas_payinfo");
            }
            for (int i = cas_payinfos.size(); i > 0; --i) {
                cas_payinfo = (DynamicObject)cas_payinfos.get(i - 1);
                if (!entryapplyid.equals(cas_payinfo.getString("entry_applyid")) || !PayStatusEnum.NOTPAYING.getValue().equals(cas_payinfo.getString("entry_paystatus")) || !casPayinfoDelPks.contains(cas_payinfo.getPkValue())) continue;
                try {
                    DynamicObjectCollection draftEntrys;
                    DynamicObjectCollection entrys = (DynamicObjectCollection)model.getValue("cas_payinfo");
                    int indexEntry = i - 1;
                    DynamicObject entry = (DynamicObject)entrys.get(indexEntry);
                    String entry_settletnumber = entry.getString("entry_settletnumber");
                    if (EmptyUtil.isNoEmpty((String)entry_settletnumber) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(draftEntrys = this.getModel().getEntryEntity("cas_draftinfo")))) {
                        for (int j = 0; j < draftEntrys.size(); ++j) {
                            DynamicObject draftEntry = (DynamicObject)draftEntrys.get(j);
                            DynamicObject draft = draftEntry.getDynamicObject("draftbillinfo");
                            if (null == draft) continue;
                            String draftBillno = draft.getString("draftbillno");
                            long srcbillid = draftEntry.getLong("srcbillid");
                            if (EmptyUtil.isNoEmpty((Long)srcbillid)) {
                                long entryId = cas_payinfo.getLong("id");
                                if (srcbillid != entryId || !entry_settletnumber.equals(draftBillno)) continue;
                                model.deleteEntryRow("cas_draftinfo", j);
                                continue;
                            }
                            int draftScrIndex = draftEntry.getInt("srcbillindex");
                            if (i != draftScrIndex || !entry_settletnumber.equals(draftBillno)) continue;
                            model.deleteEntryRow("cas_draftinfo", j);
                        }
                    }
                    model.deleteEntryRow("cas_payinfo", indexEntry);
                    continue;
                }
                catch (Exception e) {
                    log.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            this.getView().updateView("cas_payinfo");
            OperateOption option = OperateOption.create();
            if (!this.getView().getFormShowParameter().getStatus().toString().equals("ADDNEW")) {
                option.setVariableValue("entryPkValue", (String)params.get(PKVALUE));
            }
            this.getView().invokeOperation("save", option);
            this.getView().invokeOperation("refresh");
        }
    }

    private void setCasPayInfo(IDataModel model, DynamicObject caspayinfo, String entryapplyid, int index) {
        Set entryPropertyS = EntityPropertyHelper.getEntryPropertys((String)"cas_payapplybill", (String)"cas_payinfo");
        List<String> diffPayPropsList = Arrays.asList(DIFF_PAY_PROPS);
        for (String entryProperty : entryPropertyS) {
            if (diffPayPropsList.contains(entryProperty)) continue;
            try {
                model.setValue(entryProperty, caspayinfo.get(entryProperty), index);
            }
            catch (Exception exception) {}
        }
        model.setValue("cas_payinfo.id", caspayinfo.getPkValue(), index);
        model.setValue("entry_applyid", (Object)Long.valueOf(entryapplyid), index);
        model.setValue("entry_settlementtype", caspayinfo.get("entry_settlementtype"), index);
        model.setValue("entry_paycurrency", caspayinfo.get("entry_paycurrency"), index);
        model.setValue("entry_payeraccbank", caspayinfo.get("entry_payeraccbank"), index);
        model.setValue("entry_draftbill", caspayinfo.get("entry_draftbill"), index);
        model.setValue("entry_arrivalno", caspayinfo.get("entry_arrivalno"), index);
        DynamicObject payeraccbank = (DynamicObject)caspayinfo.get("entry_payeraccbank");
        if (payeraccbank != null) {
            this.setPaymentChannelValue(payeraccbank, index);
        }
        model.setValue("entry_paymentchannel", caspayinfo.get("entry_paymentchannel"), index);
        this.getModel().beginInit();
        model.setValue("entry_isdiffcur", caspayinfo.get("entry_isdiffcur"), index);
        model.setValue("entry_exratetable", caspayinfo.get("entry_exratetable"), index);
        model.setValue("entry_exratedate", caspayinfo.get("entry_exratedate"), index);
        model.setValue("entry_exchangerate", caspayinfo.get("entry_exchangerate"), index);
        model.setValue("entry_payamount", caspayinfo.get("entry_payamount"), index);
        model.setValue("entry_quotation", caspayinfo.get("entry_quotation"), index);
        this.getModel().endInit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObjectCollection payApplyEntity = model.getEntryEntity("cas_payapplyentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)payApplyEntity)) {
            return;
        }
        DynamicObject payApplyBill = (DynamicObject)payApplyEntity.get(0);
        Long pkValue = (Long)payApplyBill.getPkValue();
        if (EmptyUtil.isEmpty((Long)pkValue)) {
            long payApplyBillEntryId = DB.genLongId((String)"cas_payapplybill");
            model.setValue("cas_payapplyentry.id", (Object)payApplyBillEntryId, 0);
            model.setValue("e_splitid", (Object)payApplyBillEntryId, 0);
            model.setValue("entry_applyid", (Object)payApplyBillEntryId, 0);
        }
        PayApplyEntryEdit.initDraftAmtTotal(this.getView());
        PayApplyEntryEdit.initArrivalUnlockAmt(this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        Object newValue;
        Object newValue2;
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        List<String> templeKey = Arrays.asList(FIELD_TEMPLE);
        IDataModel model = this.getModel();
        if (templeKey.contains(fieldKey)) {
            this.changedEntryPayInfo(fieldKey, rowIndex);
        }
        if ("entry_payeraccbank".equals(fieldKey)) {
            newValue2 = (DynamicObject)changeData[0].getNewValue();
            DynamicObject settleMentType = (DynamicObject)this.getModel().getValue("entry_settlementtype", rowIndex);
            if (EmptyUtil.isEmpty((DynamicObject)settleMentType) || EmptyUtil.isEmpty((DynamicObject)newValue2)) {
                this.getModel().setValue("entry_payeraccbank", null, rowIndex);
                this.getModel().setValue("entry_balance", (Object)0, rowIndex);
                this.getModel().setValue("entry_lastmodifytime", null, rowIndex);
                this.getModel().setValue("entry_payerbank", null, rowIndex);
                this.getModel().setValue("entry_paymentchannel", null, rowIndex);
                this.getModel().setValue("entry_payinstitutioncode", null, rowIndex);
                this.getModel().setValue("entry_payinstitutionname", null, rowIndex);
                return;
            }
            DynamicObject bank = (DynamicObject)newValue2.get("bank");
            this.setPaymentChannelValue((DynamicObject)newValue2, rowIndex);
            this.getModel().setValue("entry_payerbank", (Object)bank, rowIndex);
            this.updateBalance(new int[]{rowIndex});
        } else if ("planpaydate".equals(fieldKey)) {
            DynamicObjectCollection payInfoEntry = model.getEntryEntity("cas_payinfo");
            if (!payInfoEntry.isEmpty()) {
                newValue = changeData[0].getNewValue();
                for (int i = 0; i < payInfoEntry.size(); ++i) {
                    model.setValue("entry_expectdate", newValue, i);
                }
            }
        } else if ("entry_payeebank".equals(fieldKey)) {
            DynamicObject payeeBank = (DynamicObject)model.getValue("entry_payeebank", rowIndex);
            if (EmptyUtil.isEmpty((DynamicObject)payeeBank)) {
                this.getModel().setValue("entry_recbanknumber", null, rowIndex);
                this.getModel().setValue("entry_recswiftcode", null, rowIndex);
                this.getModel().setValue("entry_recroutingnum", null, rowIndex);
                this.getModel().setValue("entry_recothercode", null, rowIndex);
            } else {
                this.getModel().setValue("entry_recbanknumber", payeeBank.get("union_number"), rowIndex);
                this.getModel().setValue("entry_recswiftcode", payeeBank.get("swift_code"), rowIndex);
                this.getModel().setValue("entry_recroutingnum", payeeBank.get("routingnum"), rowIndex);
                this.getModel().setValue("entry_recothercode", payeeBank.get("other_code"), rowIndex);
            }
        } else if ("entry_settlementtype".equals(fieldKey)) {
            String newType;
            DynamicObject oldValue2 = (DynamicObject)changeData[0].getOldValue();
            newValue = (DynamicObject)changeData[0].getNewValue();
            PaymentChannelHelper.initPaymentChannel(rowIndex, (DynamicObject)newValue, (DynamicObject)this.getModel().getValue("entry_payeraccbank", rowIndex), this.getView());
            if (EmptyUtil.isEmpty((DynamicObject)newValue) || EmptyUtil.isEmpty((DynamicObject)oldValue2)) {
                return;
            }
            String oldType = (String)oldValue2.get("settlementtype");
            if (!oldType.equals(newType = (String)newValue.get("settlementtype")) && (SettleMentTypeEnum.VIRTUAL.getValue().equals(oldType) || SettleMentTypeEnum.VIRTUAL.getValue().equals(newType))) {
                this.getModel().setValue("entry_payeraccbank", null, rowIndex);
                this.getModel().setValue("entry_payerbank", null, rowIndex);
                this.getModel().setValue("entry_balance", null, rowIndex);
                this.getModel().setValue("entry_lastmodifytime", null, rowIndex);
            }
            if (PayApplyEntryEdit.isDraftbillSettlement(oldValue2) != PayApplyEntryEdit.isDraftbillSettlement((DynamicObject)newValue)) {
                model.setValue("entry_draftbill", null, rowIndex);
            }
            if (PayApplyEntryEdit.isArrivalSettlement(oldValue2) != PayApplyEntryEdit.isArrivalSettlement((DynamicObject)newValue)) {
                model.setValue("entry_arrivalno", null, rowIndex);
            }
            PayApplyEntryEdit.initDraftAmtTotal(this.getView());
            PayApplyEntryEdit.initArrivalUnlockAmt(this.getView());
        } else if ("entry_paymentchannel".equals(fieldKey)) {
            newValue2 = (String)changeData[0].getNewValue();
            oldValue = (String)changeData[0].getOldValue();
            DynamicObject payerAccBank = (DynamicObject)model.getValue("entry_payeraccbank", rowIndex);
            String result = PayApplyEntryEdit.checkPaymentChannel(payerAccBank, (String)newValue2);
            if (result != null) {
                model.setValue("entry_paymentchannel", oldValue, rowIndex);
                this.getView().showErrorNotification(result);
                return;
            }
        } else if ("entry_draftbill".equals(fieldKey)) {
            newValue2 = (DynamicObjectCollection)changeData[0].getNewValue();
            CharSequence[] draftbillnos = (String[])newValue2.stream().map(coll -> coll.getDynamicObject("fbasedataid").getString("draftbillno")).toArray(String[]::new);
            model.setValue("entry_settletnumber", (Object)String.join((CharSequence)"\uff1b", draftbillnos), rowIndex);
            BigDecimal draftamttotal = BigDecimal.ZERO;
            List amountList = newValue2.stream().map(coll -> coll.getDynamicObject("fbasedataid").getBigDecimal("amount")).collect(Collectors.toList());
            for (BigDecimal amount : amountList) {
                draftamttotal = draftamttotal.add(amount);
            }
            model.setValue("entry_draftamttotal", (Object)draftamttotal, rowIndex);
            Object payeeamount = model.getValue("entry_payeeamount", rowIndex);
            if (payeeamount == null || BigDecimal.ZERO.compareTo(new BigDecimal(payeeamount.toString())) == 0) {
                model.setValue("entry_payeeamount", (Object)draftamttotal, rowIndex);
                Object entry_applyid = model.getValue("entry_applyid", rowIndex);
                if (entry_applyid != null) {
                    DynamicObjectCollection payApplyEntry = model.getEntryEntity("cas_payapplyentry");
                    for (int i = 0; i < payApplyEntry.size(); ++i) {
                        if (!((DynamicObject)payApplyEntry.get(i)).get("e_splitid").equals(entry_applyid)) continue;
                        model.setValue("e_payeeamount", (Object)draftamttotal, i);
                        break;
                    }
                }
            }
        } else if ("entry_arrivalno".equals(fieldKey)) {
            newValue2 = changeData[0].getNewValue();
            BigDecimal arrivalunlockamt = null;
            String settletnumber = null;
            if (newValue2 != null) {
                DynamicObject arrivalBill = BusinessDataServiceHelper.loadSingle((Object)newValue2, (String)"lc_arrival");
                arrivalunlockamt = arrivalBill.getBigDecimal("todoamount").subtract(arrivalBill.getBigDecimal("lockamount"));
                settletnumber = arrivalBill.getString("arrivalno");
            }
            model.setValue("entry_settletnumber", settletnumber, rowIndex);
            model.setValue("entry_arrivalunlockamt", arrivalunlockamt, rowIndex);
        } else if ("entry_settletnumber".equals(fieldKey)) {
            DynamicObject settleType = (DynamicObject)this.getModel().getValue("entry_settlementtype", rowIndex);
            if (PayApplyEntryEdit.isDraftbillSettlement(settleType)) {
                DynamicObjectCollection draftBill = (DynamicObjectCollection)model.getValue("entry_draftbill", rowIndex);
                if (draftBill != null && draftBill.size() > 0) {
                    String newValue3 = (String)changeData[0].getNewValue();
                    if (newValue3 == null || newValue3.length() < 1) {
                        model.setValue("entry_draftbill", null, rowIndex);
                    } else {
                        CharSequence[] draftbillnos = (String[])draftBill.stream().map(coll -> coll.getDynamicObject("fbasedataid").getString("draftbillno")).toArray(String[]::new);
                        if (!String.join((CharSequence)"\uff1b", draftbillnos).equals(newValue3)) {
                            model.setValue("entry_settletnumber", (Object)String.join((CharSequence)"\uff1b", draftbillnos), rowIndex);
                        }
                    }
                } else {
                    model.setValue("entry_settletnumber", null, rowIndex);
                }
            } else if (PayApplyEntryEdit.isArrivalSettlement(settleType)) {
                newValue = (String)changeData[0].getNewValue();
                if (newValue == null || ((String)newValue).length() < 1) {
                    model.setValue("entry_arrivalno", null, rowIndex);
                } else {
                    model.setValue("entry_arrivalno", model.getValue("entry_arrivalno", rowIndex), rowIndex);
                }
            }
        }
        if ("entry_payeetype".equals(fieldKey) || "entry_payeename".equals(fieldKey)) {
            model.setValue("entry_draftbill", null, rowIndex);
            model.setValue("entry_arrivalno", null, rowIndex);
        }
        if ("payeecurrency".equals(fieldKey)) {
            newValue2 = changeData[0].getNewValue();
            oldValue = changeData[0].getOldValue();
            DynamicObjectCollection payInfoEntry = model.getEntryEntity("cas_payinfo");
            if (newValue2 != oldValue && !payInfoEntry.isEmpty()) {
                for (int i = 0; i < payInfoEntry.size(); ++i) {
                    model.setValue("entry_draftbill", null, i);
                }
            }
        }
        if ("entry_paycurrency".equals(fieldKey)) {
            this.updateBalance(new int[]{rowIndex});
        }
    }

    public static boolean isDraftbillSettlement(DynamicObject settleType) {
        return settleType != null && (SettleMentTypeEnum.CHECK.getValue().equals(settleType.getString("settlementtype")) || SettleMentTypeEnum.BUSINESS.getValue().equals(settleType.getString("settlementtype")) || SettleMentTypeEnum.BANK.getValue().equals(settleType.getString("settlementtype")));
    }

    public static boolean isArrivalSettlement(DynamicObject settleType) {
        return settleType != null && SettleMentTypeEnum.CREDIT.getValue().equals(settleType.getString("settlementtype"));
    }

    public static void initDraftAmtTotal(IFormView view) {
        view.setVisible(Boolean.valueOf(PayApplyEntryEdit.isDraftbillSettlement(view.getModel().getEntryEntity("cas_payinfo"))), new String[]{"entry_draftamttotal"});
    }

    private static boolean isDraftbillSettlement(DynamicObjectCollection payinfoCollection) {
        return payinfoCollection.stream().filter(payEntry -> PayApplyEntryEdit.isDraftbillSettlement(payEntry.getDynamicObject("entry_settlementtype"))).findFirst().isPresent();
    }

    public static void initArrivalUnlockAmt(IFormView view) {
        view.setVisible(Boolean.valueOf(PayApplyEntryEdit.isArrivalSettlement(view.getModel().getEntryEntity("cas_payinfo"))), new String[]{"entry_arrivalunlockamt"});
    }

    private static boolean isArrivalSettlement(DynamicObjectCollection payinfoCollection) {
        return payinfoCollection.stream().filter(payEntry -> PayApplyEntryEdit.isArrivalSettlement(payEntry.getDynamicObject("entry_settlementtype"))).findFirst().isPresent();
    }

    public static String checkPaymentChannel(DynamicObject payerAccBank, String newValue) {
        if (payerAccBank != null) {
            if (PaymentChannelEnum.ONLINEBANK.getValue().equals(newValue) && !payerAccBank.getBoolean("isopenbank")) {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u7f51\u4e0a\u94f6\u884c\u3002", (String)"PayApplyEntryEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (PaymentChannelEnum.BEI.getValue().equals(newValue) && !payerAccBank.getBoolean("issetbankinterface")) {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u3002", (String)"PayApplyEntryEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void updateBalance(int[] selectRows) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("payorg");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u672a\u5237\u65b0\u5373\u65f6\u4f59\u989d\u3002", (String)"PayApplyEntryEdit_30", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<String> keySet = new HashSet<String>();
        for (int i : selectRows) {
            DynamicObject payerAccBank = (DynamicObject)this.getModel().getValue("entry_payeraccbank", i);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("entry_paycurrency", i);
            String payStatus = (String)this.getModel().getValue("entry_paystatus", i);
            if (payerAccBank == null || currency == null || !PayStatusEnum.NOTPAYING.getValue().equals(payStatus)) continue;
            String payerAccBankId = String.valueOf(payerAccBank.getLong("id"));
            String currencyId = String.valueOf(currency.getLong("id"));
            keySet.add(payerAccBankId.concat(";").concat(currencyId));
        }
        String balanceType = SystemParameterFcsHelper.getParameterString((long)org.getLong("id"), (String)"balancevalue");
        ArrayList<BizBalanceModelBean> bizBeanList = new ArrayList<BizBalanceModelBean>(keySet.size());
        for (String key : keySet) {
            BizBalanceModelBean bizBean = new BizBalanceModelBean();
            String[] keys = key.split(";");
            bizBean.setAccountId(Long.valueOf(Long.parseLong(keys[0])));
            bizBean.setCurrencyId(Long.valueOf(Long.parseLong(keys[1])));
            bizBean.setBalanceType(balanceType);
            bizBeanList.add(bizBean);
        }
        Map<String, BizBalanceModelBean> bizBalanceModelBeanMap = null;
        if (!bizBeanList.isEmpty()) {
            ModelRequestBean modelRequestBean = new ModelRequestBean();
            modelRequestBean.setBizBeans(bizBeanList);
            Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalanceBatch", (Object[])new Object[]{SerializationUtils.toJsonString((Object)modelRequestBean)});
            modelRequestBean = (ModelRequestBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), ModelRequestBean.class);
            if (modelRequestBean != null && modelRequestBean.getBizBeans() != null) {
                bizBalanceModelBeanMap = modelRequestBean.getBizBeans().stream().filter(d -> d != null && EmptyUtil.isNoEmpty((Long)d.getAccountId()) && EmptyUtil.isNoEmpty((Long)d.getCurrencyId())).collect(Collectors.toMap(e -> e.getAccountId() + ";" + e.getCurrencyId(), e -> e, (v1, v2) -> v2));
            }
        }
        for (int i : selectRows) {
            this.updateBalance(i, bizBalanceModelBeanMap);
        }
    }

    private void updateBalance(int i, Map<String, BizBalanceModelBean> bizBalanceModelBeanMap) {
        DynamicObject payerAccBank = (DynamicObject)this.getModel().getValue("entry_payeraccbank", i);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("entry_paycurrency", i);
        String payStatus = (String)this.getModel().getValue("entry_paystatus", i);
        BigDecimal balance = null;
        Date accountBankLastModifyTime = null;
        if (PayStatusEnum.NOTPAYING.getValue().equals(payStatus)) {
            BizBalanceModelBean bizBalanceModelBean;
            if (payerAccBank != null && currency != null && bizBalanceModelBeanMap != null && (bizBalanceModelBean = bizBalanceModelBeanMap.get(payerAccBank.getLong("id") + ";" + currency.getLong("id"))) != null) {
                balance = bizBalanceModelBean.getAmount();
                accountBankLastModifyTime = bizBalanceModelBean.getLastTime();
            }
            this.getModel().setValue("entry_balance", balance, i);
            this.getModel().setValue("entry_lastmodifytime", accountBankLastModifyTime, i);
        }
    }

    public static Date getAccountBankLastModifyTime(Long acctBankID, Long currencyID) {
        DynamicObject acctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)acctBankID, (String)"bd_accountbanks");
        if (acctBank != null && acctBank.getBoolean("issetbankinterface")) {
            QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", (Object)acctBankID), new QFilter("currency", "=", (Object)currencyID)};
            DynamicObjectCollection balanceInquires = QueryServiceHelper.query((String)"getLastestBalanceInquire", (String)"bei_bankbalance", (String)"amount,bizdate,modifytime", (QFilter[])filters, (String)"modifytime desc", (int)1);
            if (balanceInquires.isEmpty()) {
                return null;
            }
            return ((DynamicObject)balanceInquires.get(0)).getDate("modifytime");
        }
        return new Date();
    }

    private void changedEntryPayInfo(String templeKey, int rowIndex) {
        String key = templeKey.substring(2);
        IDataModel model = this.getModel();
        DynamicObjectCollection payApplyEntry = model.getEntryEntity("cas_payapplyentry");
        DynamicObjectCollection payInfoEntry = model.getEntryEntity("cas_payinfo");
        DynamicObject payApply = (DynamicObject)payApplyEntry.get(rowIndex);
        Long payApplyEntryId = payApply.getLong("e_splitid");
        for (int i = 0; i < payInfoEntry.size(); ++i) {
            Long applyId = (Long)model.getValue("entry_applyid", i);
            if (payApplyEntryId.compareTo(applyId) != 0) continue;
            model.setValue("entry_" + key, ((DynamicObject)payApplyEntry.get(rowIndex)).get(templeKey), i);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String key = evt.getFieldName();
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"entry_paybillno")) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("cas_payinfo", rowIndex);
            String e_billno = entryRowEntity.getString("entry_paybillno");
            String[] billnos = e_billno.split(",");
            HashSet<String> set = new HashSet<String>(billnos.length);
            for (String billno : billnos) {
                set.add(billno);
            }
            QFilter billno = new QFilter("billno", "in", set);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{billno});
            ArrayList<Long> billIds = new ArrayList<Long>(ids.length);
            ArrayList<Tuple> tuples = new ArrayList<Tuple>(2);
            for (DynamicObject bill : ids) {
                billIds.add(bill.getLong("id"));
            }
            if (billIds.size() > 0) {
                tuples.add(new Tuple((Object)"cas_paybill", billIds));
            }
            CasBotpHelper.showTrackParameter(tuples, (IFormView)this.getView());
        }
    }

    private void setPaymentChannelValue(DynamicObject payerAcctBank, int rowIndex) {
        String defChannel = PayApplyEntryEdit.getPaymentChannelValue((ComboEdit)this.getControl("entry_paymentchannel"), payerAcctBank, this.getModel(), rowIndex);
        this.getModel().setValue("entry_paymentchannel", (Object)defChannel, rowIndex);
        PaymentChannelHelper.initPaymentChannel(rowIndex, null, payerAcctBank, this.getView());
    }

    public static String getPaymentChannelValue(ComboEdit paymentChannel, DynamicObject payerAcctBank, IDataModel model, int rowIndex) {
        boolean isSetBankInterface;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(PaymentChannelEnum.COUNTER.getValue());
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.COUNTER.getName(), (String)"PaymentBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        ComboItem selectedItem = comboItem;
        comboItems.add(comboItem);
        ComboItem item = new ComboItem();
        item.setValue(PaymentChannelEnum.ONLINEBANK.getValue());
        item.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.ONLINEBANK.getName(), (String)"PaymentBillEdit_17", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        comboItems.add(item);
        ComboItem itemBei = new ComboItem();
        itemBei.setValue(PaymentChannelEnum.BEI.getValue());
        itemBei.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.BEI.getName(), (String)"PaymentBillEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        comboItems.add(itemBei);
        boolean isOpenBank = payerAcctBank.getBoolean("isopenbank");
        if (isOpenBank) {
            selectedItem = item;
        }
        if (isSetBankInterface = payerAcctBank.getBoolean("issetbankinterface")) {
            selectedItem = itemBei;
        }
        paymentChannel.setComboItems(comboItems);
        String defaultPaymentChannel = "";
        DynamicObject settletype = (DynamicObject)model.getValue("entry_settlementtype", rowIndex);
        if (Objects.nonNull(settletype) && StringUtils.isNotEmpty((CharSequence)(defaultPaymentChannel = settletype.getString("defaultpaymentchannel")))) {
            if (!isOpenBank && Objects.equals(defaultPaymentChannel, PaymentChannelEnum.ONLINEBANK.getValue()) || !isSetBankInterface && Objects.equals(defaultPaymentChannel, PaymentChannelEnum.BEI.getValue())) {
                return null;
            }
            return defaultPaymentChannel;
        }
        return selectedItem.getValue();
    }
}

