/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.paybill.convert;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.util.DraftBillUtils;
import kd.fi.cas.util.EmptyUtil;

public class Pay2DraftAllocConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(Pay2DraftAllocConvertPlugin.class);

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntities;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject draftAlloc = billDataEntity.getDataEntity();
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object id = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcData.get(0));
            DynamicObject paymentBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_paybill");
            DynamicObjectCollection drafts = paymentBill.getDynamicObjectCollection("draftbill");
            DynamicObjectCollection endorseDetails = draftAlloc.getDynamicObjectCollection("entryentity");
            HashMap<Long, BigDecimal> transAmoutMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, Long> billLogMap = new HashMap<Long, Long>();
            DynamicObjectCollection entryEntitys = paymentBill.getDynamicObjectCollection("cas_draftinfo");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntitys) && entryEntitys.size() > 0) {
                for (DynamicObject entryEntity : entryEntitys) {
                    DynamicObject draftbillinfo = entryEntity.getDynamicObject("draftbillinfo");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)draftbillinfo) || !DraftBillUtils.isReceiveBill((String)draftbillinfo.getString("rptype"))) continue;
                    transAmoutMap.put(draftbillinfo.getLong("id"), entryEntity.getBigDecimal("transamount"));
                    Long draftbilllogid = entryEntity.getLong("draftbilllogid");
                    if (!EmptyUtil.isNoEmpty((Long)draftbilllogid)) continue;
                    billLogMap.put(draftbillinfo.getLong("id"), draftbilllogid);
                }
            } else {
                for (DynamicObject draft2 : drafts) {
                    DynamicObject draftDy = draft2.getDynamicObject("fbasedataid");
                    if (EmptyUtil.isEmpty((DynamicObject)draftDy) || !DraftBillUtils.isReceiveBill((String)draftDy.getString("rptype"))) continue;
                    long draftid = draft2.getDynamicObject("fbasedataid").getLong("id");
                    BigDecimal transamount = draft2.getDynamicObject("fbasedataid").getBigDecimal("amount");
                    transAmoutMap.put(draftid, transamount);
                }
            }
            List draftBills = drafts.stream().filter(draft -> EmptyUtil.isNoEmpty((DynamicObject)draft.getDynamicObject("fbasedataid")) && DraftBillUtils.isReceiveBill((String)draft.getDynamicObject("fbasedataid").getString("rptype"))).map(d -> d.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            BigDecimal amount = BigDecimal.ZERO;
            if (!draftBills.isEmpty()) {
                for (DynamicObject draftBill : draftBills) {
                    this.fillHead(draftAlloc, draftBill);
                    EntryProp p = (EntryProp)draftAlloc.getDynamicObjectType().getProperty("entryentity");
                    DynamicObject dynamicObject = new DynamicObject(p.getDynamicCollectionItemPropertyType());
                    dynamicObject.set("e_draftbill", (Object)draftBill);
                    dynamicObject.set("e_subbillamt", transAmoutMap.get(draftBill.getLong("id")));
                    Long billLogId = (Long)billLogMap.get(draftBill.getLong("id"));
                    if (EmptyUtil.isNoEmpty((Long)billLogId)) {
                        dynamicObject.set("draftbilllogid", (Object)billLogId);
                    }
                    endorseDetails.add((Object)dynamicObject);
                    amount = amount.add((BigDecimal)transAmoutMap.get(draftBill.getLong("id")));
                }
                Object draftbilltypeId = ((DynamicObject)draftBills.get(0)).getDynamicObject("draftbilltype").getPkValue();
                DynamicObject draftbilltype = BusinessDataServiceHelper.loadSingle((Object)draftbilltypeId, (String)"cdm_billtype");
                String billmedium = draftbilltype.getString("billmedium");
                if ("2".equals(billmedium)) {
                    Object bankAccountid = ((DynamicObject)draftBills.get(0)).getDynamicObject("bankaccount").getPkValue();
                    DynamicObject bankaccount = BusinessDataServiceHelper.loadSingle((Object)bankAccountid, (String)"bd_accountbanks");
                    this.setInAccount(draftAlloc, paymentBill, bankaccount);
                }
            }
            draftAlloc.set("biztype", (Object)"allocate");
            draftAlloc.set("amount", (Object)amount);
            draftAlloc.set("draftcount", (Object)endorseDetails.size());
        }
    }

    private void setInAccount(DynamicObject draftAlloc, DynamicObject paymentBill, DynamicObject bankaccount) {
        DynamicObject payeracctbank = paymentBill.getDynamicObject("payeracctbank");
        QFilter companyIdFilter = new QFilter("company", "=", paymentBill.getDynamicObject("org").getPkValue());
        if (null != payeracctbank) {
            QFilter defaultaccountIdFilter = new QFilter("defaultaccount", "=", payeracctbank.getPkValue());
            DynamicObject[] eleDirectSetList = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id", (QFilter[])new QFilter[]{defaultaccountIdFilter});
            if (null != eleDirectSetList && eleDirectSetList.length > 0) {
                logger.info("inaccount from payeracctbank");
                draftAlloc.set("inaccount", (Object)payeracctbank);
            } else {
                logger.info("eleDirectSetList is null");
                this.setInAccountnNotByPayAcc(draftAlloc, bankaccount, companyIdFilter);
            }
        } else {
            logger.info("payeracctbank is null");
            this.setInAccountnNotByPayAcc(draftAlloc, bankaccount, companyIdFilter);
        }
    }

    private void setInAccountnNotByPayAcc(DynamicObject draftAlloc, DynamicObject bankaccount, QFilter companyIdFilter) {
        long bankId = bankaccount.getLong("id");
        DynamicObject[] bankaccounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"bank.bank_cate", (QFilter[])new QFilter("id", "=", (Object)bankId).toArray());
        long bank_cateId = bankaccounts[0].getDynamicObject("bank.bank_cate").getLong("id");
        QFilter bankIdIdFilter = new QFilter("directconnchannel", "=", (Object)bank_cateId);
        DynamicObject[] eleDirectSetListByBank = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount,directconnchannel", (QFilter[])new QFilter[]{companyIdFilter, bankIdIdFilter});
        if (null != eleDirectSetListByBank && eleDirectSetListByBank.length > 0) {
            logger.info("inaccount from  eleDirectSetListByBank");
            draftAlloc.set("inaccount", (Object)eleDirectSetListByBank[0].getDynamicObject("defaultaccount"));
        } else {
            DynamicObject[] eleDirectSetListByCompany = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount,istransbank", (QFilter[])new QFilter[]{companyIdFilter});
            if (null != eleDirectSetListByCompany && eleDirectSetListByCompany.length > 0) {
                List istransbankList = Arrays.stream(eleDirectSetListByCompany).filter(x -> x.getBoolean("istransbank")).collect(Collectors.toList());
                if (null != istransbankList && istransbankList.size() > 0) {
                    logger.info("inaccount from  istransbank");
                    draftAlloc.set("inaccount", (Object)((DynamicObject)istransbankList.get(0)).getDynamicObject("defaultaccount"));
                } else {
                    logger.info("inaccount from  eleDirectSetListByCompany");
                    draftAlloc.set("inaccount", (Object)eleDirectSetListByCompany[0].getDynamicObject("defaultaccount"));
                }
            } else {
                logger.info("eleDirectSetListByCompany is null");
            }
        }
    }

    private void fillHead(DynamicObject draftAlloc, DynamicObject draft) {
        DynamicObject outCompany = draft.getDynamicObject("company");
        DynamicObject billPool = draft.getDynamicObject("billpool");
        if (billPool != null) {
            billPool = BusinessDataServiceHelper.loadSingle((Object)billPool.getPkValue(), (String)billPool.getDynamicObjectType().getName());
            String dispatchRule = billPool.getString("dispatchrule");
            draftAlloc.set("dispatchrule", (Object)dispatchRule);
            draftAlloc.set("billpool", (Object)billPool);
            draftAlloc.set("company", (Object)billPool.getDynamicObject("company"));
            draftAlloc.set("outcompany", (Object)outCompany);
        }
    }
}

