/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.paybill.convert;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.CdmBizConstant;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentBillRecbookConverter
extends AbstractConvertPlugIn {
    protected String getSourceKey() {
        return "org,payeracctbank";
    }

    protected String getTargetKey() {
        return "draweraccount,drawerbankname,drawerbankno,payeetype";
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField(this.getSourceKey());
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject[] finOrgInfos;
            QFilter filter;
            DynamicObject drawercompany;
            Boolean isBusiness;
            DynamicObject[] dynObjWithId;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cas_paybill");
            DynamicObject type = sourceBill.getDynamicObject("settletype");
            BigDecimal actpayamt = sourceBill.getBigDecimal("actpayamt");
            targetBill.set("casamount", (Object)actpayamt);
            targetBill.set("supperbillamount", (Object)actpayamt);
            DraftHelper.setSubBillInfo((DynamicObject)targetBill, (BigDecimal)actpayamt);
            String description = targetBill.getString("description");
            if (EmptyUtil.isEmpty((String)description)) {
                targetBill.set("description", (Object)sourceBill.getString("usage"));
            }
            if ((dynObjWithId = BusinessDataServiceHelper.load((String)"cdm_billtype", (String)"id,settlementtype,billmedium", (QFilter[])new QFilter[]{new QFilter("settlementtypebd.fbasedataid.id", "=", type.getPkValue()), new QFilter("enable", "=", (Object)"1")})).length != 0) {
                targetBill.set("draftbilltype", (Object)dynObjWithId[0]);
                this.draftbilltypeChange(dynObjWithId[0], targetBill);
            }
            if ((isBusiness = Boolean.valueOf(SettleMentTypeEnum.BUSINESS.getValue().equals(type.get("settlementtype")))).booleanValue() && (drawercompany = targetBill.getDynamicObject("drawercompany")) != null) {
                targetBill.set("acceptername", (Object)drawercompany.getString("name"));
            }
            if (CasHelper.isEmpty((Object)sourceBill.get("payeracctbank"))) {
                QFilter statusFilter;
                QFilter deffilter;
                DynamicObject org = sourceBill.getDynamicObject("org");
                filter = new QFilter("company", "=", org.getPkValue());
                DynamicObject[] accountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber,bank,isdefaultpay", (QFilter[])new QFilter[]{filter, deffilter = new QFilter("isdefaultpay", "=", (Object)"1"), statusFilter = new QFilter("acctstatus", "=", (Object)"normal")});
                if (null != accountBank && accountBank.length > 0) {
                    this.setValue(targetBill, accountBank[0], type.getString("settlementtype"));
                }
            } else {
                DynamicObject accountBank = sourceBill.getDynamicObject("payeracctbank");
                filter = new QFilter("bankaccountnumber", "=", (Object)accountBank.getString("number"));
                DynamicObject[] acctBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber,bank", (QFilter[])new QFilter[]{filter});
                if (acctBank != null && acctBank.length > 0) {
                    DynamicObject bank = acctBank[0];
                    targetBill.set("drawerbankno", bank.get("bank.union_number"));
                    if (!isBusiness.booleanValue()) {
                        targetBill.set("accepterbankno", bank.get("bank.union_number"));
                    }
                    if (SettleMentTypeEnum.CHECK.getValue().equals(type.get("settlementtype"))) {
                        targetBill.set("drawerorg", bank.get("bank"));
                    }
                }
            }
            if (!CasHelper.isEmpty((Object)sourceBill.get("payeebank")) || CasHelper.isEmpty((Object)sourceBill.get("recbanknumber")) || (finOrgInfos = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,bebank", (QFilter[])new QFilter[]{new QFilter("union_number", "=", sourceBill.get("recbanknumber"))})) == null || finOrgInfos.length <= 0) continue;
            targetBill.set("receiverbank", (Object)finOrgInfos[0].getDynamicObject("bebank"));
        }
    }

    private void setValue(DynamicObject targetBill, DynamicObject accountBank, String settleType) {
        targetBill.set("drawerbankname", accountBank.get("bank.name"));
        targetBill.set("drawerbankno", accountBank.get("bank.union_number"));
        if (SettleMentTypeEnum.CHECK.getValue().equals(settleType)) {
            targetBill.set("drawerorg", accountBank.get("bank"));
            targetBill.set("draweraccountname", accountBank.get("bankaccountnumber"));
            return;
        }
        targetBill.set("draweraccount", (Object)accountBank);
        if (!SettleMentTypeEnum.BUSINESS.getValue().equals(settleType)) {
            targetBill.set("acceptername", accountBank.get("bank.name"));
            targetBill.set("accepterbankname", accountBank.get("bank.name"));
            targetBill.set("accepterbankno", accountBank.get("bank.union_number"));
        }
    }

    private void draftbilltypeChange(DynamicObject draftbilltypeDO, DynamicObject targetBill) {
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            long billtypeId = CdmBizConstant.PAYABLEBILL_BANK;
            String billMedium = draftbilltypeDO.getString("billmedium");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                billtypeId = "1".equals(billMedium) ? CdmBizConstant.PAYABLEBILL_BANK.longValue() : CdmBizConstant.PAYABLEBILL_BANK_ELECT.longValue();
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                billtypeId = "1".equals(billMedium) ? CdmBizConstant.PAYABLEBILL_BUSINESS.longValue() : CdmBizConstant.PAYABLEBILL_BUSINESS_ELECT.longValue();
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                billtypeId = CdmBizConstant.PAYABLEBILL_CHECK;
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                billtypeId = CdmBizConstant.PAYABLEBILL_PROMISSORY;
            }
            DynamicObject dyBilltype = BusinessDataServiceHelper.loadSingle((Object)billtypeId, (String)"bos_billtype");
            targetBill.set("billtype", (Object)dyBilltype);
        }
    }
}

