/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.permission;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PermissionUpgradeServiceImpl {
    public void addPermItemsByExistPermItem(String existPermItemID, String existEntityTypeID, String existAppID, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        this.processUserPerm(existPermItemID, existEntityTypeID, existAppID, newEntityTypeID, newAppID, newPermItemIds);
        this.processRolePerm(existPermItemID, existEntityTypeID, existAppID, newEntityTypeID, newAppID, newPermItemIds);
        this.processBizRolePerm(existPermItemID, existEntityTypeID, existAppID, newEntityTypeID, newAppID, newPermItemIds);
        PermissionServiceHelper.clearAllCache();
    }

    private void processBizRolePerm(String existPermItemID, String existEntityTypeID, String existAppID, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        Set parentIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)"select fid from t_perm_bizroleperm where fpermitemid=? and fentitytypeid=? and fbizappid=?;", (Object[])new Object[]{existPermItemID, existEntityTypeID, existAppID}, r -> {
            HashSet<String> ids = new HashSet<String>(4);
            while (r.next()) {
                ids.add(r.getString("fid"));
            }
            return ids;
        });
        String insertSql = "INSERT INTO t_perm_bizroleperm(FID,FENTRYID,FSEQ,FPERMITEMID,FENTITYTYPEID,FBIZAPPID) VALUES (?,?,?,?,?,?);";
        for (String newPermItemID : newPermItemIds) {
            Set hadPermIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)"select fid from t_perm_bizroleperm where FPERMITEMID=? and fentitytypeid=? and fbizappid=?;", (Object[])new Object[]{newPermItemID, newEntityTypeID, newAppID}, r -> {
                HashSet<String> ids = new HashSet<String>(4);
                while (r.next()) {
                    String fid = r.getString("fid");
                    ids.add(fid);
                }
                return ids;
            });
            HashSet realIds = new HashSet(parentIds);
            realIds.removeAll(hadPermIds);
            int pidSize = realIds.size();
            ArrayList<Object[]> paramCache = new ArrayList<Object[]>(4);
            int i = 0;
            long[] entryIds = DB.genLongIds((String)"t_perm_bizroleperm", (int)pidSize);
            for (String pid : realIds) {
                Object[] param = new Object[]{pid, entryIds[i], 0, newPermItemID, newEntityTypeID, newAppID};
                paramCache.add(param);
                if (++i % 1000 != 0 && i != pidSize) continue;
                DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, paramCache);
                paramCache.clear();
            }
        }
    }

    private void processRolePerm(String existPermItemID, String existEntityTypeID, String existAppID, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        Set parentIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)"select fid from t_perm_rolepermdetial where fpermitemid=? and fentitytypeid=? and fbizappid=?;", (Object[])new Object[]{existPermItemID, existEntityTypeID, existAppID}, r -> {
            HashSet<String> ids = new HashSet<String>(8);
            while (r.next()) {
                ids.add(r.getString("fid"));
            }
            return ids;
        });
        String insertSql = "INSERT INTO T_PERM_ROLEPERMDETIAL(FID,FENTRYID,FSEQ,FCONTROLMODE,FPERMITEMID,FINHERITMODE,FENTITYTYPEID,FBIZAPPID) VALUES (?,?,?,?,?,?,?,?);";
        for (String newPermItemID : newPermItemIds) {
            Set hadPermIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)"select fid from T_PERM_ROLEPERMDETIAL where FPERMITEMID=? and fentitytypeid=? and fbizappid=?;", (Object[])new Object[]{newPermItemID, newEntityTypeID, newAppID}, r -> {
                HashSet<String> ids = new HashSet<String>(8);
                while (r.next()) {
                    String fid = r.getString("fid");
                    ids.add(fid);
                }
                return ids;
            });
            HashSet realIds = new HashSet(parentIds);
            realIds.removeAll(hadPermIds);
            int pidSize = realIds.size();
            ArrayList<Object[]> paramCache = new ArrayList<Object[]>(8);
            int i = 0;
            String[] entryIds = DB.genStringIds((String)"T_PERM_ROLEPERMDETIAL", (int)pidSize);
            for (String pid : realIds) {
                Object[] param = new Object[]{pid, entryIds[i], 0, Character.valueOf(' '), newPermItemID, Character.valueOf(' '), newEntityTypeID, newAppID};
                paramCache.add(param);
                if (++i % 1000 != 0 && i != pidSize) continue;
                DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, paramCache);
                paramCache.clear();
            }
        }
    }

    private void processUserPerm(String existPermItemID, String existEntityTypeID, String existAppID, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        Set noPermParentIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)"select p.fid as fid from t_perm_userperm as p inner join t_perm_disfunperm as d on p.fuserid=d.fuserid and p.forgid=d.forgid where d.fpermitemid=? and d.fentitytypeid=? and d.fbizappid=?;", (Object[])new Object[]{existPermItemID, existEntityTypeID, existAppID}, r -> {
            HashSet<String> ids = new HashSet<String>(16);
            while (r.next()) {
                ids.add(r.getString("fid"));
            }
            return ids;
        });
        Set parentIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)"select fid from T_PERM_USERPERMDETAIL where fpermitemid=? and fentitytypeid=? and fbizappid=?;", (Object[])new Object[]{existPermItemID, existEntityTypeID, existAppID}, r -> {
            HashSet<String> ids = new HashSet<String>(32);
            while (r.next()) {
                String fid = r.getString("fid");
                ids.add(fid);
            }
            return ids;
        });
        parentIds.removeAll(noPermParentIds);
        String insertSql = "INSERT INTO T_PERM_USERPERMDETAIL(FID,FENTRYID,FSEQ,FCONTROLMODE,FPERMITEMID,FENTITYTYPEID,FBIZAPPID,FSOURCE,FBIZROLEID) VALUES (?,?,?,?,?,?,?,?,?);";
        for (String newPermItemID : newPermItemIds) {
            Set hadPermIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)"select fid from T_PERM_USERPERMDETAIL where FPERMITEMID=? and fentitytypeid=? and fbizappid=?;", (Object[])new Object[]{newPermItemID, newEntityTypeID, newAppID}, r -> {
                HashSet<String> ids = new HashSet<String>(32);
                while (r.next()) {
                    String fid = r.getString("fid");
                    ids.add(fid);
                }
                return ids;
            });
            HashSet realIds = new HashSet(parentIds);
            realIds.removeAll(hadPermIds);
            int pidSize = realIds.size();
            ArrayList<Object[]> paramCache = new ArrayList<Object[]>(32);
            int i = 0;
            String[] entryIds = DB.genStringIds((String)"T_PERM_USERPERMDETAIL", (int)pidSize);
            for (String pid : realIds) {
                Object[] param = new Object[]{pid, entryIds[i], 0, 10, newPermItemID, newEntityTypeID, newAppID, 1, 0};
                paramCache.add(param);
                if (++i % 1000 != 0 && i != pidSize) continue;
                DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, paramCache);
                paramCache.clear();
            }
        }
    }
}

