/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.rec;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.RecAmtTypeEnum;
import kd.fi.cas.enums.RecTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class RecBillBatchInputPlugin
extends BillEditPlugin {
    private static Log logger = LogFactory.getLog(RecBillBatchInputPlugin.class);
    private static final String KEY_CLOSECALLBACK_CHARGEBACK = "CALLBACK_SELECTDRAFT";
    private static final String ER_PAYEER = "er_payeer";
    private static final String ENTRY = "entryentity";
    private static final Set<String> CORE_BILLTYPES = Stream.of("ar_finarbill", "sm_salorder", "conm_salcontract", "cas_paybill", "er_repaymentbill", "fr_glreim_recbill").collect(Collectors.toSet());

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "biztypetext", "payertypetext"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit orgname = (TextEdit)this.getView().getControl("orgname");
        TextEdit openorgname = (TextEdit)this.getView().getControl("openorgname");
        TextEdit payeebanknum = (TextEdit)this.getView().getControl("payeebanknum");
        TextEdit payeebankname = (TextEdit)this.getView().getControl("payeebankname");
        TextEdit payername = (TextEdit)this.getView().getControl("payername");
        TextEdit payeracctbanknum = (TextEdit)this.getView().getControl("payeracctbanknum");
        TextEdit payerbankname = (TextEdit)this.getView().getControl("payerbankname");
        TextEdit settletnumber = (TextEdit)this.getView().getControl("settletnumber");
        TextEdit corebillno = (TextEdit)this.getView().getControl("e_corebillno");
        orgname.addButtonClickListener((ClickListener)this);
        openorgname.addButtonClickListener((ClickListener)this);
        payeebanknum.addButtonClickListener((ClickListener)this);
        payeebankname.addButtonClickListener((ClickListener)this);
        payername.addButtonClickListener((ClickListener)this);
        payeracctbanknum.addButtonClickListener((ClickListener)this);
        payerbankname.addButtonClickListener((ClickListener)this);
        settletnumber.addButtonClickListener((ClickListener)this);
        corebillno.addButtonClickListener((ClickListener)this);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        this.filterRecType(rowIndex);
        this.fillPayeeAcctBank(rowIndex);
        this.fillCurrency(rowIndex);
        this.filterESettleOrg();
        this.fillFundFlow(rowIndex);
        this.expenseItem();
        Object vtual = this.getModel().getValue("isvirtual", rowIndex);
        if (vtual != null) {
            Boolean isvirtual = (Boolean)vtual;
            if (isvirtual.booleanValue()) {
                this.setVirtualSettlementTypeFilter();
            } else {
                this.setSettlementTypeFilter();
            }
        }
    }

    public void afterLoadData(EventObject e) {
        FormShowParameter param;
        OperationStatus status;
        super.afterLoadData(e);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        String payertype = (String)this.getValue("payertype", rowIndex);
        if (payertype.equals(AsstActTypeEnum.EMPLOYEE.getValue()) && CasHelper.isEmpty((Object)this.getValue("f7_payerbank", rowIndex)) && CasHelper.isEmpty((Object)this.getValue("payeracctbanknum", rowIndex))) {
            this.userF7Changed(null, this.getValue("userf7"), rowIndex);
        }
        if ((status = (param = this.getView().getFormShowParameter()).getStatus()).equals((Object)OperationStatus.VIEW)) {
            this.getModel().setDataChanged(false);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String clickItem = c.getKey().toLowerCase();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        switch (clickItem) {
            case "orgname": 
            case "openorgname": 
            case "payeebanknum": 
            case "payeebankname": {
                this.changePayeePage(rowIndex);
                break;
            }
            case "payername": 
            case "payeracctbanknum": 
            case "payerbankname": {
                this.addPayer(OperationStatus.EDIT, rowIndex);
                break;
            }
            case "e_corebillno": {
                this.getCorebilltypeToChange(rowIndex);
                break;
            }
            case "settletnumber": {
                this.settleNumberClick(rowIndex);
                break;
            }
            case "btnok": {
                this.checkAndSave();
                break;
            }
            case "biztypetext": 
            case "payertypetext": {
                this.fillPayRecType();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initRowData(0);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("newentry".equals(operateKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY);
            this.initRowData(entryEntity.size() - 1);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        int rowIndex = changeData[0].getRowIndex();
        switch (fieldKey) {
            case "biztype": {
                this.bizTypeChange(newValue, rowIndex);
                break;
            }
            case "org": {
                this.setDefaultOpenOrg(rowIndex);
                break;
            }
            case "accountbank": {
                this.payeeAcctBankF7Changed(newValue, rowIndex);
                break;
            }
            case "accountcash": {
                this.accountCashChanged(rowIndex);
                break;
            }
            case "basecurrency": {
                DynamicObject srcCurrency = this.getDynamicObject("currency", rowIndex);
                DynamicObject destCurrency = this.getDynamicObject("basecurrency", rowIndex);
                if (srcCurrency == null || destCurrency == null) {
                    return;
                }
                if (srcCurrency.getLong("id") != destCurrency.getLong("id")) break;
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"exchangerate"});
                break;
            }
            case "currency": {
                this.currencyF7Changed(newValue, rowIndex);
                this.changeCurrencyOrActPayAmt(rowIndex);
                this.updateCoreBill(true, rowIndex);
                break;
            }
            case "bizdate": {
                if (newValue == null) {
                    return;
                }
                this.setValue("exratedate", newValue, rowIndex);
                this.currencyF7Changed(newValue, rowIndex);
                break;
            }
            case "exratetable": 
            case "exratedate": {
                this.currencyF7Changed(newValue, rowIndex);
                break;
            }
            case "payertype": {
                this.payerTypeChanged(e, newValue, true, rowIndex);
                this.updateCoreBill(true, rowIndex);
                break;
            }
            case "userf7": {
                this.userF7Changed(e, newValue, rowIndex);
                break;
            }
            case "exchangerate": 
            case "quotation": 
            case "e_actamt": 
            case "e_receivableamt": 
            case "e_discountamt": {
                this.calculateAmt(rowIndex);
                break;
            }
            case "e_fee": {
                this.calculateFee(rowIndex);
                break;
            }
            case "receivingtype": {
                this.recTypeChanged(oldValue, newValue, rowIndex);
                this.setESettleOrg(false, rowIndex);
                this.setEcorebilltype(rowIndex);
                this.lockOrUnlockInnerAccountFiled(rowIndex);
                this.changeCurrencyOrActPayAmt(rowIndex);
                break;
            }
            case "settletype": {
                this.settleTypeChanged((DynamicObject)newValue, rowIndex);
                this.isClearSettleType((DynamicObject)oldValue, (DynamicObject)newValue, rowIndex);
                break;
            }
            case "settletnumber": {
                DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
                if (!CasHelper.isNotEmpty((Object)settleType)) break;
                String settleTypeBizType = settleType.getString("settlementtype");
                if (!SettleMentTypeEnum.PROMISSORY.getValue().equals(settleTypeBizType) && !SettleMentTypeEnum.DRAFT.getValue().equals(settleTypeBizType) && !SettleMentTypeEnum.BUSINESS.getValue().equals(settleTypeBizType) && !SettleMentTypeEnum.BANK.getValue().equals(settleTypeBizType)) break;
                if (this.isEquals(rowIndex)) {
                    return;
                }
                this.setValue("draftbill", null, rowIndex);
                break;
            }
            case "draftbill": {
                DynamicObjectCollection coll = (DynamicObjectCollection)this.getValue("draftbill", rowIndex);
                List<String> draftNoList = this.getDraftNoList(coll);
                if (draftNoList == null || draftNoList.size() == 0) {
                    return;
                }
                String dfratnoStr = draftNoList.stream().collect(Collectors.joining(";"));
                this.setValue("settletnumber", dfratnoStr, rowIndex);
                break;
            }
            case "e_corebilltype": {
                this.updateCoreBill(false, rowIndex);
                this.getModel().setValue("e_corebillno", null, rowIndex);
                this.getModel().setValue("e_corebillentryseq", null, rowIndex);
                this.getModel().setValue("conbillentity", null, rowIndex);
                this.getModel().setValue("conbillnumber", null, rowIndex);
                this.getModel().setValue("conbillrownum", null, rowIndex);
                break;
            }
            case "e_corebillno": {
                this.checkChangeData(newValue, rowIndex);
                if (!EmptyUtil.isEmpty((Object)e.getChangeSet()[0].getNewValue())) break;
                this.updateCoreBill(false, rowIndex);
                break;
            }
            case "actrecamt": {
                this.changeCurrencyOrActPayAmt(rowIndex);
                break;
            }
        }
    }

    private void lockOrUnlockInnerAccountFiled(int rowIndex) {
        DynamicObject paymentType = this.getDynamicObject("receivingtype", rowIndex);
        if (paymentType != null) {
            String sourceBillType = (String)this.getValue("sourcebilltype", rowIndex);
            if (paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.FUNDS_DOWN.getValue()) && "fca_transdownbill".equals(sourceBillType)) {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (SystemParameterHelper.isShowInternalAccount((long)org.getLong("id"))) {
                    this.setInnerAccountFiledEdit(true, rowIndex);
                    ((TextEdit)this.getControl("inneraccountamount")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"RecBillInnerAccount_0", (String)"fi-cas-formplugin", (Object[])new Object[0])));
                } else {
                    this.setInnerAccountFiledEdit(false, rowIndex);
                }
            } else if (paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue())) {
                this.setInnerAccountFiledEdit(true, rowIndex);
                ((TextEdit)this.getControl("inneraccountamount")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"RecBillInnerAccount_1", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            } else {
                this.setInnerAccountFiledEdit(false, rowIndex);
            }
        } else {
            this.setInnerAccountFiledEdit(false, rowIndex);
        }
        DynamicObject accountBank = this.getDynamicObject("accountbank", rowIndex);
        if (accountBank == null) {
            return;
        }
        if (PayBillCrossHelper.isInnerAcct((Object)accountBank.getPkValue())) {
            this.setInnerAccountFiledEdit(false, rowIndex);
        }
    }

    private void setInnerAccountFiledEdit(boolean enable, int rowIndex) {
        this.getView().setEnable(Boolean.valueOf(enable), rowIndex, new String[]{"inneraccount", "inneraccountcurrency", "inneraccountamount"});
        if (!enable) {
            this.getModel().setValue("inneraccount", null, rowIndex);
            this.getModel().setValue("inneraccountcurrency", null, rowIndex);
            this.getModel().setValue("inneraccountamount", null, rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        switch (actionId) {
            case "changepayee": {
                Map payeeInfoMap = (Map)e.getReturnData();
                if (payeeInfoMap == null) break;
                this.changePayeeValue(payeeInfoMap, rowIndex);
                break;
            }
            case "addpayer": {
                Map payerInfoMap = (Map)e.getReturnData();
                if (payerInfoMap == null) break;
                this.addPayerValue(payerInfoMap, rowIndex);
                break;
            }
            case "e_corebillno": {
                Map<Long, BigDecimal> actpayamt;
                int currentRowIndex;
                Object returnData = e.getReturnData();
                if (CasHelper.isEmpty((Object)returnData)) break;
                IDataModel model = this.getModel();
                String coreBillType = (String)model.getValue("e_corebilltype", currentRowIndex = model.getEntryCurrentRowIndex(ENTRY));
                if (this.isOpenSelectCorebill(coreBillType)) {
                    return;
                }
                ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)returnData;
                int entryRowCount = model.getEntryRowCount(ENTRY);
                int followingRowCount = entryRowCount - currentRowIndex - 1;
                if (coreBillCollection.size() - 1 > followingRowCount) {
                    model.appendEntryRow("entry", entryRowCount - 1, coreBillCollection.size() - 1 - followingRowCount);
                }
                DynamicObject settleorg = (DynamicObject)model.getValue("e_settleorg", currentRowIndex);
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                formShowParameter.setCustomParam("isSelectCoreBillNo", (Object)"true");
                HashMap<Integer, Long> actMap = new HashMap<Integer, Long>(coreBillCollection.size());
                for (int i = 0; i < coreBillCollection.size(); ++i) {
                    ListSelectedRow listSelectedRow = coreBillCollection.get(i);
                    model.setValue("e_settleorg", (Object)settleorg, currentRowIndex + i);
                    this.getModel().beginInit();
                    model.setValue("e_corebilltype", (Object)coreBillType, currentRowIndex + i);
                    this.getModel().endInit();
                    this.getView().updateView("e_corebilltype", currentRowIndex + i);
                    model.setValue("e_corebillno", (Object)listSelectedRow.getBillNo(), currentRowIndex + i);
                    if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.REPAYMENTBILL.getValue())) {
                        model.setValue("e_sourcebillid", listSelectedRow.getPrimaryKeyValue(), currentRowIndex + i);
                        model.setValue("e_sourcebillentryid", listSelectedRow.getEntryPrimaryKeyValue(), currentRowIndex + i);
                        model.setValue("e_corebillid", listSelectedRow.getEntryPrimaryKeyValue(), currentRowIndex + i);
                        actMap.put(currentRowIndex + i, (Long)listSelectedRow.getEntryPrimaryKeyValue());
                    }
                    String entryEntityKey = listSelectedRow.getEntryEntityKey();
                    Object entryPKValue = listSelectedRow.getEntryPrimaryKeyValue();
                    if (entryPKValue != null) {
                        QFilter[] filters = new QFilter[]{new QFilter((String)entryEntityKey + ".id", "=", entryPKValue)};
                        DynamicObject coreBill = QueryServiceHelper.queryOne((String)coreBillType, (String)((String)entryEntityKey + ".seq"), (QFilter[])filters);
                        if (coreBill != null) {
                            model.setValue("e_corebillentryseq", (Object)coreBill.getString((String)entryEntityKey + ".seq"), currentRowIndex + i);
                        }
                    }
                    this.getModel().beginInit();
                    if (ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType) || ClaimCoreBillTypeEnum.SALCONTRACT.getValue().equals(coreBillType)) {
                        DynamicObject queryInfo;
                        List<String> conGroupFields;
                        boolean isMaterialEntry;
                        boolean isSalOrder = ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType);
                        boolean isSelectEntry = !kd.fi.cas.util.StringUtils.isEmpty((String)entryEntityKey) && !ObjectUtils.isEmpty((Object)entryPKValue);
                        boolean bl = isMaterialEntry = !kd.fi.cas.util.StringUtils.isEmpty((String)entryEntityKey) && "billentry".equals(entryEntityKey);
                        if (isSelectEntry && isMaterialEntry) {
                            conGroupFields = isSalOrder ? Arrays.asList((String)entryEntityKey + ".conbillnumber", (String)entryEntityKey + ".conbillrownum", (String)entryEntityKey + ".conbillid", (String)entryEntityKey + ".conbillentryid") : Arrays.asList("id", "billno", (String)entryEntityKey + ".lineno", (String)entryEntityKey + ".id");
                            QFilter[] filters = new QFilter[]{new QFilter((String)entryEntityKey + ".id", "=", entryPKValue)};
                            queryInfo = QueryServiceHelper.queryOne((String)coreBillType, (String)String.join((CharSequence)",", conGroupFields), (QFilter[])filters);
                            if (queryInfo != null) {
                                model.setValue("conbillentity", (Object)"conm_salcontract", currentRowIndex + i);
                                model.setValue("conbillnumber", (Object)(isSalOrder ? queryInfo.getString((String)entryEntityKey + ".conbillnumber") : queryInfo.getString("billno")), currentRowIndex + i);
                                model.setValue("conbillrownum", (Object)(isSalOrder ? queryInfo.getString((String)entryEntityKey + ".conbillrownum") : queryInfo.getString((String)entryEntityKey + ".lineno")), currentRowIndex + i);
                            }
                        } else {
                            conGroupFields = isSalOrder ? Arrays.asList("billentry.conbillnumber", "billentry.conbillrownum", "billentry.conbillid", "billentry.conbillentryid") : Arrays.asList("id", "billno", "billentry.lineno", "billentry.id");
                            QFilter filter = new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue());
                            queryInfo = QueryServiceHelper.queryOne((String)coreBillType, (String)String.join((CharSequence)",", conGroupFields), (QFilter[])new QFilter[]{filter});
                            if (queryInfo != null) {
                                model.setValue("conbillnumber", (Object)(isSalOrder ? queryInfo.getString("billentry.conbillnumber") : queryInfo.getString("billno")), currentRowIndex + i);
                            }
                            model.setValue("conbillentity", (Object)"conm_salcontract", currentRowIndex + i);
                            model.setValue("conbillrownum", (Object)"", currentRowIndex + i);
                        }
                    }
                    this.getModel().endInit();
                    this.getView().updateView("conbillentity", currentRowIndex + i);
                    this.getView().updateView("conbillnumber", currentRowIndex + i);
                    this.getView().updateView("conbillrownum", currentRowIndex + i);
                }
                if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.PAYBILL.getValue())) {
                    QFilter qFilter = new QFilter("id", "in", actMap.keySet());
                    actpayamt = QueryServiceHelper.query((String)"cas_paybill", (String)"id , actpayamt", (QFilter[])new QFilter[]{qFilter}).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getBigDecimal("actpayamt")));
                    for (Map.Entry act : actMap.entrySet()) {
                        this.getModel().setValue("e_receivableamt", (Object)actpayamt.get(act.getValue()), ((Integer)act.getKey()).intValue());
                    }
                } else if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.REPAYMENTBILL.getValue())) {
                    QFilter qFilter = new QFilter("er_repaymentbill.repaymententry.id", "in", actMap.values());
                    actpayamt = QueryServiceHelper.query((String)"er_repaymentbill", (String)"er_repaymentbill.repaymententry.id id, er_repaymentbill.repaymententry.orirepayamount orirepayamount, er_repaymentbill.repaymententry.orirecamount orirecamount,er_repaymentbill.repaymententry.remarks remarks,er_repaymentbill.repaymententry.sourceexpenseitem.id expenseitem", (QFilter[])new QFilter[]{qFilter}).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (m1, m2) -> m1));
                    DynamicObject repayDy = null;
                    for (Map.Entry act : actMap.entrySet()) {
                        repayDy = (DynamicObject)actpayamt.get(act.getValue());
                        if (EmptyUtil.isNoEmpty((DynamicObject)repayDy)) {
                            this.getModel().setValue("e_receivableamt", (Object)repayDy.getBigDecimal("orirepayamount").subtract(repayDy.getBigDecimal("orirecamount")), ((Integer)act.getKey()).intValue());
                            this.getModel().setValue("e_actamt", (Object)repayDy.getBigDecimal("orirepayamount").subtract(repayDy.getBigDecimal("orirecamount")), ((Integer)act.getKey()).intValue());
                            this.getModel().setValue("e_remark", repayDy.get("remarks"), ((Integer)act.getKey()).intValue());
                            this.getModel().setValue("e_expenseitem", repayDy.get("expenseitem"), ((Integer)act.getKey()).intValue());
                            continue;
                        }
                        this.getModel().setValue("e_receivableamt", null, ((Integer)act.getKey()).intValue());
                        this.getModel().setValue("e_actamt", null, ((Integer)act.getKey()).intValue());
                        this.getModel().setValue("e_remark", null, ((Integer)act.getKey()).intValue());
                        this.getModel().setValue("e_expenseitem", null, ((Integer)act.getKey()).intValue());
                    }
                }
                formShowParameter.setCustomParam("isSelectCoreBillNo", (Object)"false");
                break;
            }
            case "settletnumber": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
                if (!EmptyUtil.isNoEmpty((Object)rows)) break;
                CasBotpHelper.doDraw((IFormView)this.getView(), (String)"lc_present", (String)this.getModel().getDataEntityType().getName(), (ListSelectedRowCollection)rows);
                break;
            }
            case "batchpayrectype": {
                Map resultMap = (Map)e.getReturnData();
                if (resultMap == null) break;
                String biztype = (String)resultMap.get("biztype");
                String payertype = (String)resultMap.get("payertype");
                if (!EmptyUtil.isNotEmpty((String)biztype) || !EmptyUtil.isNotEmpty((String)payertype)) break;
                this.setValue("biztype", biztype, rowIndex);
                this.setValue("biztypetext", RecTypeEnum.getName((String)biztype), rowIndex);
                this.setValue("payertype", payertype, rowIndex);
                this.setValue("payertypetext", AsstActTypeEnum.getName((String)payertype), rowIndex);
            }
        }
    }

    private void initRowData(int rowIndex) {
        DynamicObject receivingtype;
        DynamicObject org = this.getDynamicObject("org", rowIndex);
        if (org == null) {
            DynamicObject curOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getOrgId(), (String)"bos_org");
            this.setValue("org", curOrg, rowIndex);
        }
        String initBizType = "SalesRec";
        String bizType = this.getString("biztype", rowIndex);
        if (EmptyUtil.isEmpty((String)bizType)) {
            bizType = initBizType;
            this.getModel().setValue("biztype", (Object)bizType, rowIndex);
        }
        this.getModel().setValue("biztypetext", (Object)RecTypeEnum.getName((String)bizType), rowIndex);
        DynamicObject receivingType = this.getDynamicObject("receivingtype", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)receivingType)) {
            this.setRecTypeByBizType(rowIndex);
        }
        if (bizType.equals(RecTypeEnum.OtherRec.toString())) {
            this.setValue("payertype", AsstActTypeEnum.OTHER.getValue(), rowIndex);
            this.setValue("payertypetext", AsstActTypeEnum.OTHER.getName(), rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_material"});
        } else {
            this.setValue("payertype", AsstActTypeEnum.CUSTOMER.getValue(), rowIndex);
            this.setValue("payertypetext", AsstActTypeEnum.CUSTOMER.getName(), rowIndex);
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_material"});
        }
        this.fillPayerType(rowIndex);
        Date currentDate = DateUtils.getCurrentDate();
        this.setValueIfAbsent("bizdate", currentDate, rowIndex);
        this.setValueIfAbsent("exratedate", currentDate, rowIndex);
        org = this.getDynamicObject("org", rowIndex);
        if (org != null) {
            Long orgId = org.getLong("id");
            this.setDefaultExratetable(orgId, rowIndex);
            if (!SystemStatusCtrolHelper.isInitEnable((long)orgId)) {
                this.getView().showErrorNotification(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
                return;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"ReceivingBillEdit_34", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"payeebank"});
        this.setValueIfAbsent("settletype", BaseDataHelper.getDefaultSettleType(), rowIndex);
        this.payeeF7Changed(null, this.getValue("org", rowIndex), rowIndex);
        this.payeeAcctBankF7Changed(this.getDynamicObject("accountbank", rowIndex), rowIndex);
        this.currencyF7Changed(this.getDynamicObject("currency", rowIndex), rowIndex);
        this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"customerf7"});
        this.setPayeeInfo(rowIndex);
        this.fillPayerType(rowIndex);
        this.setDefaultOpenOrg(rowIndex);
        this.setESettleOrg(false, rowIndex);
        this.setDefaultSettleValue(rowIndex);
        DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType) && org != null) {
            Long orgId = org.getLong("id");
            this.setValue("accountcash", AccountCashHelper.getDefaultAccountcash((Long)orgId, (String)"payee"), rowIndex);
        }
        if ((receivingtype = this.getDynamicObject("receivingtype", rowIndex)) != null) {
            this.fillFundflowItem(true, receivingtype.getDynamicObject("fundflowitem"), rowIndex);
        }
        this.getModel().setDataChanged(false);
    }

    private void setPayeeInfo(int rowIndex) {
        DynamicObject org = this.getDynamicObject("org", rowIndex);
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)this.getDynamicObject("settletype", rowIndex));
        DynamicObject payerAcctBank = this.getDynamicObject("accountbank", rowIndex);
        DynamicObject accountCash = this.getDynamicObject("accountcash", rowIndex);
        String payeebanknumStr = "";
        if (isCash && accountCash != null) {
            payeebanknumStr = accountCash.getString("number");
        }
        if (!isCash && payerAcctBank != null) {
            payeebanknumStr = kd.fi.cas.util.StringUtils.splitString((String)payerAcctBank.getString("bankaccountnumber"), (int)4, (String)" ");
        }
        DynamicObject payeebank = this.getDynamicObject("payeebank", rowIndex);
        String payeeBanknameStr = "";
        if (payeebank != null) {
            payeeBanknameStr = CasHelper.getLocalValue((DynamicObject)payeebank, (String)"name");
        }
        this.setValue("orgname", CasHelper.getLocalValue((DynamicObject)org, (String)"name"));
        this.setValue("openorgname", CasHelper.getLocalValue((DynamicObject)org, (String)"name"));
        this.setValue("payeebanknum", payeebanknumStr);
        this.setValue("payeebankname", payeeBanknameStr);
    }

    private void setPayerInfo(int rowIndex) {
        String payername = (String)this.getValue("payername", rowIndex);
        long payeeId = (Long)this.getValue("payer");
        String payertype = this.getString("payertype");
        if (!CasHelper.isEmpty((Object)payeeId)) {
            DynamicObject obj = null;
            if (payertype.equals("bd_supplier") || payertype.equals("bd_customer")) {
                obj = BusinessDataServiceHelper.loadSingle((Object)payeeId, (String)payertype, (String)"name");
            } else if (payertype.equals("bos_user")) {
                obj = BusinessDataServiceHelper.loadSingle((Object)payeeId, (String)payertype, (String)"name");
            }
            if (obj != null && kd.fi.cas.util.StringUtils.isEmpty((String)payername)) {
                payername = CasHelper.getLocalValue((DynamicObject)obj, (String)"name");
            }
        }
        this.setValue("payername", payername, rowIndex);
    }

    private void setRecTypeByBizType(int rowIndex) {
        String biztype = this.getString("biztype", rowIndex);
        Object[] recbilltypes = null;
        QFilter[] qFilters = biztype.equals(RecTypeEnum.OtherRec.toString()) ? new QFilter[]{new QFilter("id", "=", (Object)180953578175745024L), new QFilter("enable", "=", (Object)"1"), new QFilter("number", "!=", (Object)"106")} : new QFilter[]{new QFilter("id", "=", (Object)180951994582732800L), new QFilter("enable", "=", (Object)"1"), new QFilter("number", "!=", (Object)"106"), new QFilter("ispartreceivable", "=", (Object)"1")};
        recbilltypes = BusinessDataServiceHelper.load((String)"cas_receivingbilltype", (String)"id,number,name,ispartreceivable,biztype,fundflowitem.id,fundflowitem.number,fundflowitem.name", (QFilter[])qFilters);
        if (EmptyUtil.isNoEmpty((Object[])recbilltypes)) {
            this.setValue("receivingtype", recbilltypes[0], rowIndex);
        } else {
            this.setValue("receivingtype", null, rowIndex);
        }
    }

    private void filterRecType(int rowIndex) {
        BasedataEdit receivabletypeF7 = (BasedataEdit)this.getControl("receivingtype");
        receivabletypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and(new QFilter("number", "!=", (Object)"106"));
            String rectype = this.getModel().getValue("biztype", rowIndex).toString();
            if (RecTypeEnum.SalesRec.toString().equals(rectype)) {
                qFilter.and("ispartreceivable", "=", (Object)"1");
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillPayeeAcctBank(int rowIndex) {
        BasedataEdit payerAcctBankF7 = (BasedataEdit)this.getControl("accountbank");
        payerAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setIsolationOrg(false);
            DynamicObject payee = this.getDynamicObject("org", rowIndex);
            if (payee != null) {
                QFilter[] usableAccountFilter = AccountBankHelper.getUsableAccountFilter((long)payee.getLong("id"));
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(usableAccountFilter));
            } else {
                showParameter.getListFilterParameter().setFilter(AccountBankHelper.getUsableFilter());
            }
        });
    }

    private void fillCurrency(int rowIndex) {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParam = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
            boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
            Collection currencyPks = new ArrayList();
            if (isCash) {
                DynamicObject accountCash = this.getDynamicObject("accountcash", rowIndex);
                if (accountCash != null) {
                    currencyPks = AccountCashHelper.getCurrencys(Collections.singletonList(accountCash.getLong("id")));
                }
            } else {
                DynamicObject payerAcctBank = this.getDynamicObject("accountbank", rowIndex);
                if (payerAcctBank != null) {
                    currencyPks = AccountBankHelper.getCurrencyPks((long)payerAcctBank.getLong("id"));
                }
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("id", "in", currencyPks)};
            showParam.getListFilterParameter().setQFilters(Arrays.asList(qFilters));
        });
    }

    private void fillPayerType(int rowIndex) {
        ComboEdit payertypeCbo = (ComboEdit)this.getView().getControl("payertype");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String rectype = (String)customParams.get("recmentType");
        if (rectype == null) {
            Object type = this.getValue("biztype", rowIndex);
            rectype = type != null ? type.toString() : "";
        }
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        if (rectype.equals(RecTypeEnum.OtherRec.toString())) {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.OTHER.getName()), AsstActTypeEnum.OTHER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
        } else {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
        }
        payertypeCbo.setComboItems(comboItem);
    }

    private void filterESettleOrg() {
        BasedataEdit settleorg = (BasedataEdit)this.getControl("e_settleorg");
        settleorg.addBeforeF7SelectListener(select -> {
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            showParam.setCustomParam("orgFuncId", (Object)"10");
        });
    }

    private void fillFundFlow(int rowIndex) {
        BasedataEdit fundFlow = (BasedataEdit)this.getControl("e_fundflowitem");
        fundFlow.addBeforeF7SelectListener(select -> {
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            DynamicObject org = this.getDynamicObject("org", rowIndex);
            QFilter[] qFilters = new QFilter[]{new QFilter("direction", "!=", (Object)"C"), new QFilter("isleaf", "=", (Object)"1")};
            showParam.setCustomParam("org", (Object)String.valueOf(org.getPkValue()));
            showParam.getListFilterParameter().setQFilters(Arrays.asList(qFilters));
        });
    }

    protected void expenseItem() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("e_expenseitem");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object[] objects = BusinessDataServiceHelper.load((String)"er_expenseitembill", (String)"id,expenseitem", (QFilter[])new QFilter[]{new QFilter("billtype.bill_number.number", "=", (Object)"cas_recbill")});
            if (EmptyUtil.isEmpty((Object[])objects)) {
                return;
            }
            List ids = Arrays.stream(objects).map(o -> o.get("expenseitem.id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    private void bizTypeChange(Object newValue, int rowIndex) {
        String newBizType = (String)newValue;
        this.getModel().setValue("biztype", (Object)newBizType, rowIndex);
        this.getModel().setValue("biztypetext", (Object)RecTypeEnum.getName((String)newBizType), rowIndex);
        this.fillPayerType(rowIndex);
        this.setRecTypeByBizType(rowIndex);
        if (newBizType.equals(RecTypeEnum.OtherRec.toString())) {
            this.setValue("payertype", AsstActTypeEnum.OTHER.getValue(), rowIndex);
            this.setValue("payertypetext", AsstActTypeEnum.OTHER.getName(), rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_material"});
        } else {
            this.setValue("payertype", AsstActTypeEnum.CUSTOMER.getValue(), rowIndex);
            this.setValue("payertypetext", AsstActTypeEnum.CUSTOMER.getName(), rowIndex);
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_material"});
        }
    }

    private void fillPayRecType() {
        HashMap<String, String> batchInfo = new HashMap<String, String>();
        batchInfo.put("batchbillname", "cas_batchrecbill");
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_batchpayrectype");
        parameter.getCustomParams().putAll(batchInfo);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchpayrectype"));
        this.getView().showForm(parameter);
    }

    private void changePayeeValue(Map<String, Object> returnMap, int rowIndex) {
        DynamicObject oldAcctcash;
        DynamicObject newAcctcash;
        DynamicObject oldAcctbank;
        DynamicObject newAcctbank;
        DynamicObject oldOrg;
        DynamicObject newOrg = (DynamicObject)returnMap.get("org");
        if (!CasHelper.isEquals((Object)newOrg, (Object)(oldOrg = this.getDynamicObject("org", rowIndex)))) {
            this.setValue("org", newOrg, rowIndex);
            this.setValue("orgname", newOrg.getString("name"), rowIndex);
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)((Long)newOrg.getPkValue()));
            this.setValue("basecurrency", baseCurrency, rowIndex);
            this.setESettleOrg(false, rowIndex);
        }
        if (!CasHelper.isEquals((Object)(newAcctbank = (DynamicObject)returnMap.get("accountbank")), (Object)(oldAcctbank = this.getDynamicObject("accountbank", rowIndex)))) {
            this.setValue("accountbank", newAcctbank, rowIndex);
        }
        if (!CasHelper.isEquals((Object)(newAcctcash = (DynamicObject)returnMap.get("accountcash")), (Object)(oldAcctcash = this.getDynamicObject("accountcash", rowIndex)))) {
            this.setValue("accountcash", newAcctcash, rowIndex);
        }
        String payeebanknum = "";
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)this.getDynamicObject("settletype", rowIndex));
        if (isCash && newAcctcash != null) {
            payeebanknum = newAcctcash.getString("number");
        }
        if (!isCash && newAcctbank != null) {
            payeebanknum = kd.fi.cas.util.StringUtils.splitString((String)newAcctbank.getString("bankaccountnumber"), (int)4, (String)" ");
        }
        this.setValue("payeebanknum", payeebanknum, rowIndex);
        DynamicObject newBank = (DynamicObject)returnMap.get("payeebank");
        DynamicObject oldBank = this.getDynamicObject("payeebank", rowIndex);
        if (!CasHelper.isEquals((Object)oldBank, (Object)newBank)) {
            this.setValue("payeebank", newBank, rowIndex);
            this.setValue("payeebankname", CasHelper.getLocalValue((DynamicObject)newBank, (String)"name"), rowIndex);
        }
        this.setPayeeInfo(rowIndex);
    }

    private void addPayerValue(Map<String, Object> resultMap, int rowIndex) {
        this.setValue("payerformid", resultMap.get("payerformid"), rowIndex);
        this.setValue("payer", resultMap.get("payer"), rowIndex);
        this.setValue("payername", resultMap.get("payername"), rowIndex);
        this.setValue("payernumber", resultMap.get("payernumber"), rowIndex);
        if (this.isHwControl()) {
            this.setValue("hw_payeesiteid", resultMap.get("hw_payeesiteid"));
            this.setValue("scorg", resultMap.get("scorg"), rowIndex);
        }
        this.setValue("payeraccformid", resultMap.get("payeraccformid"), rowIndex);
        this.setValue("payeracctbank", resultMap.get("payeracctbank"), rowIndex);
        this.setValue("payeracctbanknum", resultMap.get("payeracctbanknum"), rowIndex);
        this.setValue("f7_payerbank", resultMap.get("payerbank"), rowIndex);
        this.setValue("payerbankname", resultMap.get("payerbankname"), rowIndex);
        this.setPayerInfo(rowIndex);
    }

    private void setDefaultOpenOrg(int rowIndex) {
        DynamicObject openorg;
        DynamicObject org = this.getDynamicObject("org", rowIndex);
        if (org == null) {
            return;
        }
        Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)org.getPkValue()));
        if (null != companyByOrg && companyByOrg.size() > 0) {
            this.setValue("openorg", companyByOrg.get("id"), rowIndex);
            this.setValue("openorgname", companyByOrg.get("name"), rowIndex);
            return;
        }
        DynamicObject acct = this.getDynamicObject("accountbank", rowIndex);
        if (acct != null && (openorg = acct.getDynamicObject("openorg")) != null && (openorg = QueryServiceHelper.queryOne((String)"bos_org", (String)"fisaccounting", (QFilter[])new QFilter[]{new QFilter("id", "=", openorg.getPkValue())})).getBoolean("fisaccounting")) {
            this.setValue("openorg", acct.getDynamicObject("openorg"), rowIndex);
            this.setValue("openorgname", acct.getDynamicObject("openorg").getString("name"), rowIndex);
            return;
        }
        this.setValue("openorg", null, rowIndex);
    }

    private void setESettleOrg(boolean isBindData, int rowIndex) {
        DynamicObject rectype = this.getDynamicObject("receivingtype", rowIndex);
        if (rectype != null && rectype.getBoolean("ispartreceivable")) {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"e_settleorg"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_settleorg"});
        }
        DynamicObject openOrg = this.getDynamicObject("openorg", rowIndex);
        if (openOrg != null) {
            if (isBindData && CasHelper.isEmpty((Object)this.getDynamicObject("e_settleorg", rowIndex))) {
                this.setValue("e_settleorg", openOrg.getPkValue(), rowIndex);
            }
            if (!isBindData) {
                this.setValue("e_settleorg", openOrg.getPkValue(), rowIndex);
            }
        }
    }

    private void setDefaultSettleValue(int rowIndex) {
        DynamicObject recOrg = this.getDynamicObject("org", rowIndex);
        if ((recOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting")).getBoolean("fisaccounting")) {
            this.getModel().setValue("e_settleorg", this.getValue("org", rowIndex), rowIndex);
            return;
        }
        DynamicObject recAccount = this.getDynamicObject("accountbank", rowIndex);
        if (recAccount != null) {
            this.getModel().setValue("e_settleorg", recAccount.get("openorg"), rowIndex);
            return;
        }
    }

    private void setDefaultExratetable(Long orgId, int rowIndex) {
        Long exchangeRateTableId = 0L;
        try {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
        }
        catch (Exception e) {
            logger.error("RecBillBatchInputPlugin.setDefaultExratetable(), getExrateTable exception:{}", (Object)e.toString());
        }
        this.getModel().setValue("exratetable", (Object)exchangeRateTableId, rowIndex);
    }

    private void userF7Changed(PropertyChangedArgs e, Object newValue, int rowIndex) {
        DynamicObject user = (DynamicObject)newValue;
        if (user != null) {
            DynamicObject erPayeeInfo = this.getErPayeeInfo(user.getLong("id"), user.getString("name"));
            if (erPayeeInfo != null) {
                this.setValue("f7_payerbank", erPayeeInfo.getDynamicObject("payerbank"), rowIndex);
                this.setValue("payeracctbanknum", erPayeeInfo.getString("payeraccount"), rowIndex);
                this.setValue("payeraccformid", ER_PAYEER, rowIndex);
                this.setValue("payeracctbank", erPayeeInfo.getLong("id"), rowIndex);
            } else {
                this.setValue("payeracctbanknum", null, rowIndex);
                this.setValue("f7_payerbank", null, rowIndex);
                this.setValue("payeraccformid", null, rowIndex);
                this.setValue("payeracctbank", null, rowIndex);
            }
        } else {
            this.setValue("payeracctbanknum", null, rowIndex);
            this.setValue("f7_payerbank", null, rowIndex);
            this.setValue("payeraccformid", null, rowIndex);
            this.setValue("payeracctbank", null, rowIndex);
        }
    }

    private void payeeAcctBankF7Changed(Object newValue, int rowIndex) {
        DynamicObject payeeAcctBank = (DynamicObject)newValue;
        if (payeeAcctBank != null) {
            DynamicObject currency = this.getDynamicObject("currency", rowIndex);
            boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"bd_accountbanks", (Object)payeeAcctBank.getPkValue(), (DynamicObject)currency);
            if (!containCurrency) {
                Long currencyId = (Long)payeeAcctBank.get("defaultcurrency.id");
                if (this.isBotpCreate(rowIndex)) {
                    this.setValueIfAbsent("currency", currencyId, rowIndex);
                } else {
                    this.setValue("currency", currencyId, rowIndex);
                }
            }
            this.setValue("payeebank", payeeAcctBank.getDynamicObject("bank"), rowIndex);
            this.setValue("payeebankname", payeeAcctBank.getDynamicObject("bank").getString("name"), rowIndex);
            this.setCurrencyEditable(rowIndex);
        } else {
            this.setValue("payeebank", null, rowIndex);
            if (!this.isBotpCreate(rowIndex)) {
                this.setValue("currency", this.getDynamicObject("basecurrency", rowIndex), rowIndex);
            }
        }
        this.setDefaultOpenOrg(rowIndex);
        this.setESettleOrg(false, rowIndex);
    }

    private void setCurrencyEditable(int rowIndex) {
        boolean isCurrencyEditable = true;
        if (this.isBotpCreate(rowIndex)) {
            isCurrencyEditable = false;
        } else {
            DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
            boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
            if (isCash) {
                DynamicObject accountCash = this.getDynamicObject("accountcash", rowIndex);
                if (accountCash != null) {
                    isCurrencyEditable = !accountCash.getBoolean("isbycurrency");
                }
            } else {
                DynamicObject accountBank = this.getDynamicObject("accountbank", rowIndex);
                if (accountBank != null) {
                    isCurrencyEditable = accountBank.getBoolean("ismulcurrency");
                }
            }
        }
        this.getView().setEnable(Boolean.valueOf(isCurrencyEditable), rowIndex, new String[]{"currency"});
    }

    private void currencyF7Changed(Object newValue, int rowIndex) {
        DynamicObject srcCurrency = this.getDynamicObject("currency", rowIndex);
        DynamicObject destCurrency = this.getDynamicObject("basecurrency", rowIndex);
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"exchangerate"});
        }
    }

    private DynamicObject getErPayeeInfo(long userId, String name) {
        QFilter[] qFilters = new QFilter[]{new QFilter("payer", "=", (Object)userId), new QFilter("status", "=", (Object)Character.valueOf('C')), new QFilter("enable", "=", (Object)"1")};
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number";
        String orderBys = "isdefault desc";
        DynamicObjectCollection erPayeeList = QueryServiceHelper.query((String)ER_PAYEER, (String)"id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number", (QFilter[])qFilters, (String)"isdefault desc", (int)1);
        DynamicObject erPayee = null;
        if (erPayeeList != null && erPayeeList.size() > 0) {
            erPayee = (DynamicObject)erPayeeList.get(0);
        }
        return erPayee;
    }

    private void addPayer(OperationStatus status, int rowIndex) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (this.isHwControl()) {
            paramMap.put("hw_payeesiteid", this.getValue("hw_payeesiteid"));
        }
        paramMap.put("org", this.getDynamicObject("org", rowIndex));
        paramMap.put("asstActType", this.getValue("payertype", rowIndex));
        paramMap.put("rowIndex", rowIndex);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_recaddpayer");
        parameter.setStatus(status);
        parameter.getCustomParams().putAll(paramMap);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addpayer"));
        this.getView().showForm(parameter);
    }

    private void changePayeePage(int rowIndex) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_changepayee");
        DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
        HashMap<String, Boolean> payerInfo = new HashMap<String, Boolean>();
        payerInfo.put("virtual", BaseDataHelper.isSettleTypeVirtual((DynamicObject)settleType));
        payerInfo.put("ReceivingBill", true);
        parameter.getCustomParams().putAll(payerInfo);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changepayee"));
        this.getView().showForm(parameter);
    }

    private void getCorebilltypeToChange(int rowIndex) {
        Object corebilltype = this.getModel().getValue("e_corebilltype", rowIndex);
        if (corebilltype == null || "".equals(corebilltype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"ReceivingBillEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isOpenSelectCorebill(corebilltype)) {
            return;
        }
        ListShowParameter lsp = null;
        if (corebilltype.equals("er_repaymentbill")) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("cas_repaymentbill");
            para.setCustomParam("openSource", (Object)"cas_recbill");
            Object payertype = this.getValue("payertype");
            if (EmptyUtil.isEmpty((Object)payertype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a\u8fd8\u6b3e\u5355\uff0c\u8bf7\u5148\u6307\u5b9a\u4ed8\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"ReceivingBillEdit_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            para.setCustomParam("payertype", payertype);
            Object payername = null;
            payername = "other".equals(payertype) ? this.getValue("payername") : this.getValue("payer");
            if (CasHelper.isEmpty((Object)payername)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a\u201c\u8fd8\u6b3e\u5355\u201d\uff0c\u8bf7\u5148\u6307\u5b9a\u4ed8\u6b3e\u4eba\u3002", (String)"ReceivingBillEdit_23", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            para.setCustomParam("payername", payername);
            Object accountcurrency = this.getValue("currency");
            if (EmptyUtil.isEmpty((Object)accountcurrency)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a\u8fd8\u6b3e\u5355\uff0c\u8bf7\u5148\u6307\u5b9a\u5e01\u79cd", (String)"ReceivingBillEdit_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            para.setCustomParam("accountcurrency", ((DynamicObject)accountcurrency).getPkValue());
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setShowTitle(true);
            para.setStatus(OperationStatus.ADDNEW);
            StyleCss css = new StyleCss();
            css.setWidth("960");
            css.setHeight("580");
            para.getOpenStyle().setInlineStyleCss(css);
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_corebillno"));
            this.getView().showForm(para);
            return;
        }
        lsp = ShowFormHelper.createShowListForm((String)String.valueOf(corebilltype), (boolean)true, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        switch (String.valueOf(corebilltype)) {
            case "ar_finarbill": {
                Object e_settleorg = this.getModel().getValue("e_settleorg", rowIndex);
                if (e_settleorg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ReceivingBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object pkValue = ((DynamicObject)e_settleorg).getPkValue();
                lfp.setFilter(new QFilter("org", "=", pkValue));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                lfp.setFilter(new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"}));
                break;
            }
            case "sm_salorder": {
                Object e_settleorg1 = this.getModel().getValue("e_settleorg", rowIndex);
                if (e_settleorg1 == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ReceivingBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object pkValue1 = ((DynamicObject)e_settleorg1).getPkValue();
                lfp.setFilter(new QFilter("billentry.entrysettleorg", "=", pkValue1));
                Object payer = this.getModel().getValue("payer");
                lfp.setFilter(new QFilter("customer", "=", !ObjectUtils.isEmpty((Object)payer) ? payer : Long.valueOf(0L)));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                lfp.setFilter(new QFilter("changestatus", "<>", (Object)"B"));
                lfp.setFilter(QFilter.of((String)" receiptamount < totalallamount ", (Object[])new Object[0]));
                break;
            }
            case "conm_salcontract": {
                Object e_settleorg2 = this.getModel().getValue("e_settleorg", rowIndex);
                if (e_settleorg2 == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ReceivingBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object pkValue2 = ((DynamicObject)e_settleorg2).getPkValue();
                lfp.setFilter(new QFilter("billentry.entrysettleorg", "=", pkValue2));
                Object payer1 = this.getModel().getValue("payer");
                lfp.setFilter(new QFilter("customer", "=", !ObjectUtils.isEmpty((Object)payer1) ? payer1 : Long.valueOf(0L)));
                lfp.setFilter(new QFilter("validstatus", "<>", (Object)"A"));
                lfp.setFilter(new QFilter("changestatus", "<>", (Object)"B"));
                lfp.setFilter(QFilter.of((String)" receiptallamount < totalallamount ", (Object[])new Object[0]));
                break;
            }
            case "cas_paybill": {
                lfp.setFilter(new QFilter("billstatus", "=", (Object)"D"));
                boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)((DynamicObject)this.getModel().getValue("settletype")));
                DynamicObject payerAcctBank = this.getDynamicObject("accountbank", rowIndex);
                DynamicObject accountCash = this.getDynamicObject("accountcash", rowIndex);
                QFilter payeracctbank = null;
                if (isCash && accountCash != null) {
                    payeracctbank = new QFilter("payeracctcash", "=", accountCash.getPkValue());
                }
                if (!isCash && payerAcctBank != null) {
                    payeracctbank = new QFilter("payeracctbank", "=", payerAcctBank.getPkValue());
                }
                if (EmptyUtil.isEmpty(payeracctbank)) {
                    payeracctbank = new QFilter("payeracctcash", "=", null).and(new QFilter("payeracctbank", "=", null));
                }
                lfp.setFilter(payeracctbank);
                Object payeebanknumObj = this.getModel().getValue("payeebanknum");
                if (EmptyUtil.isNoEmpty((Object)payeebanknumObj)) {
                    lfp.setFilter(new QFilter("payeebanknum", "=", (Object)((String)payeebanknumObj)));
                    break;
                }
                lfp.setFilter(new QFilter("payeebanknum", "=", null));
                break;
            }
            case "fr_glreim_recbill": {
                Object org = this.getModel().getValue("org", rowIndex);
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u7ec4\u7ec7\u3002", (String)"ReceivingBillEdit_16_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object orgPkValue = ((DynamicObject)org).getPkValue();
                lfp.setFilter(new QFilter("accountingorg", "=", orgPkValue));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)"D"));
                lfp.setFilter(new QFilter("castorecamount", ">=", (Object)0));
                break;
            }
        }
        if (ClaimCoreBillTypeEnum.SALCONTRACT.getValue().equals(corebilltype)) {
            lfp.setSelectEntity("payentry");
        } else if (ClaimCoreBillTypeEnum.SALORDER.getValue().equals(corebilltype)) {
            lfp.setSelectEntity("recplanentry");
        } else if (ClaimCoreBillTypeEnum.FINARBILL.getValue().equals(corebilltype)) {
            lfp.setSelectEntity("entry");
        }
        lsp.setCustomParam("ismergerows", (Object)false);
        lsp.setListFilterParameter(lfp);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "e_corebillno");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void settleNumberClick(int rowIndex) {
        DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
        if (CasHelper.isEmpty((Object)settleType)) {
            return;
        }
        String settlementtype = settleType.getString("settlementtype");
        if (SettleMentTypeEnum.CREDIT.getValue().equals(settlementtype)) {
            this.creditBillClick(rowIndex);
        } else {
            this.draftBillClick(settleType, rowIndex);
        }
    }

    private void draftBillClick(DynamicObject settleType, int rowIndex) {
        String settlementtype = settleType.getString("settlementtype");
        DynamicObject org = this.getDynamicObject("org", rowIndex);
        Object payeeType = this.getValue("payertype", rowIndex);
        Long payer = (Long)this.getValue("payer", rowIndex);
        String payername = (String)this.getValue("payername", rowIndex);
        DynamicObject currency = this.getDynamicObject("currency", rowIndex);
        if (SettleMentTypeEnum.PROMISSORY.getValue().equals(settlementtype) || SettleMentTypeEnum.DRAFT.getValue().equals(settlementtype) || SettleMentTypeEnum.BUSINESS.getValue().equals(settlementtype) || SettleMentTypeEnum.BANK.getValue().equals(settlementtype)) {
            BasedataEdit settleNumberId = (BasedataEdit)this.getControl("draftbill");
            settleNumberId.addBeforeF7SelectListener(e -> {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                QFilter billHandleFilter = new QFilter(String.join((CharSequence)".", "company", "id"), "=", (Object)org.getLong("id"));
                billHandleFilter.and(new QFilter("delivername", "=", (Object)payername));
                String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                String noticeClaimAllowStatus = (String)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"noticeclaimallowstatus");
                List<String> allowStatusList = Arrays.asList(noticeClaimAllowStatus.split(","));
                ArrayList<String> draftBillStatusList = new ArrayList<String>();
                for (String allowStatus : allowStatusList) {
                    if (EmptyUtil.isEmpty((String)allowStatus)) continue;
                    draftBillStatusList.add(allowStatus);
                }
                billHandleFilter.and(new QFilter("draftbillstatus", "in", draftBillStatusList));
                billHandleFilter.and(new QFilter("source", "!=", (Object)"cas"));
                billHandleFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
                billHandleFilter.and(new QFilter("isendorsepay", "=", (Object)"0"));
                billHandleFilter.and(new QFilter("currency", "=", currency.getPkValue()));
                billHandleFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                if (settleType != null) {
                    List billTypeIdList = DraftHelper.getBillTypeIdList((Object)settleType.getPkValue(), (String)settlementtype);
                    billHandleFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
                }
                DynamicObject[] billHandleDataArr = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,claimnoticebillno", (QFilter[])new QFilter[]{billHandleFilter});
                List billIdList = Arrays.stream(billHandleDataArr).filter(i -> !RecBillHepler.existsRecBill((Long)i.getLong("id"))).filter(x -> EmptyUtil.isEmpty((String)x.getString("claimnoticebillno"))).map(i -> i.get("id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", billIdList);
                ArrayList<Long> ids = new ArrayList<Long>(0);
                Object draftBillColl = this.getValue("draftbill", rowIndex);
                if (null != draftBillColl) {
                    DynamicObjectCollection colls = (DynamicObjectCollection)draftBillColl;
                    for (DynamicObject coll : colls) {
                        ids.add(((DynamicObject)coll.get("fbasedataid")).getLong("id"));
                    }
                }
                if (ids.size() > 0) {
                    qFilter.or(new QFilter("id", "in", ids));
                }
                showParameter.getListFilterParameter().setFilter(qFilter);
                showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                showParameter.setCustomParam("source", (Object)"rec");
            });
            settleNumberId.click();
        }
    }

    private void creditBillClick(int rowIndex) {
        String appId = AppMetadataCache.getAppInfo((String)"lc").getId();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        AppParam param = new AppParam();
        param.setAppId(appId);
        param.setOrgId(Long.valueOf(org.getLong("id")));
        param.setViewType("08");
        String recmethod = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"recmethod");
        if ("0".equals(recmethod)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "settletnumber");
            QFilter qFilterSour = new QFilter("arrivalstatus", "=", (Object)"present_confirm");
            qFilterSour.and("arrivalway", "!=", (Object)"protest");
            qFilterSour.and(QFilter.sqlExpress((String)"arrivalamount", (String)">", (String)"flockamount"));
            CasBotpHelper.doBeforeDraw((IFormView)this.getView(), (String)"lc_present", (String)this.getModel().getDataEntityType().getName(), (Boolean)false, (QFilter)qFilterSour, (CloseCallBack)closeCallBack);
        }
    }

    private boolean isOpenSelectCorebill(Object corebilltype) {
        return !CORE_BILLTYPES.contains(corebilltype);
    }

    private boolean isHwControl() {
        return this.getPageCache().getAll().containsKey("isHwControl");
    }

    protected void setVirtualSettlementTypeFilter() {
        BasedataEdit settletypeF7 = (BasedataEdit)this.getControl("settletype");
        settletypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (kd.fi.cas.util.StringUtils.isNotEmpty((String)this.getControlBankAcctForSettleType())) {
                DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue(this.getControlBankAcctForSettleType());
                if (payerAcctBank != null) {
                    DynamicObjectCollection colls = payerAcctBank.getDynamicObjectCollection("settlementtype");
                    if (colls != null && colls.size() > 0) {
                        Set ids = colls.stream().map(e -> e.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.VIRTUAL.getValue())};
                        showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilters));
                    }
                } else {
                    QFilter filter = new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.VIRTUAL.getValue());
                    showParameter.getListFilterParameter().setFilter(filter);
                }
            }
        });
    }

    protected void setSettlementTypeFilter() {
        BasedataEdit settletypeF7 = (BasedataEdit)this.getControl("settletype");
        settletypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (kd.fi.cas.util.StringUtils.isNotEmpty((String)this.getControlBankAcctForSettleType())) {
                DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue(this.getControlBankAcctForSettleType());
                if (payerAcctBank != null) {
                    DynamicObjectCollection colls = payerAcctBank.getDynamicObjectCollection("settlementtype");
                    if (colls != null && colls.size() > 0) {
                        Set ids = colls.stream().map(e -> e.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                        QFilter qFilter = new QFilter("id", "in", ids);
                        showParameter.getListFilterParameter().setFilter(qFilter);
                    }
                } else {
                    showParameter.getListFilterParameter().setFilter(null);
                }
            }
        });
    }

    private void fillFundflowItem(boolean isCover, DynamicObject defaultFundsItem, int rowIndex) {
        if (defaultFundsItem == null) {
            return;
        }
        if (isCover) {
            this.setValue("e_fundflowitem", defaultFundsItem.getPkValue(), rowIndex);
        } else {
            this.setValueIfAbsent("e_fundflowitem", defaultFundsItem.getPkValue(), rowIndex);
        }
    }

    private void payeeF7Changed(PropertyChangedArgs e, Object newValue, int rowIndex) {
        DynamicObject org = (DynamicObject)newValue;
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)orgId);
        if (defaultRecAccount != null && (BaseDataHelper.isSettleTypeVirtual((DynamicObject)this.getDynamicObject("settletype")) && VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultRecAccount).booleanValue() || !BaseDataHelper.isSettleTypeVirtual((DynamicObject)this.getDynamicObject("settletype")) && !VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultRecAccount).booleanValue())) {
            this.setValue("accountbank", defaultRecAccount, rowIndex);
        }
        DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
        this.setValue("basecurrency", baseCurrency, rowIndex);
    }

    protected String getControlBankAcctForSettleType() {
        return null;
    }

    protected boolean isBotpCreate(int rowIndex) {
        String sourceBillType = this.getString("sourcebilltype");
        return !CasHelper.isEmpty((Object)sourceBillType);
    }

    private void accountCashChanged(int rowIndex) {
        DynamicObject accountCash = this.getDynamicObject("accountcash", rowIndex);
        if (accountCash == null) {
            if (!this.isBotpCreate(rowIndex)) {
                this.setValue("currency", this.getDynamicObject("basecurrency"), rowIndex);
            }
            return;
        }
        DynamicObject currency = this.getDynamicObject("currency", rowIndex);
        boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"cas_accountcash", (Object)accountCash.getPkValue(), (DynamicObject)currency);
        if (!containCurrency) {
            DynamicObject defaultCurrency = accountCash.getDynamicObject("defaultcurrency");
            if (this.isBotpCreate(rowIndex)) {
                this.setValueIfAbsent("currency", defaultCurrency, rowIndex);
            } else {
                this.setValue("currency", defaultCurrency, rowIndex);
            }
        }
        this.setCurrencyEditable(rowIndex);
        this.setValue("openorg", accountCash.getDynamicObject("openorg"), rowIndex);
        this.setValue("openorgname", accountCash.getDynamicObject("openorg").getString("name"), rowIndex);
    }

    private void updateCoreBill(boolean isClearAll, int rowIndex) {
        boolean isErBill = "er_repaymentbill".equals((String)this.getValue("e_corebilltype", rowIndex));
        if (isClearAll && isErBill) {
            this.getModel().beginInit();
            this.getModel().setValue("e_corebillno", null, rowIndex);
            this.getModel().setValue("e_corebillid", null, rowIndex);
            this.getModel().setValue("e_sourcebillentryid", null, rowIndex);
            this.getModel().setValue("e_sourcebillid", null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("e_corebillno", rowIndex);
            this.getView().updateView("e_corebillid", rowIndex);
            this.getView().updateView("e_sourcebillentryid", rowIndex);
            this.getView().updateView("e_sourcebillid", rowIndex);
        }
    }

    private void payerTypeChanged(PropertyChangedArgs e, Object newValue, boolean isChanged, int rowIndex) {
        Object value = null;
        this.setValue("payerformid", value, rowIndex);
        this.setValue("payer", value, rowIndex);
        this.setValue("payername", value, rowIndex);
        this.setValue("payeraccformid", value, rowIndex);
        this.setValue("payeracctbank", value, rowIndex);
        this.setValue("payeracctbanknum", value, rowIndex);
        this.setValue("f7_payerbank", value, rowIndex);
        this.setValue("payerbankname", value, rowIndex);
    }

    private void calculateAmt(int rowIndex) {
        DynamicObject org = this.getDynamicObject("org", rowIndex);
        if (org != null) {
            int cs = SystemParameterHelper.getParameterInteger((long)org.getLong("id"), (String)"cs117");
            if (RecAmtTypeEnum.RECEIVABLEAMT.getValue().equals(String.valueOf(cs))) {
                this.calculateAmtByRecamt(rowIndex);
            } else {
                this.calculateAmtByActamt(rowIndex);
            }
        }
    }

    private void calculateAmtByRecamt(int rowIndex) {
        int round;
        DynamicObject currency = this.getDynamicObject("currency", rowIndex);
        if (currency == null) {
            return;
        }
        BigDecimal exchangeRate = null != this.getBigDecimal("exchangerate", rowIndex) ? this.getBigDecimal("exchangerate", rowIndex) : BigDecimal.ONE;
        String quotation = null != this.getString("quotation", rowIndex) ? this.getString("quotation", rowIndex) : this.quoteType(rowIndex);
        DynamicObject basecurrency = this.getDynamicObject("basecurrency", rowIndex);
        round = basecurrency != null ? (round = basecurrency.getInt("amtprecision")) : 10;
        this.getModel().beginInit();
        BigDecimal eRecAmt = null != this.getBigDecimal("e_receivableamt", rowIndex) ? this.getBigDecimal("e_receivableamt", rowIndex) : BigDecimal.ZERO;
        BigDecimal eDiscountamt = null != this.getBigDecimal("e_discountamt", rowIndex) ? this.getBigDecimal("e_discountamt", rowIndex) : BigDecimal.ZERO;
        BigDecimal eFee = null != this.getBigDecimal("e_fee", rowIndex) ? this.getBigDecimal("e_fee", rowIndex) : BigDecimal.ZERO;
        BigDecimal eRecLocalAmt = QuotationHelper.callToCurrency((BigDecimal)eRecAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
        this.setValue("e_receivablelocamt", eRecLocalAmt, rowIndex);
        this.setValue("e_discountlocamt", QuotationHelper.callToCurrency((BigDecimal)eDiscountamt, (BigDecimal)exchangeRate, (String)quotation, (int)round), rowIndex);
        BigDecimal eActAmt = eRecAmt.subtract(eDiscountamt).subtract(eFee);
        this.setValue("e_actamt", eActAmt, rowIndex);
        BigDecimal eLocalAmt = QuotationHelper.callToCurrency((BigDecimal)eActAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
        this.setValue("e_localamt", eLocalAmt, rowIndex);
        this.setValue("e_unsettledamt", eRecAmt, rowIndex);
        this.setValue("e_unsettledlocalamt", QuotationHelper.callToCurrency((BigDecimal)eRecAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round), rowIndex);
        this.setValue("e_unlockamt", eRecAmt, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("e_receivablelocamt", rowIndex);
        this.getView().updateView("e_discountlocamt", rowIndex);
        this.getView().updateView("e_fee", rowIndex);
        this.getView().updateView("e_actamt", rowIndex);
        this.getView().updateView("e_localamt", rowIndex);
        this.getView().updateView("e_unsettledamt", rowIndex);
        this.getView().updateView("e_unsettledlocalamt", rowIndex);
        this.getView().updateView("e_unlockamt", rowIndex);
        this.setValue("actrecamt", eActAmt, rowIndex);
        this.setValue("fee", eFee, rowIndex);
        this.setValue("localamt", eLocalAmt, rowIndex);
    }

    private void calculateAmtByActamt(int rowIndex) {
        DynamicObject currency = this.getDynamicObject("currency", rowIndex);
        if (currency == null) {
            return;
        }
        BigDecimal exchangeRate = null != this.getBigDecimal("exchangerate", rowIndex) ? this.getBigDecimal("exchangerate", rowIndex) : BigDecimal.ONE;
        String quotation = null != this.getString("quotation", rowIndex) ? this.getString("quotation", rowIndex) : this.quoteType(rowIndex);
        DynamicObject basecurrency = this.getDynamicObject("basecurrency", rowIndex);
        int round = null != basecurrency ? basecurrency.getInt("amtprecision") : 10;
        this.getModel().beginInit();
        BigDecimal eActamt = this.getBigDecimal("e_actamt", rowIndex);
        BigDecimal eLocalAmt = QuotationHelper.callToCurrency((BigDecimal)eActamt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
        this.setValue("e_localamt", eLocalAmt, rowIndex);
        BigDecimal eDiscountamt = this.getBigDecimal("e_discountamt", rowIndex);
        BigDecimal eDiscountLocalAmt = QuotationHelper.callToCurrency((BigDecimal)eDiscountamt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
        this.setValue("e_discountlocamt", eDiscountLocalAmt, rowIndex);
        this.setValue("e_unsettledamt", eActamt, rowIndex);
        this.setValue("e_unlockamt", eActamt, rowIndex);
        BigDecimal eFee = null != this.getBigDecimal("e_fee", rowIndex) ? this.getBigDecimal("e_fee", rowIndex) : BigDecimal.ZERO;
        BigDecimal eRecAmt = eActamt.add(eDiscountamt).add(eFee);
        this.setValue("e_receivableamt", eRecAmt, rowIndex);
        this.setValue("e_receivablelocamt", QuotationHelper.callToCurrency((BigDecimal)eRecAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round), rowIndex);
        this.setValue("e_unsettledamt", eRecAmt, rowIndex);
        this.setValue("e_unsettledlocalamt", QuotationHelper.callToCurrency((BigDecimal)eRecAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round), rowIndex);
        this.setValue("e_unlockamt", eRecAmt, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("e_receivablelocamt", rowIndex);
        this.getView().updateView("e_discountlocamt", rowIndex);
        this.getView().updateView("e_fee", rowIndex);
        this.getView().updateView("e_actamt", rowIndex);
        this.getView().updateView("e_localamt", rowIndex);
        this.getView().updateView("e_unsettledamt", rowIndex);
        this.getView().updateView("e_unsettledlocalamt", rowIndex);
        this.getView().updateView("e_unlockamt", rowIndex);
        this.setValue("actrecamt", eActamt, rowIndex);
        this.setValue("fee", eFee, rowIndex);
        this.setValue("localamt", eLocalAmt, rowIndex);
    }

    private void changeCurrencyOrActPayAmt(int rowIndex) {
        DynamicObject paymentType = this.getDynamicObject("receivingtype", rowIndex);
        if (CasHelper.isEmpty((Object)paymentType)) {
            return;
        }
        String bizType = paymentType.getString("biztype");
        if (PayAndRecBizTypeEnum.FUNDS_DOWN.getValue().equals(bizType) || PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(bizType)) {
            DynamicObject currency = this.getDynamicObject("currency", rowIndex);
            this.setValue("inneraccountcurrency", currency == null ? "" : currency.get("name"));
            BigDecimal actPayAmt = new BigDecimal(this.getModel().getValue("actrecamt").toString());
            this.setValue("inneraccountamount", actPayAmt.toPlainString());
        }
    }

    private void calculateFee(int rowIndex) {
        DynamicObject org = this.getDynamicObject("org", rowIndex);
        if (org != null) {
            int cs = SystemParameterHelper.getParameterInteger((long)org.getLong("id"), (String)"cs117");
            if (RecAmtTypeEnum.RECEIVABLEAMT.getValue().equals(String.valueOf(cs))) {
                this.calculateFeeByRec(rowIndex);
            } else {
                this.calculateFeeAct(rowIndex);
            }
        }
    }

    private void calculateFeeByRec(int rowIndex) {
        DynamicObject currency = this.getDynamicObject("currency", rowIndex);
        if (currency == null) {
            return;
        }
        BigDecimal exchangeRate = null != this.getBigDecimal("exchangerate", rowIndex) ? this.getBigDecimal("exchangerate", rowIndex) : BigDecimal.ONE;
        String quotation = null != this.getString("quotation", rowIndex) ? this.getString("quotation", rowIndex) : this.quoteType(rowIndex);
        DynamicObject basecurrency = this.getDynamicObject("basecurrency", rowIndex);
        int round = null != basecurrency ? basecurrency.getInt("amtprecision") : 10;
        this.getModel().beginInit();
        BigDecimal eRecAmt = this.getBigDecimal("e_receivableamt", rowIndex);
        BigDecimal eDiscountAmt = this.getBigDecimal("e_discountamt", rowIndex);
        BigDecimal eFee = this.getBigDecimal("e_fee", rowIndex);
        BigDecimal eActAmt = eRecAmt.subtract(eDiscountAmt).subtract(eFee);
        BigDecimal eLocalAmt = QuotationHelper.callToCurrency((BigDecimal)eActAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
        this.setValue("e_actamt", eActAmt, rowIndex);
        this.setValue("e_localamt", eLocalAmt, rowIndex);
        this.getView().updateView("e_actamt", rowIndex);
        this.getView().updateView("e_localamt", rowIndex);
        this.setValue("actrecamt", eActAmt);
        this.setValue("localamt", eLocalAmt);
        this.setValue("fee", eFee);
        this.getModel().endInit();
        this.getView().updateView("fee", rowIndex);
        this.getView().updateView("actrecamt", rowIndex);
        this.getView().updateView("localamt", rowIndex);
    }

    private void calculateFeeAct(int rowIndex) {
        DynamicObject currency = this.getDynamicObject("currency", rowIndex);
        if (currency == null) {
            return;
        }
        BigDecimal exchangeRate = null != this.getBigDecimal("exchangerate", rowIndex) ? this.getBigDecimal("exchangerate", rowIndex) : BigDecimal.ONE;
        String quotation = null != this.getString("quotation", rowIndex) ? this.getString("quotation", rowIndex) : this.quoteType(rowIndex);
        DynamicObject basecurrency = this.getDynamicObject("basecurrency", rowIndex);
        int round = null != basecurrency ? basecurrency.getInt("amtprecision") : 10;
        this.getModel().beginInit();
        BigDecimal eActAmt = this.getBigDecimal("e_actamt", rowIndex);
        BigDecimal eDiscountAmt = this.getBigDecimal("e_discountamt", rowIndex);
        BigDecimal eFee = this.getBigDecimal("e_fee", rowIndex);
        BigDecimal eRecAmt = eActAmt.add(eDiscountAmt).add(eFee);
        BigDecimal eRecLocalAmt = QuotationHelper.callToCurrency((BigDecimal)eRecAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
        this.setValue("e_receivableamt", eRecAmt, rowIndex);
        this.setValue("e_receivablelocamt", eRecLocalAmt, rowIndex);
        this.setValue("e_unsettledamt", eRecAmt, rowIndex);
        this.setValue("e_unlockamt", eRecAmt, rowIndex);
        this.getView().updateView("e_unsettledamt", rowIndex);
        this.getView().updateView("e_unlockamt", rowIndex);
        this.getView().updateView("e_receivableamt", rowIndex);
        this.getView().updateView("e_receivablelocamt", rowIndex);
        this.setValue("fee", eFee, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("fee", rowIndex);
    }

    private String quoteType(int rowIndex) {
        Map exchangeRateByRules;
        DynamicObject currency = this.getDynamicObject("currency", rowIndex);
        DynamicObject baseCurrency = this.getDynamicObject("basecurrency", rowIndex);
        DynamicObject exRateTable = this.getDynamicObject("exratetable", rowIndex);
        Date exRateDate = (Date)this.getValue("exratedate", rowIndex);
        String quoteType = "0";
        if (currency != null && baseCurrency != null && exRateTable != null && exRateDate != null && (exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency.getLong("id"), (Long)baseCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exRateDate)).get("quoteType") != null && ((Boolean)exchangeRateByRules.get("quoteType")).booleanValue()) {
            quoteType = "1";
        }
        return quoteType;
    }

    public Boolean getLastRow(int row) {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRY);
        if (row < entryRowCount - 1) {
            return false;
        }
        return true;
    }

    private void recTypeChanged(Object oldValue, Object newValue, int rowIndex) {
        DynamicObject newobject = (DynamicObject)newValue;
        DynamicObject oldobject = (DynamicObject)oldValue;
        if (newobject != null && oldobject != null && newobject.getBoolean("ispartreceivable") != oldobject.getBoolean("ispartreceivable")) {
            this.setValue("actrecamt", BigDecimal.ZERO, rowIndex);
            this.setValue("localamt", BigDecimal.ZERO, rowIndex);
            this.calculateAmt(rowIndex);
        }
        if (newobject != null) {
            this.fillFundflowItem(true, newobject.getDynamicObject("fundflowitem"), rowIndex);
        }
    }

    private void setEntryAmountCaption(int rowIndex) {
        DynamicObject recType = this.getDynamicObject("receivingtype", rowIndex);
        if (recType == null) {
            return;
        }
        boolean isAr = recType.getBoolean("ispartreceivable");
        if (isAr) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_receivableamt", "e_receivablelocamt"});
        }
    }

    private void setEcorebilltype(int rowIndex) {
        DynamicObject recType = this.getDynamicObject("receivingtype", rowIndex);
        if (recType == null) {
            this.setByIspartreceivable();
            return;
        }
        boolean isAr = recType.getBoolean("ispartreceivable");
        this.setByIspartreceivable(isAr);
    }

    private void settleTypeChanged(DynamicObject settleType, int rowIndex) {
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            this.getModel().beginInit();
            this.setValue("accountbank", null, rowIndex);
            this.setValue("payeebank", null, rowIndex);
            this.getModel().endInit();
            this.setValue("accountcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payee"), rowIndex);
        } else {
            this.setValue("accountcash", null, rowIndex);
        }
        this.setPayeeInfo(rowIndex);
    }

    private void isClearSettleType(DynamicObject oldValue, DynamicObject newValue, int rowIndex) {
        String settletnumber = (String)this.getValue("settletnumber", rowIndex);
        if (oldValue == null || newValue == null || EmptyUtil.isEmpty((String)settletnumber)) {
            return;
        }
        boolean oldIsCredit = SettleMentTypeEnum.CREDIT.getValue().equals(oldValue.getString("settlementtype"));
        boolean newIsCredit = SettleMentTypeEnum.CREDIT.getValue().equals(newValue.getString("settlementtype"));
        if (EmptyUtil.isNotEmpty((String)settletnumber) && oldIsCredit && !newIsCredit) {
            this.getModel().setValue("settletnumber", null, rowIndex);
            this.getModel().setValue("sourcebilltype", null, rowIndex);
            this.getModel().setValue("sourcebillid", null, rowIndex);
        }
    }

    private void setByIspartreceivable() {
        ArrayList<ComboItem> coreComboItem = new ArrayList<ComboItem>();
        ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_recbill").getProperty("settlecorebilltype");
        ComboProp propertyUn = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_recbill").getProperty("unsettlecorebilltype");
        this.getCoreComboItem(coreComboItem, property);
        this.getCoreComboItem(coreComboItem, propertyUn);
        ComboEdit coreCbo = (ComboEdit)this.getView().getControl("e_corebilltype");
        coreCbo.setComboItems(coreComboItem);
    }

    private void setByIspartreceivable(boolean isPart) {
        ArrayList<ComboItem> coreComboItem = new ArrayList<ComboItem>();
        ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_recbill").getProperty(isPart ? "settlecorebilltype" : "unsettlecorebilltype");
        this.getCoreComboItem(coreComboItem, property);
        ComboEdit coreCbo = (ComboEdit)this.getView().getControl("e_corebilltype");
        coreCbo.setComboItems(coreComboItem);
    }

    private void getCoreComboItem(List<ComboItem> coreComboItem, ComboProp property) {
        List comboItems;
        if (EmptyUtil.isNoEmpty((Object)property) && EmptyUtil.isNoEmpty((Object)(comboItems = property.getComboItems()))) {
            ComboItem comboItem = null;
            for (ValueMapItem valueMapItem : comboItems) {
                if ("cas_paybill".equals(valueMapItem.getValue())) continue;
                comboItem = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
                coreComboItem.add(comboItem);
            }
        }
    }

    private boolean isEquals(int rowIndex) {
        DynamicObjectCollection coll = (DynamicObjectCollection)this.getValue("draftbill", rowIndex);
        String settleNumber = (String)this.getValue("settletnumber", rowIndex);
        if (coll.size() == 0 || kd.bos.util.StringUtils.isEmpty((String)settleNumber)) {
            return false;
        }
        Object[] draftNoList = (String[])coll.stream().map(o -> o.getDynamicObject("fbasedataid").getString("draftbillno")).toArray(String[]::new);
        Object[] draftNoList2 = settleNumber.replaceAll(" ", "").split(";");
        return Arrays.equals(draftNoList, draftNoList2);
    }

    private List<String> getDraftNoList(DynamicObjectCollection coll) {
        List<String> draftNoList = new ArrayList<String>(coll.size());
        if (coll.size() == 0) {
            return draftNoList;
        }
        draftNoList = coll.stream().map(o -> o.getDynamicObject("fbasedataid").getString("draftbillno")).collect(Collectors.toList());
        return draftNoList;
    }

    private void checkAndSave() {
        DynamicObjectCollection dataRows = this.getModel().getEntryEntity(ENTRY);
        if (CasHelper.isEmpty((Object)dataRows)) {
            return;
        }
        int size = dataRows.size();
        DynamicObject[] targetBills = new DynamicObject[size];
        for (int i = 0; i < size; ++i) {
            targetBills[i] = this.convertTargetBill((DynamicObject)dataRows.get(i));
        }
        OperationResult operationResult = OperateServiceHelper.execOperate((String)"save", (String)"cas_recbill", (DynamicObject[])targetBills, (OperateOption)OperateOption.create(), (boolean)true);
        if (!operationResult.isSuccess()) {
            logger.error((Throwable)((Object)operationResult.getAllErrorOrValidateInfo()));
        } else {
            int okCount = operationResult.getSuccessPkIds().size();
            String msg = String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5f55\u5165%s\u6761\u6536\u6b3e\u5904\u7406\u5355", (String)"RecBillBatch_01", (String)"fi-cas-formplugin", (Object[])new Object[0]), okCount);
            this.getView().showSuccessNotification(msg, Integer.valueOf(3000));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok", "newentry", "copyentry", "deleteentry"});
        }
    }

    private void checkChangeData(Object newValue, int rowIndex) {
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            String coreBillType = (String)this.getValue("e_corebilltype", rowIndex);
            if (kd.fi.cas.util.StringUtils.isNotEmpty((String)coreBillType)) {
                String corebillno = (String)newValue;
                if (CORE_BILLTYPES.contains(coreBillType)) {
                    DynamicObject settleorg = this.getDynamicObject("e_settleorg", rowIndex);
                    if (EmptyUtil.isEmpty((DynamicObject)settleorg)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ed3\u7b97\u7ec4\u7ec7", (String)"ClaimHandleEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    QFilter billNoFilter = new QFilter("billno", "=", (Object)corebillno);
                    List<QFilter> coreBillFilters = this.getCoreBillFilter(coreBillType, settleorg, rowIndex);
                    coreBillFilters.add(billNoFilter);
                    Object[] coreBillColl = BusinessDataServiceHelper.load((String)coreBillType, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)corebillno)});
                    Object isSelectCoreBillNo = this.getView().getFormShowParameter().getCustomParam("isSelectCoreBillNo");
                    if (EmptyUtil.isNoEmpty((Object[])coreBillColl) && !coreBillType.equals("er_repaymentbill")) {
                        if (ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType) || ClaimCoreBillTypeEnum.SALCONTRACT.getValue().equals(coreBillType)) {
                            if (!"true".equals(isSelectCoreBillNo)) {
                                boolean isSalOrder = ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType);
                                List<String> conGroupFields = isSalOrder ? Arrays.asList("billentry.conbillnumber", "billentry.conbillrownum", "billentry.conbillid", "billentry.conbillentryid") : Arrays.asList("id", "billno", "billentry.lineno", "billentry.id");
                                QFilter filter = new QFilter("id", "=", (Object)coreBillColl[0].getLong("id"));
                                DynamicObject queryInfo = QueryServiceHelper.queryOne((String)coreBillType, (String)String.join((CharSequence)",", conGroupFields), (QFilter[])new QFilter[]{filter});
                                if (queryInfo != null) {
                                    this.getModel().setValue("conbillnumber", (Object)(isSalOrder ? queryInfo.getString("billentry.conbillnumber") : queryInfo.getString("billno")), rowIndex);
                                }
                                this.getModel().setValue("conbillentity", (Object)"conm_salcontract", rowIndex);
                                this.getModel().setValue("conbillrownum", (Object)"", rowIndex);
                            }
                        } else {
                            this.getModel().setValue("e_corebillid", (Object)coreBillColl[0].getLong("id"), rowIndex);
                        }
                    } else if (!"true".equals(isSelectCoreBillNo)) {
                        this.getModel().beginInit();
                        this.getModel().setValue("e_corebillno", null, rowIndex);
                        this.getModel().setValue("e_corebillid", null, rowIndex);
                        this.getModel().setValue("e_sourcebillentryid", null, rowIndex);
                        this.getModel().setValue("e_sourcebillid", null, rowIndex);
                        this.getModel().endInit();
                        String message = ResManager.loadKDString((String)"\u5bf9\u5e94\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\u6b64\u6838\u5fc3\u5355\u636e\u53f7\u3002", (String)"ReceivingBillEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                        if (coreBillType.equals("er_repaymentbill")) {
                            message = ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a\u8fd8\u6b3e\u5355\u3002\u6838\u5fc3\u5355\u636e\u7f16\u53f7\u4e0d\u5141\u8bb8\u624b\u5de5\u4fee\u6539\u3002", (String)"ReceivingBillCoreBillEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                        }
                        this.getView().showTipNotification(message);
                        return;
                    }
                }
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("e_corebillno", null, rowIndex);
                this.getModel().endInit();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"ReceivingBillEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private List<QFilter> getCoreBillFilter(String coreBillType, DynamicObject settleorg, int rowIndex) {
        Object payer;
        ArrayList<QFilter> list = new ArrayList<QFilter>(8);
        if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.FINARBILL.getValue())) {
            list.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            list.add(new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"}));
        }
        if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.SALORDER.getValue())) {
            list.add(new QFilter("billentry.entrysettleorg", "=", settleorg.getPkValue()));
            payer = this.getModel().getValue("payer", rowIndex);
            list.add(new QFilter("customer", "=", !ObjectUtils.isEmpty((Object)payer) ? payer : Long.valueOf(0L)));
            list.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            list.add(new QFilter("changestatus", "<>", (Object)"B"));
            list.add(QFilter.of((String)" receiptamount < totalallamount ", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.SALCONTRACT.getValue())) {
            list.add(new QFilter("billentry.entrysettleorg", "=", settleorg.getPkValue()));
            payer = this.getModel().getValue("payer", rowIndex);
            list.add(new QFilter("customer", "=", !ObjectUtils.isEmpty((Object)payer) ? payer : Long.valueOf(0L)));
            list.add(new QFilter("validstatus", "<>", (Object)"A"));
            list.add(new QFilter("changestatus", "<>", (Object)"B"));
            list.add(QFilter.of((String)" receiptallamount < totalallamount ", (Object[])new Object[0]));
        }
        return list;
    }

    private DynamicObject convertTargetBill(DynamicObject row) {
        DataEntityPropertyCollection properties = row.getDataEntityType().getProperties();
        DynamicObject bill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"));
        bill.set("billstatus", row.get("billstatus"));
        bill.set("bizdate", row.get("bizdate"));
        bill.set("receivingtype", row.get("receivingtype"));
        bill.set("isvirtual", row.get("isvirtual"));
        bill.set("payertype", row.get("payertype"));
        bill.set("txt_description", row.get("txt_description"));
        bill.set("org", row.get("org"));
        bill.set("openorg", row.get("openorg"));
        bill.set("accountbank", row.get("accountbank"));
        bill.set("accountcash", row.get("accountcash"));
        bill.set("payeebank", row.get("payeebank"));
        bill.set("payername", row.get("payername"));
        bill.set("payer", row.get("payer"));
        bill.set("payeracctbanknum", row.get("payeracctbanknum"));
        bill.set("payeracctbank", row.get("payeracctbank"));
        bill.set("payerbankname", row.get("payerbankname"));
        bill.set("f7_payerbank", row.get("f7_payerbank"));
        bill.set("biztype", row.get("biztype"));
        bill.set("actrecamt", row.get("actrecamt"));
        bill.set("fee", row.get("fee"));
        bill.set("settletype", row.get("settletype"));
        bill.set("currency", row.get("currency"));
        bill.set("settletnumber", row.get("settletnumber"));
        bill.set("draftbill", row.get("draftbill"));
        bill.set("exratetable", row.get("exratetable"));
        bill.set("exratedate", row.get("exratedate"));
        bill.set("exchangerate", row.get("exchangerate"));
        bill.set("quotation", row.get("quotation"));
        bill.set("payernumber", row.get("payernumber"));
        bill.set("f7_payer", row.get("f7_payer"));
        bill.set("customerf7", row.get("customerf7"));
        bill.set("f7_payeracctbank", row.get("f7_payeracctbank"));
        bill.set("userf7", row.get("userf7"));
        bill.set("payee_company", row.get("payee_company"));
        bill.set("localamt", row.get("localamt"));
        bill.set("basecurrency", row.get("basecurrency"));
        bill.set("payerformid", row.get("payerformid"));
        bill.set("payeraccformid", row.get("payeraccformid"));
        bill.set("unsettleamount", row.get("unsettleamount"));
        bill.set("unsettleamountbase", row.get("unsettleamountbase"));
        bill.set("settleamount", row.get("settleamount"));
        bill.set("settleamountbase", row.get("settleamountbase"));
        bill.set("settlestatus", row.get("settlestatus"));
        bill.set("sourcebilltype", row.get("sourcebilltype"));
        bill.set("sourcebillid", row.get("sourcebillid"));
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
        DynamicObject eDyObj = entry.addNew();
        eDyObj.set("e_settleorg", row.get("e_settleorg"));
        eDyObj.set("e_material", row.get("e_material"));
        eDyObj.set("e_receivableamt", row.get("e_receivableamt"));
        eDyObj.set("e_receivablelocamt", row.get("e_receivablelocamt"));
        eDyObj.set("e_discountamt", row.get("e_discountamt"));
        eDyObj.set("e_fee", row.get("e_fee"));
        eDyObj.set("e_actamt", row.get("e_actamt"));
        eDyObj.set("e_localamt", row.get("e_localamt"));
        eDyObj.set("project", row.get("project"));
        eDyObj.set("e_fundflowitem", row.get("e_fundflowitem"));
        eDyObj.set("costcenter", row.get("costcenter"));
        eDyObj.set("e_corebilltype", row.get("e_corebilltype"));
        eDyObj.set("contractnumber", row.get("contractnumber"));
        eDyObj.set("e_corebillno", row.get("e_corebillno"));
        eDyObj.set("conbillnumber", row.get("conbillnumber"));
        eDyObj.set("e_remark", row.get("e_remark"));
        eDyObj.set("e_discountlocamt", row.get("e_discountlocamt"));
        eDyObj.set("e_settledamt", row.get("e_settledamt"));
        eDyObj.set("e_settledlocalamt", row.get("e_settledlocalamt"));
        eDyObj.set("e_unsettledamt", row.get("e_unsettledamt"));
        eDyObj.set("e_unsettledlocalamt", row.get("e_unsettledlocalamt"));
        eDyObj.set("e_unlockamt", row.get("e_unlockamt"));
        eDyObj.set("e_lockamt", row.get("e_lockamt"));
        eDyObj.set("e_corebillentryseq", row.get("e_corebillentryseq"));
        eDyObj.set("e_corebillentryid", row.get("e_corebillentryid"));
        eDyObj.set("conbillentity", row.get("conbillentity"));
        eDyObj.set("conbillid", row.get("conbillid"));
        eDyObj.set("conbillentryid", row.get("conbillentryid"));
        eDyObj.set("conbillrownum", row.get("conbillrownum"));
        eDyObj.set("e_expenseitem", row.get("e_expenseitem"));
        eDyObj.set("productline", row.get("productline"));
        bill.set("entry", (Object)entry);
        DynamicObjectCollection draftbillColl = (DynamicObjectCollection)row.get("draftbill");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftbillColl)) {
            this.updateDraftInfo(bill, draftbillColl);
        }
        return bill;
    }

    private void updateDraftInfo(DynamicObject recBill, DynamicObjectCollection draftbillColl) {
        DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("cas_draftinfo");
        for (DynamicObject draftbill : draftbillColl) {
            DynamicObject entry = entrys.addNew();
            entry.set("draftbillinfo", (Object)draftbill.getDynamicObject("fbasedataid"));
            entry.set("transamount", (Object)draftbill.getDynamicObject("fbasedataid").getBigDecimal("amount"));
            entry.set("recbillcurrency", (Object)draftbill.getDynamicObject("fbasedataid").getDynamicObject("currency"));
            entry.set("srcbilltype", (Object)"cas_recbill");
            entry.set("srcbillindex", (Object)"1");
        }
    }
}

