/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.rec;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.fi.cas.enums.RecAmtTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class RecBillExchangeRateEdit
extends BillEditPlugin {
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.reExchangeRate();
        this.calculateAmt();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "basecurrency": {
                this.reExchangeRate();
            }
        }
    }

    private void reExchangeRate() {
        this.setExchangerateEditable();
    }

    private void calculateAmt() {
        IDataModel model = this.getModel();
        Object org = model.getValue("org");
        if (org != null) {
            int cs = SystemParameterHelper.getParameterInteger((long)((DynamicObject)org).getLong("id"), (String)"cs117");
            if (RecAmtTypeEnum.RECEIVABLEAMT.getValue().equals(String.valueOf(cs))) {
                this.calculateAmtByRecamt();
            } else {
                this.calculateAmtByActamt();
            }
        }
    }

    private void calculateAmtByRecamt() {
        IDataModel model = this.getModel();
        String quotation = this.getString("quotation");
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        BigDecimal fee = this.getBigDecimal("fee");
        DynamicObject currency = this.getDynamicObject("currency");
        if (currency == null) {
            return;
        }
        DynamicObject basecurrency = (DynamicObject)model.getValue("basecurrency");
        if (basecurrency == null) {
            return;
        }
        int count = model.getEntryRowCount("entry");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            BigDecimal receivableAmount = (BigDecimal)model.getValue("e_receivableamt", i);
            BigDecimal discountAmount = (BigDecimal)model.getValue("e_discountamt", i);
            BigDecimal subtract = receivableAmount.subtract(discountAmount);
            amount = amount.add(subtract);
        }
        BigDecimal countFee = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            BigDecimal discountAmt;
            BigDecimal recAmount = (BigDecimal)model.getValue("e_receivableamt", i);
            if (recAmount != null) {
                this.setValue("e_receivablelocamt", QuotationHelper.callToCurrency((BigDecimal)recAmount, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision")), i);
            }
            if ((discountAmt = (BigDecimal)model.getValue("e_discountamt", i)) != null) {
                this.setValue("e_discountlocamt", QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision")), i);
            }
            if (recAmount != null) {
                BigDecimal actAmt = recAmount.subtract(discountAmt);
                this.setValue("e_fee", BigDecimal.ZERO, i);
                if (amount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal efee = actAmt.multiply(fee).divide(amount, currency.getInt("amtprecision"), RoundingMode.DOWN);
                    if (this.getLastRow(i).booleanValue()) {
                        efee = fee.subtract(countFee);
                    }
                    countFee = countFee.add(efee);
                    this.setValue("e_fee", efee, i);
                    actAmt = actAmt.subtract(efee);
                }
                sumAmt = sumAmt.add(actAmt);
                BigDecimal actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision"));
                this.setValue("e_actamt", actAmt, i);
                this.setValue("e_localamt", actLocalAmt, i);
            }
            this.setValue("e_unsettledamt", recAmount, i);
            this.setValue("e_unlockamt", recAmount, i);
        }
        this.setValue("actrecamt", sumAmt);
        this.setValue("localamt", QuotationHelper.callToCurrency((BigDecimal)sumAmt, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision")));
    }

    private void calculateAmtByActamt() {
        DynamicObject currency;
        String quotation = this.getString("quotation");
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        BigDecimal fee = this.getBigDecimal("fee");
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ONE;
        }
        if (fee == null) {
            fee = BigDecimal.ZERO;
        }
        if ((currency = this.getDynamicObject("currency")) == null) {
            return;
        }
        DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (basecurrency == null) {
            return;
        }
        int count = this.getModel().getEntryRowCount("entry");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity("entry", i);
            BigDecimal actAndDisc = rowInfo.getBigDecimal("e_actamt").add(rowInfo.getBigDecimal("e_discountamt"));
            amount = amount.add(actAndDisc);
        }
        BigDecimal countFee = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            BigDecimal discountAmt;
            DynamicObject rowInfo = this.getModel().getEntryRowEntity("entry", i);
            BigDecimal actAmount = rowInfo.getBigDecimal("e_actamt");
            if (actAmount != null) {
                this.setValue("e_localamt", QuotationHelper.callToCurrency((BigDecimal)actAmount, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision")), i);
            }
            if ((discountAmt = rowInfo.getBigDecimal("e_discountamt")) != null) {
                this.setValue("e_discountlocamt", QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision")), i);
            }
            this.setValue("e_unsettledamt", actAmount, i);
            this.setValue("e_unlockamt", actAmount, i);
            if (actAmount != null) {
                BigDecimal actAmtAndDisc = actAmount.add(discountAmt);
                this.setValue("e_fee", BigDecimal.ZERO, i);
                if (amount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal efee = actAmtAndDisc.multiply(fee).divide(amount, currency.getInt("amtprecision"), RoundingMode.DOWN);
                    if (this.getLastRow(i).booleanValue()) {
                        efee = fee.subtract(countFee);
                    }
                    countFee = countFee.add(efee);
                    this.setValue("e_fee", efee, i);
                    actAmtAndDisc = actAmtAndDisc.add(efee);
                }
                BigDecimal actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision"));
                this.setValue("e_receivableamt", actAmtAndDisc, i);
                this.setValue("e_receivablelocamt", actLocalAmt, i);
                this.setValue("e_unsettledamt", actAmtAndDisc, i);
                this.setValue("e_unlockamt", actAmtAndDisc, i);
            }
            if (actAmount == null) continue;
            sumAmt = sumAmt.add(actAmount);
        }
        this.setValue("actrecamt", sumAmt);
        this.setValue("localamt", QuotationHelper.callToCurrency((BigDecimal)sumAmt, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision")));
    }

    protected void setExchangerateEditable() {
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"exchangerate"});
        }
    }

    protected boolean isBotpCreate() {
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        return !CasHelper.isEmpty((Object)sourceBillType);
    }

    public Boolean getLastRow(int row) {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        if (row < entryRowCount - 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

