/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.rec;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.RecDraftHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecBillSelectDraftEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initDraftBillF7();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirmop".equals(operateKey) && !this.draftValidate()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("confirmop".equals(operateKey) && e.getOperationResult().isSuccess()) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object recBillId = customParams.get("recBillId");
            DynamicObjectCollection draftBillColl = (DynamicObjectCollection)this.getModel().getValue("draftbill");
            List draftBillIdList = draftBillColl.stream().map(i -> i.get("fbasedataid.id")).collect(Collectors.toList());
            HashMap returnData = new HashMap();
            returnData.put("recBillId", recBillId);
            returnData.put("draftBillIdList", draftBillIdList);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private boolean draftValidate() {
        DynamicObjectCollection draftBillColl;
        List draftBillIdList;
        DynamicObject[] draftDataArr;
        BigDecimal billAmount;
        BigDecimal recAmount = (BigDecimal)this.getModel().getValue("casrecamounttotal");
        if (recAmount.compareTo(billAmount = Arrays.stream(draftDataArr = BusinessDataServiceHelper.load((Object[])(draftBillIdList = (draftBillColl = (DynamicObjectCollection)this.getModel().getValue("draftbill")).stream().map(i -> i.get("fbasedataid.id")).collect(Collectors.toList())).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payandrecdraft_f7"))).map(i -> i.getBigDecimal("availableamount")).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u7684\u7968\u9762\u91d1\u989d\u5408\u8ba1\u91d1\u989d\u5fc5\u987b\u4e0e\u6536\u6b3e\u5904\u7406\u5408\u8ba1\u91d1\u989d\u76f8\u7b49\u3002", (String)"RecBillSelectDraftEdit_0_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject dt : draftDataArr) {
            boolean isendorsepay = dt.getBoolean("isendorsepay");
            if (!isendorsepay) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7968\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c", (String)"RecBillSelectDraftEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void initDraftBillF7() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ArrayList<Long> recBillIdList = new ArrayList<Long>(16);
        Object recBillId = formShowParameter.getCustomParam("recBillId");
        if (recBillId != null) {
            if (recBillId instanceof JSONArray) {
                JSONArray payBillIdJsonArr = (JSONArray)recBillId;
                if (null != payBillIdJsonArr) {
                    for (Object ob : payBillIdJsonArr) {
                        recBillIdList.add(Long.parseLong(ob.toString()));
                    }
                }
            } else {
                recBillIdList.add(Long.parseLong(recBillId.toString()));
            }
        }
        ArrayList<Long> selectedDraftIds = new ArrayList<Long>();
        Object draftBillColl = this.getModel().getValue("draftbill");
        if (null != draftBillColl) {
            DynamicObjectCollection colls = (DynamicObjectCollection)draftBillColl;
            for (DynamicObject coll : colls) {
                selectedDraftIds.add(((DynamicObject)coll.get("fbasedataid")).getLong("id"));
            }
        }
        BasedataEdit draftBillEdit = (BasedataEdit)this.getControl("draftbill");
        draftBillEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int recBillIdCount = recBillIdList.size();
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = RecDraftHelper.getDraftFilter(recBillIdList.get(0), (List)selectedDraftIds, null);
            BigDecimal recAmount = (BigDecimal)this.getModel().getValue("casrecamounttotal");
            if (EmptyUtil.isNoEmpty((BigDecimal)recAmount) && BigDecimal.ZERO.compareTo(recAmount) < 0) {
                qFilter.and(new QFilter("availableamount", "<=", (Object)recAmount));
            }
            showParameter.setCustomParam("source", (Object)"rec");
            showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            boolean isSingleRec = recBillIdCount <= 1;
            showParameter.setMultiSelect(isSingleRec);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "draftbill": {
                Object draftBillColl = this.getModel().getValue("draftbill");
                if (null != draftBillColl) {
                    DynamicObjectCollection colls = (DynamicObjectCollection)draftBillColl;
                    Set draftBillIdSet = colls.stream().filter(e1 -> null != e1.getDynamicObject("fbasedataid")).map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    DynamicObjectCollection draftColl = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIdSet)});
                    BigDecimal draftAmountTotal = draftColl.stream().map(o -> o.getBigDecimal("availableamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    this.getModel().setValue("totalamount", (Object)draftAmountTotal);
                    break;
                }
                this.getModel().setValue("totalamount", (Object)BigDecimal.ZERO);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashSet<Long> recBillIdSet = new HashSet<Long>(16);
        Object recBillId = formShowParameter.getCustomParam("recBillId");
        if (recBillId != null) {
            if (recBillId instanceof JSONArray) {
                JSONArray payBillIdJsonArr = (JSONArray)recBillId;
                if (null != payBillIdJsonArr) {
                    for (Object ob : payBillIdJsonArr) {
                        recBillIdSet.add(Long.parseLong(ob.toString()));
                    }
                }
            } else {
                recBillIdSet.add(Long.parseLong(recBillId.toString()));
            }
            if (recBillIdSet.size() > 0) {
                DynamicObjectCollection casRecBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,actrecamt", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillIdSet)});
                BigDecimal casTotalAmount = casRecBills.stream().map(e1 -> e1.getBigDecimal("actrecamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                this.getModel().setValue("casrecamounttotal", (Object)casTotalAmount);
            }
        }
        this.getModel().setValue("textfield1", (Object)ResManager.loadKDString((String)"\u6536\u6b3e\u5904\u7406\u5408\u8ba1\u91d1\u989d\uff1a", (String)"RecBillSelectDraftEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield11", (Object)ResManager.loadKDString((String)"\u7968\u9762\u5408\u8ba1\u91d1\u989d\uff1a", (String)"RecBillSelectDraftEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }
}

