/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.rec;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecBillSettleNumberEdit
extends BillEditPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit settleNumber = (TextEdit)this.getView().getControl("settletnumber");
        settleNumber.addButtonClickListener((ClickListener)this);
        BasedataEdit draftBill = (BasedataEdit)this.getControl("draftbill");
        draftBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSettleNumberVisible();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (fieldKey) {
            case "draftbill": {
                DynamicObjectCollection coll = (DynamicObjectCollection)newValue;
                if (coll.size() > 0) {
                    this.updateDraftInfo(coll);
                    List<String> draftNoList = this.getDraftNoList(coll);
                    if (draftNoList == null || draftNoList.size() == 0) {
                        return;
                    }
                    StringBuilder sb = new StringBuilder();
                    draftNoList.forEach(o -> sb.append((String)o).append(";"));
                    this.setValue("settletnumber", sb.substring(0, sb.length() - 1));
                    this.setValue("selectdraftflag", "addnew");
                    break;
                }
                this.setValue("settletnumber", null);
                this.setValue("selectdraftflag", " ");
                this.getModel().deleteEntryData("cas_draftinfo");
                break;
            }
            case "settletype": {
                String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
                if (!"lc_present".equals(sourceBillType) && !"lc_forfaiting".equals(sourceBillType)) {
                    this.setValue("draftbill", null);
                    this.setValue("settletnumber", null);
                }
                this.initSettleNumberVisible();
            }
        }
    }

    private void initSettleNumberVisible() {
        boolean visible = false;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject settleType = this.getDynamicObject("settletype");
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
            String settleTypeBizType = settleType.getString("settlementtype");
            if (SettleMentTypeEnum.PROMISSORY.getValue().equals(settleTypeBizType) || SettleMentTypeEnum.BUSINESS.getValue().equals(settleTypeBizType) || SettleMentTypeEnum.BANK.getValue().equals(settleTypeBizType) || SettleMentTypeEnum.CHECK.getValue().equals(settleTypeBizType)) {
                String paramValue = this.getTypeParam(settleTypeBizType);
                visible = SystemParameterHelper.getCdmParameterBoolean((long)org.getLong("id"), (String)paramValue);
            }
        }
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"settletnumber"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"draftbill"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        DynamicObject settleType;
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("settletnumber".equals(key) && ObjectUtils.isEmpty((Object)(settleType = this.getDynamicObject("settletype")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"RecBillSettleNumberEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            evt.setCancel(true);
        }
    }

    private String getTypeParam(String settleTypeBizType) {
        String paramValue = "";
        switch (settleTypeBizType) {
            case "5": 
            case "6": {
                paramValue = "isdraft";
                break;
            }
            case "1": {
                paramValue = "ischeck";
                break;
            }
            case "2": {
                paramValue = "ispromissorynote";
            }
        }
        return paramValue;
    }

    private void updateDraftInfo(DynamicObjectCollection draftBillColl) {
        QFilter[] filters;
        String entityName;
        boolean isExists;
        if (EmptyUtil.isEmpty((DynamicObjectCollection)draftBillColl) || draftBillColl.size() < 1) {
            this.getModel().deleteEntryData("cas_draftinfo");
            return;
        }
        this.getModel().deleteEntryData("cas_draftinfo");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("draftbillinfo", new Object[0]);
        vs.addField("recbillcurrency", new Object[0]);
        vs.addField("transamount", new Object[0]);
        vs.addField("draftbilllogid", new Object[0]);
        vs.addField("srcbilltype", new Object[0]);
        vs.addField("srcbillindex", new Object[0]);
        HashMap draftIdDealAmountMapDB = new HashMap(10);
        HashMap draftIdLogIdMapDB = new HashMap(10);
        String billNo = (String)this.getModel().getValue("billno");
        if (EmptyUtil.isNotEmpty((String)billNo) && (isExists = QueryServiceHelper.exists((String)(entityName = "cas_recbill"), (QFilter[])(filters = new QFilter[]{new QFilter("billno", "=", (Object)billNo)})))) {
            DynamicObject recBill = BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])filters);
            DynamicObjectCollection entrysDB = recBill.getDynamicObjectCollection("cas_draftinfo");
            draftIdDealAmountMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            draftIdLogIdMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
        }
        Map draftIdAndAvailaAmountMap = DraftHelper.getNewestAvailamountMap((DynamicObjectCollection)draftBillColl, (String)"settlenumber");
        for (DynamicObject entryInfo : draftBillColl) {
            long draftId = entryInfo.getDynamicObject("fbasedataid").getLong("id");
            BigDecimal savedTransamount = (BigDecimal)draftIdDealAmountMapDB.get(draftId);
            Long draftBillLogId = (Long)draftIdLogIdMapDB.get(entryInfo.getDynamicObject("fbasedataid").getLong("id"));
            BigDecimal displayTransamount = EmptyUtil.isEmpty((BigDecimal)savedTransamount) ? (BigDecimal)draftIdAndAvailaAmountMap.get(draftId) : savedTransamount;
            long displayLogId = EmptyUtil.isEmpty((Long)draftBillLogId) ? 0L : draftBillLogId;
            vs.addRow(new Object[]{draftId, entryInfo.getDynamicObject("fbasedataid").getDynamicObject("currency").getLong("id"), displayTransamount, displayLogId, "cas_recbill", 1});
        }
        model.batchCreateNewEntryRow("cas_draftinfo", vs);
        model.endInit();
        this.getView().updateView("cas_draftinfo");
    }

    private List<String> getDraftNoList(DynamicObjectCollection coll) {
        List<String> draftNoList = new ArrayList<String>(coll.size());
        if (coll.size() == 0) {
            return draftNoList;
        }
        draftNoList = coll.stream().map(o -> o.getDynamicObject("fbasedataid").getString("draftbillno")).collect(Collectors.toList());
        return draftNoList;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("draftbill".equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String payername = (String)this.getModel().getValue("payername");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter billHandleFilter = new QFilter(String.join((CharSequence)".", "company", "id"), "=", (Object)org.getLong("id"));
            billHandleFilter.and(new QFilter("delivername", "=", (Object)payername));
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            String noticeClaimAllowStatus = (String)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"noticeclaimallowstatus");
            List<String> allowStatusList = Arrays.asList(noticeClaimAllowStatus.split(","));
            ArrayList<String> draftBillStatusList = new ArrayList<String>();
            for (String allowStatus : allowStatusList) {
                if (EmptyUtil.isEmpty((String)allowStatus)) continue;
                draftBillStatusList.add(allowStatus);
            }
            billHandleFilter.and(new QFilter("draftbillstatus", "in", draftBillStatusList));
            billHandleFilter.and(new QFilter("source", "!=", (Object)"cas"));
            billHandleFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
            billHandleFilter.and(new QFilter("isendorsepay", "=", (Object)"0"));
            billHandleFilter.and(new QFilter("currency", "=", currency.getPkValue()));
            billHandleFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            billHandleFilter.and(new QFilter("availableamount", ">", (Object)0));
            DynamicObject settleType = this.getDynamicObject("settletype");
            String settleTypeBizType = settleType.getString("settlementtype");
            List billTypeIdList = DraftHelper.getBillTypeIdList((Object)settleType.getPkValue(), (String)settleTypeBizType);
            billHandleFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
            DynamicObject[] billHandleDataArr = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,claimnoticebillno,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,availableamount,amount", (QFilter[])new QFilter[]{billHandleFilter});
            List billIdList = Arrays.stream(billHandleDataArr).filter(i -> !RecBillHepler.existsRecBill((Long)i.getLong("id"))).filter(x -> EmptyUtil.isEmpty((String)x.getString("claimnoticebillno"))).filter(o -> o.getBigDecimal("availableamount").compareTo(o.getBigDecimal("amount")) == 0).map(i -> i.get("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", billIdList);
            Set cdm_receivablebill = DraftHelper.getReleatedRecPayBill((QFilter)qFilter, (String)"cdm_receivablebill");
            if (EmptyUtil.isNoEmpty((Object)cdm_receivablebill)) {
                qFilter.and(new QFilter("id", "not in", (Object)cdm_receivablebill));
            }
            ArrayList<Long> ids = new ArrayList<Long>(0);
            Object draftBillColl = this.getModel().getValue("draftbill");
            if (null != draftBillColl) {
                DynamicObjectCollection colls = (DynamicObjectCollection)draftBillColl;
                for (DynamicObject coll : colls) {
                    Object fbasedataid = coll.get("fbasedataid");
                    if (!EmptyUtil.isNoEmpty((Object)fbasedataid)) continue;
                    ids.add(((DynamicObject)fbasedataid).getLong("id"));
                }
            }
            if (ids.size() > 0) {
                qFilter.or(new QFilter("id", "in", ids));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("source", (Object)"rec");
        }
    }
}

