/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.helper.RecPayRuleHelper;
import kd.fi.cas.enums.ClaimAuthorityEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.helper.TmcAppCache;
import kd.fi.cas.util.EmptyUtil;

public class ClaimRecWorkbenchPlugin
extends AbstractListPlugin {
    private static IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");
    private static final String SYSTEMTYPE = "fi-cas-formplugin";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operateKey = evt.getItemKey();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object[] selectids = selectedRows.getPrimaryKeyValues();
        if (EmptyUtil.isEmpty((Object[])selectids)) {
            return;
        }
        switch (operateKey) {
            case "noticeclaim": {
                this.noticeClaim(selectids);
                break;
            }
            case "cancelnotice": {
                this.cancelNotice(selectids);
                break;
            }
        }
    }

    private void checkOpPerm(String operKey, String operKeyName, DynamicObject[] transdetails) {
        Long org;
        if (CasHelper.isEmpty((DynamicObject[])transdetails)) {
            return;
        }
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)"cas_intelrec", (String)operKey);
        Object permission = operateMetaMap.get("permission");
        boolean hasPerm = false;
        HashSet<Long> orgIds = new HashSet<Long>(transdetails.length);
        for (DynamicObject transdetail : transdetails) {
            orgIds.add(transdetail.getDynamicObject("company").getLong("id"));
        }
        Iterator iterator = orgIds.iterator();
        while (iterator.hasNext() && !(hasPerm = PermissionHelper.checkCurrentUserPermission((long)(org = (Long)iterator.next()), (String)"cas_intelrec", (String)(permission + "")))) {
        }
        if (!hasPerm) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0%s\u6743\u9650\u3002", (String)"RecWorkbenchPlugin_5", (String)SYSTEMTYPE, (Object[])new Object[0]), operKeyName));
        }
    }

    private void cancelNotice(Object[] selectids) {
        DynamicObject[] transdetails = this.getSelectRow(selectids);
        this.checkOpPerm("cancelnotice", ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_8", (String)SYSTEMTYPE, (Object[])new Object[0]), transdetails);
        OperationResult result = new OperationResult();
        result.setBillCount(transdetails.length);
        ArrayList<String> noticeNos = new ArrayList<String>();
        HashMap<String, String> billNoMap = new HashMap<String, String>();
        for (DynamicObject transdetail : transdetails) {
            String claimBillno = transdetail.getString("claimnoticebillno");
            if (CasHelper.isNotEmpty((Object)claimBillno)) {
                String receredtype = transdetail.getString("receredtype");
                if ("3".equals(receredtype)) {
                    result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)transdetail.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5df2\u5165\u8d26,\u65e0\u6cd5\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%s\uff09\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"ClaimRecWorkbenchPlugin_23", (String)SYSTEMTYPE, (Object[])new Object[0]), transdetail.getString("billno")), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_8", (String)SYSTEMTYPE, (Object[])new Object[0])));
                    continue;
                }
                String billno = transdetail.getString("claimnoticebillno");
                noticeNos.add(billno);
                billNoMap.put(billno, transdetail.getString("billno"));
                continue;
            }
            result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)transdetail.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u5904\u4e8e\u201c\u5f85\u8ba4\u9886\u201d\u72b6\u6001\u7684\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%s\uff09\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"ClaimRecWorkbenchPlugin_9", (String)SYSTEMTYPE, (Object[])new Object[0]), transdetail.getString("billno")), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_8", (String)SYSTEMTYPE, (Object[])new Object[0])));
        }
        HashSet<Object> claimIds = new HashSet<Object>();
        HashMap claimType = new HashMap(claimIds.size());
        HashMap<String, List<Object>> typeValue = null;
        ArrayList<String> noticeMes = null;
        DynamicObjectCollection dycoll = null;
        StringBuilder message = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-M-dd");
        if (noticeNos.size() > 0) {
            DynamicObject[] noticeBills;
            for (DynamicObject noticeBill : noticeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno,claimstatus,sourceid,currency,mergestatus,reamount,oppunit,description,tradetime,tradedetailno,claimnoticebillno,receredtype,entryentity1.claimtype,entryentity1.claimtypeid", (QFilter[])new QFilter[]{new QFilter("billno", "in", noticeNos)})) {
                if (!ClaimStatusEnum.WAIT.getValue().equals(noticeBill.getString("claimstatus"))) {
                    result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)noticeBill.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u5904\u4e8e\u201c\u5f85\u8ba4\u9886\u201d\u72b6\u6001\u7684\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%s\uff09\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"ClaimRecWorkbenchPlugin_9", (String)SYSTEMTYPE, (Object[])new Object[0]), billNoMap.get(noticeBill.getString("billno"))), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_8", (String)SYSTEMTYPE, (Object[])new Object[0])));
                    continue;
                }
                if (MergeStatusEnum.MARFED.getValue().equals(noticeBill.getString("mergestatus"))) {
                    result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)noticeBill.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u672a\u88ab\u5408\u5e76\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%s\uff09\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"ClaimRecWorkbenchPlugin_24", (String)SYSTEMTYPE, (Object[])new Object[0]), billNoMap.get(noticeBill.getString("billno"))), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_8", (String)SYSTEMTYPE, (Object[])new Object[0])));
                    continue;
                }
                claimIds.add(noticeBill.getPkValue());
                dycoll = noticeBill.getDynamicObjectCollection("entryentity1");
                typeValue = new HashMap<String, List<Object>>();
                typeValue.put("userids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                typeValue.put("usergroupids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERGROUP.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                typeValue.put("orgids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERORG.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                typeValue.put("roleids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.ROLER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                message.setLength(0);
                noticeMes = new ArrayList<String>();
                noticeMes.add(String.format(ResManager.loadKDString((String)"1\u7b14\u6536\u6b3e\uff08\u91d1\u989d\uff1a%1$s%2$s\uff09\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"ClaimRecWorkbenchPlugin_15", (String)SYSTEMTYPE, (Object[])new Object[0]), noticeBill.getDynamicObject("currency").getString("sign"), CasHelper.formatDecimal((BigDecimal)noticeBill.getBigDecimal("reamount"), (int)2)));
                typeValue.put("title", noticeMes);
                message.setLength(0);
                noticeMes = new ArrayList();
                message.append(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6536\u6b3e\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002\u6536\u6b3e\u91d1\u989d\uff1a%1$s%2$s\uff0c\u5bf9\u65b9\u6237\u540d\uff1a%3$s\uff0c\u6458\u8981\uff1a%4$s", (String)"ClaimRecWorkbenchPlugin_18", (String)SYSTEMTYPE, (Object[])new Object[0]), noticeBill.getDynamicObject("currency").getString("sign"), CasHelper.formatDecimal((BigDecimal)noticeBill.getBigDecimal("reamount"), (int)2), noticeBill.getString("oppunit"), noticeBill.getString("description")));
                if (EmptyUtil.isNoEmpty((Object)noticeBill.getDate("tradetime"))) {
                    message.append(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\uff1a%s", (String)"ClaimRecWorkbenchPlugin_21", (String)SYSTEMTYPE, (Object[])new Object[0]), sdf.format(noticeBill.getDate("tradetime"))));
                }
                message.append(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7 \uff1a%s", (String)"ClaimRecWorkbenchPlugin_22", (String)SYSTEMTYPE, (Object[])new Object[0]), noticeBill.getString("tradedetailno")));
                noticeMes.add(message.toString());
                typeValue.put("content", noticeMes);
                claimType.put(noticeBill.getPkValue(), typeValue);
            }
        }
        if (claimIds.size() > 0) {
            OperationResult execOperate = null;
            try (TXHandle tx = TX.requiresNew();){
                execOperate = OperateServiceHelper.execOperate((String)"delete", (String)"cas_claimcenterbill", (Object[])claimIds.toArray(), (OperateOption)OperateOption.create());
                if (!execOperate.isSuccess() && execOperate.getAllErrorInfo().size() > 0) {
                    result.addErrorInfo((OperateErrorInfo)execOperate.getAllErrorInfo().get(0));
                }
            }
            HashMap claimTypeTemp = new HashMap(claimIds.size());
            List successPkid = execOperate.getSuccessPkIds();
            for (Map.Entry claim : claimType.entrySet()) {
                if (!successPkid.contains(claim.getKey())) continue;
                claimTypeTemp.put(claim.getKey(), claim.getValue());
            }
            RecClaimHelper.sendClaimNoticeMessage(claimTypeTemp, (String)"cancel");
        }
        if (result.getAllErrorInfo().size() > 0) {
            ((ListView)this.getView()).refresh();
            this.getPageCache().put("operationresult", DataEntitySerializer.serializerToString((Object)result));
            CasHelper.showOperationResultMulti((OperationResult)result, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_8", (String)SYSTEMTYPE, (Object[])new Object[0]), (IFormView)this.getView());
        } else {
            ((ListView)this.getView()).refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ClaimRecWorkbenchPlugin_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
    }

    private void noticeClaim(Object[] ids) {
        DynamicObject[] transdetails = this.getSelectRow(ids);
        this.checkOpPerm("noticeclaim", ResManager.loadKDString((String)"\u901a\u77e5\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_7", (String)SYSTEMTYPE, (Object[])new Object[0]), transdetails);
        ArrayList<DynamicObject> noticeds = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> unnotices = new ArrayList<DynamicObject>(10);
        HashSet<Long> orgSet = new HashSet<Long>(10);
        for (DynamicObject transdetail : transdetails) {
            if (StringUtils.equals((CharSequence)"3", (CharSequence)transdetail.getString("receredtype"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5165\u8d26\u6570\u636e\uff0c\u65e0\u6cd5\u901a\u77e5\u8ba4\u9886\u3002", (String)"ClaimRecWorkbenchPlugin_10", (String)SYSTEMTYPE, (Object[])new Object[0]));
                return;
            }
            orgSet.add(transdetail.getDynamicObject("company").getLong("id"));
            if (orgSet.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u8d44\u91d1\u7ec4\u7ec7\u7684\u4ea4\u6613\u660e\u7ec6\u6279\u91cf\u901a\u77e5\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_14", (String)SYSTEMTYPE, (Object[])new Object[0]));
                return;
            }
            if (EmptyUtil.isEmpty((String)((String)transdetail.get("claimnoticebillno")))) {
                unnotices.add(transdetail);
                continue;
            }
            noticeds.add(transdetail);
        }
        ArrayList<DynamicObject> failIds = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> successIds = new ArrayList<DynamicObject>(10);
        StringBuilder recPayRuleFailMessage = new StringBuilder();
        HashMap<String, String> ruleNotice = new HashMap<String, String>();
        for (DynamicObject unnotice : unnotices) {
            Object id = unnotice.get("id");
            DynamicObject ruleResult = RecPayRuleHelper.getClaimInfoByMatchRule((Long)((Long)id), (String)"rec", (String)"claim");
            if (EmptyUtil.isEmpty((DynamicObject)ruleResult)) {
                failIds.add(unnotice);
                continue;
            }
            if ("recv".equals(ruleResult.get("e_handlescheme")) && !EmptyUtil.isEmpty((Object)ruleResult.get("e_savenotifi_TAG"))) {
                successIds.add(unnotice);
                cache.put(id.toString(), ruleResult.get("e_savenotifi_TAG"));
                ruleNotice.put(id.toString(), ruleResult.get("e_savenotifi_TAG").toString());
            } else {
                failIds.add(unnotice);
            }
            if (!"recv".equals(ruleResult.get("e_handlescheme")) || EmptyUtil.isEmpty((Object)ruleResult.get("e_rulesname"))) continue;
            cache.put(id.toString() + "rulesname", ruleResult.get("e_rulesname"));
        }
        OperationResult result = null;
        if (!successIds.isEmpty()) {
            result = OperateServiceHelper.execOperateWithoutThrow((String)"pushandsave", (String)"bei_transdetail_cas", (Object[])successIds.stream().map(e -> e.get("id")).toArray(), (OperateOption)OperateOption.create());
            this.getPageCache().put("successIds", String.join((CharSequence)",", successIds.stream().map(e -> e.get("id").toString()).collect(Collectors.toList())));
        }
        if (!failIds.isEmpty()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("claimconfirm", (IFormPlugin)this);
            String confirmMessage = "";
            noticeds.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u53d1\u8d77\u8fc7\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u65e0\u9700\u518d\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"ClaimRecWorkbenchPlugin_4", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
            successIds.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u901a\u77e5\u8ba4\u9886\u64cd\u4f5c\u6210\u529f\u3002\r\n", (String)"ClaimRecWorkbenchPlugin_5", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
            failIds.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u6309\u65b9\u6848\u901a\u77e5\u8ba4\u9886\uff0c\u53ef\u80fd\u662f\u672a\u8fdb\u884c\u89c4\u5219\u8bbe\u7f6e\uff0c\u6216\u672a\u9002\u914d\u5230\u65b9\u6848\u3002\u53ef\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f\u540e\u53d1\u8d77\u901a\u77e5\u3002\r\n", (String)"ClaimRecWorkbenchPlugin_1", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
            confirmMessage = noticeds.isEmpty() ? String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u6309\u89c4\u5219\u901a\u77e5\u8ba4\u9886%2$s\u6761\uff0c\u9700\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f%3$s\u6761\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClaimRecWorkbenchPlugin_0", (String)SYSTEMTYPE, (Object[])new Object[0]), ids.length, successIds.size(), failIds.size()) : String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u65e0\u9700\u901a\u77e5%2$s\u6761\uff0c\u5df2\u6309\u89c4\u5219\u901a\u77e5\u8ba4\u9886%3$s\u6761\uff0c\u9700\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f%4$s\u6761\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClaimRecWorkbenchPlugin_6", (String)SYSTEMTYPE, (Object[])new Object[0]), ids.length, noticeds.size(), successIds.size(), failIds.size());
            this.getView().showConfirm(confirmMessage, recPayRuleFailMessage.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            this.getPageCache().put("failids", String.join((CharSequence)",", failIds.stream().map(e -> e.get("id").toString()).collect(Collectors.toList())));
        } else {
            if (noticeds.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ClaimRecWorkbenchPlugin_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
            } else {
                noticeds.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u53d1\u8d77\u8fc7\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u65e0\u9700\u518d\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"ClaimRecWorkbenchPlugin_4", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
                unnotices.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u901a\u77e5\u8ba4\u9886\u64cd\u4f5c\u6210\u529f\u3002\r\n", (String)"ClaimRecWorkbenchPlugin_5", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u901a\u77e5\u8ba4\u9886%2$s\u6761\uff0c\u65e0\u9700\u901a\u77e5%3$s\u6761\u3002", (String)"ClaimRecWorkbenchPlugin_3", (String)SYSTEMTYPE, (Object[])new Object[0]), transdetails.length, unnotices.size(), noticeds.size()), recPayRuleFailMessage.toString(), MessageTypes.Default);
            }
            if (result != null) {
                this.noticeMessage(ruleNotice);
                this.getPageCache().remove("successIds");
            }
            ((ListView)this.getView()).refresh();
        }
    }

    private void noticeMessage(Map<String, String> ruleNotice) {
        HashMap claimTypeMap = new HashMap(ruleNotice.size());
        HashMap<String, List> typeValue = null;
        for (Map.Entry<String, String> rule : ruleNotice.entrySet()) {
            Map map = (Map)SerializationUtils.fromJsonString((String)rule.getValue(), Map.class);
            typeValue = new HashMap<String, List>();
            typeValue.put("usergroupids", (List)map.get("usergroupids"));
            typeValue.put("orgids", (List)map.get("orgids"));
            typeValue.put("roleids", (List)map.get("roleids"));
            typeValue.put("userids", (List)map.get("userids"));
            claimTypeMap.put(rule.getKey(), typeValue);
        }
        RecClaimHelper.sendClaimNoticeMessage(claimTypeMap, (String)"notice");
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("claimconfirm") && e.getResult() == MessageBoxResult.Yes) {
            FormShowParameter formParameter = new FormShowParameter();
            formParameter.setFormId("cas_noticeclaim");
            formParameter.getOpenStyle().setShowType(ShowType.Modal);
            formParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "noticetype"));
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Object[] transdetails = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id, billno, claimnoticebillno , receredtype , company", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
            if (EmptyUtil.isNoEmpty((Object[])transdetails)) {
                formParameter.setCustomParam("orgId", transdetails[0].getDynamicObject("company").getPkValue());
            }
            this.getView().showForm(formParameter);
        } else {
            String successString = this.getPageCache().get("successIds");
            if (EmptyUtil.isNotEmpty((String)successString)) {
                String[] successIds = successString.split(",");
                HashMap<String, String> ruleNotice = new HashMap<String, String>(successIds.length);
                for (int i = 0; i < successIds.length; ++i) {
                    ruleNotice.put(successIds[i], (String)cache.get(successIds[i], String.class));
                }
                this.noticeMessage(ruleNotice);
            }
            this.getPageCache().remove("successIds");
            ((ListView)this.getView()).refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("noticetype".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (EmptyUtil.isEmpty((Object)returnData)) {
                return;
            }
            Map noticeData = (Map)returnData;
            String jsonString = SerializationUtils.toJsonString((Object)noticeData);
            String failidString = this.getPageCache().get("failids");
            String[] failids = failidString.split(",");
            HashMap<String, String> ruleNotice = new HashMap<String, String>(failids.length);
            for (int i = 0; i < failids.length; ++i) {
                cache.put(failids[i], (Object)jsonString);
                ruleNotice.put(failids[i], jsonString);
            }
            Object[] ids = (Long[])Arrays.stream(failids).mapToLong(Long::valueOf).boxed().toArray(Long[]::new);
            OperationResult result = OperateServiceHelper.execOperateWithoutThrow((String)"pushandsave", (String)"bei_transdetail_cas", (Object[])ids, (OperateOption)OperateOption.create());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ClaimRecWorkbenchPlugin_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
            String successString = this.getPageCache().get("successIds");
            if (EmptyUtil.isNotEmpty((String)successString)) {
                String[] successIds = successString.split(",");
                for (int i = 0; i < successIds.length; ++i) {
                    ruleNotice.put(successIds[i], (String)cache.get(successIds[i], String.class));
                }
            }
            this.noticeMessage(ruleNotice);
            this.getPageCache().remove("successIds");
            ((ListView)this.getView()).refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("claimnoticebillno".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObject detail = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"bei_transdetail_cas", (String)"id,claimnoticebillno");
            String recBillNo = detail.getString("claimnoticebillno");
            if (!StringUtils.isEmpty((CharSequence)recBillNo)) {
                QFilter filter = new QFilter("billno", "=", (Object)recBillNo);
                DynamicObject recbillDo = BusinessDataServiceHelper.loadSingle((String)"cas_claimcenterbill", (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
                if (!CasHelper.isEmpty((Object)recbillDo)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setFormId("cas_claimcenterbill");
                    showParameter.setPkId(recbillDo.getPkValue());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
    }

    public DynamicObject[] getSelectRow(Object[] ids) {
        DynamicObject[] transdetails = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id, billno, claimnoticebillno , receredtype , company", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        return transdetails;
    }
}

