/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.claimhandle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.BusinessTypeEnum;
import kd.fi.cas.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimPaymentTypeEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.RecAmtTypeEnum;
import kd.fi.cas.enums.RecBizTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.formplugin.recclaim.CommonOperationHandler;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CoreBillSettingHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.ViewInputHelper;
import kd.fi.cas.result.InvokeResult;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;
import kd.sdk.fi.cas.extpoint.claimbill.IClaimHandlePluginSDK;
import kd.sdk.fi.cas.extpoint.claimbill.IClaimbillFilter;

public class ClaimHandleEditPlugin
extends BillEditPlugin
implements HyperLinkClickListener,
EntryGridBindDataListener {
    private static Log logger = LogFactory.getLog(ClaimHandleEditPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        boolean addnew;
        super.beforeBindData(e);
        IDataModel iDataModel = this.getModel();
        String billstatus = (String)iDataModel.getValue("billstatus");
        String claimNo = (String)iDataModel.getValue("claimno");
        String claimtype = (String)iDataModel.getValue("claimtype");
        DynamicObject org = (DynamicObject)iDataModel.getValue("org");
        DynamicObject recbasepayee = (DynamicObject)iDataModel.getValue("recbasepayee");
        if (CasHelper.isEmpty((Object)recbasepayee)) {
            this.setRecInfo(iDataModel);
        }
        String businesstype = (String)iDataModel.getValue("businesstype");
        if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businesstype)) {
            ((FieldEdit)this.getView().getControl("paytype")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("payeetype")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("recpayee")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("recbasepayee")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("e_paymenttype")).setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"multireceivingtype"});
        } else {
            ((FieldEdit)this.getView().getControl("recpaytype")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("paymenttype")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("recpayer")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("recbasepayer")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("e_receivingtype")).setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"multipaymenttype"});
        }
        QFilter claimNoQ = null;
        boolean isNeedUpdate = true;
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.SAVE.getValue()) || StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.SUBMIT.getValue()) || StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            Object[] load;
            if ((StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.ADJUST.getValue()) || StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CHANGE.getValue())) && EmptyUtil.isNoEmpty((Object[])(load = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{claimNoQ = new QFilter("id", "=", this.getModel().getValue("id"))})))) {
                isNeedUpdate = false;
            }
        } else {
            isNeedUpdate = false;
        }
        boolean isRecpayer = true;
        if (isNeedUpdate) {
            claimNoQ = new QFilter("claimNo", "=", (Object)claimNo);
            claimNoQ.and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue())).and(new QFilter("claimtype", "!=", (Object)ClaimTypeEnum.ADJUST.getValue()));
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"cas_claimbill", (String)"multireceivingtype,multipaymenttype,recpaytype,paytype,payeetype,recbasetype,recbasepayee,recpayee,recviewpayee,paymenttype,recpayer,bizdate,inneraccount", (QFilter[])new QFilter[]{claimNoQ}, (String)" auditdate asc ");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
                isRecpayer = false;
                boolean updateFlag = false;
                DynamicObject claimbill = (DynamicObject)colls.get(0);
                Long recpaytypeDy = claimbill.getLong("recpaytype");
                String paymenttypeStr = claimbill.getString("paymenttype");
                String recpayerDy = claimbill.getString("recpayer");
                Date biz = claimbill.getDate("bizdate");
                Object recpaytypeObj = iDataModel.getValue("recpaytype");
                String paymenttype = (String)iDataModel.getValue("paymenttype");
                Object recpayerObj = iDataModel.getValue("recpayer");
                Date bizDate = (Date)iDataModel.getValue("bizdate");
                if (!(EmptyUtil.isEmpty((Object)recpaytypeObj) || EmptyUtil.isEmpty((String)paymenttype) || EmptyUtil.isEmpty((Object)recpayerObj))) {
                    Long recpaytype = null;
                    String recpayer = null;
                    if (recpaytypeObj instanceof Long) {
                        recpaytype = (Long)recpaytypeObj;
                    }
                    if (recpaytypeObj instanceof DynamicObject) {
                        recpaytype = ((DynamicObject)recpaytypeObj).getLong("id");
                    }
                    if (recpayerObj instanceof Long) {
                        recpayer = String.valueOf(recpayerObj);
                    }
                    if (recpayerObj instanceof DynamicObject) {
                        recpayer = String.valueOf(((DynamicObject)recpayerObj).getLong("id"));
                    }
                    if (recpayerObj instanceof String) {
                        recpayer = (String)recpayerObj;
                    }
                    if (recpaytypeDy.compareTo(recpaytype) != 0 || !StringUtils.equals((CharSequence)paymenttypeStr, (CharSequence)paymenttype) || !StringUtils.equals((CharSequence)recpayerDy, (CharSequence)recpayer) || biz.compareTo(bizDate) != 0) {
                        updateFlag = true;
                    }
                } else {
                    updateFlag = true;
                }
                BigDecimal payAmount = (BigDecimal)iDataModel.getValue("payamount");
                if (payAmount.compareTo(BigDecimal.ZERO) != 0 && !StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                    iDataModel.beginInit();
                    iDataModel.setValue("payeetype", claimbill.get("payeetype"));
                    iDataModel.setValue("recbasetype", claimbill.get("recbasetype"));
                    if (CasHelper.isNotEmpty((Object)claimbill.getLong("recbasepayee"))) {
                        iDataModel.setValue("recbasepayee", claimbill.get("recbasepayee"));
                    }
                    iDataModel.setValue("recpayee", claimbill.get("recpayee"));
                    iDataModel.setValue("recviewpayee", claimbill.get("recviewpayee"));
                    iDataModel.setValue("bizdate", (Object)biz);
                    iDataModel.endInit();
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0b\u5df2\u5b58\u5728\u5ba1\u6838\u7684\u8ba4\u9886\u4fe1\u606f\uff0c\u5c06\u4f7f\u7528\u5df2\u5ba1\u6838\u8ba4\u9886\u5355\u7684\u6536\u6b3e\u4eba\u7c7b\u578b\u3001\u6536\u6b3e\u4eba\u4fe1\u606f\u3001\u4e1a\u52a1\u65e5\u671f", (String)"ClaimHandleEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(8000));
                }
                if (updateFlag && payAmount.compareTo(BigDecimal.ZERO) == 0 && !StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                    iDataModel.beginInit();
                    iDataModel.setValue("paymenttype", (Object)paymenttypeStr);
                    iDataModel.setValue("recpayer", (Object)recpayerDy);
                    iDataModel.setValue("bizdate", (Object)biz);
                    iDataModel.setValue("inneraccount", claimbill.get("inneraccount"));
                    iDataModel.endInit();
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0b\u5df2\u5b58\u5728\u5ba1\u6838\u7684\u8ba4\u9886\u4fe1\u606f\uff0c\u5c06\u4f7f\u7528\u5df2\u5ba1\u6838\u8ba4\u9886\u5355\u7684\u4ed8\u6b3e\u4eba\u7c7b\u578b\u3001\u4ed8\u6b3e\u4eba\u4fe1\u606f\u3001\u4e1a\u52a1\u65e5\u671f", (String)"ClaimHandleEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(8000));
                }
                if (StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CLAIM.getValue())) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"payeetype", "recbasetype", "recbasepayee", "recpayee", "recviewpayee", "inneraccount", "paymenttype", "recpayer", "recbasepayer", "bizdate"});
                }
            }
        }
        String payment = (String)iDataModel.getValue("paymenttype");
        Object recpaytypeObj = this.getModel().getValue("recpaytype");
        boolean ispartreceivable = true;
        Boolean multiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
        if (!EmptyUtil.isEmpty((Object)recpaytypeObj)) {
            DynamicObject recpaytype = (DynamicObject)recpaytypeObj;
            String bizType = recpaytype.getString("biztype");
            QFilter typeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
            QFilter orgFilter = new QFilter("org.id", "=", org.getPkValue());
            DynamicObject[] bdFinorginfo = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{typeFilter.and(orgFilter)});
            if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(bizType) && bdFinorginfo.length > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccount"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccountname"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountname"});
            }
            String paymenttype = "";
            ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.CUSTOMER.getName()), ClaimPaymentTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.SUPPLIER.getName()), ClaimPaymentTypeEnum.SUPPLIER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.USER.getName()), ClaimPaymentTypeEnum.USER.getValue()));
            if (!multiReceivingType.booleanValue() && !recpaytype.getBoolean("ispartreceivable")) {
                ispartreceivable = false;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_settleorg", "e_corebillentryseq", "e_itemname", "e_material", "e_discountamt", "e_saleman"});
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entryentity"))) {
                    int entryRowCount = this.getModel().getEntryRowCount("entryentity");
                    for (int i = 0; i < entryRowCount; ++i) {
                        this.getModel().setValue("e_corebillentryseq", null, i);
                        this.getModel().setValue("e_itemname", null, i);
                        this.getModel().setValue("e_material", null, i);
                        this.getModel().setValue("e_discountamt", null, i);
                        this.getModel().setValue("e_saleman", null, i);
                        this.getModel().setValue("e_corebillnoinput", this.getModel().getValue("e_corebillno", i), i);
                    }
                }
                paymenttype = "other";
                comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.ORG.getName()), ClaimPaymentTypeEnum.ORG.getValue()));
                comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.OTHER.getName()), ClaimPaymentTypeEnum.OTHER.getValue()));
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_corebillno"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_settleorg", "e_corebillentryseq", "e_itemname", "e_material", "e_discountamt", "e_saleman"});
                paymenttype = "bd_customer";
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_corebillnoinput"});
            }
            if (RecBizTypeEnum.AGENT_RECEIVING.getValue().equals(recpaytype.getString("biztype"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_settleorg"});
            }
            ComboEdit recpaytypeCbo = (ComboEdit)this.getView().getControl("paymenttype");
            recpaytypeCbo.setComboItems(comboItem);
            if (EmptyUtil.isEmpty((String)payment)) {
                this.getModel().beginInit();
                this.getModel().setValue("paymenttype", (Object)paymenttype);
                this.getModel().setValue("paymentbasetype", (Object)(StringUtils.equals((CharSequence)"other", (CharSequence)paymenttype) ? "" : paymenttype));
                this.getModel().endInit();
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_corebillnoinput"});
        }
        if (EmptyUtil.isNotEmpty((String)payment) && !StringUtils.equals((CharSequence)payment, (CharSequence)"other")) {
            iDataModel.setValue("paymentbasetype", (Object)payment);
            iDataModel.setValue("recbasepayer", iDataModel.getValue("recpayer"));
            Object recbasepayerDy = this.getModel().getValue("recbasepayer");
            if (EmptyUtil.isEmpty((Object)recbasepayerDy)) {
                this.getModel().setValue("recviewpayer", null);
            } else {
                this.getModel().setValue("recviewpayer", (Object)((DynamicObject)recbasepayerDy).getString("name"));
            }
        } else {
            iDataModel.setValue("recviewpayer", iDataModel.getValue("recpayer"));
        }
        this.refreshNoticeBillInfo();
        this.rebuildCoreBillType(multiReceivingType, ispartreceivable);
        this.getView().setVisible(Boolean.FALSE, new String[]{"recviewpayer"});
        this.changeCaption();
        Object sourceid = this.getModel().getValue("sourceid");
        if (sourceid != null && !"".equals(sourceid)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)sourceid, (String)"cas_claimcenterbill");
            String mergestatus = dynamicObject.getString("mergestatus");
            if (MergeStatusEnum.ALMARGE.getValue().equals(mergestatus)) {
                this.getDataToEntry();
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailentry", "ticketdetail"});
            }
        }
        this.getView().getModel().setDataChanged(false);
        BigDecimal payAmount = (BigDecimal)this.getModel().getValue("payamount");
        if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
            HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba4\u9886\u7ed3\u679c", (String)"ClaimAppealEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            this.getView().updateControlMetadata("contentpanel", props);
        }
        DynamicObjectCollection detailentryentity = this.getModel().getEntryEntity("detailentryentity");
        Map<String, List<DynamicObject>> oppBankNumberMap = detailentryentity.stream().collect(Collectors.groupingBy(c -> c.getString("e_oppunit")));
        Boolean boolTemp = true;
        if (null != this.getView().getFormShowParameter().getCustomParams().get("showTips")) {
            boolTemp = false;
        }
        if ((addnew = this.getView().getFormShowParameter().getStatus().toString().equals("ADDNEW")) && oppBankNumberMap.size() > 1 && isRecpayer && boolTemp.booleanValue()) {
            this.getModel().setValue("recbasepayer", null);
            this.getModel().setValue("recviewpayer", null);
            this.getModel().setValue("recpayer", null);
            this.getModel().setValue("recpayee", null);
            this.getModel().setValue("recbasepayee", null);
            this.getModel().setValue("recviewpayer", null);
        }
    }

    private void rebuildCoreBillType(boolean multiType, boolean ispartreceivable) {
        List comboItems;
        ArrayList<ComboItem> coreComboItem = new ArrayList<ComboItem>();
        String selectType = multiType ? "multicorebilltype" : (ispartreceivable ? "settlecorebilltype" : "unsettlecorebilltype");
        ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_claimbill").getProperty(selectType);
        if (EmptyUtil.isNoEmpty((Object)property) && EmptyUtil.isNoEmpty((Object)(comboItems = property.getComboItems()))) {
            for (ValueMapItem valueMapItem : comboItems) {
                ComboItem comboItem = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
                coreComboItem.add(comboItem);
            }
        }
        CoreBillSettingHelper.setCoreBillTypeComboItem((String)"cas_claimbill", (boolean)multiType, (boolean)ispartreceivable, coreComboItem);
        ComboEdit coreCbo = (ComboEdit)this.getView().getControl("e_corebilltype");
        coreCbo.setComboItems(coreComboItem);
    }

    private void refreshNoticeBillInfo() {
        IDataModel iDataModel = this.getModel();
        String claimNo = (String)iDataModel.getValue("claimno");
        QFilter claimNoQ = new QFilter("billno", "=", (Object)claimNo);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"claimstatus,claimedamount,unclaimamount,isaddfee", (QFilter[])new QFilter[]{claimNoQ});
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
            iDataModel.setValue("claimstatus", ((DynamicObject)colls.get(0)).get("claimstatus"));
            iDataModel.setValue("claimedamount", ((DynamicObject)colls.get(0)).get("claimedamount"));
            iDataModel.setValue("unclaimamount", ((DynamicObject)colls.get(0)).get("unclaimamount"));
            this.getView().updateView("claimstatus");
            Boolean feeEnable = !((DynamicObject)colls.get(0)).getBoolean("isaddfee");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entryentity"))) {
                int entryRowCount = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getView().setEnable(feeEnable, i, new String[]{"e_fee"});
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection entries;
        Boolean multiType;
        DynamicObjectCollection detailentryentity;
        Map<String, List<DynamicObject>> oppBankNumberMap;
        super.afterBindData(e);
        DynamicObject claim = this.getModel().getDataEntity();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object showConer = customParams.get("showConer");
        List workflowlist = WorkflowServiceHelper.getAllApprovalRecord((String)claim.getPkValue().toString());
        if (CollectionUtils.isEmpty((Collection)workflowlist) || CasHelper.isEmpty(showConer)) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.right, true);
            control.setCollapse("splitpanelap1", true);
        }
        if (EmptyUtil.isEmpty((String)this.getPageCache().get("firstTip"))) {
            Object showTips;
            Object rejectreason = this.getModel().getValue("rejectreason");
            if (rejectreason != null && !"".equals(String.valueOf(rejectreason))) {
                String msg = String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u5355\u9a73\u56de\u539f\u56e0\uff1a%s\u3002", (String)"ClaimHandleEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), rejectreason);
                this.getView().showMessage(msg);
            }
            if ((showTips = this.getView().getFormShowParameter().getCustomParam("showTips")) != null) {
                this.getView().showTipNotification((String)showTips);
            }
            Boolean isnoticemerge = (Boolean)this.getModel().getValue("isnoticemerge");
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (isnoticemerge.booleanValue() && !StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) {
                String claimNo = (String)this.getModel().getValue("claimno");
                QFilter claimNoQ = new QFilter("billno", "=", (Object)claimNo);
                Object[] colls = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,creator", (QFilter[])new QFilter[]{claimNoQ});
                String userName = "";
                if (EmptyUtil.isNoEmpty((Object[])colls) && EmptyUtil.isNoEmpty((DynamicObject)colls[0].getDynamicObject("creator"))) {
                    userName = colls[0].getDynamicObject("creator").getString("name");
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u8ba4\u9886\u5355\u6240\u5c5e\u7684\u901a\u77e5\u5355\u5df2\u88ab\u5408\u5e76\u4eba%1$s\u5408\u5e76\u6210\u7f16\u53f7%2$s\u7684\u8ba4\u9886\u901a\u77e5\u5355\u3002", (String)"ClaimHandleEditPlugin_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), userName, claimNo), Integer.valueOf(8000));
            }
            this.getPageCache().put("firstTip", "yes");
        }
        if (this.getView().getFormShowParameter().getCustomParam("onlyView") != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"unsubmitaudit", "change"});
        }
        this.setEntryAmountCaption();
        if (this.getView().getPageCache().get("tradedetailno") == null) {
            this.getView().getPageCache().put("tradedetailno", (String)this.getModel().getValue("tradedetailno"));
        }
        if ((oppBankNumberMap = (detailentryentity = this.getModel().getEntryEntity("detailentryentity")).stream().collect(Collectors.groupingBy(c -> c.getString("e_oppunit")))).size() > 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"oppunit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_oppunit"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"oppunit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_oppunit"});
        }
        this.controlRecAmt();
        this.controlPayAmt();
        this.calculateRecAmt();
        String businessType = (String)this.getModel().getValue("businesstype");
        DynamicObject recType = (DynamicObject)this.getModel().getValue("recpaytype");
        DynamicObject payType = (DynamicObject)this.getModel().getValue("paytype");
        if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) {
            multiType = (Boolean)this.getModel().getValue("multipaymenttype");
            entries = this.getModel().getDataEntity().getDynamicObjectCollection("payentity");
            if (!multiType.booleanValue()) {
                for (int i = 0; i < entries.size(); ++i) {
                    if (this.getModel().getValue("e_paymenttype", i) != null) continue;
                    this.getModel().setValue("e_paymenttype", (Object)payType, i);
                }
                DynamicObjectCollection payEntries = this.getModel().getEntryEntity("payentity");
                for (int i = 0; i < payEntries.size(); ++i) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_paymenttype"});
                }
            }
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                DynamicObject ePaymentType = entry.getDynamicObject("e_paymenttype");
                Object payFundFlowItem = this.getModel().getValue("e_payfundflowitem", i);
                if (ePaymentType == null || !CasHelper.isEmpty((Object)payFundFlowItem)) continue;
                DynamicObject defaultFundFlow = ePaymentType.getDynamicObject("fundflowitem");
                this.getModel().beginInit();
                this.getModel().setValue("e_payfundflowitem", defaultFundFlow == null ? null : Long.valueOf(defaultFundFlow.getLong("id")), i);
                this.getModel().endInit();
            }
        } else {
            multiType = (Boolean)this.getModel().getValue("multireceivingtype");
            entries = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            if (!multiType.booleanValue()) {
                for (int i = 0; i < entries.size(); ++i) {
                    if (this.getModel().getValue("e_receivingtype", i) != null) continue;
                    this.getModel().setValue("e_receivingtype", (Object)recType, i);
                }
                DynamicObjectCollection recEntries = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
                for (int i = 0; i < recEntries.size(); ++i) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_receivingtype"});
                }
            }
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                DynamicObject eReceivingType = entry.getDynamicObject("e_receivingtype");
                Object fundFlowItem = this.getModel().getValue("e_fundflowitem", i);
                if (eReceivingType == null || !CasHelper.isEmpty((Object)fundFlowItem)) continue;
                DynamicObject defaultFundFlow = eReceivingType.getDynamicObject("fundflowitem");
                this.getModel().beginInit();
                this.getModel().setValue("e_fundflowitem", defaultFundFlow == null ? null : Long.valueOf(defaultFundFlow.getLong("id")), i);
                this.getModel().endInit();
            }
        }
        this.multiTypeSelect(multiType);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (Arrays.asList("save", "submit", "unsubmit", "audit", "unsubmitaudit").contains(operateKey)) {
            DynamicObject claimNoticeBil = QueryServiceHelper.queryOne((String)"cas_claimcenterbill", (String)"id,mergestatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)dataEntity.getString("claimno"))});
            if (EmptyUtil.isEmpty((DynamicObject)claimNoticeBil)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba4\u9886\u5904\u7406\u5355\u5173\u8054\u7684\u8ba4\u9886\u901a\u77e5\u5355\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"ClaimNoticeEditPlugin_55", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.equals((CharSequence)MergeStatusEnum.MARFED.getValue(), (CharSequence)claimNoticeBil.getString("mergestatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba4\u9886\u5904\u7406\u5355\u5173\u8054\u7684\u8ba4\u9886\u901a\u77e5\u5355\u8fdb\u884c\u4e86\u5408\u5e76\u8ba4\u9886\u64cd\u4f5c\uff0c\u5f53\u524d\u64cd\u4f5c\u540e\u5c06\u4f1a\u81ea\u52a8\u66f4\u65b0\u8ba4\u9886\u901a\u77e5\u4fe1\u606f\u3002", (String)"ClaimNoticeEditPlugin_54", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                this.getView().invokeOperation("refresh");
                return;
            }
        }
        if ("entryimport".equals(operateKey)) {
            FormShowParameter showForm = new FormShowParameter();
            Object payeetype = this.getModel().getValue("paymenttype");
            showForm.setFormId("cas_entryimport");
            showForm.getOpenStyle().setShowType(ShowType.Modal);
            String billFormId = this.getModel().getDataEntityType().getName();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("payeetype", payeetype);
            params.put("BillFormId", billFormId);
            params.put("BillEntryId", "entryentity");
            showForm.setCustomParams(params);
            showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_entryimport"));
            this.getView().showForm(showForm);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"adjust")) {
            Object id = this.getModel().getValue("id");
            InvokeResult ret = CommonOperationHandler.beforeAdjust(id);
            if (!ret.isSuccess()) {
                if (ret.get("recentDateId") != null) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("cas_claimbill");
                    showParameter.setPkId(ret.get("recentDateId"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setCustomParam("showTips", (Object)ret.getMsg());
                    this.getView().showForm((FormShowParameter)showParameter);
                    args.setCancel(true);
                } else {
                    this.getView().showTipNotification(ret.getMsg());
                    args.setCancel(true);
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"change")) {
            InvokeResult ret;
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (CasHelper.isEmpty((Object)pkValue)) {
                args.setCancel(true);
            }
            if (!(ret = CommonOperationHandler.beforeChangeClaimBill(this.getModel().getDataEntity().getPkValue())).isSuccess()) {
                if (ret.get("recentDateId") != null) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("cas_claimbill");
                    showParameter.setPkId(ret.get("recentDateId"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setCustomParam("showTips", (Object)ret.getMsg());
                    this.getView().showForm((FormShowParameter)showParameter);
                } else {
                    this.getView().showTipNotification(ret.getMsg());
                }
                args.setCancel(true);
            } else {
                boolean flag = ret.isSettleAmtIsZero();
                if (!flag) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("cas_unsettleconfirm");
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setCustomParam("unSetBillSet", (Object)ret.getUnSetBillSet());
                    showParameter.setCustomParam("operation", (Object)"change");
                    this.getView().showForm(showParameter);
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("entryentity".equals(entryName)) {
            this.controlRecAmt();
        } else if ("payentity".equals(entryName)) {
            this.controlPayAmt();
        }
        if ("entryentity".equals(entryName) || "payentity".equals(entryName)) {
            BigDecimal payAmount;
            IDataModel iDataModel = this.getModel();
            Object[] rowDatas = e.getRowDataEntities();
            if (!EmptyUtil.isEmpty((Object[])rowDatas)) {
                for (int j = 0; j < rowDatas.length; ++j) {
                    int insertIndex = rowDatas[j].getRowIndex();
                    String businessType = (String)this.getModel().getValue("businesstype");
                    if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) {
                        Boolean multiPaymentType = (Boolean)this.getModel().getValue("multipaymenttype");
                        if (multiPaymentType.booleanValue()) continue;
                        DynamicObject payType = (DynamicObject)this.getModel().getValue("paytype");
                        iDataModel.setValue("e_paymenttype", (Object)payType, insertIndex);
                        this.getView().setEnable(Boolean.valueOf(false), insertIndex, new String[]{"e_paymenttype"});
                        continue;
                    }
                    Boolean multiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
                    if (multiReceivingType.booleanValue()) continue;
                    DynamicObject recType = (DynamicObject)this.getModel().getValue("recpaytype");
                    iDataModel.setValue("e_receivingtype", (Object)recType, insertIndex);
                    this.getView().setEnable(Boolean.valueOf(false), insertIndex, new String[]{"e_receivingtype"});
                }
            }
            if ((payAmount = (BigDecimal)this.getModel().getValue("payamount")).compareTo(BigDecimal.ZERO) != 0) {
                return;
            }
            DynamicObject recOrg = (DynamicObject)iDataModel.getValue("org");
            DynamicObject settOrg = null;
            if (EmptyUtil.isNoEmpty((DynamicObject)recOrg)) {
                DynamicObject openOrg;
                DynamicObject openOrgObj;
                DynamicObject recAccount;
                DynamicObject centerOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting");
                if (EmptyUtil.isNoEmpty((DynamicObject)centerOrg) && centerOrg.getBoolean("fisaccounting")) {
                    settOrg = recOrg;
                }
                if ((recAccount = (DynamicObject)iDataModel.getValue("accountbank")) != null && !EmptyUtil.isEmpty((DynamicObject)(openOrgObj = BusinessDataServiceHelper.loadSingle((Object)(openOrg = recAccount.getDynamicObject("openorg")).getPkValue(), (String)openOrg.getDynamicObjectType().getName(), (String)"fisaccounting"))) && openOrgObj.getBoolean("fisaccounting")) {
                    settOrg = openOrg;
                }
            }
            if (!EmptyUtil.isEmpty((Object[])rowDatas)) {
                for (Object rowData : rowDatas) {
                    int insertIndex = rowData.getRowIndex();
                    DynamicObject settleorg = (DynamicObject)iDataModel.getValue("e_settleorg", insertIndex > 0 ? insertIndex - 1 : insertIndex);
                    if (EmptyUtil.isEmpty((DynamicObject)settleorg)) {
                        settleorg = settOrg;
                    }
                    iDataModel.setValue("e_settleorg", (Object)settleorg, insertIndex);
                    DynamicObject eReceivingType = iDataModel.getEntryRowEntity("entryentity", insertIndex).getDynamicObject("e_receivingtype");
                    if (eReceivingType == null) continue;
                    DynamicObject defaultFundFlow = eReceivingType.getDynamicObject("fundflowitem");
                    iDataModel.setValue("e_fundflowitem", defaultFundFlow == null ? null : Long.valueOf(defaultFundFlow.getLong("id")), insertIndex);
                }
                this.refreshNoticeBillInfo();
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        this.controlRecAmt();
        this.controlPayAmt();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (StringUtils.equals((CharSequence)e.getEntryProp().getName(), (CharSequence)"entryentity")) {
            this.controlRecAmt();
        } else if (StringUtils.equals((CharSequence)e.getEntryProp().getName(), (CharSequence)"payentity")) {
            this.calculatePayAmt();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject defaultFundFlow;
        String newValue;
        super.propertyChanged(e);
        IDataEntityProperty iDataEntityProperty = e.getProperty();
        String propertyName = iDataEntityProperty.getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"recpaytype")) {
            this.recPayTypeChange(e);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_receivableamt") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_discountamt") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_fee") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_actamt")) {
            Long sourceclaimid;
            Object[] sourceclaims;
            String claimNo;
            QFilter claimNoQ;
            DynamicObjectCollection colls;
            DynamicObjectCollection entryDyColl = this.getModel().getEntryEntity("entryentity");
            String claimtype = (String)this.getModel().getValue("claimtype");
            if (StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CHANGE.getValue()) && StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_receivableamt") && EmptyUtil.isNoEmpty((DynamicObjectCollection)(colls = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"isaddfee", (QFilter[])new QFilter[]{claimNoQ = new QFilter("billno", "=", (Object)(claimNo = (String)this.getModel().getValue("claimno")))}))) && ((DynamicObject)colls.get(0)).getBoolean("isaddfee") && EmptyUtil.isNoEmpty((Object[])(sourceclaims = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"entryentity.e_receivableamt,entryentity.e_fee", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(sourceclaimid = (Long)this.getModel().getValue("sourceclaimid")))})))) {
                Object sourceclaim = sourceclaims[0];
                DynamicObjectCollection entrys = sourceclaim.getDynamicObjectCollection("entryentity");
                BigDecimal oldsumrec = entryDyColl.stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal oldsumfee = entrys.stream().map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal totolfee = BigDecimal.ZERO;
                int amtprecision = ((DynamicObject)this.getModel().getValue("currency")).getInt("amtprecision");
                if (oldsumrec.compareTo(BigDecimal.ZERO) != 0 && oldsumfee.compareTo(BigDecimal.ZERO) != 0) {
                    for (int i = 0; i < entryDyColl.size(); ++i) {
                        BigDecimal tempfee = ((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_receivableamt").multiply(oldsumfee).divide(oldsumrec, amtprecision, RoundingMode.DOWN);
                        if (i == entryDyColl.size() - 1) {
                            tempfee = oldsumfee.subtract(totolfee);
                        } else {
                            totolfee = totolfee.add(tempfee);
                        }
                        this.getModel().beginInit();
                        this.getModel().setValue("e_fee", (Object)tempfee, i);
                        this.getModel().endInit();
                        this.getView().updateView("e_fee", i);
                    }
                }
            }
            this.calculateRecAmt();
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_corebilltype")) {
            int entryInd = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue("e_corebillno", null, entryInd);
            this.getModel().setValue("e_corebillnoinput", null, entryInd);
            this.getModel().setValue("e_corebillid", null, entryInd);
            this.getModel().setValue("e_corebillentryid", null, entryInd);
            this.getModel().setValue("e_corebillentryseq", null, entryInd);
            this.getModel().setValue("conbillentity", null, entryInd);
            this.getModel().setValue("conbillnumber", null, entryInd);
            this.getModel().setValue("conbillrownum", null, entryInd);
            this.getModel().setValue("conbillid", null, entryInd);
            this.getModel().setValue("conbillentryid", null, entryInd);
            Object coreBilltype = this.getModel().getValue("e_corebilltype", entryInd);
            if ("ar_finarbill".equals(coreBilltype)) {
                DynamicObject claimControl;
                DynamicObject[] claimControls = BusinessDataServiceHelper.load((String)"cas_claimcontrol", (String)"id,entry.claimdimension,entry.claimcomtrol", (QFilter[])new QFilter[0]);
                if (CasHelper.isNotEmpty((Object)claimControls) && claimControls.length > 0 && (claimControl = claimControls[0]).getDynamicObjectCollection("entry").size() > 0) {
                    DynamicObject entry = (DynamicObject)claimControl.getDynamicObjectCollection("entry").get(0);
                    String dimensionStr = entry.getString("claimdimension");
                    Boolean comTrolBool = entry.getBoolean("claimcomtrol");
                    this.getModel().setValue("claimdimension", (Object)dimensionStr, entryInd);
                    this.getModel().setValue("claimcomtrol", (Object)comTrolBool, entryInd);
                }
            } else {
                this.getModel().setValue("claimdimension", null, entryInd);
                this.getModel().setValue("claimcomtrol", (Object)false, entryInd);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"paymenttype")) {
            Object newValueObj = e.getChangeSet()[0].getNewValue();
            String string = newValue = newValueObj == null ? null : newValueObj.toString();
            if ("other".equals(newValue)) {
                this.getModel().setValue("recpayer", (Object)"");
                this.getModel().setValue("recbasepayer", (Object)"");
                this.getModel().setValue("paymentbasetype", (Object)"");
            } else {
                this.getModel().setValue("recpayer", (Object)"");
                this.getModel().setValue("recbasepayer", (Object)"");
                this.getModel().setValue("paymentbasetype", (Object)newValue);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"recbasepayer")) {
            Object payerid = this.getModel().getValue("recbasepayer");
            if (payerid != null) {
                this.getModel().setValue("recpayer", ((DynamicObject)payerid).getPkValue());
            } else {
                this.getModel().setValue("recpayer", (Object)"");
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_corebillno")) {
            this.coreBillNoChange(e);
        } else if ("tradedetailno".equals(propertyName)) {
            ChangeData[] changeSet = e.getChangeSet();
            newValue = String.valueOf(changeSet[0].getNewValue());
            if (!this.getView().getPageCache().get("tradedetailno").equals(newValue)) {
                this.getModel().setValue("tradedetailno", (Object)this.getView().getPageCache().get("tradedetailno"));
            }
        } else if ("recbasepayee".equals(propertyName)) {
            Object recbasepayeeDy = this.getModel().getValue("recbasepayee");
            if (!EmptyUtil.isEmpty((Object)recbasepayeeDy)) {
                this.getModel().setValue("recpayee", (Object)((DynamicObject)recbasepayeeDy).getString("name"));
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"payeetype")) {
            Object newValueObj = e.getChangeSet()[0].getNewValue();
            String string = newValue = newValueObj == null ? null : newValueObj.toString();
            if ("other".equals(newValue)) {
                this.getModel().setValue("recpayee", (Object)"");
                this.getModel().setValue("recbasepayee", (Object)"");
                this.getModel().setValue("recbasetype", (Object)"");
            } else {
                this.getModel().setValue("recpayee", (Object)"");
                this.getModel().setValue("recbasepayee", (Object)"");
                this.getModel().setValue("recbasetype", (Object)newValue);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"paytype")) {
            this.payTypeChange(e);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_payactamt") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_payableamt") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_paydiscountamt")) {
            this.calculatePayAmt();
        } else if ("multireceivingtype".equals(propertyName)) {
            Boolean newValue2 = (Boolean)e.getChangeSet()[0].getNewValue();
            this.multiTypeSelect(newValue2);
            this.multiTypeChange(newValue2);
            DynamicObject recpaytype = (DynamicObject)this.getModel().getValue("recpaytype");
            boolean ispartreceivable = recpaytype != null && recpaytype.getBoolean("ispartreceivable");
            this.rebuildCoreBillType(newValue2, ispartreceivable);
        } else if ("e_receivingtype".equals(propertyName)) {
            DynamicObject eReceivingType = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject dynamicObject = defaultFundFlow = eReceivingType != null ? eReceivingType.getDynamicObject("fundflowitem") : null;
            if (defaultFundFlow != null) {
                long defaultFundFlowId = defaultFundFlow.getLong("id");
                this.getModel().setValue("e_fundflowitem", (Object)defaultFundFlowId, this.getModel().getEntryCurrentRowIndex("entryentity"));
            }
        } else if ("multipaymenttype".equals(propertyName)) {
            Boolean newValue3 = (Boolean)e.getChangeSet()[0].getNewValue();
            this.multiTypeSelect(newValue3);
            this.multiTypeChange(newValue3);
        } else if ("e_paymenttype".equals(propertyName)) {
            DynamicObject ePaymentType = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject dynamicObject = defaultFundFlow = ePaymentType != null ? ePaymentType.getDynamicObject("fundflowitem") : null;
            if (defaultFundFlow != null) {
                long defaultFundFlowId = defaultFundFlow.getLong("id");
                this.getModel().setValue("e_payfundflowitem", (Object)defaultFundFlowId, this.getModel().getEntryCurrentRowIndex("payentity"));
            }
        } else if ("e_settleorg".equals(propertyName)) {
            DynamicObject newValue4 = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (null == newValue4 || null == oldValue || newValue4.getLong("id") != oldValue.getLong("id")) {
                this.getModel().setValue("e_corebilltype", null, rowIndex);
                this.getModel().setValue("e_corebillno", null, rowIndex);
                this.getModel().setValue("e_corebillnoinput", null, rowIndex);
                this.getModel().setValue("e_corebillentryid", null, rowIndex);
                this.getModel().setValue("e_corebillid", null, rowIndex);
                this.getModel().setValue("e_corebillentryseq", null, rowIndex);
            }
        }
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"recpaytype") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"paymenttype") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"recbasepayer") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"recpayer")) {
            String payment = (String)this.getModel().getValue("paymenttype");
            if (EmptyUtil.isNotEmpty((String)payment) && !StringUtils.equals((CharSequence)payment, (CharSequence)"other")) {
                this.getModel().setValue("paymentbasetype", (Object)payment);
                this.getModel().setValue("recbasepayer", this.getModel().getValue("recpayer"));
                Object recbasepayerDy = this.getModel().getValue("recbasepayer");
                if (EmptyUtil.isEmpty((Object)recbasepayerDy)) {
                    this.getModel().setValue("recviewpayer", null);
                } else {
                    this.getModel().setValue("recviewpayer", (Object)((DynamicObject)recbasepayerDy).getString("name"));
                }
            } else {
                this.getModel().setValue("recviewpayer", this.getModel().getValue("recpayer"));
            }
        }
    }

    private void payTypeChange(PropertyChangedArgs e) {
        DynamicObject newValueObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
        Boolean multiPaymentType = (Boolean)this.getModel().getValue("multipaymenttype");
        if (null != newValueObj && null != oldValue && !multiPaymentType.booleanValue()) {
            if (newValueObj.getBoolean("ispartpayment") && !oldValue.getBoolean("ispartpayment")) {
                this.getModel().deleteEntryData("payentity");
            }
            if (!newValueObj.getBoolean("ispartpayment") && oldValue.getBoolean("ispartpayment")) {
                this.getModel().deleteEntryData("payentity");
            }
        }
        this.setEntryAmountCaption();
        DynamicObject paytype = (DynamicObject)this.getModel().getValue("paytype");
        ComboEdit paytypeCom = (ComboEdit)this.getView().getControl("payeetype");
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
        comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
        comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
        if (!multiPaymentType.booleanValue()) {
            DynamicObjectCollection payEntries = this.getModel().getDataEntity().getDynamicObjectCollection("payentity");
            this.fillEntryType(payEntries, "e_paymenttype", newValueObj);
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        Boolean selectAllType = SystemParameterHelper.getParameterBoolean((long)((Long)org.getPkValue()), (String)"selectallpayeetype");
        if (!multiPaymentType.booleanValue() && paytype != null && paytype.getBoolean("ispartpayment") && !selectAllType.booleanValue()) {
            paytypeCom.setComboItems(comboItem);
            Object payeeType = this.getModel().getValue("payeetype");
            if ("bos_org".equals(payeeType)) {
                this.getModel().setValue("recpayee", (Object)"");
                this.getModel().setValue("recbasepayee", (Object)"");
            }
            if ("other".equals(payeeType)) {
                this.getModel().setValue("recpayee", (Object)"");
                this.getModel().setValue("recviewpayee", (Object)"");
            }
        } else {
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.ORG.getName()), ClaimPaymentTypeEnum.ORG.getValue()));
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.OTHER.getName()), ClaimPaymentTypeEnum.OTHER.getValue()));
            paytypeCom.setComboItems(comboItem);
        }
    }

    private void recPayTypeChange(PropertyChangedArgs e) {
        Object recpaytypeObj = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        DynamicObject newobject = (DynamicObject)recpaytypeObj;
        DynamicObject oldobject = (DynamicObject)oldValue;
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (newobject != null) {
            String bizType = newobject.getString("biztype");
            QFilter typeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
            QFilter orgFilter = new QFilter("org.id", "=", org.getPkValue());
            DynamicObject[] bdFinorginfo = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{typeFilter.and(orgFilter)});
            if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(bizType) && bdFinorginfo.length > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccount"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccountname"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountname"});
                this.getModel().setValue("inneraccount", null);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountname"});
            this.getModel().setValue("inneraccount", null);
        }
        Boolean multiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
        DynamicObject recpaytype = (DynamicObject)recpaytypeObj;
        if (!multiReceivingType.booleanValue()) {
            DynamicObjectCollection recEntries = this.getModel().getEntryEntity("entryentity");
            this.fillEntryType(recEntries, "e_receivingtype", recpaytype);
        }
        if (newobject != null && oldobject != null && newobject.getBoolean("ispartreceivable") == oldobject.getBoolean("ispartreceivable") && !RecBizTypeEnum.AGENT_RECEIVING.getValue().equals(newobject.getString("biztype")) && !RecBizTypeEnum.AGENT_RECEIVING.getValue().equals(oldobject.getString("biztype"))) {
            return;
        }
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.CUSTOMER.getName()), ClaimPaymentTypeEnum.CUSTOMER.getValue()));
        comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.SUPPLIER.getName()), ClaimPaymentTypeEnum.SUPPLIER.getValue()));
        comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.USER.getName()), ClaimPaymentTypeEnum.USER.getValue()));
        String paymenttype = "";
        boolean selectAllType = SystemParameterHelper.getParameterBoolean((long)((Long)org.getPkValue()), (String)"selectallpayertype");
        if (!EmptyUtil.isEmpty((Object)recpaytypeObj)) {
            boolean ispartreceivable = true;
            ComboEdit recpaytypeCbo = (ComboEdit)this.getView().getControl("paymenttype");
            if (!multiReceivingType.booleanValue() && recpaytype != null && recpaytype.getBoolean("ispartreceivable") && !selectAllType) {
                recpaytypeCbo.setComboItems(comboItem);
            } else {
                comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.ORG.getName()), ClaimPaymentTypeEnum.ORG.getValue()));
                comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.OTHER.getName()), ClaimPaymentTypeEnum.OTHER.getValue()));
                recpaytypeCbo.setComboItems(comboItem);
            }
            if (!multiReceivingType.booleanValue() && !recpaytype.getBoolean("ispartreceivable")) {
                ispartreceivable = false;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_settleorg", "e_corebillentryseq", "e_itemname", "e_material", "e_discountamt", "e_saleman"});
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entryentity"))) {
                    int entryRowCount = this.getModel().getEntryRowCount("entryentity");
                    for (int i = 0; i < entryRowCount; ++i) {
                        this.getModel().setValue("e_corebillentryseq", null, i);
                        this.getModel().setValue("e_itemname", null, i);
                        this.getModel().setValue("e_material", null, i);
                        this.getModel().setValue("e_discountamt", null, i);
                        this.getModel().setValue("e_saleman", null, i);
                        this.getModel().setValue("e_corebilltype", null, i);
                    }
                }
                paymenttype = ClaimPaymentTypeEnum.OTHER.getValue();
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_corebillno"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"e_corebillnoinput"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_settleorg", "e_corebillentryseq", "e_itemname", "e_material", "e_discountamt", "e_saleman"});
                paymenttype = ClaimPaymentTypeEnum.CUSTOMER.getValue();
                this.getView().setVisible(Boolean.TRUE, new String[]{"e_corebillno"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_corebillnoinput"});
            }
            if (!multiReceivingType.booleanValue() && RecBizTypeEnum.AGENT_RECEIVING.getValue().equals(recpaytype.getString("biztype"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_settleorg"});
            }
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entryentity"))) {
                DynamicObject recOrg = (DynamicObject)this.getModel().getValue("org");
                DynamicObject settOrg = null;
                if (EmptyUtil.isNoEmpty((DynamicObject)recOrg)) {
                    DynamicObject openOrg;
                    DynamicObject openOrgObj;
                    DynamicObject recAccount;
                    DynamicObject centerOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting");
                    if (EmptyUtil.isNoEmpty((DynamicObject)centerOrg) && centerOrg.getBoolean("fisaccounting")) {
                        settOrg = recOrg;
                    }
                    if ((recAccount = (DynamicObject)this.getModel().getValue("accountbank")) != null && !EmptyUtil.isEmpty((DynamicObject)(openOrgObj = BusinessDataServiceHelper.loadSingle((Object)(openOrg = recAccount.getDynamicObject("openorg")).getPkValue(), (String)openOrg.getDynamicObjectType().getName(), (String)"fisaccounting"))) && openOrgObj.getBoolean("fisaccounting")) {
                        settOrg = openOrg;
                    }
                }
                int entryRowCount = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue("e_corebilltype", null, i);
                    this.getModel().setValue("e_corebillno", null, i);
                    this.getModel().setValue("e_corebillnoinput", null, i);
                    this.getModel().setValue("e_corebillid", null, i);
                    this.getModel().setValue("e_corebillentryid", null, i);
                    this.getModel().setValue("e_corebillentryseq", null, i);
                    this.getModel().setValue("conbillentity", null, i);
                    this.getModel().setValue("conbillnumber", null, i);
                    this.getModel().setValue("conbillrownum", null, i);
                    this.getModel().setValue("conbillid", null, i);
                    this.getModel().setValue("conbillentryid", null, i);
                    if (!EmptyUtil.isNoEmpty((DynamicObject)settOrg) || !EmptyUtil.isEmpty((Object)this.getModel().getValue("e_settleorg", i))) continue;
                    this.getModel().setValue("e_settleorg", (Object)settOrg, i);
                }
            }
            this.rebuildCoreBillType(multiReceivingType, ispartreceivable);
        }
        String oldpaymenttype = (String)this.getModel().getValue("paymenttype");
        if (!(selectAllType || StringUtils.equals((CharSequence)ClaimPaymentTypeEnum.CUSTOMER.getValue(), (CharSequence)oldpaymenttype) || StringUtils.equals((CharSequence)ClaimPaymentTypeEnum.SUPPLIER.getValue(), (CharSequence)oldpaymenttype))) {
            this.getModel().beginInit();
            if (newobject == null || oldobject != null) {
                this.getModel().setValue("recpayer", (Object)"");
                this.getModel().setValue("recbasepayer", (Object)"");
            }
            this.getModel().setValue("paymentbasetype", (Object)(StringUtils.equals((CharSequence)"other", (CharSequence)paymenttype) ? "" : paymenttype));
            this.getModel().endInit();
            this.getModel().setValue("paymenttype", (Object)paymenttype);
            this.getView().updateView("recpayer");
            this.getView().updateView("recbasepayer");
            this.getView().updateView("paymenttype");
            this.getView().updateView("paymentbasetype");
        }
    }

    private void coreBillNoChange(PropertyChangedArgs e) {
        Object newValueObj = e.getChangeSet()[0].getNewValue();
        if (EmptyUtil.isEmpty((Object)newValueObj)) {
            int entryIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue("e_corebillid", null, entryIndex);
            this.getModel().setValue("e_corebillentryid", null, entryIndex);
            this.getModel().setValue("e_corebillentryseq", null, entryIndex);
            this.getModel().setValue("conbillentity", null, entryIndex);
            this.getModel().setValue("conbillnumber", null, entryIndex);
            this.getModel().setValue("conbillrownum", null, entryIndex);
            this.getModel().setValue("conbillid", null, entryIndex);
            this.getModel().setValue("conbillentryid", null, entryIndex);
        } else {
            boolean isHandInput;
            int currrow = e.getChangeSet()[0].getRowIndex();
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_corebillid", null, (int)currrow);
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_corebillentryid", null, (int)currrow);
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_corebillentryseq", null, (int)currrow);
            String corebilltype = (String)this.getModel().getValue("e_corebilltype", currrow);
            DynamicObject recPayType = (DynamicObject)this.getModel().getValue("recpaytype");
            boolean isPartReceivable = false;
            if (recPayType != null) {
                isPartReceivable = recPayType.getBoolean("ispartreceivable");
            }
            if (StringUtils.isEmpty((CharSequence)corebilltype)) {
                this.getModel().setValue("e_corebillno", null, currrow);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"ClaimHandleEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isMultiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
            List coreBillSettings = CoreBillSettingHelper.loadCoreBillSetting((String)"cas_claimbill", (boolean)isMultiReceivingType, (boolean)isPartReceivable);
            DynamicObject coreBillSetting = CoreBillSettingHelper.filterCoreBillSetting((List)coreBillSettings, (String)corebilltype);
            if (CasHelper.isNotEmpty((Object)coreBillSetting) && (isHandInput = coreBillSetting.getBoolean("handinput"))) {
                DynamicObject settleorg = (DynamicObject)this.getModel().getValue("e_settleorg", currrow);
                if (EmptyUtil.isEmpty((DynamicObject)settleorg)) {
                    this.getModel().setValue("e_corebillno", null, currrow);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ed3\u7b97\u7ec4\u7ec7", (String)"ClaimHandleEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map showParams = CoreBillSettingHelper.dealShowF7CustomParams((DynamicObject)coreBillSetting, (IDataModel)this.getModel(), (boolean)false);
                showParams.put("billno", newValueObj);
                showParams.put("entitynumber", corebilltype);
                CoreBillSettingHelper.setCoreBillInfo((DynamicObject)coreBillSetting, (Map)showParams, (IFormView)this.getView(), (int)currrow, (boolean)false);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tradedetailno"});
        this.addClickListeners(new String[]{"e_corebillno", "e_corebillnoinput"});
        this.initF7();
        this.setFinAccF7Filter();
        Control entryentity1 = this.getView().getControl("detailentryentity");
        Control entryentity2 = this.getView().getControl("ticketentryentity");
        EntryGrid entry1 = (EntryGrid)entryentity1;
        EntryGrid entry2 = (EntryGrid)entryentity2;
        entry1.addHyperClickListener((HyperLinkClickListener)this);
        entry2.addHyperClickListener((HyperLinkClickListener)this);
        Control entryentity = this.getView().getControl("entryentity");
        EntryGrid entry = (EntryGrid)entryentity;
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initF7() {
        this.fillSettleOrg();
        this.fillRecPayType();
        this.fillPayOrg();
        this.fillRecBasePayer();
        this.fillReceivingPayType();
    }

    private void fillReceivingPayType() {
        String businessType = (String)this.getModel().getValue("businesstype");
        if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) {
            Boolean multiPaymentType = (Boolean)this.getModel().getValue("multipaymenttype");
            BasedataEdit payType = (BasedataEdit)this.getControl("paytype");
            BasedataEdit ePaymentType = (BasedataEdit)this.getControl("e_paymenttype");
            payType.addBeforeF7SelectListener(evt -> {
                if (!multiPaymentType.booleanValue()) {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    QFilter qFilter = new QFilter("biztype", "!=", (Object)"110");
                    showParameter.getListFilterParameter().setFilter(qFilter);
                } else {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    QFilter qFilter = new QFilter("biztype", "=", (Object)"110");
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            });
            ePaymentType.addBeforeF7SelectListener(evt -> {
                if (multiPaymentType.booleanValue()) {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    QFilter qFilter = new QFilter("biztype", "!=", (Object)"110");
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            });
        } else {
            Boolean multiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
            BasedataEdit recPayType = (BasedataEdit)this.getControl("recpaytype");
            BasedataEdit eReceivingType = (BasedataEdit)this.getControl("e_receivingtype");
            recPayType.addBeforeF7SelectListener(evt -> {
                if (!multiReceivingType.booleanValue()) {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    QFilter qFilter = new QFilter("biztype", "!=", (Object)"110");
                    showParameter.getListFilterParameter().setFilter(qFilter);
                } else {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    QFilter qFilter = new QFilter("biztype", "=", (Object)"110");
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            });
            eReceivingType.addBeforeF7SelectListener(evt -> {
                if (multiReceivingType.booleanValue()) {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    QFilter qFilter = new QFilter("biztype", "!=", (Object)"110");
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            });
        }
    }

    private void fillRecBasePayer() {
        BasedataEdit recbasepayer = (BasedataEdit)this.getControl("recbasepayer");
        recbasepayer.addBeforeF7SelectListener(evt -> {
            String paymenttype = this.getString("paymenttype");
            if (StringUtils.isBlank((CharSequence)paymenttype)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba\u7c7b\u578b", (String)"ClaimNoticeEditPlugin_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
        });
    }

    private void fillPayOrg() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("recbasepayer");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Object paymentbasetype = this.getModel().getValue("paymentbasetype");
            if (EmptyUtil.isNoEmpty((Object)paymentbasetype) && StringUtils.equals((CharSequence)"bos_org", (CharSequence)paymentbasetype.toString())) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                qFilter.and(new QFilter("fisbankroll", "=", (Object)"1"));
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void fillRecPayType() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("recpaytype");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Object businessType = this.getModel().getValue("businesstype");
            if (EmptyUtil.isNoEmpty((Object)businessType) && "recticket".equals(businessType.toString())) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("biztype", "!=", (Object)PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue());
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void fillSettleOrg() {
        BasedataEdit settleorg = (BasedataEdit)this.getControl("e_settleorg");
        settleorg.addBeforeF7SelectListener(select -> {
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            showParam.setCustomParam("orgFuncId", (Object)"10");
        });
    }

    private void setFinAccF7Filter() {
        BasedataEdit finAcc = (BasedataEdit)this.getControl("inneraccount");
        finAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara;
            DynamicObject orgId;
            QFilter innerAccQFilter = new QFilter("acctclassify", "=", (Object)"I");
            innerAccQFilter.and(new QFilter("acctstatus", "!=", (Object)"closed"));
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency != null) {
                innerAccQFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            }
            if ((orgId = (DynamicObject)this.getModel().getValue("org")) != null) {
                innerAccQFilter.and(new QFilter("bank.org.id", "=", orgId.getPkValue()));
            }
            if (CasHelper.isNotEmpty((Object)(showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter()))) {
                showPara.setCustomParam("isclearcorefilter", (Object)"true");
                showPara.getListFilterParameter().setFilter(innerAccQFilter);
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)"e_corebillno", (CharSequence)key) || StringUtils.equals((CharSequence)"e_corebillnoinput", (CharSequence)key)) {
            this.showCoreBillF7();
        } else if (StringUtils.equals((CharSequence)"tradedetailno", (CharSequence)key)) {
            String businesstype = (String)this.getModel().getValue("businesstype");
            String billno = (String)this.getModel().getValue("tradedetailno");
            QFilter billnoQf = new QFilter("recticket".equals(businesstype) ? "draftbillno" : "billno", "=", (Object)billno);
            String entity = "recticket".equals(businesstype) ? "cdm_receivablebill" : "bei_transdetail_cas";
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)entity, (String)"id", (QFilter[])new QFilter[]{billnoQf});
            if ("recticket".equals(businesstype)) {
                if (ids.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6b64\u5e94\u6536\u7968\u636e\uff0c\u8bf7\u68c0\u67e5\u8be5\u5355\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (ids.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6536\u4ed8\u5904\u7406\u5355\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u8be5\u5355\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            String claimNo = (String)this.getModel().getValue("claimno");
            QFilter claimNoQ = new QFilter("billno", "=", (Object)claimNo);
            DynamicObject[] colls = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,sourceid", (QFilter[])new QFilter[]{claimNoQ});
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(entity);
            showParameter.setPkId(colls[0].get("sourceid"));
            showParameter.setCustomParam("onlyView", (Object)"onlyView");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void showCoreBillF7() {
        DynamicObject coreBillSetting;
        int currrow = this.getModel().getEntryCurrentRowIndex("entryentity");
        String corebilltype = (String)this.getModel().getValue("e_corebilltype", currrow);
        String businessType = (String)this.getModel().getValue("businesstype");
        DynamicObject recPayType = (DynamicObject)this.getModel().getValue("recpaytype");
        boolean isPartReceivable = false;
        if (recPayType != null) {
            isPartReceivable = recPayType.getBoolean("ispartreceivable");
        }
        if (StringUtils.isEmpty((CharSequence)corebilltype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"ClaimHandleEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isMultiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
        List coreBillSettings = CoreBillSettingHelper.loadCoreBillSetting((String)"cas_claimbill", (boolean)isMultiReceivingType, (boolean)isPartReceivable);
        Set coreNumbers = CoreBillSettingHelper.getNumberBySetting((List)coreBillSettings);
        if (EmptyUtil.isEmpty((String)ClaimCoreBillTypeEnum.getName((String)corebilltype)) && !coreNumbers.contains(corebilltype)) {
            return;
        }
        Set billList = Stream.of(ClaimCoreBillTypeEnum.FINARBILL.getValue(), ClaimCoreBillTypeEnum.SALORDER.getValue(), ClaimCoreBillTypeEnum.GLREIMBILL.getValue(), ClaimCoreBillTypeEnum.GLREIMRECBILL.getValue(), ClaimCoreBillTypeEnum.SALCONTRACT.getValue(), ClaimCoreBillTypeEnum.MSCON_PERFORMPLANIN.getValue()).collect(Collectors.toSet());
        billList.addAll(coreNumbers);
        DynamicObject settleorg = (DynamicObject)this.getModel().getValue("e_settleorg", currrow);
        if (EmptyUtil.isEmpty((DynamicObject)settleorg) && (billList.contains(corebilltype) || Arrays.asList("recticket", "rec").contains(businessType) && isPartReceivable && StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.PAYBILL.getValue()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ed3\u7b97\u7ec4\u7ec7", (String)"ClaimHandleEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Boolean claimComtrol = (Boolean)this.getModel().getValue("claimcomtrol", currrow);
        String claimDimenSion = (String)this.getModel().getValue("claimdimension", currrow);
        if (claimComtrol.booleanValue() && CasHelper.isNotEmpty((Object)claimDimenSion)) {
            QFilter qFilter = new QFilter("org.id", "=", settleorg.getPkValue());
            DynamicObject[] arInit = BusinessDataServiceHelper.load((String)"ar_init", (String)"id,org,settlemodel", (QFilter[])new QFilter[]{qFilter});
            Boolean dsBool = false;
            if (CasHelper.isNotEmpty((Object)arInit) && arInit.length > 0) {
                String settleModel = arInit[0].getString("settlemodel");
                if ("ar_finarbill_planlayout".equals(claimDimenSion) && "1".equals(settleModel) || "ar_finarbill_detaillayout".equals(claimDimenSion) && "2".equals(settleModel)) {
                    dsBool = true;
                }
            } else {
                dsBool = true;
            }
            if (dsBool.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba4\u9886\u7ef4\u5ea6\u4e0e\u5e94\u6536\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u8ba4\u9886\u7ef4\u5ea6\u6216\u5173\u95ed\u8ba4\u9886\u9884\u5360\u63a7\u5236\u3002", (String)"ClaimHandleEditPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (CasHelper.isNotEmpty((Object)claimDimenSion)) {
            corebilltype = claimDimenSion;
        }
        String showFormId = corebilltype;
        if (ClaimCoreBillTypeEnum.MSCON_PERFORMPLANIN.getValue().equals(corebilltype)) {
            showFormId = "mscon_performin_casf7";
        }
        if (CasHelper.isNotEmpty((Object)(coreBillSetting = CoreBillSettingHelper.filterCoreBillSetting((List)coreBillSettings, (String)corebilltype)))) {
            this.getPageCache().put("CORE_BILL_SETTING", SerializeHelper.serializeDynamicObj((Object)coreBillSetting));
            showFormId = coreBillSetting.getString("formid");
        } else {
            this.getPageCache().remove("CORE_BILL_SETTING");
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)showFormId, (boolean)true, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        List<QFilter> coreBillFilters = this.getCoreBillFilter(corebilltype, settleorg, currency);
        if (!coreBillFilters.isEmpty()) {
            lfp.setQFilters(coreBillFilters);
        }
        if (StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.GLREIMBILL.getValue()) || StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.GLREIMRECBILL.getValue())) {
            lfp.setFilter(new QFilter("accountingorg", "=", settleorg.getPkValue()));
            lfp.setFilter(new QFilter("castorecamount", ">=", (Object)0));
        }
        if (StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.GLREIMBILL.getValue()) || StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.GLREIMRECBILL.getValue())) {
            lfp.setFilter(new QFilter("billstatus", "=", (Object)"D"));
        } else if (StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.REPAYMENTBILL.getValue())) {
            lfp.setFilter(new QFilter("billstatus", "=", (Object)"E"));
        } else if (ClaimCoreBillTypeEnum.CAS_AGENT_PAY_BILL.getValue().equals(corebilltype)) {
            lfp.setSelectEntity("entry");
            lsp.setCustomParam("isEntryMain", (Object)Boolean.TRUE);
            lsp.addCustPlugin("kd.fi.cas.formplugin.agentpay.AgentCoreBillF7ListPlugin");
            IDataModel model = this.getModel();
            lfp.setFilter(new QFilter("payeracctbank", "=", (Object)this.getPk("accountbank")));
            lfp.setFilter(new QFilter("currency", "=", (Object)this.getPk("currency")));
            Date tradeTime = (Date)model.getValue("tradetime");
            Date maxTimeDate = DateUtils.getDateWithMaxTime((Date)tradeTime);
            lfp.setFilter(new QFilter("bizdate", "<=", (Object)maxTimeDate));
            lfp.setFilter(new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()));
            lfp.setFilter(new QFilter("entry.e_isrefund", "=", (Object)"0"));
            lfp.setFilter(new QFilter("entry.e_issuccess", "=", (Object)"1"));
            lfp.setFilter(new QFilter("entry.e_isrepaid", "=", (Object)"0"));
        } else if (!ClaimCoreBillTypeEnum.MSCON_PERFORMPLANIN.getValue().equals(corebilltype) && !coreNumbers.contains(corebilltype)) {
            lfp.setFilter(new QFilter("billstatus", "=", (Object)"C"));
        }
        this.setIFilters(lfp, this.getModel());
        if (CasHelper.isNotEmpty((Object)coreBillSetting)) {
            Map showParams = CoreBillSettingHelper.dealShowF7CustomParams((DynamicObject)coreBillSetting, (IDataModel)this.getModel(), (boolean)false);
            lsp.setCustomParams(showParams);
        }
        if (ClaimCoreBillTypeEnum.MSCON_PERFORMPLANIN.getValue().equals(corebilltype)) {
            lsp.setCustomParam("settleOrg", settleorg.getPkValue());
            lsp.setCustomParam("payer", (Object)this.getPk("recbasepayer"));
        }
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.setListFilterParameter(lfp);
        if (ClaimCoreBillTypeEnum.SALCONTRACT.getValue().equals(corebilltype)) {
            lfp.setSelectEntity("payentry");
        } else if (ClaimCoreBillTypeEnum.SALORDER.getValue().equals(corebilltype)) {
            lfp.setSelectEntity("recplanentry");
        } else if (ClaimCoreBillTypeEnum.FINARBILL.getValue().equals(corebilltype)) {
            lfp.setSelectEntity("entry");
        } else if ("ar_finarbill_planlayout".equals(corebilltype)) {
            lsp.setSelectedEntity("planentity");
        }
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.setListFilterParameter(lfp);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "e_corebillno");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<QFilter> getCoreBillFilter(String coreBillType, DynamicObject settleorg, DynamicObject currency) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(8);
        if (coreBillType.startsWith(ClaimCoreBillTypeEnum.FINARBILL.getValue())) {
            list.add(new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"}));
            list.add(new QFilter("org", "=", settleorg.getPkValue()));
            list.add(new QFilter("currency", "=", currency.getPkValue()));
            if ("ar_finarbill_planlayout".equals(coreBillType)) {
                list.add(new QFilter("planentity.unplanlockamt", "!=", (Object)BigDecimal.ZERO));
            } else if ("ar_finarbill_detaillayout".equals(coreBillType)) {
                list.add(new QFilter("entry.e_unlockamt", "!=", (Object)BigDecimal.ZERO));
            }
        }
        if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.SALORDER.getValue())) {
            DynamicObject org;
            String appId = AppMetadataCache.getAppInfo((String)"ar").getId();
            boolean isAutoCreateBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"10", (Long)(org = (DynamicObject)this.getModel().getValue("org")).getLong("id"), (String)"ar_011");
            if (isAutoCreateBill) {
                list.add(new QFilter("paymode", "=", (Object)"CREDIT"));
            } else {
                list.add(new QFilter("paymode", "in", (Object)new String[]{"CREDIT", "CASH"}));
            }
            list.add(new QFilter("billentry.entrysettleorg", "=", settleorg.getPkValue()));
            Object recpayer = this.getModel().getValue("recpayer");
            list.add(new QFilter("customer", "=", (Object)(!ObjectUtils.isEmpty((Object)recpayer) ? Long.parseLong(recpayer.toString()) : 0L)));
            list.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            list.add(new QFilter("changestatus", "<>", (Object)"B"));
            list.add(QFilter.of((String)" receiptamount < totalallamount ", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.SALCONTRACT.getValue())) {
            list.add(new QFilter("billentry.entrysettleorg", "=", settleorg.getPkValue()));
            Object recpayer1 = this.getModel().getValue("recpayer");
            list.add(new QFilter("customer", "=", (Object)(!ObjectUtils.isEmpty((Object)recpayer1) ? Long.parseLong(recpayer1.toString()) : 0L)));
            list.add(new QFilter("validstatus", "<>", (Object)"A"));
            list.add(new QFilter("changestatus", "<>", (Object)"B"));
            list.add(QFilter.of((String)" receiptallamount < totalallamount ", (Object[])new Object[0]));
        }
        return list;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("e_corebillno".equals(e.getActionId()) || "e_corebillnoinput".equals(e.getActionId())) {
            Object returnData = e.getReturnData();
            if (!CasHelper.isEmpty((Object)returnData)) {
                IDataModel model = this.getModel();
                int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
                String coreBillType = (String)model.getValue("e_corebilltype", currentRowIndex);
                String coreBillSettingStr = this.getPageCache().get("CORE_BILL_SETTING");
                DynamicObject coreBillSetting = null;
                if (CasHelper.isNotEmpty((Object)coreBillSettingStr)) {
                    coreBillSetting = SerializeHelper.deserializeDynamicObj((String)"cas_corebill_setting", (String)coreBillSettingStr);
                }
                if (coreBillSetting != null) {
                    this.coreBillSettingClosedCallBack(returnData, model, coreBillType, currentRowIndex, coreBillSetting);
                } else {
                    this.srcDealClosedCallBack(returnData, model, coreBillType, currentRowIndex);
                }
            }
        } else if ("cas_entryimport".equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            logger.info("EntryImport >> Data>> " + SerializationUtils.toJsonString((Object)returnData));
            this.entryImportDataHandler(returnData);
        }
    }

    private void coreBillSettingClosedCallBack(Object returnData, IDataModel model, String coreBillType, int currentRowIndex, DynamicObject coreBillSetting) {
        List coreBillCollection = (List)returnData;
        int entryRowCount = model.getEntryRowCount("entryentity");
        int followingRowCount = entryRowCount - currentRowIndex - 1;
        if (coreBillCollection.size() - 1 > followingRowCount) {
            model.appendEntryRow("entryentity", entryRowCount - 1, coreBillCollection.size() - 1 - followingRowCount);
        }
        DynamicObject settleorg = (DynamicObject)model.getValue("e_settleorg", currentRowIndex);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam("isSelectCoreBillNo", (Object)"true");
        for (int i = 0; i < coreBillCollection.size(); ++i) {
            Map selectedRow = (Map)coreBillCollection.get(i);
            int rowIndex = currentRowIndex + i;
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_settleorg", (Object)settleorg, (int)rowIndex);
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_corebilltype", (Object)coreBillType, (int)rowIndex);
            if (selectedRow.containsKey("e_corebillno")) {
                ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_corebillnoinput", selectedRow.get("e_corebillno"), (int)rowIndex);
            }
            CoreBillSettingHelper.setClosedCallBackInfo((Map)selectedRow, (DynamicObject)coreBillSetting, (IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIndex);
        }
    }

    private void srcDealClosedCallBack(Object returnData, IDataModel model, String coreBillType, int currentRowIndex) {
        Boolean claimComtrol = (Boolean)this.getModel().getValue("claimcomtrol", currentRowIndex);
        String claimDimenSion = (String)this.getModel().getValue("claimdimension", currentRowIndex);
        ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)returnData;
        int entryRowCount = model.getEntryRowCount("entryentity");
        int followingRowCount = entryRowCount - currentRowIndex - 1;
        if (coreBillCollection.size() - 1 > followingRowCount) {
            model.appendEntryRow("entryentity", entryRowCount - 1, coreBillCollection.size() - 1 - followingRowCount);
        }
        DynamicObject settleorg = (DynamicObject)model.getValue("e_settleorg", currentRowIndex);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam("isSelectCoreBillNo", (Object)"true");
        HashSet<Long> actSet = new HashSet<Long>(coreBillCollection.size());
        HashSet<Long> entryIdSet = new HashSet<Long>();
        String entryEntityKey = "";
        for (ListSelectedRow listSelectedRow : coreBillCollection) {
            entryEntityKey = listSelectedRow.getEntryEntityKey();
            Object entryPKValue = listSelectedRow.getEntryPrimaryKeyValue();
            if (entryPKValue != null) {
                entryIdSet.add((Long)entryPKValue);
            }
            actSet.add((Long)listSelectedRow.getPrimaryKeyValue());
        }
        PluginProxy pluginProxy = PluginProxy.create(IClaimHandlePluginSDK.class, (String)"kd.sdk.fi.cas.extpoint.claimbill.IClaimHandlePluginSDK");
        HashMap entryId_Seq = new HashMap();
        if (entryIdSet.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(entryEntityKey).append(".id,").append(entryEntityKey).append(".seq");
            String finalEntryEntityKey = entryEntityKey;
            String finalSelectField = sb.toString();
            HashSet extFieldSet = new HashSet(10);
            List extField = pluginProxy.callReplace(p -> p.getSelectFieldWithEntry(coreBillType, finalEntryEntityKey, finalSelectField));
            if (EmptyUtil.isNoEmpty((Object)extField) && extField.size() > 0 && EmptyUtil.isNoEmpty(extField.get(0))) {
                extFieldSet.addAll((Collection)extField.get(0));
                for (String oneField : (Set)extField.get(0)) {
                    sb.append(',').append(oneField);
                }
            }
            QFilter[] filters = new QFilter[]{new QFilter(entryEntityKey + ".id", "in", entryIdSet)};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryEntry", (String)coreBillType, (String)sb.toString(), (QFilter[])filters, null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Long entryId = row.getLong(entryEntityKey + ".id");
                    HashMap<String, Object> value = new HashMap<String, Object>(2);
                    value.put(entryEntityKey + ".seq", row.getString(entryEntityKey + ".seq"));
                    for (String field : extFieldSet) {
                        value.put(field, row.get(field));
                    }
                    entryId_Seq.put(entryId, value);
                }
            }
        }
        pluginProxy.callReplace(p -> {
            p.fillResult(coreBillType, actSet, entryId_Seq);
            return null;
        });
        for (int i = 0; i < coreBillCollection.size(); ++i) {
            boolean isSelectEntry;
            String seq;
            ListSelectedRow listSelectedRow = coreBillCollection.get(i);
            Long entryPKValue = (Long)listSelectedRow.getEntryPrimaryKeyValue();
            DynamicObject rowData = (DynamicObject)model.getEntryEntity("entryentity").get(currentRowIndex + i);
            rowData.set("e_settleorg", (Object)settleorg);
            rowData.set("e_corebilltype", (Object)coreBillType);
            model.setValue("e_corebillno", (Object)listSelectedRow.getBillNo(), currentRowIndex + i);
            model.setValue("e_corebillnoinput", (Object)listSelectedRow.getBillNo(), currentRowIndex + i);
            model.setValue("e_corebillid", listSelectedRow.getPrimaryKeyValue(), currentRowIndex + i);
            rowData.set("e_corebillno", (Object)listSelectedRow.getBillNo());
            rowData.set("e_corebillnoinput", (Object)listSelectedRow.getBillNo());
            rowData.set("e_corebillid", listSelectedRow.getPrimaryKeyValue());
            rowData.set("claimcomtrol", (Object)claimComtrol);
            rowData.set("claimdimension", (Object)claimDimenSion);
            if (EmptyUtil.isNoEmpty(entryId_Seq.get(entryPKValue)) && EmptyUtil.isNoEmpty((String)(seq = (String)((Map)entryId_Seq.get(entryPKValue)).get(entryEntityKey + ".seq")))) {
                model.setValue("e_corebillentryseq", (Object)seq, currentRowIndex + i);
                rowData.set("e_corebillentryseq", (Object)seq);
            }
            boolean bl = isSelectEntry = !StringUtils.isEmpty((CharSequence)entryEntityKey) && !ObjectUtils.isEmpty((Object)entryPKValue);
            if (isSelectEntry) {
                rowData.set("e_corebillentryid", (Object)entryPKValue);
            } else {
                rowData.set("e_corebillentryid", null);
                rowData.set("e_corebillentryseq", null);
            }
            if (ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType) || ClaimCoreBillTypeEnum.SALCONTRACT.getValue().equals(coreBillType)) {
                DynamicObject queryInfo;
                List<String> conGroupFields;
                boolean isMaterialEntry;
                boolean isSalOrder = ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType);
                boolean bl2 = isMaterialEntry = !StringUtils.isEmpty((CharSequence)entryEntityKey) && "billentry".equals(entryEntityKey);
                if (isSelectEntry && isMaterialEntry) {
                    conGroupFields = isSalOrder ? Arrays.asList(entryEntityKey + ".conbillnumber", entryEntityKey + ".conbillrownum", entryEntityKey + ".conbillid", entryEntityKey + ".conbillentryid") : Arrays.asList("id", "billno", entryEntityKey + ".lineno", entryEntityKey + ".id");
                    QFilter[] filters = new QFilter[]{new QFilter(entryEntityKey + ".id", "=", (Object)entryPKValue)};
                    queryInfo = QueryServiceHelper.queryOne((String)coreBillType, (String)String.join((CharSequence)",", conGroupFields), (QFilter[])filters);
                    if (queryInfo != null) {
                        rowData.set("conbillentity", (Object)"conm_salcontract");
                        rowData.set("conbillnumber", (Object)(isSalOrder ? queryInfo.getString(entryEntityKey + ".conbillnumber") : queryInfo.getString("billno")));
                        rowData.set("conbillrownum", (Object)(isSalOrder ? queryInfo.getString(entryEntityKey + ".conbillrownum") : queryInfo.getString(entryEntityKey + ".lineno")));
                        rowData.set("conbillid", (Object)(isSalOrder ? queryInfo.getLong(entryEntityKey + ".conbillid") : queryInfo.getLong("id")));
                        rowData.set("conbillentryid", (Object)(isSalOrder ? queryInfo.getLong(entryEntityKey + ".conbillentryid") : queryInfo.getLong(entryEntityKey + ".id")));
                    }
                } else {
                    conGroupFields = isSalOrder ? Arrays.asList("billentry.conbillnumber", "billentry.conbillrownum", "billentry.conbillid", "billentry.conbillentryid") : Arrays.asList("id", "billno", "billentry.id");
                    QFilter filter = new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue());
                    queryInfo = QueryServiceHelper.queryOne((String)coreBillType, (String)String.join((CharSequence)",", conGroupFields), (QFilter[])new QFilter[]{filter});
                    if (queryInfo != null) {
                        rowData.set("conbillnumber", (Object)(isSalOrder ? queryInfo.getString("billentry.conbillnumber") : queryInfo.getString("billno")));
                        rowData.set("conbillid", (Object)(isSalOrder ? queryInfo.getLong("billentry.conbillid") : queryInfo.getLong("id")));
                        rowData.set("conbillentity", (Object)"conm_salcontract");
                        rowData.set("conbillrownum", (Object)"");
                        if (!isSalOrder) {
                            rowData.set("conbillentryid", (Object)entryPKValue);
                        }
                    }
                }
            }
            pluginProxy.callReplace(p -> {
                p.dealResult(entryId_Seq, rowData);
                return null;
            });
            model.getEntryEntity("entryentity").set(currentRowIndex + i, (Object)rowData);
        }
        this.getModel().updateEntryCache(model.getEntryEntity("entryentity"));
        this.getView().updateView("entryentity");
    }

    private void entryImportDataHandler(Map<String, Object> returnData) {
        Object imptMethod = returnData.get("imptmethod");
        if (imptMethod != null && "cover".equals(imptMethod)) {
            this.getModel().deleteEntryData("entryentity");
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        String businessType = (String)this.getModel().getValue("businesstype");
        Boolean multiType = true;
        if (Arrays.asList(BusinessTypeEnum.REC.getName(), BusinessTypeEnum.REC.getValue(), BusinessTypeEnum.RECTICKET.getName(), BusinessTypeEnum.RECTICKET.getValue()).contains(businessType)) {
            multiType = (Boolean)this.getModel().getValue("multireceivingtype");
        }
        if (entryentity != null && entryentity.size() > 0) {
            Boolean flag = true;
            Set claimbillFields = EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"entryentity");
            for (int i = entryentity.size() - 1; i >= 0; --i) {
                for (String claimbillField : claimbillFields) {
                    Object filedValue = ((DynamicObject)entryentity.get(i)).get(claimbillField);
                    if (filedValue == null || "".equals(filedValue) || "0".equals(String.valueOf(filedValue)) || "0.00".equals(String.valueOf(filedValue)) || "e_settleorg".equals(claimbillField) || "e_receivingtype".equals(claimbillField) || "claimcomtrol".equals(claimbillField) || filedValue instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)filedValue) == 0) continue;
                    flag = false;
                    break;
                }
                if (flag.booleanValue()) {
                    this.getModel().deleteEntryRow("entryentity", i);
                    this.getView().updateView("entryentity");
                    continue;
                }
                flag = true;
            }
        }
        entryentity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            if (multiType.booleanValue()) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_receivingtype"});
        }
        List rowDatas = (List)returnData.get("rowDatas");
        StringBuilder errorInfo = new StringBuilder();
        this.getModel().beginInit();
        for (int rowNum = 0; rowNum < rowDatas.size(); ++rowNum) {
            Map row = (Map)rowDatas.get(rowNum);
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) {
                Boolean multiPaymentType = (Boolean)this.getModel().getValue("multipaymenttype");
                if (!multiPaymentType.booleanValue()) {
                    DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("paytype");
                    this.getModel().setValue("e_paymenttype", (Object)dynamicObject, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_paymenttype"});
                }
            } else {
                DynamicObject dynamicObject;
                Boolean multiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
                if (!multiReceivingType.booleanValue()) {
                    DynamicObject dynamicObject2 = (DynamicObject)this.getModel().getValue("recpaytype");
                    this.getModel().setValue("e_receivingtype", (Object)dynamicObject2, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_receivingtype"});
                }
                if ((dynamicObject = this.getModel().getEntryRowEntity("entryentity", rowIndex).getDynamicObject("e_receivingtype")) != null) {
                    DynamicObject defaultFundFlow = dynamicObject.getDynamicObject("fundflowitem");
                    this.getModel().setValue("e_fundflowitem", defaultFundFlow == null ? null : Long.valueOf(defaultFundFlow.getLong("id")), rowIndex);
                }
            }
            try {
                for (Map.Entry entry : row.entrySet()) {
                    String keyName;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (value == null || "".equals(value.trim())) continue;
                    IDataEntityProperty property = null;
                    if (key.contains(".number")) {
                        String keyNum = key.replace(".number", "");
                        property = this.getModel().getProperty(keyNum);
                    } else if (key.contains(".name")) {
                        keyName = key.replace(".name", "");
                        property = this.getModel().getProperty(keyName);
                    } else if (key.contains(".")) {
                        keyName = key.substring(0, key.indexOf("."));
                        property = this.getModel().getProperty(keyName);
                    } else {
                        property = this.getModel().getProperty(key);
                    }
                    if (property == null) continue;
                    if ("e_remark".equals(key)) {
                        TextAreaProp text = new TextAreaProp();
                        if (property instanceof TextAreaProp) {
                            text = (TextAreaProp)property;
                        }
                        if (text.getMaxLenth() > 0 && value != null && value.length() > text.getMaxLenth()) {
                            value = value.substring(0, text.getMaxLenth());
                            String agentPayBillEdit_16 = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s \u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236, \u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206!", (String)"ClaimHandleEditPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                            errorInfo.append(agentPayBillEdit_16);
                        }
                    }
                    if (property instanceof AmountProp || property instanceof DecimalProp) {
                        BigDecimal amount = BigDecimal.ZERO;
                        try {
                            amount = new BigDecimal(value);
                            this.getModel().setValue(key, (Object)amount, rowIndex);
                            if (!"e_receivableamt".equals(key)) continue;
                            BigDecimal receivableamt = new BigDecimal((String)row.get("e_receivableamt"));
                            String e_discountamt = (String)row.get("e_discountamt");
                            String e_fee = (String)row.get("e_fee");
                            BigDecimal discountamt = BigDecimal.ZERO;
                            Object fee = BigDecimal.ZERO;
                            if (e_discountamt != null && !"".equals(e_discountamt)) {
                                discountamt = new BigDecimal(e_discountamt);
                            }
                            if (e_fee != null && !"".equals(e_fee)) {
                                fee = new BigDecimal(e_fee);
                            }
                            this.getModel().setValue("e_actamt", (Object)receivableamt.subtract(discountamt).subtract((BigDecimal)fee), rowIndex);
                            continue;
                        }
                        catch (Exception e) {
                            this.getModel().deleteEntryRow("entryentity", rowIndex);
                            String agentPayBillEdit_18 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u5b57\u6bb5\uff0c\u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"ClaimHandleEditPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                            errorInfo.append(agentPayBillEdit_18);
                            break;
                        }
                    }
                    if (property instanceof BasedataProp) {
                        if (row.get(key) == null) continue;
                        String enity = null;
                        String name = "name";
                        String number = "number";
                        String enable = "enable";
                        Boolean flag = true;
                        switch (key) {
                            case "e_settleorg.name": 
                            case "e_settleorg.number": {
                                enity = "bos_org";
                                break;
                            }
                            case "e_itemname.name": 
                            case "e_itemname.number": {
                                enity = "bos_assistantdata_detail";
                                break;
                            }
                            case "e_material.name": 
                            case "e_material.number": {
                                enity = "bd_material";
                                break;
                            }
                            case "e_project.name": 
                            case "e_project.number": {
                                enity = "bd_project";
                                break;
                            }
                            case "e_fundflowitem.name": 
                            case "e_fundflowitem.number": {
                                enity = "cas_fundflowitem";
                                break;
                            }
                            case "e_saleman.name": 
                            case "e_saleman.number": 
                            case "e_saleman.operatornumber": 
                            case "e_saleman.operatorname": {
                                enity = "bd_operator";
                                name = "operatorname";
                                number = "operatornumber";
                                enable = "invalid";
                                flag = false;
                            }
                        }
                        if (this.CustomSetBaseData(key, rowIndex)) continue;
                        DynamicObject payeeNameDyms = null;
                        if (enity != null) {
                            payeeNameDyms = key.contains(".number") || key.contains(".operatornumber") ? BusinessDataServiceHelper.loadSingle((String)enity, (String)("id," + number + ',' + name), (QFilter[])new QFilter[]{new QFilter(number, "=", (Object)value), new QFilter(enable, "=", (Object)flag)}) : BusinessDataServiceHelper.loadSingle((String)enity, (String)("id," + number + ',' + name), (QFilter[])new QFilter[]{new QFilter(name, "=", (Object)value), new QFilter(enable, "=", (Object)flag)});
                            if (payeeNameDyms == null) {
                                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s \u5b57\u6bb5,\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u3002\n", (String)"ClaimHandleEditPlugin_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), key));
                                this.getModel().deleteEntryRow("entryentity", rowIndex);
                                break;
                            }
                            if (key.contains(".number") || key.contains(".operatornumber")) {
                                String fileName = key.contains(".number") ? key.replace(".number", "") : key.replace(".operatornumber", "");
                                this.getModel().setValue(fileName, payeeNameDyms.getPkValue(), rowIndex);
                                continue;
                            }
                            String fileName = key.contains(".name") ? key.replace(".name", "") : key.replace(".operatorname", "");
                            this.getModel().setValue(fileName, payeeNameDyms.getPkValue(), rowIndex);
                            continue;
                        }
                        if (property instanceof ItemClassProp) continue;
                        enity = ((BasedataProp)property).getBaseEntityId();
                        if (key.contains(".")) {
                            int i = key.indexOf(".");
                            String fileName = key.substring(i + 1);
                            payeeNameDyms = BusinessDataServiceHelper.loadSingle((String)enity, (String)("id," + number + ',' + name), (QFilter[])new QFilter[]{new QFilter(fileName, "=", (Object)value), new QFilter(enable, "=", (Object)flag)});
                        }
                        if (payeeNameDyms == null) {
                            errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s \u5b57\u6bb5,\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u3002\n", (String)"ClaimHandleEditPlugin_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), key));
                            this.getModel().deleteEntryRow("entryentity", rowIndex);
                            break;
                        }
                        if (!key.contains(".")) continue;
                        String fileName = key.substring(0, key.indexOf("."));
                        this.getModel().setValue(fileName, payeeNameDyms.getPkValue(), rowIndex);
                        continue;
                    }
                    if (property instanceof ItemClassTypeProp) continue;
                    if ("e_corebillno".equals(key) || "e_corebilltype".equals(key)) {
                        String e_corebilltype = (String)row.get("e_corebilltype");
                        if (e_corebilltype == null || "".equals(e_corebilltype)) {
                            errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c:\u82e5\u9700\u8981\u5bfc\u5165\u6838\u5fc3\u5355\u636e\u7f16\u53f7,\u8bf7\u5148\u586b\u5199\u6838\u5fc3\u5355\u636e\u7c7b\u578b\n", (String)"ClaimHandleEditPlugin_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow")));
                            this.getModel().deleteEntryRow("entryentity", rowIndex);
                            break;
                        }
                        switch (e_corebilltype) {
                            case "\u8d22\u52a1\u5e94\u6536\u5355": {
                                e_corebilltype = "ar_finarbill";
                                break;
                            }
                            case "\u9500\u552e\u8ba2\u5355": {
                                e_corebilltype = "sm_salorder";
                                break;
                            }
                            case "\u9500\u552e\u5408\u540c": {
                                e_corebilltype = "conm_salcontract";
                                break;
                            }
                            case "\u4ed8\u6b3e\u5355": {
                                e_corebilltype = "cas_paybill";
                                break;
                            }
                            case "\u603b\u8d26\u62a5\u8d26\u5355": {
                                e_corebilltype = "fr_glreim_bill";
                                break;
                            }
                            case "\u603b\u8d26\u6536\u6b3e\u5355": {
                                e_corebilltype = "fr_glreim_recbill";
                            }
                        }
                        if ("e_corebilltype".equals(key)) {
                            this.getModel().setValue(key, (Object)e_corebilltype, rowIndex);
                            break;
                        }
                        DynamicObject corebill = BusinessDataServiceHelper.loadSingle((String)e_corebilltype, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)value)});
                        if (corebill == null) {
                            errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: \u4e0d\u5b58\u5728\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a %2$s, \u6838\u5fc3\u5355\u636e\u7f16\u53f7\u4e3a %3$s \u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u3002\n", (String)"ClaimHandleEditPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), row.get("e_corebilltype"), value));
                            this.getModel().deleteEntryRow("entryentity", rowIndex);
                            break;
                        }
                        this.getModel().setValue("e_corebillid", corebill.getPkValue(), rowIndex);
                        this.getModel().setValue(key, (Object)value, rowIndex);
                        this.getModel().setValue("e_corebillnoinput", (Object)value, rowIndex);
                        continue;
                    }
                    this.getModel().setValue(key, (Object)value, rowIndex);
                }
                this.CustomSetEntryValue(row, rowIndex);
                continue;
            }
            catch (KDBizException bizExp) {
                this.getModel().deleteEntryRow("entryentity", rowIndex);
                String string = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u3002", (String)"ClaimHandleEditPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), bizExp.getMessage());
                errorInfo.append(string);
                logger.info("EntryImport >> data >> " + (Object)((Object)bizExp));
                continue;
            }
            catch (Exception e) {
                this.getModel().deleteEntryRow("entryentity", rowIndex);
                String string = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u3002", (String)"ClaimHandleEditPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), e.getMessage());
                errorInfo.append(string);
                logger.info("EntryImport >> data >> " + e.getMessage());
            }
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        if (!"".equals(errorInfo.toString())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5f02\u5e38\u3002\u8bf7\u70b9\u51fb\u201c\u5c55\u793a\u8be6\u60c5\u201d\u67e5\u770b\u3002", (String)"ClaimHandleEditPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
        }
    }

    public boolean CustomSetBaseData(String key, int rowIndex) {
        return false;
    }

    public void CustomSetEntryValue(Map<String, String> row, int rowIndex) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || operationResult.isSuccess()) {
            if ("copyentryrow".equals(operateKey)) {
                EntryGrid entry = (EntryGrid)this.getControl("entryentity");
                if (entry.getSelectRows().length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"ClaimHandleEditPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
            } else if ("save".equals(operateKey) || "submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unsubmitaudit".equals(operateKey)) {
                this.getDataToEntry();
                this.refreshNoticeBillInfo();
                this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
            }
        } else {
            String claimno;
            QFilter billnoQf;
            Object[] bills;
            if (("save".equals(operateKey) || "submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unsubmitaudit".equals(operateKey)) && (EmptyUtil.isEmpty((Object[])(bills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id", (QFilter[])new QFilter[]{billnoQf = new QFilter("billno", "=", (Object)(claimno = (String)this.getModel().getValue("claimno")))}))) || bills.length < 1)) {
                return;
            }
            Object sourceid = this.getModel().getValue("sourceid");
            if (sourceid != null && !"".equals(sourceid)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)sourceid, (String)"cas_claimcenterbill");
                String mergestatus = dynamicObject.getString("mergestatus");
                if (MergeStatusEnum.ALMARGE.getValue().equals(mergestatus)) {
                    this.getDataToEntry();
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailentry", "ticketdetail"});
                }
            }
        }
    }

    private void changeCaption() {
        String businesstype = (String)this.getModel().getValue("businesstype");
        if ("recticket".equals(businesstype)) {
            FieldEdit tradedetailno = (FieldEdit)this.getView().getControl("tradedetailno");
            tradedetailno.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7968\u636e\u53f7", (String)"ClaimHandleEditPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            FieldEdit oppunit = (FieldEdit)this.getView().getControl("oppunit");
            oppunit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u7968\u4eba\u5168\u79f0", (String)"ClaimHandleEditPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            FieldEdit tradetime = (FieldEdit)this.getView().getControl("tradetime");
            tradetime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u767b\u8bb0\u65e5\u671f", (String)"ClaimHandleEditPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            this.getModel().setValue("registtime", this.getModel().getValue("tradetime"));
            FieldEdit detailid = (FieldEdit)this.getView().getControl("detailid");
            detailid.setCaption(new LocaleString(ResManager.loadKDString((String)"\u627f\u5151\u4eba\u540d\u79f0", (String)"ClaimHandleEditPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountbank", "bank", "oppbanknumber", "oppbank", "tradetime"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"draftbilltype", "draftbillexpiredate", "drawername"});
        }
    }

    private void getDataToEntry() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedetailno", "accountbank", "bank", "tradetime", "oppbanknumber", "oppbank", "bankdetailno", "detailid", "datasource", "draftbilltype", "draftbillexpiredate", "drawername", "description"});
        Object noticeBillId = this.getModel().getValue("sourceid");
        List margeBills = RecClaimHelper.getAllChildNoticeBill((Object)noticeBillId);
        String type = (String)this.getModel().getValue("businesstype");
        if ("rec".equals(type) || "pay".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ticketdetail"});
            this.getModel().deleteEntryData("detailentryentity");
            DynamicObjectCollection detailentryentity = (DynamicObjectCollection)this.getModel().getValue("detailentryentity");
            for (DynamicObject margeBill : margeBills) {
                DynamicObject addNew = detailentryentity.addNew();
                addNew.set("e_billno", (Object)margeBill.getString("tradedetailno"));
                addNew.set("e_tracebillno", (Object)margeBill.getString("detailid"));
                addNew.set("e_bankdetailno", (Object)margeBill.getString("bankdetailno"));
                addNew.set("e_bankaccount", margeBill.get("accountbank"));
                addNew.set("e_tracedate", (Object)margeBill.getDate("tradetime"));
                String bankName = margeBill.getDynamicObject("bank") == null ? null : margeBill.getDynamicObject("bank").getString("name");
                addNew.set("e_opeanbank", (Object)bankName);
                addNew.set("e_reamount", (Object)("rec".equals(type) ? margeBill.getBigDecimal("reamount") : margeBill.getBigDecimal("payamount")));
                addNew.set("e_oppunit", (Object)margeBill.getString("oppunit"));
                addNew.set("e_oppbanknumber", (Object)margeBill.getString("oppbanknumber"));
                addNew.set("e_oppbank", (Object)margeBill.getString("oppbank"));
                addNew.set("e_datasource", (Object)margeBill.getString("datasource"));
                addNew.set("e_description", (Object)margeBill.getString("description"));
            }
            this.getView().updateView("detailentryentity");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailentry"});
            this.getModel().deleteEntryData("ticketentryentity");
            DynamicObjectCollection detailentryentity = (DynamicObjectCollection)this.getModel().getValue("ticketentryentity");
            BigDecimal sumreamount = BigDecimal.ZERO;
            for (DynamicObject margeBill : margeBills) {
                DynamicObject addNew = detailentryentity.addNew();
                addNew.set("e_ticketid", margeBill.get("sourceid"));
                addNew.set("e_ticketbillno", (Object)margeBill.getString("tradedetailno"));
                addNew.set("e_ticketamount", (Object)margeBill.getBigDecimal("reamount"));
                String name = margeBill.getDynamicObject("draftbilltype") == null ? "" : margeBill.getDynamicObject("draftbilltype").getString("name");
                addNew.set("e_draftbilltype", (Object)name);
                addNew.set("e_ticketdescription", (Object)margeBill.getString("description"));
                addNew.set("e_ticketdate", (Object)margeBill.getDate("tradetime"));
                addNew.set("e_draftbillexpiredate", (Object)margeBill.getDate("draftbillexpiredate"));
                addNew.set("e_drawername", (Object)margeBill.getString("drawername"));
                addNew.set("e_ticketname", (Object)margeBill.getString("detailid"));
                addNew.set("e_ticketsource", (Object)margeBill.getString("datasource"));
                sumreamount = sumreamount.add(margeBill.getBigDecimal("reamount"));
            }
            this.getView().updateView("ticketentryentity");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject entryRowEntity;
        int rowIndex = evt.getRowIndex();
        String key = evt.getFieldName();
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"e_billno")) {
            entryRowEntity = this.getModel().getEntryRowEntity("detailentryentity", rowIndex);
            String e_billno = entryRowEntity.getString("e_billno");
            QFilter billno = new QFilter("billno", "=", (Object)e_billno);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{billno});
            if (ids.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6536\u4ed8\u5904\u7406\u5355\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u8be5\u5355\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("bei_transdetail_cas");
            showParameter.setCustomParam("onlyView", (Object)"onlyView");
            showParameter.setPkId(ids[0].getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"e_ticketbillno")) {
            entryRowEntity = this.getModel().getEntryRowEntity("ticketentryentity", rowIndex);
            Long ticketId = entryRowEntity.getLong("e_ticketid");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("cdm_receivablebill");
            showParameter.setPkId((Object)ticketId);
            showParameter.setCustomParam("onlyView", (Object)"onlyView");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (rowIndex > -1 && (StringUtils.equals((CharSequence)key, (CharSequence)"e_corebillno") || StringUtils.equals((CharSequence)key, (CharSequence)"e_corebillnoinput"))) {
            RecClaimHelper.openCoreBillNo((IFormView)this.getView(), (int)rowIndex);
        }
    }

    private void setRecInfo(IDataModel iDataModel) {
        String oppunit = (String)iDataModel.getValue("oppunit");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter oppunitNameFilter = new QFilter("name", "=", (Object)oppunit);
        Object[] customers = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{enableFilter, statusFilter, oppunitNameFilter});
        if (!EmptyUtil.isEmpty((Object[])customers)) {
            if (customers.length == 1) {
                iDataModel.setValue("payeetype", (Object)ClaimPaymentTypeEnum.CUSTOMER.getValue());
                iDataModel.setValue("recbasetype", (Object)ClaimPaymentTypeEnum.CUSTOMER.getValue());
                iDataModel.setValue("recbasepayee", customers[0].get("id"));
            }
            return;
        }
        oppunitNameFilter = new QFilter("name", "=", (Object)oppunit);
        Object[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{enableFilter, statusFilter, oppunitNameFilter});
        if (!EmptyUtil.isEmpty((Object[])suppliers)) {
            if (suppliers.length == 1) {
                iDataModel.setValue("payeetype", (Object)ClaimPaymentTypeEnum.SUPPLIER.getValue());
                iDataModel.setValue("recbasetype", (Object)ClaimPaymentTypeEnum.SUPPLIER.getValue());
                iDataModel.setValue("recbasepayee", suppliers[0].get("id"));
            }
            return;
        }
    }

    private void setEntryAmountCaption() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("paytype");
        if (billType == null) {
            return;
        }
        EntryGrid entryCtr = (EntryGrid)this.getControl("payentity");
        if (!billType.getBoolean("ispartpayment")) {
            entryCtr.setColumnProperty("e_payableamt", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u5b9e\u4ed8\u91d1\u989d", (String)"PaymentBillEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        } else {
            entryCtr.setColumnProperty("e_payableamt", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d", (String)"PaymentBillEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        }
    }

    private void setIFilters(ListFilterParameter lfp, IDataModel iDataModel) {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u4e8c\u5f00\u6269\u5c55\u5b57\u6bb5\u5bf9\u5916\u670d\u52a1\u4e1a\u52a1\u57cb\u70b9 - kd.sdk.fi.cas.extpoint.claimbill.IClaimbillFilter");
        PluginProxy pluginProxy = PluginProxy.create(IClaimbillFilter.class, (String)"fi.cas.filter.claimbill.v2");
        List resultList = pluginProxy.callReplace(proxy -> {
            proxy.setIFilters(lfp, iDataModel);
            return Boolean.TRUE;
        });
        if (EmptyUtil.isNoEmpty((Object)resultList) && ((Boolean)resultList.get(0)).booleanValue()) {
            return;
        }
        pluginProxy = PluginProxy.create(IClaimbillFilter.class, (String)"fi.cas.filter.claimbill");
        pluginProxy.callReplace(proxy -> {
            proxy.setIFilters(lfp, iDataModel.getDataEntity());
            return null;
        });
    }

    private void calculateRecAmt() {
        IDataModel model = this.getModel();
        Object org = model.getValue("org");
        if (org != null) {
            DynamicObjectCollection entryDyColl = this.getModel().getEntryEntity("entryentity");
            int cs = SystemParameterHelper.getParameterInteger((long)((DynamicObject)org).getLong("id"), (String)"cs117");
            BigDecimal claimAmount = BigDecimal.ZERO;
            if (RecAmtTypeEnum.RECEIVABLEAMT.getValue().equals(String.valueOf(cs))) {
                for (int i = 0; i < entryDyColl.size(); ++i) {
                    BigDecimal receivableamt = ((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_receivableamt");
                    BigDecimal discountamt = ((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_discountamt");
                    BigDecimal fee = ((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_fee");
                    this.getModel().setValue("e_actamt", (Object)receivableamt.subtract(discountamt).subtract(fee), i);
                    claimAmount = claimAmount.add(((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_receivableamt"));
                }
            } else {
                for (int i = 0; i < entryDyColl.size(); ++i) {
                    BigDecimal actamt = ((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_actamt");
                    BigDecimal discountamt = ((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_discountamt");
                    BigDecimal fee = ((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_fee");
                    this.getModel().setValue("e_receivableamt", (Object)actamt.add(discountamt).add(fee), i);
                    claimAmount = claimAmount.add(((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_receivableamt"));
                }
            }
            this.getModel().setValue("claimamount", (Object)claimAmount);
        }
    }

    private void calculatePayAmt() {
        IDataModel model = this.getModel();
        Object org = model.getValue("org");
        if (org != null) {
            BigDecimal claimAmount = BigDecimal.ZERO;
            DynamicObjectCollection entryDyColl = this.getModel().getEntryEntity("payentity");
            for (int i = 0; i < entryDyColl.size(); ++i) {
                BigDecimal receivableamt = ((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_payableamt");
                BigDecimal discountamt = ((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_paydiscountamt");
                this.getModel().setValue("e_payactamt", (Object)receivableamt.subtract(discountamt), i);
                claimAmount = claimAmount.add(((DynamicObject)entryDyColl.get(i)).getBigDecimal("e_payableamt"));
            }
            this.getModel().setValue("claimamount", (Object)claimAmount);
        }
    }

    public void controlRecAmt() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object org = model.getValue("org");
        String field = "e_actamt";
        String enableField = "e_receivableamt";
        if (org != null) {
            int cs = SystemParameterHelper.getParameterInteger((long)((DynamicObject)org).getLong("id"), (String)"cs117");
            if (RecAmtTypeEnum.ACTAMT.getValue().equals(String.valueOf(cs))) {
                field = "e_receivableamt";
                enableField = "e_actamt";
            }
        }
        int entryCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryCount; ++i) {
            view.setEnable(Boolean.valueOf(true), i, new String[]{enableField});
            view.setEnable(Boolean.valueOf(false), i, new String[]{field});
        }
    }

    public void controlPayAmt() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object org = model.getValue("org");
        String field = "e_payactamt";
        String enableField = "e_payableamt";
        int entryCount = model.getEntryRowCount("payentity");
        for (int i = 0; i < entryCount; ++i) {
            view.setEnable(Boolean.valueOf(true), i, new String[]{enableField});
            view.setEnable(Boolean.valueOf(false), i, new String[]{field});
        }
    }

    private void multiTypeSelect(Boolean multiType) {
        ComboEdit recPayTypeCbo;
        DynamicObject recType = (DynamicObject)this.getModel().getValue("recpaytype");
        DynamicObject payType = (DynamicObject)this.getModel().getValue("paytype");
        String businessType = (String)this.getModel().getValue("businesstype");
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.CUSTOMER.getName()), ClaimPaymentTypeEnum.CUSTOMER.getValue()));
        comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.SUPPLIER.getName()), ClaimPaymentTypeEnum.SUPPLIER.getValue()));
        comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.USER.getName()), ClaimPaymentTypeEnum.USER.getValue()));
        ComboEdit comboEdit = recPayTypeCbo = Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType) ? (ComboEdit)this.getView().getControl("payeetype") : (ComboEdit)this.getView().getControl("paymenttype");
        if (!multiType.booleanValue()) {
            boolean isPartSettlement;
            boolean selectAllType = Boolean.TRUE;
            if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) {
                boolean bl = isPartSettlement = payType != null && payType.getBoolean("ispartpayment");
                if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
                    selectAllType = SystemParameterHelper.getParameterBoolean((long)((Long)org.getPkValue()), (String)"selectallpayeetype");
                }
            } else {
                boolean bl = isPartSettlement = recType != null && recType.getBoolean("ispartreceivable");
                if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
                    selectAllType = SystemParameterHelper.getParameterBoolean((long)((Long)org.getPkValue()), (String)"selectallpayertype");
                }
            }
            if (isPartSettlement && !selectAllType) {
                recPayTypeCbo.setComboItems(comboItem);
            } else {
                comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.ORG.getName()), ClaimPaymentTypeEnum.ORG.getValue()));
                comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.OTHER.getName()), ClaimPaymentTypeEnum.OTHER.getValue()));
                recPayTypeCbo.setComboItems(comboItem);
            }
        } else {
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.ORG.getName()), ClaimPaymentTypeEnum.ORG.getValue()));
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.OTHER.getName()), ClaimPaymentTypeEnum.OTHER.getValue()));
            recPayTypeCbo.setComboItems(comboItem);
        }
    }

    private void fillEntryType(DynamicObjectCollection entries, String recPayType, DynamicObject type) {
        for (int i = 0; i < entries.size(); ++i) {
            this.getModel().setValue(recPayType, (Object)type, i);
        }
    }

    private void multiTypeChange(Boolean multiType) {
        block9: {
            block10: {
                block7: {
                    block8: {
                        String businessType = (String)this.getModel().getValue("businesstype");
                        if (!Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) break block7;
                        if (!multiType.booleanValue()) break block8;
                        DynamicObjectCollection payEntries = this.getModel().getEntryEntity("payentity");
                        for (int i = 0; i < payEntries.size(); ++i) {
                            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"e_paymenttype"});
                        }
                        QFilter qFilter = new QFilter("biztype", "=", (Object)"110").and(new QFilter("default", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1"));
                        DynamicObject[] paymentBillType = BusinessDataServiceHelper.load((String)"cas_paymentbilltype", (String)"id,biztype,ispartpayment", (QFilter[])new QFilter[]{qFilter});
                        if (paymentBillType == null || paymentBillType.length == 0) break block9;
                        this.getModel().setValue("paytype", (Object)paymentBillType[0]);
                        break block9;
                    }
                    DynamicObjectCollection entries = this.getModel().getEntryEntity("payentity");
                    boolean haveValue = false;
                    for (DynamicObject entry : entries) {
                        DynamicObject ePaymentType = entry.getDynamicObject("e_paymenttype");
                        if (ePaymentType == null) continue;
                        haveValue = true;
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u591a\u4ed8\u6b3e\u7c7b\u578b\u5c06\u81ea\u52a8\u6e05\u7a7a\u8ba4\u9886\u660e\u7ec6\u4ed8\u6b3e\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClaimHandleEditPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("clearPayType", (IFormPlugin)this));
                        break;
                    }
                    if (haveValue) break block9;
                    this.getModel().setValue("paytype", null);
                    for (int i = 0; i < entries.size(); ++i) {
                        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_paymenttype"});
                    }
                    break block9;
                }
                if (!multiType.booleanValue()) break block10;
                DynamicObjectCollection recEntries = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < recEntries.size(); ++i) {
                    this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"e_receivingtype"});
                }
                QFilter qFilter = new QFilter("biztype", "=", (Object)"110").and(new QFilter("default", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1"));
                DynamicObject[] receivingBillType = BusinessDataServiceHelper.load((String)"cas_receivingbilltype", (String)"id,biztype,ispartreceivable", (QFilter[])new QFilter[]{qFilter});
                if (receivingBillType == null || receivingBillType.length == 0) break block9;
                this.getModel().setValue("recpaytype", (Object)receivingBillType[0]);
                break block9;
            }
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            boolean haveValue = false;
            for (DynamicObject entry : entries) {
                DynamicObject eReceivingType = entry.getDynamicObject("e_receivingtype");
                if (eReceivingType == null) continue;
                haveValue = true;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u591a\u6536\u6b3e\u7c7b\u578b\u5c06\u81ea\u52a8\u6e05\u7a7a\u8ba4\u9886\u660e\u7ec6\u6536\u6b3e\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClaimHandleEditPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("clearReceivingType", (IFormPlugin)this));
                break;
            }
            if (!haveValue) {
                this.getModel().setValue("recpaytype", null);
                for (int i = 0; i < entries.size(); ++i) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_receivingtype"});
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"clearReceivingType", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().setValue("recpaytype", null);
                DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entries.size(); ++i) {
                    this.getModel().setValue("e_receivingtype", null, i);
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_receivingtype"});
                }
                this.getView().updateView("entryentity");
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
                this.getModel().beginInit();
                this.getModel().setValue("multireceivingtype", (Object)"1");
                this.getModel().endInit();
                this.getView().updateView("multireceivingtype");
            }
        } else if (StringUtils.equals((CharSequence)"clearPayType", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().setValue("paytype", null);
                DynamicObjectCollection entries = this.getModel().getEntryEntity("payentity");
                for (int i = 0; i < entries.size(); ++i) {
                    this.getModel().setValue("e_paymenttype", null, i);
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_paymenttype"});
                }
                this.getView().updateView("payentity");
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
                this.getModel().beginInit();
                this.getModel().setValue("multipaymenttype", (Object)"1");
                this.getModel().endInit();
                this.getView().updateView("multipaymenttype");
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        if ("e_corebillno".equals(key)) {
            int index = e.getRowIndex();
            if (value != null) {
                String coreBillType = (String)this.getModel().getValue("e_corebilltype", index);
                if (ClaimCoreBillTypeEnum.MSCON_PERFORMPLANIN.getValue().equals(coreBillType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u5bf9\u5e94\u7684\u6838\u5fc3\u5355\u636e\u7f16\u53f7\u4e0d\u652f\u6301\u624b\u5de5\u5f55\u5165\u3002", (String)"ClaimHandleEditPlugin_23", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                this.getView().updateView("e_corebillno", index);
            }
        }
    }
}

