/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.claimnotice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.formplugin.recclaim.CommonOperationHandler;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.result.InvokeResult;
import kd.fi.cas.util.EmptyUtil;

public class ClaimNoticeListPlugin
extends AbstractListPlugin {
    private FilterContainerInitArgs initArgs;
    private List<QFilter> drawPieFilters;
    private static ArrayList<ComboItem> ids = null;
    private static final String QUERYNOCONFIRM = "queryNoConfirm";
    private static final String[] colors = new String[]{"#40A9FF", "#45DAD1", "#73D13D", "#FFC53D", "#FFA940", "#F57582", "#9F69E2", "#6682F5", "#F273B5"};

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String selectedOrgIdList;
        String fieldName = args.getFieldName();
        if ("accountbank.id".equals(fieldName) && EmptyUtil.isNotEmpty((String)(selectedOrgIdList = this.getPageCache().get("selectedOrgIdList")))) {
            String[] splits = selectedOrgIdList.split(",");
            List selectedOrgIdLongList = Arrays.stream(splits).map(o -> Long.parseLong(o.trim())).collect(Collectors.toList());
            QFilter idsFilter = AccountBankHelper.getUseAuthAccountBankFilterByOrg(selectedOrgIdLongList);
            idsFilter.and(VisibleVirtualAcctHelper.notVirtualAcctQf());
            args.setQfilters(Arrays.asList(idsFilter.toArray()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (ids == null || ids.size() <= 0 || !"accountbank.bankaccountnumber".equals(fieldName)) continue;
            commonFilter.setComboItems(ids);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelapa112", "confirmlable"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"labelapa112", (CharSequence)key) || StringUtils.equals((CharSequence)"confirmlable", (CharSequence)key)) {
            this.getPageCache().put(QUERYNOCONFIRM, "yes");
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("mergestatus", "!=", (Object)MergeStatusEnum.MARFED.getValue()));
        if (EmptyUtil.isNotEmpty((String)this.getPageCache().get(QUERYNOCONFIRM))) {
            qFilters.add(new QFilter("claimstatus", "in", (Object)new String[]{ClaimStatusEnum.CLAIMED.getValue(), ClaimStatusEnum.APPEAL.getValue(), ClaimStatusEnum.CHANGE.getValue()}));
            this.getPageCache().remove(QUERYNOCONFIRM);
        }
        this.drawPieFilters = qFilters;
    }

    private void drawPieChart(List<QFilter> qFilters) {
        PieSeries series;
        if (qFilters.isEmpty()) {
            return;
        }
        String selectedOrgIdList = this.getPageCache().get("selectedOrgIdList");
        if (EmptyUtil.isNotEmpty((String)selectedOrgIdList)) {
            String[] splits = selectedOrgIdList.split(",");
            List selectedOrgIdLongList = Arrays.stream(splits).map(o -> Long.parseLong(o.trim())).collect(Collectors.toList());
            qFilters.add(new QFilter("org", "in", selectedOrgIdLongList));
        } else {
            qFilters.add(new QFilter("org", "in", (Object)PermissionServiceHelper.getUserOrgs((long)Long.parseLong(RequestContext.get().getUserId()))));
        }
        ArrayList<ItemValue> items = new ArrayList<ItemValue>(10);
        int sumClaim = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryPie", (String)"cas_claimcenterbill", (String)"claimstatus", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            DataSet gds = ds.groupBy(new String[]{"claimstatus"}).count().finish();
            int i = 0;
            while (gds.hasNext()) {
                Row r = gds.next();
                String status = r.getString("claimstatus");
                if (status.equals(ClaimStatusEnum.CLAIMED.getValue()) || status.equals(ClaimStatusEnum.APPEAL.getValue()) || status.equals(ClaimStatusEnum.CHANGE.getValue())) {
                    sumClaim += r.getInteger("count").intValue();
                }
                items.add(new ItemValue(ClaimStatusEnum.getName((String)status), (Number)r.getBigDecimal("count"), colors[i % colors.length]));
                ++i;
            }
            gds.close();
        }
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        Label confirmlable = (Label)this.getControl("confirmlable");
        if (items.size() > 0) {
            pieChart.setShowTooltip(true);
            pieChart.setShowLegend(true);
            series = pieChart.createPieSeries("piechartap");
            pieChart.setLegendPropValue("left", (Object)"60%");
            pieChart.setLegendPropValue("top", (Object)"15%");
            series.setData(items.toArray(new ItemValue[0]));
            series.setRadius("0%", "60%");
            series.setCenter("40%", "50%");
            pieChart.addTooltip("formatter", (Object)String.format(ResManager.loadKDString((String)"%1$s\u7b14%2$s", (String)"ClaimNoticeListPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), "{b0}: {c0}", " {d0}%"));
            pieChart.setLegendPropValue("orient", (Object)"vertical");
            pieChart.setLegendPropValue("x", (Object)"right");
            confirmlable.setText(String.valueOf(sumClaim));
        } else {
            series = pieChart.createPieSeries("piechartap");
            items.add(new ItemValue(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"ClaimNoticeListPlugin_25", (String)"fi-cas-formplugin", (Object[])new Object[0]), (Number)BigDecimal.ZERO));
            series.setData(items.toArray(new ItemValue[0]));
            confirmlable.setText("0");
        }
        pieChart.refresh();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
        if (e.getSource() instanceof BillList) {
            this.drawPieChart(this.drawPieFilters);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        List selectedOrgIdList = new ArrayList();
        if (currentCommonFilter != null && ((List)currentCommonFilter.get("FieldName")).contains("org.id")) {
            selectedOrgIdList = (List)currentCommonFilter.get("Value");
            if (ids == null) {
                ids = new ArrayList();
            } else {
                ids.clear();
            }
            if (selectedOrgIdList == null || selectedOrgIdList.size() == 0 || "".equals(selectedOrgIdList.get(0))) {
                String userId = RequestContext.get().getUserId();
                List userOrgs = PermissionServiceHelper.getUserOrgs((long)Long.parseLong(userId));
                QFilter idsFilter = AccountBankHelper.getUseAuthAccountBankFilterByOrg((Collection)userOrgs);
                idsFilter.and(VisibleVirtualAcctHelper.notVirtualAcctQf());
                DynamicObjectCollection accts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{idsFilter});
                for (DynamicObject acct : accts) {
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(acct.getString("bankaccountnumber")));
                    item.setValue(acct.getString("id"));
                    ids.add(item);
                }
            }
            if (EmptyUtil.isNoEmpty(selectedOrgIdList) && !"".equals(selectedOrgIdList.get(0))) {
                this.getPageCache().put("selectedOrgIdList", String.join((CharSequence)",", selectedOrgIdList.stream().filter(EmptyUtil::isNoEmpty).map(Object::toString).collect(Collectors.toList())));
            } else {
                this.getPageCache().put("selectedOrgIdList", "");
            }
        }
        if (selectedOrgIdList != null && selectedOrgIdList.size() > 0 && !"".equals(selectedOrgIdList.get(0))) {
            ArrayList selectedOrgIdListNew = new ArrayList(selectedOrgIdList.size());
            selectedOrgIdList.forEach(o -> selectedOrgIdListNew.add(Long.parseLong(o.toString())));
            QFilter idsFilter = AccountBankHelper.getUseAuthAccountBankFilterByOrg(selectedOrgIdListNew);
            idsFilter.and(VisibleVirtualAcctHelper.notVirtualAcctQf());
            DynamicObjectCollection accts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{idsFilter});
            for (DynamicObject acct : accts) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(acct.getString("bankaccountnumber")));
                item.setValue(acct.getString("id"));
                ids.add(item);
            }
            if (accts.size() < 1) {
                ids.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"ClaimNoticeListPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0])), ""));
            }
        }
        this.filterContainerInit(this.initArgs);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operateKey = evt.getItemKey();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object[] selectids = selectedRows.getPrimaryKeyValues();
        if (("transpond".equals(operateKey) || "cancelnotice".equals(operateKey)) && EmptyUtil.isEmpty((Object[])selectids)) {
            return;
        }
        switch (operateKey) {
            case "claimset": {
                long userId = Long.parseLong(RequestContext.get().getUserId());
                List orgIds = OrgHelper.getAuthorizedBankOrgId((Long)userId, (String)"cas_recpayrule", (String)"47156aff000000ac");
                Boolean flag = false;
                for (Long orgId : orgIds) {
                    boolean hasViewPerm = PermissionHelper.checkCurrentUserPermission((long)orgId, (String)"cas_recpayrule", (String)"0QEEW5JO7058");
                    if (!hasViewPerm) continue;
                    flag = true;
                    break;
                }
                if (!flag.booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61\u201c\u8ba4\u9886\u4e2d\u5fc3\u201d\u7684\u201c\u8ba4\u9886\u8bbe\u7f6e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u201c\u7ec4\u7ec7\u201d\u7684\u201c\u751f\u5355/\u901a\u77e5\u89c4\u5219\u201d\u6743\u9650\u9879\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ClaimNoticeListPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListShowParameter showPara = new ListShowParameter();
                showPara.setBillFormId("cas_recpayrule");
                showPara.setCustomParam("flag", (Object)"claimNoticeBill");
                showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showPara);
                break;
            }
            case "unclaimacc": {
                String msg;
                String operKeyName = ResManager.loadKDString((String)"\u672a\u8ba4\u9886\u5165\u8d26", (String)"ClaimNoticeListPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)"cas_claimcenterbill", (String)"unclaimacc");
                Object permission = operateMetaMap.get("permission");
                List orgIdList = OrgHelper.getAuthorizedBankOrgId((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"cas_claimcenterbill", (String)(permission + ""));
                if (orgIdList.size() == 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u6743\u9650\uff01", (String)"ClaimNoticeListPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), operKeyName));
                    return;
                }
                if (selectedRows.isEmpty()) {
                    return;
                }
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cas_claimcenterbill");
                DynamicObject[] claimNotices = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)type);
                ArrayList<String> billnoList = new ArrayList<String>();
                ArrayList<String> mergeList = new ArrayList<String>();
                int size = 0;
                for (DynamicObject claimNotice : claimNotices) {
                    BigDecimal payAmount = claimNotice.getBigDecimal("payamount");
                    if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\u7f16\u53f7 %s \u4ed8\u6b3e\u4e1a\u52a1\u4e0d\u652f\u6301\u672a\u8ba4\u9886\u5165\u8d26\uff0c\u8bf7\u901a\u8fc7\u8ba4\u9886\u540e\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u5165\u8d26\u3002", (String)"ClaimNoticeListPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]), claimNotice.getString("billno")));
                        return;
                    }
                    Boolean myFlag = false;
                    String claimstatus = claimNotice.getString("claimstatus");
                    if (!ClaimStatusEnum.WAIT.getValue().equals(claimstatus) && !ClaimStatusEnum.PART.getValue().equals(claimstatus)) {
                        billnoList.add(claimNotice.getString("billno"));
                    } else {
                        myFlag = true;
                        if (claimNotice.getBoolean("isunclaim")) {
                            ++size;
                        }
                    }
                    if (!StringUtils.equals((CharSequence)MergeStatusEnum.UNMARGE.getValue(), (CharSequence)claimNotice.getString("mergestatus"))) {
                        mergeList.add(claimNotice.getString("billno"));
                        continue;
                    }
                    if (myFlag.booleanValue() || !claimNotice.getBoolean("isunclaim")) continue;
                    ++size;
                }
                if (!billnoList.isEmpty()) {
                    msg = billnoList.stream().reduce((a, b) -> a + ',' + b).orElse("");
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\u5355\u7f16\u53f7 %s \u4e0d\u662f\u5f85\u8ba4\u9886\u548c\u90e8\u5206\u8ba4\u9886\u72b6\u6001\uff0c\u53ea\u6709\u201c\u5f85\u8ba4\u9886\u3001\u90e8\u5206\u8ba4\u9886\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u672a\u8ba4\u9886\u5165\u8d26\u64cd\u4f5c\u3002", (String)"ClaimNoticeListPlugin_24", (String)"fi-cas-formplugin", (Object[])new Object[0]), msg));
                    return;
                }
                if (!mergeList.isEmpty()) {
                    msg = mergeList.stream().reduce((a, b) -> a + ',' + b).orElse("");
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\u5355\u7f16\u53f7 %s \u4e0d\u662f\u672a\u5408\u5e76\u72b6\u6001\uff0c\u53ea\u6709\u201c\u672a\u5408\u5e76\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u672a\u8ba4\u9886\u5165\u8d26\u64cd\u4f5c\u3002", (String)"ClaimNoticeListPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), msg));
                    return;
                }
                if (claimNotices.length == size) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u90fd\u662f\u5df2\u7ecf\u672a\u8ba4\u9886\u5165\u8d26\u7684,\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ClaimNoticeListPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
                List companyIds = transDetails.stream().map(t -> t.getLong("org")).distinct().collect(Collectors.toList());
                Long companyId = null;
                if (companyIds.size() == 1) {
                    companyId = (Long)companyIds.get(0);
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.setCustomParam("recorg", (Object)companyId);
                fsp.setCustomParam("receredway", (Object)"claim");
                fsp.setCustomParam("call", (Object)"cas_unclaimtoaccount");
                fsp.setFormId("cas_recbizinfo");
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "cas_unclaimtoaccount");
                fsp.setCloseCallBack(callBack);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
                break;
            }
        }
    }

    public void showForm(String formId, String callBackBtn) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, callBackBtn);
        fsp.setCloseCallBack(callBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    private void userCardAdd() {
        ListShowParameter para = new ListShowParameter();
        para.setHasRight(true);
        para.setLookUp(true);
        para.setBillFormId("bos_user");
        para.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(true);
        para.setShowUsed(true);
        para.setShowTitle(false);
        para.setStatus(OperationStatus.ADDNEW);
        para.setShowQuickFilter(true);
        para.setIsolationOrg(true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "usercard_add"));
        this.getView().showForm((FormShowParameter)para);
    }

    private void addFee(Object claimId) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("cas_claimaddfee");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("claimId", claimId);
        para.setCustomParams(customParams);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setShowTitle(true);
        para.setStatus(OperationStatus.ADDNEW);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "claimaddfee"));
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (actionId.equals("usercard_add") && e.getReturnData() != null) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
            HashMap<Object, String> userIdNames = new HashMap();
            if (!EmptyUtil.isEmpty((Collection)returnData)) {
                userIdNames = returnData.stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, ListSelectedRow::getName, (e1, e2) -> e2));
            }
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Object[] selectids = selectedRows.getPrimaryKeyValues();
            InvokeResult invokeResult = CommonOperationHandler.transpond(userIdNames, selectids);
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"cas_unclaimtoaccount")) {
            HashMap returnData = (HashMap)e.getReturnData();
            if (!CasHelper.isEmpty((Object)returnData)) {
                OperationResult result = new OperationResult();
                OperateOption operateOption = OperateOption.create();
                String returnDataStr = SerializationUtils.toJsonString((Object)returnData);
                operateOption.setVariableValue("returnDataByOpHand", returnDataStr);
                BillList list = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                Object[] selectedPks = selectedRows.getPrimaryKeyValues();
                result.setBillCount(selectedPks.length);
                ArrayList<Object> succIdList = new ArrayList<Object>();
                Boolean errorFlag = Boolean.FALSE;
                for (Object pk : selectedPks) {
                    try {
                        OperationResult executeOperate = OperateServiceHelper.executeOperate((String)"unclaimpush", (String)"cas_claimcenterbill", (Object[])new Object[]{pk}, (OperateOption)operateOption);
                        if (executeOperate.isSuccess()) {
                            succIdList.add(pk);
                            result.setSuccess(true);
                            result.setSuccessPkIds(succIdList);
                            continue;
                        }
                        errorFlag = Boolean.TRUE;
                        result.addErrorInfo(this.getOperateErrorInfo(pk, ((OperateErrorInfo)executeOperate.getAllErrorInfo().get(0)).getMessage()));
                    }
                    catch (Exception ee) {
                        errorFlag = Boolean.TRUE;
                        result.addErrorInfo(this.getOperateErrorInfo(pk, ee.getMessage()));
                    }
                }
                if (errorFlag.booleanValue()) {
                    this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u672a\u8ba4\u9886\u5165\u8d26", (String)"ClaimNoticeListPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ClaimNoticeListPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"claimaddfee") && e.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ClaimNoticeListPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        int rowLen = listSelectedData.getPrimaryKeyValues().length;
        switch (operateKey) {
            case "cancelaccount": 
            case "cancelclaim": {
                if (rowLen == 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ReceivingBillList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "addfee": {
                BigDecimal fee;
                if (rowLen != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ClaimNoticeListPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject claimcenterbill = BusinessDataServiceHelper.loadSingle((Object)listSelectedData.getPrimaryKeyValues()[0], (String)"cas_claimcenterbill");
                String claimstatus = claimcenterbill.getString("claimstatus");
                if (StringUtils.equals((CharSequence)claimstatus, (CharSequence)ClaimStatusEnum.SURE.getValue()) || StringUtils.equals((CharSequence)claimstatus, (CharSequence)ClaimStatusEnum.CHANGE.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u548c\u53d8\u66f4\u4e2d\u72b6\u6001\u4e0d\u80fd\u8865\u5145\u624b\u7eed\u8d39", (String)"ClaimNoticeListPlugin_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (claimcenterbill.getBoolean("isaddfee")) break;
                DynamicObjectCollection entrys = claimcenterbill.getDynamicObjectCollection("entryentity");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) && BigDecimal.ZERO.compareTo(fee = entrys.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)) != 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u901a\u77e5\u5355\u5df2\u6709\u8ba4\u9886\u5355\u586b\u5199\u624b\u7eed\u8d39\uff0c\u4e0d\u53ef\u8865\u5145\u624b\u7eed\u8d39\u3002", (String)"ClaimNoticeListPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!"pay".equals(claimcenterbill.getString("businesstype"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba4\u9886\u4e0d\u5141\u8bb8\u8865\u5145\u624b\u7eed\u8d39\u3002", (String)"ClaimNoticeListPlugin_26", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void showBillForm(String formId, Object pkId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId(pkId);
        billShowParameter.setFormId(formId);
        billShowParameter.setCustomParam("confirmclaim", (Object)"confirmclaim");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        switch (operateKey) {
            case "claimaccount": 
            case "cancelunclaim": 
            case "cancelaccount": 
            case "cancelclaim": 
            case "cancelnotice": {
                if (!result.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "transpond": {
                if (!result.isSuccess()) break;
                this.userCardAdd();
                break;
            }
            case "addfee": {
                if (!result.isSuccess()) break;
                List successPkIds = e.getOperationResult().getSuccessPkIds();
                this.addFee(successPkIds.get(0));
                break;
            }
            case "confirmclaim": {
                if (!result.isSuccess()) break;
                List successPkIds = e.getOperationResult().getSuccessPkIds();
                if (successPkIds.size() == 1) {
                    DynamicObject noticeBill = BusinessDataServiceHelper.loadSingle(successPkIds.get(0), (String)"cas_claimcenterbill");
                    String claimstatus = noticeBill.getString("claimstatus");
                    if (!ClaimStatusEnum.WAIT.getValue().equals(claimstatus) && !ClaimStatusEnum.SURE.getValue().equals(claimstatus)) {
                        this.showBillForm("cas_claimcenterbill", successPkIds.get(0));
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\u5355\u8ba4\u9886\u72b6\u6001\u4e3a\u201c\u90e8\u5206\u8ba4\u9886\u201d\u3001\u201c\u5df2\u8ba4\u9886\u201d\u3001\u201c\u7533\u8bc9\u4e2d\u201d\u6216\u201c\u53d8\u66f4\u4e2d\u201d\u7684\u624d\u53ef\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u3002", (String)"ClaimNoticeListPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().invokeOperation("claimaccount");
                break;
            }
            case "mytrackdownrec": {
                if (!result.isSuccess()) break;
                this.getView().invokeOperation("trackdown");
                break;
            }
            case "mytrackdown": {
                if (!result.isSuccess()) break;
                List successPkIds = e.getOperationResult().getSuccessPkIds();
                if (successPkIds.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ClaimNoticeListPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object primaryKeyValue = successPkIds.get(0);
                DynamicObject claimNoticeBill = BusinessDataServiceHelper.loadSingle(primaryKeyValue, (String)"cas_claimcenterbill");
                QFilter qFilter = new QFilter("claimno", "=", (Object)claimNoticeBill.getString("billno"));
                DynamicObject[] ids = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (ids.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u8ba4\u9886\u5355", (String)"ClaimNoticeListPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (ids.length == 1) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("cas_claimbill");
                    showParameter.setPkId(ids[0].getPkValue());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("cas_claimbill");
                showParameter.setCustomParam("hasright", (Object)"yes");
                showParameter.setCustomParam("claimno", (Object)claimNoticeBill.getString("billno"));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(qFilter);
                showParameter.getListFilterParameter().setQFilters(qFilters);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    private void showOperationResultMulti(OperationResult operationResult, String operateName) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap pkNumbers = new HashMap();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty() && !operationResult.getBillNos().isEmpty()) {
            pkNumbers.putAll(operationResult.getBillNos());
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        IPageCache pageCache = this.getPageCache();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        int successCount = operationResult.getSuccessPkIds().size();
        String title = "";
        title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u5176\u4e2d\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"RecWorkbenchPlugin_25", (String)"fi-cas-formplugin", (Object[])new Object[0]), operationResult.getBillCount(), StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount, operationResult.getBillCount() - successCount);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        this.getView().showForm(parameters);
    }

    public OperateErrorInfo getOperateErrorInfo(Object pk, String meg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }
}

