/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recinit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.F7FilterUtil;

public class RecEdcBatchAddPlugin
extends DynamicFormPlugin {
    private static final Log logger = LogFactory.getLog(RecEdcBatchAddPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addListener();
    }

    protected void addListener() {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)"1")}, null);
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            F7FilterUtil.bankrollOrgF7QFilter((BeforeF7SelectEvent)evt, (String)appId, (String)"cas_rec_edc", (String)"47156aff000000ac", (List)OrgHelper.getIdList((DynamicObjectCollection)coll));
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_save": {
                this.save();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int iRow = changeData[0].getRowIndex();
        if (newValue == oldValue) {
            return;
        }
        switch (name) {
            case "org": {
                this.changeOrg(newValue, iRow);
            }
        }
    }

    protected void changeOrg(Object newValue, int iRow) {
        if (newValue == null) {
            this.getModel().setValue("startperiod", null, iRow);
            this.getModel().setValue("currentperiod", null, iRow);
            this.getModel().setValue("recperiod", null, iRow);
            return;
        }
        DynamicObject org = (DynamicObject)newValue;
        DynamicObject orgInit = SystemStatusCtrolHelper.loadCashMgtInit((long)org.getLong("id"));
        this.getModel().setValue("startperiod", orgInit.get("startperiod"), iRow);
        this.getModel().setValue("currentperiod", orgInit.get("currentperiod"), iRow);
        this.getModel().setValue("recperiod", orgInit.get("currentperiod"), iRow);
    }

    private void save() {
        if (!this.checkSaveInfo()) {
            return;
        }
        if (this.saveEvent()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ManualJournalEditPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private boolean checkSaveInfo() {
        IDataModel model = this.getModel();
        int size = model.getEntryRowCount("entryentity");
        if (size < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5206\u5f55\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"RecEdcBatchAddPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        Map orgInitMap = SystemStatusCtrolHelper.loadFinishInits();
        Set initOrgIds = orgInitMap.keySet();
        Map recEdcOrgs = SystemStatusCtrolHelper.loadRecEdcs(initOrgIds);
        HashMap<Long, Integer> addOrgIds = new HashMap<Long, Integer>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = model.getEntryRowEntity("entryentity", i);
            DynamicObject org = entry.getDynamicObject("org");
            if (org == null) {
                return false;
            }
            DynamicObject orgInit = (DynamicObject)orgInitMap.get(org.getLong("id"));
            if (orgInit == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%1$s\u884c\uff1a \u7ec4\u7ec7\u201c%2$s\u201d\u672a\u7ed3\u675f\u51fa\u7eb3\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u5bf9\u8d26\u3002", (String)"RecEdcBatchAddPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1, CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
                return false;
            }
            DynamicObject recEdcOrg = (DynamicObject)recEdcOrgs.get(org.getLong("id"));
            if (recEdcOrg != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%1$s\u884c\uff1a \u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u542f\u7528\u5bf9\u8d26\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u542f\u7528\u3002", (String)"RecEdcBatchAddPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1, CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
                return false;
            }
            if (addOrgIds.containsKey(org.getLong("id"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\uff1a \u7ec4\u7ec7\u201c%3$s\u201d\u91cd\u590d\u5f55\u5165\u3002", (String)"RecEdcBatchAddPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1, addOrgIds.get(org.getLong("id")), CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
                return false;
            }
            addOrgIds.put(org.getLong("id"), i + 1);
            DynamicObject currentperiod = orgInit.getDynamicObject("currentperiod");
            DynamicObject recperiod = entry.getDynamicObject("recperiod");
            if (currentperiod != null && currentperiod.getPkValue().equals(recperiod.getPkValue())) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%1$s\u884c\uff1a \u7ec4\u7ec7\u201c%2$s\u201d\u5f53\u524d\u671f\u95f4\u5df2\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u671f\u95f4\u662f\u5426\u6b63\u786e\uff0c\u5982\u9700\u7ee7\u7eed\u8bf7\u5148\u53cd\u7ed3\u8d26\u4f7f\u5f97\u5f53\u524d\u671f\u95f4\u4e0e\u542f\u7528\u671f\u95f4\u76f8\u540c\uff0c\u6216\u8005\u5237\u65b0\u754c\u9762\u83b7\u53d6\u6700\u65b0\u5f53\u524d\u671f\u95f4\u542f\u7528\u5bf9\u8d26\u3002", (String)"RecEdcBatchAddPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1, CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
            return false;
        }
        return true;
    }

    protected boolean saveEvent() {
        try (TXHandle tx = TX.requiresNew();){
            this.handleSaveMainInfo();
            boolean bl = true;
            return bl;
        }
    }

    public void handleSaveMainInfo() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        if (entryentity == null || entryentity.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> addRecEdcs = new ArrayList<DynamicObject>(entryentity.size());
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject row = (DynamicObject)entryentity.get(i);
            DynamicObject recEdc = BusinessDataServiceHelper.newDynamicObject((String)"cas_rec_edc");
            recEdc.set("org", row.get("org"));
            recEdc.set("creator", (Object)RequestContext.get().getCurrUserId());
            recEdc.set("startperiod", row.get("startperiod"));
            recEdc.set("currentperiod", row.get("currentperiod"));
            recEdc.set("recperiod", row.get("recperiod"));
            addRecEdcs.add(recEdc);
        }
        if (!addRecEdcs.isEmpty()) {
            OperateServiceHelper.execOperate((String)"save", (String)"cas_rec_edc", (DynamicObject[])addRecEdcs.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }
}

