/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recinit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.helper.BalanceCountHelper;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.GLBusinessHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.NumberUtils;
import kd.fi.cas.util.ViewUtils;

public class RecInitEdit
extends BillEditPlugin {
    private static final Log logger = LogFactory.getLog(RecInitEdit.class);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.initF7();
    }

    private void initF7() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getView().getControl("org");
        orgCtrl.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)"1")}, null);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)coll)));
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_adjustedbalance".equals(key.toLowerCase(Locale.ENGLISH))) {
            try {
                this.jumpToBalAdjTable();
            }
            catch (Throwable e) {
                throw new KDBizException(e.getMessage());
            }
        }
        if ("bar_bankunreach".equals(key.toLowerCase(Locale.ENGLISH))) {
            if (this.isFinishInit().booleanValue()) {
                return;
            }
            if (!this.validateSelectEntry()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\uff0c\u624d\u80fd\u8fdb\u884c\u672a\u8fbe\u8d26\u5f55\u5165\u3002", (String)"CashMgtInitEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.validateSelectSingleEntry()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5355\u884c\u5206\u5f55\uff0c\u8fdb\u884c\u672a\u8fbe\u8d26\u5f55\u5165\u3002", (String)"CashMgtInitEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showBankUnreachForm();
        }
        if ("bar_companyunreach".equals(key.toLowerCase(Locale.ENGLISH))) {
            if (this.isFinishInit().booleanValue()) {
                return;
            }
            if (!this.validateSelectEntry()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\uff0c\u624d\u80fd\u8fdb\u884c\u672a\u8fbe\u8d26\u5f55\u5165\u3002", (String)"CashMgtInitEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.validateSelectSingleEntry()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5355\u884c\u5206\u5f55\uff0c\u8fdb\u884c\u672a\u8fbe\u8d26\u5f55\u5165\u3002", (String)"CashMgtInitEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showCompanyUnreachForm();
        } else if ("bar_checkgl".equals(key.toLowerCase(Locale.ENGLISH))) {
            Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            Long startPeriodId = ((DynamicObject)this.getModel().getValue("startperiod")).getLong("id");
            GLBusinessHelper.checkAndShowWithGL((IFormView)this.getView(), (Long)orgId, (Long)startPeriodId, (Boolean)Boolean.TRUE);
        }
    }

    private Boolean isFinishInit() {
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            return false;
        }
        DynamicObject casRecInit = BusinessDataServiceHelper.loadSingle((String)"cas_rec_init", (String)"id, isfinishinit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (EmptyUtil.isNoEmpty((DynamicObject)casRecInit) && casRecInit.getBoolean("isfinishinit")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u5bf9\u8d26\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CashMgtInitEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (("finishinit".equals(operateKey) || "antiinit".equals(operateKey) || "save".equals(operateKey)) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh", OperateOption.create());
        } else if ("finishinit".equals(operateKey) && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            Map<String, Map<String, BigDecimal>> statementMap = this.getBankStatement(0L, 0L);
            Map<String, Map<String, BigDecimal>> journalMap = this.getBankJournal(0L, 0L);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrybank");
            int rowCount = this.getModel().getEntryRowCount("entrybank");
            for (int i = 0; i < rowCount; ++i) {
                if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)entryEntity.get(i)).getDynamicObject("bank_accountbank"), (DynamicObject)org)) continue;
                this.calcJournalBalanceAdj(i, statementMap);
                this.calcStatementBalanceAdj(i, journalMap);
                this.getView().updateView("bank_journalbalanceadj", i);
                this.getView().updateView("bank_journalsumbalanceadj", i);
                this.getView().updateView("bank_statementbalanceadj", i);
                this.getView().updateView("bank_equal", i);
            }
        }
    }

    public void afterBindData(EventObject e) {
        int i;
        super.afterBindData(e);
        DynamicObjectCollection entrybank = this.getModel().getEntryEntity("entrybank");
        DynamicObjectCollection entryCash = this.getModel().getEntryEntity("entrycash");
        int rowBankCount = this.getModel().getEntryRowCount("entrybank");
        HashSet<String> bankIdCurrents = new HashSet<String>(rowBankCount);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject initPeriod = this.getDynamicObject("initperiod");
        Boolean isFinishInit = (Boolean)this.getValue("isfinishinit");
        DynamicObjectCollection closedAcctColl = new DynamicObjectCollection();
        for (i = 0; i < rowBankCount; ++i) {
            DynamicObject accountbank = ((DynamicObject)entrybank.get(i)).getDynamicObject("bank_accountbank");
            DynamicObject bankCurrency = ((DynamicObject)entrybank.get(i)).getDynamicObject("bank_currency");
            if (accountbank == null || bankCurrency == null) continue;
            accountbank = AccountBankHelper.getAccountBankById((long)accountbank.getLong("id"));
            if (BankAcctStatusEnum.CLOSED.getValue().equals(accountbank.getString("acctstatus"))) {
                closedAcctColl.add(entrybank.get(i));
                continue;
            }
            Long bankId = accountbank.getLong("id");
            Long currentId = bankCurrency.getLong("id");
            bankIdCurrents.add(bankId + "_" + currentId);
            this.setValue("bank_bankaccountnumber", RecInitEdit.getAccountBankDisplay(accountbank), i);
            DynamicObject bankOpenOrg = ((DynamicObject)entrybank.get(i)).getDynamicObject("bank_openorg");
            DynamicObject addBankOpenOrg = accountbank.getDynamicObject("openorg");
            if (bankOpenOrg != null || addBankOpenOrg == null) continue;
            this.setValue("bank_openorg", addBankOpenOrg.getPkValue(), i);
        }
        if (!closedAcctColl.isEmpty()) {
            entrybank.removeAll((Collection)closedAcctColl);
            this.getModel().updateEntryCache(entrybank);
        }
        if (!isFinishInit.booleanValue()) {
            this.remainBankEntry(org, initPeriod, bankIdCurrents, rowBankCount);
        }
        if (!isFinishInit.booleanValue()) {
            this.remainCashEntry(org, initPeriod);
            entryCash = this.getModel().getEntryEntity("entrycash");
        }
        closedAcctColl.clear();
        int rowCount = this.getModel().getEntryRowCount("entrycash");
        for (i = 0; i < rowCount; ++i) {
            DynamicObject accountcash = ((DynamicObject)entryCash.get(i)).getDynamicObject("cash_accountcash");
            if ("1".equals(accountcash.getString("closestatus"))) {
                closedAcctColl.add(entryCash.get(i));
                continue;
            }
            this.setValue("cash_accountcashnumber", RecInitEdit.getAccountCashDisplay(accountcash), i);
        }
        if (!closedAcctColl.isEmpty()) {
            entryCash.removeAll((Collection)closedAcctColl);
            this.getModel().updateEntryCache(entryCash);
        }
        if (!isFinishInit.booleanValue()) {
            this.calculateStatementBalance();
            this.calculateJournalBalance();
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView("entrybank");
        this.getView().updateView("entrycash");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = this.getDynamicObject("org");
        if (org != null) {
            this.initLoad(org, this.isAddNew());
            DynamicObject dataEntity = this.getModel().getDataEntity();
            dataEntity.getDataEntityState().setBizChanged(false);
            DynamicObjectCollection entryBanks = dataEntity.getDynamicObjectCollection("entrybank");
            for (DynamicObject bank : entryBanks) {
                bank.getDataEntityState().setBizChanged(false);
            }
            DynamicObjectCollection entryCashs = dataEntity.getDynamicObjectCollection("entrycash");
            for (DynamicObject cash : entryCashs) {
                cash.getDataEntityState().setBizChanged(false);
            }
            this.fillToolBar((Boolean)this.getValue("isfinishinit"));
        }
    }

    private DynamicObject getRecInit(long orgId, long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("initperiod", "=", (Object)periodId)};
        DynamicObjectCollection recInitInfo = QueryServiceHelper.query((String)"cas_rec_init", (String)"id", (QFilter[])filters);
        if (recInitInfo.size() == 0) {
            return null;
        }
        DynamicObject recInit = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)recInitInfo.get(0)).getLong("id"), (String)"cas_rec_init");
        return recInit;
    }

    private void initLoad(DynamicObject org, Boolean isAddNew) {
        DynamicObject recInit;
        Boolean isfinishinit;
        long orgId = org.getLong("id");
        if (isAddNew.booleanValue()) {
            DynamicObject cashMgtInit = SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
            if (EmptyUtil.isEmpty((DynamicObject)cashMgtInit) || !cashMgtInit.getBoolean("isfinishinit")) {
                this.getModel().setValue("org", null);
                return;
            }
            DynamicObject currentperiod = cashMgtInit.getDynamicObject("currentperiod");
            if (cashMgtInit.getDynamicObject("startperiod") != null) {
                this.setValue("startperiod", cashMgtInit.getDynamicObject("startperiod").getLong("id"));
            }
            if (currentperiod != null) {
                this.setValue("initperiod", currentperiod.getLong("id"));
                this.setValue("currentperiod", currentperiod.getLong("id"));
            }
            this.setValue("standardcurrency", cashMgtInit.getDynamicObject("standardcurrency").getLong("id"));
            this.setValue("exratetable", cashMgtInit.getDynamicObject("exratetable").getLong("id"));
            this.setValue("periodtype", cashMgtInit.getDynamicObject("periodtype").getLong("id"));
            DynamicObject recInit2 = null;
            if (currentperiod != null) {
                recInit2 = this.getRecInit(orgId, currentperiod.getLong("id"));
            }
            if (recInit2 != null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit"});
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u5df2\u5b58\u5728%2$s\u671f\u95f4\u7684\u5bf9\u8d26\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RecInitEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), CasHelper.getLocalValue((DynamicObject)org, (String)"name"), CasHelper.getLocalValue((DynamicObject)currentperiod, (String)"name")));
                return;
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit"});
        }
        if ((isfinishinit = (Boolean)this.getValue("isfinishinit")).booleanValue()) {
            DynamicObjectCollection entrybank = this.getModel().getEntryEntity("entrybank");
            int rowCount = this.getModel().getEntryRowCount("entrybank");
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject accountbank = ((DynamicObject)entrybank.get(i)).getDynamicObject("bank_accountbank");
                this.setValue("bank_bankaccountnumber", RecInitEdit.getAccountBankDisplay(accountbank), i);
            }
            DynamicObjectCollection entrycash = this.getModel().getEntryEntity("entrycash");
            int rowCount2 = this.getModel().getEntryRowCount("entrycash");
            for (int i = 0; i < rowCount2; ++i) {
                DynamicObject accountcash = ((DynamicObject)entrycash.get(i)).getDynamicObject("cash_accountcash");
                this.setValue("cash_accountcashnumber", RecInitEdit.getAccountCashDisplay(accountcash), i);
            }
            return;
        }
        DynamicObject initperiod = this.getDynamicObject("initperiod");
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entrycash");
        dataModel.deleteEntryData("entrybank");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("closestatus", "!=", (Object)"1")};
        Map accountCashMap = BusinessDataServiceHelper.loadFromCache((String)"cas_accountcash", (QFilter[])filters);
        Map cashBalance = BalanceCountHelper.getCashBalance((Long)orgId, (DynamicObject)initperiod);
        for (DynamicObject accountCash : accountCashMap.values()) {
            DynamicObjectCollection currencyList = accountCash.getDynamicObjectCollection("currency");
            for (Object currency : currencyList) {
                int cashEntryIndex = dataModel.createNewEntryRow("entrycash");
                this.setValue("cash_accountcash", accountCash, cashEntryIndex);
                this.setValue("cash_accountcashnumber", RecInitEdit.getAccountCashDisplay(accountCash), cashEntryIndex);
                this.setValue("cash_currency", currency.get("fbasedataid"), cashEntryIndex);
                this.setValue("cash_yeardebit", new BigDecimal(0), cashEntryIndex);
                this.setValue("cash_yearcredit", new BigDecimal(0), cashEntryIndex);
                String key = BalanceCountHelper.getMapKey((DynamicObject)org, (DynamicObject)accountCash, (DynamicObject)currency.getDynamicObject("fbasedataid"));
                this.setValue("cash_balance", cashBalance.get(key), cashEntryIndex);
            }
        }
        QFilter accountBankFilterByOrg = new QFilter("createorg", "=", (Object)orgId);
        boolean isShowInnerAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"am").getId(), (String)"08", (Long)orgId, (String)"isshowinternalaccount");
        if (!isShowInnerAccount) {
            accountBankFilterByOrg.and(new QFilter("finorgtype", "!=", (Object)Character.valueOf('1')));
        }
        Map accountBankMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{accountBankFilterByOrg, new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue())});
        Map journalBalance = BalanceCountHelper.getJournalBalance((Long)orgId, (DynamicObject)initperiod);
        for (DynamicObject accountbank : accountBankMap.values()) {
            DynamicObjectCollection currencyList = accountbank.getDynamicObjectCollection("currency");
            Iterator iterator = currencyList.iterator();
            while (iterator.hasNext()) {
                DynamicObject currency = (DynamicObject)iterator.next();
                if (CasHelper.isEmpty((Object)currency) || CasHelper.isEmpty((Object)currency.get("fbasedataid"))) continue;
                int cashEntryIndex = dataModel.createNewEntryRow("entrybank");
                this.setValue("bank_accountbank", accountbank.getPkValue(), cashEntryIndex);
                DynamicObject openorg = accountbank.getDynamicObject("openorg");
                if (openorg != null && EmptyUtil.isNoEmpty((DynamicObject)openorg)) {
                    this.setValue("bank_openorg", openorg.getPkValue(), cashEntryIndex);
                }
                this.setValue("bank_bankaccountnumber", RecInitEdit.getAccountBankDisplay(accountbank), cashEntryIndex);
                this.setValue("bank_currency", currency.get("fbasedataid"), cashEntryIndex);
                this.setValue("bank_journaldebit", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_journalcredit", new BigDecimal(0), cashEntryIndex);
                String key = BalanceCountHelper.getMapKey((DynamicObject)org, (DynamicObject)accountbank, (DynamicObject)currency.getDynamicObject("fbasedataid"));
                this.setValue("bank_journalbalance", journalBalance.get(key), cashEntryIndex);
                this.setValue("bank_journalbalanceadj", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_statementdebit", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_statementcredit", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_statementbalance", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_statementbalanceadj", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_journalsumbalanceadj", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_equal", "1", cashEntryIndex);
            }
        }
        if (initperiod != null && (recInit = this.getRecInit(orgId, initperiod.getLong("id"))) != null) {
            DynamicObjectCollection bankEntryList = recInit.getDynamicObjectCollection("entrybank");
            for (DynamicObject bankEntry : bankEntryList) {
                int size = dataModel.getEntryRowCount("entrybank");
                for (int i = 0; i < size; ++i) {
                    if (CasHelper.isEmpty((Object)bankEntry.getDynamicObject("bank_accountbank")) || CasHelper.isEmpty((Object)bankEntry.getDynamicObject("bank_currency"))) continue;
                    long initAccountBankId = bankEntry.getDynamicObject("bank_accountbank").getLong("id");
                    long initCurrencyId = bankEntry.getDynamicObject("bank_currency").getLong("id");
                    long entryAccountBankId = this.getPk("bank_accountbank", i);
                    long entryCurrencyId = this.getPk("bank_currency", i);
                    if (initAccountBankId != entryAccountBankId || initCurrencyId != entryCurrencyId) continue;
                    this.setValue("bank_journalbalanceadj", bankEntry.getBigDecimal("bank_journalbalanceadj"), i);
                    this.setValue("bank_statementdebit", bankEntry.getBigDecimal("bank_statementdebit"), i);
                    this.setValue("bank_statementcredit", bankEntry.getBigDecimal("bank_statementcredit"), i);
                    this.setValue("bank_statementbalance", bankEntry.getBigDecimal("bank_statementbalance"), i);
                    this.setValue("bank_statementbalanceadj", bankEntry.getBigDecimal("bank_statementbalanceadj"), i);
                }
            }
        }
        Map<String, Map<String, BigDecimal>> statementMap = this.getBankStatement(0L, 0L);
        Map<String, Map<String, BigDecimal>> journalMap = this.getBankJournal(0L, 0L);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrybank");
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        ArrayList<Integer> journalIndexs = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("entrybank");
        for (int i = 0; i < rowCount; ++i) {
            if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)entryEntity.get(i)).getDynamicObject("bank_accountbank"), (DynamicObject)org)) {
                ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
                lstFilters.add(new QFilter("org", "=", (Object)((DynamicObject)entryEntity.get(i)).getDynamicObject("bank_accountbank").getDynamicObject("createorg").getLong("id")));
                lstFilters.add(new QFilter("isfinishinit", "=", (Object)"1"));
                DynamicObject[] cashmgtInitDy = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id", (QFilter[])lstFilters.toArray(new QFilter[0]));
                if (cashmgtInitDy != null && cashmgtInitDy.length > 0) {
                    journalIndexs.add(i);
                } else {
                    this.calcJournalBalanceAdj(i, statementMap);
                }
                this.setValue("bank_statementdebit", new BigDecimal(0), i);
                this.setValue("bank_statementcredit", new BigDecimal(0), i);
                this.setValue("bank_statementbalance", new BigDecimal(0), i);
                this.setValue("bank_statementbalanceadj", new BigDecimal(0), i);
                this.setValue("bank_journalsumbalanceadj", new BigDecimal(0), i);
                this.setValue("bank_equal", "0", i);
                indexs.add(i);
                continue;
            }
            this.calcJournalBalanceAdj(i, statementMap);
            this.calcStatementBalanceAdj(i, journalMap);
        }
        ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"cash_yeardebit", "cash_yearcredit", "cash_balance", "bank_journaldebit", "bank_journalcredit", "bank_journalbalance", "bank_statementdebit", "bank_statementcredit", "bank_statementbalance"});
        if (indexs.size() > 0) {
            RecInitEdit.setEnable((AbstractFormPlugin)this, false, indexs, "bank_statementdebit", "bank_statementcredit", "bank_statementbalance");
        }
        if (journalIndexs.size() > 0) {
            RecInitEdit.setEnable((AbstractFormPlugin)this, false, journalIndexs, "bank_journaldebit", "bank_journalcredit", "bank_journalbalance");
        }
    }

    public static void setEnable(AbstractFormPlugin plugin, boolean enable, List<Integer> indexs, String ... ctrlId) {
        for (int i = 0; i < ctrlId.length; ++i) {
            RecInitEdit.innerSetEnable(plugin, enable, ctrlId[i], indexs);
        }
    }

    private static void innerSetEnable(AbstractFormPlugin plugin, boolean enable, String ctrlId, List<Integer> indexs) {
        Control ctrl = plugin.getView().getControl(ctrlId);
        if (ctrl == null || ctrl instanceof Button) {
            plugin.getView().setEnable(Boolean.valueOf(enable), new String[]{ctrlId});
        } else if (ctrl instanceof FieldEdit) {
            FieldEdit edit = (FieldEdit)ctrl;
            if (edit.getProperty().getParent() instanceof EntryType) {
                for (int i : indexs) {
                    edit.setEnable("", enable, i);
                }
            } else {
                edit.setEnable("", enable, 0);
            }
        } else {
            throw new RuntimeException("control error");
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entrybank");
        final RecInitEdit $this = this;
        final IFormView view = this.getView();
        entryGrid.addCellClickListener(new CellClickListener(){

            public void cellDoubleClick(CellClickEvent doubleEvt) {
            }

            public void cellClick(CellClickEvent singEvt) {
                int index = singEvt.getRow();
                Object value = view.getModel().getValue("bank_accountbank", index);
                DynamicObject org = view.getModel().getDataEntity().getDynamicObject("org");
                if (!((Boolean)RecInitEdit.this.getValue("isfinishinit")).booleanValue()) {
                    if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)value), (DynamicObject)org)) {
                        ViewUtils.setEnable((AbstractFormPlugin)$this, (boolean)false, (String[])new String[]{"bar_bankunreach", "bar_companyunreach", "bar_adjustedbalance"});
                    } else {
                        ViewUtils.setEnable((AbstractFormPlugin)$this, (boolean)true, (String[])new String[]{"bar_bankunreach", "bar_companyunreach", "bar_adjustedbalance"});
                        ViewUtils.setVisible((AbstractFormPlugin)$this, (boolean)true, (String[])new String[]{"bar_adjustedbalance"});
                    }
                }
            }
        });
        entryGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
                String fieldName = hyperLinkClickEvent.getFieldName();
                if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"bank_journalsumbalanceadj")) {
                    Object value = $this.getModel().getValue("bank_accountbank", hyperLinkClickEvent.getRowIndex());
                    DynamicObject startPeriod = (DynamicObject)$this.getModel().getValue("startperiod");
                    DynamicObject org = view.getModel().getDataEntity().getDynamicObject("org");
                    Object currency = $this.getModel().getValue("bank_currency", hyperLinkClickEvent.getRowIndex());
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setFormId("cas_totalamount");
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    parameter.setCustomParam("accountbankId", ((DynamicObject)value).getPkValue());
                    parameter.setCustomParam("currencyId", ((DynamicObject)currency).getPkValue());
                    parameter.setCustomParam("orgId", (Object)org.getString("id"));
                    parameter.setCustomParam("orgname", (Object)org.getLocaleString("name").getLocaleValue());
                    parameter.setCustomParam("modifytime", (Object)startPeriod.getDate("begindate"));
                    parameter.setCustomParam("journalbalance", $this.getModel().getValue("bank_journalbalance", hyperLinkClickEvent.getRowIndex()));
                    parameter.setCustomParam("journalbalanceadj", $this.getModel().getValue("bank_journalbalanceadj", hyperLinkClickEvent.getRowIndex()));
                    $this.getView().showForm(parameter);
                }
            }
        });
    }

    private static String getAccountBankDisplay(DynamicObject accountBank) {
        if (accountBank == null) {
            return "";
        }
        if (accountBank.getString("bankaccountnumber") != null && !accountBank.getString("bankaccountnumber").trim().equals("")) {
            return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
        }
        accountBank = AccountBankHelper.getAccountBankById((long)accountBank.getLong("id"));
        return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
    }

    private static String getAccountCashDisplay(DynamicObject accountCash) {
        if (accountCash == null) {
            return "";
        }
        if (accountCash.getString("number") != null && !accountCash.getString("number").trim().equals("")) {
            return accountCash.getString("number") + "\n" + accountCash.getString("name");
        }
        accountCash = AccountCashHelper.getAccountCashById((long)accountCash.getLong("id"));
        return accountCash.getString("number") + "\n" + accountCash.getString("name");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals("bank_journalbalance")) {
            int entryIndex = e.getChangeSet()[0].getRowIndex();
            Long rowAcctbankId = this.getPk("bank_accountbank", entryIndex);
            Long rowCurrencyId = this.getPk("bank_currency", entryIndex);
            Map<String, Map<String, BigDecimal>> statementMap = this.getBankStatement(rowAcctbankId, rowCurrencyId);
            this.calcJournalBalanceAdj(entryIndex, statementMap);
        } else if (propertyName.equals("bank_statementbalance")) {
            int entryIndex = e.getChangeSet()[0].getRowIndex();
            Long rowAcctbankId = this.getPk("bank_accountbank", entryIndex);
            Long rowCurrencyId = this.getPk("bank_currency", entryIndex);
            Map<String, Map<String, BigDecimal>> journalMap = this.getBankJournal(rowAcctbankId, rowCurrencyId);
            this.calcStatementBalanceAdj(entryIndex, journalMap);
        }
    }

    private void calcJournalBalanceAdj(int entryIndex, Map<String, Map<String, BigDecimal>> statementMap) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        Long rowAcctbankId = this.getPk("bank_accountbank", entryIndex);
        Long rowCurrencyId = this.getPk("bank_currency", entryIndex);
        BigDecimal journalBalance = (BigDecimal)this.getModel().getValue("bank_journalbalance", entryIndex);
        BigDecimal debitAmount = new BigDecimal(0);
        BigDecimal creditAmount = new BigDecimal(0);
        if (statementMap.get(rowAcctbankId + "-" + rowCurrencyId) != null) {
            debitAmount = statementMap.get(rowAcctbankId + "-" + rowCurrencyId).get("debitamount");
            creditAmount = statementMap.get(rowAcctbankId + "-" + rowCurrencyId).get("creditamount");
        }
        BigDecimal journalBalanceAdj = journalBalance.add(creditAmount).subtract(debitAmount);
        this.setValue("bank_journalbalanceadj", journalBalanceAdj, entryIndex);
        BigDecimal sumBalanceAdj = this.getUseOrgJournalAmount(entryIndex);
        BigDecimal statementBalanceAdj = (BigDecimal)this.getModel().getValue("bank_statementbalanceadj", entryIndex);
        if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)this.getModel().getValue("bank_accountbank", entryIndex)), (DynamicObject)org)) {
            this.setValue("bank_journalsumbalanceadj", BigDecimal.ZERO, entryIndex);
            this.setValue("bank_equal", "0", entryIndex);
        } else {
            this.setValue("bank_journalsumbalanceadj", sumBalanceAdj, entryIndex);
            this.setValue("bank_equal", NumberUtils.equals((BigDecimal)sumBalanceAdj, (BigDecimal)statementBalanceAdj) ? "1" : "0", entryIndex);
        }
    }

    private BigDecimal getUseOrgJournalAmount(int entryIndex) {
        BigDecimal totalAmount = new BigDecimal(0);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject createOegStartPeriod = dataEntity.getDynamicObject("initperiod");
        long accountbankId = ((DynamicObject)this.getModel().getValue("bank_accountbank", entryIndex)).getLong("id");
        long currencyId = ((DynamicObject)this.getModel().getValue("bank_currency", entryIndex)).getLong("id");
        DynamicObject[] cashmgtInitDy = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org,startperiod,currentperiod,isfinishinit,entrybank.bank_accountbank,entrybank.bank_currency,entrybank.bank_journalbalance,entrybank.bank_journalbalanceadj", (QFilter[])new QFilter[]{new QFilter("entrybank.bank_accountbank", "=", (Object)accountbankId)});
        boolean isSave = false;
        for (DynamicObject dyObj : cashmgtInitDy) {
            if (dyObj.getDynamicObject("org").getLong("id") == org.getLong("id")) {
                isSave = true;
                totalAmount = totalAmount.add((BigDecimal)this.getModel().getValue("bank_journalbalanceadj", entryIndex));
                continue;
            }
            if (!dyObj.getBoolean("isfinishinit")) continue;
            DynamicObjectCollection bankCollection = dyObj.getDynamicObjectCollection("entrybank");
            for (DynamicObject dyObj1 : bankCollection) {
                Date createOrgBeginDate;
                long accountBankId1 = dyObj1.getDynamicObject("bank_accountbank").getLong("id");
                long currencyId1 = dyObj1.getDynamicObject("bank_currency").getLong("id");
                if (accountBankId1 != accountbankId || currencyId1 != currencyId) continue;
                DynamicObject useorgStartPeriod = dyObj.getDynamicObject("startperiod");
                Date useOrgBeginDate = useorgStartPeriod.getDate("begindate");
                if (useOrgBeginDate.compareTo(createOrgBeginDate = createOegStartPeriod.getDate("begindate")) < 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(createOrgBeginDate);
                    calendar.add(5, -1);
                    Date endDate = calendar.getTime();
                    BalanceCountService balanceCountService = new BalanceCountService();
                    BigDecimal accountBalance = balanceCountService.getJournalBalance(dyObj, Long.valueOf(dyObj.getDynamicObject("org").getLong("id")), Long.valueOf(accountBankId1), Long.valueOf(currencyId1), endDate);
                    totalAmount = totalAmount.add(accountBalance);
                    continue;
                }
                BigDecimal journalbalance1 = dyObj1.getBigDecimal("bank_journalbalance");
                totalAmount = totalAmount.add(journalbalance1);
            }
        }
        if (!isSave) {
            totalAmount = totalAmount.add((BigDecimal)this.getModel().getValue("bank_journalbalanceadj", entryIndex));
        }
        return totalAmount;
    }

    private void calcStatementBalanceAdj(int entryIndex, Map<String, Map<String, BigDecimal>> journalMap) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        Long rowAcctbankId = this.getPk("bank_accountbank", entryIndex);
        Long rowCurrencyId = this.getPk("bank_currency", entryIndex);
        BigDecimal statementBalance = (BigDecimal)this.getModel().getValue("bank_statementbalance", entryIndex);
        BigDecimal debitAmount = new BigDecimal(0);
        BigDecimal creditAmount = new BigDecimal(0);
        if (journalMap.get(rowAcctbankId + "-" + rowCurrencyId) != null) {
            debitAmount = journalMap.get(rowAcctbankId + "-" + rowCurrencyId).get("debitamount");
            creditAmount = journalMap.get(rowAcctbankId + "-" + rowCurrencyId).get("creditamount");
        }
        BigDecimal statementBalanceAdj = statementBalance.add(debitAmount).subtract(creditAmount);
        BigDecimal journalBalanceAdj = (BigDecimal)this.getModel().getValue("bank_journalsumbalanceadj", entryIndex);
        if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)this.getModel().getValue("bank_accountbank", entryIndex)), (DynamicObject)org)) {
            this.setValue("bank_statementbalanceadj", BigDecimal.ZERO, entryIndex);
            this.setValue("bank_equal", "0", entryIndex);
        } else {
            this.setValue("bank_statementbalanceadj", statementBalanceAdj, entryIndex);
            this.setValue("bank_equal", NumberUtils.equals((BigDecimal)journalBalanceAdj, (BigDecimal)statementBalanceAdj) ? "1" : "0", entryIndex);
        }
    }

    private Map<String, Map<String, BigDecimal>> getBankJournal(long bankacctId, long currencyId) {
        Long orgId = this.getPk("org");
        String selectors = "accountbank as faccountbankid,currency as fcurrencyid,debitamount,creditamount";
        QFilter[] filters = null;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)0L);
        QFilter recperiodFilter = new QFilter("recinitperiod", "=", (Object)this.getPk("initperiod"));
        if (bankacctId != 0L) {
            QFilter accountFilter = new QFilter("accountbank", "=", (Object)bankacctId);
            QFilter currencyFilter = new QFilter("currency", "=", (Object)currencyId);
            filters = new QFilter[]{orgFilter, periodFilter, recperiodFilter, accountFilter, currencyFilter};
        } else {
            filters = new QFilter[]{orgFilter, periodFilter, recperiodFilter};
        }
        HashMap<String, Map<String, BigDecimal>> mapJournal = new HashMap<String, Map<String, BigDecimal>>();
        try (DataSet bankStatementDataSet = QueryServiceHelper.queryDataSet((String)"cas.cashmgtinit.bankjournal", (String)"cas_bankjournal", (String)selectors, (QFilter[])filters, null);
             DataSet groupByDataSet = bankStatementDataSet.groupBy(new String[]{"faccountbankid", "fcurrencyid"}).sum("debitamount").sum("creditamount").finish();){
            groupByDataSet.forEach(row -> {
                Long rowAcctbankId = (Long)row.get("faccountbankid");
                Long rowCurrencyId = (Long)row.get("fcurrencyid");
                BigDecimal debitamount = (BigDecimal)row.get("debitamount");
                BigDecimal creditamount = (BigDecimal)row.get("creditamount");
                HashMap<String, BigDecimal> rowData = new HashMap<String, BigDecimal>();
                rowData.put("debitamount", debitamount);
                rowData.put("creditamount", creditamount);
                mapJournal.put(rowAcctbankId + "-" + rowCurrencyId, rowData);
            });
        }
        return mapJournal;
    }

    private Map<String, Map<String, BigDecimal>> getBankStatement(long bankacctId, long currencyId) {
        Long orgId = this.getPk("org");
        String selectors = "accountbank as faccountbankid,currency as fcurrencyid,debitamount,creditamount";
        QFilter[] filters = null;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)0L);
        QFilter recperiodFilter = new QFilter("recinitperiod", "=", (Object)this.getPk("initperiod"));
        if (bankacctId != 0L) {
            QFilter accountFilter = new QFilter("accountbank", "=", (Object)bankacctId);
            QFilter currencyFilter = new QFilter("currency", "=", (Object)currencyId);
            filters = new QFilter[]{orgFilter, periodFilter, recperiodFilter, accountFilter, currencyFilter};
        } else {
            filters = new QFilter[]{orgFilter, periodFilter, recperiodFilter};
        }
        HashMap<String, Map<String, BigDecimal>> mapStatement = new HashMap<String, Map<String, BigDecimal>>();
        try (DataSet bankStatementDataSet = QueryServiceHelper.queryDataSet((String)"cas.cashmgtinit.bankstatement", (String)"cas_bankstatement", (String)selectors, (QFilter[])filters, null);
             DataSet groupByDataSet = bankStatementDataSet.groupBy(new String[]{"faccountbankid", "fcurrencyid"}).sum("debitamount").sum("creditamount").finish();){
            groupByDataSet.forEach(row -> {
                Long rowAcctbankId = (Long)row.get("faccountbankid");
                Long rowCurrencyId = (Long)row.get("fcurrencyid");
                BigDecimal debitamount = (BigDecimal)row.get("debitamount");
                BigDecimal creditamount = (BigDecimal)row.get("creditamount");
                HashMap<String, BigDecimal> rowData = new HashMap<String, BigDecimal>();
                rowData.put("debitamount", debitamount);
                rowData.put("creditamount", creditamount);
                mapStatement.put(rowAcctbankId + "-" + rowCurrencyId, rowData);
            });
        }
        return mapStatement;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void jumpToBalAdjTable() throws Throwable {
        ShowType showType;
        EntryGrid entryBank = (EntryGrid)this.getControl("entrybank");
        int[] rowIndexs = entryBank.getSelectRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5206\u5f55\uff0c\u518d\u67e5\u770b\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"CashMgtInitEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex("entrybank");
        DynamicObject cashmgtinitbank = this.getModel().getEntryRowEntity("entrybank", index);
        Long acct = (Long)cashmgtinitbank.getDynamicObject("bank_accountbank").getPkValue();
        Long currency = (Long)cashmgtinitbank.getDynamicObject("bank_currency").getPkValue();
        BigDecimal journal = cashmgtinitbank.getBigDecimal("bank_journalbalance");
        BigDecimal statem = cashmgtinitbank.getBigDecimal("bank_statementbalance");
        Object startPeriod = this.getModel().getValue("startperiod");
        Long startPeriodId = 0L;
        if (startPeriod != null) {
            startPeriodId = ((DynamicObject)startPeriod).getLong("id");
        }
        Long orgId = this.getPk("org");
        if (((Boolean)this.getModel().getValue("isfinishinit")).booleanValue()) {
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and(new QFilter("bankaccount", "=", (Object)acct));
            filter.and(new QFilter("currency", "=", (Object)currency)).and("period", "=", (Object)0);
            DynamicObject[] balances = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id", (QFilter[])new QFilter[]{filter});
            if (balances != null && balances.length > 0) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("cas_balanceadjust");
                parameter.setCustomParam("isinit", (Object)"1");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setPkId(balances[0].getPkValue());
                this.getView().showForm((FormShowParameter)parameter);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u65f6\u672a\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\uff01", (String)"CashMgtInitEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Date begindate = this.getModel().getDataEntity().getDynamicObject("initperiod").getDate("begindate");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cas_balanceadjust");
        parameter.setCustomParam("org", (Object)orgId);
        parameter.setCustomParam("accountbank", (Object)acct);
        parameter.setCustomParam("currency", (Object)currency);
        parameter.setCustomParam("enddate", (Object)DateUtils.getLastDay((Date)begindate, (int)1));
        parameter.setCustomParam("isinit", (Object)"1");
        parameter.setCustomParam("journal", (Object)journal);
        parameter.setCustomParam("startPeriod", (Object)startPeriodId);
        parameter.setCustomParam("statem", (Object)statem);
        parameter.setCustomParam("acct", (Object)acct);
        parameter.setCustomParam("acct", (Object)acct);
        ShowType parentshowType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (parentshowType == ShowType.Modal) {
            showType = ShowType.Modal;
        } else {
            showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
            parameter.getOpenStyle().setTargetKey("tabap");
        }
        parameter.getOpenStyle().setShowType(showType);
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(parameter);
    }

    private boolean validateSelectEntry() {
        EntryGrid entryBank = (EntryGrid)this.getControl("entrybank");
        int[] rowIndexs = entryBank.getSelectRows();
        return rowIndexs != null && rowIndexs.length != 0;
    }

    private boolean validateSelectSingleEntry() {
        EntryGrid entryBank = (EntryGrid)this.getControl("entrybank");
        int[] rowIndexs = entryBank.getSelectRows();
        return rowIndexs != null && rowIndexs.length == 1;
    }

    private void showBankUnreachForm() {
        ShowType showType;
        Long orgid = this.getPk("org");
        Long periodid = this.getPk("initperiod");
        int index = this.getModel().getEntryCurrentRowIndex("entrybank");
        DynamicObject cashmgtinitbank = this.getModel().getEntryRowEntity("entrybank", index);
        Long accountbankid = (Long)cashmgtinitbank.getDynamicObject("bank_accountbank").getPkValue();
        Long currencyid = (Long)cashmgtinitbank.getDynamicObject("bank_currency").getPkValue();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cas_bankunreachedit");
        parameter.setCustomParam("orgid", (Object)orgid);
        parameter.setCustomParam("periodid", (Object)periodid);
        parameter.setCustomParam("accountbankid", (Object)accountbankid);
        parameter.setCustomParam("currencyid", (Object)currencyid);
        ShowType parentshowType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (parentshowType == ShowType.Modal) {
            showType = ShowType.Modal;
        } else {
            showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
            parameter.getOpenStyle().setTargetKey("tabap");
        }
        parameter.getOpenStyle().setShowType(showType);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calcBankUnreach"));
        this.getView().showForm(parameter);
    }

    private void showCompanyUnreachForm() {
        ShowType showType;
        Long orgid = this.getPk("org");
        Long periodid = this.getPk("initperiod");
        int index = this.getModel().getEntryCurrentRowIndex("entrybank");
        DynamicObject cashmgtinitbank = this.getModel().getEntryRowEntity("entrybank", index);
        Long accountbankid = (Long)cashmgtinitbank.getDynamicObject("bank_accountbank").getPkValue();
        Long currencyid = (Long)cashmgtinitbank.getDynamicObject("bank_currency").getPkValue();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cas_companyunreachedit");
        parameter.setCustomParam("orgid", (Object)orgid);
        parameter.setCustomParam("periodid", (Object)periodid);
        parameter.setCustomParam("accountbankid", (Object)accountbankid);
        parameter.setCustomParam("currencyid", (Object)currencyid);
        ShowType parentshowType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (parentshowType == ShowType.Modal) {
            showType = ShowType.Modal;
        } else {
            showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
            parameter.getOpenStyle().setTargetKey("tabap");
        }
        parameter.getOpenStyle().setShowType(showType);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calcCompanyUnreach"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("calcBankUnreach".equals(e.getActionId())) {
            this.calculateStatementBalance();
        } else if ("calcCompanyUnreach".equals(e.getActionId())) {
            this.calculateJournalBalance();
        }
    }

    private void calculateStatementBalance() {
        Map<String, Map<String, BigDecimal>> journalMap = this.getBankJournal(0L, 0L);
        int rowCount = this.getModel().getEntryRowCount("entrybank");
        for (int i = 0; i < rowCount; ++i) {
            this.calcStatementBalanceAdj(i, journalMap);
        }
    }

    private void calculateJournalBalance() {
        Map<String, Map<String, BigDecimal>> statementMap = this.getBankStatement(0L, 0L);
        int rowCount = this.getModel().getEntryRowCount("entrybank");
        for (int i = 0; i < rowCount; ++i) {
            this.calcJournalBalanceAdj(i, statementMap);
        }
    }

    private void fillToolBar(boolean isfinishinit) {
        ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"bar_save", "bar_finishinit", "bar_antiinit", "bar_bankunreach", "bar_companyunreach"});
        ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"bar_adjustedbalance"});
        if (isfinishinit) {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"bar_save", "bar_finishinit", "bar_bankunreach", "bar_companyunreach"});
        } else {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"bar_antiinit"});
        }
    }

    private boolean isAddNew() {
        return this.getView().getFormShowParameter().getStatus().toString().equals("ADDNEW");
    }

    private void remainCashEntry(DynamicObject org, DynamicObject initperiod) {
        if (org == null) {
            return;
        }
        long orgId = org.getLong("id");
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entrycash");
        Map cashBalance = BalanceCountHelper.getCashBalance((Long)orgId, (DynamicObject)initperiod);
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("closestatus", "!=", (Object)"1")};
        Map accountCashMap = BusinessDataServiceHelper.loadFromCache((String)"cas_accountcash", (QFilter[])filters);
        for (DynamicObject accountCash : accountCashMap.values()) {
            DynamicObjectCollection currencyList = accountCash.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencyList) {
                int cashEntryIndex = dataModel.createNewEntryRow("entrycash");
                this.setValue("cash_accountcash", accountCash, cashEntryIndex);
                this.setValue("cash_accountcashnumber", RecInitEdit.getAccountCashDisplay(accountCash), cashEntryIndex);
                this.setValue("cash_currency", currency.get("fbasedataid"), cashEntryIndex);
                this.setValue("cash_yeardebit", new BigDecimal(0), cashEntryIndex);
                this.setValue("cash_yearcredit", new BigDecimal(0), cashEntryIndex);
                String key = BalanceCountHelper.getMapKey((DynamicObject)org, (DynamicObject)accountCash, (DynamicObject)currency.getDynamicObject("fbasedataid"));
                this.setValue("cash_balance", cashBalance.get(key), cashEntryIndex);
            }
        }
    }

    private void remainBankEntry(DynamicObject org, DynamicObject initperiod, Set<String> bankIdCurrents, int rowBankCount) {
        IDataModel dataModel = this.getModel();
        if (org == null) {
            return;
        }
        long orgId = org.getLong("id");
        QFilter accountBankFilterByOrg = new QFilter("createorg", "=", (Object)orgId);
        boolean isShowInnerAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"am").getId(), (String)"08", (Long)orgId, (String)"isshowinternalaccount");
        if (!isShowInnerAccount) {
            accountBankFilterByOrg.and(new QFilter("finorgtype", "!=", (Object)Character.valueOf('1')));
        }
        Map accountBankMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{accountBankFilterByOrg, new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue())});
        AtomicInteger bankCount = new AtomicInteger(0);
        accountBankMap.forEach((key, value) -> {
            DynamicObjectCollection bankList = value.getDynamicObjectCollection("currency");
            bankList.stream().filter(o -> CasHelper.isNotEmpty((Object)o) && CasHelper.isNotEmpty((Object)o.get("fbasedataid"))).forEach(p -> bankCount.getAndIncrement());
        });
        if (rowBankCount == bankCount.get()) {
            return;
        }
        Map journalBalance = BalanceCountHelper.getJournalBalance((Long)orgId, (DynamicObject)initperiod);
        for (DynamicObject accountbank : accountBankMap.values()) {
            DynamicObjectCollection currencyList = accountbank.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencyList) {
                if (CasHelper.isEmpty((Object)currency) || CasHelper.isEmpty((Object)currency.get("fbasedataid"))) continue;
                DynamicObject baseDataId = currency.getDynamicObject("fbasedataid");
                Long currentId = baseDataId.getLong("id");
                Long bankId = accountbank.getLong("id");
                String bankCurrent = bankId + "_" + currentId;
                if (bankIdCurrents.contains(bankCurrent)) continue;
                int cashEntryIndex = dataModel.createNewEntryRow("entrybank");
                this.setValue("bank_accountbank", accountbank.getPkValue(), cashEntryIndex);
                DynamicObject openorg = accountbank.getDynamicObject("openorg");
                if (openorg != null) {
                    this.setValue("bank_openorg", openorg.getPkValue(), cashEntryIndex);
                }
                this.setValue("bank_bankaccountnumber", RecInitEdit.getAccountBankDisplay(accountbank), cashEntryIndex);
                this.setValue("bank_currency", currency.get("fbasedataid"), cashEntryIndex);
                this.setValue("bank_journaldebit", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_journalcredit", new BigDecimal(0), cashEntryIndex);
                String key2 = BalanceCountHelper.getMapKey((DynamicObject)org, (DynamicObject)accountbank, (DynamicObject)currency.getDynamicObject("fbasedataid"));
                this.setValue("bank_journalbalance", journalBalance.get(key2), cashEntryIndex);
                this.setValue("bank_journalbalanceadj", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_statementdebit", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_statementcredit", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_statementbalance", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_statementbalanceadj", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_journalsumbalanceadj", new BigDecimal(0), cashEntryIndex);
                this.setValue("bank_equal", "1", cashEntryIndex);
            }
        }
    }
}

