/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recsupdivide;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;

public class RecOrgsDividePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.fillSettleOrg();
    }

    private void fillSettleOrg() {
        BasedataEdit settleorg = (BasedataEdit)this.getControl("settleorg");
        settleorg.addBeforeF7SelectListener(select -> {
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            showParam.setCustomParam("orgFuncId", (Object)"10");
            Object formPOJO = this.getView().getFormShowParameter().getCustomParam("formPOJO");
            Map recData = (Map)JSON.parseObject((String)formPOJO.toString(), Map.class);
            if (CasHelper.isEmpty((Object)recData)) {
                return;
            }
            Object settleorgId = recData.get("settleorg");
            if (CasHelper.isNotEmpty(settleorgId)) {
                showParam.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", settleorgId));
            }
        });
    }

    public void beforeBindData(EventObject e) {
        Object currency;
        super.beforeBindData(e);
        AmountEdit fee = (AmountEdit)this.getControl("fee");
        fee.addTips(new Tips("text", null, new LocaleString(this.getFeeTip()), false, null));
        AmountEdit discountamt = (AmountEdit)this.getControl("discountamt");
        discountamt.addTips(new Tips("text", null, new LocaleString(this.getDiscountTip()), false, null));
        Object formPOJO = this.getView().getFormShowParameter().getCustomParam("formPOJO");
        Map recData = (Map)JSON.parseObject((String)formPOJO.toString(), Map.class);
        if (CasHelper.isEmpty((Object)recData)) {
            return;
        }
        Object e_remark = recData.get("e_remark");
        Object e_fundflowitem = recData.get("e_fundflowitem");
        this.getModel().setValue("fundflowitem", e_fundflowitem);
        if (CasHelper.isNotEmpty(e_remark)) {
            this.getModel().setValue("remark", e_remark);
        }
        if (CasHelper.isNotEmpty(currency = recData.get("currency"))) {
            this.getModel().setValue("currency", currency);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty iDataEntityProperty = e.getProperty();
        String propertyName = iDataEntityProperty.getName();
        Object formPOJO = this.getView().getFormShowParameter().getCustomParam("formPOJO");
        Map recData = (Map)JSON.parseObject((String)formPOJO.toString(), Map.class);
        BigDecimal e_actamt = (BigDecimal)recData.get("e_actamt");
        BigDecimal e_fee = (BigDecimal)recData.get("e_fee");
        BigDecimal e_discountamt = (BigDecimal)recData.get("e_discountamt");
        switch (propertyName) {
            case "actamt": {
                BigDecimal divideAmount;
                BigDecimal actamt = (BigDecimal)this.getModel().getValue("actamt");
                if (actamt == null || e_actamt == null) break;
                if (CasHelper.isNotEmpty((Object)e_fee)) {
                    divideAmount = this.getDivideAmount(e_actamt, actamt, e_fee);
                    this.getModel().setValue("fee", (Object)divideAmount);
                }
                if (!CasHelper.isNotEmpty((Object)e_discountamt)) break;
                divideAmount = this.getDivideAmount(e_actamt, actamt, e_discountamt);
                this.getModel().setValue("discountamt", (Object)divideAmount);
                break;
            }
            case "fee": 
            case "discountamt": {
                this.getnReceivableamt();
                break;
            }
            case "settleorg": {
                DynamicObject settleorg = (DynamicObject)this.getModel().getValue("settleorg");
                if (!CasHelper.isNotEmpty((Object)settleorg) || SystemStatusCtrolHelper.isInitEnable((long)settleorg.getLong("id"))) break;
                this.getView().showTipNotification(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)settleorg, (String)"name")));
                this.getModel().setValue("settleorg", null);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("btnok".equals(operateKey) && opResult.isSuccess()) {
            Object formPOJO = this.getView().getFormShowParameter().getCustomParam("formPOJO");
            Map recData = (Map)JSON.parseObject((String)formPOJO.toString(), Map.class);
            if (CasHelper.isEmpty((Object)recData)) {
                return;
            }
            BigDecimal e_fee = (BigDecimal)recData.get("e_fee");
            BigDecimal e_discountamt = (BigDecimal)recData.get("e_discountamt");
            BigDecimal e_unlockamt = (BigDecimal)recData.get("e_unlockamt");
            if (CasHelper.isEmpty((Object)e_fee)) {
                e_fee = BigDecimal.ZERO;
            }
            if (CasHelper.isEmpty((Object)e_discountamt)) {
                e_discountamt = BigDecimal.ZERO;
            }
            if (CasHelper.isEmpty((Object)e_unlockamt)) {
                e_unlockamt = BigDecimal.ZERO;
            }
            BigDecimal actamt = this.getBigDecimalProp("actamt");
            BigDecimal fee = this.getBigDecimalProp("fee");
            BigDecimal discountamt = this.getBigDecimalProp("discountamt");
            if (e_fee.compareTo(fee) < 0 || e_discountamt.compareTo(discountamt) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e05\u5206\u7684\u624b\u7eed\u8d39\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6240\u9009\u5206\u5f55\u884c\u7684\u624b\u7eed\u8d39\uff0c\u6e05\u5206\u7684\u73b0\u91d1\u6298\u6263\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6240\u9009\u5206\u5f55\u884c\u7684\u73b0\u91d1\u6298\u6263\u3002", (String)"RecOrgsDividePlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (e_unlockamt.compareTo(actamt.add(fee).add(discountamt)) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e05\u5206\u7684\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u201c\u6240\u9009\u5206\u5f55\u884c\u7684\u672a\u9501\u5b9a\u91d1\u989d-\u73b0\u91d1\u6298\u6263-\u624b\u7eed\u8d39\u201d\u3002", (String)"RecOrgsDividePlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (actamt.compareTo(BigDecimal.ZERO) < 0 || fee.compareTo(BigDecimal.ZERO) < 0 || discountamt.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u586b\u5199\u7684\u91d1\u989d\u662f\u5426\u4e3a\u6b63\u6570\u3002", (String)"RecOrgsDividePlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal e_actamt = (BigDecimal)recData.get("e_actamt");
            if (actamt.compareTo(e_actamt) >= 0 && (e_discountamt.compareTo(discountamt) != 0 || e_fee.compareTo(fee) != 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u6709\u5b9e\u6536\u91d1\u989d\u989d\u5ea6\u5df2\u7ecf\u6e05\u5206\u5b8c\u6bd5\uff0c\u8bf7\u8865\u5145\u73b0\u91d1\u6298\u6263\u548c\u624b\u7eed\u8d39\u3002", (String)"RecOrgsDividePlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> parentData = new HashMap<String, Object>();
            IDataModel model = this.getModel();
            parentData.put("discountamt", discountamt);
            parentData.put("fee", fee);
            parentData.put("remark", model.getValue("remark"));
            parentData.put("actamt", actamt);
            parentData.put("receivableamt", model.getValue("receivableamt"));
            parentData.put("settleorg", model.getValue("settleorg"));
            parentData.put("fundflowitem", model.getValue("fundflowitem"));
            Object uuid = recData.get("uuid");
            if (CasHelper.isEmpty(uuid)) {
                uuid = this.generateUUIDShort();
            }
            parentData.put("uuid", uuid);
            this.getView().returnDataToParent(parentData);
            this.getView().close();
        }
    }

    private BigDecimal getBigDecimalProp(String prop) {
        BigDecimal value = (BigDecimal)this.getModel().getValue(prop);
        if (CasHelper.isEmpty((Object)value)) {
            value = BigDecimal.ZERO;
        }
        return value;
    }

    private void getnReceivableamt() {
        BigDecimal actamt = this.getBigDecimalProp("actamt");
        BigDecimal discountamt = this.getBigDecimalProp("discountamt");
        BigDecimal fee = this.getBigDecimalProp("fee");
        this.getModel().setValue("receivableamt", (Object)actamt.add(discountamt).add(fee));
    }

    private String generateUUIDShort() {
        String currTime = DateUtils.formatString((Date)new Date(), (String)"yyyyMMddHHmmss");
        return "src" + currTime + UUID.randomUUID().toString().replace("-", "").substring(0, 10);
    }

    private BigDecimal getDivideAmount(BigDecimal total, BigDecimal actm, BigDecimal dividedMount) {
        BigDecimal divide = actm.divide(total, 6, 4).multiply(dividedMount).setScale(4, 4);
        return divide;
    }

    private String getFeeTip() {
        return ResManager.loadKDString((String)"\u5982\u672a\u6307\u5b9a\u6e05\u5206\u624b\u7eed\u8d39\uff0c\u5c06\u6839\u636e\u6e05\u5206\u7684\u5b9e\u6536\u91d1\u989d\u6309\u6bd4\u4f8b\u62c6\u5206\u539f\u624b\u7eed\u8d39\uff08\u5982\u6709\uff09\u3002", (String)"RecOrgsDividePlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
    }

    private String getDiscountTip() {
        return ResManager.loadKDString((String)"\u5982\u672a\u6307\u5b9a\u6e05\u5206\u73b0\u91d1\u6298\u6263\uff0c\u5c06\u6839\u636e\u6e05\u5206\u7684\u5b9e\u6536\u91d1\u989d\u6309\u6bd4\u4f8b\u62c6\u5206\u539f\u73b0\u91d1\u6298\u6263\uff08\u5982\u6709\uff09\u3002", (String)"RecOrgsDividePlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
    }
}

