/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recsupdivide;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.enums.CoreBillTypeEnum;
import kd.fi.cas.enums.RecAmtTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class RecSupContractPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"corebillno"});
    }

    public void beforeBindData(EventObject e) {
        boolean writeActAmt;
        Object currency;
        super.beforeBindData(e);
        Object formPOJO = this.getView().getFormShowParameter().getCustomParam("formPOJO");
        Map recData = (Map)JSON.parseObject((String)formPOJO.toString(), Map.class);
        if (CasHelper.isEmpty((Object)recData)) {
            return;
        }
        Object e_remark = recData.get("e_remark");
        Object e_fundflowitem = recData.get("e_fundflowitem");
        this.getModel().setValue("fundflowitem", e_fundflowitem);
        if (CasHelper.isNotEmpty(e_remark)) {
            this.getModel().setValue("remark", e_remark);
        }
        if (CasHelper.isNotEmpty(currency = recData.get("currency"))) {
            this.getModel().setValue("currency", currency);
        }
        if (writeActAmt = this.isWriteActAmt(recData)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"actamt"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"receivableamt"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"receivableamt"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"actamt"});
        }
        AmountEdit fee = (AmountEdit)this.getControl("fee");
        fee.addTips(new Tips("text", null, new LocaleString(String.format(this.getFeeTip(), writeActAmt ? ResManager.loadKDString((String)"\u5b9e\u6536\u91d1\u989d", (String)"RecSupContractPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"RecSupContractPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]))), false, null));
        AmountEdit discountamt = (AmountEdit)this.getControl("discountamt");
        discountamt.addTips(new Tips("text", null, new LocaleString(String.format(this.getDiscountTip(), writeActAmt ? ResManager.loadKDString((String)"\u5b9e\u6536\u91d1\u989d", (String)"RecSupContractPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"RecSupContractPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]))), false, null));
    }

    private boolean isWriteActAmt(Map<String, Object> recData) {
        Object org = recData.get("org");
        String orgId = String.valueOf(org);
        if (EmptyUtil.isEmpty((Object)org) || "0".equals(orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecSupContractPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        int cs117 = SystemParameterHelper.getParameterInteger((long)Long.parseLong(orgId), (String)"cs117");
        return RecAmtTypeEnum.ACTAMT.getValue().equals(String.valueOf(cs117));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty iDataEntityProperty = e.getProperty();
        String propertyName = iDataEntityProperty.getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object formPOJO = this.getView().getFormShowParameter().getCustomParam("formPOJO");
        Map recData = (Map)JSON.parseObject((String)formPOJO.toString(), Map.class);
        BigDecimal e_receivableamt = (BigDecimal)recData.get("e_receivableamt");
        BigDecimal e_actamt = (BigDecimal)recData.get("e_actamt");
        BigDecimal e_fee = (BigDecimal)recData.get("e_fee");
        BigDecimal e_discountamt = (BigDecimal)recData.get("e_discountamt");
        switch (propertyName) {
            case "corebilltype": {
                this.getModel().setValue("corebillno", null);
                break;
            }
            case "discountamt": {
                BigDecimal newValue = (BigDecimal)changeSet[0].getNewValue();
                if (CasHelper.isEmpty((Object)e_discountamt)) {
                    e_discountamt = BigDecimal.ZERO;
                }
                if (CasHelper.isNotEmpty((Object)newValue) && newValue.compareTo(e_discountamt) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8865\u5145\u5408\u540c\u53f7\u6298\u6263\u4e0d\u80fd\u5927\u4e8e\u53ef\u62c6\u5206\u7684\u6298\u6263", (String)"RecSupContractPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("discountamt", (Object)0);
                    return;
                }
                if (this.isWriteActAmt(recData)) {
                    this.getreceivableamt();
                    break;
                }
                this.getnActamt();
                break;
            }
            case "fee": {
                BigDecimal newFeeValue;
                if (CasHelper.isEmpty((Object)e_fee)) {
                    e_fee = BigDecimal.ZERO;
                }
                if (CasHelper.isNotEmpty((Object)(newFeeValue = (BigDecimal)changeSet[0].getNewValue())) && newFeeValue.compareTo(e_fee) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8865\u5145\u5408\u540c\u53f7\u624b\u7eed\u8d39\u4e0d\u80fd\u5927\u4e8e\u53ef\u62c6\u5206\u7684\u624b\u7eed\u8d39\u3002", (String)"RecSupContractPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("fee", (Object)0);
                    return;
                }
                if (this.isWriteActAmt(recData)) {
                    this.getreceivableamt();
                    break;
                }
                this.getnActamt();
                break;
            }
            case "receivableamt": {
                if (!this.isWriteActAmt(recData) && CasHelper.isNotEmpty((Object)e_receivableamt)) {
                    BigDecimal divideAmount;
                    BigDecimal receivableamt = this.getBigDecimalProp("receivableamt");
                    if (CasHelper.isNotEmpty((Object)e_fee)) {
                        divideAmount = this.getDivideAmount(e_receivableamt, receivableamt, e_fee);
                        this.getModel().setValue("fee", (Object)divideAmount);
                    }
                    if (CasHelper.isNotEmpty((Object)e_discountamt)) {
                        divideAmount = this.getDivideAmount(e_receivableamt, receivableamt, e_discountamt);
                        this.getModel().setValue("discountamt", (Object)divideAmount);
                    }
                }
                this.getnActamt();
                break;
            }
            case "actamt": {
                if (this.isWriteActAmt(recData) && e_actamt != null) {
                    BigDecimal divideAmount;
                    BigDecimal actamt = this.getBigDecimalProp("actamt");
                    if (CasHelper.isNotEmpty((Object)e_fee)) {
                        divideAmount = this.getDivideAmount(e_actamt, actamt, e_fee);
                        this.getModel().setValue("fee", (Object)divideAmount);
                    }
                    if (CasHelper.isNotEmpty((Object)e_discountamt)) {
                        divideAmount = this.getDivideAmount(e_actamt, actamt, e_discountamt);
                        this.getModel().setValue("discountamt", (Object)divideAmount);
                    }
                }
                this.getreceivableamt();
            }
        }
    }

    private BigDecimal getDivideAmount(BigDecimal total, BigDecimal actm, BigDecimal dividedMount) {
        BigDecimal divide = actm.divide(total, 6, 4).multiply(dividedMount).setScale(4, 4);
        return divide;
    }

    private void getnActamt() {
        BigDecimal receivableamt = this.getBigDecimalProp("receivableamt");
        BigDecimal discountamt = this.getBigDecimalProp("discountamt");
        BigDecimal fee = this.getBigDecimalProp("fee");
        this.getModel().setValue("actamt", (Object)receivableamt.subtract(discountamt).subtract(fee));
    }

    private void getreceivableamt() {
        BigDecimal actamt = this.getBigDecimalProp("actamt");
        BigDecimal discountamt = this.getBigDecimalProp("discountamt");
        BigDecimal fee = this.getBigDecimalProp("fee");
        this.getModel().setValue("receivableamt", (Object)actamt.add(discountamt).add(fee));
    }

    private BigDecimal getBigDecimalProp(String prop) {
        BigDecimal value = (BigDecimal)this.getModel().getValue(prop);
        if (CasHelper.isEmpty((Object)value)) {
            value = BigDecimal.ZERO;
        }
        return value;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)"corebillno", (CharSequence)key)) {
            this.showCoreBillF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("e_corebillno".equals(e.getActionId()) && CasHelper.isNotEmpty((Object)e.getReturnData())) {
            ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)e.getReturnData();
            IDataModel model = this.getModel();
            model.setValue("corebillno", (Object)coreBillCollection.get(0).getBillNo());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("btnok".equals(operateKey) && opResult.isSuccess()) {
            BigDecimal actamt;
            IDataModel model = this.getModel();
            Object contractnumber = model.getValue("contractnumber");
            Object corebillno = model.getValue("corebillno");
            Object formPOJO = this.getView().getFormShowParameter().getCustomParam("formPOJO");
            Map recData = (Map)JSON.parseObject((String)formPOJO.toString(), Map.class);
            if (CasHelper.isEmpty((Object)recData)) {
                return;
            }
            if (CasHelper.isEmpty((Object)contractnumber) && CasHelper.isEmpty((Object)corebillno)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5408\u540c\u53f7\u201d\u6216\u201c\u6838\u5fc3\u5355\u636e\u53f7\u201d\u4e24\u8005\u5176\u4e00\u5fc5\u586b,\u8bf7\u68c0\u67e5\u3002", (String)"RecSupContractPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal e_unlockamt = (BigDecimal)recData.get("e_unlockamt");
            BigDecimal receivableamt = (BigDecimal)model.getValue("receivableamt");
            if (CasHelper.isEmpty((Object)e_unlockamt) || CasHelper.isEmpty((Object)receivableamt) || receivableamt.compareTo(e_unlockamt) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u5206\u5f55\u884c\u7684\u672a\u9501\u5b9a\u91d1\u989d\u3002", (String)"RecSupContractPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object sourceId = null;
            String corebilltype = (String)model.getValue("corebilltype");
            if (CasHelper.isNotEmpty((Object)corebillno) && !CoreBillTypeEnum.CONTRACT.getValue().equals(corebilltype)) {
                if (StringUtils.isEmpty((CharSequence)corebilltype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b", (String)"RecSupContractPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter billnoQf = new QFilter("billno", "=", (Object)String.valueOf(corebillno));
                DynamicObject[] ids = BusinessDataServiceHelper.load((String)corebilltype, (String)"id", (QFilter[])new QFilter[]{billnoQf});
                if (ids.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u7c7b\u578b\u7684\u201c\u6838\u5fc3\u5355\u636e\u53f7\u201d\u672a\u627e\u5230,\u8bf7\u68c0\u67e5\u3002", (String)"RecSupContractPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                sourceId = ids[0].getPkValue();
            }
            BigDecimal e_fee = (BigDecimal)recData.get("e_fee");
            BigDecimal e_discountamt = (BigDecimal)recData.get("e_discountamt");
            BigDecimal fee = (BigDecimal)model.getValue("fee");
            BigDecimal discountamt = (BigDecimal)model.getValue("discountamt");
            if (CasHelper.isEmpty((Object)e_fee)) {
                e_fee = BigDecimal.ZERO;
            }
            if (CasHelper.isEmpty((Object)e_discountamt)) {
                e_discountamt = BigDecimal.ZERO;
            }
            if (CasHelper.isEmpty((Object)fee)) {
                fee = BigDecimal.ZERO;
            }
            if (CasHelper.isEmpty((Object)discountamt)) {
                discountamt = BigDecimal.ZERO;
            }
            if ((actamt = receivableamt.subtract(fee).subtract(discountamt)).compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e\u73b0\u91d1\u6298\u6263\u52a0\u624b\u7eed\u8d39\u7684\u603b\u548c\u3002", (String)"RecSupContractPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal e_actamt = (BigDecimal)recData.get("e_actamt");
            if (actamt.compareTo(e_actamt) >= 0 && (e_discountamt.compareTo(discountamt) != 0 || e_fee.compareTo(fee) != 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u6709\u5b9e\u6536\u91d1\u989d\u989d\u5ea6\u5df2\u7ecf\u8865\u5145\u5b8c\u6bd5,\u8bf7\u628a\u73b0\u91d1\u6298\u6263\u548c\u624b\u7eed\u8d39\u4e00\u5e76\u8865\u5145\u5b8c\u6bd5", (String)"RecSupContractPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (e_fee.compareTo(fee) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8865\u5145\u5408\u540c\u53f7\u624b\u7eed\u8d39\u4e0d\u80fd\u5927\u4e8e\u53ef\u62c6\u5206\u7684\u624b\u7eed\u8d39\u3002", (String)"RecSupContractPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            e_fee = e_fee.subtract(fee);
            if (e_discountamt.compareTo(discountamt) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8865\u5145\u5408\u540c\u53f7\u6298\u6263\u4e0d\u80fd\u5927\u4e8e\u53ef\u62c6\u5206\u7684\u6298\u6263\u3002", (String)"RecSupContractPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            e_discountamt = e_discountamt.subtract(discountamt);
            if (receivableamt.compareTo(BigDecimal.ZERO) < 0 || fee.compareTo(BigDecimal.ZERO) < 0 || discountamt.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u586b\u5199\u7684\u91d1\u989d\u662f\u5426\u4e3a\u6b63\u6570\u3002", (String)"RecSupContractPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> parentData = new HashMap<String, Object>();
            parentData.put("e_discountamt", e_discountamt);
            parentData.put("e_fee", e_fee);
            parentData.put("discountamt", discountamt);
            parentData.put("fee", fee);
            parentData.put("contractnumber", contractnumber);
            parentData.put("corebilltype", model.getValue("corebilltype"));
            parentData.put("corebillno", corebillno);
            parentData.put("corebillentryseq", model.getValue("corebillentryseq"));
            parentData.put("receivableamt", receivableamt);
            parentData.put("remark", model.getValue("remark"));
            parentData.put("actamt", actamt);
            parentData.put("e_sourcebillid", sourceId);
            parentData.put("fundflowitem", model.getValue("fundflowitem"));
            parentData.put("isWriteActAmt", this.isWriteActAmt(recData));
            Object uuid = recData.get("uuid");
            if (CasHelper.isEmpty(uuid)) {
                uuid = this.generateUUIDShort();
            }
            parentData.put("uuid", uuid);
            this.getView().returnDataToParent(parentData);
            this.getView().close();
        }
    }

    private String generateUUIDShort() {
        String currTime = DateUtils.formatString((Date)new Date(), (String)"yyyyMMddHHmmss");
        return currTime + UUID.randomUUID().toString().replace("-", "").substring(0, 10);
    }

    private void showCoreBillF7() {
        String corebilltype = (String)this.getModel().getValue("corebilltype");
        if (StringUtils.isEmpty((CharSequence)corebilltype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"RecSupContractPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isEmpty((String)ClaimCoreBillTypeEnum.getName((String)corebilltype))) {
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)corebilltype, (boolean)false, (int)2);
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "e_corebillno");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private String getFeeTip() {
        return ResManager.loadKDString((String)"\u5982\u672a\u6307\u5b9a\u6e05\u5206\u624b\u7eed\u8d39\uff0c\u5c06\u6839\u636e\u6e05\u5206\u7684\u5b9e\u6536\u91d1\u989d\u6309\u6bd4\u4f8b\u62c6\u5206\u539f\u624b\u7eed\u8d39\uff08\u5982\u6709\uff09\u3002", (String)"RecOrgsDividePlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
    }

    private String getDiscountTip() {
        return ResManager.loadKDString((String)"\u5982\u672a\u6307\u5b9a\u6e05\u5206\u73b0\u91d1\u6298\u6263\uff0c\u5c06\u6839\u636e\u6e05\u5206\u7684\u5b9e\u6536\u91d1\u989d\u6309\u6bd4\u4f8b\u62c6\u5206\u539f\u73b0\u91d1\u6298\u6263\uff08\u5982\u6709\uff09\u3002", (String)"RecOrgsDividePlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
    }
}

