/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.refund;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.log.RefundLogExecutor;
import org.apache.commons.lang3.StringUtils;

public class RefundRenoteOkBtnPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String CONFIRM_REFUND_RENOTE_CALLBACK = "CONFIRM_REFUND_RENOTE_CALLBACK";
    private static final String CONFIRM_DIFFERENT_SOURCE = "CONFIRM_DIFFERENT_SOURCE";
    private static final String CONFIRM_DIFFERENT_SETTLETYPE = "CONFIRM_DIFFERENT_SETTLETYPE";
    private RefundLogExecutor refundLogExecutor;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (BTN_OK.equals(source.getKey())) {
            if (!this.checkBeforeOperate()) {
                return;
            }
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String operateKey = (String)showParameter.getCustomParam("operateKey");
            String tips = "renote".equals(operateKey) ? ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u9000\u7968\uff1f", (String)"PaymentBillEdit_23_1", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u9000\u6b3e\uff1f", (String)"PaymentBillEdit_23_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_REFUND_RENOTE_CALLBACK, (IFormPlugin)this));
        }
    }

    private boolean checkBeforeOperate() {
        BigDecimal currentAmtSum;
        String releBillType = (String)this.getModel().getValue("relebilltype");
        DynamicObjectCollection reList = this.getModel().getEntryEntity("relebilllist");
        if (CollectionUtils.isEmpty((Collection)reList)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u5355\u636e\u3002", (String)"RefundRenoteOkBtnPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        BigDecimal refundableamt = (BigDecimal)this.getModel().getValue("refundableamt");
        if (refundableamt.compareTo(currentAmtSum = reList.stream().map(e -> e.getBigDecimal("currentrefundamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)) != 0) {
            String msg = ResManager.loadKDString((String)"\u672c\u6b21\u9000\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u53ef\u9000\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"RefundRenoteOkBtnPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        if (!"cas_paybill".equals(releBillType) && !"cas_agentpaybill".equals(releBillType)) {
            return true;
        }
        Map<Long, Boolean> payBillIsDiffer = null;
        if ("cas_paybill".equals(releBillType)) {
            Set payIds = reList.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection payBills = QueryServiceHelper.query((String)releBillType, (String)"id,isdiffcur", (QFilter[])new QFilter("id", "in", payIds).toArray());
            payBillIsDiffer = payBills.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getBoolean("isdiffcur")));
        }
        boolean releWithInfo = (Boolean)this.getModel().getValue("relewithinfo");
        for (DynamicObject rele : reList) {
            BigDecimal remainrefundamt;
            BigDecimal curReAmt = rele.getBigDecimal("currentrefundamt");
            BigDecimal bigDecimal = remainrefundamt = releWithInfo ? rele.getBigDecimal("remainrefundamt") : rele.getBigDecimal("totalremainrefundamt");
            if (curReAmt.compareTo(BigDecimal.ZERO) > 0 && remainrefundamt.compareTo(BigDecimal.ZERO) < 0 || curReAmt.compareTo(BigDecimal.ZERO) < 0 && remainrefundamt.compareTo(BigDecimal.ZERO) > 0) {
                String msg = ResManager.loadKDString((String)"\u672c\u6b21\u9000\u91d1\u989d\u5fc5\u987b\u4e0e\u5176\u5bf9\u5e94\u5355\u636e\u6216\u5bf9\u5e94\u660e\u7ec6\u884c\u5269\u4f59\u53ef\u9000\u91d1\u989d\u65b9\u5411\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"RefundRenoteOkBtnPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return false;
            }
            if (curReAmt.abs().compareTo(remainrefundamt.abs()) <= 0 || payBillIsDiffer != null && payBillIsDiffer.getOrDefault(rele.getLong("id"), false).booleanValue()) continue;
            String msg = ResManager.loadKDString((String)"\u672c\u6b21\u9000\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5bf9\u5e94\u5355\u636e\u6216\u5bf9\u5e94\u660e\u7ec6\u884c\u5269\u4f59\u53ef\u9000\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"RefundRenoteOkBtnPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        if (!MessageBoxResult.Yes.equals((Object)closedEvent.getResult())) {
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String operateKey = (String)showParameter.getCustomParam("operateKey");
        DynamicObjectCollection reList = this.getModel().getEntryEntity("relebilllist");
        String releBillType = (String)this.getModel().getValue("relebilltype");
        if (CONFIRM_REFUND_RENOTE_CALLBACK.equals(closedEvent.getCallBackId())) {
            if ("cas_paybill".equals(releBillType) || "cas_agentpaybill".equals(releBillType)) {
                if (!this.checkSameSourceBillType(reList, releBillType)) {
                    return;
                }
                if (!this.checkSameSettlementType(reList, releBillType)) {
                    return;
                }
            }
            this.invokeOperate(operateKey);
        } else if (CONFIRM_DIFFERENT_SOURCE.equals(closedEvent.getCallBackId())) {
            if (!this.checkSameSettlementType(reList, releBillType)) {
                return;
            }
            this.invokeOperate(operateKey);
        } else if (CONFIRM_DIFFERENT_SETTLETYPE.equals(closedEvent.getCallBackId())) {
            this.invokeOperate(operateKey);
        }
    }

    private boolean checkSameSettlementType(DynamicObjectCollection reList, String releBillType) {
        DynamicObject settletype = (DynamicObject)this.getModel().getValue("settletype", 0);
        for (DynamicObject rele : reList) {
            String releSettleType;
            String receivingSettleType = settletype.getString("settlementtype");
            if (StringUtils.equals((CharSequence)receivingSettleType, (CharSequence)(releSettleType = rele.getString("relesettletype.settlementtype")))) continue;
            String tips = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b=[%1$s]\uff0c\u5173\u8054\u7684%2$s\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b=[%3$s]\uff0c\u4e8c\u8005\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RefundRenoteOkBtnPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            MainEntityType settlementType = EntityMetadataCache.getDataEntityType((String)"bd_settlementtype");
            ComboProp settlementTypeProp = (ComboProp)settlementType.getProperty("settlementtype");
            ComboProp releBillEntityType = (ComboProp)this.getModel().getProperty("relebilltype");
            this.getView().showConfirm(String.format(tips, settlementTypeProp.getItemByName(receivingSettleType), releBillEntityType.getItemByName(releBillType), settlementTypeProp.getItemByName(releSettleType)), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_DIFFERENT_SETTLETYPE, (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private boolean checkSameSourceBillType(DynamicObjectCollection reList, String releBillType) {
        Object[] ids = reList.stream().map(r -> r.getLong("id")).toArray();
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)releBillType, (String)"billno,sourcebilltype", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        Map sourceTypeMap = Arrays.stream(bills).collect(Collectors.groupingBy(b -> b.getString("sourcebilltype"), LinkedHashMap::new, Collectors.toList()));
        if (sourceTypeMap.size() > 1) {
            String msg = ResManager.loadKDString((String)"[%1$s][%2$s]\u7684\u6e90\u5355\u7c7b\u578b\u662f[%3$s];", (String)"RefundRenoteOkBtnPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            ComboProp releBillEntityType = (ComboProp)this.getModel().getProperty("relebilltype");
            ComboProp sourceBillTypeComb = (ComboProp)EntityMetadataCache.getDataEntityType((String)releBillType).getProperty("sourcebilltype");
            StringBuilder msgBuilder = new StringBuilder();
            for (Map.Entry e : sourceTypeMap.entrySet()) {
                String sourceBillName = sourceBillTypeComb.getItemByName((String)e.getKey());
                sourceBillName = (String)StringUtils.defaultIfEmpty((CharSequence)sourceBillName, (CharSequence)((CharSequence)e.getKey()));
                List billList = (List)e.getValue();
                for (DynamicObject bill : billList) {
                    String subMsg = String.format(msg, releBillEntityType.getItemByName(releBillType), bill.getString("billno"), sourceBillName);
                    msgBuilder.append(subMsg).append("\r\n");
                }
            }
            String tips = ResManager.loadKDString((String)"%s\u6765\u6e90\u4e0d\u540c\u7684\u591a\u7b14\u652f\u4ed8\u5355\u636e\u73b0\u5728\u8981\u5173\u8054\u4e00\u7b14\u6536\u6b3e\u505a\u9000\u6b3e\u9000\u7968\u5904\u7406\uff0c\u8bf7\u4ed4\u7ec6\u786e\u8ba4\u4ee5\u4e0a\u5355\u636e\u662f\u5426\u5747\u4e3a\u5b9e\u9645\u8981\u64cd\u4f5c\u9000\u6b3e\u9000\u7968\u7684\u5355\u636e\uff1f", (String)"RefundRenoteOkBtnPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(String.format(tips, msgBuilder), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_DIFFERENT_SOURCE, (IFormPlugin)this));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("refundrenote".equals(operate.getOperateKey())) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String operateKey = (String)showParameter.getCustomParam("operateKey");
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            this.refundLogExecutor = new RefundLogExecutor(dataEntity, operateKey);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        AbstractOperate op = (AbstractOperate)arg.getSource();
        if ("refundrenote".equals(op.getOperateKey())) {
            OperationResult opResult = arg.getOperationResult();
            boolean success = opResult.isSuccess();
            if (this.refundLogExecutor != null) {
                this.refundLogExecutor.saveLog(opResult);
            }
        }
    }

    private void invokeOperate(String operateKey) {
        String releBillType = (String)this.getModel().getValue("relebilltype");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("operateKey", operateKey);
        if ("cas_paybill".equals(releBillType) || "cas_agentpaybill".equals(releBillType)) {
            this.getView().invokeOperation("refundrenote", operateOption);
        } else if ("ifm_transhandlebill".equals(releBillType)) {
            String operation = "refund".equals(operateKey) ? "ifm_refund" : "ifm_renote";
            this.getView().invokeOperation(operation, operateOption);
        }
    }
}

